/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/* The source code in this module is proprietary software belonging to       */
/* Clark Development Company and is part of the PCBoard source code library. */
/* You are granted the right to use this source code for the building of any */
/* of the PCBoard products you have licensed.  Any other usage is forbidden  */
/* without prior written consent from Clark Development Company, Inc.        */
/*                                                                           */
/* Be sure to read the source code license agreement before utilizing any    */
/* of the source code found herein.                                          */
/*                                                                           */
/* Copyright (C) 1996  Clark Development Company, Inc.  All Rights Reserved. */
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/


#include "xmodem.h"

static unsigned short CrcTable[] = {
  0x00000, 0x01021, 0x02042, 0x03063, 0x04084, 0x050A5, 0x060C6, 0x070E7,
  0x08108, 0x09129, 0x0A14A, 0x0B16B, 0x0C18C, 0x0D1AD, 0x0E1CE, 0x0F1EF,
  0x01231, 0x00210, 0x03273, 0x02252, 0x052B5, 0x04294, 0x072F7, 0x062D6,
  0x09339, 0x08318, 0x0B37B, 0x0A35A, 0x0D3BD, 0x0C39C, 0x0F3FF, 0x0E3DE,
  0x02462, 0x03443, 0x00420, 0x01401, 0x064E6, 0x074C7, 0x044A4, 0x05485,
  0x0A56A, 0x0B54B, 0x08528, 0x09509, 0x0E5EE, 0x0F5CF, 0x0C5AC, 0x0D58D,
  0x03653, 0x02672, 0x01611, 0x00630, 0x076D7, 0x066F6, 0x05695, 0x046B4,
  0x0B75B, 0x0A77A, 0x09719, 0x08738, 0x0F7DF, 0x0E7FE, 0x0D79D, 0x0C7BC,
  0x048C4, 0x058E5, 0x06886, 0x078A7, 0x00840, 0x01861, 0x02802, 0x03823,
  0x0C9CC, 0x0D9ED, 0x0E98E, 0x0F9AF, 0x08948, 0x09969, 0x0A90A, 0x0B92B,
  0x05AF5, 0x04AD4, 0x07AB7, 0x06A96, 0x01A71, 0x00A50, 0x03A33, 0x02A12,
  0x0DBFD, 0x0CBDC, 0x0FBBF, 0x0EB9E, 0x09B79, 0x08B58, 0x0BB3B, 0x0AB1A,
  0x06CA6, 0x07C87, 0x04CE4, 0x05CC5, 0x02C22, 0x03C03, 0x00C60, 0x01C41,
  0x0EDAE, 0x0FD8F, 0x0CDEC, 0x0DDCD, 0x0AD2A, 0x0BD0B, 0x08D68, 0x09D49,
  0x07E97, 0x06EB6, 0x05ED5, 0x04EF4, 0x03E13, 0x02E32, 0x01E51, 0x00E70,
  0x0FF9F, 0x0EFBE, 0x0DFDD, 0x0CFFC, 0x0BF1B, 0x0AF3A, 0x09F59, 0x08F78,
  0x09188, 0x081A9, 0x0B1CA, 0x0A1EB, 0x0D10C, 0x0C12D, 0x0F14E, 0x0E16F,
  0x01080, 0x000A1, 0x030C2, 0x020E3, 0x05004, 0x04025, 0x07046, 0x06067,
  0x083B9, 0x09398, 0x0A3FB, 0x0B3DA, 0x0C33D, 0x0D31C, 0x0E37F, 0x0F35E,
  0x002B1, 0x01290, 0x022F3, 0x032D2, 0x04235, 0x05214, 0x06277, 0x07256,
  0x0B5EA, 0x0A5CB, 0x095A8, 0x08589, 0x0F56E, 0x0E54F, 0x0D52C, 0x0C50D,
  0x034E2, 0x024C3, 0x014A0, 0x00481, 0x07466, 0x06447, 0x05424, 0x04405,
  0x0A7DB, 0x0B7FA, 0x08799, 0x097B8, 0x0E75F, 0x0F77E, 0x0C71D, 0x0D73C,
  0x026D3, 0x036F2, 0x00691, 0x016B0, 0x06657, 0x07676, 0x04615, 0x05634,
  0x0D94C, 0x0C96D, 0x0F90E, 0x0E92F, 0x099C8, 0x089E9, 0x0B98A, 0x0A9AB,
  0x05844, 0x04865, 0x07806, 0x06827, 0x018C0, 0x008E1, 0x03882, 0x028A3,
  0x0CB7D, 0x0DB5C, 0x0EB3F, 0x0FB1E, 0x08BF9, 0x09BD8, 0x0ABBB, 0x0BB9A,
  0x04A75, 0x05A54, 0x06A37, 0x07A16, 0x00AF1, 0x01AD0, 0x02AB3, 0x03A92,
  0x0FD2E, 0x0ED0F, 0x0DD6C, 0x0CD4D, 0x0BDAA, 0x0AD8B, 0x09DE8, 0x08DC9,
  0x07C26, 0x06C07, 0x05C64, 0x04C45, 0x03CA2, 0x02C83, 0x01CE0, 0x00CC1,
  0x0EF1F, 0x0FF3E, 0x0CF5D, 0x0DF7C, 0x0AF9B, 0x0BFBA, 0x08FD9, 0x09FF8,
  0x06E17, 0x07E36, 0x04E55, 0x05E74, 0x02E93, 0x03EB2, 0x00ED1, 0x01EF0
};


unsigned short LIBENTRY xmodemcrc(char *Str, int Len) {
  unsigned short Crc;

//for (Crc = 0; Len; Len--, Str++)
//  Crc ^= CrcTable[*Str];

  unsigned char Save;

  for (Crc = 0, Save = 0; Len; Len--, Str++) {
    Save = (unsigned char) ((Crc & 0xFF00) >> 8);
    Crc = (((Crc & 0x00FF) << 8) + *Str) ^ CrcTable[Save];
  }

  return(Crc);
}


unsigned char LIBENTRY xmodemchecksum(char *Str, int Len) {
  unsigned char CheckSum;

  for (CheckSum = 0; Len; Len--, Str++)
    CheckSum += (char) *Str;

  return(CheckSum);
}
