;
; Changes made by Scott McNay (1:395/11) July 26, 1992, to allow routine to be
; used with code compiled with BC's /Fs option.  (Most) changes marked with
; ;BCFS0726.  May have optimized some code also.  This is a plug-in replacement
; for the original code.
;

;BCFS0801: Standardized code format.  Made sure that DI, SI, BP, and DS are
;  saved to meet requirements of BC 7.x.

	 Extrn  StringAddress:far					      ;BCFS0726

CSEG	SEGMENT BYTE PUBLIC 'CODE'
	ASSUME  CS:CSEG,DS:CSEG,ES:CSEG,SS:CSEG
	PUBLIC  LPLKIT
	PUBLIC  LOKIT
	PUBLIC  UNLOKIT
LOOPLCK	EQU	0
NETLOCK	EQU	1
UNLOCK	EQU	2
DRIVE	DB	?		; INPUT DRIVE NUMBER
REQUEST	DB	?		; TYPE OF REQUEST
LENLOK	DW	?		; LENGTH OF LOCK NAME
POINTER	DW	?		; POINTER TO LOCK NAME
LCKNAME	DB	64 DUP(?)	; INPUT LOCK NAME
NEWNAME	DB	'\'		; REBUILT LOCK NAME WITH PATH
CURPATH	EQU	$		; CURRENT PATH FOR INPUT DRIVE
	DB	64 DUP(?)	; REBUILT LOCK NAME WITH PATH
LENPATH	EQU	$-CURPATH

LPLKIT	PROC	FAR
	MOV	CS:REQUEST,LOOPLCK
	JMP	PROCESS
LPLKIT	ENDP

LOKIT	PROC	FAR
	MOV	CS:REQUEST,NETLOCK
	JMP	PROCESS
LOKIT	ENDP

UNLOKIT	PROC	FAR
	MOV	CS:REQUEST,UNLOCK

PROCESS:
INT	3	;For debugging.  Remove when operation verified
	PUSH	BP		; SAVE BP
	MOV	BP,SP		; SAVE SP INTO BP FOR PARM ADDRESSING
	PUSH	DS		; SAVE BASIC'S DATA SEGMENT
	PUSH	ES		; SAVE BASIC'S EXTRA SEGMENT
	PUSH	DI							      ;BCFS0801
	PUSH	SI							      ;BCFS0801
	MOV	BX,[BP+10]	; GET ADDRESS OF DRIVE NUMBER
	MOV	AL,[BX]		; GET LOW ORDER BYTE OF DRIVE ADDRESS
	MOV	CS:DRIVE,AL	; SAVE THE DRIVE NUMBER
	PUSH	[BP+8]		; GET A$ STRING DESCRIPTOR ADDRESS	      ;BCFS0726
	CALL	StringAddress						      ;BCFS0726
	MOV	CS:LENLOK,CX	; GET LENGTH OF STRING A$ IN CX REGISTER      ;BCFS0726
	MOV	CS:POINTER,AX						      ;BCFS0726
	MOV	SI,AX		; OFFSET OF BASIC'S STRING		      ;BCFS0726
	MOV	DS,DX							      ;BCFS0726
	PUSH	CS		; MOV CS TO ES VIA STACK
	POP	ES		; TARGET IS IN OUR CSEG
	MOV	DI,OFFSET LCKNAME ; OFFSET OF WORK AREA
	CLD			; START FROM THE BOTTOM
	REP	MOVSB		; COPY BASIC'S STRING TO OUR WORK AREA
	PUSH	CS		; MOV CS TO DS VIA STACK
	POP	DS		; OUR CSEG SEGMENT INTO DS
	MOV	DI,OFFSET CURPATH ; ADDRESS OF AREA TO BLANK
	MOV	CX,LENPATH	; LENGTH OF AREA TO BLANK
	MOV	AL,' '		; A BLANK (NATURALLY)
	REP	STOSB		; BLANK THE AREA OUT
	MOV	SI,OFFSET CURPATH ; SET UP FOR CURRENT PATH CALL
	MOV	AH,47H		; ASK FOR CURRENT PATH
	MOV	DL,DRIVE	; REQUEST PATH FOR INDICATED DRIVE
	INC	DL		; 1 ORIGIN FOR PATH CALL
	INT	21H		; CALL DOS
	MOV	DI,OFFSET CURPATH ; START SCAN FOR ZERO BYTE AT START OF PATH
	CMP	BYTE PTR [DI],0	; SEE IF WE ARE IN THE BASE DIRECTORY
	JE	ROOT		; IF [DI]=0 THEN WE ARE IN THE BASE DIR
	MOV	CX,LENPATH	; ONLY GO FOR LENGTH OF PATH
	XOR	AL,AL		; SCANNING FOR THE 0 BYTE		      ;BCFS0801
	REPNE	SCASB		; SCAN THE STRING WHILE [DI] <> 00H
	DEC	DI
	MOV	BYTE PTR [DI],'\' ; PUT IN THE ENDING '\' BEFORE FILE NAME
	INC	DI		; DI NOW POINTS TO THE ENDING 0
ROOT:
	MOV	SI,OFFSET LCKNAME+2 ; START MOVE AFTER THE ':'
	MOV	CX,LENLOK	; LENGTH OF STRING
	DEC	CX		; MINUS 1
	DEC	CX		; MINUS 1
	REP	MOVSB		; COPY FILENAME AFTER PATH NAME
	MOV	DX,OFFSET NEWNAME ; POINT TO NEW NAME
	MOV	AX,WORD PTR DRIVE ; GET DRIVE FOR LOCK
	INT	67h		; CALL LOCK MANAGER
	POP	SI							      ;BCFS0801
	POP	DI							      ;BCFS0801
	POP	ES		; GET BACK BASIC'S EXTRA SEGMENT
	POP	DS		; GET BACK BASIC'S DATA SEGMENT
	MOV	DI,[BP+6]	; GET ADDRESS OF RESULT VARIABLE
	MOV	[DI],AL		; STORE RETURN CODE FROM LOCK MANAGER
	POP	BP
	RET	6
UNLOKIT	ENDP
CSEG	ENDS
	END
