{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : ARCHIVE.PAS                                                   
  Description: Archiver Miscellaneous Stuff                                  
  Version    : v0.1500                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B+,E+,F+,I+,L-,N-,O+,R-,S+,V-}
Unit Archive;

interface

uses
	crt, dos, overlay,
	myio,
	execbat,
	common;

procedure arcstuff(var ok,convt:boolean; var blks:integer; var convtime:real;
                   itest:boolean; fpath:astr; var fn,descr:astr);

procedure purgedir(s:astr);                {* erase all non-dir files in dir *}
function arcmci(src,fn,ifn:astr):astr;
procedure arcdecomp(var ok:boolean; atype:integer; fn,fspec:astr);
procedure arccomp(var ok:boolean; atype:integer; fn,fspec:astr);
procedure arccomment(var ok:boolean; atype,cnum:integer; fn:astr);
procedure arcintegritytest(var ok:boolean; atype:integer; fn:astr);
procedure conva(var ok:boolean; otype,ntype:integer; tdir,ofn,nfn:astr);
function arctype(s:astr):integer;
procedure listarctypes;
procedure invarc;
procedure doarccommand(cc:char);
procedure rezipstuff;

implementation

uses file0, file1, file2, file7, file9, file11,
     NewFile1;

const
	maxdoschrline=127;
var rezipcmd:string;

procedure arcstuff(var ok,convt:boolean;    { if ok - if converted }
									 var blks:integer;        { # blocks     }
									 var convtime:real;       { convert time }
                   itest:boolean;           { whether to test integrity }
                   fpath:astr;              { filepath     }
                   var fn:astr;             { filename     }
                   var descr:astr);         { description  }
var fi:file of byte;
		convtook,convstart,convend:datetimerec;
    oldnam,newnam,s,sig:astr;
    sttime:real;
		x,y,c:word;
    oldarc,newarc:integer;
begin
  {*  oldarc: current archive format, 0 if none
   *  newarc: desired archive format, 0 if none
   *  oldnam: current filename
	 *  newnam: desired archive format filename
   *}

	convtime:=0.0;
	ok:=TRUE;

	{Get original size and # of blocks}
	assign(fi,fpath+fn);
	{$I-} reset(fi); {$I+}
	if (ioresult<>0) then blks:=0
	else begin
		blks:=trunc((filesize(fi)+127.0)/128.0);
	end;
	if (filerec(fi).mode<>fmclosed) then close(fi);

	newarc:=memuboard.arctype;
	oldarc:=1;
	oldnam:=sqoutsp(fpath+fn);
	{Find what archive type it is}
	while (systat.filearcinfo[oldarc].ext<>'') and
				(systat.filearcinfo[oldarc].ext<>copy(fn,length(fn)-2,3)) and
				(oldarc<maxarcs+1) do
		inc(oldarc);
	if (oldarc=maxarcs+1) or
		 (systat.filearcinfo[oldarc].ext='') then oldarc:=0;
	if (not systat.filearcinfo[oldarc].active) then oldarc:=0;
	if (not systat.filearcinfo[newarc].active) then newarc:=0;
	if (newarc=0) then newarc:=oldarc;

	{* if both archive formats supported ... *}
	if ((oldarc<>0) and (newarc<>0)) then begin
	{* archive extension supported *}
		newnam:=fn;
		if (pos('.',newnam)<>0) then newnam:=copy(newnam,1,pos('.',newnam)-1);
		newnam:=sqoutsp(fpath+newnam+'.'+systat.filearcinfo[newarc].ext);
		{* if integrity tests supported ... *}
		if ((itest) and (systat.filearcinfo[oldarc].testline<>'')) then begin
      prfmsg('ARINTTST','');
			arcintegritytest(ok,oldarc,oldnam);
			if (not ok) then begin
				sysoplog(#3#8'>>>>'#3#5+' "'+oldnam+'" on #'+cstr(fileboard)+
								 ': Errors in integrity test');
        prfmsg('ARINTBAD','');
			end else
        prfmsg('ARINTOK','');
		end;

		{* if conversion required ... *}
		if ((ok) and (oldarc<>newarc) and (newarc<>0)) then begin
			convt:=incom;   {* don't convert if local and non-file-SysOp *}
			s:=systat.filearcinfo[newarc].ext;
			if (fso) then begin
				dyny:=TRUE;
        convt:=pynq(getmsg('ARCVTA2Q',s));
			end;
			if (convt) then begin
        prfmsg('ARCVTHDR','');

				getdatetime(convstart);
				conva(ok,oldarc,newarc,'tgtemp5.$$$',oldnam,newnam);
				getdatetime(convend);
				timediff(convtook,convstart,convend);
				convtime:=dt2r(convtook);

				if (ok) then begin
					assign(fi,fpath+fn);
					{$I-} erase(fi); {$I+}

					assign(fi,newnam);
					{$I-} reset(fi); {$I+}
					if (ioresult<>0) then ok:=FALSE
					else begin
						blks:=trunc((filesize(fi)+127.0)/128.0);
						close(fi);
						if (blks=0) then ok:=FALSE;
					end;
					fn:=align(stripname(newnam));
          prfmsg('ARCVTOK','');
				end else begin
					assign(fi,newnam);
					{$I-} erase(fi); {$I+}
					sysoplog(#3#8+'>>>>'#3#5+' "'+oldnam+'" on #'+
									 cstr(fileboard)+': Conversion unsuccessful');
          prfmsg('ARCVTBAD','');
					newarc:=oldarc;
				end;
				ok:=TRUE;
			end else
				newarc:=oldarc;
		end;

		{* if comment fields supported/desired ... *}
		if (ok) and (systat.filearcinfo[newarc].cmtline<>'') then begin
			s:=sqoutsp(fpath+fn);
			arccomment(ok,newarc,memuboard.cmttype,s);
			ok:=TRUE;
		end;
	end;
	fn:=sqoutsp(fn);

end;


procedure purgedir(s:astr);                {* erase all non-dir files in dir *}
var oldfn,fn,odir,odir2:astr;
    dirinfo:searchrec;
    fp:file;
    att:word;
		ubn,i:byte;
    nospace,ok,ahangup,fok,wenttosysop,convt:boolean;
    gotpts,blks,rn,pl:integer; convtime,tconvtime:real;
		f:ulfrec; v:verbrec;

begin
	if (pos(WorkPath+'2',s)=0) then begin
		s:=fexpand(s);
		while copy(s,length(s),1)='\' do s:=copy(s,1,length(s)-1);
		getdir(0,odir); getdir(exdrv(s),odir2);
		chdir(s);
		findfirst('*.*',AnyFile-Directory,dirinfo);
		while (doserror=0) do begin
			assign(fp,fexpand(dirinfo.name));
			setfattr(fp,$00);           {* remove possible read-only, etc, attributes *}
			{$I-} erase(fp); {$I+}      {* erase the $*@( file !!     *}
			findnext(dirinfo);          {* move on to the next one... *}
		end;
		chdir(odir2); chdir(odir);
	end else begin
		{Login - Checks for files in WORK/2 that were not processed}
		oldfn:='';
		findfirst(WorkPath+'2\*.*',anyfile-directory,dirinfo);
		while (doserror=0) do begin
			fn:=sqoutsp(dirinfo.name);
			if oldfn<>fn then oldfn:=fn else exit;
			ubn:=0;
			fiscan(pl);
			wenttosysop:=TRUE;
			f.filename:=fn;
			with f do begin
				description:='The User Hungup After Transfer';
				disknums[1]:=0;
				disknums[2]:=0;
				FileInfo:='';
				CrackGroup:='';
				reservedpassword:='';
				reservedstring:='';
				fileto:=0;
				for i:=1 to 4 do reserved[i]:=0;
				vpointer:=-1;
				v.descr[1]:='';
			end;
			fileboard:=systat.tosysopdir;
			fiscan(pl);
			arcstuff(ok,convt,blks,convtime,TRUE,WorkPath+'2\',fn,f.description);
			tconvtime:=tconvtime+convtime; f.blocks:=blks;
			doffstuff(f,fn,gotpts);
			fok:=TRUE;
			loaduboard(fileboard);

			if (ok) then begin {arc test OK}
				movefile(fok,nospace,FALSE,WorkPath+'2\'+fn,memuboard.dlpath+fn);
				if (fok) then begin
          prfmsg('ARABUPH','');
					newff(f,v);
					sysoplog(#3#3+'AUTO-Batch uploaded "'+sqoutsp(fn)+'" on '+memuboard.name);
				end else
					sysoplog(#3#3+'Error auto-batch uploading "'+sqoutsp(fn)+'" into directory');
			end else begin {archive test failed}
				if (f.blocks div 8>systat.minresume) then begin
          prfmsg('ARABUPHF','');
					movefile(fok,nospace,FALSE,WorkPath+'2\'+fn,memuboard.dlpath+fn);
					if (fok) then begin
						doffstuff(f,fn,gotpts);
						f.filestat:=f.filestat+[resumelater];
						newff(f,v);
					end else begin
						sysoplog(#3#3+'Error auto-batch uploading "'+sqoutsp(fn)+'" into directory');
					end;
				end;
				if (not (resumelater in f.filestat)) then begin
					assign(fp,WorkPath+'2\'+fn); erase(fp);
				end;
				sysoplog(#3#3+'Errors Batch Uploading "'+sqoutsp(fn)+'"');
			end;

			findnext(dirinfo);
		end;
	end;
end;

function arcmci(src,fn,ifn:astr):astr;
var i:byte;
begin
	src:=substall(src,'@F',stripspaces(fn));
	src:=substall(src,'@I',stripspaces(ifn));
	src:=substall(src,'@N',cstr(NodeNumber));
	src:=substall(src,'@P',cstr(modemr.ComPort));
	{9517 -- must be on-line to redirect..}
	if (incom) then src:=substall(src,'@R',modemr.RemoteRedir)
     else src:=substall(src,'@R','CON');
	arcmci:=src;
end;

procedure arcdecomp(var ok:boolean; atype:integer; fn,fspec:astr);
begin
	purgedir(WorkPath+'1\');

	if atype=0 then begin   {9510}
    prfmsg('ARDECNOM','');
		ok:=false;
		exit;
	end;
	shel1;
	{9517 - turn off remote display (var 2,-> false) and all subsequent}
	execbatch(ok,FALSE,'tgtemp1.bat','tgtest1.$$$',WorkPath+'1\',
						arcmci(Systat.ArchivePath+systat.filearcinfo[atype].unarcline,fn,fspec),
						systat.filearcinfo[atype].succlevel);
	shel2;

	if (not ok) then
		sysoplog('Archive "'+fn+'": Errors during de-compression');
end;

procedure arccomp(var ok:boolean; atype:integer; fn,fspec:astr);
{* ok: result
 * atype: archive method
 * fn   : archive filename
 *}
begin
	if atype=0 then begin   {9510}
    prfmsg('ARCOMNOM','');
		ok:=false;
		exit;
	end;
	shel1;
	execbatch(ok,FALSE,'tgtemp1.bat','tgtest1.$$$',WorkPath+'1\',
						arcmci(Systat.ArchivePath+systat.filearcinfo[atype].arcline,fn,fspec),
						systat.filearcinfo[atype].succlevel);
	shel2;

	if (not ok) then
		sysoplog('Archive "'+fn+'": Errors during compression');

	purgedir(WorkPath+'1\');
end;

procedure arccomment(var ok:boolean; atype,cnum:integer; fn:astr);
var cfile,ff:text;
		temp_read:string;
		b:boolean;
begin
	if atype=0 then begin   {9510}
    prfmsg('ARCMTNOM','');
		ok:=false;
		exit;
	end;
	if (cnum<>0) and (systat.filearccomment[cnum]<>'') then begin
		if not exist(systat.filearccomment[cnum]) then begin
       prfmsg('ARCMTERR','');
			 exit;
		end;

		shel1;
		b:=systat.swapshell; systat.swapshell:=FALSE;

		execbatch(ok,FALSE,'tgtemp1.bat','tgtest1.$$$',WorkPath+'1\',
							arcmci(Systat.ArchivePath+systat.filearcinfo[atype].cmtline,fn,'')+' <'+systat.filearccomment[cnum],
							systat.filearcinfo[atype].succlevel);

		systat.swapshell:=b;
		shel2;

	end;
end;

procedure arcintegritytest(var ok:boolean; atype:integer; fn:astr);
begin
	if atype=0 then begin   {9510}
    prfmsg('ARFITNOM','');
		ok:=false;
		exit;
	end;
	if (systat.filearcinfo[atype].testline<>'') then begin
		shel1;
		execbatch(ok,FALSE,'tgtemp1.bat','tgtest1.$$$',WorkPath+'1\',
							arcmci(Systat.ArchivePath+systat.filearcinfo[atype].testline,fn,''),
							systat.filearcinfo[atype].succlevel);
		shel2;
	end;
end;

procedure conva(var ok:boolean; otype,ntype:integer; tdir,ofn,nfn:astr);
var f:file;
    nofn,ps,ns,es:astr;
    eq:boolean;
begin
  prfmsg('ARCVTSON','');
  eq:=(otype=ntype);
  if (eq) then begin
    fsplit(ofn,ps,ns,es);
    nofn:=ps+ns+'.#$%';
	end;
  arcdecomp(ok,otype,ofn,'*.*');
  if (not ok) then prfmsg('ARCVTEID','')
  else begin
    prfmsg('ARCVTSTW','');
		if (eq) then begin assign(f,ofn); rename(f,nofn); end;
    arccomp(ok,ntype,nfn,'*.*');
    if (not ok) then begin
      prfmsg('ARCVTEIC','');
      if (eq) then begin assign(f,nofn); rename(f,ofn); end;
    end;
    if (not exist(sqoutsp(nfn))) then ok:=FALSE;
  end;
end;

function arctype(s:astr):integer;
var atype:integer;
begin
  s:=align(stripname(s)); s:=copy(s,length(s)-2,3);
	atype:=1;
	while (systat.filearcinfo[atype].ext<>'') and
        (systat.filearcinfo[atype].ext<>s) and
        (atype<maxarcs+1) do
    inc(atype);
  if (atype=maxarcs+1) or (systat.filearcinfo[atype].ext='') or
     (not systat.filearcinfo[atype].active) then atype:=0;
  arctype:=atype;
end;

procedure listarctypes;
var i,j:integer;
begin
  i:=1; j:=0;
  while (systat.filearcinfo[i].ext<>'') and (i<maxarcs) do begin
    if (systat.filearcinfo[i].active) then begin
      inc(j);
      if (j=1) then prfmsg('ARLISAVL','') else prfmsg('ARLISDEL','');
      varstr:=systat.filearcinfo[i].ext;
      prfmsg('ARLISTYP',varstr);
		end;
    inc(i);
	end;
  if (j=0) then prfmsg('ARLISNOA','');
  prfmsg('ARLISBOT','');
end;

procedure invarc;
begin
  prfmsg('ARUARCF','');
  listarctypes;
  prfmsg('ARUARCFB','');
end;


procedure doarccommand(cc:char);
const maxfiles=100;
var fl:array[1..maxfiles] of astr;
		fn,s,s1,s2,os1:astr;
    atype,numfl,rn,pl,savflistopt:integer;
    i,j,x:integer;
		c:char;
    abort,next,done,ok,ok1:boolean;
    fnx:boolean;    {* whether fn points to file out of .DIR list *}
    fil1,fil2:boolean;    {* whether listed/unlisted files in list *}
    wenttosysop,delbad,savpause:boolean;
		f,f1:ulfrec;
    rfpts:real;
    fi:file of byte;
    v:verbrec;
    dstr,nstr,estr:astr;
    bb:byte;
    c_files,c_oldsiz,c_newsiz,oldsiz,newsiz:longint;

  function stripname(i:astr):astr;
  var i1:astr; n:integer;

		function nextn:integer;
    var n:integer;
    begin
      n:=pos(':',i1);
			if (n=0) then n:=pos('\',i1);
      if (n=0) then n:=pos('/',i1);
      nextn:=n;
    end;

  begin
    i1:=i;
    while nextn<>0 do i1:=copy(i1,nextn+1,80);
    stripname:=i1;
  end;

  procedure addfl(fn:astr; b:boolean);
  var pl,rn,oldnumfl:integer;
      f:ulfrec;
      s,dstr,nstr,estr:astr;
			dirinfo:searchrec;
  begin
    if (not b) then begin
      oldnumfl:=numfl;
      recno(fn,pl,rn);
			if (fn<>'') and (pos('.',fn)<>0) and (rn<>0) then
        while (fn<>'') and (rn<>0) and (numfl<maxfiles) do begin
          seek(ulff,rn); read(ulff,f);
					inc(numfl);
          fl[numfl]:=f.filename;
          nrecno(fn,pl,rn);
        end;
      if (numfl=oldnumfl) then prfmsg('ARNOMF','');
      if (numfl>=maxfiles) then prfmsg('ARFRECF','');
    end else begin
      oldnumfl:=numfl;
      fsplit(fn,dstr,nstr,estr); s:=dstr;
      while (copy(s,length(s),1)='\') do s:=copy(s,1,length(s)-1);
      {$I-} chdir(s); {$I+}
      if ioresult<>0 then prfmsg('ARNOPATH','')
      else begin
        findfirst(fn,AnyFile-Directory-VolumeID,dirinfo);
        while (doserror=0) and (numfl<maxfiles) do begin
          inc(numfl);
          fl[numfl]:=fexpand(dstr+dirinfo.name);
					findnext(dirinfo);
        end;
        if (numfl>=maxfiles) then prfmsg('ARFRECF','');
        if (numfl=oldnumfl) then prfmsg('ARNOMF','');
      end;
      chdir(start_dir);
    end;
  end;

  procedure testfiles(b:integer; fn:astr; delbad:boolean; var abort,next:boolean);
  var fi:file of byte;
      f:ulfrec;
      oldboard,pl,rn,atype:integer;
			ok:boolean;
  begin
    oldboard:=fileboard;
    if (fileboard<>b) then changefileboard(b);
    if (fileboard=b) then begin
      recno(fn,pl,rn); { loads in memuboard }
      abort:=FALSE; next:=FALSE;
			while (fn<>'') and (rn<>0) and (not abort) and (not hangup) do begin
				{$I-} reset(ulff); {$I+}
        seek(ulff,rn); read(ulff,f);
        if (filerec(ulff).mode<>fmclosed) then close(ulff);
        fn:=memuboard.dlpath+f.filename;
        atype:=arctype(fn);
        if (atype<>0) then begin
          pbn(FALSE,abort,next); nl;
          varstr:=sqoutsp(fn);
          prfmsg('ARTSTWHA',varstr);
          ok:=TRUE;
          if (not exist(fn)) then begin
            varstr:=sqoutsp(fn);
            prfmsg('ARTSTFDE',varstr);
						ok:=FALSE;
          end else begin
            arcintegritytest(ok,atype,sqoutsp(fn));
            if (not ok) then begin
              varstr:=sqoutsp(fn);
              prfmsg('ARTSTFDP',varstr);
              if (delbad) then begin
                deleteff(rn,pl,TRUE);
                assign(fi,fn);
								{$I-} erase(fi); {$I+}
                if (ioresult<>0) then prfmsg('ARTSTEEF',varstr);
              end;
            end;
          end;
        end;
        nrecno(fn,pl,rn);
        wkey(abort,next);
      end;
      if (filerec(ulff).mode<>fmclosed) then close(ulff);
    end;
		fileboard:=oldboard;
  end;

  procedure cmtfiles(b:integer; fn:astr; var abort,next:boolean);
  var fi:file of byte;
      f:ulfrec;
      oldboard,pl,rn,atype:integer;
      ok:boolean;
	begin
		oldboard:=fileboard;
    if (fileboard<>b) then changefileboard(b);
    if (fileboard=b) then begin
      recno(fn,pl,rn); { loads in memuboard }
      abort:=FALSE; next:=FALSE;
      while (fn<>'') and (rn<>0) and (not abort) and (not hangup) do begin
        {$I-} reset(ulff); {$I+}
        seek(ulff,rn); read(ulff,f);
        if (filerec(ulff).mode<>fmclosed) then close(ulff);
        fn:=memuboard.dlpath+f.filename;
				atype:=arctype(fn);
        if (atype<>0) then begin
          pbn(FALSE,abort,next);
          varstr:=sqoutsp(fn);
          prfmsg('ARCMTING',varstr);
          ok:=TRUE;
          if (not exist(fn)) then begin
            prfmsg('ARCMTFDE',varstr);
            ok:=FALSE;
					end
          else arccomment(ok,atype,memuboard.cmttype,sqoutsp(fn));
				end;
        nrecno(fn,pl,rn);
        wkey(abort,next);
      end;
      if (filerec(ulff).mode<>fmclosed) then close(ulff);
    end;
    fileboard:=oldboard;
  end;

	procedure cvtfiles(b:integer; fn:astr; toa:integer;
                     var c_files,c_oldsiz,c_newsiz:longint;
                     var abort,next:boolean);
  var fi:file of byte;
      f:ulfrec;
      s:astr;
      oldboard,pl,rn,atype:integer;
      ok:boolean;
	begin
    oldboard:=fileboard;
    if (fileboard<>b) then changefileboard(b);
		if (fileboard=b) then begin
      recno(fn,pl,rn); { loads in memuboard }
      abort:=FALSE; next:=FALSE;
      while (fn<>'') and (rn<>0) and (not abort) and (not hangup) do begin
        {$I-} reset(ulff); {$I+}
        seek(ulff,rn); read(ulff,f);
        if (filerec(ulff).mode<>fmclosed) then close(ulff);
        fn:=memuboard.dlpath+f.filename;
				atype:=arctype(fn);
        if (atype<>0) and (atype<>toa) then begin
          pbn(FALSE,abort,next);
          varstr:=sqoutsp(fn);
          prfmsg('ARCVTING',varstr);
          ok:=FALSE;
          if (not exist(fn)) then
            prfmsg('ARCVTFDE',varstr)
          else begin
						ok:=TRUE;
            s:=copy(fn,1,pos('.',fn))+systat.filearcinfo[toa].ext;
            conva(ok,atype,bb,WorkPath+'1\',sqoutsp(fn),sqoutsp(s));
            if (ok) then begin
							assign(fi,sqoutsp(fn));
              {$I-} reset(fi); {$I+}
              ok:=(ioresult=0);
              varstr:=sqoutsp(fn);
              if (ok) then begin
                oldsiz:=trunc(filesize(fi));
                if (filerec(fi).mode<>fmclosed) then close(fi);
              end else
                prfmsg('ARCVTUAF',varstr);
              if (ok) then begin
                varstr:=sqoutsp(s);
                if (not exist(sqoutsp(s))) then begin
                  prfmsg('ARCVTUAS',varstr);
                  sysoplog('Unable to access "'+sqoutsp(s)+'"');
                  ok:=FALSE;
                end;
              end;
            end;
						if (ok) then begin
              f.filename:=align(stripname(sqoutsp(s)));
              {$I-} reset(ulff); {$I-}
              seek(ulff,rn); write(ulff,f);
              if (filerec(ulff).mode<>fmclosed) then close(ulff);
							{$I-} erase(fi); {$I+}
              if (ioresult<>0) then begin
                varstr:=sqoutsp(fn);
                prfmsg('ARCVTUEF',varstr);
                sysoplog('Unable to erase "'+sqoutsp(fn)+'"');
              end;

							assign(fi,sqoutsp(s));
              {$I-} reset(fi); {$I+}
              ok:=(ioresult=0);
              if (not ok) then begin
                varstr:=sqoutsp(s);
                prfmsg('ARCVTUAS',varstr);
                sysoplog('Unable to access "'+sqoutsp(s)+'"');
              end else begin
                newsiz:=trunc(filesize(fi));
								f.blocks:=trunc((filesize(fi)+127.0)/128.0);
                if (filerec(fi).mode<>fmclosed) then close(fi);
                {$I-} reset(ulff); {$I+}
                seek(ulff,rn); write(ulff,f);
                if (filerec(ulff).mode<>fmclosed) then close(ulff);
              end;

              if (ok) then begin
                inc(c_oldsiz,oldsiz);
                inc(c_newsiz,newsiz);
                inc(c_files);
                varstr:=cstrl(oldsiz); prfmsg('ARCVTOLD',varstr);
                varstr:=cstrl(newsiz); prfmsg('ARCVTNEW',varstr);
                if (oldsiz-newsiz>0) then begin
                  varstr:=cstrl(oldsiz-newsiz); prfmsg('ARCVTSSV',varstr);
                end else begin
                  varstr:=cstrl(newsiz-oldsiz); prfmsg('ARCVTSWA',varstr);
                end;
              end;
            end else begin
							sysoplog('Unable to convert "'+sqoutsp(fn)+'"');
              varstr:=sqoutsp(fn); prfmsg('ARCVTUCF',varstr);
            end;
          end;
        end;
        nrecno(fn,pl,rn);
        wkey(abort,next);
			end;
      if (filerec(ulff).mode<>fmclosed) then close(ulff);
    end;
    fileboard:=oldboard;
	end;

begin
  savpause:=(pause in thisuser.ac);
  if (savpause) then thisuser.ac:=thisuser.ac-[pause];
  numfl:=0;
  fiscan(pl); { loads in memuboard }
  case cc of
		'A':begin
          varstr:=cstr(maxfiles); prfmsg('ARADDHDR',varstr);
          prfmsg('ARADDFNP',''); prfmsg('ARADDFNC','');
          mpl(78); input(fn,78);
          if (fn<>'') then begin
            if (pos('.',fn)=0) and (memuboard.arctype<>0) then
							fn:=fn+'.'+systat.filearcinfo[memuboard.arctype].ext;
            fnx:=isul(fn);
            if (not fnx) then fn:=memuboard.dlpath+fn;
						fn:=fexpand(fn); atype:=arctype(fn);
            if (atype=0) then begin
              prfmsg('ARADDATN','');
              listarctypes;
            end else begin
              done:=FALSE; c:='A';
              repeat
                if (c='A') then
									repeat
                    prfmsg('ARADDADD',''); varstr:=cstr(numfl);
                    prfmsg('ARADDADC',varstr);
                    mpl(70); input(s,70);
                    if s<>'' then begin
                      if pos('.',s)=0 then s:=s+'*.*';
                      addfl(s,isul(s));
                    end;
                  until (s='') or (numfl>=maxfiles) or (hangup);
                prfmsg('ARADDPMT',''); onek(c,'QADLR?'); prfmsg('ARADDAP','');
                case c of
                  '?':prfmsg('ARADDMNU','');
                  'D':begin
												i:=0;
                        repeat
                          inc(i); j:=1;
                          s2:=sqoutsp(fl[i]);
                          if not isul(s2) then
                            s2:=memuboard.dlpath+s2;
                          s1:=arcmci(Systat.ArchivePath+systat.filearcinfo[atype].arcline,fn,s2);
                          os1:=s1;
                          while (length(s1)<=maxdoschrline) and (i<numfl) do begin
                            inc(i); inc(j);
														s2:=sqoutsp(fl[i]);
														if (not isul(s2)) then
                              s2:=memuboard.dlpath+s2;
                            os1:=s1;
                            s1:=s1+' '+s2;
                          end;
                          if (length(s1)>maxdoschrline) then begin
                            dec(i); dec(j);
                            s1:=os1;
													end;
                          ok:=TRUE; varstr:=cstr(j);
                          prfmsg('ARADDAFA',varstr);
                          shel1;
													execbatch(ok,FALSE,'tgtemp1.bat','tgtemp1.$$$',
                                    WorkPath+'1\',s1,
                                    systat.filearcinfo[atype].succlevel);
                          shel2;
                          if (not ok) then begin
                            prfmsg('ARADDEAF','');
                            ok:=pynq(getmsg('ARCONAWQ',''));
														if (hangup) then ok:=FALSE;
                          end;
                        until (i>=numfl) or (not ok);
                        arccomment(ok,atype,memuboard.cmttype,fn);
                        prfmsg('ARADDACR','');
                        if (not fnx) then begin
                          s2:=stripname(fn);
                          recno(s2,pl,rn);
                          if (rn<>0) then prfmsg('ARADDFAE','');
                          if pynq(getmsg('ARAA2LQ','')) then begin
                            assign(fi,fn);
                            {$I-} reset(fi); {$I+}
                            if ioresult=0 then begin
                              f.blocks:=trunc((filesize(fi)+127.0)/128.0);
                              close(fi);
                            end;
                            f.filename:=s2;
                            ok1:=TRUE;
                            if pynq(getmsg('ARUSFIDQ','')) then begin
															repeat
                                prfmsg('ARADDGFN','');
                                mpl(12); input(s2,12);
                                recno(s2,pl,rn);
                                if rn=0 then prfmsg('ARADDFNF','');
                                if s2='' then prfmsg('ARADDABT','');
                              until (rn<>0) or (s2='') or (hangup);
															if s2<>'' then begin
                                seek(ulff,rn); read(ulff,f1);
                                with f do begin
                                  description:=f1.description;
                                  vpointer:=f1.vpointer;
                                  nacc:=f1.nacc;
                                  ft:=f1.ft;
                                  owner:=f1.owner;
                                  stowner:=f1.stowner;
                                  date:=f1.date;
                                  daten:=f1.daten;
																end;
                                f1.vpointer:=-1;
																seek(ulff,rn); write(ulff,f1);
                              end else
                                ok1:=FALSE;
                            end else
                              ok1:=FALSE;

														if (not ok1) then begin
                              wenttosysop:=FALSE;
                              dodescrs(f,v,pl,wenttosysop,FALSE,ok1);
                              ok1:=false;
                              f.nacc:=0;
                              f.ft:=255;
                              f.owner:=usernum;
                              f.stowner:=allcaps(thisuser.name);
                              f.date:=date;
                              f.daten:=daynum(date);
                            end;

                            f.filestat:=[];
                            if (not fso) and (not systat.validateallfiles) then
															f.filestat:=f.filestat+[notval];

                            if (not systat.fileptratio) then f.filepoints:=0
                            else begin
                              rfpts:=(f.blocks/8)/systat.fileptcompbasesize;
															f.filepoints:=round(rfpts);
                            end;

                            if (rn=0) then newff(f,v) else writefv(rn,f,v);
                          end;
                        end;
                        if pynq(getmsg('ARDELOFQ','')) then
                          for i:=1 to numfl do begin
                            s2:=sqoutsp(fl[i]);
                            if not isul(fl[i]) then begin
                              recno(s2,pl,rn);
															if rn<>0 then deleteff(rn,pl,TRUE);
                              s2:=memuboard.dlpath+s2;
                            end;
                            assign(fi,s2);
														{$I-} erase(fi); {$I+}
                            if (ioresult<>0) then begin
                              varstr:=s2; prfmsg('ARADDCND',varstr);
                            end;
                          end;
												if ok then done:=TRUE;
                      end;
                  'L':if (numfl=0) then prfmsg('ARLISNOF','')
                      else begin
                        abort:=FALSE; next:=FALSE;
                        s:=''; j:=0;
                        i:=0;
                        repeat
                          inc(i);
                          if isul(fl[i]) then s:=s+'^3' else s:=s+'^1';
                          s:=s+align(stripname(fl[i]));
													inc(j);
                          if j<5 then s:=s+'    '
                          else begin
                            varstr:=s; prfmsg('ARLISFIL',varstr);
                            s:=''; j:=0;
													end;
                        until (i=numfl) or (abort) or (hangup);
                        if (j in [1..4]) and (not abort) then begin
                          varstr:=s; prfmsg('ARLISFIL',varstr);
                        end;
                      end;
                  'R':begin
                        prfmsg('ARREMGFN',''); mpl(12); input(s,12);
                        i:=0;
                        repeat
                          inc(i);
                          if align(stripname(fl[i]))=align(s) then begin
                            s1:=sqoutsp(fl[i]); varstr:='^3'+s1;
                            prfmsg('ARREMOFN',varstr);
                            if pynq(getmsg('ARREMOVQ','')) then begin
                              for j:=i to numfl-1 do fl[j]:=fl[j+1];
															dec(numfl); dec(i);
                            end;
                          end;
                        until (i>=numfl);
                      end;
                  'Q':done:=TRUE;
								end;
              until (done) or (hangup);

            end;
          end;
        end;
    'C':begin
          prfmsg('ARCVTFHD','');
          prfmsg('ARCVTFFS','');
          prfmsg('ARCVTFFP','');
          mpl(78); input(fn,78);
          c_files:=0; c_oldsiz:=0; c_newsiz:=0;
					if (fn<>'') then begin
            prfmsg('ARCVTNLA','');
            abort:=FALSE; next:=FALSE;
            repeat
              prfmsg('ARCVTTPP','');
              input(s,3);
              if (s='?') then begin
                prfmsg('ARCVTLH',''); listarctypes; prfmsg('ARCVTLB','');
              end;
            until (s<>'?');
						if (value(s)<>0) then bb:=value(s)
							else bb:=arctype(s+'FILENAME.'+s);
            if (bb<>0) then begin
              sysoplog('Conversion process began at '+date+' '+time+'.');
              if (isul(fn)) then begin
                fsplit(fn,dstr,nstr,estr); s:=dstr;
                findfirst(fn,AnyFile-Directory-VolumeID,dirinfo);
                abort:=FALSE; next:=FALSE;
                while (doserror=0) and (not abort) and (not hangup) do begin
                  fn:=fexpand(sqoutsp(dstr+dirinfo.name));
                  atype:=arctype(fn);
                  if (atype<>0) and (atype<>bb) then begin
                    varstr:=fn;
                    prfmsg('ARCVTPRC',varstr);
                    ok:=TRUE;
                    s:=copy(fn,1,pos('.',s))+systat.filearcinfo[bb].ext;
                    conva(ok,atype,bb,WorkPath+'1\',fn,s);
                    if (ok) then begin
                      assign(fi,sqoutsp(fn));
                      {$I-} reset(fi); {$I+}
                      ok:=(ioresult=0);
											if (ok) then begin
                        oldsiz:=trunc(filesize(fi));
                        close(fi);
                      end else begin
                        varstr:=sqoutsp(fn); prfmsg('ARCVTUAF',varstr);
                      end;
                      if (ok) then
                        if (not exist(sqoutsp(s))) then begin
                          varstr:=sqoutsp(fn); prfmsg('ARCVTUAS',varstr);
                          sysoplog('Unable to access "'+sqoutsp(s)+'"');
                          ok:=FALSE;
                        end;
										end;
                    if (ok) then begin
                      {$I-} erase(fi); {$I+}
                      if (ioresult<>0) then begin
                        varstr:=sqoutsp(fn);
                        prfmsg('ARCVTUEF',varstr);
                      end;

                      assign(fi,sqoutsp(s));
                      {$I-} reset(fi); {$I+}
											ok:=(ioresult=0);
											if (ok) then begin
                        newsiz:=trunc(filesize(fi));
                        close(fi);
                      end else begin
                        varstr:=sqoutsp(fn);
                        prfmsg('ARCVTUAS',varstr);
                      end;

                      if (ok) then begin
                        inc(c_oldsiz,oldsiz);
                        inc(c_newsiz,newsiz);
                        inc(c_files);
                        varstr:=cstrl(oldsiz); prfmsg('ARCVTOLD',varstr);
                        varstr:=cstrl(newsiz); prfmsg('ARCVTNEW',varstr);
                        if (oldsiz-newsiz>0) then begin
                          varstr:=cstrl(oldsiz-newsiz); prfmsg('ARCVTSSV',varstr);
                        end else begin
                          varstr:=cstrl(newsiz-oldsiz); prfmsg('ARCVTSWA',varstr);
                        end;
                      end;
                    end else begin
											sysoplog('Unable to convert "'+sqoutsp(fn)+'"');
                      varstr:=sqoutsp(fn); prfmsg('ARCVTUCF',varstr);
										end;
                  end;
                  findnext(dirinfo);
                  wkey(abort,next);
                end;
{                if (abort) then sprint('^M'+#3#7+'Conversion aborted.');}
              end else begin
                ok1:=pynq(getmsg('ARSADQ',''));
                nl;
								if (ok1) then begin
                  i:=0; abort:=FALSE; next:=FALSE;
                  while (not abort) and (i<=maxulb) and (not hangup) do begin
                    if (fbaseac(i)) then
                      cvtfiles(i,fn,bb,c_files,c_oldsiz,c_newsiz,abort,next);
                    inc(i);
                    wkey(abort,next);
                    if (next) then abort:=FALSE;
									end;
                end else
                  cvtfiles(fileboard,fn,bb,c_files,c_oldsiz,c_newsiz,
													 abort,next);
                reset(ulff);
              end;
              sysoplog('Conversion process ended at '+date+' '+time+'.');
              varstr:=cstr(c_files); prfmsg('ARCVTTAC',varstr);
              varstr:=cstrl(c_oldsiz); prfmsg('ARCVTOLD',varstr);
              varstr:=cstrl(c_newsiz); prfmsg('ARCVTNEW',varstr);
              if (c_oldsiz-c_newsiz>0) then begin
                varstr:=cstrl(c_oldsiz-c_newsiz);
                prfmsg('ARCVTSSV',varstr);
              end else begin
                varstr:=cstrl(c_newsiz-c_oldsiz);
                prfmsg('ARCVTSWA',varstr);
              end;
              sysoplog('Converted '+cstr(c_files)+' archives; old size='+
                       cstrl(c_oldsiz)+' bytes, new size='+cstrl(c_newsiz)+' bytes');
            end;
					end;
        end;
    'M':begin
          prfmsg('ARCOMCUH','');
          prfmsg('ARCOMCUF','');
          prfmsg('ARCOMCUP','');
          mpl(78); input(fn,78);
          if (fn<>'') then begin
            prfmsg('ARCOMNLA','');
            abort:=FALSE; next:=FALSE;
						if (isul(fn)) then begin
              prfmsg('ARCOMTYP','');
              ini(bb);
              if (badini) then bb:=1;
              if (bb<0) or (bb>3) then bb:=1;
              fsplit(fn,dstr,nstr,estr); s:=dstr;
              findfirst(fn,AnyFile-Directory-VolumeID,dirinfo);
              abort:=FALSE; next:=FALSE;
							while (doserror=0) and (not abort) and (not hangup) do begin
                fn:=fexpand(sqoutsp(dstr+dirinfo.name));
                atype:=arctype(fn);
                if (atype<>0) then begin
                  varstr:=fn; prfmsg('ARCOMPRC',varstr);
									ok:=TRUE;
                  arccomment(ok,atype,bb,fn);
                end;
                findnext(dirinfo);
                wkey(abort,next);
              end;
{              if (abort) then sprint('^M'+#3#7+'Comment update aborted.');}
            end else begin
              ok1:=pynq(getmsg('ARSADQ',''));
              prfmsg('ARCOMNLB','');
              if (ok1) then begin
                i:=0; abort:=FALSE; next:=FALSE;
                while (not abort) and (i<=maxulb) and (not hangup) do begin
                  if (fbaseac(i)) then cmtfiles(i,fn,abort,next);
									inc(i);
                  wkey(abort,next);
                  if (next) then abort:=FALSE;
                end;
              end else
                cmtfiles(fileboard,fn,abort,next);
							reset(ulff);
            end;
          end;
        end;
    'T':begin
          prfmsg('ARFITFIH','');
          prfmsg('ARFITFIF','');
          prfmsg('ARFITFIP','');
          mpl(78); input(fn,78);
          if (fn<>'') then begin
            prfmsg('ARFITNLA','');
            delbad:=pynq(getmsg('ARDFDPTQ',''));
            prfmsg('ARFITNLB','');
            abort:=FALSE; next:=FALSE;
            if (isul(fn)) then begin
              fsplit(fn,dstr,nstr,estr); s:=dstr;
              findfirst(fn,AnyFile-Directory-VolumeID,dirinfo);
              abort:=FALSE; next:=FALSE;
              while (doserror=0) and (not abort) and (not hangup) do begin
								fn:=fexpand(sqoutsp(dstr+dirinfo.name));
                atype:=arctype(fn);
                if (atype<>0) then begin
                  varstr:=fn;
                  prfmsg('ARFITPRC',varstr);
									ok:=TRUE;
                  arcintegritytest(ok,atype,fn);
                  if (not ok) then begin
                    varstr:=fn;
                    prfmsg('ARTSTFDP',varstr);
                    if (delbad) then begin
                      varstr:=fn;
                      assign(fi,fn);
                      {$I-} erase(fi); {$I+}
                      if (ioresult<>0) then prfmsg('ARTSTEEF',varstr);
										end;
                  end;
                end;
                findnext(dirinfo);
                wkey(abort,next);
              end;
{              if (abort) then sprint('^M'+#3#7+'Integrity testing aborted.');}
            end else begin
              ok1:=pynq(getmsg('ARSADQ',''));
              nl;
              if (ok1) then begin
								i:=0; abort:=FALSE; next:=FALSE;
                while (not abort) and (i<=maxulb) and (not hangup) do begin
                  if (fbaseac(i)) then testfiles(i,fn,delbad,abort,next);
                  inc(i);
                  wkey(abort,next);
                  if (next) then abort:=FALSE;
                end;
              end else
								testfiles(fileboard,fn,delbad,abort,next);
              reset(ulff);
            end;
          end;
        end;
    'X':begin {* extract *}
        end;
  end;
  close(ulff);
	if (savpause) then thisuser.ac:=thisuser.ac+[pause];
end;


{* Undef *}
procedure cvtfiles(b:integer; fn:astr; var c_files,c_oldsiz,c_newsiz:longint;
                   var abort,next:boolean);
var fi:file of byte;
    f:ulfrec;
    s,ps,ns,es:astr;
		oldsiz,newsiz:longint;
    oldboard,pl,rn,atype:integer;
    ok:boolean;
begin
  oldboard:=fileboard;
  if (fileboard<>b) then changefileboard(b);
  if (fileboard=b) then begin
    recno(fn,pl,rn); { loads in memuboard }
    abort:=FALSE; next:=FALSE;
    while (fn<>'') and (rn<>0) and (not abort) and (not hangup) do begin
			{$I-} reset(ulff); {$I+}
			seek(ulff,rn); read(ulff,f);
      if (filerec(ulff).mode<>fmclosed) then close(ulff);
      fn:=memuboard.dlpath+f.filename;
      atype:=arctype(fn);
      if (atype<>0) then begin
        pbn(FALSE,abort,next); nl;
        varstr:=sqoutsp(fn); prfmsg('ARCVTPRC',varstr);
        ok:=FALSE;
        if (not exist(fn)) then begin
          varstr:=sqoutsp(fn); prfmsg('ARCVTFDE',varstr);
        end else begin
          if (rezipcmd<>'') then begin
            assign(fi,sqoutsp(fn));
            {$I-} reset(fi); {$I+}
            if (ioresult=0) then begin
              oldsiz:=trunc(filesize(fi));
              if (filerec(fi).mode<>fmclosed) then close(fi);
            end;
            shel1;
						execbatch(ok,FALSE,'tgtemp1.bat','tgtest1.$$$',WorkPath+'1\',
											rezipcmd+' '+sqoutsp(fn),-1);
            shel2;
            assign(fi,sqoutsp(fn));
            {$I-} reset(fi); {$I+}
            if (ioresult=0) then begin
              newsiz:=trunc(filesize(fi));
              f.blocks:=trunc((filesize(fi)+127.0)/128.0);
							if (filerec(fi).mode<>fmclosed) then close(fi);
              {$I-} reset(ulff); {$I+}
              seek(ulff,rn); write(ulff,f);
              if (filerec(ulff).mode<>fmclosed) then close(ulff);
            end;
          end else begin
            ok:=TRUE;
            s:=fn;
            conva(ok,atype,atype,WorkPath+'1\',sqoutsp(fn),sqoutsp(s));
            if (ok) then begin
              fsplit(fn,ps,ns,es); fn:=ps+ns+'.#$%';
              assign(fi,sqoutsp(fn));
              {$I-} reset(fi); {$I+}
              ok:=(ioresult=0);
              if (ok) then begin
                oldsiz:=trunc(filesize(fi));
                if (filerec(fi).mode<>fmclosed) then close(fi);
              end else begin
                varstr:=sqoutsp(fn); prfmsg('ARCVTUAF',varstr);
              end;
              if (ok) then
                if (not exist(sqoutsp(s))) then begin
                  varstr:=sqoutsp(s); prfmsg('ARCVTUAS',varstr);
                  sysoplog('Unable to access "'+sqoutsp(s)+'"');
                  ok:=FALSE;
                end;
            end;
            if (ok) then begin
              f.filename:=align(stripname(sqoutsp(s)));
              {$I-} reset(ulff); {$I+}
              seek(ulff,rn); write(ulff,f);
              if (filerec(ulff).mode<>fmclosed) then close(ulff);

              fsplit(fn,ps,ns,es); fn:=ps+ns+'.#$%';
              assign(fi,fn); {$I-} erase(fi); {$I+}

              if (ioresult<>0) then begin
                varstr:=sqoutsp(fn); prfmsg('ARCVTUEF',varstr);
                sysoplog('Unable to erase "'+sqoutsp(fn)+'"');
							end;

              assign(fi,sqoutsp(s));
              {$I-} reset(fi); {$I+}
              ok:=(ioresult=0);
              if (not ok) then begin
                varstr:=sqoutsp(s); prfmsg('ARCVTUAS',varstr);
                sysoplog('Unable to access "'+sqoutsp(s)+'"');
              end else begin
                newsiz:=trunc(filesize(fi));
                f.blocks:=trunc((filesize(fi)+127.0)/128.0);
                if (filerec(fi).mode<>fmclosed) then close(fi);
                {$I-} reset(ulff); {$I+}
                seek(ulff,rn); write(ulff,f);
                if (filerec(ulff).mode<>fmclosed) then close(ulff);
                arccomment(ok,atype,memuboard.cmttype,sqoutsp(s));
              end;
            end else begin
              sysoplog('Unable to convert "'+sqoutsp(fn)+'"');
              varstr:=sqoutsp(fn); prfmsg('ARCVTUCF',varstr);
            end;
          end;
          if (ok) then begin
            inc(c_oldsiz,oldsiz);
            inc(c_newsiz,newsiz);
            inc(c_files);
            varstr:=cstrl(oldsiz); prfmsg('ARCVTOLD',varstr);
            varstr:=cstrl(newsiz); prfmsg('ARCVTNEW',varstr);
            if (oldsiz-newsiz>0) then begin
              varstr:=cstrl(oldsiz-newsiz); prfmsg('ARCVTSSV',varstr);
            end else begin
              varstr:=cstrl(newsiz-oldsiz); prfmsg('ARCVTSWA',varstr);
            end;
          end;
        end;
      end;
      nrecno(fn,pl,rn);
      wkey(abort,next);
    end;
		if (filerec(ulff).mode<>fmclosed) then close(ulff);
  end;
  fileboard:=oldboard;
end;

procedure rezipstuff;
var fn:astr;
    c_files,c_oldsiz,c_newsiz:longint;
    i:integer;
    abort,next,ok1:boolean;
begin
  prfmsg('ARRECRCH','');
  prfmsg('ARRECRCF','');
  prfmsg('ARRECRCP','');
  mpl(78); input(fn,78);
  c_files:=0; c_oldsiz:=0; c_newsiz:=0;
  if (fn<>'') then begin
    prfmsg('ARRECEXT','');
    if pynq(getmsg('ARSUCHAS','')) then begin
      prfmsg('ARRECCMD','');
      input(rezipcmd,100);
      if (rezipcmd='') then exit;
    end else
      rezipcmd:='';
    prfmsg('ARRECNLA','');
    abort:=FALSE; next:=FALSE;
    ok1:=pynq(getmsg('ARSADQ',''));
    prfmsg('ARRECNLB','');
    sysoplog('Conversion process began at '+date+' '+time+'.');
    varstr:=date+tilde+time;
    prfmsg('ARRECBEG',varstr);
    if (ok1) then begin
      i:=0; abort:=FALSE; next:=FALSE;
      while ((not abort) and (i<=maxulb) and (not hangup)) do begin
        if (fbaseac(i)) then
          cvtfiles(i,fn,c_files,c_oldsiz,c_newsiz,abort,next);
        inc(i);
        wkey(abort,next);
        if (next) then abort:=FALSE;
      end;
    end else
      cvtfiles(fileboard,fn,c_files,c_oldsiz,c_newsiz,abort,next);
  end;
  sysoplog('Conversion process ended at '+date+' '+time+'.');
  varstr:=date+tilde+time;
  prfmsg('ARRECEND',varstr);
  varstr:=cstr(c_files); prfmsg('ARCVTTAC',varstr);
  varstr:=cstrl(c_oldsiz); prfmsg('ARCVTOLD',varstr);
  varstr:=cstrl(c_newsiz); prfmsg('ARCVTNEW',varstr);
  if (c_oldsiz-c_newsiz>0) then begin
    varstr:=cstrl(c_oldsiz-c_newsiz); prfmsg('ARCVTSSV',varstr);
  end else begin
    varstr:=cstrl(c_newsiz-c_oldsiz); prfmsg('ARCVTSWA',varstr);
  end;
  sysoplog('Converted '+cstr(c_files)+' archives; old size='+
           cstrl(c_oldsiz)+' bytes, new size='+cstrl(c_newsiz)+' bytes');
end;


end.
