{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : FILE*.PAS                                                     
  Description: Revelation File Transfer System                               
  Version    : v0.1100                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit file0;

interface

uses
  crt,dos,overlay,
  myio,
  common;


const
  ulffopen1:boolean=TRUE;   { whether ulff has been opened before }

var
  dirinfo:searchrec;
  found:boolean;


function substall(src,old,new:astr):astr;
procedure deleteff(var rn:integer; var pl:integer; killverbose:boolean);
function align(fn:astr):astr;
function baddlpath:boolean;
function badulpath:boolean;
function bslash(b:boolean; s:astr):astr;
function existdir(s:astr):boolean;
procedure ffile(fn:astr);
procedure fileinfo(f:ulfrec; editing:boolean; var abort,next:boolean);
procedure fiscan(var pl:integer);
function fit(f1,f2:astr):boolean;
procedure gfn(var fn:astr);
function isul(s:astr):boolean;
function iswildcard(s:astr):boolean;
procedure nfile;
procedure lrecno(fn:astr; var pl,rn:integer);
procedure nrecno(fn:astr; var pl,rn:integer);
procedure recno(fn:astr; var pl,rn:integer);
function rte:real;
procedure star(s:astr);
function stripname(i:astr):astr;
function tcheck(s:real; i:integer):boolean;
function tchk(s:real; i:real):boolean;
procedure verbfileinfo(pt:integer; editing,abort,next:boolean);

implementation

function substall(src,old,new:astr):astr;
var p:integer;
begin
  p:=1;
  while p>0 do begin
    p:=pos(old,src);
    if p>0 then begin
      insert(new,src,p+length(old));
      delete(src,p,length(old));
    end;
  end;
  substall:=src;
end;

procedure deleteff(var rn:integer; var pl:integer; killverbose:boolean);
var i:integer;
    f:ulfrec;
    v:verbrec;
    fileit:file of ulfrec;
    temp:ulfrec;
    done:boolean;
begin
  if (rn<=pl) and (rn>0) then begin
    done:=FALSE;
    dec(pl);
    {$I-} reset(ulff); {$I+}
    seek(ulff,rn); read(ulff,f);
    if (filerec(ulff).mode<>fmclosed) then close(ulff);

    if (f.vpointer<>-1) and (killverbose) then begin
      assign(verbf,systat.systempath+'verbose.dat');
      reset(verbf);
      seek(verbf,f.vpointer); read(verbf,v);
      if (ioresult=0) then begin
        v.descr[1]:='';
        seek(verbf,f.vpointer); write(verbf,v);
      end;
      close(verbf);
    end;

    if (fbdirdlpath in memuboard.fbstat) then
      assign(fileit,memuboard.dlpath+memuboard.filename+'.REV')
    else
      assign(fileit,systat.systempath+memuboard.filename+'.REV');

    rewrite(fileit);
    {$I-} reset(ulff); {$I+}
    seek(ulff,0); read(ulff,temp);

    temp.blocks:=pl;
    write(fileit,temp);   {Writes the CONTROL record to the file}

    while not eof(ulff) do begin
      read(ulff,temp);
      if (temp.filename<>f.filename) or (done=true) then
        write(fileit,temp)
      else begin          {Done allows only ONE file to be del'd}
        rn:=filepos(fileit);
        done:=TRUE;
      end;
    end;
    close(fileit);
    if (filerec(ulff).mode<>fmclosed) then close(ulff);
    {Closes the files}

    erase(ulff);      {erase the old directory file}

    if (fbdirdlpath in memuboard.fbstat) then
      rename(fileit,memuboard.dlpath+memuboard.filename+'.DIR')
    else
      rename(fileit,systat.systempath+memuboard.filename+'.DIR');

    {That renames the new file to the correct name.}
    fiscan(pl);  {ReAssigns ULFF}
    if (filerec(ulff).mode<>fmclosed) then close(ulff);
  end;
end;

function align(fn:astr):astr;
var f,e,t:astr; c,c1:integer;
begin
  c:=pos('.',fn);
  if (c=0) then begin
    f:=fn; e:='   ';
  end else begin
    f:=copy(fn,1,c-1); e:=copy(fn,c+1,3);
  end;
  f:=mln(f,8);
  e:=mln(e,3);
  c:=pos('*',f); if (c<>0) then for c1:=c to 8 do f[c1]:='?';
  c:=pos('*',e); if (c<>0) then for c1:=c to 3 do e[c1]:='?';
  c:=pos(' ',f); if (c<>0) then for c1:=c to 8 do f[c1]:=' ';
  c:=pos(' ',e); if (c<>0) then for c1:=c to 3 do e[c1]:=' ';
  align:=f+'.'+e;
end;

function baddlpath:boolean;
var s:string;
begin
  if (badfpath) then begin
    varstr:=cstr(fileboard); prfmsg('FBUTPC',varstr);
    If fso then prfmsg('FBBDLP',memuboard.dlpath);
    prfmsg('FBPITS','');

    sysoplog('Invalid DL Path (file base #'+cstr(fileboard)+'): "'+
             memuboard.dlpath+'"');
  end;
  baddlpath:=badfpath;
end;

function badulpath:boolean;
var s:string;
begin
  if (badufpath) then begin
    varstr:=cstr(fileboard)+'~'+memuboard.ulpath;
    prfmsg('FBBULP',varstr);
    sysoplog('Invalid UL Path (File Base #'+cstr(fileboard)+'): "'+
             memuboard.ulpath+'"');
  end;
  badulpath:=badufpath;
end;

function bslash(b:boolean; s:astr):astr;
begin
  if (b) then begin
    while (copy(s,length(s)-1,2)='\\') do s:=copy(s,1,length(s)-2);
    if (copy(s,length(s),1)<>'\') then s:=s+'\';
  end else
    while (copy(s,length(s),1)='\') do s:=copy(s,1,length(s)-1);
  bslash:=s;
end;

function existdir(s:astr):boolean;
var savedir:astr;
    okd:boolean;
begin
  okd:=TRUE;
  s:=bslash(FALSE,fexpand(s));

  if ((length(s)=2) and (copy(s,2,1)=':')) then begin
    getdir(0,savedir);
    {$I-} chdir(s); {$I+}
    if (ioresult<>0) then okd:=FALSE;
    chdir(savedir);
    exit;
  end;

  okd:=(exist(s));

  if (okd) then begin
    findfirst(s,anyfile,dirinfo);
    if (dirinfo.attr and directory<>directory) or
       (doserror<>0) then okd:=FALSE;
  end;

  existdir:=okd;
end;

procedure fiscan(var pl:integer); { loads in memuboard ... }
var f:ulfrec;
    dirinfo:searchrec;
    s:astr;
begin
  loaduboard(fileboard);          { And So Does This.....}
  s:=memuboard.dlpath; s:=copy(s,1,length(s)-1);
  if ((length(s)=2) and (s[2]=':')) then badfpath:=FALSE else begin
    findfirst(s,dos.directory,dirinfo);
    badfpath:=(doserror<>0);
  end;

  s:=memuboard.ulpath; s:=copy(s,1,length(s)-1);
  if ((length(s)=2) and (s[2]=':')) then badufpath:=FALSE else begin
    findfirst(s,dos.directory,dirinfo);
    badufpath:=(doserror<>0);
  end;

  if (not ulffopen1) then
    if (filerec(ulff).mode<>fmclosed) then close(ulff)
      else begin end
  else
    ulffopen1:=FALSE;

  if (fbdirdlpath in memuboard.fbstat) then
    assign(ulff,memuboard.dlpath+memuboard.filename+'.DIR')
  else
    assign(ulff,systat.SystemPath+memuboard.filename+'.DIR');
  {$I-} reset(ulff); {$I+}
  if (ioresult<>0) then begin
    rewrite(ulff);
    f.blocks:=0;
    write(ulff,f);
  end;
  seek(ulff,0); read(ulff,f);
  pl:=f.blocks;
  bnp:=FALSE;
end;

procedure ffile(fn:astr);
begin
  findfirst(fn,anyfile,dirinfo);
  found:=(doserror=0);
end;

procedure fileinfo(f:ulfrec; editing:boolean; var abort,next:boolean);
var dt:datetimerec;
    fz,s:astr;
    r:real;
    x:longint;
    i,j,z:integer;
    u:userrec;
    number,outof:string[3];

function whosto(filto:integer):string;
begin
  if filto=0 then whosto:='All'
  else whosto:=cstr(filto);
end;

begin
  j:=0;
  with f do begin
    prfmsg('FBFITOP','');
    for i:=1 to 9 do begin
      if (i=4) and (editing) then inc(i);
      inc(j);
{      if (editing) then s:=#3#3+cstr(j)+'. ' else s:=#3#1; }
      case i of
        1:begin
            str(disknums[1],number);
            str(disknums[2],outof);
            varstr:=filename+'~'+number+'~'+outof;
            prfmsg('FBFIONE',varstr);
          end;
        2:prfmsg('FBFITWO',description);
        3:begin
            x:=blocks; x:=x*128; varstr:=cstrl(x)+'~'+cstr((blocks+7) div 8)+'~'+cstr(blocks);
            prfmsg('FBFITHR',varstr);
          end;
        4:begin
            r:=rte*blocks; r2dt(r,dt); varstr:=longtim(dt);
            prfmsg('FBFIFOU',varstr);
          end;
        5:if (fso) or (aacs(memuboard.nameacs)) then begin
            varstr:=caps(stowner)+'~'+cstr(owner);
            prfmsg('FBFIFIV',varstr);
          end;
        6:prfmsg('FBFISIX',date);
        7:prfmsg('FBFISEV',cstr(nacc));
        8:begin
            varstr:=cstr(filepoints)+'~';
            if (notval in filestat) then varstr:=varstr+' ^8<Not Val>';
            if (isrequest in filestat) then varstr:=varstr+' ^9Request File';
            if (resumelater in filestat) then varstr:=varstr+' ^7Resume Later';
            prfmsg('FBFIEIG',varstr);
          end;
        9:prfmsg('FBFININ',whosto(fileto));
      end;
    end;
    prfmsg('FBFIBOT','');
    if ((f.fileto<>0) and (f.fileto<>usernum)) then begin
      if not fso then prfmsg('FBPRVFI','')
      else prfmsg('FBPRVCO',cstr(f.fileto));
    end else if (f.fileto=usernum) then prfmsg('FBPRVYU','');
  end;
  if (f.vpointer<>-1) then verbfileinfo(f.vpointer,editing,abort,next);
end;

function fit(f1,f2:astr):boolean;
var tf:boolean; c:integer;
begin
  tf:=TRUE;
  for c:=1 to 12 do
    if (f1[c]<>f2[c]) and (f1[c]<>'?') then tf:=FALSE;
  fit:=tf;
end;

procedure gfn(var fn:astr);
begin
  prfmsg('FBGFNL','');
  input(fn,12);
  if (pos('.',fn)=0) and (value(fn)=0) then fn:=fn+'*.*';
  if (value(fn)=0) then fn:=align(fn);
end;

function isul(s:astr):boolean;
begin
  isul:=((pos('\',s)<>0) or (pos(':',s)<>0) or (pos('|',s)<>0));
end;

function iswildcard(s:astr):boolean;
begin
  iswildcard:=((pos('*',s)<>0) or (pos('?',s)<>0));
end;

procedure nfile;
begin
  findnext(dirinfo);
  found:=(doserror=0);
end;

procedure lrecno(fn:astr; var pl,rn:integer);
var c:integer;
    f:ulfrec;
begin
  rn:=0;
  if (lrn<=pl) and (lrn>=0) then begin
    c:=lrn-1;
    {$I-} reset(ulff); {$I+}
    while (c<=pl) and (rn=0) do begin
      seek(ulff,c); read(ulff,f);
      if pos('.',f.filename)<>9 then begin
        f.filename:=align(f.filename);
        seek(ulff,c); write(ulff,f);
      end;
      if fit(lfn,f.filename) then rn:=c;
      inc(c);
    end;
    if (filerec(ulff).mode<>fmclosed) then close(ulff);
    lrn:=rn;
  end;
end;

procedure nrecno(fn:astr; var pl,rn:integer);
var c:integer;
    f:ulfrec;
begin
  rn:=0;
  if (lrn<pl) and (lrn>=0) then begin
    c:=lrn+1;
    {$I-} reset(ulff); {$I+}
    while (c<=pl) and (rn=0) do begin
      seek(ulff,c); read(ulff,f);
      if pos('.',f.filename)<>9 then begin
        f.filename:=align(f.filename);
        seek(ulff,c); write(ulff,f);
      end;
      if fit(lfn,f.filename) then rn:=c;
      inc(c);
    end;
    if (filerec(ulff).mode<>fmclosed) then close(ulff);
    lrn:=rn;
  end;
end;

procedure recno(fn:astr; var pl,rn:integer);
var f:ulfrec;
    c:integer;
begin
  fn:=align(fn);
  fiscan(pl);
  rn:=0; c:=1;
  {$I-} reset(ulff); {$I+}
  while (c<=pl) and (rn=0) do begin
    seek(ulff,c); read(ulff,f);
    if pos('.',f.filename)<>9 then begin
      f.filename:=align(f.filename);
      seek(ulff,c); write(ulff,f);
    end;
    if fit(fn,f.filename) then rn:=c;
    inc(c);
  end;
  if (filerec(ulff).mode<>fmclosed) then close(ulff);
  lrn:=rn;
  lfn:=fn;
end;

function rte:real;
var i:integer;
begin
  i:=value(connectspd); if (i=0) then i:=modemr.maxbaud;
  rte:=1400.0/i;
end;

procedure star(s:astr); (* KILL THIS PROCEDURE *)
begin
  If (okansi) then sprompt('^9 ^2') else sprompt('^9* ^2');
  If (s<>#1) then sprint(s);
end;

function stripname(i:astr):astr;
var i1:astr;
    n:integer;

  function nextn:integer;
  var n:integer;
  begin
    n:=pos(':',i1);
    if (n=0) then n:=pos('\',i1);
    if (n=0) then n:=pos('/',i1);
    nextn:=n;
  end;

begin
  i1:=i;
  while (nextn<>0) do i1:=copy(i1,nextn+1,80);
  stripname:=i1;
end;

function tcheck(s:real; i:integer):boolean;
var r:real;
begin
  r:=timer-s;
  if r<0.0 then r:=r+86400.0;
  if (r<0.0) or (r>32760.0) then r:=32766.0;
  if trunc(r)>i then tcheck:=FALSE else tcheck:=TRUE;
end;

function tchk(s:real; i:real):boolean;
var r:real;
begin
  r:=timer;
  if r<s then r:=r+86400.0;
  if (r-s)>i then tchk:=FALSE else tchk:=TRUE;
end;

procedure verbfileinfo(pt:integer; editing,abort,next:boolean);
var v:verbrec;
    i:integer;
    s:astr;
    vfo:boolean;
begin
  v.descr[1]:='';
  if pt<>-1 then begin
    {$I-} reset(verbf); {$I+}
    if ioresult=0 then begin
      {$I-} seek(verbf,pt); read(verbf,v); {$I+}
      if ioresult=0 then
        with v do
          for i:=1 to 10 do
            if descr[i]='' then i:=10
            else begin
              s:=#3#5;
              s:=s+'> ';
              s:=s+#3#4+descr[i];
              if (editing) and (i=1) then s:=s+#3#2+' ('+cstr(pt)+')';
              prfmsg('FBVRBOSE',s);
{              printacr(s,abort,next); }
            end;
      if (filerec(verbf).mode<>fmclosed) then close(verbf);
    end;
  end;
  if (editing) then
    if (pt=-1) then prfmsg('FBVRBNO','')
    else
      if (v.descr[1]='') then
        prfmsg('FBVRBNY',cstr(pt));
end;

end.
