{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit file1;

interface

uses
	crt, dos, overlay,
  myio, common;

procedure dodl(fpneed:integer);
procedure doul(pts:integer);
procedure showuserfileinfo;
function okdl(f:ulfrec):boolean;
procedure dlx(f1:ulfrec; rn:integer; var abort:boolean);
procedure dl(fn:astr);
procedure dodescrs(var f:ulfrec; var v:verbrec; var pl:integer;
                   var tosysop:boolean; LocalUpload:boolean; var dontprocede:boolean);
procedure writefv2(f:ulfrec; v:verbrec);
procedure writefv(rn:integer; f:ulfrec; v:verbrec);
procedure newff(f:ulfrec; v:verbrec);
procedure doffstuff(var f:ulfrec; fn:astr; var gotpts:integer);
procedure idl(ForceFileName:string);
procedure iul;

procedure fbaselist;
procedure unlisted_download(s:astr);
procedure do_unlisted_download;
function nfvpointer:longint;
procedure newuserupload(var descript:astr; var fname:astr);
procedure FILE_ID_DIZ(fn:astr;IsBatchUL:Boolean;var v:verbrec;var f:ulfrec);

implementation

uses
  file0, file8, Msg1, archive, miscx, CfgLists;
var
  locbatup:boolean;

procedure dodl(fpneed:integer);   { Deducts File Points }
begin
  prfmsg('FBDODL','');
  if (not aacs(systat.nofilepts)) or
     (not (fnofilepts in thisuser.ac)) then begin
    if (fpneed>0) then dec(thisuser.filepoints,fpneed);
    if (thisuser.filepoints<0) then thisuser.filepoints:=0;
    prfmsg('FBENJOY',thisuser.name);
    if (fpneed<>0) then
      prfmsg('FBFPDED',cstr(thisuser.filepoints));
	end;
end;

procedure doul(pts:integer);     { Gives UL File Points }
begin
  if (not aacs(systat.ulvalreq)) then begin
    prfmsg('FBTHXUL',thisuser.name);
    if (systat.uldlratio) then
      prfmsg('FBWRFC',systat.sysopname)
		else
      prfmsg('FBWRFP',systat.sysopname);
	end else
    if ((not systat.uldlratio) and (not systat.fileptratio) and (pts=0)) then begin
      prfmsg('FBTHXUL',thisuser.name);
      prfmsg('FBWRFP',systat.sysopname);
    end else
      inc(thisuser.filepoints,pts);
end;

procedure showuserfileinfo;      { Shows File Info (UL/DLs) }
begin
  with thisuser do
    commandline('U/L: '+cstr(uploads)+'/'+cstr(trunc(uk))+
						'k  D/L: '+cstr(downloads)+'/'+cstr(trunc(dk))+'k');
end;

function okdl(f:ulfrec):boolean;   { Check if OK to DL File. Returns boolean }
var s:astr;
		b:boolean;

	function phours(lotime,hitime:integer):astr;
	begin
		if (lotime<>hitime) then
			phours:=tch(cstr(lotime div 60))+':'+tch(cstr(lotime mod 60))+'...'+
							tch(cstr(hitime div 60))+':'+tch(cstr(hitime mod 60))
	end;

  procedure nope(msg,vars:string);
	begin
    if (b) then prfmsg(msg,vars);
		b:=FALSE;
	end;

begin
	b:=TRUE;

	if (value(connectspd)<=9600) and (value(connectspd)>0) then
		if (not intime(timer,systat.bdllowtime,systat.bdlhitime)) then begin
			if (exist(systat.TextPath+'lowdlhrs.*') or exist(systat.SystemPath+'lowdlhrs.*')) then
				printf('lowdlhrs')
      else
        nope('FBDLLWB',phours(systat.bdllowtime,systat.bdlhitime))

		end;

	if (not intime(timer,systat.dllowtime,systat.dlhitime)) then
			if (exist(systat.TextPath+'dlhours.*') or exist(systat.SystemPath+'dlhours.*')) then
				printf('dlhours')
			else
        nope('FBDLHRS',phours(systat.dllowtime,systat.dlhitime));

	if memuboard.basetype=1 then
    nope('FBDLULO','');

	if memuboard.basetype=3 then
		if (usernum<>f.fileto) and (f.fileto<>0) then
      nope('FBDLPRV','')
		else
      prfmsg('FBDLYOU','');

	if (isrequest in f.filestat) then begin
		printf('reqfile');
    if (nofile) then prfmsg('FBREQDL',systat.sysopname);
		dyny:=TRUE;
    if (pynq(getmsg('FBREQNWQ',''))) then begin
			s:=sqoutsp(f.filename);
			SendEMail('SYSOP', 'File Request Of "'+s+'" From File Base '+memuboard.name);
		end;
		b:=FALSE;
	end;

	if ((resumelater in f.filestat) and (not fso)) then
    nope('FBDLRLF','');

	if ((notval in f.filestat) and (not aacs(systat.dlunval))) then
    nope('FBDLUNV','');

	if (thisuser.filepoints<f.filepoints) and (f.filepoints>0) and
		 (not aacs(systat.nofilepts)) and
		 (not (fnofilepts in thisuser.ac)) and
		 (not (fbnoratio in memuboard.fbstat)) then
    nope('FBDLIFP','');

	if (nsl<rte*f.blocks) then
    nope('FBDLNET','');

	if (not exist(memuboard.dlpath+f.filename)) then begin
    nope('FBDLFNT','');
		sysoplog('File missing in file list: '+sqoutsp(memuboard.dlpath+f.filename));
	end;

	if (usernum<>f.fileto) and (f.fileto<>0) then
    nope('FBDLPRO','');

	okdl:=b;
end;

procedure dlx(f1:ulfrec; rn:integer; var abort:boolean);  { Single File DL / Called by DL }
var u:userrec;
		tooktime,xferstart,xferend:datetimerec;
		ulffopenb4:boolean;
		i,ii,tt,bar,s:astr;
		rl,tooktime1:real;
		cps,lng:longint;
		inte,pl,z:integer;
		c:char;
		next,ps,ok,tl:boolean;
begin
	abort:=FALSE; next:=FALSE;

  fileinfo(f1,FALSE,abort,next);

	ps:=TRUE;
	abort:=FALSE;
	if (not okdl(f1)) then ps:=TRUE else begin
		ps:=FALSE;
		showuserfileinfo;

		getdatetime(xferstart);
		send1(memuboard.dlpath+f1.filename,ok,abort);
		getdatetime(xferend);
		timediff(tooktime,xferstart,xferend);

		if (not (-lastprot in [10,11,12])) then
			if (not abort) then
				if (not ok) then begin
          prfmsg('FBDLNOK','');
					sysoplog(#3#3+'Tried download "'+sqoutsp(f1.filename)+'" from '+memuboard.name);
					ps:=TRUE;
				end else begin
					if (not (fbnoratio in memuboard.fbstat)) then begin
						inc(thisuser.downloads);
            thisuser.dk:=thisuser.dk+(f1.blocks div 8);
          end;
					inc(systat.todayzlog.downloads);
					inc(systat.todayzlog.dk,(f1.blocks div 8));

          if (not incom) then nl;

          lng:=f1.blocks; lng:=lng*128;
          varstr:=longtim(tooktime)+'~'+cstrl(lng)+'~';
          if (fbnoratio in memuboard.fbstat) then varstr:=varstr+' ^5<No-Ratio>';
          prfmsg('FBDLWOK',varstr);

					s:=#3#3+'Download "'+sqoutsp(f1.filename)+'" from '+memuboard.name;

          tooktime1:=dt2r(tooktime);
          if (tooktime1>=1.0) then begin
						cps:=f1.blocks; cps:=cps*128;
            cps:=trunc(cps/tooktime1);
          end else
            cps:=0;

          s:=s+#3#3+' ('+cstr(f1.blocks div 8)+'k, '+ctim(dt2r(tooktime))+
							 ', '+cstr(cps)+' cps)';
          sysoplog(s);
          if (not (fbnoratio in memuboard.fbstat)) and
             (f1.filepoints>0) then dodl(f1.filepoints);
          showuserfileinfo;

					if (rn<>-1) then begin
						inc(f1.nacc);
						ulffopenb4:=(filerec(ulff).mode<>fmclosed);
						{$I-} reset(ulff); {$I+}
						seek(ulff,rn); write(ulff,f1);
						if not ulffopenb4 then close(ulff);
					end;
        end;
  end;
	if (ps) then begin
    prfmsg('FBCTNFP','');
		onek(c,'Q '^M);
    abort:=(c='Q');
	end;
end;

procedure dl(fn:astr);        { Download a File using File NAME.}
var pl,rn:integer;
		f:ulfrec;
		abort:boolean;
begin
	abort:=FALSE;
	recno(fn,pl,rn);
	if (baddlpath) then exit;

  if (rn=0) then prfmsg('FBNOFILE','')
	else
		while (rn<>0) and (not abort) and (not hangup) do begin
			{$I-} reset(ulff); {$I+}
			seek(ulff,rn);
			read(ulff,f);
			dlx(f,rn,abort);
			nrecno(fn,pl,rn);
		end;
	if (filerec(ulff).mode<>fmclosed) then close(ulff);
end;

procedure Idl(ForceFileName:string);   { Intelligent Batch or Single DL }
var s,Fil:astr;
		dok,dabort,abort:boolean;
		pl:Integer;
		f:UlfRec;
		ulffopenb4:boolean;
begin
		If (ForceFileName<>'') then send1(ForceFileName,dok,dabort) Else begin
      prfmsg('FBDLHDR','');
      Mpl(60); Input(s,60);
			s:=s+' ';
			While Pos('  ',s)>0 do Delete(s,Pos('  ',s),1);
			FiScan(pl);
			Abort:=FALSE;
			{ Prevent Error 103s. }
			ulffopenb4:=(filerec(ulff).mode<>fmclosed);
			While (Not Abort) And (Pos(' ',s)>0) do begin
				Fil:=Copy(s,1,Pos(' ',s)-1);
				{ If a valid number, use it.. }
				If (Value(Fil)>0) And (cstr(Value(Fil))=Fil) And (Value(Fil)<=pl) Then Begin
					{$I-} reset(Ulff);  {$I+}
					Seek(ulff,Value(Fil)); read(ulff,f);
					if (okdl(f)) then dlx(f,Value(Fil),Abort);
				End Else dl(Fil); { If not a number, use File NAME.}
				Delete(s,1,Pos(' ',s));
			End;
			if (not ulffopenb4) and (filerec(ulff).mode<>fmclosed) then close(ulff);
		End;
end;

{ Inputs Upload Descriptions (Only) }
Procedure dodescrs(var f:ulfrec;              {* file record      *}
									 var v:verbrec;             {* verbose description record *}
									 var pl:integer;            {* # files in dir   *}
									 var tosysop:boolean;       {* whether to-SysOp *}
									 LocalUpload:boolean;
									 var dontprocede:boolean);  {Abort Upload?}
Var
	a,b,i,maxlen:integer;
	isgif:boolean;
	s:string;

	gifsig:astr;
	x,y,c:word;

 Function exitcalled(check:string):boolean;
 Begin
  exitcalled:=FALSE;
  If (not LocalUpload) then exit;
  command_checkstr:=check;

  if (check='.') or
	 (allcaps(check)='.D') or
    (allcaps(check)='.N') or
     (allcaps(check)='.S')
      then exitcalled:=TRUE;
 End;

Begin
  f.fileto:=0;
  if pynq(getmsg('FBISPRVU',f.filename)) then begin
    s:='';
    prfmsg('FBPRVULU','');
		finduser(s,i);
    if i>0 then f.fileto:=i;
  end;

  if (memuboard.basetype=3) and (f.fileto=0) then begin
    prfmsg('FBBFPUO','');
		dontprocede:=false;  {Do not procede with transfer}
		exit;
  end;

  prfmsg('FBULCLS',''); {cls;}

  if localupload then begin
    movexy(1,1);
    sprompt(#3#3'File Area: '+memuboard.name+#3#3'  ('+memuboard.dlpath+')');
    movexy(1,3);
    sprompt(#3#2'['#3#3'.'#3#2']'#3#3' Quit Mass Upload   '#3#2'['#3#3'.S'#3#2']'#3#3' Skip this file');
    movexy(1,4);
    sprompt(#3#2'['#3#3'.N'#3#2']'#3#3' Next Directory    '#3#2'['#3#3'.D'#3#2']'#3#3' Delete this file');
  end;

	if ((tosysop) and (systat.tosysopdir<>255) and
      (systat.tosysopdir>=0) and (systat.tosysopdir<=maxulb)) then begin
    movexy(1,6);
    prfmsg('FBULSYS',systat.sysopname);
	end
  else tosysop:=FALSE;

  If (not LocalUpload) then loaduboard(fileboard);

  maxlen:=30;
(*
  if ((fbusegifspecs in memuboard.fbstat) and (isgif)) then begin
{   dec(maxlen,14);}

   getgifspecs(memuboard.ulpath+sqoutsp(f.filename),gifsig,x,y,c);
   if (gifsig<>'NOTFOUND') then s:='['+cstrl(x)+'x'+cstrl(y)+','+cstr(c)+'c] '
   else s:='[Unknown GIF]';

   buf:=s;
  end;
*)
  movexy(1,8);
  prfmsg('FBULHDR','');
	movexy(1,9);
  prfmsg('FBULHDB','');
  movexy(1,10);
	sprompt(#3#3+f.filename);
  movexy(14,10);

  {This sets all vars to default values - for LocalUpload}
 If LocalUpload then
  with f do begin
   description:='';
   disknums[1]:=0;
   disknums[2]:=0;
   FileInfo:='';
   CrackGroup:='';
	 reservedpassword:='';
   reservedstring:='';
   fileto:=0;
	 for i:=1 to 4 do reserved[i]:=0;

	 vpointer:=-1;
   v.descr[1]:='';
  end;

	repeat
    movexy(14,10);
    cl(5);
    inputl(s,maxlen);

    if (((s[1]='\') or (rvalidate in thisuser.ac))
       and (tosysop) and (not LocalUpload)) then begin
      fileboard:=systat.tosysopdir;
      fiscan(pl);
      tosysop:=TRUE;
    end else
			tosysop:=FALSE;

    if (s='\') and (not LocalUpload) then s:=copy(s,2,length(s)-1);
	until ((s<>'') or (fso) or (hangup));

  f.description:=s;
  If exitcalled(s) then exit;

  movexy(45,10);
	sprompt(#3#2'[');
  movexy(48,10);
  sprompt(#3#3'/');
  movexy(51,10);
  sprompt(#3#2']');
  movexy(46,10);

  repeat
   cl(5);
   f.disknums[1]:=100;
   input(s,2);
	 if (bytevalue(s)>=1) and (bytevalue(s)<=99)
   or ((bytevalue(s)=0) and (s='0')) then f.disknums[1]:=bytevalue(s)
   else {if s='' then} f.disknums[1]:=1;
	until ((f.disknums[1]<100) or (fso) or (hangup));
  If exitcalled(s) then exit;
  movexy(46,10);
  sprompt('  ');
  movexy(46,10);
  sprompt(#3#3+cstr(f.disknums[1]));

  movexy(49,10);
  repeat
   cl(5);
   f.disknums[2]:=100;
   input(s,2);
   if (bytevalue(s)>=1) and (bytevalue(s)<=99)
   or ((bytevalue(s)=0) and (s='0')) then f.disknums[2]:=bytevalue(s)
   else {if s='' then} f.disknums[2]:=1;
  until ((f.disknums[2]<100) or (fso) or (hangup));
  If exitcalled(s) then exit;
	movexy(49,10);
  sprompt('  ');
	movexy(49,10);
	sprompt(#3#3+cstr(f.disknums[2]));

  movexy(53,10);
  sprompt(#3#2'[');
  movexy(60,10);
  sprompt(#3#2']');

  movexy(54,10);
  cl(5);
  inputl(s,6);
  f.FileInfo:=s;
  If exitcalled(s) then exit;

  movexy(62,10);
  cl(5);
  inputl(s,6);
  f.CrackGroup:=s;
	If exitcalled(s) then exit;

  v.descr[1]:='';
	dyny:=FALSE;
  nl;
  if (pynq(getmsg('FBADDVDQ',''))) then begin
    prfmsg('FBVRBHDR','');
    i:=1;
    repeat
      prt(cstr(i)+': ');
      mpl(76);
      inputl(v.descr[i],76);
      if (v.descr[i]='') then i:=10;
      inc(i);
    until ((i=11) or (hangup));
    if (v.descr[1]<>'') then f.vpointer:=nfvpointer
    else prfmsg('FBNOVRBS','');
  end;
	if (v.descr[1]='') then f.vpointer:=-1;
end;


procedure writefv2(f:ulfrec; v:verbrec);
var vfo:boolean;
begin
  if (v.descr[1]<>#1#1#0#1#1) and (f.vpointer<>-1) then begin
    {$I-} reset(verbf); {$I+}
    seek(verbf,f.vpointer); write(verbf,v);
    if (filerec(verbf).mode<>fmclosed) then close(verbf);
  end;
end;

procedure writefv(rn:integer; f:ulfrec; v:verbrec);
var vfo:boolean;
begin
	{$I-} reset(ulff); {$I+}
  seek(ulff,rn);
  write(ulff,f);
	writefv2(f,v);  {I split up this procedure so that I could
                   bypass the begining SEEK and WRITE and
                   not rewrite code anywhere.}

  if (filerec(ulff).mode<>fmclosed) then close(ulff);
end;

procedure newff(f:ulfrec; v:verbrec); {* ulff needs to be open before calling *}
var i,pl:integer;
    fo:boolean;
    f1:ulfrec;
    fileit:file of ulfrec;
begin
  {$I-} reset(ulff); {$I+}
  seek(ulff,0); read(ulff,f1); pl:=f1.blocks;
	if (filerec(ulff).mode<>fmclosed) then close(ulff);

	if (fbdirdlpath in memuboard.fbstat) then
		assign(fileit,memuboard.dlpath+memuboard.filename+'.REV')
  else
		assign(fileit,systat.systempath+memuboard.filename+'.REV');

  rewrite(fileit);
  write(fileit,f1);   {Writes the CONTROL record to the file}
  write(fileit,f);    {Writes the new FILE at the begining of the directory}

	{$I-} reset(ulff); {$I+}
  for I:=1 to pl do begin
    seek(ulff,i); read(ulff,f1);
    write(fileit,f1);
  end;
  {Reads the old directory file and adds to the new one}

  if (filerec(ulff).mode<>fmclosed) then close(ulff);
	if (filerec(fileit).mode<>fmclosed) then close(fileit);
  {Closes the files}

	erase(ulff);      {erase the old directory file}

  if (fbdirdlpath in memuboard.fbstat) then
		rename(fileit,memuboard.dlpath+memuboard.filename+'.DIR')
  else
    rename(fileit,systat.systempath+memuboard.filename+'.DIR');
  {That renames the new file to the correct name.}

  writefv2(f,v);   {Writes the VERBOSE description record
										if one exists}
	fiscan(pl);      {ReAssign ULFF}
  inc(pl); f1.blocks:=pl;
  seek(ulff,0); write(ulff,f1);
  if (filerec(ulff).mode<>fmclosed) then close(ulff);
end;

procedure doffstuff(var f:ulfrec; fn:astr; var gotpts:integer);  { Calculate Points to Award }
var rfpts:real;
begin
	f.filename:=align(fn);
	f.owner:=usernum;
	f.stowner:=thisuser.name;
	f.date:=date;
	f.daten:=daynum(date);
	f.nacc:=0;

	if (not systat.fileptratio) then begin
		f.filepoints:=0;
		gotpts:=0;
	end else begin
		rfpts:=(f.blocks/8)/systat.fileptcompbasesize;
		f.filepoints:=round(rfpts);
		gotpts:=round(rfpts*fpcomp[thisuser.sl]);
		if (gotpts<0) then gotpts:=0;
	end;

	f.filestat:=[];
	if (not fso) and (not systat.validateallfiles) then
		f.filestat:=f.filestat+[notval];
	if (f.fileto>0) then f.filestat:=f.filestat-[notval];
	f.ft:=255; {* filetype *}
end;

{ ARCSTUFF moved to ARCHIVE.PAS - Please Use Roadmap To Find It }

{ Search for Duplicate Uploads }
function searchfordups(completefn:astr):boolean;
var ReadStr,wildfn,nearfn,s:astr;
    i:integer;
    fcompleteacc,fcompletenoacc,fnearacc,fnearnoacc,
    Ok,hadacc,b1,b2:boolean;
    fi:Text;

	procedure searchb(b:integer; fn:astr; var hadacc,fcl,fnr:boolean);
	var f:ulfrec;
      oldboard,pl,rn:integer;
  begin
    oldboard:=fileboard;
    hadacc:=fbaseac(b); { loads in memuboard }
    fileboard:=b;
		recno(fn,pl,rn);
    if (badfpath) then exit;
    while (rn<=pl) and (rn<>0) do begin
      {$I-} Reset(ulff); {$I+}
      seek(ulff,rn); read(ulff,f);
      if (filerec(ulff).mode<>fmclosed) then close(ulff);

			if (align(f.filename)=align(completefn)) then fcl:=TRUE
      else begin
				nearfn:=align(f.filename);
        fnr:=TRUE;
      end;
			nrecno(fn,pl,rn);
    end;
		if (filerec(ulff).mode<>fmclosed) then close(ulff);
    fileboard:=oldboard;
    fiscan(pl);
  end;

begin
 SearchForDups:=TRUE;

 wildfn:=copy(align(completefn),1,9)+'???';

 Assign(fi,systat.SystemPath+'BADUL.CTL');
 {$I-} Reset(fi); {$I+}
 If (IOResult=0) then begin
   Ok:=TRUE;
   While (Not Eof(fi)) and (Ok) do begin
     ReadLn(fi,ReadStr);
     If align(ReadStr)=Align(completefn) then begin
			 Ok:=FALSE;
       prfmsg('FBINBADU',ReadStr);
     End;
	 End;
   Close(fi);
 End;

 If Ok Then Begin
  prfmsg('FBSFDFP','');

  fcompleteacc:=FALSE; fcompletenoacc:=FALSE;
  fnearacc:=FALSE; fnearnoacc:=FALSE;
  b1:=FALSE; b2:=FALSE;

  i:=0;
  while (i<=maxfboard) do begin
    searchb(fconfpk^[i],wildfn,hadacc,b1,b2); { fbaseac loads in memuboard ... }
    loaduboard(fconfpk^[i]);
    if (b1) then begin
			s:='User tried upload "'+sqoutsp(completefn)+'" to #'+cstr(fileboard)+
         '; existed in #'+cstr(fconfpk^[i]);
      if (not hadacc) then s:=s+' - no access to';
      sysoplog(s);
      if (hadacc) then begin
        varstr:=sqoutsp(completefn)+'~'+memuboard.name+'~'+cstr(i);
        prfmsg('FBFAEIB',varstr);
      end else prfmsg('FBFCBA',sqoutsp(completefn));
      prfmsg('FBBADFN','');
      loaduboard(fileboard);
      exit;
    end;
    if (b2) then begin
      s:='User entered upload filename "'+sqoutsp(completefn)+'" in #'+
         cstr(fileboard)+'; was warned that "'+sqoutsp(nearfn)+
         '" existed in #'+cstr(fconfpk^[i])+'.';
			if (not hadacc) then s:=s+' - no access to';
      sysoplog(s);
      nl; nl;
      if (hadacc) then begin
        varstr:=sqoutsp(nearfn)+'~'+memuboard.name+'~'+cstr(i);
        prfmsg('FBWARNA',varstr);
      end else prfmsg('FBWARNB',sqoutsp(nearfn));
      searchfordups:=not pynq(getmsg('FBULANYQ',''));
      loaduboard(fileboard);
			exit;
    end;
    inc(i);
  end;

  prfmsg('FBNODUPS','');
  searchfordups:=FALSE;
  loaduboard(fileboard);
 End;
end;


{ Upload Files }
procedure ul(var abort:boolean; fn:astr; var addbatch:boolean);
var baf:text;
    fi:file of byte;
    f,f1:ulfrec;
    wind:windowrec;
    v:verbrec;
    s:astr;
		xferstart,xferend,tooktime,ulrefundgot1,convtime1:datetimerec;
    ulrefundgot,convtime,rfpts,tooktime1:real;
    cps,lng,origblocks:longint;
    x,rn,pl,cc,oldboard,np,sx,sy,gotpts:integer;
    c:char;
    uls,ok,kabort,convt,aexists,resumefile,wenttosysop,offline:boolean;
begin
	oldboard:=fileboard;
  fiscan(pl);
  if (badulpath) then exit;

  uls:=incom; ok:=TRUE; fn:=align(fn); rn:=0;
  if (fn[1]=' ') or (fn[10]=' ') then ok:=FALSE;
  for x:=1 to length(fn) do
		ok:=(pos(fn[x],'0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ. -@#$%^&()_')<>0);
  np:=0;
  for x:=1 to length(fn) do if (fn[x]='.') then inc(np);
  if (np<>1) then ok:=FALSE;
  if (not ok) then begin
    prfmsg('FBBADFN','');
		exit;
  end;

  {* aexists:    if file already EXISTS in dir
     rn:         rec-num of file if already EXISTS in file listing
     resumefile: if user is going to RESUME THE UPLOAD
		 uls:        whether file is to be actually UPLOADED
     offline:    if uploaded a file to be offline automatically..
  *}

  resumefile:=FALSE; uls:=TRUE; offline:=FALSE; abort:=FALSE;
  aexists:=exist(memuboard.ulpath+fn);

  recno(fn,pl,rn);

  if (badulpath) then exit;
  {nl;}
  if (rn<>0) then begin
    {$I-} reset(ulff); {$I+}
    seek(ulff,rn); read(ulff,f);
		if (filerec(ulff).mode<>fmclosed) then close(ulff);

    resumefile:=(resumelater in f.filestat);
    if (resumefile) then begin
      prfmsg('FBRESFL','');
			resumefile:=((f.owner=usernum) or (fso));
      if (resumefile) then begin
        if (not incom) then begin
          prfmsg('FBNORESL','');
          exit;
        end;
        dyny:=TRUE;
        resumefile:=pynq(getmsg('FBRESULQ',sqoutsp(fn)));
        if (not resumefile) then exit;
			end else begin
        prfmsg('FBNOTULR','');
        exit;
      end;
    end;
  end;
	if ((not aexists) and (not incom)) then begin
    uls:=FALSE;
    offline:=TRUE;
    prfmsg('FBNOTDIR','');
    if not pynq(getmsg('FBWCOFEQ','')) then exit;
  end;
  if (not resumefile) then begin
    if (((aexists) or (rn<>0)) and (not fso)) then begin
      prfmsg('FBFILEEX','');
      exit;
    end;
    if (pl>=memuboard.maxfiles) then begin
      prfmsg('FBDIRFUL','');
      exit;
		end;
    if (not aexists) and (not offline) and
       (freek(exdrv(memuboard.ulpath))<=systat.minspaceforupload)
    then begin
      prfmsg('FBDISKFL','');
      c:=chr(exdrv(memuboard.ulpath)+64);
			if c='@' then
        sysoplog(#3#8+'>>>>'+#3#3+' Main BBS drive full!  Insufficient space to upload a file!')
      else sysoplog(#3#8+'>>>>'+#3#3+' '+c+': drive full!  Insufficient space to upload a file!');
			exit;
    end;
    if (aexists) then begin
      uls:=FALSE;
      prfmsg('FBUSING',sqoutsp(memuboard.ulpath+fn));
      if (rn<>0) then prfmsg('FBELIST','');
      dyny:=(rn=0);
      if (locbatup) then begin
        prfmsg('FBQORUL',syn(dyny));
        onekcr:=FALSE; onekda:=FALSE;
				onek(c,'QYN'^M);
        if (rn<>0) then ok:=(c='Y') else ok:=(c in ['Y',^M]);
        abort:=(c='Q');
        if (abort) then print('Quit') else  (* STANDARDIZE YES NO QUIT STUFF *)
          if (not ok) then print('No') else print('Yes');
      end else
        ok:=pynq(getmsg('FBULDISQ',''));
      rn:=0;
		end;

    if ((systat.searchdup) and (ok) and (not abort) and (incom)) then
      if (searchfordups(fn)) then exit;

    loaduboard(fileboard);

    if (uls) then begin
      dyny:=TRUE;
      ok:=pynq(getmsg('FBULFNQ',sqoutsp(fn)));
    end;
    if ((ok) and (uls) and (not resumefile)) then begin
			assign(fi,memuboard.ulpath+fn);
      {$I-} rewrite(fi); {$I+}
      if ioresult<>0 then begin
        if (filerec(ulff).mode<>fmclosed) then close(ulff);
        cc:=ioresult;
        ok:=FALSE;
			end else begin
				if (filerec(ulff).mode<>fmclosed) then close(ulff);
        erase(fi);
      end;
      if (not ok) then begin
        prfmsg('FBUULFN','');
        exit;
      end;
    end;
  end;

  if (not ok) then exit;
  wenttosysop:=TRUE;
  if (not resumefile) then begin
		f.filename:=align(fn);
    dodescrs(f,v,pl,wenttosysop,FALSE,ok);
    if not ok then exit;
  end;
  ok:=TRUE;
  if (uls) then begin
		showuserfileinfo;
    getdatetime(xferstart);

    receive1(memuboard.ulpath+fn,FALSE,resumefile,ok,kabort,addbatch);

    if (addbatch) then begin
      inc(numubatchfiles);
      ubatch[numubatchfiles].fn:=sqoutsp(fn);
      with ubatch[numubatchfiles] do begin
        fileto:=f.fileto;
        section:=fileboard;
        description:=f.description;
        DiskNumbers[1]:=f.disknums[1];
        DiskNumbers[2]:=f.disknums[2];
				FileInfo:=f.FileInfo;
        CrackGroup:=f.CrackGroup;
        if (v.descr[1]<>'') then begin
          inc(hiubatchv);
          new(ubatchv[hiubatchv]);    {* define dynamic memory *}
					ubatchv[hiubatchv]^:=v;
					vr:=hiubatchv;
        end else
          vr:=0;
      end;
      prfmsg('FBNUMINQ',cstr(numubatchfiles));
      fileboard:=oldboard;
      exit;
    end else begin
      getdatetime(xferend);
			timediff(tooktime,xferstart,xferend);
    end;

    if (kabort) then begin
			fileboard:=oldboard;
      exit;
		end;

    ulrefundgot:=(dt2r(tooktime))*(systat.ulrefund/100.0);
    freetime:=freetime+ulrefundgot;
    prfmsg('FBGAVREF',ctim(ulrefundgot));

    showuserfileinfo;

    if (not kabort) then prfmsg('FBXFERC','');
  end;
{  nl;}

  convt:=FALSE;
	if (not offline) then begin
		assign(fi,memuboard.ulpath+fn);
    {$I-} reset(fi); {$I+}
		if (ioresult<>0) then ok:=FALSE
    else begin
      f.blocks:=trunc((filesize(fi)+127.0)/128.0);
			close(fi);
      if (f.blocks=0) then ok:=FALSE;
      origblocks:=f.blocks;
    end;
  end;

  if ((ok) and (not offline)) then begin
		arcstuff(ok,convt,f.blocks,convtime,uls,memuboard.ulpath,fn,f.description);
    doffstuff(f,fn,gotpts);
    FILE_ID_DIZ(fn,False,v,f);
    if (ok) then begin
      if ((not resumefile) or (rn=0)) then newff(f,v) else writefv(rn,f,v);

      if (uls) then begin
				if (aacs(systat.ulvalreq)) then begin
          inc(thisuser.uploads);
					inc(thisuser.uk,f.blocks div 8);
        end;
        inc(systat.todayzlog.uploads);
        inc(systat.todayzlog.uk,f.blocks div 8);
			end;

      s:=#3#3+'Upload "'+sqoutsp(fn)+'" on '+memuboard.name;
      if (uls) then begin
        tooktime1:=dt2r(tooktime);
        if (tooktime1>=1.0) then begin
          cps:=f.blocks; cps:=cps*128;
          cps:=trunc(cps/tooktime1);
        end else
          cps:=0;
        s:=s+#3#3+' ('+cstr(f.blocks div 8)+'k, '+ctim(tooktime1)+
             ', '+cstr(cps)+' cps)';
      end;
      sysoplog(s);
			if ((incom) and (uls)) then begin
				if (convt) then begin
          lng:=origblocks*128;
          prfmsg('FBORGSIZ',cstrl(lng));
        end;
        lng:=f.blocks; lng:=lng*128;
        if (convt) then prfmsg('FBNEWSIZ',cstrl(lng))
          else prfmsg('FBREGSIZ',cstrl(lng));
        prfmsg('FBUPLTIM',longtim(tooktime));
        r2dt(convtime,convtime1);
        if (convt) then
          prfmsg('FBCVTTIM',longtim(convtime1));
        prfmsg('FBXFRRAT',cstr(cps));
        r2dt(ulrefundgot,ulrefundgot1);
        prfmsg('FBTIMREF',longtim(ulrefundgot1));
        if (gotpts<>0) then
          prfmsg('FBGOTPTS',cstr(gotpts));
        prfmsg('FBOUTNL','');
        if (choptime<>0.0) then begin
					choptime:=choptime+ulrefundgot;
          freetime:=freetime-ulrefundgot;
          prfmsg('FBNOTNOW','');
        end;
				doul(gotpts);
      end
      else prfmsg('FBENTADD','');
    end;
  end;
  if (not ok) and (not offline) then begin
    if (exist(memuboard.ulpath+fn)) then begin
      prfmsg('FBULNOTR','');
      s:='file deleted';
      if ((thisuser.sl>0 {systat.minresumelatersl} ) and
          (f.blocks div 8>systat.minresume)) then begin
        nl; dyny:=TRUE; (* LEAVE IT IN FOR NOW BUT I DONT WANT TO! *)
        if pynq(getmsg('FBSAVFRQ','')) then begin
					doffstuff(f,fn,gotpts);
					f.filestat:=f.filestat+[resumelater];
          if (not aexists) or (rn=0) then newff(f,v) else writefv(rn,f,v);
					s:='file saved for later resume';
        end;
      end;
			if (not (resumelater in f.filestat)) then begin
        if (exist(memuboard.ulpath+fn)) then begin
					assign(fi,memuboard.ulpath+fn);
					{$I-} erase(fi); {$I+}
        end;
      end;
      sysoplog(#3#3+'Error Uploading "'+sqoutsp(fn)+'" - '+s);
    end;
    prfmsg('FBTAKREF',ctim(ulrefundgot));
    freetime:=freetime-ulrefundgot;
  end;
  if (offline) then begin
		f.blocks:=10;
    doffstuff(f,fn,gotpts);
		f.filestat:=f.filestat+[isrequest];
    newff(f,v);
  end;
	fileboard:=oldboard;
	fiscan(pl);
	if (filerec(ulff).mode<>fmclosed) then close(ulff);
end;

procedure iul;
var s:astr;
    pl:integer;
    c:char;
    abort,done,addbatch:boolean;
begin
	loaduboard(fileboard);
	fiscan(pl);
  if (badulpath) then exit;
	if (memuboard.basetype=2) or (not aacs(memuboard.ulacs)) then begin
    prfmsg('FBNOULH','');
    exit;
	end;
  locbatup:=FALSE;
  if (incom) then printf('upload');
{  nl;}
  repeat
    prfmsg('FBUPLOAD','');
		done:=TRUE; addbatch:=FALSE;
    prfmsg('FBGETFNP',''); mpl(12); input(s,12); s:=sqoutsp(s);
    if (s<>'') then
      if (not fso) then ul(abort,s,addbatch)
      else begin
        if (not iswildcard(s)) then ul(abort,s,addbatch)
        else begin
          locbatup:=TRUE;
					ffile(memuboard.ulpath+s);
          if (not found) then prfmsg('FBNOFILF','') else
            repeat
              if not ((dirinfo.attr and VolumeID=VolumeID) or
                      (dirinfo.attr and Directory=Directory)) then
								ul(abort,dirinfo.name,addbatch);
							nfile;
            until (not found) or (abort);
        end;
      end;
    done:=(not addbatch);
	until (done) or (hangup);
end;

procedure fbaselist;
var AreaFileName,Header1,Header2,Header3,Header4,Footer1,Footer2,Body,s,s1,os:astr;
		TotFiles,nd,b,b2,i:integer;
    abort,next,acc:boolean;
    AreaListF:text;
    f:ulfrec;


Procedure AreaList;
Var
	Acc,Abort,Next,FoundFile:Boolean;
	InF:Text;
	AreaFile,Temp,Work:String;
  BoardNum:String[5];

	Function YesNo(InBoo:Boolean):String;
  Begin
		If InBoo then YesNo:='Yes' Else YesNo:='No ';
  End;

Begin
	If ThisUser.AreaListNumber>0 then begin
		AreaFile:=Systat.TextPath+'FIL'+cstr(ThisUser.AreaListNumber);
		AreaFile:=GetTextFileName(AreaFile);
		If AreaFile='' then FoundFile:=FALSE Else FoundFile:=TRUE;
	End Else FoundFile:=FALSE;

  Abort:=FALSE;
  Next:=FALSE;

	If FoundFile then begin
		Assign(InF,AreaFile);
		Reset(InF);
	end;

	CfgListTOP(FoundFile,InF,2);

	If FoundFile then ReadLn(InF,Temp);

	b:=0;

	While (b<=maxfboard) and (not abort) do begin
		acc:=fbaseac(fconfpk^[b]);       { fbaseac will load memuboard }
		If ((fbunhidden in memuboard.fbstat) or (acc)) then begin
			If (Not FoundFile) or (Pos('AT',Temp)<>0) then begin
        TotFiles:=0;
        If (fbdirdlpath in memuboard.fbstat) then
          Assign(ulff,memuboard.dlpath+memuboard.filename+'.DIR')
        Else
          Assign(ulff,systat.SystemPath+memuboard.filename+'.DIR');
        {$I-} Reset(ulff); {$I+}
        If (IOResult=0) then begin
          Seek(ulff,0);
          Read(ulff,f);
          TotFiles:=f.blocks;
          Close(ulff);
        End;
      End;

			If (acc) then BoardNum:=cstr(b) Else BoardNum:='';

      If Not FoundFile then begin
{  printacr(#3#9' '#3#7+BoardNum+Ins(3,BoardNum)
	+' '+memuboard.name+Ins(40,StripColor(memuboard.name))+' '#3#2+YesNo(checkzscanf(fconfpk^[b]))
	+'  '+YesNo(Not (fbnoratio in memuboard.fbstat))
  +'   '#3#7+cstr(TotFiles)+Ins(4,cstr(TotFiles))+#3#9' ',abort,next)}
        varstr:=boardnum+'~'+memuboard.name+'~'+yesno(checkzscanf(fconfpk^[b]));
        varstr:=varstr+'~'+yesno(not (fbnoratio in memuboard.fbstat))+'~'+cstr(totfiles);
        abort:=prfmsga('FBALISTO',varstr);
      End Else begin
	Work:=Temp;

	If (memuboard.arctype=0) then ReplaceCode('AA','N/A',3,Work)
        Else ReplaceCode('AA',systat.filearcinfo[memuboard.arctype].ext,3,Work);

        ReplaceCode('AD',memuboard.name,40,Work);
				ReplaceCode('AG',YesNo(fbusegifspecs in memuboard.fbstat),0,Work);
        ReplaceCode('AN',BoardNum,0,Work);
        ReplaceCode('AO',Ins(3,BoardNum),0,Work);
        ReplaceCode('AR',YesNo(Not (fbnoratio in memuboard.fbstat)),0,Work);
        ReplaceCode('AS',YesNo(checkzscanf(fconfpk^[b])),0,Work);
        ReplaceCode('AT',cstr(TotFiles),4,Work);
				PrintAcr(Work,Abort,Next);
      End;
      Inc(nd);
    End;
    inc(b);
	End;

  CfgListBOT(FoundFile,InF,2);
	If FoundFile then Close(InF);
End;

begin
  prfmsg('FBALISTP','');
  abort:=FALSE;
	s:=''; b:=0; nd:=0;
  AreaList;
  If (nd=0) then prfmsg('FBNOBASE','');
end;

procedure unlisted_download(s:astr);
var dok,kabort:boolean;
		pl,oldnumbatchfiles,oldfileboard:integer;
begin
  if (s<>'') then begin
    if (not exist(s)) then prfmsg('FBNOFILE','')
    else if (iswildcard(s)) then prfmsg('FBNOWILD','')
      else begin
        oldnumbatchfiles:=numbatchfiles;
        oldfileboard:=fileboard; fileboard:=-1;
        send1(s,dok,kabort);
        if (numbatchfiles=oldnumbatchfiles) and (dok) and (not kabort) then
          dodl(5);
        fileboard:=oldfileboard;
      end;
	end;
end;

procedure do_unlisted_download;
var s:astr;
begin
  prfmsg('FBEFNDL',''); mpl(78); input(s,78);
	unlisted_download(s);
end;

function nfvpointer:longint;
var i,x:integer;
    v:verbrec;
begin
  {$I-} reset(verbf); {$I+}
	x:=filesize(verbf);
	for i:=0 to filesize(verbf)-1 do begin
		seek(verbf,i); read(verbf,v);
		if (v.descr[1]='') then x:=i;
  end;
	if (filerec(verbf).mode<>fmclosed) then close(verbf);
  nfvpointer:=x;
end;

procedure newuserupload(var descript:astr; var fname:astr);
var
	ulf:file of ulrec;
  f:ulfrec;
  convtime:real;
	abort,uls,convt,addbatch,heisdone,ok,wenttosysop,resumefile,kabort:boolean;
  np,x,rn,pl,gotpts,dump:integer;
  s:astr;
  v:verbrec;
begin
  abort:=false;
  addbatch:=false;
  heisdone:=false;
  ok:=false;
	kabort:=false;
	resumefile:=false;
  uls:=true;

  assign(ulf,systat.systempath+'UPLOADS.DAT');
  reset(ulf);
	read(ulf,memuboard);
  close(ulf);

	fileboard:=0;

	if exist(systat.systempath+memuboard.filename+'.DIR') then
    assign(ulff,systat.systempath+memuboard.filename+'.DIR')
  else if exist(memuboard.dlpath+memuboard.filename+'.DIR') then
    assign(ulff,memuboard.dlpath+memuboard.filename+'.DIR');

  {$I-} reset(ulff); {$I+}
  seek(ulff,0); read(ulff,f); pl:=f.blocks;
  bnp:=false;
  if (filerec(ulff).mode<>fmclosed) then close(ulff);
	{Initialize Variables For File Section}

  repeat
    printf('VALULOAD');
    prfmsg('FBGETFNP',''); mpl(12); input(s,12); s:=sqoutsp(s);
    if (s<>'') then begin
			uls:=incom; ok:=TRUE; s:=align(s); rn:=0;
      if (s[1]=' ') or (s[10]=' ') then ok:=FALSE;
      for x:=1 to length(s) do
        ok:=(pos(s[x],'0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ. -@#$%^&()_')<>0);
      np:=0;
			for x:=1 to length(s) do if (s[x]='.') then inc(np);
      if (np<>1) then ok:=FALSE;
      if (not ok) then prfmsg('FBBADFN','');
      if ok then begin
        f.filename:=align(s);
        dodescrs(f,v,pl,wenttosysop,FALSE,ok);
        if ok then begin
          showuserfileinfo;
          receive1(memuboard.ulpath+s,FALSE,resumefile,ok,kabort,addbatch);
					if kabort then ok:=false;
          if addbatch then ok:=false;
          if (ok) then begin
            convt:=false;
            gotpts:=0;
            FILE_ID_DIZ(f.filename,False,v,f);
						arcstuff(ok,convt,f.blocks,convtime,uls,memuboard.ulpath,s,f.description);
            doffstuff(f,s,gotpts);
            if (ok) then begin
              newff(f,v);
              heisdone:=true;
							descript:=f.description; fname:=f.filename;
            end;
          end;
        end;
      end;
    end;
    if not heisdone then prfmsg('FBNULVAL','');
  until heisdone or hangup;
end;

Procedure FILE_ID_DIZ(fn:astr;IsBatchUL:Boolean;var v:verbrec;var f:ulfrec);
var
  tempv:verbrec;
  diz:text;
  dizstr:string[80];
	dizcnt:byte;
  dump:integer;
  abort:boolean;
	next,done,tempok:boolean;
	OldPointerExists:boolean;

begin

	if (systat.UseFILE_ID_DIZ) then begin

		OldPointerExists:=False;
		if f.vpointer <> -1 then begin  {If an old pointer/verbose exists, save in temp var.}
			OldPointerExists:=TRUE;
			{$I-} reset(verbf); {$I+}
			seek(verbf,f.vpointer);  read(verbf,v);
			tempv:=v;
		end;

		if IsBatchUL then arcdecomp(tempok,arctype(fn),WorkPath+'2\'+fn,'FILE_ID.DIZ')
			else arcdecomp(tempok,arctype(fn),memuboard.ulpath+fn,'FILE_ID.DIZ');

		if exist(WorkPath+'1\FILE_ID.DIZ') then begin
			assign(diz,WorkPath+'1\FILE_ID.DIZ');
			reset(diz);
			for dizcnt:=1 to 10 do v.descr[dizcnt]:='';
			dizcnt:=1; dizstr:='';

			if ( (systat.UsersDecideDIZ) and (not hangup) ) then begin
				abort:=FALSE; next:=FALSE;
        prfmsg('FBDIZFND','');
				while (dizcnt<=10) and (not (eof(diz))) and (not abort) do begin {Display DIZ}
					readln(diz,dizstr);
          prfmsg('FBDIZOUT',dizstr);
					inc(dizcnt);
				end;
				dyny:=TRUE;
        if pynq(getmsg('FBATTVBQ','')) then begin
					dizcnt:=1; dizstr:=''; reset(diz);
					while (dizcnt<=10) and (not (eof(diz))) do begin
						readln(diz,dizstr);
						if (dizstr='') then dizstr:=' ';
						v.descr[dizcnt]:=dizstr;
						inc(dizcnt);
					end;
				end else if OldPointerExists then v:=tempv;   {If new DIZ not used, restore old one.}
				dyny:=FALSE;
			end else begin   { if UsersDecideDIZ=False or if the user hungup }
				while (dizcnt<=10) and (not (eof(diz))) do begin
					readln(diz,dizstr);
					if (dizstr='') then dizstr:=' ';
					v.descr[dizcnt]:=dizstr;
					inc(dizcnt);
				end;
			end;
			close(diz);
			erase(diz);
			if (OldPointerExists=False) then f.vpointer:=nfvpointer;
		end;
	end;

end;

end.
