{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit file11;

interface

uses
  crt,dos,overlay,
  myio,
  common;

function cansee(f:ulfrec):boolean;
procedure fbasechange(var done:boolean; mstr:astr);
procedure createtempdir;
procedure fbasestats;

implementation

Uses Emulate, file0, file1;


function cansee(f:ulfrec):boolean;
begin
  cansee:=((not (notval in f.filestat)) or (aacs(systat.seeunval)));
end;

function isulr:boolean;
begin
  isulr:=((systat.uldlratio) and (not systat.fileptratio));
end;


procedure fbasechange(var done:boolean; mstr:astr);
var s:astr;
    i,temp:integer;
    count:byte;
begin
  if (mstr<>'') then
    case mstr[1] of
      '+':begin
            i:=realfbase(fileboard);
            if i<maxfboard then begin
              changefileboard(fconfpk^[i+1]);
              lastcommandovr:=true;
            end else prfmsg('FBHIBASE','');
          end;
      '-':begin
            i:=realfbase(fileboard);
            if i>0 then begin
              changefileboard(fconfpk^[i-1]);
              lastcommandovr:=true;
            end else prfmsg('FBLOBASE','');
          end;
      'L':fbaselist;
    else  begin
            temp:=value(mstr);
            if (temp>=0) and (temp<=maxfboard) then begin
              changefileboard(fconfpk^[temp]);
              lastcommandovr:=true;
            end else prfmsg('FBNOTINR','');
          end;
  end else begin
    if (novice in thisuser.ac) then fbaselist;
   {nl;}
    s:='?';
    repeat
      prfmsg('FBCHGBAS','');
      input(s,3);
      if s[1] in ['0'..'9'] then begin
        i:=value(s);
        if (((i>=0) and (i<=maxfboard)) or
           ((i=0) and (copy(s,1,1)='[0'))) and
           (i<>fileboard) then
          changefileboard(fconfpk^[i]);
      end;
      if (s='?') then begin fbaselist; nl; end;
    until (s<>'?') or (hangup);
    lastcommandovr:=TRUE;
  end;
end;

procedure createtempdir;
var s:astr;
    i:integer;
begin
  if (maxulb=maxuboards) then prfmsg('FBTOOMNY','')
  else begin
    prfmsg('FBENTTMP',''); mpl(40); input(s,40);
    if (s<>'') then begin
      s:=fexpand(bslash(TRUE,s));
      fileboard:=maxulb+1;
      sysoplog('Created temporary directory #'+cstr(fileboard)+
               ' in "'+s+'"');
      with tempuboard do begin
        name:='<< Temporary >>';
        filename:='TEMPFILE';
        dlpath:=s;
        ulpath:=s;
        maxfiles:=2000;
        password:='';
        arctype:=0;
        cmttype:=1;
        fbdepth:=0;
        fbstat:=[];
        acs:='s'+cstr(thisuser.sl)+'d'+cstr(thisuser.dsl);
        ulacs:='s'+cstr(thisuser.sl)+'d'+cstr(thisuser.dsl);
        nameacs:='s'+cstr(thisuser.sl)+'d'+cstr(thisuser.dsl);
        for i:=1 to 6 do res[i]:=0;
      end;
      memuboard:=tempuboard;
    end;
  end;
end;

procedure fbasestats;
var s:astr;

  function dv(s:string; b:boolean):string; (* Determine Variable *)
  begin
    if (b) then dv:=s else dv:='None.';
  end;

begin
  loaduboard(fileboard);
  with memuboard do begin
    prfmsg('FBBINFH',memuboard.name);

    varstr:=dv('"'+password+'"',(password<>''));
    varstr:=varstr+'~'+dv(cstr(maxfiles),(maxfiles<>0));
    varstr:=varstr+'~'+dv('"'+systat.filearcinfo[arctype].ext+'"',(arctype<>0));
    case basetype of
      0:varstr:=varstr+'~'+'"Upload And Download"';
      1:varstr:=varstr+'~'+'"Upload Only"';
      2:varstr:=varstr+'~'+'"Download Only"';
      3:varstr:=varstr+'~'+'"Private Only"';
    end;
    prfmsg('FBBINFB',varstr);
    if (fso) then begin
      varstr:='"'+filename+'.DIR"'+'~'+'"'+dlpath+'"';
      prfmsg('FBBINFS',varstr);
    end;
  end;
end;
end.
