{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit file12;

interface

uses
  crt,dos,overlay,
	file0, file1, file2, file6, file9,
	execbat, archive,
  mmodem,
  common;

procedure delubatch(n:integer);
procedure listubatchfiles;
procedure removeubatchfiles;
procedure clearubatch;
procedure batchul;
procedure batchinfo;

implementation

procedure delubatch(n:integer);
var c:integer;
begin
  if ((n>=1) and (n<=numubatchfiles)) then begin
    if (n<>numubatchfiles) then
      for c:=n to numubatchfiles-1 do ubatch[c]:=ubatch[c+1];
    dec(numubatchfiles);
  end;
end;

procedure listubatchfiles;
var s,s1:astr;
    i,j:integer;
    abort,next:boolean;
begin
  if (numubatchfiles=0) then
    prfmsg('FBUBQEMP','')
  else begin
    prfmsg('FBBUQHDR','');
    i:=1;
		while ((not abort) and (i<=numubatchfiles) and (not hangup)) do begin
      with ubatch[i] do begin
        if (section=systat.tosysopdir) then s1:='SysOp '
          else s1:=mrn(cstr(section),6);
        varstr:=mn(i,3)+'~'+align(fn)+'~'+s1+'~'+description;
        prfmsg('FBBUQLST',varstr);
        if (vr<>0) then
          if (ubatchv[vr]^.descr[1]<>'') then begin

            {$I-} reset(verbf); {$I+}
            if (ioresult=0) then
							for j:=1 to 4 do
                if ubatchv[vr]^.descr[j]='' then j:=4 else
                  prfmsg('FBBUQVRB',ubatchv[vr]^.descr[j]);

            if (filerec(verbf).mode<>fmclosed) then close(verbf);
          end;
      end;
      inc(i);
    end;
  end;
end;

procedure removeubatchfiles;
var s:astr;
    i:integer;
begin
  if (numubatchfiles=0) then
    prfmsg('FBUBQEMP','')
  else
		repeat
      prfmsg('FBRUQP',cstr(numubatchfiles));
      input(s,2); i:=value(s);
      if (s='?') then listubatchfiles;
      if ((i>0) and (i<=numubatchfiles)) then begin
        prfmsg('FBFOOUQ',stripname(ubatch[i].fn));
        delubatch(i);
      end;
      if (numubatchfiles=0) then prfmsg('FBUQNE','');
    until (s<>'?');
end;

procedure clearubatch;
begin
  prfmsg('FBCUQP','');
  if pynq(getmsg('FBCLRUQQ','')) then begin
    numubatchfiles:=0;
    prfmsg('FBUQNE','');
  end;
end;

procedure batchul;
var fi:file of byte;
		dirinfo:searchrec;
		f:ulfrec;
		v:verbrec;
		tott:real;
		n:integer;
		batfile:text;
		toxfer:integer;
		readlog:boolean;
		pointsreqd:longint;


		tblks,tblks1:longint;
		tpts,tpts1,tnfils,tnfils1:integer;

		xferstart,xferend,tooktime,takeawayulrefundgot1,ulrefundgot1:datetimerec;
		tconvtime1,st1:datetimerec;
		pc,fn,s:astr;
		st,tconvtime,convtime,ulrefundgot,takeawayulrefundgot:real;
		totb,totfils,totb1,totfils1,cps,lng,totpts:longint;
		i,p,hua,pl,dbn,blks,gotpts,ubn,filsuled,oldboard,passn:integer;
		c:char;
		abort,ahangup,next,done,dok,kabort,wenttosysop,ok,convt,
			beepafter,fok,nospace,savpause:boolean;

	function notinubatch(fn:astr):boolean;
	var i:integer;
	begin
		notinubatch:=FALSE;
		for i:=1 to numubatchfiles do
			if (sqoutsp(fn)=sqoutsp(ubatch[i].fn)) then exit;
		notinubatch:=TRUE;
	end;

	function ubatchnum(fn:astr):integer;
	var i:integer;
	begin
		fn:=sqoutsp(fn);
		ubatchnum:=0;
		for i:=1 to numubatchfiles do
			if (fn=sqoutsp(ubatch[i].fn)) then ubatchnum:=i;
	end;

	function plural:string;
	begin
		if (totfils<>1) then plural:='s' else plural:='';
	end;

	procedure processhangup;
	begin
		ahangup:=FALSE;
		if (hangup) then begin
			if (spd<>'KB') then begin
				commandline('Hanging up and taking phone off hook...');
				dophonehangup(FALSE);
				dophoneoffhook(FALSE);
				spd:='KB';
			end;
			ahangup:=TRUE;
		end;
	end;




begin
	{Prevent pausing in this routine.}
	savpause:=(pause in thisuser.ac);
	if (savpause) then thisuser.ac:=thisuser.ac-[pause];
	{Save current board # for unlisted ULs}
	oldboard:=fileboard;
	beepafter:=FALSE; done:=FALSE;
	if (numubatchfiles=0) then begin
		printf('batchul0');
    if (nofile) then prfmsg('FBNFSWRN','');
	end else begin
		printf('batchul');
    if (nofile) then prfmsg('FBFIAWRN','');
	end;
	reset(xf);
	done:=FALSE;
	repeat
    prfmsg('FBBPROTP','');
    mpkey(s);
		if (s='?') then begin
      prfmsg('FBBFSP','');
			showprots(TRUE,FALSE,TRUE,FALSE);
		end else begin
			p:=findprot(s,TRUE,FALSE,TRUE,FALSE);
      if (p=-99) then prfmsg('FBPINVE','') else done:=TRUE;
		end;
	until (done) or (hangup);
	if (p<>-10) then begin
		seek(xf,p); read(xf,protocol); close(xf);
    prfmsg('FBHUAXF','');
		onek(c,'ANYM'^M); if c=^M then c:='N';
		hua:=pos(c,'ANYM');
		dok:=TRUE;
		if (hua<>1) then begin
			if (hua<>3) then begin
        prfmsg('FBBATPV','');
				dyny:=TRUE;
        beepafter:=pynq(getmsg('FBBEEPAQ',''));
			end;

			lil:=0;
      if (useron) then prfmsg('FBRTRBQ','');
			lil:=0;

			{ Checks if okay to DL Files if BiDirectional }

			if (protocol.bidirect) then begin
				tott:=0.0;
				pointsreqd:=0;
				for n:=1 to numbatchfiles do begin
					tott:=tott+batch[n].tt;
					pointsreqd:=pointsreqd+batch[n].pts;
				end;

        varstr:=cstr(numbatchfiles)+'~'+ctim(tott)+'~'+ctim(nsl);
        prfmsg('FBBDBDLR',varstr);

				if (tott>nsl) then begin
          prfmsg('FBRFQIT','');
					exit;
				end;

				if (thisuser.filepoints<pointsreqd) and (pointsreqd>0) and
           (not aacs(systat.nofilepts)) and         {No FP Checking for user}
           (not (fnofilepts in thisuser.ac)) and    {User Flag 3}
					 (systat.fileptratio) then begin      {Use FP Ratios?}
              prfmsg('FBDLIFP','');
							exit;
					 end;


        if (hua<>1) then begin
          tblks:=0; tpts:=0; tnfils:=0;
          tblks1:=0; tpts1:=0; tnfils1:=0;
          {nl; nl;}

          { Writes FI.LST For BiDirectional DL }

					if (protocol.dlflist<>'') then begin
            tott:=0.0;
						assign(batfile,bproline1(protocol.dlflist));
						rewrite(batfile);
            for n:=1 to numbatchfiles do begin
              writeln(batfile,batch[n].fn);
							inc(toxfer); tott:=tott+batch[n].tt;
						end;
						close(batfile);
					end;
					(* delete old log file *)
					if (exist(bproline1(protocol.templog))) then begin
            assign(batfile,bproline1(protocol.templog));
            {$I-} erase(batfile); {$I+}
          end;

        end;
			end;  {End BiDirectional Krap}

      getdatetime(xferstart);
			if (useron) then shel(caps(thisuser.name)+' Is Batch Uploading!')
									else shel('Receiving File(s)...');
      if (protocol.bidirect) then NodeUpDate(getmsg('NDBIDXFR',''))
                             else NodeUpDate(getmsg('NDBULFIL',''));
			execbatch(dok,FALSE,'tgtemp1.bat','tgtest1.$$$',WorkPath+'2\',
								bproline1(Systat.ProtocolPath+protocol.ulcmd),-1);
      NodeUpDate(getmsg('NDAVL4PG',''));
			shel2;
			getdatetime(xferend);
			timediff(tooktime,xferstart,xferend);

			if (protocol.bidirect) then
				figuresucc(dok,readlog,tnfils,tblks,tpts,tnfils1,tblks1,tpts1,toxfer);

			showuserfileinfo;
			commandline('');
      {nl; nl;}
			if (protocol.bidirect) then ulrefundgot:=(dt2r(tooktime))*(systat.ulrefund/200.0)
														 else ulrefundgot:=(dt2r(tooktime))*(systat.ulrefund/100.0);
			if (ulrefundgot < 0) then ulrefundgot:=0;
			freetime:=freetime+ulrefundgot;

			{*****}

      lil:=0;
      if (protocol.bidirect) then prfmsg('FBBDXFC','')
                             else prfmsg('FBBUXFC','');

			if (protocol.bidirect) then begin
				DisplayDLStats(tnfils,tnfils1,lng,tpts,tblks,tblks1,tpts1);
				systat.todayzlog.downloads:=systat.todayzlog.downloads+tnfils;
				systat.todayzlog.dk:=systat.todayzlog.dk + (tblks div 8);
				CheckForUnSentDLs(tblks,tpts,lng);
			end;

			lil:=0;

			tconvtime:=0.0; takeawayulrefundgot:=0.0;
			totb:=0; totfils:=0; totb1:=0; totfils1:=0; totpts:=0;

			findfirst(WorkPath+'2\*.*',anyfile-directory-volumeid,dirinfo);  {iM Test " -volumeid ".}
			while (doserror=0) do begin
				inc(totfils1);
				inc(totb1,dirinfo.size);
				findnext(dirinfo);
			end;

			{Prevent division by zero.}
			if dt2r(tooktime)=0 then cps:=0 else
			cps:=trunc(totb1/dt2r(tooktime));

			abort:=FALSE; next:=FALSE;


			if (totfils1=0) then begin
        prfmsg('FBNUDXA','');
				exit;
			end;

			case hua of
				3:hangup:=TRUE;
				4:begin
						lil:=0;
             prfmsg('FBHULCM','');
						 st:=timer;
						 while (tcheck(st,30)) and (empty) do;
						 if (empty) then hangup:=TRUE;
						 if (not empty) then
							 if upcase(inkey)='H' then hangup:=TRUE;
						lil:=0;
					end;
			end;

			ProcessHangup;

			r2dt(ulrefundgot,ulrefundgot1);
			if (not ahangup) then begin
        prfmsg('FBPAKFUS','');
				if (beepafter) then begin
					i:=1;
					repeat
						if (s<>time) then begin prompt(^G#0#0#0^G); s:=time; inc(i); end;
					until ((i=30) or (not empty) or (hangup));
				end;
				getkey(c);
{       for i:=1 to 33 do prompt(^H' '^H);}

        prfmsg('FBULSDET','');
				dir(WorkPath+'2\','*.*',TRUE);
        varstr:=cstr(totfils1)+'~'+cstrl(totb1)+'~'+longtim(tooktime)+'~'+cstr(cps)+'~'+longtim(ulrefundgot1);
        prfmsg('FBBUDST',varstr);
        pausescr;
			end;

			fiscan(pl);

			{  files not in the upload batch queue get prompted for info in the  }
			{	 first section -- files IN the queue info passed on in the second. }
				dbn := fileboard;
				findfirst(WorkPath+'2\*.*',anyfile-directory-volumeid,dirinfo);  {iM Test " -volumeid ".}
				while (doserror=0) do begin
					fn:=sqoutsp(dirinfo.name);
          {nl;}
					if (notinubatch(fn)) then begin
						ubn:=0;
            prfmsg('FBFNIBQ',fn);

						fiscan(pl);
						wenttosysop:=FALSE;
						f.filename:=fn;
						if (not ahangup) then dodescrs(f,v,pl,wenttosysop,FALSE,fok);
						ProcessHangup;
						if (fok or ahangup) then begin
							if (ahangup) then begin
								f.description:='Not In Upload Batch Queue - Hungup After Transfer';
								f.vpointer:=-1; v.descr[1]:='';
								f.disknums[1]:=0; f.disknums[2]:=0;
								f.fileto:=0; f.fileinfo:=''; f.crackgroup:='';
							end;
							if (not wenttosysop) or (ahangup) then begin
                {nl;}
								done:=FALSE;
								fileboard:=oldboard;     {iM Test (WORKS?)- change dbn to oldboard}
                {nl;}
							end;
							FILE_ID_DIZ(f.filename,True,v,f);
							ProcessHangup;
						end;
					end else {if in batch queue}
						begin
              prfmsg('FBFFIBQ',fn);
							ubn:=ubatchnum(fn);

							f.description:=ubatch[ubn].description;
							f.disknums[1]:=ubatch[ubn].DiskNumbers[1];
							f.disknums[2]:=ubatch[ubn].DiskNumbers[2];
							f.fileto:=ubatch[ubn].fileto;
							f.FileInfo:=ubatch[ubn].FileInfo;
							f.CrackGroup:=ubatch[ubn].CrackGroup;

							fileboard:=ubatch[ubn].section;
							v.descr[1]:='';
							if (ubatch[ubn].vr<>0) then v:=ubatchv[ubatch[ubn].vr]^;
							f.vpointer:=-1;
							if (v.descr[1]<>'') then f.vpointer:=nfvpointer;
							FILE_ID_DIZ(f.filename,True,v,f);   {iM Test 956}
							ProcessHangup;
							wenttosysop:=(fileboard=systat.tosysopdir);
						end;

          begin {ziptest/move/give pts, etc. you know, all that shit tough guy}
						if (wenttosysop) then fileboard:=systat.tosysopdir;

						fiscan(pl);

						arcstuff(ok,convt,blks,convtime,TRUE,WorkPath+'2\',
										 fn,f.description);
						tconvtime:=tconvtime+convtime; f.blocks:=blks;

						doffstuff(f,fn,gotpts);
            { SOMETHING IN THIS AREA CAUSES SYS ERROR #5 !!! SO FIX IT!!! }
						fok:=TRUE;
						loaduboard(fileboard);
						if (ok) then begin
              prfmsg('FBMOVFT',memuboard.name);
              prfmsg('FBMOVPG','');
							movefile(fok,nospace,TRUE,WorkPath+'2\'+fn,memuboard.dlpath+fn);
							if (fok) then begin
								newff(f,v);
                prfmsg('FBFSUL',fn);
								sysoplog(#3#3+'Batch uploaded "'+sqoutsp(fn)+'" on '+
												 memuboard.name);
								inc(totfils);
								lng:=blks; lng:=lng*128;
								inc(totb,lng);
								inc(totpts,gotpts);
							end else begin
                prfmsg('FBEMFID','');
								sysoplog(#3#3+'Error moving batch upload "'+sqoutsp(fn)+'" into directory');
							end;
						end else begin
              prfmsg('FBULNOTR','');
							if ((thisuser.sl>0) and
									(f.blocks div 8>systat.minresume)) then begin
                {nl;}
								dyny:=TRUE;
                if pynq(getmsg('FBSAVFRQ','')) then begin
									sprompt(#3#5+'Progress: ');
									movefile(fok,nospace,TRUE,WorkPath+'2\'+fn,memuboard.dlpath+fn);
									if (fok) then begin
										nl;
										doffstuff(f,fn,gotpts);
										f.filestat:=f.filestat+[resumelater];
										newff(f,v);
										s:='file saved for later resume';
									end else begin
                    prfmsg('FBEMFID','');
										sysoplog(#3#3+'Error moving batch upload "'+sqoutsp(fn)+'" into directory');
									end;
								end;
							end;
							if (not (resumelater in f.filestat)) then begin
								s:='File Deleted';
								assign(fi,WorkPath+'2\'+fn); erase(fi);
							end;
							sysoplog(#3#3+'Errors Batch Uploading "'+sqoutsp(fn)+'" - '+s);
						end;

						if (not ok) then begin
							st:=(rte*f.blocks);
							takeawayulrefundgot:=takeawayulrefundgot+st;
							r2dt(st,st1);
              prfmsg('FBTRWBT',longtim(st1));
						end else
							if (ubn<>0) then delubatch(ubn);
					end;

          findnext(dirinfo);
        end;

      fileboard:=oldboard;
      fiscan(pl);
      if (filerec(ulff).mode<>fmclosed) then close(ulff);

      prfmsg('FBBULSA',cstr(totfils1));
			if (totfils<>totfils1) then
        prfmsg('FBBULSB',cstr(totfils));
      varstr:=cstrl(totb1)+'~'+longtim(tooktime);
      prfmsg('FBBULSC',varstr);
			r2dt(tconvtime,tconvtime1);
			if (tconvtime<>0.0) then
        prfmsg('FBBULSD',longtim(tconvtime1));
			r2dt(ulrefundgot,ulrefundgot1);
      varstr:=cstr(cps)+'~'+longtim(ulrefundgot1);
      prfmsg('FBBULSE',varstr);

      inc(systat.todayzlog.uploads,totfils);
      inc(systat.todayzlog.uk,totb1 div 1024);
      if (aacs(systat.ulvalreq)) then begin
        if (totpts<>0) then
        varstr:=cstr(totpts)+'~'+cstr(totfils)+'~'+cstr(totb1 div 1024)+'~'+thisuser.name;
        prfmsg('FBBULCRD',varstr);
        inc(thisuser.uploads,totfils);
        inc(thisuser.filepoints,totpts);
        thisuser.uk:=thisuser.uk+(totb1 div 1024);
      end else begin
        varstr:=thisuser.name+'~';
        if (systat.uldlratio) then varstr:=varstr+'Credit'
          else varstr:=varstr+'Points';
        varstr:=varstr+'~'+systat.sysopname;
        prfmsg('FBULTHX',varstr);
      end;

      if (choptime<>0.0) then begin
        choptime:=choptime+ulrefundgot;
        freetime:=freetime-ulrefundgot;
        prfmsg('FBNOTNOW','');
      end;

      if (takeawayulrefundgot<>0.0) then begin
        r2dt(takeawayulrefundgot,takeawayulrefundgot1);
        prfmsg('FBTAKREF',longtim(takeawayulrefundgot1));
        freetime:=freetime-takeawayulrefundgot;
      end;

      if (ahangup) then begin
        commandline('Hanging up phone again...');
        dophonehangup(FALSE);
        hangup:=TRUE;
      end;

    end;
  end;
  if (savpause) then thisuser.ac:=thisuser.ac+[pause];
end;

procedure batchinfo;
begin
  if (numbatchfiles<>0) then prfmsg('FBFLIDQ',cstr(numbatchfiles));
  if (numubatchfiles<>0) then prfmsg('FBFLIUQ',cstr(numubatchfiles));
end;

end.

