{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit file9;

interface

uses
  crt, dos, overlay,
  myio,
  file0, file1, file2,
  common;

function info:astr;
procedure dir(cd,x:astr; expanded:boolean);
procedure dirf(expanded:boolean);
procedure setdirs;
procedure pointdate;

implementation

function align2(s:astr):astr;
begin
  if pos('.',s)=0 then s:=mln(s,12)
    else s:=mln(copy(s,1,pos('.',s)-1),8)+' '+mln(copy(s,pos('.',s)+1,3),3);
  align2:=s;
end;

function info:astr;
var pm:char;
    i:integer;
    s:astr;
    dt:datetime;

  function ti(i:integer):astr;
  var s:astr;
  begin
    ti:=tch(cstr(i));
  end;

begin
  s:=dirinfo.name;
  if (dirinfo.attr and directory)=directory then s:=mln(s,13)+'<DIR>   '
    else s:=align2(s)+'  '+mrn(cstrl(dirinfo.size),7);
  unpacktime(dirinfo.time,dt);
  with dt do begin
    if hour<13 then pm:='a' else begin pm:='p'; hour:=hour-12; end;
    s:=s+'  '+mrn(cstr(month),2)+'-'+ti(day)+'-'+ti(year-1900)+
             '  '+mrn(cstr(hour),2)+':'+ti(min)+pm;
  end;
  info:=s;
end;

procedure dir(cd,x:astr; expanded:boolean);
var abort,next,nofiles:boolean;
    s:astr;
    onlin:integer;
    dfs:longint;
    numfiles:integer;
begin
  if (copy(cd,length(cd),1)<>'\') then cd:=cd+'\';
  abort:=FALSE;
  cd:=cd+x;
  if (fso) then
    prfmsg('FBDIROF',copy(cd,1,length(cd)));
  s:=''; onlin:=0; numfiles:=0; nofiles:=TRUE;
  ffile(cd);
  while (found) and (not abort) do begin
    if (not (dirinfo.attr and directory=directory)) or (fso) then
      if (not (dirinfo.attr and volumeid=volumeid)) then
        if ((not (dirinfo.attr and dos.hidden=dos.hidden)) or (usernum=1)) then
          if ((dirinfo.attr and dos.hidden=dos.hidden) and
             (not (dirinfo.attr and directory=directory))) or
             (not (dirinfo.attr and dos.hidden=dos.hidden)) then begin
            nofiles:=FALSE;
            if (expanded) then printacr(info,abort,next)
            else begin
              inc(onlin);
              s:=s+align2(dirinfo.name);
              if onlin<>5 then s:=s+'    ' else begin
                printacr(s,abort,next);
                s:=''; onlin:=0;
              end;
            end;
            inc(numfiles);
          end;
    nfile;
  end;
  if (not found) and (onlin in [1..5]) then printacr(s,abort,next);
  dfs:=freek(exdrv(cd));
  if (nofiles) then
    prfmsg('FBDIRBA',mrn(cstrl(dfs*1024),10))
  else begin
    varstr:=mrn(cstr(numfiles),10)+'~'+mrn(cstrl(dfs*1024),10);
    prfmsg('FBDIRBB',varstr);
  end;
{    s:=#3#3+'Files not found'
    else s:=#3#3+mrn(cstr(numfiles)+#3#5+' File(s)',17);
  printacr(s+#3#3+mrn(cstrl(dfs*1024),10)+#3#5+' bytes free',abort,next); }
end;

procedure dirf(expanded:boolean);
var fspec:astr;
    abort,next,all:boolean;
begin
  prfmsg('FBRAWDIR','');
  gfn(fspec); abort:=FALSE; next:=FALSE;
  prfmsg('FBRAWDIB','');
  loaduboard(fileboard);
  dir(memuboard.dlpath,fspec,expanded);
end;

procedure setdirs;
var s,t:astr;
    i:integer;
    done:boolean;
    tempboard:integer;
begin
  if (novice in thisuser.ac) then fbaselist;
  done:=FALSE;
  repeat
    prfmsg('FBSETZP','');
    input(s,3);
    if (s='Q') then done:=TRUE;
    if (s='?') then fbaselist;
    {$B-}
    if (length(s)>0) and (s[1] in ['0'..'9']) and (value(s)<=maxfboard) then
      i:=value(s);
    {$B+}
    if (fbaseac(fconfpk^[i])) then { loads memuboard }
      if (i>=0) and (i<=maxfboard) and
         (length(s)>0) and (s[1] in ['0'..'9']) then begin
        t:=memuboard.name;
        tempboard:=fileboard;
        if (checkzscanf(fconfpk^[i])) then begin
          prfmsg('FBBRDNOT',t);
          loaduboard(fconfpk^[i]);
          zscanf.zscan:=false;
          savezscanf;
          loaduboard(tempboard);
        end else begin
          prfmsg('FBBRDYES',t);
          loaduboard(fconfpk^[i]);
          zscanf.zscan:=true;
          savezscanf;
          loaduboard(tempboard);
        end;
      end;
  until (done) or (hangup);
  lastcommandovr:=TRUE;
end;

procedure pointdate;
var s:astr;
begin
  prfmsg('FBPTRDP',''); input(s,8);
  if (daynum(s)=0) and (s<>'') then prfmsg('FBILLDAT','') else newdate:=s;
  prfmsg('FBOKDAT','');
end;

End.
