{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : FSE.PAS                                                       
  Description: ANSi Full Screen Editor System                                
  Version    : v0.2000                                                       
                                                                             
                                                                           
 Ľ}
{$G+,O+}
unit FSE;

interface

uses common,crt;

function ansireedit(maxli:integer):boolean;

implementation

const
  topscrline=6;   {Top Screen Position Where TOPLINE resides}

type
   msgptrtype=^msgstruct;
   msgstruct=array[1..819] of string[79];  {819 Lines Max In This Editor}
var
  msg:msgptrtype;

function ansireedit(maxli:integer):boolean;
var
  curline:integer;    {Current Line}
  x,y:integer;        {Current X and Y}
  topline:integer;    {Top of the Screen's Line}
  save:boolean;       {Save message or abort?}
  insertmode:boolean; {Are we in insert mode or not?}
  amtlines:integer;   {Current Amount Of Lines}
  helptoggle:boolean; {Help or not??????}
  abort:boolean;      {Abort Message?}
  msgdone:boolean;    {Finished with message?}
  insstr,tovstr,insxy:string;

{********************Screen Control Stuff**********************************}

  procedure gotoansixy(newx,newy:integer);
  begin
    fastwrite('['+cstr(newy)+';'+cstr(newx)+'H');   {Send GOTOXY ansi sequence}
  end;

  procedure insertdraw;
  {This procedure outputs what mode we are in (INSERT or TYPEOVER)}
  var insertstg:string;
  begin
    if insertmode then insertstg:=insstr else insertstg:=tovstr;
    if helptoggle then fastwrite('['+insxy+'H'+insertstg);
    gotoansixy(x,y);
  end;

  procedure headit;
  {This procedure writes out the message header}
  begin
    prfmsg('FSEHDR','');
    insertdraw;
    cl(4);
  end;

  procedure clrmsgarea;
  begin
    headit;                     {Clear the screen and Write the message header}
    gotoansixy(1,topscrline);   {Set current screen position}
  end;

  Procedure redraw;       {Full Redraw Of Text}
  var
    i,z:integer;
  begin
    i:=topline;
    z:=topscrline;
    gotoansixy(1,z);
    while (z<thisuser.pagelen) and (I<=amtlines) do begin
      clre;
      sprint(msg^[i]);            {Print The Line Out}
      if i=curline then y:=z;     {Set Current Y Position On The Screen}
      inc(i);                     {Increment Line In Array Counter}
      inc(z);                     {Increment Y Position On Screen Of Output Line}
    end;
    if z<thisuser.pagelen then    {Clear The Rest Of The Screen}
      while z<=thisuser.pagelen do begin
        clre;
        fastwrite('[B');
        inc(z);
      end;
    if x>length(msg^[curline])+1 then x:=length(msg^[curline])+1;
    gotoansixy(x,y);              {Reposition The Cursor}
  end;

  procedure partredraw;     {Partial Redraw of Text Starting At Current Line}
  var
    i,z:integer;
  begin
    z:=y;
    i:=curline;
    gotoansixy(1,y);
    while (z<thisuser.pagelen) and (i<=amtlines) do begin
      clre;
      sprint(msg^[i]);
      inc(z);
      inc(i);
    end;
    if z<thisuser.pagelen then
      while z<=thisuser.pagelen do begin
        clre;
        fastwrite('[B');
        inc(z);
      end;
    gotoansixy(x,y);
  end;

  procedure redrawcurline(part:boolean);
  {If part is TRUE then this will redraw the current line from the current
  x value.  Otherwise it will redraw the entire line.}
  begin
    if part then gotoansixy(x,y) else gotoansixy(1,y);  {Set the screen pos}
    clre;             {Erase the line on the screen}
    if part then sprompt(copy(msg^[curline],x,length(msg^[curline])-x+1)) else sprompt(msg^[curline]);  {Reprint the line}
    gotoansixy(x,y);    {Reposition the cursor on the screen}
  end;

{******************************End of Screen Control Stuff*********************}

{********************Quoting Procedures************************************}
  procedure doquote;
  var f:text;
      t1:integer;
      s,z:string;
      done:boolean;
      quoteli:integer;
      c1:char;

    procedure openquotefile;
    begin
      done:=FALSE;
      assign(f,'msgtmp');
      {$I-} reset(f); {$I+}
      if (ioresult<>0) then done:=TRUE;
    end;

    procedure readquoteline;
    begin
      if eof(f) then done:=TRUE else begin
        {$I-} readln(f,s); {$I+}
        if (ioresult<>0) then done:=TRUE;
      end;
    end;

    procedure gotoquoteline(b:boolean);
    begin
      if (b) then begin
        close(f);
        openquotefile;
      end;
      if (not done) then begin
        t1:=0;
        repeat
          inc(t1);
          readquoteline;
        until ((t1=quoteli) or (done));
      end;
      if (done) then quoteli:=1;
    end;

  begin
    quoteli:=1;
    openquotefile;
    if (not done) then begin
      readquoteline;
      if (not done) then repeat
        if (s[1]<>'+') and (s[2]<>'+') then begin
          sprompt(#3+chr(memboard.quote_color));
          sprint(s);
          z:=getmsg('FSEQPMT','');
          sprompt(z);
          repeat
            getkey(c1);
            c1:=upcase(c1);
          until (c1 in ['A','S','F','Q','-','?',^M]);
          for t1:=1 to length(stripcolor(z)) do
            prompt(^H' '^H);
          sprompt(#3#1);
          case c1 of
            '?':prfmsg('FSEQHLP','');
            'A':begin
                  if (amtlines>maxli) then done:=TRUE else begin
                    s:=stripcolor(s);
                    if length(s) > 79 then delete(s,79,length(s));
                    inc(y);
                    if (y=thisuser.pagelen) then begin
                      clrmsgarea;
                      y:=topscrline;
                      x:=1;
                      gotoansixy(x,y);
                      topline:=curline;
                    end;
                    msg^[curline]:=s;
                    if (amtlines=1) and (msg^[curline]='') and (curline=1) then topline:=curline;
                    msg^[curline]:=s;
                    inc(curline);         {The Current Line}
                    inc(amtlines);        {Amount of lines written into the message}
                    inc(quoteli);         {Amount of Quoted Lines Of Text}
                    readquoteline;
                    if (done) then dec(quoteli);
                  end;
                end;
         ^M,'S':begin
                  inc(quoteli);
                  readquoteline;
                  if (done) then dec(quoteli);
                end;
            '-':if (quoteli>1) then begin
                  dec(quoteli);
                  gotoquoteline(TRUE);
                end;
            'F':begin
                  quoteli:=1;
                  gotoquoteline(TRUE);
                end;
            'Q':done:=TRUE;
          end;
        end else readquoteline;
        until (done);
      {$I-} close(f); {$I+}
      end;
    end;

  procedure fsq;  {Full Screen Quoting}
  type
    quotewhatptr=^quotewhatptrtype;
    quotewhatptrtype=array [1..819] of boolean;

  var
    f:text;
    fsqpt:msgptrtype;
    quotewhatpt:quotewhatptr;
    i,amtfsqlines:integer;
    fsqcurline,fsqtopline,
    fsqy:integer;
    fsqdone,fsqabort:boolean;


  Procedure fsqredraw;       {Full Redraw Of Text}
  var
    i,z:integer;
    s:string;
  begin
    i:=fsqtopline;
    z:=topscrline;
    gotoansixy(1,z);
    while (z<thisuser.pagelen) and (I<=amtfsqlines) do begin
      clre;
      if quotewhatpt^[i] then s:='[47m'+fsqpt^[i] else
        s:='[40m'+fsqpt^[i];           {Print The Line Out}
      sprint(s);
      if i=fsqcurline then fsqy:=z;     {Set Current Y Position On The Screen}
      inc(i);                           {Increment Line In Array Counter}
      inc(z);                           {Increment Y Position On Screen Of Output Line}
    end;
    if z<thisuser.pagelen then    {Clear The Rest Of The Screen}
      while z<=thisuser.pagelen do begin
        clre;
        fastwrite('[B');
        inc(z);
      end;
    gotoansixy(1,fsqy);              {Reposition The Cursor}
  end;

  procedure fsqhead;
  {This procedure writes out the FSQ header}
  begin
    prfmsg('FSEQHDR','');
    cl(4);
  end;

  procedure fsqpagedn(downline:boolean);
  {If downline is true then you have already incremented curline, so we must
   set the topline # to the current line, and do a redraw.  Otherwise
   calculate the topline of the next page and redraw, set the current
   line to that line as well.}
  var
    b,d:integer;
  begin
    if downline then begin
      fsqtopline:=fsqcurline;
      fsqy:=topscrline;
      fsqredraw;
    end else begin
      b:=thisuser.pagelen-topscrline;          {Find out the size of the work area}
      d:=curline+b;                            {D is the first line of the next page}
      if d>amtfsqlines then d:=amtfsqlines;
      fsqcurline:=d;
      fsqtopline:=fsqcurline;
      fsqy:=topscrline;
      fsqredraw;
    end;
  end;

  procedure fsqpageup(upline:boolean);
  {If upline is true then we have already decremented curline, so we
  calculate the top of the previous page and then redraw leaving
  curline at the bottom.  If not then we calculate the top of the previous
  page and redraw, and set curline to the top.}
  var
    b,d:integer;
  begin
    if upline then begin
      {Curline Has Already Been Decremented}
      b:=fsqcurline-thisuser.pagelen+topscrline+1;
      if b<1 then b:=1;
      fsqtopline:=b;
      redraw;
    end else begin
      b:=thisuser.pagelen-topscrline;          {Find out the size of the workarea}
      d:=fsqcurline-b;
      if d<1 then d:=1;
      fsqtopline:=d;
      fsqcurline:=d;
      fsqredraw;
    end;
  end;

  procedure fsqupline;
  {This goes up a line in the text, it pages up if necessary}
  var
    len,b:integer;
  begin
    if fsqcurline>1 then begin
      dec(fsqcurline);
      if fsqy>topscrline then begin
        dec(fsqy);
        len:=length(fsqpt^[fsqcurline])+1;
        gotoansixy(1,fsqy);
      end else fsqpageup(true);
    end;
  end;

  procedure fsqdownline;
  {This goes down a line in text, it pages if necessary as well.  Also
  if the current line is the last line, it will create another line
  and put you on it at the first char (x=1).}
  var
    len:integer;
  begin
    if fsqcurline<amtfsqlines then begin
      inc(fsqcurline);
      if fsqy<thisuser.pagelen-1 then begin
        inc(fsqy);
        len:=length(fsqpt^[fsqcurline])+1;
        gotoansixy(1,fsqy);
      end else begin
        fsqtopline:=fsqcurline;
        fsqredraw;
      end;
    end;
  end;

  procedure userescape;
  {Handles the user Escape Ansi Sequences, like their arrow keys}
  var k:char;
      where:boolean;
  begin
    repeat
      k:=gimmekey(where);
      case k of
        #72,'A': fsqupline;
        #80,'B': fsqdownline;
      end;
    until (K<>'[') or hangup;
  end;

  procedure fsqselect;
  {This procedure handles the SPACE BAR}
  var k:char;
      t:integer;
      s:string;
  begin
    if (quotewhatpt^[fsqcurline]=false) then quotewhatpt^[fsqcurline]:=true else
      quotewhatpt^[fsqcurline]:=false;
    {Keep track what line is being quoted}
    gotoansixy(1,fsqy);
    clre;
    if quotewhatpt^[fsqcurline] then
      s:='[47m'+fsqpt^[fsqcurline]
    else
      s:='[40m'+fsqpt^[fsqcurline];
    sprint(s);
    gotoansixy(1,fsqy);
  end;

  procedure fsqprocesskey;
  {This procedure gets the keys and decides what to do}
  var k:char;
      where:boolean;
  begin
    k:=gimmekey2(where);
    if (k=#0) and not where then begin
      k:=gimmekey2(where);
      case k of
        #72,'A': fsqupline;   {Up Arrow Pressed, Local}
        #80,'B': fsqdownline; {Down Arrow Pressed, Local}
      end;
    end else
      case k of
        #27:userescape;
        ^A:fsqAbort:=true;     {Abort Quoting}
        ^C:if (fsqcurline<amtfsqlines) then fsqpagedn(false);
        ^E:fsqupline;          {Go Up A Line, Same As Up Arrow}
        ^L:fsqredraw;          {Redraw The Screen}
        ' ':fsqselect;           {Select/Deselect This Line For Quoting}
        ^M,#13:gotoansixy(1,fsqy);        {Kill off any bugs on that shit!}
        ^J,#10:gotoansixy(1,fsqy);        {Kill off any bugs on that shit!}
        ^Q:fsqdone:=true;      {Exit And Save}
        ^R:if (fsqcurline>1) then fsqpageup(false);
    {    ^U:fsqhelp;   }         {Print Out Help File}
        ^X:fsqdownline;        {Go Down A Line, Same As Down Arrow}
      end;
      checkhangup;  { Check if user hungup }
  end;

  begin
    fsqabort:=false;
    fsqdone:=false;
    getmem(fsqpt,65520);
    getmem(quotewhatpt,819);
    for i:=1 to 819 do begin
      quotewhatpt^[i]:=false;
      fsqpt^[i]:='';
    end;
    assign(f,'msgtmp');
    {$I-} reset(f); {$I+}
    if (ioresult<>0) then fsqdone:=TRUE;
    if not fsqdone then begin
      i:=1;
      while (not eof(f)) and (i<=819) do begin
        readln(f,fsqpt^[i]);
        inc(i);
      end;
      {Read In The Temp Text File To Quote From, Into Our Quote Array}
      amtfsqlines:=i-1;  {Calculate The Amount Of FSQ Lines}

      fsqhead;           {Output The FSQ Header}
      fsqtopline:=1;
      fsqcurline:=1;
      fsqredraw;

      repeat fsqprocesskey; until (fsqdone) or (hangup) or (fsqabort);
      {Process The Key's}
      if (fsqdone) and (not fsqabort) and (not hangup) then begin
        for i:=1 to amtfsqlines do begin
          if quotewhatpt^[i]=true then begin
            msg^[curline]:=fsqpt^[i];
            inc(curline);
            inc(amtlines);
          end;
        end;
      end;
      {This copies all lines that should be quoted to the message text}
    end;
    close(f);
    freemem(fsqpt,65520);
    freemem(quotewhatpt,819);
  end;


{**********************End Of Quoting Stuff********************************}

{********************Importing Procedures************************************}
  procedure doimport;
  var f:text;
      t1:integer;
      s:string;
      done:boolean;
      importli:integer;
      c1:char;

    procedure openimportfile;
    var g,z:string; gl:integer; over:byte;
    begin
      done:=FALSE;
      z:=getmsg('FSEFNTI',''); sprompt(z);
      input(g,40); gl:=length(g); gl:=gl+(length(stripcolor(z)));
      for over:=1 to gl do prompt(^H' '^H);
      if length(stripspaces(g)) > 0 then begin
        assign(f,g);
        {$I-} reset(f); {$I+}
        if (ioresult<>0) then done:=TRUE;
      end else done:=TRUE;
    end;

    procedure readimportline;
    begin
      if eof(f) then done:=TRUE else begin
        {$I-} readln(f,s); {$I+}
        if (ioresult<>0) then done:=TRUE;
      end;
    end;

    procedure gotoimportline(b:boolean);
    begin
      if (b) then begin
        close(f);
        openimportfile;
      end;
      if (not done) then begin
        t1:=0;
        repeat
          inc(t1);
          readimportline;
        until ((t1=importli) or (done));
      end;
      if (done) then importli:=1;
    end;

  begin
    importli:=1;
    openimportfile;
    if (not done) then begin
      readimportline;
      if (not done) then repeat
        if (s[1]<>'+') and (s[2]<>'+') then begin
          if (amtlines>maxli) then done:=TRUE else begin
            s:=stripcolor(s);
            if length(s) > 79 then delete(s,79,length(s));
            inc(y);
            if (y=thisuser.pagelen) then begin
              clrmsgarea;
              y:=topscrline;
              x:=1;
              gotoansixy(x,y);
              topline:=curline;
            end;
            if (amtlines=1) and (curline=1) then topline:=1;
            msg^[curline]:=s;
            inc(importli);
            inc(amtlines);       {Amount Of Lines}
            inc(curline);        {Current Line}
            readimportline;
            if (done) then dec(importli);
          end;
        end else readimportline;
        until (done);
      {$I-} close(f); {$I+}
      end;
    end;
{**********************End Of Importing Stuff********************************}

  procedure pagedn(downline:boolean);
  {If downline is true then you have already incremented curline, so we must
   set the topline # to the current line, and do a redraw.  Otherwise
   calculate the topline of the next page and redraw, set the current
   line to that line as well.}
  var
    b,d:integer;
  begin
    if downline then begin
      topline:=curline;
      x:=1;
      y:=topscrline;
      redraw;
    end else begin
      b:=thisuser.pagelen-topscrline;          {Find out the size of the work area}
      d:=curline+b;                            {D is the first line of the next page}
      if d>amtlines then d:=amtlines;
      curline:=d;
      topline:=curline;
      y:=topscrline;
      x:=1;
      redraw;
    end;
  end;

  procedure pageup(upline:boolean);
  {If upline is true then we have already decremented curline, so we
  calculate the top of the previous page and then redraw leaving
  curline at the bottom.  If not then we calculate the top of the previous
  page and redraw, and set curline to the top.}
  var
    b,d:integer;
  begin
    if upline then begin
      {Curline Has Already Been Decremented}
      b:=curline-thisuser.pagelen+topscrline+1;
      if b<1 then b:=1;
      topline:=b;
      redraw;
    end else begin
      b:=thisuser.pagelen-topscrline;          {Find out the size of the workarea}
      d:=curline-b;
      if d<1 then d:=1;
      topline:=d;
      curline:=d;
      redraw;
    end;
  end;

  procedure upline;
  {This goes up a line in the text, it pages up if necessary}
  var
    len,b:integer;
  begin
    if curline>1 then begin
      dec(curline);
      if y>topscrline then begin
        dec(y);
        len:=length(msg^[curline])+1;
        if x>len then x:=len;
        gotoansixy(x,y);
      end else pageup(true);
    end;
  end;

  procedure downline;
  {This goes down a line in text, it pages if necessary as well.  Also
  if the current line is the last line, it will create another line
  and put you on it at the first char (x=1).}
  var
    len:integer;
  begin
    if curline<maxli then begin
      inc(curline);
      if curline>amtlines then amtlines:=curline;
      if y<thisuser.pagelen-1 then begin
        inc(y);
        len:=length(msg^[curline])+1;
        if x>len then x:=len;
        gotoansixy(x,y);
      end else begin
        topline:=curline;
        redraw;
      end;
    end;
  end;

  procedure fowrd;
  {This procedure handles the right arrow key, going down a line if
   necassary}
  begin
    if (x<79) and (X<=length(msg^[curline])) then begin {If this is not the last character on the line}
      inc(x);            {Increment X's Position}
      fastwrite('[C');  {Send the Right Cursor Code}
    end else
      if (x=length(msg^[curline])+1) and (curline<maxli) then begin
        x:=1;
        downline;
      end;
  end;

  procedure back;
  {This procedure handles the left arrow key, going up a line if necessary}
  begin
    if (x>=1) then begin   {If this is not the first character on the line}
      dec(x);             {Decrement X's position}
      fastwrite('[D');   {Send the left cursor code}
    end else
      if (x=1) and (curline>1) then begin
        {If this is the first character and not on the first line do the following}
        x:=length(msg^[curline-1])+1;  {Set the X position to the last character on the line}
        upline;
    end;
  end;

  procedure toggleins;
  {This procedure Toggles Insertmode/TypeOver mode}
  begin
    insertmode:=not insertmode;   {Toggle the intertmode boolean value}
    insertdraw;                   {Rewrite the status line indicating
                                   what mode we are in}
  end;


  procedure deleteline;
  {This procedure deletes a line from the body of text}
  var
   i:integer;
  begin
    if (curline>=1) and (curline<maxli) and (curline<amtlines) then begin
      for I:=curline to amtlines do
        msg^[i]:=msg^[i+1];
      dec(amtlines);
    end else
      if (curline>=amtlines) then msg^[curline]:='';
    partredraw;
  end;

  procedure insertline;
  {This procedure inserts a line into the body of text}
  var i:integer;
  begin
    if amtlines<maxli then begin
      for I:=amtlines downto curline do
        msg^[i+1]:=msg^[i];
      msg^[curline]:='';
      inc(amtlines);
    end;
    redraw;            {Needs A Full Redraw}
  end;

  procedure beginline;
  {This function goes to the beginning of the line}
  begin
    x:=1;               {Set X to the first character in the line}
    gotoansixy(x,y);    {Goto the new location}
  end;

  procedure endline;
  {This function goes to the end of the line}
  begin
    x:=length(msg^[curline])+1;
    gotoansixy(x,y);
  end;

  procedure joinlines;
  {This procedure joins two lines and wordwraps if necessary.  Curline Is
  The First Line of The Joining, and The Next Line Will Be added To IT}
  var
    len,i:integer;
    temp1,         {MSG^[CURLINE]}
    temp2:string;  {MSG^[CURLINE+1]}
  begin
    temp1:=msg^[curline]+copy(msg^[curline+1],1,length(msg^[curline+1]));
    temp2:='';
    {msg^[curline]:=msg^[curline]+copy(msg^[curline+1],1,length(msg^[curline+1]));
    msg^[curline+1]:=''; }
    if length(temp1) > 79 then begin

      i:=length(temp1);
      repeat
        repeat dec(i); until temp1[i]=' ';    {Find The Beggining Of The Last Word}
      until i<79;

      if i>1 then begin
        len:=length(temp1);
        inc(i);      {move past the space}
        {Finds Where To Copy From}

        temp2:=copy(temp1,i,len);
        delete(temp1,i,len);
        msg^[curline]:=temp1;
        msg^[curline+1]:=temp2;
        {WordWrap}
      end else begin
        len:=length(temp1);
        temp2:=copy(temp1,79,len);
        delete(temp1,79,len-79+1);
        msg^[curline]:=temp1;
        msg^[curline+1]:=temp2;
      end;
      if y<thisuser.pagelen-1 then begin {Redraw Both Lines Involved In The Joining}
        inc(y);
        inc(curline);
        redrawcurline(false);
        dec(curline);
        dec(y);
        redrawcurline(true);
      end else redrawcurline(true);   {If You Are On The Last Line Of The Page
                                       Then You Should Only Redraw The That Line}
    end else begin
      msg^[curline]:=temp1;
      msg^[curline+1]:=temp2;
      if (curline+1 = amtlines) then dec(amtlines);
      msg^[curline+1]:='';
      redraw;
    end;
  end;

  procedure deleteeol;
  {This procedure deletes all text from the current x position to the end
  of the line}
  begin
    clre;
    delete(msg^[curline],x,length(msg^[curline])-x+1);
  end;

  procedure wordleft;   {Goes To the beginning of the current word if
                         we are not at the beginning otherwise it goes
                         to the word before this one}
  var i:integer;
  begin
    i:=x;
    if (msg^[curline][i]<>' ') and (msg^[curline][i-1]=' ') then dec(i);
    repeat dec(i); until msg^[curline][i]=' ';
    if i<=1 then x:=1 else x:=i+1;
    gotoansixy(x,y);
  end;

  procedure wordright;  {Goes to the first CHAR of the Next Word}
  var i:integer;
  begin
    i:=x;
    repeat inc(i); until msg^[curline][i]=' ';
    if i>=78 then x:=78 else x:=i+1;
    gotoansixy(x,y);
  end;

  procedure worddel;
  {Deletes the current word if we are at the beginning of it}
  var
    i:integer;
  begin
    I:=x;
    repeat inc(i); until msg^[curline][i]=' ';
    if i<=78 then begin     {If it is Larger than 78 then this is bogus}
      dec(i);      {I will now point to the end of the word}
      delete(msg^[curline],x,i-x+1);
      redrawcurline(false);
    end;
  end;

  procedure del;
  {Handles The Del Key}
  var i,t:integer;
      len:integer;
  begin
    if length(msg^[curline])>0 then delete(msg^[curline],x,1);
    if (x<=1) and (length(msg^[curline])=0) then begin
      x:=1;
      deleteline;     {Removes The Current Line, and PartRedraw's}
    end else
      if (x<length(msg^[curline])+1) and (x>=1) then redrawcurline(true) else
        if (x>=length(msg^[curline])+1) then joinlines;
  end;

  procedure bkspace;
  {Handles The BackSpace Key}
  var t:integer;
      joined:boolean;
  begin
    t:=0;
    joined:=false;
    if (curline=1) and (x=1) then begin
      delete(msg^[curline],x,1);
      redrawcurline(false);
    end else
      if (curline=topline) and (x=1) then begin
        deleteline;
        dec(curline);
        x:=length(msg^[curline])+1;
        pageup(true);
      end else
        if (x=1) then begin
          dec(curline);
          if length(msg^[curline])>1 then begin
            t:=length(msg^[curline+1]);
            joinlines;
            joined:=true;
          end;
          if not joined then begin
            inc(curline);
            deleteline;
            dec(y);
            dec(curline);
          end;
          x:=length(msg^[curline])+1-t;
          gotoansixy(x,y);
        end else begin
          dec(x);
          delete(msg^[curline],x,1);
          fastwrite(^H+' '+^H);
          redrawcurline(true);
        end;
  end;
  
  Procedure Tab;
  {Puts 5 spaces into the line of text, a TAB}
  var s:astr;
      i:byte;
  begin
    if not insertmode then begin
      for i:=0 to 4 do
        msg^[curline][x+i]:=' ';
      x:=x+5;
      if x>length(msg^[curline])+1 then msg^[curline][0]:=chr(x-1);
    end else if length(msg^[curline])<75 then begin
      insert('     ',msg^[curline],x);
      x:=x+5;
      redrawcurline(false);
    end;
  end;

  procedure help;
  {This procedure gets Help}
  var where:boolean;
  begin
    cls;
    printfile(systat.textpath+'FSECMD.ANS');
    prfmsg('FSEPAK','');
    if upcase(gimmekey(where))<>'b' then begin clrmsgarea; redraw; end;
  end;

  procedure commands;

    function youaresure:boolean;
    begin
      youaresure:=false;
      fastwrite('['+cstr(topscrline-1)+';1H');
      youaresure:=pynq(getmsg('FSEAYS',''));
      abort:=false;
    end;

    procedure savemes;
    begin
      msgdone:=true;
      save:=true;
    end;

    procedure abortmes;
    begin
      if youaresure then begin
        amtlines:=0;
        abort:=true;
        msgdone:=true;
      end;
    end;

  var k:char;
      input:string;
  begin
    abort:=false;
    fastwrite('['+cstr(topscrline-1)+';1H');
    prfmsg('FSECMD','');
    inputl(input,40);
    abort:=false;
    fastwrite('[A');
    clre;
    if length(input)=0 then begin
      gotoansixy(x,y);
      exit;
    end;
    k:=upcase(input[1]);
    case k of
      'S':savemes;
      'A':abortmes;
      'Q':begin gotoansixy(x,y); doquote; clrmsgarea; redraw; end;
      'I':if (mso) then begin gotoansixy(x,y); doimport; clrmsgarea; redraw; end;
      '?':help
    end;
    gotoansixy(x,y);
  end;


  procedure userescape;
  {Handles the user Escape Ansi Sequences, like their arrow keys}
  var k:char;
      where:boolean;
  begin
    repeat
      k:=gimmekey(where);
      case k of
        #72,'A': upline;
        #80,'B': downline;
        #77,'C': fowrd;
        #75,'D': back;
        #82,'@': toggleins;
        #83,'P': del;
      end;
    until (K<>'[') or hangup;
  end;

  procedure crlf;
  {This procedure handles the ENTER key}
  var k:char;
      t:integer;
  begin
    if (length(msg^[curline])=2) and (msg^[curline][1]='/') then begin
      k:=upcase(msg^[curline][2]);
      case k of
        'S':begin
              msgdone:=true;
              if ((amtlines=1) and (msg^[curline]='')) or (amtlines=0) then begin
                msgdone:=true;
                exit;
              end;
              deleteline;  {Fix the /S saving into the text}
              ansireedit:=true;
              save:=true;
              exit;
            end;
        'A':begin
              fastwrite('['+cstr(topscrline-1)+';1H');
              if pynq(getmsg('FSEAYS','')) then begin
                amtlines:=0;
                msgdone:=true;
                abort:=true;
              end;
            end;
        'Q':begin deleteline; doquote; clrmsgarea; redraw; end;
        'I':if (mso) then begin deleteline; doimport; clrmsgarea; redraw; end;
      end;
    end;
    if (insertmode) and (x>=1) and(x<length(msg^[curline])) then begin
      t:=x;
      inc(curline);
      if (amtlines<curline) then inc(amtlines);
      insertline;
      msg^[curline]:=copy(msg^[curline-1],t,length(msg^[curline-1]));
      delete(msg^[curline-1],t,length(msg^[curline-1]));
      x:=1;
      redraw;
    end else begin
      x:=1;
      downline;
    end;
  end;

  procedure letterkey(ch:char);
  {This procedure handles characters, it wordwraps, inserts, pages, you name
  it.}
  var
    len,i,b,t:integer;
    newpage,nooutkey:boolean;
  begin
    inc(x);
    newpage:=false;
    nooutkey:=false;
    if (amtlines<maxli) and (x<=79) then begin
      if (x>length(msg^[curline])) then msg^[curline]:=msg^[curline]+ch else
        if insertmode and (x<=length(msg^[curline])) then begin
          dec(x);
          insert(ch,msg^[curline],x);
          dec(x);
          redrawcurline(true);
          x:=x+2;
          gotoansixy(x,y);
          nooutkey:=true;
        end else
          if not insertmode and (x<=length(msg^[curline])) then msg^[curline][x-1]:=ch;
    end;

    len:=length(msg^[curline]);
    if (len+1>=79) and (amtlines<maxli) then begin
      i:=79;
      repeat dec(i); until msg^[curline][i]=' ';
      if I>1 then begin
        t:=curline;
        if insertmode then begin
          downline;     {Inc(curline);}
          insertline;
        end else downline;

        inc(i);      {move past the space}
        msg^[curline]:=copy(msg^[t],i,len);
        delete(msg^[t],i,len);
        {WordWrap}

        x:=length(msg^[curline])+1;           {Reset X Coord}
        if (curline<>topline) and (curline<>1) then begin
          dec(curline);
          dec(y);
          partredraw;
          inc(curline);
          inc(y);
          gotoansixy(x,y);
        end else redrawcurline(false);
      end else begin   {If there are no spaces, just continue w/o wordwrap}
        x:=1;
        if insertmode then begin
          inc(curline);
          insertline;
        end else downline;
      end;
    end else if not nooutkey then outkey(ch);             {Output the key}
  end;

  procedure processkey;
  {This procedure gets the keys and decides what to do}
  var k:char;
      where:boolean;
  begin
    abort:=false;
    k:=gimmekey2(where);
    if (k=#0) and not where then begin
      k:=gimmekey2(where);
      case k of
        #72,'A': upline;
        #80,'B': downline;
        #77,'C': fowrd;
        #75,'D': back;
        #82,'@': toggleins;
        #83,'P': del;
      end;
    end else
      case k of
        #27:userescape;
        ' '..#255:letterkey(k);

        ^A:wordleft;
      (*  ^B:breakline;  *)
        ^C:if (curline<amtlines) then pagedn(false);
        ^D:fowrd;
        ^E:upline;
        ^F:wordright;
        ^G:del;
        ^H:bkspace;
        ^I:tab;
      (*  ^J:joinlines;  *)
        ^K:commands;
        ^L:redraw;
        ^M:crlf;
        ^N:insertline;
        ^O:deleteeol;
        ^P:letterkey(#3);          {OUTPUT OUR CONTROL-P For COLOR}
        ^Q:begin {doquote;}fsq; clrmsgarea; redraw; end;
        ^R:if (curline>1) then pageup(false);
        ^S:back;
        ^T:worddel;
        ^U:help;
        ^V:toggleins;
        ^W:endline;
        ^X:downline;
        ^Y:deleteline;
      end;
      checkhangup;  { Check if user hungup }
  end;

var t:text;          {Text file to save message to}
    I:integer; 
begin
  helptoggle:=true;
  msgdone:=false;
  abort:=false;
  save:=false;
  insstr:=getmsg('FSEISTR',''); tovstr:=getmsg('FSETSTR','');
  insxy:=getmsg('FSEIMYX','');
  {Initialize Booleans for exiting purposes}

  getmem(msg,65520);         {Gets Memory From The Heap}
  for I := 1 to maxli do msg^[i]:='';
  amtlines:=1;
  curline:=1;
  topline:=1;
  y:=topscrline;
  x:=1;
  {Initialize linked list}

  clrmsgarea; {Draw out message area}

  repeat processkey until msgdone or hangup;  {Main Message Loop}

  if save then begin
    assign(t,'MSGTMP');
    rewrite(t);
    for I:=1 to amtlines do writeln(t,msg^[i]);
    close(t);
  end;
  {Saves Message if it should}
  freemem(msg,65520);        {Free's The Heap}
  ansireedit:=save;    {Return value if this message is to be saved by Rev!}
end;

end.

