{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : RUMORS.PAS                                                    
  Description: Rumor System                                                  
  Version    : v0.1100                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
Unit Rumors;

Interface

Uses Dos,Crt,Overlay,Common,Emulate;

Procedure Rumor_View(RumorNum:integer);
Procedure Rumor_Add;
Procedure Rumor_List;
Procedure Rumor_Delete;

Implementation

Const
 RumorFileName:String[10]='RUMORS.LST';
 TempRumorFileName:String[10]='RUMORS.$$$';

Var
 RumorNum:integer;
 s:string[3];
 tmprumorf:file of rumorrec;
 tmprumor:rumorrec;
 NoRumors:boolean;

Procedure Rumor_View(RumorNum:integer);
Var
 s:string;
Begin
 NoRumors:=FALSE;
 Assign(rumorf, systat.SystemPath+rumorfilename);
 {$I-} Reset(rumorf); {$I-}
 If IOResult<>0 then NoRumors:=TRUE
 Else begin
  If (FileSize(rumorf)<1) then NoRumors:=TRUE;
  If (RumorNum>FileSize(rumorf)) then NoRumors:=TRUE;
  If (RumorNum<1) then NoRumors:=TRUE;
  Close(rumorf);
 End;

 If NoRumors then begin
  If (menur.emulation>=20) and (menur.emulation<=29) then prfmsg('RUNOR20','')
    Else prfmsg('RUNORO','');
  Exit;
 End;

 s:=rumorviewstring;

 If pos('R#',s)=0 then s:=getmsg('RUUDRPS','')
 Else Begin
  Reset(rumorf);
  Seek(rumorf,RumorNum-1);
  Read(rumorf,rumor);
  Close(rumorf);
  Insert(rumor.rumor,s,pos('R#',s));
  Delete(s,pos('R#',s),3);
 End;

 prfmsg('RURUMOR',s);
End;

Procedure Rumor_Add;
Var
 s:string;
Begin
 Assign(rumorf, systat.SystemPath+rumorfilename);
 {$I-} Reset(rumorf); {$I-}
 If IOResult<>0 then begin
  {$I-} Rewrite(rumorf); {$I+}
  If IOResult<>0 then begin
   prfmsg('RUIOERR','');
   Exit;
  End;
 End;

 Seek(rumorf,FileSize(rumorf));

 rumor.date:=date;
 rumor.author:=thisuser.name;

 If (menur.emulation>=20) and (menur.emulation<=29) then begin
  prfmsg('RUGTIT20','');
  inputl(s,20);
  rumor.title:=s;
  prfmsg('RUGATI20','');
  If rumor.title='' then exit;
  prfmsg('RUPRAQ20','');
  inputl(s,3);
  If allcaps(s)<>'Y' then rumor.anonymous:=FALSE
  Else rumor.anonymous:=TRUE;
  prfmsg('RULRRR20','');
  inputl(s,3);
  rumor.accessreq:=bytevalue(s);
  prfmsg('RUERUM20','');
  inputl(s,75);
  rumor.rumor:=s;
  If s<>'' then begin
   write(rumorf,rumor);
   prfmsg('RURCRE20','');
  End;
  prfmsg('RUAADD20','');
 End
 Else Begin
  rumor.title:='';
  rumor.anonymous:=FALSE;
  rumor.accessreq:=0;
  prfmsg('RUERUMO','');
  inputl(s,75);
  rumor.rumor:=s;
  If s<>'' then begin
   write(rumorf,rumor);
   prfmsg('RURCREO','');
  End
  Else prfmsg('RUNOTSAV','');
 End;

 close(rumorf);
End;


Procedure Rumor_List;
Var
 Temp,
 Count,
 Range:integer;
 AuthorStr:String[21];

Begin
  NoRumors:=FALSE;
  Assign(rumorf, systat.SystemPath+rumorfilename);
  {$I-} Reset(rumorf); {$I-}
  If IOResult<>0 then NoRumors:=TRUE
  Else If (FileSize(rumorf)<1) then begin close(rumorf); NoRumors:=TRUE; end;

  If (menur.emulation>=20) and (menur.emulation<=29) then begin

    If NoRumors then begin
      prfmsg('RUNORU20','');
      Exit;
    End;

    prfmsg('RUVWPT20',cstr(FileSize(rumorf)));
    input(s,9);
    count:=0;
    If s<>'' then begin
      If pos('-',s)<>0 then begin
        Temp:=value(copy(s,1,pos('-',s)-1));
        If Temp>0 then count:=Temp-1;
        Temp:=value(copy(s,pos('-',s)+1,length(s)-pos('-',s)+1));
        If Temp>0 then range:=Temp-1;
      End
      Else If (value(s)>0) then begin
        range:=value(s)-1;
        count:=value(s)-1;
      End
      Else range:=FileSize(rumorf)-1;
    End
    Else range:=FileSize(rumorf)-1;
    If range<count then begin
      {nl;}
      Exit;
    End;

    If range>FileSize(rumorf)-1 then range:=FileSize(rumorf)-1;
    If count>FileSize(rumorf)-1 then count:=FileSize(rumorf)-1;
    prfmsg('RUVWHD20','');

    While (Count<=Range) and (Not Hangup) do begin
      Seek(rumorf,count);
      Read(rumorf,rumor);
      If (not rumor.anonymous) then AuthorStr:=Rumor.Author
      Else begin
        If (cso) then AuthorStr:='Anon ['+copy(rumor.author,1,21)+']'
        Else AuthorStr:='Anonymous';
      End;
      varstr:=cstr(count+1)+'~'+rumor.title+'~'+rumor.date+'~'+authorstr;
      prfmsg('RUVWLS20',varstr);
      Inc(Count);
    End;
    prfmsg('RUVWBT20','');
  End (* End Emu 20-29 Stuff *)

  Else Begin (* Other Emulations *)

    If NoRumors then begin
      prfmsg('RUNORUO','');
      Exit;
    End;
    count:=0;
    range:=FileSize(rumorf)-1;
    prfmsg('RUVWHDO','');
    While (Count<=Range) and (Not Hangup) do begin
      Seek(rumorf,count);
      Read(rumorf,rumor);
      varstr:=cstr(count+1)+'~'+copy(stripcolor(rumor.rumor),1,73);
      prfmsg('RUVWLSO',varstr);
      Inc(Count);
    End;
    prfmsg('RUVWBTO','');
  End;

  close(rumorf);
End;


Procedure Rumor_Delete;

  Procedure DeleteIt(DeleteNum:integer);
  Var
    i:integer;
  Begin
    (* iM Test 956
    {$I-} Rewrite(tmprumorf); {$I-}
    If IOResult<>0 then Exit;
    close(tmprumorf);
    *)
    reset(rumorf);

    if deletenum > filesize(rumorf) then begin
      prfmsg('RURNF','');
      close(rumorf);
      exit;
    end;

    Dec(deletenum);

    { Finds Rumor to delete and loads it up. }

    Seek(rumorf,DeleteNum);
    Read(rumorf,tmprumor);
    close(rumorf);

    prfmsg('RUDELHDR','');
    If (cso) or (allcaps(thisuser.name)=allcaps(tmprumor.author)) then begin
      If (cso) and (allcaps(thisuser.name)<>allcaps(tmprumor.author)) then
        prfmsg('RURCB',tmprumor.author);
      prfmsg('RUVR4D',tmprumor.rumor);
      If (menur.emulation>=20) and (menur.emulation<=29) then prfmsg('RUDLIT20','')
      Else prfmsg('RUDLITO','');
      If (yn) then begin

        Assign(tmprumorf, systat.SystemPath+temprumorfilename);
        {$I-} Rewrite(tmprumorf); {$I-}
        If IOResult<>0 then Exit;

        Reset(rumorf);

        For i:=0 to DeleteNum-1 do begin
          Seek(rumorf,i);
          Seek(tmprumorf,i);
          Read(rumorf,rumor);
          Write(tmprumorf,rumor);
        End;

        For i:=DeleteNum+1 to FileSize(rumorf)-1 do begin
          Seek(rumorf,i);
          Seek(tmprumorf,i-1);
          Read(rumorf,rumor);
          Write(tmprumorf,rumor);
        End;
        close(tmprumorf);
        close(rumorf);
        Erase(rumorf);
        Rename(tmprumorf, systat.SystemPath+rumorfilename);
      End;
    End
    Else begin
      prfmsg('RUYDMTR','');
    End;
  End;

Begin
  NoRumors:=FALSE;
  Assign(rumorf, systat.SystemPath+rumorfilename);
  {$I-} Reset(rumorf); {$I-}
  If IOResult<>0 then NoRumors:=TRUE
  Else begin
    If (FileSize(rumorf)<1) then NoRumors:=TRUE;
    close(rumorf);
  end;

  If (menur.emulation>=20) and (menur.emulation<=29) then begin
    If NoRumors then begin
      prfmsg('RUNORU20','');
      Exit;
    End;

    Repeat
      prfmsg('RURNTD20','');
      input(s,4);
      If s='?' then begin prfmsg('RUB4RL20',''); Rumor_List; s:='?'; end;
    Until s<>'?';
    if value(s)>0 then DeleteIt(value(s));
    prfmsg('RUAFDL20','');

  End (* Emulation 20-29 *)
  Else Begin (* Other Emulations *)
    If NoRumors then begin
      prfmsg('RUNORUO','');
      Exit;
    End;
   
    Repeat
      prfmsg('RURNTDO','');
      input(s,4);
      If allcaps(s)='L' then begin Rumor_List; s:='L'; end;
    Until s<>'L';
    If value(s)>0 then DeleteIt(value(s));

  End;
End;

End.
