{ķ
                          Revelation BBS Systems                           
                                                       
                                                                             
  FileName   : SYSOP7.PAS                                                    
  Description: Menu Editor System                                            
  Version    : v0.1500                                                       
                                                                             
                                                                           
 Ľ}
{$A+,B+,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop7;

interface

uses
  crt, dos, overlay,
  common,
  sysop7m,
  file9,
  menus2,
  sysop1;

procedure menu_edit;

implementation

Uses File0;

Var
 menuchanged:boolean;
 x:integer;
 filv:text;
 MenuFile:text;

function readin:boolean;                    (* read in the menu file curmenu *)
var s:astr;
    i:integer;
begin
  noc:=0;
  assign(filv,curmenu);
  {$I-} reset(filv); {$I+}
  if ioresult<>0 then begin
    print('"'+allcaps(curmenu)+'" does not exist.');
    readin:=FALSE;
  end else begin
    menuchanged:=FALSE;

    with menur do begin
      readln(filv,menuname[1]);
      readln(filv,menuname[2]);
      readln(filv,menuname[3]);
      readln(filv,directive);
      readln(filv,tutorial);
      readln(filv,menuprompt);
      readln(filv,acs);
      readln(filv,password);
      readln(filv,fallback);
      readln(filv,forcehelplevel);
      readln(filv,gencols);
      for i:=1 to 3 do readln(filv,gcol[i]);
{<!>}

      readln(filv,inputcase);
      readln(filv,inputstyle);
      readln(filv,emulation);

      readln(filv,s);
      s:=allcaps(s); menuflags:=[];
      if (pos('C',s)<>0) then menuflags:=menuflags+[clrscrbefore];
      if (pos('D',s)<>0) then menuflags:=menuflags+[dontcenter];
      if (pos('N',s)<>0) then menuflags:=menuflags+[nomenuprompt];
      if (pos('P',s)<>0) then menuflags:=menuflags+[forcepause];
      if (pos('T',s)<>0) then menuflags:=menuflags+[autotime];
    end;
    repeat
      inc(noc);
      with cmdr^[noc] do begin
        readln(filv,NodeStatus);  {958}
        readln(filv,sdesc);
        readln(filv,ckeys);
        readln(filv,acs);
        readln(filv,cmdkeys);
        readln(filv,mstring);
        readln(filv,s);
        s:=allcaps(s); commandflags:=[];
        if (pos('H',s)<>0) then commandflags:=commandflags+[hidden];
        if (pos('U',s)<>0) then commandflags:=commandflags+[unhidden];
      end;
    until (eof(filv));
    close(filv);

    readin:=TRUE;
  end;
end;

procedure menu_edit;
const showcmdtype:integer=1;
      menudata:boolean=FALSE;
var nocsave,i,i1,i2,ii:integer;
    c:char;
    abort,next:boolean;
    s,scurmenu:astr;

  procedure newcmd(n:integer);                          { new command stuff }
  begin
    with cmdr^[n] do begin
      NodeStatus:='';   {958}
      sdesc:='';
      ckeys:='XXX';
      acs:='';
      cmdkeys:='-L';
      mstring:='';
      commandflags:=[];
    end;
  end;

  procedure moveinto(i1,i2:integer);
  begin
    cmdr^[i1]:=cmdr^[i2];
  end;

  procedure mes;
  var s:astr;
      i:integer;
  begin
    rewrite(filv);
    with menur do begin
      WriteLn(filv,menuname[1]);
      WriteLn(filv,menuname[2]);
      WriteLn(filv,menuname[3]);
      WriteLn(filv,directive);
      WriteLn(filv,tutorial);
      WriteLn(filv,menuprompt);
      WriteLn(filv,acs);
      WriteLn(filv,password);
      WriteLn(filv,fallback);
      WriteLn(filv,forcehelplevel);
      WriteLn(filv,gencols);
      for i:=1 to 3 do WriteLn(filv,gcol[i]);
{<!>}
      WriteLn(filv,inputcase);
      WriteLn(filv,inputstyle);
      WriteLn(filv,emulation);

      s:='';
      if (clrscrbefore in menuflags) then s:=s+'C';
      if (dontcenter in menuflags) then s:=s+'D';
      if (nomenuprompt in menuflags) then s:=s+'N';
      if (forcepause in menuflags) then s:=s+'P';
      if (autotime in menuflags) then s:=s+'T';
      WriteLn(filv,s);
    end;
    for i:=1 to noc do begin
      with cmdr^[i] do begin
        WriteLn(filv,NodeStatus);  {958}
        WriteLn(filv,sdesc);
        WriteLn(filv,ckeys);
        WriteLn(filv,acs);
        WriteLn(filv,cmdkeys);
        WriteLn(filv,mstring);
        s:='';
        if (hidden in commandflags) then s:=s+'H';
        if (unhidden in commandflags) then s:=s+'U';
        WriteLn(filv,s);
      end;
    end;
    close(filv);
    sysoplog('* Saved menu file: '+scurmenu);
  end;

 procedure deletemenufile;
 var filename:string[8];

 begin   {Procedure DeleteMenuFile}
   NL;
   sprompt('^5^1Enter Filename To Delete ^9[^21^9-^28 Chars^9]: ^1');
   Input(FileName,8);
   If (FileName<>'') then begin
     Assign(MenuFile,Systat.MenuPath+FileName+'.MNU');
     {$I-} Reset(MenuFile); {$I-}
     If (IOResult=0) then begin
       if not pynq('Delete "'+filename+'" Menu') then begin
  {    sprompt(#3#3'Delete "'+FileName+'" Menu?'#3#2' ['#3#3'No'#3#2']: ');
       If Not yn then begin }
         sprint('^7Nothing Done!');
         Exit;
       End;
     End;
     {$I-} Erase(MenuFile); {$I-}
     If (IOResult<>0) then sprint('^7Error Deleting File.')
       Else sprint('^5File Deleted.');
   End Else sprint('^7Nothing Done!');

 End;   {Procedure DeleteMenuFile}


 procedure insertmenufile;
 var filename:string[8];
 begin
   nl;
   sprompt('^5^1Enter Filename To Insert ^9[^21^9-^28 Chars^9]: ^1');
   input(filename,8);

   if (filename<>'') then begin
     assign(menufile,systat.menupath+filename+'.MNU');
     {$I-} reset(menufile); {$I-}
     If (IOResult=0) then begin
       if not pynq('File Appears To Exist - Overwrite') then begin
         sprint('^7Nothing Done!');
         exit;
       end;
     end;
     {$I-} rewrite(menufile); {$I-}
     if (IOResult<>0) then begin
       sprint('^7Error Creating File.');
     end else begin
       writeln(menufile,'');
       writeln(menufile,'');
       writeln(menufile,'');
       writeln(menufile,'');
       writeln(menufile,'');

       writeln(menufile,'New Menu Prompt');
       writeln(menufile,'');
       writeln(menufile,'');
       writeln(menufile,'TOP');
       writeln(menufile,'0');
       writeln(menufile,'4');
       writeln(menufile,'4');
       writeln(menufile,'3');
       writeln(menufile,'5');
       writeln(menufile,'0');
       writeln(menufile,'0');
       writeln(menufile,'0');
       writeln(menufile,'');

       writeln(menufile,'');
       writeln(menufile,'');
       writeln(menufile,'');
       writeln(menufile,'');
       writeln(menufile,'');
       writeln(menufile,'');
       writeln(menufile,'');

       close(menufile);

       sprint('^5New Menu File Created.');
       sysoplog('* Inserted new menu file: "'+FileName+'"');
     end;
   end else sprint('^7Nothing Done!');
 End;

  Procedure EditMenuFile;
  var i,j,k:integer;
      c:char;
      b:byte;
      bb:boolean;

    procedure memd(i:integer);                   (* delete command from list *)
    var x:integer;
    begin
      if (i>=1) and (i<=noc) then begin
        for x:=i+1 to noc do cmdr^[x-1]:=cmdr^[x];
        dec(noc);
      end;
    end;

    procedure memi(i:integer);             (* insert a command into the list *)
    var x:integer;
        s:astr;
    begin
      if (i>=1) and (i<=noc+1) and (noc<100) then begin  {958}
        inc(noc);
        if (i<>noc) then
          for x:=noc downto i do cmdr^[x]:=cmdr^[x-1];
        newcmd(i);
      end;
    end;

    procedure memp;
    var i,j,k:integer;
    begin
      prt('^5^1Move Which Command ^9[^21^9-^2'+cstr(noc)+'^9]: ^1'); inu(i);
      if ((not badini) and (i>=1) and (i<=noc)) then begin
        prt('^5^1Move Before Which Command ^9[^21^9-^2'+cstr(noc+1)+'^9]: ^1'); inu(j);
        if ((not badini) and (j>=1) and (j<=noc+1) and
            (j<>i) and (j<>i+1)) then begin
          memi(j);
          if j>i then k:=i else k:=i+1;
          cmdr^[j]:=cmdr^[k];
          if j>i then memd(i) else memd(i+1);
          menuchanged:=TRUE;
        end;
      end;
    end;

    function sfl(b:boolean; c:char):char;
    begin
      if (b) then sfl:=c else sfl:='-';
    end;

  begin
   NL;
   sprompt('^5^1Enter Filename To Edit ^9[^21^9-^28 Chars^9]: ^1');
   Input(s,8);

    assign(filv,systat.menupath+s+'.MNU');
    {$I-} reset(filv); {$I+}
    if ioresult=0 then begin
      close(filv);
      scurmenu:=s;
      curmenu:=systat.menupath+scurmenu+'.MNU';
      if readin then begin
        menuchanged:=FALSE;
        repeat
          if (c<>'?') then begin
            cls;
            abort:=FALSE; next:=FALSE;
            if (menudata) then begin
              nl; sprint('^1Menu Editor'); nl; {writebox('');}
              sprint('    ^1Menu FileName :^2'+scurmenu);
              if (not abort) then begin
                with menur do begin
                  sprint('^9[^21^9]^1 Menu Titles   :^5'+menuname[1]);
                  if (menuname[2]<>'') then sprint('^1    Menu Title #2 :^5'+menuname[2]);
                  if (menuname[3]<>'') then sprint('^1    Menu Title #3 :^5'+menuname[3]);
                  sprint('^9[^22^9]^1 Help files    :^5'+
                        aonoff((directive=''),'*Generic*',directive)+' ^9/^5 '+
                        aonoff((tutorial=''),'*Generic*',tutorial));
                  prt('^9[^23^9]^1 Prompt        :^5'); cl(5); print(menuprompt);
                  sprint('                   ^5^9(^1'+menuprompt+'^9)');
                  sprint('^9[^24^9]^1 ACS Required  :^5"'+acs+'^5"');
                  sprint('^9[^25^9]^1 Password      :^5'+
                        aonoff((password=''),'*None*',password));
                  sprint('^9[^26^9]^1 Fallback Menu :^5'+
                        aonoff((fallback=''),'*None*',fallback));
                  sprint('^9[^27^9]^1 Forced ?-Level:^5'+
                        aonoff((forcehelplevel=0),'None',cstr(forcehelplevel)));
                  if (menur.emulation = 7) then sprint('^9[^28^9]^1 Menu Bar Info : ^5Y:'+cstr(gencols)
                    +' Lo:'+cstr(gcol[1])+' Hi:'+cstr(gcol[2])+' Len:'+cstr(gcol[3]))
                  else sprint('^9[^28^9]^1 Generic Info  :^5'+cstr(gencols)+' cols - '+
                        cstr(gcol[1])+'/'+cstr(gcol[2])+'/'+cstr(gcol[3]));
                  sprint('^9[^29^9]^1 Flags         :^5'+
                        sfl((clrscrbefore in menuflags),'C')+
                        sfl((dontcenter in menuflags),'D')+
                        sfl((nomenuprompt in menuflags),'N')+
                        sfl((forcepause in menuflags),'P')+
                        sfl((autotime in menuflags),'T'));
                  sprint('^9[^2A^9]^1 Input Case    :^5'+cstr(inputcase));
                  sprint('^9[^2B^9]^1 Input Style   :^5'+cstr(inputstyle));
                  sprint('^9[^2C^9]^1 Emulation     :^5'+cstr(emulation));
                  sprint('^9[^2Q^9]^1 Quit');
                end;
              end;
              {writebox(''); writebottom;} nl;
            end else
              showcmds(showcmdtype);
          end;
          nl;
          prt('^5^1Menu Editor ^9[^2?^9/^2Help^9]: ^1');
          onek(c,'Q-DILEPSTX123456789?ABC'^M);
          case c of
            '?':begin
                  nl;
                  sprint('        ^5^9͸');
                  sprint('        ^5^9 ^2Editing Commands ^9');
                  sprint('        ^5^9;');
                  sprint('        ^5^9  ^5'); nl;
                  sprint('^9[^2D^9]^1 Delete Command      ^9[^2P^9]^1 Move Commands');
                  sprint('^9[^2I^9]^1 Insert Command      ^9[^2T^9]^1 Toggle Display Type');
                  sprint('^9[^2E^9]^1 Edit Commands       ^9[^2X^9]^1 Menu Data/Command Data');
                  sprint('^9[^2S^9]^1 Short Generic Menu  ^9[^2L^9]^1 Long Generic Menu');
                  sprint('^9[^2CR^9]^1 ReDisplay Screen   ^9[^2Q^9]^1 Quit And Save');
                  sprint('^9[^2-^9]^1 Abort Menu And Quit');
                  nl;
                end;
            'D':begin
                  prt('^5^1Delete Which Command ^9[^21^9-^2'+cstr(noc)+'^9]: ^1'); ini(b);
                  if (not badini) and (b>=1) and (b<=noc) then begin
                    memd(b);
                    menuchanged:=TRUE;
                  end;
                end;
            'I':if (noc<100) then begin
                  prt('^5^1Insert Before Which Command ^9[^21^9-^2'+cstr(noc+1)+'^9]: ^1');
                  inu(i);
                  if (not badini) and (i>=1) and (i<=noc+1) then begin
                    prt('^5^1Insert How Many Commands ^9[^21^9-^2'+cstr(100-noc)+'^9] [^21^9]: ^1');
                    inu(j);
                    if (badini) then j:=1;
                    if (j>=1) and (j<=100-noc) then begin
                      for k:=1 to j do memi(i);
                      menuchanged:=TRUE;
                    end;
                  end;
                end else begin
                  sprint(#3#7+'You already have 100 commands, delete some to make room.');
                  nl; pausescr;
                end;
            'L':begin
                  genericmenu(3);
                  pausescr;
                end;
            'E':memm(scurmenu,menuchanged);
            'P':memp;
            'S':begin
                  genericmenu(2);
                  pausescr;
                end;
            'T':showcmdtype:=1-showcmdtype;  {* toggle between 0 and 1 *}
            'X':menudata:=not menudata;
            '1':begin
                  nl;
                  sprint('^5Up To Three Menu Titles Are Allowed.');
                  sprint('^5Just Leave UnWanted Titles Set To Null.');
                  for i:=1 to 3 do begin
                    nl; prt('^5^1New Menu Title #'+cstr(i)+': ^5');
										inputwn1(menur.menuname[i],100,'CE',menuchanged);
                  end;
                end;
            '2':begin
                  nl;
                  cl(5); print('Use @S IPL for SL sensitive menus.');
                  sprint(#3#5+'Set to NULL (with " ") to use generic menus.');
                  sprint(#3#5+'You can turn Tutorials completely off by using "*OFF*"');
                  sprint(#3#5+'as the tutorial filename.');
                  nl;
                  prt('^5^1New File Displayed For Help: '); mpl(12);
									inputwn(menur.directive,12,menuchanged);
                  menur.directive:=allcaps(menur.directive);
                  nl;
                  prt('^5^1New Tutorial File ^9[^2Default Ext=".TUT"^9]: ^1'); mpl(12);
									inputwn(menur.tutorial,12,menuchanged);
                  menur.tutorial:=allcaps(menur.tutorial);
                  nl;
                end;
            '3':begin
                  nl; prt('^5^1New Menu Prompt: ');
									inputwn1(menur.menuprompt,120,'CE',menuchanged);
                end;
            '4':begin
                  nl; prt('^5^1New Menu ACS: '); mpl(20);
									inputwn1(menur.acs,20,'CE',menuchanged);
								end;
						'5':begin
									nl; prt('^5^1New Password: '); mpl(15);
									inputwn1(menur.password,15,'Eu',menuchanged);
								end;
						'6':begin
									nl; prt('^5^1New Fallback Menu: '); mpl(8);
									inputwn1(menur.fallback,8,'Eu',menuchanged);
								end;
						'7':begin
									nl; prt('^5^1New Forced Menu Help-Level ^9[^21^9-^23^9, ^20^9/^2None^9] [^2'+
										cstr(menur.forcehelplevel)+'^9]: ^1');
									ini(b);
									if ((not badini) and (b in [0..3])) then begin
										menuchanged:=TRUE;
										menur.forcehelplevel:=b;
									end;
								end;
						'8':begin
								 if (menur.emulation = 7) then begin
									repeat
										nl;
										sprint('^1[C] XY : Y Coordinate:^3'+cstr(menur.gencols));
										sprint('^1[1] Background Lo    :^3'+cstr(menur.gcol[1]));
										sprint('^1[2] Background Hi    :^3'+cstr(menur.gcol[2]));
										sprint('^1[3] Menu Bar Length  :^3'+cstr(menur.gcol[3]));
										nl;
										prt('^5^1Select ^9[^2C^9,^2 1^9-^23^9, ^2Q^9/^2Quit^9]: ^1');
										onek(c,'QC123'^M);
										nl;
										if (c in ['C','1'..'3']) then begin
											case c of
												'C':prt('XY : Y Coordinate ['+
																cstr(menur.gencols)+']: ');
												'3':prt('Menu Bar Length (1-75) ['+
																cstr(menur.gcol[3])+']: ');
											else
														prt('New color '+c+' (16-23) ['+
																cstr(menur.gcol[ord(c)-48])+']: ');
											end;
											ini(b);
											if (not badini) then
												case c of
													'C':if (b in [1..25]) then begin
																menuchanged:=TRUE;
																menur.gencols:=b;
															end;
													'3':if (b in [1..75]) then begin
																menuchanged:=TRUE;
																menur.gcol[3]:=b;
															end;
												else
															if (b in [16..23]) then begin
																menuchanged:=TRUE;
																menur.gcol[ord(c)-48]:=b;
															end;
                        end;
                    end;
                  until ((not (c in ['C','1'..'3'])) or (hangup));
                  c:=#0;

                 end
                 else begin
                  repeat
                    nl;
                    writetop('Generic Info'); writebox('');
                    writebox('[^2C^9]^1 Generic Columns  :^2'+cstr(menur.gencols));
                    writebox('[^21^9]^1 Bracket Color    :^2'+cstr(menur.gcol[1]));
                    writebox('[^22^9]^1 Command Color    :^2'+cstr(menur.gcol[2]));
                    writebox('[^23^9]^1 Description Color:^2'+cstr(menur.gcol[3]));
                    writebox('[^2S^9]^1 Show Menu');
                    writebox(''); writebottom;
                    nl;
                    prt('^5^1Select ^9[^2CS^9, ^21^9-^23^9, ^2Q^9/^2Quit^9]: ^1'); onek(c,'QCS123'^M);
                    nl;
                    if (c='S') then genericmenu(2);
                    if (c in ['C','1'..'3']) then begin
                      case c of
                        'C':prt('^5^1New Number Of Generic Columns ^9[^22^9-^27^9] [^2'+
                                cstr(menur.gencols)+'^9]: ^1');
                      else
                            prt('^5^1New Generic Menu Color '+c+' ^9[^20^9-^29^9] [^2'+
                                cstr(menur.gcol[ord(c)-48])+'^9]: ^1');
                      end;
                      ini(b);
                      if (not badini) then
                        case c of
                          'C':if (b in [2..7]) then begin
                                menuchanged:=TRUE;
                                menur.gencols:=b;
                              end;
                        else
                              if (b in [0..9]) then begin
                                menuchanged:=TRUE;
                                menur.gcol[ord(c)-48]:=b;
                              end;
                        end;
                    end;
                  until ((not (c in ['C','S','1'..'3'])) or (hangup));
                  c:=#0;
                 end;
                end;
            '9':begin
                  nl;
                  writetop('Menu Flags'); writebox('');
                  writebox('[^2C^9]^1 Clear Screen Before Menu     ^9[^2D^9]^1 Don''t Center The Menu Titles');
                  writebox('[^2N^9]^1 No Menu Prompt Displayed     ^9[^2P^9]^1 Force Pause Before Menu Display');
                  writebox('[^2T^9]^1 Auto-Time Display');
                  writebox(''); writebottom;
                  nl;
                  prt('^5^1Select One Of The Above: ^5'); onek(c,'QCDNPT'^M);
                  bb:=menuchanged; menuchanged:=TRUE;
                  with menur do
                    case c of
                      'C':if (clrscrbefore in menuflags) then
                            menuflags:=menuflags-[clrscrbefore]
                       else menuflags:=menuflags+[clrscrbefore];
                      'D':if (dontcenter in menuflags) then
                            menuflags:=menuflags-[dontcenter]
                       else menuflags:=menuflags+[dontcenter];
                      'N':if (nomenuprompt in menuflags) then
                            menuflags:=menuflags-[nomenuprompt]
                       else menuflags:=menuflags+[nomenuprompt];
                      'P':if (forcepause in menuflags) then
                            menuflags:=menuflags-[forcepause]
                       else menuflags:=menuflags+[forcepause];
                      'T':if (autotime in menuflags) then
                            menuflags:=menuflags-[autotime]
                       else menuflags:=menuflags+[autotime];
                    else
                          menuchanged:=bb;
                    end;
                  c:=#0;
                end;
            'A':begin
                 nl;
                 sprint('^9[^20^9] ^1Upper Case Forced');
                 sprint('^9[^21^9] ^1Upper/Lower Case Allowed');
                 nl;
                 prt('Choose: ');
								 input(s,3);
								 If (bytevalue(s)<>menur.inputcase) and (s<>'') then begin
                  menuchanged:=TRUE;
									menur.inputcase:=bytevalue(s);
                 end;
                 c:=#0;
                end;
            'B':begin
                 nl;
                 sprint('^9[^20^9] ^1User defined (in AC flags)');
                 sprint('^9[^21^9] ^1Full-Line forced');
                 sprint('^9[^22^9] ^1One-key forced');
                 nl;
                 prt('Choose: ');
								 input(s,3);
								 If (bytevalue(s)<>menur.inputstyle) and (s<>'') then begin
                  menuchanged:=TRUE;
									menur.inputstyle:=bytevalue(s);
                 end;
                 c:=#0;
                end;
            'C':begin
                 nl;
                 sprint('^9[^20^9] ^1Standard OS/E');
                 sprint('^9[^22^9] ^1MS/IBM DOS');
                 sprint('^9[^25^9] ^1UNIX System V/386');
                 sprint('^9[^27^9] ^1Level 1 Pull Down (Menu Bar)');
                 sprint('^9[^220^9] ^1Forum Hacks');
                 nl;
                 prt('Choose: ');
								 input(s,3);
                 If (bytevalue(s)<>menur.emulation) and (s<>'') then begin
                  menuchanged:=TRUE;
                  menur.emulation:=bytevalue(s);
                 end;
                 c:=#0;
                end;
          end;
        until ((c='Q') or (c='-') or (hangup));
        if (menuchanged) then begin
          If (c='Q') then begin
           sprint(#3#5'Saving Menu.');
           mes;
          end
          else sprint(#3#5'Aborting Edit.');
        end
        Else sprint(#3#5'Nothing Saved.');
      end;
    end;
  end;

Function MenuAlign(InStr:string):string;
Begin
 If pos('.',InStr)=0 then InStr:=mln(s,8)
 Else InStr:=mln(copy(InStr,1,pos('.',InStr)-1),8);
 MenuAlign:=InStr;
End;


 Procedure MenuFileDir(FilePath,FileSpec:string);
 Var
  NoFiles:boolean;
  Count,Column,NumFiles:integer;
  ShowStr:String;

 Begin   {Procedure MenuFileDir}
  FilePath:=FilePath+FileSpec;
  FFile(FilePath);
  NoFiles:=TRUE;
  NumFiles:=0;
  Column:=0;
  ShowStr:=#3#9'    ';
  CLS;
  sprint(#3#5+SoftwareName+' Menu Editor');
  NL;
  sprint(#3#9'    Ŀ');

  While (Found) do begin
    if (not (dirinfo.attr and directory=directory)) {or (fso)} then
      if (not (dirinfo.attr and volumeid=volumeid)) then
        if ((not (dirinfo.attr and dos.hidden=dos.hidden)) {or (UserNum=1)}) then

          If ((dirinfo.attr and dos.hidden=dos.hidden) and
             (not (dirinfo.attr and directory=directory))) or
             (not (dirinfo.attr and dos.hidden=dos.hidden)) then begin
            NoFiles:=FALSE;

            Inc(Column);
            ShowStr:=ShowStr+#3#5+MenuAlign(DirInfo.Name);
            If (Column<7) then ShowStr:=ShowStr+#3#9' '
            Else begin
             sprint(ShowStr+#3#9' ');
             ShowStr:=#3#9'    ';
             Column:=0;
            End;
            Inc(NumFiles);
          End;
    NFile;
  End;
  If (Not Found) and (Column in [1..7]) then begin
   ShowStr:=ShowStr+#3#9;
   For Count:=6 downto Column do ShowStr:=ShowStr+'         ';
   If (Column=7) then ShowStr:=ShowStr+' ';
   sprint(ShowStr);
  End;
  sprint(#3#9'    ');
 End;   {Procedure MenuFileDir}


Begin
  NocSave:=Noc;
  Noc:=0;

  MenuFileDir(Systat.MenuPath,'*.MNU');

  Repeat
    Abort:=FALSE;
    NL;
    prt('^5^1Menu Editor ^9[^2?^9/^2Help^9]:^1 ');
    Onek(c,'?IDEQ'^M);
    Case c of
     '?':begin
            nl;
            sprint('        ^5^9͸');
            sprint('        ^5^9 ^2Editing Commands ^9');
            sprint('        ^5^9;');
            sprint('        ^5^9  ^5'); nl;
            sprint('^9[^2CR^9]^1 ReDisplay Screen   ^9[^2E^9]^1 Edit Menu File');
            sprint('^9[^2I^9]^1 Insert Menu File    ^9[^2D^9]^1 Delete Menu File');
            sprint('^9[^2Q^9]^1 Quit And Save');
            nl;
         end;
     'I':InsertMenuFile;
     'D':DeleteMenuFile;
     'E':EditMenuFile;
     ^M :MenuFileDir(Systat.MenuPath,'*.MNU');
    End;
  Until (c='Q') or (Hangup);

  Noc:=NocSave;
End;

End.
