/*****************************************************************************\
**                                                                           **
**  Functions to manipulate C and Turbo Pascal strings (for use with T.A.G.  **
**  data files).  Written by Martin Pollard.  Released to public domain.     **
**                                                                           **
**  These functions should work with any MS-DOS C compiler that conforms to  **
**  the ANSI/ISO standards for the C language.  All functions were tested    **
**  with Borland's Turbo C++ v1.0 and Borland C++ v3.1 compilers.            **
**                                                                           **
\*****************************************************************************/

#include <ctype.h>
#include <string.h>

/*---------------------------------------------------------------------------*/

/*
**  strtp2c() - Converts a string from Turbo Pascal format to C format.
**              Any T.A.G. color codes that are present are removed.
*/

char *strtp2c(char *d, const char *s)
{
    register int i;
    register char *p;

	i = 1;
    p = d;
    while (i <= s[0])
	{
        if (i < s[0] && (s[i] == 0x03 || s[i] == '^') &&
            (isdigit(s[i+1]) || (s[i+1] >= 0 && s[i+1] <= 9)))
			++i;
		else
            *p++ = s[i];
		++i;
	}
    *p = '\0';
    return(d);
}


/*---------------------------------------------------------------------------*/

/*
**  strc2tp() - Converts a string from C format to Turbo Pascal format.
*/

char *strc2tp(char *d, char *s)
{
	register int i;

    d[0] = strlen(s);
    for (i = d[0]; i > 0; i--)
        d[i] = s[i-1];
    return(d);
}

