/*****************************************************************************

				WWIV Version 4
                    Copyright (C) 1988-1993 by Wayne Bell

Distribution of the source code for WWIV, in any form, modified or unmodified,
without PRIOR, WRITTEN APPROVAL by the author, is expressly prohibited.
Distribution of compiled versions of WWIV is limited to copies compiled BY
THE AUTHOR.  Distribution of any copies of WWIV not compiled by the author
is expressly prohibited.


*****************************************************************************/


#pragma hdrstop

#define _DEFINE_GLOBALS_
#include "vars.h"
#include "subxtr.h"


#include <math.h>


unsigned _stklen=15360;

#define modem_time 3.5

int unx;

int checkpw(void)
{
  char s[81];

  nl();
  prt(2,get_string(616));
  echo=0;
  input(s,20);
  echo=1;
  if (strcmp(s,(syscfg.systempw))==0)
    return(1);
  else
    return(0);
}



void end_bbs(int lev)
{
  sl1(1,"");
  close_strfiles();
  write_inst(INST_LOC_DOWN,0,INST_FLAGS_NONE);
  if (ok_modem_stuff)
    closeport();
  dtr(0);
  outs(wwiv_version);
  outs(" run complete.\r\n\r\n");
  setvect(save_dos,NULL);
  exit(lev);
}


void parse_email_info(char *s, unsigned short *un1, unsigned short *sy1)
{
  char *ss,*ss1,onx[20],ch,*mmk;
  unsigned un, sy;
  int i,nv,on,xx,onxi,odci;
  net_system_list_rec *csne;

  *un1=0;
  *sy1=0;
  ss=strchr(s,'@');
  if (ss==NULL) {
    un=finduser1(s);
    if (un>0)
      *un1=un;
    else
      pl(get_string(8));
  } else {
    ss[0]=0;
    ss=&(ss[1]);
    i=strlen(s);
    while ((i>0) && (s[i-1]==' '))
      --i;
    s[i]=0;
    un=atoi(s);
    sy=atoi(ss);
    ss1=strchr(ss,'.');
    if (ss1)
      ss1++;
    if (sy==0) {
      un=finduser1(s);
      if (un>0)
        *un1=un;
      else
        pl(get_string(8));
    } else {
      if (un==0) {
        strcpy(net_email_name,s);
        i=strlen(net_email_name);
        while ((i>0) && (net_email_name[i-1]==' '))
          --i;
        net_email_name[i]=0;
        if (net_email_name[0])
          *sy1=sy;
        else
          pl(get_string(8));
      } else {
        *un1=un;
        *sy1=sy;
      }
      if (*sy1 && ss1) {
        for (i=0; i<net_num_max; i++) {
          set_net_num(i);
          if (stricmp(ss1,net_name)==0) {
            if (!valid_system(*sy1)) {
              nl();
              outstr(get_string(9));
              npr("%s @%u.\r\n",ss1,*sy1);
              nl();
              *sy1=*un1=0;
            } else {
              if (*sy1==net_sysnum) {
                *sy1=0;
                if (*un1==0)
                  *un1=finduser(net_email_name);
                if ((*un1==0) || (*un1>32767)) {
                  *un1=0;
                  pl(get_string(8));
                }
              }
            }
            break;
          }
        }
        if (i>=net_num_max) {
          nl();
          outstr(get_string(10));
          outstr(ss1);
          nl();
          *sy1=*un1=0;
        }
      } else if (*sy1 && (net_num_max>1)) {
        odc[0]=0;
        odci=0;
        onx[0]='Q';
        onx[1]=0;
        onxi=1;
        nv=0;
        on=net_num;
        ss=malloc(net_num_max);
        xx=-1;
        for (i=0; i<net_num_max; i++) {
          set_net_num(i);
          if (net_sysnum==*sy1) {
            xx=i;
          } else if (valid_system(*sy1)) {
            ss[nv++]=i;
          }
        }
        set_net_num(on);
        if (nv==0) {
          if (xx!=-1) {
            set_net_num(xx);
            *sy1=0;
            if (*un1==0) {
              *un1=finduser(net_email_name);
              if ((*un1==0) || (*un1>32767)) {
                *un1=0;
                pl(get_string(8));
              }
            }
          } else {
            nl();
            pl(get_string(11));
            *sy1=*un1=0;
          }
        } else if (nv==1) {
          set_net_num(ss[0]);
        } else {
          nl();
          for (i=0; i<nv; i++) {
            set_net_num(ss[i]);
            csne=next_system(*sy1);
            if (csne) {
              if (i<9) {
                onx[onxi++]=i+'1';
                onx[onxi]=0;
              } else {
                odci=(i+1)/10;
                odc[odci-1]=odci+'0';
                odc[odci]=0;
              }
              npr("%d. %s (%s)\r\n",i+1,net_name,csne->name);
            }
          }
          pl(get_string(12));
          nl();
          prt(2,get_string(13));
          if (nv<9) {
            ch=onek(onx);
            if (ch=='Q')
              i=-1;
            else
              i=ch-'1';
          } else {
            mmk=mmkey(2);
            if (*mmk=='Q')
              i=-1;
            else
              i=atoi(mmk)-1;
          }
          if ((i>=0) && (i<nv)) {
            set_net_num(ss[i]);
          } else {
            nl();
            pl(get_string(14));
            nl();
            *un1=*sy1=0;
          }
        }
        farfree(ss);
      } else {
        if (*sy1==net_sysnum) {
          *sy1=0;
          if (*un1==0)
            *un1=finduser(net_email_name);
          if ((*un1==0) || (*un1>32767)) {
            *un1=0;
            pl(get_string(8));
          }
        } else if (!valid_system(*sy1)) {
          nl();
          pl(get_string(11));
          *sy1=*un1=0;
        }
      }
    }
  }
}



void mainmenu(void)
{
  char *s, s1[81], s2[81], ch;
  int i, useconf, ac;
  long l;

  s2[0]=0;
  if (usub[cursub].subnum==-1) {
    cursub=0;
    if (usub[cursub].subnum==-1) {
      strcpy(s2,get_string(16));
    }
  }

  write_inst(INST_LOC_MAIN,usub[cursub].subnum,INST_FLAGS_ONLINE);

  tleft(1);
  if ((sysstatus_expert & thisuser.sysstatus)==0)
    printmenu(0);

  nl();
  nl();
  tleft(1);

  useconf=((subconfnum>1) && okconf(&thisuser));

#ifdef OPT_EXTRA_COLOR
  npr("1T 0- 1%s\r\n",ctim(nsl()));
  sprintf(s1,"7[1Conf %c7] [1%s7]",subconfs[uconfsub[curconfsub].confnum].designator,
    stripcolors(subconfs[uconfsub[curconfsub].confnum].name));
  if (s2[0]==0)
    sprintf(s2,"7[1%s%s7] [1%s7]0 : 2",
      useconf?get_string(1398):"",
      usub[cursub].keys,
      stripcolors(subboards[usub[cursub].subnum].name));
#else
  npr("T - %s\r\n",ctim(nsl()));
  sprintf(s1,"[Conf %c] [%s]",subconfs[uconfsub[curconfsub].confnum].designator,
    stripcolors(subconfs[uconfsub[curconfsub].confnum].name));
  if (s2[0]==0)
    sprintf(s2,"[%s%s] [%s] :",
      useconf?get_string(1398):"",
      usub[cursub].keys,
      stripcolors(subboards[usub[cursub].subnum].name));
#endif

  if (useconf) {
    ansic(2);
    pl(s1);
  }
  prt(2,s2);
  helpl=1;
  s=mmkey(0);
  helpl=0;
  if (s[0])
    for (i=0; (i<num_subs) && (usub[i].subnum!=-1); i++)
      if (strcmp(usub[i].keys,s)==0)
        cursub=i;
  if (strlen(s)>2) {
    sprintf(s1,"//%s",s);
    sysopchar(s1);
  } else
    sysopchar(s);
/**************************************************/
  if (so()) {
#ifdef OPT_FAST_SEARCH
    if ((strcmp(s,"ALLOWEDIT")==0) || (strcmp(s,"AE")==0))
      edit_database();
#endif
    if ((strcmp(s,"INSTEDIT")==0) || (strcmp(s,"IE")==0))
      instance_edit();
    if ((strcmp(s,"CONFEDIT")==0) || (strcmp(s,"JE")==0)) {
      write_inst(INST_LOC_CONFEDIT,0,INST_FLAGS_ONLINE);
      edit_confs();
    }
    if ((strcmp(s,"BOARDEDIT")==0) || (strcmp(s,"BE")==0)) {
      write_inst(INST_LOC_BOARDEDIT,0,INST_FLAGS_ONLINE);
      sysoplog(get_stringx(1,2));
      boardedit();
    }
    if ((strcmp(s,"CHAINEDIT")==0) || (strcmp(s,"CE")==0)) {
      write_inst(INST_LOC_CHAINEDIT,0,INST_FLAGS_ONLINE);
      sysoplog(get_stringx(1,4));
      chainedit();
    }
    if (strcmp(s, "CHAT")==0) {
      nl();
      pl(((*(char far *)0x00000417L ^= 0x10) & 0x10) ?
                       get_string(21) :
                       get_string(22));
      sysoplog(get_stringx(1,9));
      topscreen();
    }
    if ((strcmp(s,"CHUSER")==0) || (strcmp(s,"CU")==0)) {
      write_inst(INST_LOC_CHUSER,0,INST_FLAGS_ONLINE);
      chuser();
    }
    if (strcmp(s,"CLOUT")==0) {
      npr("\r\nNot Yet.\r\n");
    /*  force_callout(2); */
    }
    if (strncmp(s,"DEBUG",5)==0) {
      if((s[5]) && (s[5]!=' '))
        debuglevel=s[5]-'0';
      else if(s[6])
        debuglevel=s[6]-'0';
    }
    if ((strcmp(s,"DIREDIT")==0) || (strcmp(s,"DE")==0)) {
      write_inst(INST_LOC_DIREDIT,0,INST_FLAGS_ONLINE);
      sysoplog(get_stringx(1,3));
      dlboardedit();
    }
    if (strcmp(s,"DOS")==0) {
      if (checkpw()) {
        write_inst(INST_LOC_DOS,0,INST_FLAGS_ONLINE);
        sysoplog(get_stringx(1,6));
        shrink_out(getenv("COMSPEC"),1,1,1,0);
        topscreen();
      }
    }
    if ((strcmp(s,"EDIT")==0)) {
      if (checkpw()) {
        write_inst(INST_LOC_TEDIT,0,INST_FLAGS_ONLINE);
        nl();
        prt(2,get_string(7));
        input(s1,50);
        if (s1[0]) {
          if ((okansi()) && (thisuser.defed))
            external_edit(s1,"",thisuser.defed-1,500,".",s1,1);
          else
            tedit(s1);
        }
      }
    }
    if ((strcmp(s,"GFILEEDIT")==0) || (strcmp(s,"GE")==0)) {
      write_inst(INST_LOC_GFILEEDIT,0,INST_FLAGS_ONLINE);
      sysoplog(get_stringx(1,5));
      gfileedit();
    }
    if (strcmp(s,"LOAD")==0) {
      nl();
      prt(2,get_string(7));
      input(s1,50);
      if (s1[0]) {
        nl();
        prt(5,get_string(17));
        if (yn()) {
          nl();
          load_workspace(s1,0);
        } else {
          nl();
          load_workspace(s1,1);
        }
      }
    }
    if (strcmp(s,"MAILR")==0) {
      if (checkpw()) {
        write_inst(INST_LOC_MAILR,0,INST_FLAGS_ONLINE);
        sysoplog(get_stringx(1,8));
        mailr();
      }
    }
    if ((strcmp(s,"REBOOT")==0) && (checkpw())) {
      write_inst(INST_LOC_REBOOT,0,INST_FLAGS_ONLINE);
      dtr(0);
      sysoplog(get_stringx(1,7));
      logoff();
      sl1(1,"");
      if (ok_modem_stuff)
        closeport();
      close_strfiles();
      wait(3.0);
      setvect(0xff,(void interrupt (*) ()) MK_FP(0xffff,0x0000));
      geninterrupt(0xff);
    }
    if (strcmp(s,"RELOAD")==0) {
      write_inst(INST_LOC_RELOAD,0,INST_FLAGS_ONLINE);
      read_new_stuff();
    }
    if (strcmp(s,"RESETF")==0) {
      write_inst(INST_LOC_RESETF,0,INST_FLAGS_ONLINE);
      reset_files();
    }
    if (strcmp(s, "RESETQSCAN")==0) {
      prt(5,get_string(970));
      if (yn()) {
        write_inst(INST_LOC_RESETQSCAN,0,INST_FLAGS_ONLINE);
        memset(qsc, 0, syscfg.qscn_len);
        *qsc=999;
        memset(qsc_n,0xff,((max_dirs+31)/32)*4);
        memset(qsc_q,0xff,((max_subs+31)/32)*4);
        close_qscn();
        sprintf(s1,"%sUSER.QSC", syscfg.datadir);
        unlink(s1);
        for (i=0; i<=number_userrecs(); i++) {
          write_qscn(i, qsc, 1);
        }
        close_qscn();
      }
    }
    if (strcmp(s,"STAT")==0) {
      read_status();
      nl();
      outstr(get_string(18));
      pln(_stklen);
      outstr(get_string(19));
      npr("%dk\r\n", (int) (farcoreleft()/1024));
      outstr(get_string(20));
      npr("%d%%\r\n", cachestat());
      outstr(get_string(938));
      npr("%lu\r\n",status.qscanptr);
      nl();
    }
  }
/**************************************************/
  if (cs()) {
    if (strcmp(s,"IVOTES")==0) {
      write_inst(INST_LOC_VOTE,0,INST_FLAGS_ONLINE);
      sysoplog(get_stringx(1,11));
      ivotes();
    }
    if (strcmp(s,"LOG")==0) {
      slname(date(), s1);
      print_local_file(s1,"");
    }
    if (strcmp(s,"NLOG")==0) {
      print_local_file("NET.LOG","");
    }
    if (strcmp(s,"PENDING")==0) {
      print_pending_list();
    }
    if (strcmp(s,"STATUS")==0) {
      prstatus();
    }
    if (strcmp(s,"TEDIT")==0) {
      write_inst(INST_LOC_TEDIT,0,INST_FLAGS_ONLINE);
      sysoplog(get_stringx(1,12));
      text_edit();
    }
    if ((strcmp(s,"UEDIT")==0) || (strcmp(s,"UE")==0)) {
      write_inst(INST_LOC_UEDIT,0,INST_FLAGS_ONLINE);
      sysoplog(get_stringx(1,10));
      uedit(usernum,0);
    }
    if (strcmp(s,"VOTEPRINT")==0) {
      write_inst(INST_LOC_VOTEPRINT,0,INST_FLAGS_ONLINE);
      voteprint();
    }
    if (strcmp(s,"YLOG")==0) {
      read_status();
      print_local_file(status.log1,"");
    }
    if (strcmp(s,"ZLOG")==0) {
      zlog();
    }
    if ((strcmp(s,",")==0) && ((net_sysnum>0) || (net_num_max>1))) {
      nl();
      prt(2,get_string(23));
      ch=onek("Q012");
      switch(ch) {
        case '0': print_local_file(get_string(1027),""); break;
        case '1': print_local_file(get_string(1028),""); break;
        case '2': print_local_file(get_string(1029),""); break;
      }
    }
    if (strcmp(s,"/?")==0) {
      printmenu(5);
    }
  }
/*************************************************/
  if ((strcmp(s,"UPLOAD")==0) && (actsl>10))
    upload_post();
  if (strcmp(s,"CLS")==0)
    outstr("\f");
  if ((strcmp(s,"NET")==0) || (strncmp(s,"NET=",4)==0))
    print_net_listing(0);
  if (strcmp(s,"QSCAN")==0) {
    nl();
    prt(5,get_string(24));
    if (yn()) {
      read_status();
      for (i=0; i<max_subs; i++)
        qsc_p[i]=status.qscanptr-1L;
      nl();
      pl(get_string(25));
      nl();
    }
  }
  if (strcmp(s,"VER")==0) {
    nl();
    npr("%s   (%s)\r\n",wwiv_version, wwiv_date);
    nl();
    outstr("Options: ");
    outstr(opt_str);
    nl();
    nl();
    pl("The author may be contacted at:");
    nl();
    pl("   Wayne Bell");
    pl("   WWIV Software Services");
    pl("   PO Box 720455");
    pl("   McAllen, TX  78504-0455");
    nl();
  }
  if (strcmp(s,"WHO")==0) {
    multi_instance();
  }
  if (strcmp(s,"/A")==0) {
    write_inst(INST_LOC_SUBS,usub[cursub].subnum,INST_FLAGS_ONLINE);
    express=0;
    expressabort=0;
    if ((uconfsub[1].confnum!=-1) && (okconf(&thisuser))) {
      ac=1;
      tmp_disable_conf(1);
    }
    nscan(0);
    if (ac)
      tmp_disable_conf(0);
  }
  if (strcmp(s,"/E")==0)
    slash_e();
  if (strcmp(s,"/N")==0)
    nscan(cursub);
  if (strcmp(s,"/O")==0)
    hangup=1;
  if (strcmp(s,"/C")==0) {
    write_inst(INST_LOC_CHATROOM,0,INST_FLAGS_ONLINE);
    if (exist("WWIVCHAT.EXE"))
      shrink_out("WWIVCHAT.EXE", 1, 1, 1, 1);
    else
      chat_room();
  }
#ifdef OPT_SLASH_S_Z
  if (strcmp(s,"/Z")==0) {
    prt(5,get_string(935));
    if (yn()) {
      pl(get_string(26));
      set_x_only(1, "POSTS.TXT", 0);
      nscan(0);
      set_x_only(0, NULL, 0);
      add_arc("OFFLINE", "POSTS.TXT", 0);
      download_temp_arc("OFFLINE", 0);
    }
  }
#endif
  if ((s[1]==0) && (s[0]!=0)) {
    switch(s[0]) {
      case '}':
        if (okconf(&thisuser)) {
          if ((curconfsub<subconfnum-1) && (uconfsub[curconfsub+1].confnum>=0))
            ++curconfsub;
          else
            curconfsub=0;
          setuconf(CONF_SUBS, curconfsub, -1);
        }
        break;
      case '>':
      case '+':
      case ']':
        if ((cursub<num_subs-1) && (usub[cursub+1].subnum>=0))
          ++cursub;
        else
          cursub=0;
        break;
      case '{':
        if (okconf(&thisuser)) {
          if (curconfsub>0)
            --curconfsub;
          else {
            while ((uconfsub[curconfsub+1].confnum>=0) && (curconfsub<subconfnum-1))
              ++curconfsub;
          }
          setuconf(CONF_SUBS, curconfsub, -1);
        }
        break;
      case '<':
      case '-':
      case '[':
        if (cursub>0)
          --cursub;
        else {
          while ((usub[cursub+1].subnum>=0) && (cursub<num_subs-1))
            ++cursub;
        }
        break;
      case '!':
        helpl=14;
        if (!cs())
          return;
        nl();
        nl();
        pl(get_string(15));
        outstr(":");
        input(s1,30);
        i=finduser1(s1);
        if (i>0) {
          sysoplog(get_stringx(1,13));
          valuser(i);
        } else
          pl(get_string(8));
        break;
      case '.':
        helpl=26;
        write_inst(INST_LOC_CHAINS,0,INST_FLAGS_ONLINE);
        existprint(get_string(1030));
        do_chains();
        break;
      case '$':
        write_inst(INST_LOC_BANK,0,INST_FLAGS_ONLINE);
        time_bank();
        break;
      case 'A':
        helpl=19;
        write_inst(INST_LOC_AMSG,0,INST_FLAGS_ONLINE);
        write_automessage();
        break;
      case 'B':
        bbslist();
        break;
      case 'C':
        helpl=3;
        reqchat();
        break;
      case 'D':
        helpl=4;
        write_inst(INST_LOC_DEFAULTS,0,INST_FLAGS_ONLINE);
        if (existprint(get_string(1031)))
          pausescr();
        defaults();
        break;
      case 'E':
        send_email();
        break;
      case 'F':
        write_inst(INST_LOC_FEEDBACK,0,INST_FLAGS_ONLINE);
        feedback(0);
        break;
      case 'G':
        helpl=28;
        write_inst(INST_LOC_GFILES,0,INST_FLAGS_ONLINE);
        existprint(get_string(1032));
        gfiles();
        break;
      case 'H':
        hop_sub();
        break;
      case 'I':
        nl();
        npr("%s   (%s)\r\n",wwiv_version, wwiv_date);
        nl();
        existprint(get_string(1033));
        existprint(get_string(1034));
        break;
      case 'J':
        if (okconf(&thisuser))
          jump_conf(CONF_SUBS);
        break;
      case 'K':
        helpl=8;
        write_inst(INST_LOC_KILLEMAIL,0,INST_FLAGS_ONLINE);
        kill_old_email();
        break;
      case 'L':
        existprint(get_string(1035));
        break;
      case 'M':
        readmail();
        break;
      case 'N':
        write_inst(INST_LOC_SUBS,65535,INST_FLAGS_ONLINE);
        express=0;
        expressabort=0;
        nscan(0);
        break;
      case 'O':
        nl();
        nl();
        prt(5,get_string(28));
        helpl=12;
        if (yn()) {
          write_inst(INST_LOC_LOGOFF,0,INST_FLAGS_ONLINE);
          outchr(12);
          outstr(get_string(29));
          pl(ctim(timer()-timeon));
          existprint(get_string(1036));
          hangup=1;
        }
        break;
      case 'P':
        irt[0]=0;
        irt_name[0]=0;
        grab_quotes(NULL, NULL);
        if (usub[0].subnum!=-1)
          post();
        break;
      case 'Q':
        write_inst(INST_LOC_SUBS,usub[cursub].subnum,INST_FLAGS_ONLINE);
        i=0;
        express=0;
        expressabort=0;
        qscan(cursub,&i);
        break;
      case 'R':
        write_inst(INST_LOC_SUBS,usub[cursub].subnum,INST_FLAGS_ONLINE);
        helpl=15;
        remove_post();
        break;
      case 'S':
        write_inst(INST_LOC_SUBS,usub[cursub].subnum,INST_FLAGS_ONLINE);
        express=0;
        expressabort=0;
        scan2();
        break;
      case 'T':
        if (syscfg.sysconfig & sysconfig_no_xfer) {
          nl();
          pl(get_string(30));
          nl();
          break;
        }
        if ((udir[0].subnum==-1) && (okconf(&thisuser))) {
          for (curconfdir=0;
               (curconfdir<dirconfnum) &&
               (uconfdir[curconfdir].confnum!=-1);
               curconfdir++) {
            setuconf(CONF_DIRS, curconfdir, -1);
            if (udir[0].subnum!=-1)
              break;
          }
        }
        if (udir[0].subnum!=-1) {
          write_inst(INST_LOC_XFER,udir[curdir].subnum,INST_FLAGS_ONLINE);
          curdloads=1;
          existprint(get_string(1037));
        } else {
          nl();
          pl(get_string(31));
          nl();
        }
        break;
      case 'U':
      case '~':
        list_users(0);
        break;
      case 'V':
        write_inst(INST_LOC_VOTE,0,INST_FLAGS_ONLINE);
        helpl=18;
        vote();
        break;
      case 'W':
        printmenu(15);
        break;
      case 'X':
        thisuser.sysstatus ^= sysstatus_expert;
        break;
      case 'Y':
        yourinfo();
        break;
      case 'Z':
        express=1;
        expressabort=0;
        tmp_disable_pause(1);
        nscan(0);
        express=0;
        expressabort=0;
        tmp_disable_pause(0);
        break;
      case '?':
        if ((sysstatus_expert & thisuser.sysstatus))
          printmenu(0);
        break;
      case '#':
        nl();
        pl(get_string(939));
        nl();
      case '*': sublist(); break;
    }
  }
  helpl=0;
}


void dlmainmenu(void)
{
  char *s, s1[81],s2[81],ch;
  int i,i1,i2,abort,next,useconf,ac;
  messagerec m;

  s2[0]=0;
  if (udir[curdir].subnum==-1) {
    curdir=0;
    if (udir[curdir].subnum==-1) {
      strcpy(s2,get_string(32));
    }
  }

  write_inst(INST_LOC_XFER,udir[curdir].subnum,INST_FLAGS_ONLINE);

  tleft(1);
  if ((sysstatus_expert & thisuser.sysstatus)==0)
    printmenu(3);

  nl();
  nl();
  tleft(1);

  useconf=((dirconfnum>1) && okconf(&thisuser));

#ifdef OPT_EXTRA_COLOR
  npr("1T 0- 1%s\r\n",ctim(nsl()));
  sprintf(s1,"7(1Conf %c7)0-7(1%s7)",dirconfs[uconfdir[curconfdir].confnum].designator,
    stripcolors(dirconfs[uconfdir[curconfdir].confnum].name));
  if (s2[0]==0)
    sprintf(s2,"7(1%s%s7)0-7(1%s7)0 : 2",
      useconf?get_string(1399):"",
      udir[curdir].keys,
      stripcolors(directories[udir[curdir].subnum].name));
#else
  npr("T - %s\r\n",ctim(nsl()));
  sprintf(s1,"(Conf %c)-(%s)",dirconfs[uconfdir[curconfdir].confnum].designator,
    stripcolors(dirconfs[uconfdir[curconfdir].confnum].name));
  if (s2[0]==0)
    sprintf(s2,"(%s%s)-(%s) :",
      useconf?get_string(1399):"",
      udir[curdir].keys,
      stripcolors(directories[udir[curdir].subnum].name));
#endif
  if (useconf) {
    ansic(2);
    pl(s1);
  }
  prt(2,s2);
  helpl=2;
  s=mmkey(1);
  helpl=0;
  if (s[0])
    for (i=0; i<num_dirs; i++)
      if (strcmp(udir[i].keys,s)==0)
        curdir=i;
  if (strlen(s)>2) {
    sprintf(s1,"//%s",s);
    sysopchar(s1);
  } else
    sysopchar(s);

  if (strcmp(s,"/A")==0) {
    nl();
    ac=0;
    if ((uconfsub[1].confnum!=-1) && (okconf(&thisuser))) {
      ac=1;
      tmp_disable_conf(1);
    }
    helpl=13;
    abort=0;
    num_listed=0;
    tagging=1;
    titled=1;
    nscanall();
    tagging=0;
    if (ac)
      tmp_disable_conf(0);
  }

  if (strcmp(s,"/O")==0)
    hangup=1;
#ifdef OPT_SLASH_S_Z
  if (strcmp(s,"/S")==0) {
    tagging=2;
    prt(5,get_string(935));
    if (yn()) {
      pl(get_string(26));
      set_x_only(1,"FILES.TXT", 1);
      searchall();
      set_x_only(0, NULL, 0);
      add_arc("TEMP", "FILES.TXT", 0);
      download_temp_arc("TEMP", 0);
    }
  }
#endif

  /* Anyone commands here */
  if (strcmp(s,"WHO")==0) {
    multi_instance();
  }

  /* download cosysop checks here */
  if (dcs()) {

    if (strcmp(s,"/?")==0)
      printmenu(8);

    if (strcmp(s,"READIDZ")==0)
      read_idz();

    if (strcmp(s,"UPLOADALL")==0) {
      i1=0;
      for (i=0; (i<num_dirs) && (udir[i].subnum>=0) && (!i1); i++) {
        nln(2);
        outstr(get_string(33));
        pl(directories[udir[i].subnum].name);
        nl();
        i1=uploadall(i);
      }
    }

    if (strcmp(s,"UPLOAD")==0)
      uploadall(curdir);

    if (strcmp(s,"REN")==0) {
      helpl=39;
      rename_file();
    }

    if (strcmp(s,"MOVE")==0)
      move_file();

    if (strcmp(s,"SORT")==0) {
      nl();
      prt(2,get_string(37));
      i=yn();
      nl();
      prt(2,get_string(38));
      if (yn())
        i1=2;
      else
        i1=0;
      if (i)
        sort_all(i1);
      else
        sortdir(udir[curdir].subnum,i1);
    }

    if (strcmp(s,"RSORT")==0) {
      sort_all(1);
    }

#ifdef OPT_FAST_SEARCH
    if ((strcmp(s,"ALLOWEDIT")==0) || (strcmp(s,"AE")==0))
      edit_database();
#endif

  }

  /* sysop checks now */
  if (so()) {

    if (strcmp(s,"UPLOADFILE")==0) {
      nl();
      pl(get_string(34));
      pl(get_string(35));
      nl();
      prt(5,get_string(36));
      ch=onek("Q12");
      nl();
      if (ch!='Q') {
        outstr(get_string(7));
        inputl(s2,80);
        switch(ch) {
          case '1': i2=2; break;
          case '2': i2=0; break;
          default : i2=0; break;
        }
        upload_files(s2,curdir,i2);
      }
    }

    if ((strcmp(s,"DIREDIT")==0) || (strcmp(s,"DE")==0)) {
      sysoplog(get_stringx(1,3));
      dlboardedit();
    }

    if (strncmp(s,"DEBUG",5)==0) {
      if((s[5]) && (s[5]!=' '))
        debuglevel=s[5]-'0';
      else if(s[6])
        debuglevel=s[6]-'0';
    }

    if (strcmp(s,"DOS")==0) {
      if (checkpw()) {
        sysoplog(get_stringx(1,6));
        shrink_out(getenv("COMSPEC"),1,1,1,0);
        topscreen();
      }
    }
  }

  /* single-key commands here */
  if ((s[1]==0) && (s[0]!=0)) {
    switch(s[0]) {
      case '}':
        if (okconf(&thisuser)) {
          if ((curconfdir<dirconfnum-1) && (uconfdir[curconfdir+1].confnum>=0))
            ++curconfdir;
          else
            curconfdir=0;
          setuconf(CONF_DIRS, curconfdir, -1);
        }
        break;
      case '>':
      case '+':
      case ']':
        if ((curdir<num_dirs-1) && (udir[curdir+1].subnum>=0))
          ++curdir;
        else
          curdir=0;
        break;
      case '{':
        if (okconf(&thisuser)) {
          if (curconfdir>0)
            --curconfdir;
          else {
            while ((uconfdir[curconfdir+1].confnum>=0) && (curconfdir<dirconfnum-1))
              ++curconfdir;
          }
          setuconf(CONF_DIRS, curconfdir, -1);
        }
        break;
      case '<':
      case '-':
      case '[':
        if (curdir>0)
          --curdir;
        else {
          while ((udir[curdir+1].subnum>=0) && (curdir<num_dirs-1))
            ++curdir;
        }
        break;
      case '#':
        nl();
        pl(get_string(939));
        nl();
      case '*': dirlist(); break;
      case '~': list_users(1); break;
      case 'Q': curdloads=0; break;
      case '.':
        if (dcs()) {
          if (!exist(dszlog))
            break;
          print_local_file(dszlog,"");
        }
        break;
      case '^':
        if (so())
          print_devices();
        break;
      case '?':
        if ((sysstatus_expert & thisuser.sysstatus))
          printmenu(3);
        break;
      case 'A':
        helpl=23;
        arc_l();
        break;
      case 'B':
        helpl=22;
        batchdl(0);
        break;
      case 'C':
        helpl=3;
        reqchat();
        break;
      case 'D':
        helpl=20;
        existprint(get_string(1038));
        download();
        break;
      case 'E':
        helpl=29;
        temp_extract();
        break;
      case 'F':
        helpl=21;
        tagging=1;
        finddescription();
        tagging=0;
        break;
      case 'G':
        helpl=30;
        temporary_stuff();
        break;
      case 'H':
        hop_dir();
        break;
      case 'J':
        if (okconf(&thisuser))
          jump_conf(CONF_DIRS);
        break;
      case 'L':
        tagging=1;
        listfiles();
        tagging=0;
        break;
      case 'M':
        helpl=31;
        if (dcs())
          move_file();
        break;
      case 'N':
#ifdef OPT_SETLDATE
        helpl=13;
        setldate();
#endif
        abort=0;
        num_listed=0;
        tagging=1;
        titled=1;
        nl();
        prt(5,get_string(39));
        if (yn())
          nscanall();
        else {
          nl();
          nscandir(curdir,&abort);
          if (num_listed) {
            endlist(2);
          } else {
            nl(); ansic(2);
            pl(get_string(1039));
          }
        }
        tagging=0;
        break;
      case 'O':
        helpl=12;
        nl();
        nl();
        prt(5,get_string(28));
        if (yn()) {
          outchr(12);
          outstr(get_string(29));
          pl(ctim(timer()-timeon));
          existprint(get_string(1036));
          hangup=1;
        }
        break;
      case 'P':
        helpl=13;
        setldate();
        break;
      case 'R':
        helpl=38;
        removefile();
        break;
      case 'S':
        tagging=1;
        searchall();
        tagging=0;
        break;
      case 'T':
        helpl=32;
        xfer_defaults();
        break;
      case 'U':
        helpl=17;
        existprint(get_string(1040));
        if ((thisuser.restrict & (restrict_validate | restrict_upload)) ||
            (syscfg.sysconfig & sysconfig_all_sysop)) {
          if (syscfg.newuploads<num_dirs)
            upload((int) syscfg.newuploads);
          else
            upload(0);
        } else
          upload(udir[curdir].subnum);
        break;
      case 'V':
        helpl=23;
        arc_l();
        break;
      case 'W':
        printmenu(16);
        break;
      case 'X':
        helpl=22;
        batchdl(0);
        break;
      case 'Y':
        yourinfodl();
        break;
      case 'Z':
        nl();
        nl();
        pl(get_string(40));
        nl();
        helpl=17;
        upload(0);
        break;
    }
  }
  helpl=0;
}


int date_changed(void)
{
  struct date today,today1;

  getdate(&today);
  getdate(&today1);
  if (today.da_day==today1.da_day)
    return(0);
  else
    return(1);
}


void print_local_file(char *ss, char *ss1)
{
  char s[81];
  char s1[81];
  char *bs;

  bs=strchr(ss,'\\');
  if ((syscfg.sysconfig & sysconfig_list) && (!incom)) {
    if (!bs) {
      sprintf(s,"%s %s%s",get_string(1041),syscfg.gfilesdir,ss);
      if (ss1[0]) {
        bs=strchr(ss1,'\\');
        if (!bs)
          sprintf(s1,"%s %s%s",s,syscfg.gfilesdir,ss1);
        else
          sprintf(s1,"%s %s",s,ss1);
        strcpy(s,s1);
      }
    } else {
      sprintf(s,"%s %s",get_string(1041),ss);
      if (ss1[0]) {
        bs=strchr(ss1,'\\');
        if (!bs)
          sprintf(s1,"%s %s%s",s,syscfg.gfilesdir,ss1);
        else
          sprintf(s1,"%s %s",s,ss1);
        strcpy(s,s1);
      }
    }
    do_remote(s,1);
    if (useron) {
      clrscrb();
      topscreen();
    }
  } else {
    printfile(ss);
    nl();
    nl();
    pausescr();
  }
}


void getcaller(void)
{
  char s[81],ch,lokb,*ss;
  int any,fast=0,i,i2;
  double d;
  userrec tu;

  c_sub=c_dir=0;

  frequent_init();
  sl1(1,"");
  imodem(0);
  usernum=0;
  wfc=0;
  write_inst(INST_LOC_WFC,0,INST_FLAGS_NONE);
  read_user(1,&thisuser);
  read_qscn(1,qsc,0);
  usernum=1;
  reset_act_sl();
  fwaiting=thisuser.waiting;
  if (thisuser.inact & inact_deleted) {
    thisuser.screenchars=80;
    thisuser.screenlines=25;
  }
  screenlinest=defscreenbottom+1;
  d=(1.0+timer()) / 102.723;
  d-=floor(d);
  d*=10000.0;
  srand((unsigned int)d);
  do {
    giveup_timeslice();
    set_net_num(0);
    any=0;
    wfc=1;
    if (date_changed())
      if (date_changed()) {
        printf("\n\nClock Corrupted.\n\n");
        printf("Should put BBS in a batch file like:\n\n");
        printf("copy con: wwiv.bat\n");
        printf(":top\n");
        printf("setclock\n");
        printf("bbs\n");
        printf("if errorlevel 1 goto top\n");
        printf("^Z\n");
        end_bbs(noklevel);
      }
    if ((strcmp(date(), status.date1)!=0)) {
      if (instance==1) {
        holdphone(1);
        beginday();
        holdphone(0);
        clrscrb();
      }
    }
    check_event();
    if (do_event) {
      run_event();
      any=1;
    }
    lokb=0;
    strcpy(curspeed,get_string(1042));
    if ((!any) && ((rand() % 8000)==0) && (net_sysnum) &&
                   (ok_modem_stuff) && (instance==1)) {
      attempt_callout();
      any=1;
    }
    okskey=0;
    ch=upcase(inkey());
    if (ch) {
      wfc=2;
      any=1;
      switch(ch) {
        case '=':
          if (ok_local())
            reset_files();
          break;
        case '?':
          if (ok_local()) {
            i=7;
            do {
              clrscrb();
              nl();
              printmenu(i);
              ch=upcase(getkey());
              if ((ch!=' ') && (ch!=27))
                if (i==7)
                  i=19;
                else
                  i=7;
            } while ((ch!=' ') && (ch!=27));
          }
          break;
        case ' ':
          outs(get_string(41));
          d=timer();
          while ((!kbhitb()) && (fabs(timer()-d)<60.0));
          if (kbhitb()) {
            ch=upcase(getchd1());
            if (ch==str_yes[0]) {
              outs(str_yes);
              outstr("\r\n");
              lokb=1;
              if ((syscfg.sysconfig & sysconfig_off_hook)==0)
                dtr(0);
            } else {
              if (!ok_local())
                break;
              ss=get_string(42);
              if (ch==upcase(*ss)) {
                unx=1;
                fast=1;
              } else {
                switch (ch) {
                  case '1':
                  case '2':
                  case '3':
                  case '4':
                  case '5':
                  case '6':
                  case '7':
                  case '8':
                  case '9':
                    fast=1;
                    unx=ch-48;
                    break;
                }
              }
              read_status();
              if ((!fast) || (unx>status.users))
                break;
              read_user(unx,&tu);
              if ((tu.sl!=255) || (tu.inact & inact_deleted))
                break;
              usernum=unx;
              i=wfc; wfc=0;
              read_user(usernum,&thisuser);
              read_qscn(usernum,qsc,0);
              wfc=i;
              outchr(ch);
              outs("\r\n\r\n\r\n\r\n\r\n\r\n");
              lokb=2;
              if ((syscfg.sysconfig & sysconfig_off_hook)==0)
                dtr(0);
              reset_act_sl();
              changedsl();
              if (set_language(thisuser.language)) {
                thisuser.language=0;
                set_language(thisuser.language);
              }
              break;
            }
            if (ch==0)
              getchd1();
          }
          if (!lokb)
            out1ch(12);
          break;
        case 'A':
          if (!ok_modem_stuff)
            break;
          answer_phone();
          break;
        case 'B':
          okskey=1;
          if (ok_local()) {
            write_inst(INST_LOC_BOARDEDIT,0,INST_FLAGS_NONE);
            holdphone(1);
            boardedit();
            cleanup_net();
            holdphone(0);
          }
          okskey=0;
          break;
        case 'C':
          okskey=1;
          if (ok_local()) {
            write_inst(INST_LOC_CHAINEDIT,0,INST_FLAGS_NONE);
            holdphone(1);
            chainedit();
            holdphone(0);
          }
          okskey=0;
          break;
        case 'D':
          okskey=1;
          if (ok_local()) {
            write_inst(INST_LOC_DIREDIT,0,INST_FLAGS_NONE);
            holdphone(1);
            dlboardedit();
            holdphone(0);
          }
          okskey=0;
          break;
        case 'W':
          okskey=1;
          if (ok_local()) {
            write_inst(INST_LOC_TEDIT,0,INST_FLAGS_NONE);
            holdphone(1);
            text_edit();
            holdphone(0);
          }
          okskey=0;
          break;
        case 'F':
          if (ok_local()) {
            write_inst(INST_LOC_DOS,0,INST_FLAGS_NONE);
            holdphone(1);
            nl();
            pl(get_string(43));
            nl();
            setvect(save_dos,NULL);
            do_remote(getenv("COMSPEC"),0);
            setvect(save_dos, getvect(INT_REAL_DOS));
            out1ch(12);
            cleanup_net();
            holdphone(0);
          }
          break;
        case 'G':
          okskey=1;
          if (ok_local()) {
            write_inst(INST_LOC_GFILEEDIT,0,INST_FLAGS_NONE);
            holdphone(1);
            gfileedit();
            holdphone(0);
          }
          okskey=0;
          break;
        case 'I':
          okskey=1;
          if (ok_local()) {
            write_inst(INST_LOC_VOTEEDIT,0,INST_FLAGS_NONE);
            holdphone(1);
            ivotes();
            holdphone(0);
          }
          okskey=0;
          break;
        case 'J':
          if (ok_local()) {
            holdphone(1);
            edit_confs();
            holdphone(0);
          }
          break;
        case 'K':
          if (ok_local()) {
            usernum=1;
            useron=1;
            holdphone(1);
            okskey=1;
            prt(2,get_string(44));
            input(s,50);
            load_workspace(s,0);
            send_email();
            okskey=0;
            useron=0;
            write_user(1,&thisuser);
            cleanup_net();
            holdphone(0);
          }
          break;
        case 'L':
          if (ok_local()) {
            read_status();
            slname(date(), s);
            print_local_file(s,status.log1);
          }
          break;
        case 'M':
          okskey=1;
          if (ok_local()) {
            write_inst(INST_LOC_MAILR,0,INST_FLAGS_NONE);
            holdphone(1);
            mailr();
            holdphone(0);
          }
          okskey=0;
          break;
        case 'N':
          if (ok_local())
            print_local_file("NET.LOG","NETDAT*.LOG");
          break;
        case 'P':
          if (ok_local())
            print_pending_list();
          break;
        case 'Q':
          end_bbs(QUIT_LEVEL);
          break;
        case 27:
          outstr(get_string(1043));
          if (yn())
            end_bbs(QUIT_LEVEL);
          clrscrb();
          break;
        case 'R':
          if (ok_local()) {
            usernum=1;
            holdphone(1);
            okskey=1;
            readmail();
            okskey=0;
            write_user(1,&thisuser);
            cleanup_net();
            holdphone(0);
          }
          break;
        case 'S':
          if (ok_local()) {
            prstatus();
            getkey();
          }
          break;
        case 'T':
          if ((ok_local()) && (syscfg.terminal[0])) {
            if (syscfg.sysconfig & sysconfig_shrink_term)
              shrink_out(syscfg.terminal,0,0,0,1);
            else
              run_external(syscfg.terminal);
            imodem(1);
            imodem(0);
          }
          break;
        case 'U':
          okskey=1;
          if (ok_local()) {
            write_inst(INST_LOC_UEDIT,0,INST_FLAGS_NONE);
            holdphone(1);
            uedit(1,0);
            holdphone(0);
          }
          okskey=0;
          break;
        case 'E':
          if (ok_local()) {
            usernum=1;
            useron=1;
            holdphone(1);
            okskey=1;
            send_email();
            okskey=0;
            useron=0;
            write_user(1,&thisuser);
            cleanup_net();
            holdphone(0);
          }
          break;
        case 'X':
          for(i=0;i<50;i++) {
            if(xenviron[i]!=NULL)
              npr("\r\nxenv %d=%s",i,xenviron[i]);
          }
          npr("\r\nreal=%x, new=%x",INT_REAL_DOS,save_dos);
          nl();
          pausescr();
        break;
        case 'Y':
          if (ok_local()) {
            read_status();
            slname(date(), s);
            print_local_file(status.log1,s);
          }
          break;
        case 'Z':
          if (ok_local()) {
            zlog();
            nl();
            getkey();
          }
          break;
        case '/':
          if ((net_sysnum) && (ok_local()))
            force_callout(0);
          break;
        case '.':
          if ((net_sysnum) && (ok_local()))
            force_callout(1);
          break;
        case ',':
          if ((net_sysnum>0) || (net_num_max>1) && ok_local()) {
            nl();
            prt(2,get_string(23));
            ch=onek("Q012");
            switch (ch) {
              case '0':
                print_local_file(get_string(1027),"");
                break;
              case '1':
                print_local_file(get_string(1028),"");
                break;
              case '2':
                print_local_file(get_string(1029),"");
                break;
            }
          }
          break;
        case '`':
          if ((net_sysnum) && (ok_local())) {
            holdphone(1);
            print_net_listing(1);
            holdphone(0);
          }
          break;
        case 9:
          if (ok_local()) {
            holdphone(1);
            instance_edit();
            holdphone(0);
          }
          break;
      }
      if (!incom && !lokb) {
        frequent_init();
        read_user(1,&thisuser);
        read_qscn(1,qsc,0);
        fwaiting=thisuser.waiting;
        reset_act_sl();
        usernum=1;
      }
      okskey=0;
      catsl();
      write_inst(INST_LOC_WFC, 0, INST_FLAGS_NONE);
    }
    if ((comhit()) && (ok_modem_stuff) && (!lokb)) {
      any=1;
      if (peek1c()==10)
        get1c();
      else {
        outs("* ");
        if (mode_switch(1.0,0)==mode_ring)
          answer_phone();
        else if (modem_mode == mode_con) {
          incom=outcom=1;
          if (!(modem_flag & flag_ec))
            wait1(45);
          else
            wait1(2);
        }
      }
    }
    if (!any) {
      giveup_timeslice();
      if (c_sub<num_subs) {
        if (!sub_dates[c_sub]) {
          any=1;
          iscan_hash(c_sub);
        }
        c_sub++;
      } else if (c_dir<num_dirs) {
        if (!dir_dates[c_dir]) {
          any=1;
          dliscan_hash(c_dir);
        }
        c_dir++;
      } else {
        if (labs(timer1()-mult_time) > 1000L) {
          cleanup_net();
          mult_time=timer1();;
          giveup_timeslice();
        } else {
          giveup_timeslice();
        }
      }
    }
  } while ((!incom) && (!lokb) && (!endday));
  if (lokb)
    modem_speed = modem_i->defl.modem_speed;
  using_modem=incom;
  if (lokb==2)
    using_modem=-1;
  okskey=1;
  if (!endday) {
    clrscrb();
    if (modem_mode==mode_fax)
      outs(get_string(45));
    else
      outs(get_string(46));
    outs(curspeed);
    outs("...\r\n");
  }
  wfc=0;
}


void gotcaller(unsigned int ms, unsigned int cs)
{
  double d;

  frequent_init();
  com_speed = cs;
  modem_speed = ms;
  sl1(1,"");
  read_user(1,&thisuser);
  read_qscn(1,qsc,0);
  reset_act_sl();
  usernum=1;
  if (thisuser.inact & inact_deleted) {
    thisuser.screenchars=80;
    thisuser.screenlines=25;
  }
  screenlinest=25;
  clrscrb();
  outs(get_string(46));
  outs(curspeed);
  outs("...\r\n");
  if (ms) {
    set_baud(cs);
    incom=1;
    outcom=1;
    using_modem=1;
  } else {
    using_modem=incom=outcom=0;
  }
  d=(timer()) / 102.723;
  d-=floor(d);
  d*=10000.0;
  srand((unsigned int)d);
}


void hang_it_up(void)
{
  int i;

  hangup=1;
  dtr(0);
  if (cdet()) {
    wait1(9);
    if (cdet()) {
      wait1(9);
      if (cdet()) {
        i=0;
        dtr(1);
        while ((i++<2) && (cdet())) {
          wait1(27);
          pr1("\x1\x1\x1");
          wait1(54);
          if (modem_i->hang[0])
            pr1(modem_i->hang);
          else
            pr1("ATH\r");
          wait1(6);
        }
      }
    }
  }
  dtr(1);
}



void main(int argc, char *argv[])
{
  char s[81],ch,frc[81], rf[30],*ss;
  int i,i1,num_min=0;
  unsigned int ui=0, us=0;
  double dt;
  unsigned short c_s,c_o;
  int this_usernum=0;

  ss=getenv("BBS");
  if (ss) {
    if (strncmp(ss,"WWIV",4)==0) {
      printf("You are already in the BBS, type 'EXIT' instead.\n\n");
      exit(-1);
    }
  }
  ss=getenv("WWIV_INSTANCE");
  if(ss) {
    instance=atoi(ss);
    if ((instance<=0) || (instance>999)) {
      printf("WWIV_INSTANCE can only be 1..999\n");
      exit(-1);
    }
  } else {
    instance=1;
  }
  already_on=0;
  endday=0;
  oklevel=0;
  noklevel=0;
  ooneuser=0;
  no_hangup=0;
  ok_modem_stuff=1;
  debuglevel=0;
  oklevel=OK_LEVEL;
  noklevel=NOK_LEVEL;
  if (instance > 1)
    sprintf(rf,"RESTORE.%3.3d",instance);
  else
    sprintf(rf,"RESTORE.WWV");
  if (exist(rf))
    restoring_shrink=1;
  else
    restoring_shrink=0;

  frc[0]=0;

  for (i=1; i<argc; i++) {
    strcpy(s,argv[i]);
    if ((s[0]=='-') || (s[0]=='/')) {
      ch=upcase(s[1]);
      switch(ch) {
        case 'C':
          flow_control=1;
          break;
        case 'B':
          ui=(unsigned int) atol(&(s[2]));
          if ((ui%300)==0) {
            ultoa((unsigned long) ui,curspeed,10);
            if (!us)
              us=ui;
            already_on=1;
          } else {
            ui=us=0;
            if (stricmp(&(s[2]),get_string(1042))==0) {
              strcpy(curspeed,get_string(1042));
              already_on=1;
            }
          }
          break;
        case 'D':
          debuglevel=atoi(&(s[2]));
          break;
        case 'F':
          strcpy(frc,s+2);
          strupr(frc);
          already_on=1;
          break;
        case 'S':
          us=(unsigned int) atol(&(s[2]));
          if (us%300) {
            us=ui;
          }
          break;
        case 'N':
          oklevel=atoi(&(s[2]));
          break;
        case 'A':
          noklevel=atoi(&(s[2]));
          break;
        case 'O':
          ooneuser=1;
          break;
        case 'H':
          no_hangup=1;
          break;
        case 'I':
          i1=atoi(&(s[2]));
          if ((i1!=instance) || (!getenv("WWIV_INSTANCE"))) {
            printf("\r\nEnvironment variable %s and /I%d (instance) must match.\r\n",ss,i1);
            exit(noklevel);
          }
          share_installed();
          break;
        case 'M':
          ok_modem_stuff=0;
          break;
        case 'X':
          c_s=strtol(&(s[2]),NULL,16);
          c_o=strtol(&(s[7]),NULL,16);
          if (c_s && c_o) {
            point_shrink=MK_FP(c_s, c_o);
          }
          break;
        case 'R':
          num_min=atoi(&(s[2]));
          break;
        case 'V':
          this_usernum=atoi(&(s[2]));
          if (!already_on)
            strcpy(curspeed,"KB");
          already_on=1;
          break;
        case '?':
          printf("WWIV Bulletin Board\n\n");
          printf("BBS /B<rate> /S<rate> /N<level> /A<level> /R<min> /O /H /M /X /F /C /V<num>/?\n\n");
          printf("  /B - someone already logged on at rate (modem speed)\n");
          printf("  /S - used only with /B, indicates com port speed\n");
          printf("  /N - normal exit level\n");
          printf("  /A - abnormal exit level\n");
          printf("  /R - specify max # minutes until event\n");
          printf("  /O - quit WWIV after one user done\n");
          printf("  /H - don't hang up on user when he logs off\n");
          printf("  /M - don't access modem at all\n");
          printf("  /X - pointer to bbs.com info\n");
          printf("  /F - pass full result code (\"CONNECT 9600/ARQ/HST/HST/V.42BIS\")\n");
          printf("  /C - enable CTS/RTS flow control\n");
          printf("  /V - pass usernumber online\n");
          printf("  /? - display command line options\n\n");
          exit(0);
      }
    }
  }

  init();

  if (syscfg.sysconfig & sysconfig_no_local) {
    this_usernum=0;
    already_on=0;
  }

  if (frc[0])
    process_full_result(frc);

  if (num_min) {
    syscfg.executetime=(timer()+num_min*60)/60;
    if (syscfg.executetime>1440)
      syscfg.executetime-=1440;
    syscfg.executestr[0]=0;
    time_event=((double)syscfg.executetime)*60.0;
    last_time=time_event-timer();
    if (last_time<0.0)
      last_time+=24.0*3600.0;
  }

  if (restoring_shrink) {
    restoring_shrink=0;
    switch(restore_data(rf)) {
      case -1: /* hanging up */
        goto hanging_up;
      case 0: /* WFC */
        goto wfc_label;
      case 1: /* main menu */
      case 2:
        goto main_menu_label;
    }
  }

  do {

    if (this_usernum) {
      usernum=this_usernum;
      read_user(usernum, &thisuser);
      if ((thisuser.inact & inact_deleted)==0) {
        gotcaller(ui, us);
        usernum=this_usernum;
        read_user(usernum,&thisuser);
        read_qscn(usernum, qsc, 0);
        reset_act_sl();
        changedsl();
        checkit=0;
        okmacro=1;
        if ((!hangup) && (usernum>0) && (thisuser.restrict & restrict_logon) &&
          (strcmp(date(),thisuser.laston)==0) && (thisuser.ontoday>0)) {
          nl();
          pl(get_string(361));
          nl();
          hangup=1;
        }
      } else
        this_usernum=0;
    }
    if (!this_usernum) {
      wait1(9);
      if (already_on)
        gotcaller(ui, us);
      else
        getcaller();
    }
    if (modem_mode==mode_fax) {
      /* nothing here yet */
      goto hanging_up;
    }
    if (using_modem>-1) {
      if (!using_modem)
        holdphone(1);
      if (!this_usernum)
        getuser();
    } else {
      holdphone(1);
      using_modem=0;
      checkit=0;
      okmacro=1;
      usernum=unx;
      reset_act_sl();
      changedsl();
    }
    this_usernum=0;
    if (!hangup) {
      if ((strcmp(date(), status.date1)!=0))
        beginday();
      logon();
main_menu_label:
      setiia(90);
      set_net_num(0);
      while (!hangup) {
        switch(curdloads) {
          case 2:
            write_inst(INST_LOC_CHAINS,0,INST_FLAGS_ONLINE);
            do_chains();
          break;
          case 1:
            write_inst(INST_LOC_XFER,udir[curdir].subnum,INST_FLAGS_ONLINE);
            dlmainmenu();
          break;
          case 0:
          default:
            write_inst(INST_LOC_MAIN,usub[cursub].subnum,INST_FLAGS_ONLINE);
            mainmenu();
          break;
        }
      }
      logoff();
    }

hanging_up:
    if ((!no_hangup) && (using_modem) && ok_modem_stuff) {
      hang_it_up();
    }
    catsl();
    frequent_init();
wfc_label:
    cleanup_net();
    if (!using_modem)
      holdphone(0);
    if ((!no_hangup) && ok_modem_stuff)
      dtr(0);
    already_on=0;
    if (sysop_alert && (!kbhitb())) {
      dtr(1);
      wait1(2);
      holdphone(1);
      dt=timer();
      clrscrb();
      nl();
      pl(get_string(47));
      nl();
      while ((!kbhitb()) && (fabs(timer()-dt)<60.0)) {
        setbeep(1);
        wait1(9);
        setbeep(0);
        wait1(18);
      }
      clrscrb();
      holdphone(0);
    }
    sysop_alert=0;
  } while ((!endday) && (!ooneuser));

  outs("\f");
  end_bbs(oklevel);
}

