/*****************************************************************************

				WWIV Version 4
                    Copyright (C) 1988-1993 by Wayne Bell

Distribution of the source code for WWIV, in any form, modified or unmodified,
without PRIOR, WRITTEN APPROVAL by the author, is expressly prohibited.
Distribution of compiled versions of WWIV is limited to copies compiled BY
THE AUTHOR.  Distribution of any copies of WWIV not compiled by the author
is expressly prohibited.


*****************************************************************************/



#include "vars.h"

#pragma hdrstop

int ok_local(void)
{
  if (syscfg.sysconfig& sysconfig_no_local)
    return(0);
  else
    return(1);
}


int finduser1(unsigned char *sx)
{
  int i,i1,i2;
  unsigned char s[81],s1[81],ch;
  userrec u;

  if (sx[0]==0)
    return(0);
  i=finduser(sx);
  if (i>0)
    return(i);
  strcpy(s,sx);
  for (i=0; s[i]!=0; i++)
    s[i]=upcase(s[i]);
  i2=0;
  read_status();
  for (i=0; (i<status.users) && (i2==0); i++) {
    if (strstr(smallist[i].name,s)!=NULL) {
      i1=smallist[i].number;
      read_user(i1,&u);
      sprintf(s1,"%s %s %s ? ",get_string(618), nam(&u,i1), get_string(619));
      prt(5,s1);
      ch=ynq();
      if (ch=='Y')
        i2=i1;
      if (ch=='Q')
        i=status.users;
    }
  }
  return(i2);
}

void slname(char *d, char *s)
{
  sprintf(s,"%c%c%c%c%c%c.LOG",
    d[6],d[7],d[0],d[1],d[3],d[4]);
}

void islname(char *s)
{
  sprintf(s,"INST-%3.3d.LOG",instance);
}

#define CAT_BUFSIZE 8192
void catsl(void)
{
  char s[81], s1[81], instname[81], wholename[81];
  int fi, fo, i;
  char *buf;

  islname(s1);
  sprintf(instname,"%s%s",syscfg.gfilesdir, s1);

  if (exist(instname)) {
    slname(date(), s);
    sprintf(wholename, "%s%s",syscfg.gfilesdir, s);

    buf=malloca(CAT_BUFSIZE);
    if (buf) {
      fo=sh_open(wholename, O_RDWR|O_BINARY|O_CREAT, S_IREAD|S_IWRITE);
      if (fo>0) {
        sh_lseek(fo, 0L, SEEK_END);

        fi=sh_open1(instname, O_RDONLY|O_BINARY);
        if (fi>0) {
          do {
            i=sh_read(fi, buf, CAT_BUFSIZE);
            if (i>0)
              sh_write(fo, buf, i);
          } while (i==CAT_BUFSIZE);

          sh_close(fi);
          unlink(instname);
        }
        sh_close(fo);
      }
      farfree(buf);
    }
  }
}

void sl1(int cmd,char *s)
{
  static int midline=0;
  static char slfn[81];
  char l[180],ch1,*ss;
  int i,f=-1;

  if (!slfn[0]) {
    strcpy(slfn, syscfg.gfilesdir);
    islname(slfn+strlen(slfn));
  }

  switch(cmd) {
    case 0: /* Write line to sysop's log */
      f=sh_open(slfn,O_RDWR | O_CREAT | O_BINARY, S_IREAD | S_IWRITE);
      if(f<0) {
        /* sysop log ? */
        return;
      }
      if (filelength(f)) {
        sh_lseek(f,-1L,SEEK_END);
        sh_read(f,((void *)&ch1),1);
        if (ch1==26)
          sh_lseek(f,-1L,SEEK_END);
      }

      if (midline) {
        sprintf(l,"\r\n%s",s);
        midline = 0;
      } else {
        sprintf(l,"%s",s);
      }
      if (syscfg.sysconfig & sysconfig_printer)
        fprintf(stdprn,"%s\r\n",l);
      i=strlen(l);
      l[i++]='\r';
      l[i++]='\n';
      l[i]=0;
      sh_write(f,(void *)l,i);
      f=sh_close(f);
    break;
    case 4:
      f = sh_open(slfn, O_RDWR | O_CREAT | O_BINARY, S_IREAD | S_IWRITE);
      if(f<0) {
        /* sysop log ? */
        return;
      }
      if (filelength(f)) {
        sh_lseek(f, -1L, SEEK_END);
        sh_read(f, ((void *)&ch1), 1);
        if (ch1 == 26)
          sh_lseek(f, -1L, SEEK_END);
     }
     if (!midline || ((midline + 2 + strlen(s)) > 78)) {
       strcpy(l, midline ? "\r\n   " : "   ");
       strcat(l, s);
       midline = 3 + strlen(s);
     } else {
       strcpy(l, ", ");
       strcat(l, s);
       midline += (2 + strlen(s));
     }
     if (syscfg.sysconfig & sysconfig_printer)
       fprintf(stdprn, "%s", l);
     i = strlen(l);
     sh_write(f, (void *)l, i);
     f=sh_close(f);
     break;
  }
}



void sysopchar(char *s)
{
  if ((incom || (actsl != 255)) && (s[0]))
    sl1(4, s);
}

void sysoplog(char *s)
{
  char s1[180];

  if ((incom) || (actsl!=255)) {
    sprintf(s1,"   %s",s);
    sl1(0,s1);
  }
}


void ssm(unsigned int un, unsigned int sy, char *s)
{
  int  f,i,i1;
  userrec u;
  char s1[161];
  shortmsgrec sm;
  net_header_rec nh;

  if ((un==65535) || (un==0))
    return;
  if (sy==0) {
    read_user(un,&u);
    if (!(u.inact & inact_deleted)) {
      sprintf(s1,"%sSMW.DAT",syscfg.datadir);
      f=sh_open(s1,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
      if (f<0)
        return;
      i=(int) (filelength(f) / sizeof(shortmsgrec));
      i1=i-1;
      if (i1>=0) {
        sh_lseek(f,((long) (i1)) * sizeof(shortmsgrec), SEEK_SET);
        sh_read(f,(void *)&sm,sizeof(shortmsgrec));
        while ((sm.tosys==0) && (sm.touser==0) && (i1>0)) {
          --i1;
          sh_lseek(f,((long) (i1)) * sizeof(shortmsgrec), SEEK_SET);
          sh_read(f,(void *)&sm,sizeof(shortmsgrec));
        }
        if ((sm.tosys) || (sm.touser))
          ++i1;
      } else
        i1=0;
      sm.tosys=sy;
      sm.touser=un;
      strncpy(sm.message,s,80);
      sm.message[80]=0;
      sh_lseek(f,((long) (i1)) * sizeof(shortmsgrec), SEEK_SET);
      sh_write(f,(void *)&sm,sizeof(shortmsgrec));
      sh_close(f);
      u.sysstatus |= sysstatus_smw;
      write_user(un,&u);
    }
  } else if (net_sysnum && valid_system(sy)) {
    nh.tosys=sy;
    nh.touser=un;
    nh.fromsys=net_sysnum;
    nh.fromuser=usernum;
    nh.main_type = main_type_ssm;
    nh.minor_type=0;
    nh.list_len=0;
    time((long *)&nh.daten);
    if (strlen(s)>80)
      s[80]=0;
    nh.length=strlen(s);
    nh.method=0;
    sprintf(s1,"%sP0%s",net_data,nete);
    f=sh_open(s1,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
    sh_lseek(f,0L,SEEK_END);
    sh_write(f,(void *)&nh,sizeof(net_header_rec));
    sh_write(f,(void *)s,nh.length);
    sh_close(f);
  }
}

