/*****************************************************************************

				WWIV Version 4
                    Copyright (C) 1988-1993 by Wayne Bell

Distribution of the source code for WWIV, in any form, modified or unmodified,
without PRIOR, WRITTEN APPROVAL by the author, is expressly prohibited.
Distribution of compiled versions of WWIV is limited to copies compiled BY
THE AUTHOR.  Distribution of any copies of WWIV not compiled by the author
is expressly prohibited.


*****************************************************************************/



#include "vars.h"

#pragma hdrstop

#include <dir.h>
#include <process.h>
#include <math.h>


static int checking_event;

#define SCROLL_UP(t,b,l) \
  _CH=t;\
  _DH=b;\
  _BH=curatr;\
  _AL=l;\
  _CL=0;\
  _DL=79;\
  _AH=6;\
  my_video_int();


unsigned char getkeyext(void)
{
  unsigned char ch;
  static int holding=0;
  static char held=0;

  if (holding) {
    holding=0;
    return(held);
  }
  ch=getkey();
  if (charbufferpointer==0) {
    if (ch==16) {
      ch=getkey();
      if ((ch==1) && (charbufferpointer==0)) {
        strcpy(charbuffer,&(thisuser.macros[2][0]));
        ch=charbuffer[0];
        if (ch) {
          charbufferpointer=1;
          return(ch);
        } else
          return(getkeyext());
      } else
        if ((ch==4) && (charbufferpointer==0)) {
          strcpy(charbuffer,&(thisuser.macros[0][0]));
          ch=charbuffer[0];
          if (ch) {
            charbufferpointer=1;
            return(ch);
          } else
            return(getkeyext());
        } else
          if ((ch==6) && (charbufferpointer==0)) {
            strcpy(charbuffer,&(thisuser.macros[1][0]));
            ch=charbuffer[0];
            if (ch) {
              charbufferpointer=1;
              return(ch);
            } else
              return(getkeyext());
          } else {
            holding=1;
            held=ch;
            return(16);
          }
    }
  }
  return(ch);
}


void cd_to(char *s)
{
  char s1[81];
  int i,db;

  strcpy(s1,s);
  i=strlen(s1)-1;
  db=(s1[i]=='\\');
  if (i==0)
    db=0;
  if ((i==2) && (s1[1]==':'))
    db=0;
  if (db)
    s1[i]=0;
  chdir(s1);
  if (s[1]==':')
    setdisk(s[0]-'A');
}

void get_dir(char *s, int be)
{
  strcpy(s,"X:\\");
  s[0]='A'+getdisk();
  getcurdir(0,&(s[3]));
  if (be) {
    if (s[strlen(s)-1]!='\\')
      strcat(s,"\\");
  }
}


void initporte(int port_num)
/* This function initializes the com buffer, setting up the interrupt,
 * and com parameters
 */
{
  int temp;

  if (!ok_modem_stuff)
    return;
  disable();
  temp=port_num;
  setvect(8+async_irq,async_isr);
  head=tail=0;
  outportb(base+3,0x03);
  temp=inportb(base+5);
  temp=inportb(base);
  temp=inportb(0x21);
  temp=temp & ((1 << async_irq) ^ 0x00ff);
  outportb(0x21,temp);
  outportb(base+1,0x01);
  temp=inportb(base+4);
  outportb(base+4,temp | 0x0A);
  enable();
  dtr(1);
  reset_colors();
  ansic(0);
}



int do_it(char *cl)
{
  int i,i1,l;
  char s[160];
  char *ss[30];

  sl1(1,"");
  strcpy(s,cl);
  ss[0]=s;
  i=1;
  l=strlen(s);
  for (i1=1; i1<l; i1++)
    if (s[i1]==32) {
      s[i1]=0;
      ss[i++]=&(s[i1+1]);
    }
  ss[i]=NULL;
  funcs[20]=NULL;
  i=spawnvpe(P_WAIT,ss[0],ss,xenviron);
  funcs[20]=NULL;
  return(i);
}



int do_remote(char *s, int ccc)
{
  int rc,i;
  char x[161];

  sl1(1,"");

  if (useron) {
    write_user(usernum,&thisuser);
    write_qscn(usernum,qsc,0);
  }
  close_strfiles();
  if (!checking_event) {
    checkhangup();
    if (hangup)
      return(32767);
  }
  sprintf(x,"%s /C %s", getenv("COMSPEC"), s);
  if (ccc)
    rc=do_it(x);
  else
    rc=do_it(s);
  chdir(cdir);
  setdisk(cdir[0]-'A');
  initporte(syscfgovr.primaryport);
  if (useron) {
    i=useron;
    useron=0;
    read_user(usernum,&thisuser);
    read_qscn(usernum,qsc,0);
    useron=i;
  }
  return(rc);
}

void checka1(void)
{
  char ch;
  long d1;

  while ((!empty()) && (!(abortext)) && (!hangup)) {
    ch=inkey();
    switch(ch) {
      case 3:
      case 32:
      case 24:
        abortext=1;
        break;
      case 'P':
      case 'p':
      case 19:
        d1=timer1();
        while ((inkey()==0) && (labs(timer1()-d1)<3276L) && (!hangup))
          checkhangup();
        lines_listed=0;
        break;
    }
  }
}


union REGS ca_r;
int ca_pause,ca_ctrl_c;
long ca_d1;


void checka2(void)
{
  ca_pause=0;
  ca_ctrl_c=0;
  ca_r.h.ah=1;
  int86(0x16,&ca_r,&ca_r);
  if ((ca_r.x.flags & 64)==0) {
    if (ca_r.x.ax==11779)
      ca_ctrl_c=1;
    if (ca_r.x.ax==7955)
      ca_pause=1;
  }
  if (head!=tail) {
    if (buffer[tail]==3)
      ca_ctrl_c=1;
    if (buffer[tail]==19)
      ca_pause=1;
  }
  if (ca_pause) {
    while (inkey()!=0)
      ;
    ca_d1=timer1();
    while ((inkey()==0) && (labs(timer1()-ca_d1)<3276L) && (!hangup))
      checkhangup();
    lines_listed=0;
  }
  if ((ca_ctrl_c) && (nextext)) {
    while (inkey()!=0)
      ;
    pl("^C");
    ca_r.x.ax=0x4c00;
    int86(save_dos,&ca_r,&ca_r);
  }
}






int run_external(char *s)
{
  return(do_remote(s,1));
}


int run_external_ul(char *s)
{
  int i;

  checking_event=1;
  i=do_remote(s,1);
  checking_event=0;
  return(i);
}



int run_external1(char *s)
{
  return(do_remote(s,0));
}



void outdosstr(char *s)
/* This function outputs a string of characters to the screen (and remotely
 * if applicable).  The com port is also checked first to see if a remote
 * user has hung up
 */
{
  int i;

  checkhangup();
  if (hangup==0) {
    i=0;
    while ((s[i] !='$') && (i<1024)) {
      checka2();
      outchr(s[i++]);
    }
  }
}


union REGS ni_r;
struct SREGS ni_s;
unsigned ni_n;
char ni_ch,ni_ch1,ni_ss[10],ni_ch2;
unsigned char *ni_st;

#define ST_SIZE 500
static unsigned short ni_stack[ST_SIZE];


#pragma warn -par

void far interrupt newintr1(unsigned bp, unsigned di, unsigned si,
                           unsigned ds, unsigned es, unsigned dx,
                           unsigned cx, unsigned bx, unsigned ax,
                           unsigned ip, unsigned cs, unsigned flags)
{

  unsigned short ni_SS, ni_SP;
#define NEW_STK() { _BX=FP_OFF(&ni_stack[ST_SIZE-2]); _SS=_DS; _SP=_BX; }
#define OLD_STK() { _AX=ni_SS; _BX=ni_SP; _SS=_AX; _SP=_BX; }



  ni_r.x.ax=ax;
  ni_r.x.bx=bx;
  ni_r.x.cx=cx;
  ni_r.x.dx=dx;
  ni_r.x.si=si;
  ni_r.x.di=di;
  ni_r.x.flags=flags;
  ni_s.ds=ds;
  ni_s.es=es;

  ni_SS=_SS;
  ni_SP=_SP;

  ni_ch=ni_r.h.ah;
  ni_ch1=0;

  switch(ni_ch) {
    case 0x01:
      NEW_STK();
      ni_ch=getkeyext();
      outchr(ni_ch);
      if (hangup)
        ni_ch=3;
      ni_r.h.al=ni_ch;
      ni_ch1=1;
      OLD_STK();
      break;
    case 0x02:
      NEW_STK();
      outchr(ni_r.h.dl);
      ni_ch1=1;
      checka2();
      OLD_STK();
      break;
    case 0x06:
      NEW_STK();
      if (ni_r.h.dl!=0xff) {
        outchr(ni_r.h.dl);
        ni_ch1=1;
      } else {
        if (empty()) {
          ni_r.x.flags |= 64;
        } else {
          ni_r.x.flags &= (0xffff ^ 64);
          ni_r.h.al=getkeyext();
        }
      }
      OLD_STK();
      break;
    case 0x07:
      NEW_STK();
      ni_ch1=1;
      ni_r.h.al=getkeyext();
      OLD_STK();
      break;
    case 0x08:
      NEW_STK();
      ni_ch1=1;
      ni_r.h.al=getkeyext();
      OLD_STK();
      break;
    case 0x09:
      NEW_STK();
      outdosstr((char *) MK_FP(ni_s.ds, ni_r.x.dx));
      ni_ch1=1;
      OLD_STK();
      break;
    case 0x0a:
      NEW_STK();
      ni_st=(char *) MK_FP(ni_s.ds,ni_r.x.dx);
      ni_n=(unsigned int)(ni_st[0]);
      if (in_extern==2)
        getkeyext();
      in_extern=0;
      input_extern=1;
      input1(&(ni_st[2]),ni_n-3,1,0);
      input_extern=0;
      in_extern=1;
      ni_st[1]=strlen(&(ni_st[2]));
      strcat(&(ni_st[2]),"\r");
      if ((hangup)) {
        strcpy(&(ni_st[2]),"EXIT\r");
        ni_st[1]=4;
        outs("Exiting...");
      }
      ni_ch1=1;
      OLD_STK();
      break;
    case 0x0b:
      NEW_STK();
      if (empty())
        ni_r.h.al=0x00;
      else
        ni_r.h.al=0xff;
      ni_ch1=1;
      OLD_STK();
      break;
    case 0x0c:
      ni_r.h.ah=ni_r.h.al;
      int86x(INT_REAL_DOS,&ni_r,&ni_r,&ni_s);
      ni_ch1=1;
      break;
    case 0x3f:
      if (ni_r.x.bx==0x0000) {
        NEW_STK();
        ni_st=(char *)MK_FP(ni_s.ds,ni_r.x.dx);
        inputl(ni_st,ni_r.x.cx);
        strcat(ni_st,"\r\n");
        ni_r.x.ax=strlen(ni_st);
        if (hangup)
          ni_r.x.ax=0;
        ni_r.x.flags &=(0xffff ^ 1);
        ni_ch1=1;
        OLD_STK();
      } else
        int86x(save_dos,&ni_r,&ni_r,&ni_s);
      break;
    case 0x40:
      if ((ni_r.x.bx==0x0001) || (ni_r.x.bx==0x0002)) {
        NEW_STK();
        ni_st=(char *)MK_FP(ni_s.ds,ni_r.x.dx);
        for (ni_n=0; ni_n<ni_r.x.cx; ni_n++) {
          outchr(ni_st[ni_n]);
          checka2();
        }
        ni_r.x.ax=ni_r.x.cx;
        ni_r.x.flags &=(0xffff ^ 1);
        ni_ch1=1;
        OLD_STK();
      } else
        int86x(save_dos,&ni_r,&ni_r,&ni_s);
      break;
    default:
      int86x(save_dos,&ni_r,&ni_r,&ni_s);
      break;
  }

  if (ni_ch1) {
    if (arcling) {
      if ((nextext) && (!abortext)) {
        checka1();
        if (abortext) {
          ni_r.x.ax=0x4c00;
          int86x(save_dos,&ni_r,&ni_r,&ni_s);
        }
      }
    }
    checkhangup();
    if (hangup) {
      if (hanguptime1<0L) {
        hanguptime1=timer1();
        if (funcs[20]) {
          outs("Terminating...\r\n");
          ip=FP_OFF(funcs[20]);
          cs=FP_SEG(funcs[20]);
          funcs[20]=(void far *)36;
        } else {
          funcs[20]=(void far *)36;
          outs("Aborting...\r\n");
          ni_r.x.ax=0x4c00;
          int86x(save_dos,&ni_r,&ni_r,&ni_s);
        }
      } else {
        if (((unsigned long) funcs[20])>500)
          funcs[20]=(void far *)36;
        if (labs(timer1()-hanguptime1)>(long)funcs[20]) {
          hanguptime1=timer1();
          outs("Aborting...\r\n");
          ni_r.x.ax=0x4c00;
          int86x(save_dos,&ni_r,&ni_r,&ni_s);
        }
      }
    }
  }

  ax=ni_r.x.ax;
  bx=ni_r.x.bx;
  cx=ni_r.x.cx;
  dx=ni_r.x.dx;
  si=ni_r.x.si;
  di=ni_r.x.di;
  flags=ni_r.x.flags;
  ds=ni_s.ds;
  es=ni_s.es;
}


#pragma warn +par

int do_external(char *s, int enab)
{
  unsigned short sav;
  int ookskey;

  checkhangup();
  if (hangup)
    return(0);
  in_extern=1;
  hanguptime1=-1L;
  abortext=0;
  nextext=enab;
  arcling=1;
  ookskey=okskey;
  okskey=0;
  sav=syscfg.sysconfig;
  if ((syscfg.sysconfig & sysconfig_no_local)==0)
    syscfg.sysconfig |= sysconfig_no_local;
  setvect(save_dos,getvect(INT_REAL_DOS));

  set_global_handle(0);

  setvect(INT_REAL_DOS,newintr1);

  do_remote(s,1);

  setvect(INT_REAL_DOS,getvect(save_dos));

  if (abortext) {
    nl();
    nl();
  }

  syscfg.sysconfig=sav;
  if (in_extern==2)
    getkey();
  in_extern=0;
  okskey=ookskey;
  return(abortext);
}


int full_external(char *s, int ctc, int ccc)
{
  unsigned short sav;
  int ookskey,cy,cx,xxx;

  sl1(1,"");
  checkhangup();
  if (hangup)
    return(0);
  in_extern=1;
  ookskey=okskey;
  okskey=0;
  hanguptime1=-1L;
  arcling=0;
  if (screenlinest>defscreenbottom-topline)
    set_protect(0);
  abortext=0;
  nextext=ctc;
  sav=syscfg.sysconfig;
  if ((syscfg.sysconfig & sysconfig_no_local)==0)
    syscfg.sysconfig |= sysconfig_no_local;

  setvect(save_dos,getvect(INT_REAL_DOS));

  set_global_handle(0);

  setvect(INT_REAL_DOS,newintr1);

  if ((screenlinest<=defscreenbottom) && (screenlinest>20)) {
    screenbottom=screenlinest-1+topline;
    cy=wherey();
    cx=wherex();
    xxx=cy-screenbottom+topline;
    if (xxx>0) {
      SCROLL_UP(topline,defscreenbottom,xxx);
      movecsr(cx,screenbottom);
    }
  }

  do_remote(s,ccc);

  screenbottom=defscreenbottom;

  setvect(INT_REAL_DOS,getvect(save_dos));

  if (abortext) {
    nl();
    nl();
  }

  syscfg.sysconfig=sav;
  okskey=ookskey;
  if (in_extern==2)
    getkey();
  in_extern=0;
  if (!wfc)
    topscreen();
  return(abortext);
}

char *create_chain_file(void)
{
  char s[81],gd[81],dd[81], fn[81], cspeed[15];
  static char fpn[81];
  long l,l1;
  FILE *f;

  ultoa(com_speed,cspeed,10);
  if ((com_speed==1) || (com_speed==49664))
    strcpy(cspeed,"115200");

  create_drop_files(cspeed);
  cd_to(syscfg.gfilesdir);
  get_dir(gd,1);
  cd_to(cdir);
  cd_to(syscfg.datadir);
  get_dir(dd,1);
  cd_to(cdir);
  islname(s);
  l=(long) (timeon);
  if (l<0)
    l += 3600*24;
  l1=(long) (timer()-timeon);
  if (l1<0)
    l1 += 3600*24;

  if (instance>1)
    sprintf(fn,"CHAIN.%3.3d",instance);
  else
    strcpy(fn,"CHAIN.TXT");

  unlink(fn);
  f=fsh_open(fn,"wt");
  if (f) {
    fprintf(f,"%d\n%s\n%s\n%s\n%d\n%c\n%10.2f\n%s\n%d\n%d\n%u\n",
            usernum, thisuser.name, thisuser.realname, thisuser.callsign,
            thisuser.age, thisuser.sex, thisuser.gold, thisuser.laston,
            thisuser.screenchars, thisuser.screenlines, thisuser.sl);
    fprintf(f,"%d\n%d\n%d\n%d\n%10.2f\n%s\n%s\n%s\n",
            cs(),so(),okansi(), incom, nsl(), gd, dd, s);
    if (using_modem)
      fprintf(f,"%u\n",modem_speed);
    else
      fprintf(f,"KB\n");
    fprintf(f,"%d\n%s\n%s\n%ld\n%ld\n%lu\n%u\n%lu\n%u\n%s\n%s\n%u\n",
            syscfgovr.primaryport, syscfg.systemname, syscfg.sysopname, l, l1,
            thisuser.uk, thisuser.uploaded, thisuser.dk, thisuser.downloaded,
            (andwith==0x7f)?"7E1":"8N1", cspeed, net_sysnum);
    fsh_close(f);
  }
  get_dir(fpn,1);
  strcat(fpn,fn);
  return(fpn);
}

void getname(int wn, unsigned char *s)
{
  unsigned char *ss;

  if (!wn) {
    ss=strchr(s,' ');
    if (ss)
      s[strlen(s)-strlen(ss)]=0;
  } else {
    ss=strrchr(s,' ');
    sprintf(s,"%s",(ss)?++ss:"");
  }
}

void create_drop_files(char *cspeed)
{
  char s[150],s1[81],s2[81],*ss;
  int fl=-1,h1,h2,m1,m2;
  double d;
  pcboard_sys_rec pcb;
  FILE *f;
  long l,l2;

  /* minutes left */
  l=(long) (nsl()/60);
  l-=1L;
  if (l<0L)
    l=0L;

  /* make DORINFO1.DEF (RBBS and many others) */
  if (instance < 10)
    sprintf(s,"DORINFO%d.DEF",instance);
  else if (instance==10)
    strcpy(s,"DORINFO0.DEF");
  else if (instance < 37)
    sprintf(s,"DORINFO%c.DEF",instance-10+'@');
  else
    sprintf(s,"DORINFO.%3.3d",instance);
  unlink(s);
  f=fsh_open(s,"wt");
  if (f) {
    fprintf(f,"%s\n%s\n\nCOM%d\n",syscfg.systemname,syscfg.sysopname,
      incom?syscfgovr.primaryport:0);
    if (using_modem)
      fprintf(f,"%u ",modem_speed);
    else
      /* arbitrary local speed */
      fprintf(f,"14400 ");
    fprintf(f,"BAUD,%s\n%d\n",(andwith==0x7f)?"E,7,1":"N,8,1",incom);
    if (syscfg.sysconfig & sysconfig_no_alias) {
      strcpy(s,thisuser.realname);
      getname(0,s);
      fprintf(f,"%s\n",s);
      strcpy(s,thisuser.realname);
      getname(1,s);
      fprintf(f,"%s\n",s);
    } else
      fprintf(f,"%s\n\n",thisuser.name);
    if (syscfg.sysconfig & sysconfig_extended_info)
      fprintf(f,"%s, %s\n",thisuser.city,thisuser.state);
    else
      fprintf(f,"\n");
    fprintf(f,"%c\n%d\n%ld\n",(thisuser.sysstatus & sysstatus_ansi)?'1':'0',
      thisuser.sl,(long)(l));
    fsh_close(f);
  }

  /* make PCBOARD.SYS (PC Board) */
  if (instance > 1)
    sprintf(s,"PCBOARD.%3.3d",instance);
  else
    sprintf(s,"PCBOARD.SYS");
  unlink(s);
  fl=sh_open(s,O_RDWR | O_BINARY | O_CREAT, S_IREAD|S_IWRITE);
  if (fl) {
    memset(&pcb,0,sizeof(pcb));
    strcpy(pcb.display,  "-1");
    strcpy(pcb.printer, (syscfg.sysconfig & sysconfig_printer)?"-1":" 0");
    strcpy(pcb.page_bell," 0");
    strcpy(pcb.alarm, (sysop_alert)?"-1":" 0");
    strcpy(pcb.errcheck, (modem_flag & flag_ec)?"-1":" 0");
    if (okansi()) {
      pcb.graphics = 'Y';
      pcb.ansi = '1';
    } else {
      pcb.graphics = 'N';
      pcb.ansi = '0';
    }
    pcb.nodechat=32;
    sprintf(pcb.openbps, "%-5.5s",cspeed);
    if (!incom)
      strcpy(pcb.connectbps,"Local");
    else
      sprintf(pcb.connectbps,"%-5.5u",modem_speed);
    pcb.usernum=usernum;
    sprintf(s,"%-25.25s",thisuser.name);
    ss=strtok(s," \t");
    sprintf(pcb.firstname,"%-15.15s",ss);
    strcpy(pcb.password,"XXX"); /* Don't write password - security */
    pcb.time_on=thisuser.timeon/60;
    pcb.prev_used = 0;
    d  = thisuser.timeon/60;
    h1 = (d/60)/10;
    h2 = (d/60)-(h1*10);
    m1 = (d-((h1*10+h2)*60))/10;
    m2 = (d-((h1*10+h2)*60))-(m1*10);
    pcb.time_logged[0] = h1+'0';
    pcb.time_logged[1] = h2+'0';
    pcb.time_logged[2] = ':';
    pcb.time_logged[3] = m1+'0';
    pcb.time_logged[4] = m2+'0';
    pcb.time_limit = nsl();
    pcb.down_limit = 1024;
    pcb.curconf = curconfsub;
    strcpy(pcb.slanguage,cur_lang_name);
    strcpy(pcb.name,thisuser.name);
    pcb.sminsleft = pcb.time_limit;
    pcb.snodenum = instance+'0';
    strcpy(pcb.seventtime, "01:00");
    strcpy(pcb.seventactive, (syscfg.executetime && syscfg.executestr[0])?
      "-1":" 0");
    strcpy(pcb.sslide," 0");
    pcb.scomport=syscfgovr.primaryport+'0';
    pcb.packflag = 27;
    pcb.bpsflag = 32;
    /* Added for PCB 14.5 Revision */
    strcpy(pcb.lastevent, status.date1);
    pcb.exittodos = '0';
    pcb.eventupcoming = '0';
    pcb.lastconfarea = curconfsub;
    /* End Additions */

    sh_write(fl, &pcb, sizeof(pcb));
    fl=sh_close(fl);
  }

  /* make CALLINFO.BBS (WildCat!) */
  if (instance > 1)
    sprintf(s,"CALLINFO.%3.3d",instance);
  else
    sprintf(s,"CALLINFO.BBS");
  unlink(s);
  f=fsh_open(s,"wt");
  if (f) {
    fprintf(f,"%s\n",thisuser.realname);
    switch (modem_speed) {
      case 300    : fprintf(f,"1\n");
      case 1200   : fprintf(f,"2\n");
      case 2400   : fprintf(f,"0\n");
      case 19200  : fprintf(f,"4\n");
      default: fprintf(f,"3\n");
    }
    fprintf(f," \n%d\n%ld\n%s\n%s\n%d\n%ld\n%.5s\n0\nABCD\n0\n0\n0\n0\n",
      thisuser.sl, l,
      (thisuser.sysstatus & sysstatus_ansi)?"COLOR":"MONO",
      "X" /* thisuser.pw */, usernum, ((long)(timeon/60)), times());
    fprintf(f,"%s\n%s 00:01\nEXPERT\nN\n%s\n%d\n%d\n1\n%d\n%d\n%s\n%s\n%d\n",
      thisuser.phone, thisuser.laston, thisuser.laston, thisuser.logons,
      thisuser.screenlines, thisuser.uploaded, thisuser.downloaded,
      (andwith==0x7f)?"7E1":"8N1",
      (incom)?"REMOTE":"LOCAL",
      (incom)?0:syscfgovr.primaryport);
    strcpy(s1,"00/00/00");
    sprintf(s2,"%d",thisuser.month);
    memmove(&(s1[2-strlen(s2)]),&(s2[0]),strlen(s2));
    sprintf(s2,"%d",thisuser.day);
    memmove(&(s1[5-strlen(s2)]),&(s2[0]),strlen(s2));
    sprintf(s2,"%d",thisuser.year);
    memmove(&(s1[8-strlen(s2)]),&(s2[0]),strlen(s2));
    fprintf(f,"%s\n",s1);
    fprintf(f,"%s\n",(incom)?cspeed:"14400");
    fsh_close(f);
  }

  /* make DOOR.SYS (Generic) */
  if (instance > 1)
    sprintf(s,"DOOR.%3.3d",instance);
  else
    sprintf(s,"DOOR.SYS");
  unlink(s);
  f=fsh_open(s,"wt");
  if (f) {
    fprintf(f,"COM%d\n%s\n%c\n%u\n%u\n%c\n%c\n%c\n%c\n%s\n%s, %s\n",
      (using_modem)?syscfgovr.primaryport:0,
      cspeed,
      (andwith==0x7f)?'7':'8',
      instance,  /* node */
      (using_modem)?modem_speed:14400,
      'Y', /* screen display */
      (syscfg.sysconfig & sysconfig_printer)?'Y':'N',
      'N',  /* page bell */
      'N',  /* caller alarm */
      thisuser.realname,
      thisuser.city,
      thisuser.state);
    fprintf(f,"%s\n%s\n%s\n%d\n%u\n%s\n%ld\n%ld\n",
      thisuser.phone,
      thisuser.dataphone,
      "X", /* thisuser.pw */
      thisuser.sl,
      thisuser.logons,
      thisuser.laston,
      (unsigned long)(60L*l),
      l);
    sprintf(s1,"%s",okansi()?"GR":"NG");
    if (andwith==0x7f)
      strcpy(s1,"7E");
    fprintf(f,"%s\n%u\n%c\n%s\n%u\n%s\n%u\n%c\n%u\n%u\n%u\n%u\n",
      s1,
      thisuser.screenlines,
      (thisuser.sysstatus & sysstatus_expert)?'Y':'N',
      "1,2,3", /* conferences */
      cursub,  /* current 'conference' */
      "12/31/99", /* expiration date */
      usernum,
      'Y', /* default protocol */
      thisuser.uploaded,
      thisuser.downloaded,
      0,  /* kb dl today */
      0); /* kb dl/day max */
    strcpy(s1,"00/00/00");
    sprintf(s2,"%d",thisuser.month);
    memmove(&(s1[2-strlen(s2)]),&(s2[0]),strlen(s2));
    sprintf(s2,"%d",thisuser.day);
    memmove(&(s1[5-strlen(s2)]),&(s2[0]),strlen(s2));
    sprintf(s2,"%d",thisuser.year);
    memmove(&(s1[8-strlen(s2)]),&(s2[0]),strlen(s2));
    fprintf(f,"%s\n%s\n%s\n%s\n%s\n%s\n%c\n%c\n%c\n%u\n%u\n%s\n%-.5s\n%s\n",
      s1,
      syscfg.datadir,
      syscfg.gfilesdir,
      syscfg.sysopname,
      thisuser.name,
      "00:01", /* event time */
      (modem_flag & flag_ec)?'Y':'N',
      (okansi())?'N':'Y',  /* ansi ok but graphics turned off? */
      'N', /* record-locking */
      thisuser.colors[0],
      thisuser.banktime,
      thisuser.laston, /* last n-scan date */
      times(),
      "00:01"); /* time last call */
    fprintf(f,"%u\n%u\n%ld\n%ld\n%s\n%u\n%ld\n",
      99, /* max files dl/day */
      0,  /* files dl today so far */
      thisuser.uk,
      thisuser.dk,
      thisuser.note,
      thisuser.chainsrun,
      thisuser.msgpost);
    fsh_close(f);
  }
}
