/*****************************************************************************

				WWIV Version 4
                    Copyright (C) 1988-1993 by Wayne Bell

Distribution of the source code for WWIV, in any form, modified or unmodified,
without PRIOR, WRITTEN APPROVAL by the author, is expressly prohibited.
Distribution of compiled versions of WWIV is limited to copies compiled BY
THE AUTHOR.  Distribution of any copies of WWIV not compiled by the author
is expressly prohibited.


*****************************************************************************/



#include "vars.h"

#pragma hdrstop

#include <ctype.h>
#include <math.h>
#include <string.h>

#ifdef OPT_CALLBACK

int input_phone(char *phone,int msg_num)         /* so strip doesn't see */
{
  int ok,i;
  int count;
  char s[81],ph[13];

  count=0;
  ok=0;
  if (msg_num!=0)
    printclb(msg_num);
  do {
    nl();
    if (msg_num!=15) {
      ansic(3);
      pl(get_string(527));
    }
    ansic(3);
    pl(get_string(493));
    prt(2,":");
    mpl(12);
    input(ph,12);
    strcpy(phone,ph);
    ok=1;
    if ((msg_num!=0) && !valid_phone(ph)) {
      ++count;
      if (count==3)
        hangup=1;
      else {
        nl();
        pl(get_string(1243));
      }
      ok=0;
    }
  } while ((!ok) && (!hangup));
  if (!hangup) {
    if (!check_phone(phone,0))
      hangup=1;
  }
  nl();
  return(ok);
}

#else

void input_phone(void)                           /* so strip doesn't see */
{
  int ok;

  do {
    nl();
    ansic(3);
    pl(get_string(527));
    ansic(3);
    pl(get_string(493));
    prt(2,":");
    mpl(12);
    input(thisuser.phone,12);

    ok=valid_phone(thisuser.phone);
    if (!ok) {
      nl();
      ansic(6);
      pl(get_string(528));
      ansic(6);
      pl(get_string(529));
    }
  } while ((!ok) && (!hangup));
}


void input_dataphone(void)
{
  int ok;

  do {
    nl();
    ansic(3);
    pl(get_string(540));
    ansic(3);
    pl(get_string(493));
    prt(2,":");
    mpl(12);
    input(thisuser.dataphone,12);

    ok=valid_phone(thisuser.dataphone);

    if (!ok) {
      nl();
      ansic(6);
      pl(get_string(528));
      ansic(6);
      pl(get_string(529));
    }
  } while ((!ok) && (!hangup));
}

#endif

void input_language(void)
{
  int i;
  char onx[20],ch,*ss;

  if (num_languages>1) {

    thisuser.language=255;

    do {
      nl(); nl();
      for (i=0; i<num_languages; i++) {
        npr("%d. %s\r\n",i+1,languages[i].name);
        if (i<9)
          onx[i]='1'+i;
      }
      nl();
      prt(2,get_string(937));
      if (num_languages<10) {
        onx[num_languages]=0;
        ch=onek(onx);
        ch-='1';
      } else {
        for (i=1; i<=num_languages/10; i++)
          odc[i-1]='0'+i;
        odc[i-1]=0;
        ss=mmkey(2);
        ch=atoi(ss)-1;
      }
      if ((ch>=0) && (ch<num_languages)) {
        thisuser.language=languages[ch].num;
      }
    } while (thisuser.language==255);

    set_language(thisuser.language);
  }
}


int check_name(unsigned char *nn)
{
  int ok,f,i;
  unsigned char s[161],s1[161],s2[81];
  long p,l;

  ok=1;
  if (nn[strlen(nn)-1]==32)
    ok=0;
  if (nn[0]<65)
    ok=0;
  if (finduser(nn)!=0)
    ok=0;
  if (strchr(nn,'@')!=NULL)
    ok=0;
  if (strchr(nn,'#')!=NULL)
    ok=0;

  if (!ok)
    return(ok);

  sprintf(s,"%sTRASHCAN.TXT",syscfg.gfilesdir);
  f=sh_open1(s,O_RDONLY | O_BINARY);

  if (f<0)
    return(ok);

  sh_lseek(f,0L,SEEK_SET);
  l=filelength(f);
  p=0;
  sprintf(s2," %s ",nn);
  while ((p<l) && (ok)) {
    sh_lseek(f,p,SEEK_SET);
    sh_read(f,(void *)s,150);
    i=0;
    while ((i<150) && (s[i])) {
      if (s[i]==13)
        s[i]=0;
      else
        ++i;
    }
    s[150]=0;
    p += (long) (i+2);
    if (s[i-1]==1)
      s[i-1]=0;
    for (i=0; i<strlen(s); i++)
      s[i]=upcase(s[i]);
    sprintf(s1," %s ",s);
    if (strstr(s2,s1)!=NULL)
      ok=0;
  }
  sh_close(f);
  if (!ok)
    hangup=1;

  return(ok);
}

void input_name(void)
{
  int ok,count;

  count=0;
  do {
    nl();
    ansic(3);
    if (syscfg.sysconfig & sysconfig_no_alias)
      pl(get_string(520));
    else
      pl(get_string(521));
    prt(2,":");
    mpl(30);
    input(thisuser.name,30);
    ok=check_name(thisuser.name);
    if (!ok) {
      nl();
      ansic(6);
      pl(get_string(522));
      ++count;
      if (count==3)
        hangup=1;
    }
  } while ((!ok) && (!hangup));
}

void input_realname(void)
{
  if (!(syscfg.sysconfig & sysconfig_no_alias)) {
    do {
      nl();
      ansic(3);
      pl(get_string(523));
      prt(2,":");
      mpl(20);
      inputp(thisuser.realname,20);

      if (thisuser.realname[0]==0) {
        nl();
        ansic(6);
        pl(get_string(524));
      }
    } while ((thisuser.realname[0]==0) && (!hangup));
  }
}

void input_callsign(void)
{
  nl();
  ansic(3);
  pl(get_string(525));
  ansic(3);
  pl(get_string(526));
  prt(2,":");
  mpl(6);
  input(thisuser.callsign,6);
}

int valid_phone(char *phone)
{
  int i;

  if (syscfg.sysconfig & sysconfig_free_phone)
    return(1);

  if (syscfg.sysconfig & sysconfig_extended_info) {
    if ((!usa_phone_convention(&thisuser)) && thisuser.country[0])
      return(1);
  }

  if (strlen(phone)!=12)
    return(0);
  if ((phone[3]!='-') || (phone[7]!='-'))
    return(0);
  for (i=0; i<12; i++) {
    if ((i!=3) && (i!=7)) {
      if ((phone[i]<'0') || (phone[i]>'9')) {
        return(0);
      }
    }
  }

  return(1);
}


void input_street(void)
{
  do {
    nl();
    ansic(3);
    pl(get_string(530));
    prt(2,":");
    mpl(30);
    inputp(thisuser.street,30);

    if (thisuser.street[0]==0) {
      nl();
      ansic(6);
      pl(get_string(531));
    }
  } while ((thisuser.street[0]==0) && (!hangup));
}

void input_city(void)
{
  do {
    nl();
    ansic(3);
    pl(get_string(532));
    prt(2,":");
    mpl(30);
    inputp(thisuser.city,30);

    if (thisuser.city[0]==0) {
      nl();
      ansic(6);
      pl(get_string(533));
    }
  } while ((thisuser.city[0]==0) && (!hangup));
}

void input_state(void)
{
  do {
    nl();
    ansic(3);
    pl(get_string(534));
    prt(2,":");
    mpl(2);
    input(thisuser.state,2);

    if (thisuser.state[0]==0) {
      nl();
      ansic(6);
      pl(get_string(535));
    }
  } while ((thisuser.state[0]==0) && (!hangup));
}

void input_country(void)
{
  do {
    nl();
    ansic(3);
    pl(get_string(536));
    prt(2,":");
    mpl(3);
    input(thisuser.country,3);

    if (thisuser.country[0]==0) {
      nl();
      ansic(6);
      pl(get_string(537));
    }
  } while ((thisuser.country[0]==0) && (!hangup));
}

void input_zipcode(void)
{
  do {
    nl();
    ansic(3);
    pl(get_string(538));
    prt(2,":");
    mpl(10);
    input(thisuser.zipcode,10);

    if (thisuser.zipcode[0]==0) {
      nl();
      ansic(6);
      pl(get_string(539));
    }
  } while ((thisuser.zipcode[0]==0) && (!hangup));
}


void input_sex(void)
{
  nl();
  prt(2,get_string(541));
  thisuser.sex=onek("MF");
}

void input_age(userrec *u)
{
  int ok,y,m,d;
  char ag[10];

  do {
    nl();
    do {
      nl();
      prt(2,get_string(542));
      mpl(2);
      input(ag,2);
      m=atoi(ag);
    } while ((!hangup) && ((m>12) || (m<1)));
    do {
      nl();
      prt(2,get_string(543));
      mpl(2);
      input(ag,2);
      d=atoi(ag);
    } while ((!hangup) && ((d>31) || (d<1)));
    do {
      nl();
      prt(2,get_string(544));
      mpl(2);
      input(ag,2);
      y=atoi(ag)+1900;
      if (y==1919) {
        nl();
        prt(5,get_string(545));
        if (!yn()) {
          y=0;
        }
      }
    } while ((!hangup) && (y<1905));
    ok=1;
    if (((m==2) || (m==9) || (m==4) || (m==6) || (m==11)) && (d==31))
      ok=0;
    if ((m==2) && (((y%4!=0) && (d==29)) || (d==30)))
      ok=0;
    if (!ok) {
      nl();
      ansic(6);
      pl(get_string(546));
    }
    if (years_old((unsigned char)m, (unsigned char)d, (unsigned char)(y-1900))<5) {
      nl();
      pl(get_string(547));
      ok=0;
    }
  } while ((!ok) && (!hangup));
  u->month=(unsigned char) m;
  u->day=(unsigned char) d;
  u->year=(unsigned char) (y-1900);
  u->age=years_old(u->month,u->day,u->year);
  nl();
}

void input_comptype(void)
{
  int i,ok,ct;
  char c[5];

  do {
   nl();
   pl(get_string(275));
   nl();
   for (i=0; ctypes[i]; i++)
     npr("%d. %s\r\n",i+1,ctypes[i]);
   nl();
   ansic(3);
   pl(get_string(548));
   ansic(3);
   pl(get_string(549));
   prt(2,":");
   mpl(2);
   input(c,2);
   ct=atoi(c);

   ok=1;
   if ((ct<1) || (ct>i))
     ok=0;

  } while ((!ok) && (!hangup));
  thisuser.comp_type=ct-1;
  /* if (checkcomp("Ami"))  thisuser.colors[0]=4; Why is this here? */
  if (hangup)
    thisuser.comp_type=0;
}

void input_screensize(void)
{
  int ok,x,y;
  char s[5];

  do {
    nl();
    ansic(3);
    pl(get_string(550));
    prt(2,":");
    mpl(2);
    input(s,2);
    x=atoi(s);
    if (s[0]==0)
      x=80;

    if ((x<32) || (x>80))
      ok=0;
    else
      ok=1;
  } while ((!ok) && (!hangup));

  do {
    nl();
    ansic(3);
    pl(get_string(551));
    prt(2,":");
    mpl(2);
    input(s,2);
    y=atoi(s);
    if (s[0]==0)
      y=25;

    if ((y<4) || (y>60))
      ok=0;
    else
      ok=1;
  } while ((!ok) && (!hangup));

  nl();
  thisuser.screenchars=x;
  thisuser.screenlines=y;
  screenlinest=y;
}

void input_pw(void)
{
  int ok;
  char s[81];

  do {
    nl();
    ansic(3);
    pl(get_string(552));
    prt(2,":");
    mpl(8);
    input(s,8);

    ok=1;
    if (strlen(s)<3)
      ok=0;
  } while ((!ok) && (!hangup));
  if (ok)
    strcpy(thisuser.pw,s);
  else
    pl(get_string(463));
}


void input_ansistat(void)
{
  int i,c,c2;
  char ch;

  thisuser.sysstatus &= ~(sysstatus_ansi | sysstatus_color);
  nl();
  if (check_ansi()==1) {
    outstr(get_string(553));
  } else {
    outstr(get_string(1244));
    outstr(get_string(1245));
    outstr(get_string(1246));
    outstr(get_string(1247));
    outstr(get_string(1248));
    pl(get_string(1249));
    pl(get_string(554));
    outstr(get_string(555));
  }
  if (yn()) {
    thisuser.sysstatus |= sysstatus_ansi;
    nl();
    prt(5,get_string(556));
    if (yn()) {
      thisuser.sysstatus |= sysstatus_color;
#ifdef OPT_EXTRA_COLOR
      thisuser.sysstatus |= sysstatus_extra_color;
#endif
    } else {
      color_list();
      nl();
      prt(2,get_string(557));
      ch=onek("\r123456789");
      if (ch=='\r')
        ch='7';
      c=ch-'0';
      c2=c << 4;
      for (i=0; i<10; i++) {
       if ((thisuser.bwcolors[i] & 0x70) == 0)
         thisuser.bwcolors[i]=(thisuser.bwcolors[i] & 0x88) | c;
       else
         thisuser.bwcolors[i]=(thisuser.bwcolors[i] & 0x88) | c2;
      }
    }
  }
}


void newuser(void)
{
  int i,ok;
  char s[255],s1[81],ch;
  userrec u;
  long l1;

  memset(&thisuser, 0, sizeof(userrec));
  memset(qsc, 0, syscfg.qscn_len);

  strcpy(thisuser.firston,date());
  strcpy(thisuser.laston,get_string(564));
  strcpy(&thisuser.macros[0][0],get_string(565));
  strcpy(&thisuser.macros[1][0],get_string(566));
  strcpy(&thisuser.macros[2][0],get_string(567));

  thisuser.screenlines=25;
  thisuser.screenchars=80;
  screenlinest=25;

  thisuser.sl=syscfg.newusersl;
  thisuser.dsl=syscfg.newuserdsl;

  thisuser.ontoday=1;

  thisuser.restrict=syscfg.newuser_restrict;

  *qsc=999;
  memset(qsc_n,0xff,((max_dirs+31)/32)*4);
  memset(qsc_q,0xff,((max_subs+31)/32)*4);

  thisuser.sysstatus=sysstatus_pause_on_page |
                     sysstatus_nscan_file_system |
                     sysstatus_conference;

  thisuser.gold=syscfg.newusergold;

  thisuser.colors[0]=7;
  thisuser.colors[1]=11;
  thisuser.colors[2]=14;
  thisuser.colors[3]=5;
  thisuser.colors[4]=31;
  thisuser.colors[5]=2;
  thisuser.colors[6]=12;
  thisuser.colors[7]=9;
  thisuser.colors[8]=6;
  thisuser.colors[9]=3;

  thisuser.bwcolors[0]=7;
  thisuser.bwcolors[1]=15;
  thisuser.bwcolors[2]=15;
  thisuser.bwcolors[3]=15;
  thisuser.bwcolors[4]=112;
  thisuser.bwcolors[5]=15;
  thisuser.bwcolors[6]=143;
  thisuser.bwcolors[7]=7;
  thisuser.bwcolors[8]=7;
  thisuser.bwcolors[9]=7;

  reset_act_sl();

  for (i=0; i<6; i++) {
    ch=rand() % 36;
    if (ch<10)
      ch+='0';
    else
      ch+='A'-10;
    thisuser.pw[i]=ch;
  }
  thisuser.pw[6]=0;

  input_language();

  sprintf(s,get_stringx(1,25),date(),times(),curspeed);
  sl1(0,"");
  sl1(0,s);
  read_status();
  if (status.users>=syscfg.maxusers) {
    nln(2);
    pl(get_string(558));
    pl(get_string(559));
    pl(get_string(560));
    nl();
    hangup=1;
  }
  if (syscfg.closedsystem) {
    nln(2);
    pl(get_string(561));
    pl(get_string(562));
    nl();
    hangup=1;
  }
  if ((syscfg.newuserpw[0]!=0) && (incom)) {
    nln(2);
    ok=0;
    i=0;
    do {
      outstr(get_string(563));
      input(s,20);
      if (strcmp(s,syscfg.newuserpw)==0)
        ok=1;
      else {
        sprintf(s1,get_stringx(1,26),s);
        sl1(0,s1);
      }
    } while ((!ok) && (!hangup) && (i++<4));
    if (!ok)
      hangup=1;
  }

  if (!hangup) {
    input_ansistat();
    if (incom) {
      if (printfile("SYSTEM"))
        sl1(0,get_stringx(1,27));
      if (printfile("NEWUSER"))
        sl1(0,get_stringx(1,28));
    }
#ifndef OPT_CALLBACK
    if (syscfg.sysconfig & sysconfig_extended_info)
      input_country();
#endif
    input_name();
    input_realname();
#ifdef OPT_CALLBACK
    input_phone(thisuser.phone,13);
#else
    input_phone();
#endif
    if (syscfg.sysconfig & sysconfig_extended_info) {
      input_street();
#ifndef OPT_CALLBACK
      input_city();
      input_state();
      input_zipcode();
      input_dataphone();
#else
      input_zipcode();
      if (!check_zip(thisuser.zipcode,1)) {
        input_city();
        input_state();
        input_country();
      }
#endif
    }
    input_callsign();
    input_sex();
    input_age(&thisuser);
    input_comptype();
    input_screensize();

    if (numed && (thisuser.sysstatus & sysstatus_ansi)) {
      nl();
      prt(5,get_string(568));
      if (yn())
        select_editor();
      nl();
    }

    prt(5,get_string(569));
    if (yn()) {
      nl();
      pl(get_string(570));
      nl();
      i=get_protocol(xf_down);
      if (i)
        thisuser.defprot=i;
    }
    nl();
    outstr(get_string(571)); pl(thisuser.pw);
    nl();
    prt(5,get_string(572));
    if (yn())
      input_pw();

#ifndef OPT_AUTOVAL
#ifdef OPT_SIMPLE_ASV
    if ((syscfg.autoval[9].sl>syscfg.newusersl) &&
        (syscfg.autoval[9].sl<100)) {
      nl();
      prt(5,get_string(1250));
      if (yn()) {
         nl();
         prt(5,get_string(1251));
         nl();
         mpl(60);
         inputl(thisuser.note,60);
         thisuser.exempt=9;
         set_autoval(9);
         nl();
         existprint("ASV");
         nl();
         pausescr();
       }
     }
#endif
#endif
  }

  if (!hangup)
    do {
      nln(2);
      outstr(get_string(573)); pl(thisuser.name);
      if (!(syscfg.sysconfig & sysconfig_no_alias)) {
        outstr(get_string(574)); pl(thisuser.realname);
      }
      outstr(get_string(575)); pl(thisuser.callsign);
      outstr(get_string(576)); pl(thisuser.phone);
      outstr(get_string(577)); npr("%c\r\n",thisuser.sex);
      outstr(get_string(578)); npr("%02d/%02d/%02d\r\n",
        (int) thisuser.month, (int) thisuser.day, (int) thisuser.year);
      outstr(get_string(579)); pl(ctypes[thisuser.comp_type]);
      outstr(get_string(580)); npr("%d X %d\r\n",
        thisuser.screenchars, thisuser.screenlines);
      outstr(get_string(581)); pl(thisuser.pw);
      if (syscfg.sysconfig & sysconfig_extended_info) {
        outstr(get_string(582)); pl(thisuser.street);
        outstr(get_string(583)); pl(thisuser.city);
        outstr(get_string(584)); pl(thisuser.state);
        outstr(get_string(585)); pl(thisuser.country);
        outstr(get_string(586)); pl(thisuser.zipcode);
#ifndef OPT_CALLBACK
        outstr(get_string(587)); pl(thisuser.dataphone);
#endif
      }
      nl();
      pl(get_string(588));
      nln(2);
      if (syscfg.sysconfig & sysconfig_extended_info) {
        prt(2,get_string(589));
#ifdef OPT_CALLBACK
        ch=onek("Q123456789ABCDE");
#else
        ch=onek("Q123456789ABCDEF");
#endif
      } else {
        prt(2,get_string(590));
        ch=onek("Q123456789");
      }
      ok=0;
      switch(ch) {
        case 'Q': ok=1; break;
        case '1': input_name(); break;
        case '2':
          if (!(syscfg.sysconfig & sysconfig_no_alias))
            input_realname();
          break;
        case '3': input_callsign(); break;
        case '4':
#ifdef OPT_CALLBACK
          input_phone(thisuser.phone,13);
#else
          input_phone();
#endif
        break;
        case '5': input_sex(); break;
        case '6': input_age(&thisuser); break;
        case '7': input_comptype(); break;
        case '8': input_screensize(); break;
        case '9': input_pw(); break;
        case 'A': input_street(); break;
        case 'B': input_city(); break;
        case 'C': input_state(); break;
        case 'D': input_country(); break;
        case 'E': input_zipcode(); break;
#ifndef OPT_CALLBACK
        case 'F': input_dataphone(); break;
#endif
      }
    } while ((!ok) && (!hangup));

  if (!hangup) {

    nl();
    pl(get_string(26));
    nl();
    read_user(0,&u);
    l1=number_userrecs();
    read_status();
    if (l1==(long) status.users) {
      usernum=status.users+1;
    } else {
      usernum=1;
      do {
        read_user(usernum,&u);
        if ((u.inact & inact_deleted)==0)
          ++usernum;
      } while (((u.inact & inact_deleted)==0) && ((long)usernum<=l1));
    }
    write_user(usernum,&thisuser);
    write_qscn(usernum, qsc, 0);
    isr(usernum,thisuser.name);
    ok=0;
    topscreen();
    do {
      nln(2);
      outstr(get_string(591)); pln(usernum);
      outstr(get_string(592)); pl(thisuser.pw);
      nl();
      pl(get_string(593));
      pl(get_string(594));
      pl(get_string(595));
      pl(get_string(596));
      nl();
      outstr(get_string(357));
      echo=0;
      input(s,8);
      if (strcmp(s,thisuser.pw)==0)
        ok=1;
    } while ((!ok) && (!hangup));
    reset_act_sl();
    changedsl();
    checkit=0;
    if (incom) {
      if (printfile("FEEDBACK"))
        sl1(0,get_stringx(1,29));
      feedback(1);
    }
#ifdef OPT_FORCE_FEEDBACK
    if ((incom) && (!thisuser.emailsent) && (!thisuser.feedbacksent)) {
      existprint("NOFBACK");
      deluser(usernum);
      hangup=1;
    }
#endif
    if ((!hangup) && (syscfg.newuser_c[0])) {
      stuff_in(s,syscfg.newuser_c,create_chain_file(),"","","","");
      write_user(usernum,&thisuser);
#ifdef OPT_NEWEVENT_INTERCEPT
      full_external(s,0,1);
#else
      run_external(s);
#endif
      read_user(usernum,&thisuser);
    }
#ifdef OPT_CALLBACK
    if ((callbak()) && (!hangup)) {
      printclb(7);
      hangup=1;
      write_user(usernum,&thisuser);
    }
#endif
  }
  reset_act_sl();
}



#ifdef OPT_CALLBACK

#define CALLBAKSL 10                             /* added to newusersl */
#define CALLBAKDSL 10                            /* added to newuserdsl */
#define FORCE                                    /* callbak is not optional */
#define AREACODE "319-"                          /* dash required */
#define PASSWORD1 "you're kidding"               /* bypass callbak Upper only */
#define PASSWORD2 "you're kidding"               /* bypass callbak Upper only */
#define PRELCL ""                                /* before dial local */
#define POSTLCL ""                               /* after dial local */
#define PRELONG ""                               /* before dial ld */
#define POSTLONG ""                              /* after dial ld */
#define SYSOPSL 80                               /* added to newusersl */
#define SYSOPDSL 80                              /* added to newuserdsl */


#define modem_time 3.5

void dial_phone(char *ph)
{
  int i=0;

  outs("Dialing phone, 'H' to abort.\r\n");
  outs(ph);
  wait1(27);
  if (kbhitb())
    return;
  pr1(ph);
  outs("\r\nWaiting ");
  do {
    if (!cdet()) {
      outs(".");
      wait1(20);
    }
    if (kbhitb()) {
      hangup=1;
      return;
    }
  } while ((!cdet()) && (i++<50));
  rts(1);
}


void printclb(int i)
{
  int next,i1;
  char s[81];

  next=0;
  if (clbmsg[0].storage_type!=255)
    read_in_file("CALLBAK.MSG",(clbmsg),40);
#ifdef DEBUG
  for(i1=20;i1<40;i1++)
    npr("type %d=%d, as %ld \r\n",i1,clbmsg[i1].storage_type,
      clbmsg[i1].stored_as);
#endif
  sprintf(s,"%s%s",languagedir,"CALLBAK.MSG");
  read_message1(&clbmsg[i],0,0,&next,s);
}


int callbak(void)
{
  int i,i1,ok,ld,count;
  char s[255],s1[81];
  userrec u;
  long l1;
  char tempphone[13];

  ld=0;
  strcpy(tempphone,get_string(1252));
  thisuser.dataphone[0]=0;
  hangup=0;
  printclb(2);
  npr(get_string(1253));
  if (!yn()) {
#ifdef FORCE
    printclb(11);
    npr(get_string(1253));
    if (!yn()) {
      u.inact |= inact_deleted;
      write_user(usernum,&thisuser);
      printclb(12);
      hangup=1;
      return(ld);
    }
#else
    return(ld);
#endif
  }
  sprintf(s,"    %s / %s / %s / %s",
    thisuser.name,thisuser.phone,date(),curspeed);
  sl1(0,s);
  ssm(1,0,s);
  printclb(3);
  i=0;
  do {
    ok=0;
    mpl(14);
    input(s1,14);

/* user is granted newusersl + CALLBAKSL
   user is granted newuserdsl + CALLBAKDSL
   dataphone is set to PASSWORD1 to indicate its use. */

    if (strcmp(s1,PASSWORD1)==0) {
      printclb(3);
      mpl(14);
      input(s1,14);
      strcpy(thisuser.dataphone,s1);
      printclb(3);
      if (hangup==0) {
        ok=0;
        topscreen();
        nl();
        npr("%s%d",get_string(1254),usernum);
        nl();
        npr("%s%s",get_string(1255),thisuser.pw);
        nl();
        printclb(6);
      }
      if (thisuser.sl<syscfg.newusersl+CALLBAKSL)
        thisuser.sl=syscfg.newusersl+CALLBAKSL;
      if (thisuser.dsl<syscfg.newuserdsl+CALLBAKDSL)
        thisuser.dsl=syscfg.newuserdsl+CALLBAKDSL;
      changedsl();
      strcpy(thisuser.dataphone,s1);
      return(0);
    }

/* user is granted newusersl + SYSOPSL
   user is granted newuserdsl + SYSOPDSL
   dataphone is set to PASSWORD2 to indicate its use. */
    if (strcmp(s1,PASSWORD2)==0) {
      printclb(3);
      mpl(14);
      input(s1,14);
      strcpy(thisuser.dataphone,s1);
      printclb(3);
      if (hangup==0) {
        ok=0;
        topscreen();
        nl();
        npr("%s%d",get_string(1254),usernum);
        nl();
        npr("%s%s",get_string(1255),thisuser.pw);
        nl();
        printclb(6);
      }
      if (thisuser.sl<syscfg.newusersl+SYSOPSL)
        thisuser.sl=syscfg.newusersl+SYSOPSL;
      if (thisuser.dsl<syscfg.newuserdsl+SYSOPDSL)
        thisuser.dsl=syscfg.newuserdsl+SYSOPDSL;
      changedsl();
      strcpy(thisuser.dataphone,s1);
      return(0);
    }
    if ((strlen(s1) == 8)                        /* This is for local calls. */
      && (s1[3] == '-')) {
      ok=1;
      ld=0;
      if ((s1[0] == '9')
        && (s1[1] == '1')
        && (s1[2] == '1'))
        ok=0;
      if ((s1[0] == '4')
        && (s1[1] == '1')
        && (s1[2] == '1'))
        ok=0;
    }
    if ((strlen(s1) == 10)                       /* This is for calls in the */
      && (s1[0] == '1')                          /* same area code that are */
      && (s1[1] == '-')                          /* long distance. */
      && (s1[5] == '-')) {
      ok=1;
      ld=1;
      if ((s1[0] == '9')
        && (s1[1] == '1')
        && (s1[2] == '1'))
        ok=0;
      if ((s1[0] == '4')
        && (s1[1] == '1')
        && (s1[2] == '1'))
        ok=0;
    }
    if ((strlen(s1) == 12)                       /* This is not a valid */
      && (s1[3] == '-')                          /* possibility here and */
      && (s1[7] == '-')) {                       /* has not been tested. */
      ok=1;                                      /* It is for numbers in */
      ld=0;                                      /* another area code that */
      if ((s1[0] == '9')                         /* are not long distance. */
        && (s1[1] == '0')
        && (s1[2] == '0'))
        ok=0;
      if ((s1[0] == '9')                         /* Steve Wolf's idea */
        && (s1[1] == '1')
        && (s1[2] == '1'))
        ok=0;
      if ((s1[0] == '4')                         /* Steve Wolf's idea */
        && (s1[1] == '1')
        && (s1[2] == '1'))
        ok=0;
    }

    if ((strlen(s1) == 14)                       /* This is for the */
      && (s1[0] == '1')                          /* traditional long */
      && (s1[1] == '-')                          /* distance number */
      && (s1[5] == '-')                          /* 1-215-296-1529 */
      && (s1[9] == '-')) {
      ok=1;
      ld=1;
      if ((s1[2] == '9')
        && (s1[3] == '0')
        && (s1[4] == '0'))
        ok=0;
      if ((s1[2] == '9')
        && (s1[3] == '1')
        && (s1[4] == '1'))
        ok=0;
      if ((s1[2] == '4')
        && (s1[3] == '1')
        && (s1[4] == '1'))
        ok=0;
    }

    for (i1=0; i1< strlen(s1)-1; i1++)
      if (((s1[i1]<'0') || (s1[i1]>'9')) && (s1[i1] != '-'))
        ok=0;

    if (!ok) {
      printclb(4);
    }
  } while ((!ok) && (i++<3));
  if (i>=3)
    hangup=1;
  sprintf(s,"%s %s\r",modem_i->dial,s1);

/*  Use these lines as required

  if (ld)
    sprintf(s,"%s%s %s%s\r",PRELONG,modem_i->dial,s1,POSTLONG);
  else
    sprintf(s,"%s%s %s%s\r",PRELCL,modem_i->dial,s1,POSTLCL);

End of predial and post dial options

*/
  if (ok)
    ok=(check_phone(s1,1));
  nl();
  if (ok) {
    pl(s);
    printclb(5);
    pausescr();
    if (ok_modem_stuff) {
      hang_it_up();
      wait1(90);
      hangup=0;
      dial_phone(s);
      if (cdet())
        outs(" CDET\r\n");
      else
        outs(" NO CDET\r\n");
    }
  } else {
    if (((hangup) || (!ok)) && (so())) {         /* lets sysop bail out */
      hangup=0;                                  /* of //callbak. */
      strcpy(thisuser.dataphone,tempphone);
      return(ld);
    }
  }
  if (!hangup) {
    i1=1;
    count=0;
    ok=0;
    wait1(150);
    dump();
    do {
      printclb(14);
      nl();
      outstr(get_string(1256));
      mpl(8);
      echo=0;
      input(s,8);
      if (strcmp(s,thisuser.pw)==0)
        ok=1;
      else {
        ++count;
        if (count==3)
          hangup=1;
        else
          nl();
      }
    } while ((!ok) && (!hangup));
    if (!ok)
      hangup=1;
  }
  if (!hangup) {
    if (so()) {
      strcpy(thisuser.dataphone,tempphone);
      return(ld);
    } else {
      strcpy(thisuser.dataphone,s1);
    }
    changedsl();
    nl();
    npr("%s%d",get_string(1254),usernum);
    nl();
    npr("%s%s",get_string(1255),thisuser.pw);
    nl();
    printclb(6);
    if (thisuser.sl<syscfg.newusersl+CALLBAKSL)
      thisuser.sl=syscfg.newusersl+CALLBAKSL;
    if (thisuser.dsl<syscfg.newuserdsl+CALLBAKDSL)
      thisuser.dsl=syscfg.newuserdsl+CALLBAKDSL;
    strcpy(thisuser.dataphone,s1);
#ifdef OPT_AUTOVAL
    wwivnode(&thisuser,0);                          /* autoval.mod */
#endif
  }
  return(ld);
}


int check_phone(char *phone, int mode)
{
  int f,i;
  char s[81],s1[161],s2[81];
  userrec u;
  long p,l;
  FILE *trash;
  char buf[80];

  if (strlen(phone) < 7)
    return(0);
  if (mode!=0) {
    if (strlen(phone) == 14) {
      sprintf(s1,"%s",strrev(strrev(phone+2)));
      sprintf(phone,"%s",s1);
    }
    if (strlen(phone) == 10) {
      sprintf(s1,"%s",strrev(strrev(phone+2)));
      sprintf(phone,"%s",AREACODE);
      strcat(phone,s1);
    }
    if (strlen(phone) == 8) {
      sprintf(s1,"%s",phone);
      sprintf(phone,"%s",AREACODE);
      strcat(phone,s1);
    }
  }

  npr("\r\n2Wait, checking for duplicates ");
  for (i=0;i<status.users;i++) {
    if ((i % 10)==0)
      outstr("3.0");
    read_user(i,&u);
    if ((strstr(u.dataphone,phone)!=NULL) || (strcmp(phone,u.phone)==0)) {
      if ((i!=usernum) && ((usernum==-1)
        && (strcmp(thisuser.name,u.name)!=0))) {
        sprintf(s,"    %s%s%s",thisuser.name,get_stringx(1,112),phone);
        sl1(0,s);
        ssm(1,0,s);
        sprintf(s,"%s%s",get_stringx(1,113),u.name);
        sl1(0,s);
        ssm(1,0,s);
      }
    }
  }
  sprintf(s,"%sTRASHFON.TXT",syscfg.gfilesdir);
  if ((trash = fsh_open(s, "r")) == NULL) {
    strcpy(s,get_stringx(1,114));
    sl1(0,s);
    ssm(1,0,s);
  } else {
    outstr("3.0");
    for (;;) {
      if ((i % 10)==0)
        outstr("3.0");
      if (fgets(buf, sizeof buf, trash) == NULL) {
        strcpy(s,get_stringx(1,115));
        sl1(0,s);
        ssm(1,0,s);
        fsh_close(trash);
        return(1);
      }
      if (strncmp(buf, "end", 3) == 0)
        break;
      else {
        (void)sscanf(buf,"%s\r\n",&s);
        if (strcmp(s,phone)==0) {
          nl();
          pl(get_string(1257));
          sprintf(s,"    %s%s%s ",thisuser.name,get_stringx(1,116),phone);
          sl1(0,s);
          ssm(1,0,s);
          fsh_close(trash);
          hangup=1;
          return(0);
        }
      }
      i++;
    }
    outstr("\r\n");
    fsh_close(trash);
  }
  return(1);
}



/* end autoval.mod additions */

/* begin zip_city.mod additions */

int check_zip(char *zip, int mode)
{
  int ok,i;
  char s[81];
  userrec u;
  FILE *zip_file;
  char zip_buf[80];

  if (zip[0]==0)
    return(0);
  ok=1;
  sprintf(s,"%sZIP-CITY\\ZIP%c.DAT",syscfg.datadir,zip[0]);
  if ((zip_file=fsh_open(s,"r"))==NULL) {
    nl(); ansic(6);
    outstr(s);
    pl(get_string(1261));
    ok=0;
  }
  for (;;) {
    if (fgets(zip_buf,sizeof zip_buf-1,zip_file)==NULL) {
      nl(); ansic(6);
      outstr(get_string(1262));
      outstr(zip);
      pl(".");
      fsh_close(zip_file);
      ok=0;
      break;
    }
    if (strncmp(zip_buf,zip,5)==0) {
      fsh_close(zip_file);
      break;
    }
  }
  if (!mode) {
    (void)sscanf(zip_buf,"%s %s %[ -Z]",&u.zipcode,&u.state,&u.city);
    properize(u.city);
    npr("\r\n2%s is in %s, %s.",u.zipcode,u.city,u.state);
    return(0);
  }
  if ((zip_buf) && (ok)) {
    (void)sscanf(zip_buf,"%s %s %[ -Z]",&u.zipcode,&u.state,&u.city);
    properize(u.city);
    npr("\r\n2%s, %s  %s? (y/N): ",u.city,u.state,"USA");
    if (yn()) {
      thisuser.city[0]=0;
      thisuser.state[0]=0;
      thisuser.country[0]=0;
      strcpy(thisuser.city,u.city);
      strcpy(thisuser.state,u.state);
      strcpy(thisuser.country,"USA");
    } else {
      nl(); ansic(6);
      pl(get_string(1263));
      ok=0;
    }
  }
  return(ok);
}


int check_city(char *city_state, int mode)
{
  FILE *city_file;
  int match,length;
  char s[81],s1[81],city[31],state[3],zipcode[11];
  char city_buf[80];

  match=0;
  if (city_state[0]==0)
    return(0);
  sprintf(s,"%sZIP-CITY\\CITY-%c.DAT",syscfg.datadir,city_state[0]);
  if ((city_file=fsh_open(s,"r"))==NULL) {
    nl();
    npr("6%s not found",s);
    return(0);
  }
  do {
    for(;;) {
      if (fgets(city_buf,sizeof city_buf,city_file)==NULL) {
        if ((mode==0) && (!match)) {
          nl();
          npr("%s%s.",get_string(1264),city_state);
          nl();
        }
        fsh_close(city_file);
        return(match);
      }
      if (strncmp(city_buf,city_state,strlen(city_state))==0) {
        match=1;
        break;
      }
    }
    (void)sscanf(city_buf,"%[ -Z]",&s1);
    if (mode==0) {
      strcpy(s,&s1[strlen(s1)-8]);
      s1[strlen(s1)-9]=0;
      strcpy(city,s1);
      strcpy(s1,&s[strlen(s)-5]);
      s[strlen(s)-6]=0;
      strcpy(state,s);
      strcpy(zipcode,s1);
      properize(city);
      nl();
      npr("%s, %s  %s",city,state,zipcode);
    } else {
      strcpy(s,&s1[strlen(s1)-8]);
      s1[strlen(s1)-9]=0;
      strcpy(city,s1);
      strcpy(s1,&s[strlen(s)-5]);
      s[strlen(s)-6]=0;
      strcpy(state,s);
      strcpy(zipcode,s1);
      nl();
      npr("%s, %s  %s",city,state,zipcode);
    }
  } while (((strncmp(city_buf,city_state,strlen(city_state))==0)
    && (!hangup)));
  fsh_close(city_file);
  return(match);
}


int check_areacode(char *areacode, int mode)
{
  FILE *areacode_file;
  int match,length;
  char s[81],s1[81],state[3];
  char areacode_buf[80];

  match=0;
  if ((areacode[0]==0) || ((mode==1) && (strlen(areacode) !=3)))
    return(0);
  sprintf(s,"%sZIP-CITY\\AREACODE.DAT",syscfg.datadir);
  if ((areacode_file=fsh_open(s,"r"))==NULL) {
    nl(); ansic(6);
    outstr(s);
    pl(get_string(1261));
    return(0);
  }
  do {
    for(;;) {
      if (fgets(areacode_buf,sizeof areacode_buf,areacode_file)==NULL) {
        if ((mode==0) && (!match)) {
          nl();
          npr("%s%s.",get_string(1264),areacode);
          nl();
        }
        fsh_close(areacode_file);
        return(match);
      }
      if (strncmp(areacode_buf,areacode,strlen(areacode))==0) {
        match=1;
        break;
      }
    }
    (void)sscanf(areacode_buf,"%[ -Z]",&s1);
    if (mode==0) {
      strcpy(s,&s1[strlen(s1)-2]);
      s1[strlen(s1)-3]=0;
      strcpy(state,s1);
      npr("%s",s);
      nl();
    } else {
    }
  } while (((strncmp(areacode_buf,areacode,strlen(areacode))==0)
    && (!hangup)));
  fsh_close(areacode_file);
  return(match);
}


void properize(char *s)
{
  int i;

  for (i=0;i<strlen(s);i++) {
    if ((i==0) || ((i>0) && ((s[i-1]==' ') || (s[i-1]=='.')))) {
      s[i]=toupper(s[i]);
    } else {
      s[i]=tolower(s[i]);
    }
    if ((i>1) && (s[i-1]=='c') && (s[i-2]=='M')) {
      s[i]=toupper(s[i]);
    }
  }
}

#endif

#ifdef OPT_AUTOVAL

#ifndef OPT_CALLBACK

#define CALLBAKSL 10                             /* added to newusersl */
#define CALLBAKDSL 10                            /* added to newuserdsl */
#define SYSOPSL 80                               /* added to newusersl */
#define SYSOPDSL 80                              /* added to newuserdsl */
#define AREACODE "319-"                          /* dash required */

void printclb(int i)
{
  int next,i1;
  char s[81];

  next=0;
  if (clbmsg[0].storage_type!=255)
    read_in_file("CALLBAK.MSG",(clbmsg),40);
#ifdef DEBUG
  for(i1=20;i1<40;i1++)
    npr("type %d=%d, as %ld \r\n",i1,clbmsg[i1].storage_type,
      clbmsg[i1].stored_as);
#endif
  sprintf(s,"%s%s",languagedir,"CALLBAK.MSG");
  read_message1(&clbmsg[i],0,0,&next,s);
}


int input_valphone(char *phone,int msg_num)         /* so strip doesn't see */
{
  int ok,i;
  int count;
  char s[81],ph[13];

  count=0;
  ok=0;
  if (msg_num!=0)
    printclb(msg_num);
  do {
    nl();
    if (msg_num!=15) {
      ansic(3);
      pl(get_string(527));
    }
    ansic(3);
    pl(get_string(493));
    prt(2,":");
    mpl(12);
    input(ph,12);
    strcpy(phone,ph);
    ok=1;
    if ((msg_num!=0) && !valid_phone(ph)) {
      ++count;
      if (count==3)
        hangup=1;
      else {
        nl();
        pl(get_string(1243));
      }
    }
  } while ((!ok) && (!hangup));
  if (!hangup) {
    if (!check_phone(phone,0))
      hangup=1;
  }
  nl();
  return(ok);
}


int check_phone(char *phone, int mode)
{
  int f,i;
  char s[81],s1[161],s2[81];
  userrec u;
  long p,l;
  FILE *trash;
  char buf[80];

  if (strlen(phone) < 7)
    return(0);
  if (mode!=0) {
    if (strlen(phone) == 14) {
      sprintf(s1,"%s",strrev(strrev(phone+2)));
      sprintf(phone,"%s",s1);
    }
    if (strlen(phone) == 10) {
      sprintf(s1,"%s",strrev(strrev(phone+2)));
      sprintf(phone,"%s",AREACODE);
      strcat(phone,s1);
    }
    if (strlen(phone) == 8) {
      sprintf(s1,"%s",phone);
      sprintf(phone,"%s",AREACODE);
      strcat(phone,s1);
    }
  }

  npr("\r\n2Wait, checking for duplicates ");
  for (i=0;i<status.users;i++) {
    if ((i % 10)==0)
      outstr("3.0");
    read_user(i,&u);
    if ((strstr(u.dataphone,phone)!=NULL) || (strcmp(phone,u.phone)==0)) {
      if ((i!=usernum) && ((usernum==-1)
        && (strcmp(thisuser.name,u.name)!=0))) {
        sprintf(s,"    %s%s%s",thisuser.name,get_stringx(1,112),phone);
        sl1(0,s);
        ssm(1,0,s);
        sprintf(s,"%s%s",get_stringx(1,113),u.name);
        sl1(0,s);
        ssm(1,0,s);
      }
    }
  }
  sprintf(s,"%sTRASHFON.TXT",syscfg.gfilesdir);
  if ((trash = fsh_open(s, "r")) == NULL) {
    strcpy(s,get_stringx(1,114));
    sl1(0,s);
    ssm(1,0,s);
  } else {
    outstr("3.0");
    for (;;) {
      if ((i % 10)==0)
        outstr("3.0");
      if (fgets(buf, sizeof buf, trash) == NULL) {
        strcpy(s,get_stringx(1,115));
        sl1(0,s);
        ssm(1,0,s);
        fsh_close(trash);
        return(1);
      }
      if (strncmp(buf, "end", 3) == 0)
        break;
      else {
        (void)sscanf(buf,"%s\r\n",&s);
        if (strcmp(s,phone)==0) {
          nl();
          pl(get_string(1257));
          sprintf(s,"    %s%s%s ",thisuser.name,get_stringx(1,116),phone);
          sl1(0,s);
          ssm(1,0,s);
          fsh_close(trash);
          hangup=1;
          return(0);
        }
      }
      i++;
    }
    outstr("\r\n");
    fsh_close(trash);
  }
  return(1);
}

#endif

void print_affil(void)
{
  net_system_list_rec *csne;

  if ((thisuser.net_num==0) || (thisuser.homesys==0))
    return;
  set_net_num(thisuser.net_num);
  csne=next_system(thisuser.homesys);
  npr("\r\n1Sysop, @%u, %s, on %s.\r\n",thisuser.homesys,csne->name,net_name);
}




void wwivnode(userrec *u, int mode)
{
  char sysnum[6],s[81],ph[13];
  net_system_list_rec *csne;
  unsigned short un, sy;

  if (!mode) {
    nl();
    outstr(get_string(1258));
    if (!yn())
      return;
  }
  nl();
  outstr(get_string(1259));
  input(sysnum,5);
  sprintf(s,"1@%s",sysnum);
  parse_email_info(s, &un, &sy);
  if (sy==0)
    return;
  csne=next_system(sy);
  sprintf(s,"Sysop @%u %s %s",sy,csne->name,net_name);
  ansic(2);
  nl();
  pl(s);
  nl();
  if (!mode) {
#ifndef OPT_CALLBACK
    input_valphone(ph,15);
#else
    input_phone(ph,15);
#endif
    enter_regnum();
  } else {
    strcpy(ph,csne->phone);
  }
  if (strcmp(ph,csne->phone)!=0) {
    printclb(10);
    sprintf(s,get_string(1260));
    strcpy(u->note,s);
    if (u->sl<syscfg.newusersl+CALLBAKSL)
      u->sl=syscfg.newusersl+CALLBAKSL;
    if (u->dsl<syscfg.newuserdsl+CALLBAKDSL)
      u->dsl=syscfg.newuserdsl+CALLBAKDSL;
    return;
  }
  sysoplog(get_stringx(1,117));
  sysoplog(s);
  u->restrict=0;
  if ((u->exempt & 1) ==0)                 /* post to call */
    u->exempt|= 1;
  if ((u->exempt & 8) ==0)                 /* up to down */
    u->exempt|= 8;
  if ((u->ar & 1) ==0)                     /* A */
    u->ar |=1;                             /* A */
  if ((u->ar & 2) ==0)                     /* B */
    u->ar |=2;                             /* B */
  if ((u->ar & 16384) ==0)                 /* O */
    u->ar |=16384;                         /* O */
  if ((u->ar & 32768) ==0)                 /* P */
    u->ar |=32768;                         /* P */
  if ((u->dar & 1) ==0)                    /* A */
    u->dar |=1;                            /* A */
  if ((u->dar & 2) ==0)                    /* B */
    u->dar |=2;                            /* B */
  if ((u->dar & 16384) ==0)                /* O */
    u->dar |=16384;                        /* O */
  if ((u->dar & 32768) ==0)                /* P */
    u->dar |=32768;                        /* P */
  printclb(8);
  if (strcmp(u->dataphone,csne->phone)==0) {
    if (u->sl<syscfg.newusersl+SYSOPSL)
      u->sl=syscfg.newusersl+SYSOPSL;
    if (u->dsl<syscfg.newuserdsl+SYSOPDSL)
      u->dsl=syscfg.newuserdsl+SYSOPDSL;
  } else {
    printclb(9);
  }
  u->net_num=net_num;
  u->homeuser=1;
  u->homesys=sy;
  print_affil();
/*  thisuser.forwardusr
  thisuser.forwardsys */
  if (!thisuser.wwiv_regnum) {
    enter_regnum();
  }
  changedsl();
}

#endif
