/*****************************************************************************

                                WWIV Version 4
                    Copyright (C) 1988-1993 by Wayne Bell

Distribution of the source code for WWIV, in any form, modified or unmodified,
without PRIOR, WRITTEN APPROVAL by the author, is expressly prohibited.
Distribution of compiled versions of WWIV is limited to copies compiled BY
THE AUTHOR.  Distribution of any copies of WWIV not compiled by the author
is expressly prohibited.


*****************************************************************************/



#include "vars.h"

#pragma hdrstop

#include <process.h>
#include <dir.h>


#define READ(x) sh_read(f,&(x),sizeof(x))

#define WRITE(x) sh_write(f,&(x),sizeof(x))


/****************************************************************************/

int restore_data(char *s)
{
  int f,stat,i;
  char s1[81];

  f=sh_open1(s,O_RDONLY | O_BINARY);
  if (f<0)
    return(-1);

  READ(stat);
  READ(oklevel);
  READ(noklevel);
  READ(ooneuser);
  READ(no_hangup);
  READ(ok_modem_stuff);
  READ(topdata);
  READ(last_time_c);
  READ(sysop_alert);
  READ(do_event);

  if (stat) {
    READ(andwith);
    READ(usernum);
    READ(chatcall);
    READ(chatreason);
    READ(timeon);
    READ(extratimecall);
    READ(curspeed);
    READ(modem_speed);
    READ(com_speed);
    READ(modem_flag);
    READ(cursub);
    READ(curdir);
    READ(curdloads);
    READ(msgreadlogon);
    READ(nscandate);
    READ(mailcheck);
    READ(smwcheck);
    READ(use_workspace);
    READ(using_modem);
    READ(last_time);
    READ(fsenttoday);
    READ(global_xx);
    READ(xtime);
    READ(xdate);
    READ(incom);
    READ(outcom);
    READ(global_handle);
    READ(actsl);
    READ(numbatch);
    READ(numbatchdl);

    sh_read(f,batch, numbatch*sizeof(batchrec));
    READ(batchtime);

    READ(last_time);
    READ(time_event);
    READ(syscfg.executetime);
    READ(syscfg.executestr);
    READ(i);
    uconfsub[0].confnum=i;
    READ(i);
    uconfdir[0].confnum=i;
    curconfsub=curconfdir=0;
    READ(i);
    usub[0].subnum=i;
    READ(i);
    udir[0].subnum=i;
    cursub=curdir=0;

    if (global_handle) {
      global_handle=0;
      set_global_handle(1);
    }

    read_user(usernum,&thisuser);
    read_qscn(usernum,qsc,0);
    if (set_language(thisuser.language)) {
      thisuser.language=0;
      set_language(thisuser.language);
    }

    useron=1;
    changedsl();
    topscreen();
  }
  if (ok_modem_stuff) {
    initport(syscfgovr.primaryport);
    if (stat) {
      set_baud(com_speed);
      if (modem_flag & flag_fc)
        flow_control = 1;
    } else {
      do_result(&(modem_i->defl));
    }
  }

  sh_close(f);
  unlink(s);
  if(instance > 1)
    sprintf(s1,"STAT.%3.3d",instance);
  else
    sprintf(s1,"STAT.WWV");
  unlink(s1);
  return(stat);
}

/****************************************************************************/

void save_state(char *s, int state,int ctc)
{
  int f,i;
  char s1[81];

  f=sh_open(s,O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
  if (f<0)
    return;

  WRITE(state);
  WRITE(oklevel);
  WRITE(noklevel);
  WRITE(ooneuser);
  WRITE(no_hangup);
  WRITE(ok_modem_stuff);
  WRITE(topdata);
  WRITE(last_time_c);
  WRITE(sysop_alert);
  WRITE(do_event);

  WRITE(andwith);
  WRITE(usernum);
  WRITE(chatcall);
  WRITE(chatreason);
  WRITE(timeon);
  WRITE(extratimecall);
  WRITE(curspeed);
  WRITE(modem_speed);
  WRITE(com_speed);
  WRITE(modem_flag);
  WRITE(cursub);
  WRITE(curdir);
  WRITE(curdloads);
  WRITE(msgreadlogon);
  WRITE(nscandate);
  WRITE(mailcheck);
  WRITE(smwcheck);
  WRITE(use_workspace);
  WRITE(using_modem);
  WRITE(last_time);
  WRITE(fsenttoday);
  WRITE(global_xx);
  WRITE(xtime);
  WRITE(xdate);
  WRITE(incom);
  WRITE(outcom);
  WRITE(global_handle);
  WRITE(actsl);
  WRITE(numbatch);
  WRITE(numbatchdl);

  sh_write(f,batch, numbatch*sizeof(batchrec));
  WRITE(batchtime);


  WRITE(last_time);
  WRITE(time_event);
  WRITE(syscfg.executetime);
  WRITE(syscfg.executestr);
  i=uconfsub[curconfsub].confnum;
  WRITE(i);
  i=uconfdir[curconfdir].confnum;
  WRITE(i);
  i=usub[cursub].subnum;
  WRITE(i);
  i=udir[curdir].subnum;
  WRITE(i);

  set_global_handle(0);

  sh_close(f);

  if(instance > 1)
    sprintf(s1,"STAT.%3.3d",instance);
  else
    sprintf(s1,"STAT.WWV");

  f=sh_open(s1,O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
  if (f<0)
    return;

  WRITE(incom);
  WRITE(outcom);
  WRITE(thisuser);
  WRITE(flow_control);
  WRITE(async_irq);
  WRITE(com_speed);
  WRITE(base);
  WRITE(andwith);
  WRITE(ctc);
  WRITE(defscreenbottom);
  WRITE(ok_modem_stuff);
  WRITE(save_dos);

  sh_close(f);


}

/****************************************************************************/

char *findit(char *cmd,char *ext)
{
  char *ss;
  static char s[81];

  if (ext)
    sprintf(s,"%s.%s",cmd,ext);
  else
    strcpy(s,cmd);

  if (exist(s))
    return(s);

  if (strchr(s,'/') || strchr(s,'\\'))
    ss=NULL;
  else
    ss=searchpath(s);

  return(ss);
}

/****************************************************************************/

void do_it_1(char *cl)
{
  char *ss,*ss1,*ss2;
  char t[81];

  sl1(1,"");
  if (ok_modem_stuff)
    closeport();
  close_strfiles();

  ss=cl;
  while ((*ss) && (*ss!=' '))
    ++ss;
  if (*ss==' ') {
    *ss=0;
    ss++;
  }
  ss1=point_shrink;
  *ss1=1;
  ss1++;
  ss2=findit(cl,NULL);
  if (!ss2) {
    ss2=findit(cl,"COM");
    if (!ss2) {
      ss2=findit(cl,"EXE");
      if (!ss2)
        return;
    }
  }
  strcpy(ss1,ss2);
  ss1=MK_FP(FP_SEG(ss1),0x0080);
  strcpy(t," ");
  strcat(t,ss);
  strcat(t,"\r");
  *ss1=strlen(t)-1;
  ++ss1;
  strcpy(ss1,t);
  setvect(save_dos,NULL);
  exit(0);
}

/****************************************************************************/

void shrink_out(char *command, int state, int intercept,int ctc,int ccc)
{
  char s[81];
  int ok_shrink;

  ok_shrink=1;
  if (!point_shrink) {
    ok_shrink=0;
    nl();
    pl(get_string(884));
    nl();
  }
  if (!searchpath("RETURN.EXE")) {
    ok_shrink=0;
    nl();
    pl(get_string(885));
    nl();
  }

  strcpy(s,command);
  strtok(s," \t");
  if ((!findit(s,NULL)) && (!findit(s,"COM")) && (!findit(s,"EXE"))) {
    if (findit(s,"BAT"))
      ccc=1;
    else
      return;
  }

  if (ok_shrink) {
    if (state>0) {
      write_user(usernum,&thisuser);
      write_qscn(usernum,qsc,0);
      if (state>1)
        thisuser.sysstatus &= ~sysstatus_pause_on_page;
    }
    if(instance > 1)
      sprintf(s,"RESTORE.%3.3d",instance);
    else
      sprintf(s,"RESTORE.WWV");
    save_state(s,state,ctc);
    set_protect(0);
    if (intercept)
      sprintf(s,"RETURN.EXE %d %d %s",intercept,ccc,command);
    else
      sprintf(s,"%s /C %s",getenv("COMSPEC"), command);
    do_it_1(s);
    if(instance > 1)
      sprintf(s,"RESTORE.%3.3d",instance);
    else
      sprintf(s,"RESTORE.WWV");
    unlink(s);
    if(instance > 1)
      sprintf(s,"STAT.%3.3d",instance);
    else
      sprintf(s,"STAT.WWV");
    unlink(s);
  } else {
    if (intercept)
      full_external(command,ctc,ccc);
    else
      do_remote(command,ccc);
  }
}
