/*****************************************************************************

				WWIV Version 4
                    Copyright (C) 1988-1993 by Wayne Bell

Distribution of the source code for WWIV, in any form, modified or unmodified,
without PRIOR, WRITTEN APPROVAL by the author, is expressly prohibited.
Distribution of compiled versions of WWIV is limited to copies compiled BY
THE AUTHOR.  Distribution of any copies of WWIV not compiled by the author
is expressly prohibited.


*****************************************************************************/



#include "vars.h"

#pragma hdrstop

#include <dir.h>



#define SETREC(f,i)  sh_lseek(f,((long) (i))*((long)sizeof(uploadsrec)),SEEK_SET);

/* number of dots for searching */
#define DOTS 5

/* color for frame */
#define FRAME 7

/* How far to indent extended descriptions */
#define INDENTION 24

/* Max # of lines for extended description */
#define MAX_LINES 10

/* If its OK to use the FSED for editing extended descriptions */
#ifdef OPT_FSED_EXT_DESC
#define FSED_OK ((okfsed()) && (1))
#else
#define FSED_OK ((okfsed()) && (0))
#endif

/* the archive type to use */
#define ARC_NUMBER 0

int foundany;

unsigned long bytes_to_k(unsigned long b)
{
  return((unsigned long)((b+1023)/1024));
}


int check_batch_queue(char *fn)
{
  int i;

  for (i=0; i<numbatch; i++) {
    if (strcmp(fn,batch[i].filename)==0)
      if (batch[i].sending)
        return(1);
      else
        return(-1);
  }

  return(0);
}


int check_ul_event(int dn, uploadsrec *u)
{
  char s[161],s1[10];

  if (syscfg.upload_c[0]) {
    sprintf(s1,"%d",syscfgovr.primaryport);
    stuff_in(s,syscfg.upload_c,create_chain_file(),
             directories[dn].path,stripfn(u->filename),s1,"");
    run_external_ul(s);
    topscreen();
    sprintf(s,"%s%s",directories[dn].path, stripfn(u->filename));
    if (!exist(s)) {
      sprintf(s,get_stringx(1,40),
              u->filename, directories[dn].name);
      sysoplog(s);
      outstr(u->filename);
      pl(get_string(727));
      return(1);
    }
  }

  return(0);
}

char (*devices)[9];
int num_devices;

void finddevs(char (*devs)[9], int *count)
{
  char s[9];
  int i;
  char far *ss;
  long far *l;
  union REGS regs;
  struct SREGS sregs;

  *count=0;
  regs.x.ax=0x5200;
  int86x(INT_REAL_DOS, &regs, &regs, &sregs);
  ss=MK_FP(sregs.es, regs.x.bx);
  ss += 34;
  l=(long far *) ss;

  while (((unsigned short) l) != 0xffff) {
    ss=(char far *) l;
    ss += 10;
    if (*ss>32) {
      strncpy(s,ss,8);
      s[8]=0;
      for (i=7; i; i--)
        if (s[i]==' ')
          s[i]=0;
        else
          break;
      if (devs) {
        strcpy(devs[*count],s);
      }
      ++(*count);
    }
    l=(long far *) *l;
  }
}

void find_devices(void)
{
  finddevs(NULL, &num_devices);
  devices=farmalloc((num_devices+2)*9);
  finddevs(devices,&num_devices);
}

int okfn(char *s)
{
  int i,l;
  unsigned char ch;

  l=strlen(s);
  if ((s[0]=='-') || (s[0]==' ') || (s[0]=='.') || (s[0]=='@'))
    return(0);
  for (i=0; i<l; i++) {
    ch=s[i];
    if ((ch==' ') || (ch=='/') || (ch=='\\') || (ch==':') ||
        (ch=='>') || (ch=='<') || (ch=='|')  || (ch=='+') ||
        (ch==',') || (ch==';') || (ch=='^')  || (ch=='\"') ||
        (ch=='\'') || (ch>126))
      return(0);
  }

  for (i=0; i<num_devices; i++) {
    l=strlen(devices[i]);
    if (strncmp(devices[i],s,l)==0) {
      if ((s[l]==0) || (s[l]=='.') || (l==8))
        return(0);
    }
  }
  return(1);
}

void print_devices(void)
{
  int i;
  for (i=0; i<num_devices; i++)
    pl(devices[i]);
}

char *exts[] = {"", ".COM", ".EXE", ".BAT", 0};

char *make_abs_cmd(char *out)
{
  char s[161],s1[161],s2[161],*ss,*ss1;
  int i;

  strcpy(s1,out);

  if (s1[1]==':') {
    if (s1[2]!='\\') {
      getcurdir(upcase(s1[0])-'A'+1, s);
      sprintf(out,"%c:\\%s\\%s", s1[0], s, s1+2);
    }
    goto got_cmd;
  }

  if (out[0]=='\\') {
    sprintf(out,"%c:%s", cdir[0], s1);
    goto got_cmd;
  }

  ss=strchr(s1,' ');
  if (ss) {
    *ss=0;
    sprintf(s2," %s",ss+1);
  } else {
    s2[0]=0;
  }
  for (i=0; exts[i]; i++) {
    if (i==0) {
      ss1=strrchr(s1,'\\');
      if (!ss1)
        ss1=s1;
      if (strchr(ss1,'.')==0)
        continue;
    }
    sprintf(s,"%s%s",s1,exts[i]);
    if (exist(s)) {
      sprintf(out,"%s\\%s%s", cdir, s, s2);
      goto got_cmd;
    } else {
      ss1=searchpath(s);
      if (ss1) {
        sprintf(out, "%s%s", ss1, s2);
        goto got_cmd;
      }
    }
  }

  sprintf(out, "%s\\%s%s", cdir, s1, s2);

got_cmd:
  return(out);
}

void get_arc_cmd(char *out, char *arcfn, int cmd, char *ofn)
{
  char *ss,s[161];
  int i;

  out[0]=0;
  ss=strchr(arcfn,'.');
  if (ss==NULL)
    return;
  ++ss;
  for (i=0; i<4; i++)
    if (stricmp(ss,syscfg.arcs[i].extension)==0) {
      switch(cmd) {
        case 0: strcpy(s,syscfg.arcs[i].arcl); break;
        case 1: strcpy(s,syscfg.arcs[i].arce); break;
        case 2: strcpy(s,syscfg.arcs[i].arca); break;
      }
      if (s[0]==0)
        return;
      stuff_in(out,s,arcfn,ofn,"","","");
      make_abs_cmd(out);
      return;
    }

}


int list_arc_out(char *fn, char *dir)
{
  char s[161],s1[81],s2[81];
  int i=0;

  sprintf(s1,"%s%s",dir,fn);
  if (directories[udir[curdir].subnum].mask & mask_cdrom) {
    sprintf(s2,"%s%s",dir,fn);
    sprintf(s1,"%s%s",syscfgovr.tempdir,fn);
    if (!exist(s1))
      copy_file(s2,s1);
  }
  get_arc_cmd(s,s1,0,"");
  if (!okfn(fn))
    s[0]=0;
  if (exist(s1) && (s[0]!=0)) {
    nl();
    nl();
    outstr(get_string(728));
    pl(fn);
    nl();
    i=do_external(s,1);
    nl();
  } else {
    nl();
    outs(get_string(729));
    pl(fn);
    nl();
    i=0;
  }
  return(i);
}


int ratio_ok(void)
{
  int ok=1;
  char s[101];

  if (!(thisuser.exempt & exempt_ratio))
    if ((syscfg.req_ratio>0.0001) && (ratio()<syscfg.req_ratio)) {
      ok=0;
      nl();
      nl();
      sprintf(s,"%s %-5.3f.  %s %-5.3f %s.",
              get_string(730), ratio(),
              get_string(731), syscfg.req_ratio,
              get_string(732));
      pl(s);
      nl();
    }

  if (!(thisuser.exempt & exempt_post))
    if ((syscfg.post_call_ratio>0.0001) && (post_ratio()<syscfg.post_call_ratio)) {
      ok=0;
      nl();
      nl();
      sprintf(s,"%s %-5.3f.  %s %-5.3f %s.",
              get_string(733), post_ratio(),
              get_string(731), syscfg.post_call_ratio,
              get_string(732));
      pl(s);
      nl();
    }


  return(ok);
}


int dcs(void)
{
  if (cs())
    return(1);
  if (thisuser.dsl>=100)
    return(1);
  else
    return(0);
}


void dliscan1(int dn)
{
  int i,f;
  uploadsrec u;
  long l;

  sprintf(dlfn,"%s%s.DIR",syscfg.datadir,directories[dn].filename);
  f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
  i=filelength(f)/sizeof(uploadsrec);
  if (i==0) {
    memset(&u, 0, sizeof(uploadsrec));
    strcpy(u.filename,"|MARKER|");
    time(&l);
    u.daten=l;
    SETREC(f,0);
    sh_write(f,(void *)&u,sizeof(uploadsrec));
  } else {
    SETREC(f,0);
    sh_read(f,(void *)&u,sizeof(uploadsrec));
    if (strcmp(u.filename,"|MARKER|")) {
      numf=u.numbytes;
      memset(&u, 0, sizeof(uploadsrec));
      strcpy(u.filename,"|MARKER|");
      time(&l);
      u.daten=l;
      u.numbytes = numf;
      SETREC(f,0);
      sh_write(f, &u, sizeof(uploadsrec));
    }
  }
  f=sh_close(f);
  numf=u.numbytes;
  this_date = u.daten;
  dir_dates[dn]=this_date;

  sprintf(edlfn,"%s%s.EXT",syscfg.datadir,directories[dn].filename);
}

void dliscan_hash(int dn)
{
  char s[81];
  int i,f;
  uploadsrec u;

  if ((dn>=num_dirs) || (dir_dates[dn]))
    return;

  sprintf(s,"%s%s.DIR",syscfg.datadir,directories[dn].filename);
  f=sh_open1(s,O_RDONLY | O_BINARY);
  if (f<0) {
    time((long *)&(dir_dates[dn]));
    return;
  }
  i=filelength(f)/sizeof(uploadsrec);
  if (i<1) {
    time((long *)&(dir_dates[dn]));
  } else {
    SETREC(f,0);
    sh_read(f,(void *)&u,sizeof(uploadsrec));
    if (strcmp(u.filename,"|MARKER|")==0) {
      dir_dates[dn]=u.daten;
    } else {
      time((long *)&(dir_dates[dn]));
    }
  }
  sh_close(f);
}


void dliscan(void)
{
  dliscan1(udir[curdir].subnum);
}


void add_extended_description(char *fn, char *desc)
{
  ext_desc_type ed;
  int f;

  strcpy(ed.name,fn);
  ed.len=strlen(desc);
  f=sh_open(edlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
  sh_lseek(f,0L,SEEK_END);
  sh_write(f,&ed,sizeof(ext_desc_type));
  sh_write(f,desc,ed.len);
  f=sh_close(f);
}


void delete_extended_description(char *fn)
{
  ext_desc_type ed;
  long r,w,l1,f;
  char *ss=NULL;

  r=w=0;
  if ((ss=malloca(10240L))==NULL)
    return;
  f=sh_open(edlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
  l1=filelength(f);
  while (r<l1) {
    sh_lseek(f,r,SEEK_SET);
    sh_read(f,&ed,sizeof(ext_desc_type));
    if (ed.len<10000) {
      sh_read(f,ss,ed.len);
      if (strcmp(fn,ed.name)) {
        if (r!=w) {
          sh_lseek(f,w,SEEK_SET);
          sh_write(f,&ed,sizeof(ext_desc_type));
          sh_write(f,ss,ed.len);
        }
        w +=(sizeof(ext_desc_type) + ed.len);
      }
    }
    r += (sizeof(ext_desc_type) + ed.len);
  }
  chsize(f,w);
  f=sh_close(f);
  farfree(ss);
}


char *read_extended_description(char *fn)
{
  ext_desc_type ed;
  long l,l1;
  char *ss=NULL;
  int f;

  l=0;
  f=sh_open1(edlfn,O_RDONLY | O_BINARY);
  if (f>0) {
    l1=filelength(f);
    while (l<l1) {
      sh_lseek(f,l,SEEK_SET);
      l += (long) sh_read(f,&ed,sizeof(ext_desc_type));
      if (strcmp(fn,ed.name)==0) {
        ss=malloca((long) ed.len+10);
        if (ss) {
          sh_read(f,ss,ed.len);
          ss[ed.len]=0;
        }
        f=sh_close(f);
        return(ss);
      } else
        l += (long) ed.len;
    }
    f=sh_close(f);
  }
  return(NULL);
}



void print_extended(char *fn, int *abort, unsigned char numlist, int indent)
{
  char *ss;
  int next=0;
  unsigned char numl=0;
  int cpos=0;
  char ch,s[81];
  int i;

  ss=read_extended_description(fn);
  if (ss) {
    if (indent!=2)
      ch=10;
    while ((ss[cpos]) && (!(*abort)) && (numl<numlist)) {
      if (ch==10) {
        if (indent==1) {
          for (i=0; i<INDENTION; i++) {
            if ((i==12) || (i==18))
              s[i]=(okansi() ? '' : '|');
            else
              s[i]=32;
          }
          s[INDENTION]=0;
          ansic((thisuser.sysstatus & sysstatus_extra_color)
            && (!(*abort)) ? FRAME : 0);
          osan(s,abort,&next);
          if ((thisuser.sysstatus & sysstatus_extra_color) && (!(*abort)))
            ansic(1);
        } else {
          if (indent==2) {
            for (i=0; i<13; i++)
              s[i]=32;
            s[13]=0;
            osan(s,abort,&next);
            if ((thisuser.sysstatus & sysstatus_extra_color) && (!(*abort)))
              ansic(2);
          }
        }
      }
      outchr(ch=ss[cpos++]);
      checka(abort,&next);
      if (ch==10)
        ++numl;
      else
        if ((ch!=13) && (wherex()>=78)) {
          osan("\r\n",abort,&next);
          ch=10;
        }
    }
    if (wherex())
      nl();
  }
  farfree(ss);
}



void modify_extended_description(char **sss, char *dest, char *title)
{
  char s[161],s1[161];
  int f,ii,i,i1,i2;

  if (*sss)
    ii=1;
  else
    ii=0;
  do {
    if (ii) {
      nl();
      if (FSED_OK)
        prt(5,get_string(734));
      else
        prt(5,get_string(735));
      if (!yn())
        return;
    } else {
      nl();
      prt(5,get_string(736));
      if (!yn())
        return;
    }
    if (FSED_OK) {
      sprintf(s,"%sEXTENDED.DSC", syscfgovr.tempdir);
      if (*sss) {
        f=sh_open(s,O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
        sh_write(f,*sss,strlen(*sss));
        sh_close(f);
        farfree(*sss);
        *sss=NULL;
      } else
        unlink(s);
      i=thisuser.screenchars;
      if (thisuser.screenchars>(76-INDENTION))
        thisuser.screenchars=76-INDENTION;
      i1=external_edit("extended.dsc",syscfgovr.tempdir,(int) thisuser.defed-1,
        MAX_LINES, dest, title, 1);
      thisuser.screenchars=i;
      if (i1) {
        if ((*sss=malloca(10240))==NULL)
          return;
        f=sh_open1(s,O_RDWR | O_BINARY);
        sh_read(f,*sss,(int) filelength(f));
        (*sss)[filelength(f)]=0;
        sh_close(f);
      }
    } else {
      if (*sss)
        farfree(*sss);
      if ((*sss=malloca(10240))==NULL)
        return;
      *sss[0]=0;
      i=1;
      nl();
      sprintf(s,"%s %d %s, %d %s",
              get_string(737), MAX_LINES,
              get_string(738), 78-INDENTION, get_string(739));
      pl(s);
      nl();
      s[0]=0;
      i1=thisuser.screenchars;
      if (thisuser.screenchars>(76-INDENTION))
        thisuser.screenchars=76-INDENTION;
      do {
        ansic(2);
        npr("%d: ",i);
        ansic(0);
        s1[0]=0;
        inli(s1,s,90,1);
        i2=strlen(s1);
        if (i2 && (s1[i2-1]==1))
          s1[i2-1]=0;
        if (s1[0]) {
          strcat(s1,"\r\n");
          strcat(*sss,s1);
        }
      } while ((i++<10) && (s1[0]));
      thisuser.screenchars=i1;
      if (*sss[0]==0) {
        farfree(*sss);
        *sss=NULL;
      }
    }
    prt(5,get_string(740));
    i=!yn();
    if (i) {
      farfree(*sss);
      *sss=NULL;
    }
  } while (i);
}


void align(char *s)
{
  char f[40],e[40],s1[20],*s2;
  int i,i1,i2;

  i1=0;
  if (s[0]=='.')
    i1=1;
  for (i=0; i<strlen(s); i++)
    if ((s[i]=='\\') || (s[i]=='/') || (s[i]==':') || (s[i]=='<') ||
      (s[i]=='>') || (s[i]=='|'))
      i1=1;
  if (i1) {
    strcpy(s,get_string(1310));
    return;
  }
  s2=strchr(s,'.');
  if (s2==NULL) {
    e[0]=0;
  } else {
    strcpy(e,&(s2[1]));
    e[3]=0;
    s2[0]=0;
  }
  strcpy(f,s);

  for (i=strlen(f); i<8; i++)
    f[i]=32;
  f[8]=0;
  i1=0;
  i2=0;
  for (i=0; i<8; i++) {
    if (f[i]=='*')
      i1=1;
    if (f[i]==' ')
      i2=1;
    if (i2)
      f[i]=' ';
    if (i1)
      f[i]='?';
  }

  for (i=strlen(e); i<3; i++)
    e[i]=32;
  e[3]=0;
  i1=0;
  for (i=0; i<3; i++) {
    if (e[i]=='*')
      i1=1;
    if (i1)
      e[i]='?';
  }

  for (i=0; i<12; i++)
    s1[i]=32;
  strcpy(s1,f);
  s1[8]='.';
  strcpy(&(s1[9]),e);
  strcpy(s,s1);
  for (i=0; i<12; i++)
    s[i]=upcase(s[i]);
}


int compare(char *s1, char *s2)
{
  int ok,i;

  ok=1;
  for (i=0; i<12; i++)
    if ((s1[i]!=s2[i]) && (s1[i]!='?') && (s2[i]!='?'))
      ok=0;
  return(ok);
}


void printinfo(uploadsrec *u, int *abort)
{
  char s[85],s1[40],s2[81];
  int i,next,fc;

  fc=thisuser.sysstatus & sysstatus_extra_color;
  if (titled!=0)
    printtitle(abort);
  if ((tagging==0) && (!x_only))
    return;
  if ((tagging == 1) && !(thisuser.sysstatus & sysstatus_no_tag)
    && (!x_only)) {
    filelist[tagptr].u=*u;
    filelist[tagptr].directory= udir[curdir].subnum;
    filelist[tagptr].dir_mask=  directories[udir[curdir].subnum].mask;
    tagptr++;
    sprintf(s,"\r%d%2d%d%c",
      (check_batch_queue(filelist[tagptr-1].u.filename)) ? 6 : 0,
      tagptr,fc ? FRAME : 0, okansi() ? '' : '|' );
    osan(s,abort,&next);
  } else
    if (!x_only)
      outstr("\r");
  if (fc)
    ansic(1);
  strncpy(s,u->filename,8);
  s[8]=0;
  osan(s,abort,&next);
  strncpy(s,&((u->filename)[8]),4);
  s[4]=0;
  if (fc)
    ansic(1);
  osan(s,abort,&next);
  ansic(fc ? FRAME : 0);
  osan((okansi() ? "" : "|"),abort,&next);

  ltoa(bytes_to_k(u->numbytes),s1,10);
  strcat(s1,"k");

  if (!(directories[udir[curdir].subnum].mask & mask_cdrom)) {
    strcpy(s2,directories[udir[curdir].subnum].path);
    strcat(s2,u->filename);
    if (!exist(s2))
      strcpy(s1,get_string(741));
  }

  for (i=0; i<5-(int)strlen(s1); i++)
    s[i]=32;
  s[i]=0;
  strcat(s,s1);
  if (fc)
    ansic(2);
  osan(s,abort,&next);

  if ((tagging == 1) && !(thisuser.sysstatus & sysstatus_no_tag)
    && (!x_only)) {
    ansic(fc ? FRAME : 0);
    osan((okansi() ? "" : "|"),abort,&next);
    sprintf(s1,"%d",u->numdloads);

    for (i=0; i<4-(int)strlen(s1); i++)
      s[i]=32;
    s[i]=0;
    strcat(s,s1);
    if (fc)
      ansic(2);
    osan(s,abort,&next);
  }

  ansic(fc ? FRAME : 0);
  osan((okansi() ? "" : "|"),abort,&next);
  sprintf(s,"%d%s",
    (u->mask & mask_extended) ? 1 : 2, u->description);
  if ((tagging) && !(thisuser.sysstatus & sysstatus_no_tag)
    && (!x_only)) {
    plal(s,thisuser.screenchars-28,abort);
  } else {
    plal(s,strlen(s),abort);
    if ((!*abort) && (thisuser.num_extended) && (u->mask & mask_extended))
      print_extended(u->filename,abort,thisuser.num_extended,1);
  }
  if (!(*abort)) {
    ++num_listed;
  } else {
    tagptr=0;
    tagging=0;
  }
}


void printtitle(int *abort)
{
  char s[81], *ss;
  int i,i1;

  if (x_only) {
    nl();
    ss="";
  } else
    ss="\r";
  if ((lines_listed >= screenlinest - 7) && (!x_only)
    && !(thisuser.sysstatus & sysstatus_no_tag)) {
    tag_files();
    if (tagging==0)
      return;
  }
  sprintf(s,"%s%s - #%s, %d %s.",ss,directories[udir[curdir].subnum].name,
                                udir[curdir].keys,numf, get_string(742));
  ansic(thisuser.sysstatus & sysstatus_extra_color ? FRAME : 0);
  if (((num_listed==0) && (tagptr==0)) || (tagging==0)
    || ((thisuser.sysstatus & sysstatus_no_tag) && (num_listed==0))) {
    if (okansi())
      npr("%s%s\r\n",ss,get_string(1311));
    else
      npr("%s%s\r\n",ss,get_string(1312));
  } else {
    if ((titled!=2) && (tagging == 1)
      && !(thisuser.sysstatus & sysstatus_no_tag)) {
      if (okansi())
        npr("%s%s\r\n",ss,get_string(1313));
      else
        npr("%s%s\r\n",ss,get_string(1314));
    } else {
      if (((thisuser.sysstatus & sysstatus_no_tag) || (tagging==2))
        && (num_listed!=0)) {
        ansic(thisuser.sysstatus & sysstatus_extra_color ? FRAME : 0);
        if (okansi())
          npr("%s%s\r\n",ss,get_string(1315));
        else
          npr("%s%s\r\n",ss,get_string(1316));
      }
    }
  }
  if (thisuser.sysstatus & sysstatus_extra_color)
    ansic(2);
  pla(s,abort);
  if ((tagging == 1) && !(thisuser.sysstatus & sysstatus_no_tag)
    && (!x_only)) {
    ansic(thisuser.sysstatus & sysstatus_extra_color ? FRAME : 0);
    if (okansi())
      npr("\r%s\r\n",get_string(1317));
    else
      npr("\r%s\r\n",get_string(1318));
  } else {
    ansic(thisuser.sysstatus & sysstatus_extra_color ? FRAME : 0);
    if (okansi())
      npr("\r%s\r\n",get_string(1319));
    else
      if (x_only)
        npr("%s\r\n",get_string(1320));
      else
        npr("\r%s\r\n",get_string(1321));
  }
  titled=0;
}


void file_mask(char *s)
{
  nl();
  helpl=9;
  prt(2,get_string(743));
  input(s,12);
  if (s[0]==0)
    strcpy(s,"*.*");
  if (strchr(s,'.')==NULL)
    strcat(s,".*");
  align(s);
  nl();
}


void listfiles(void)
{
  char s[81];
  int i,abort,next=0,f;
  uploadsrec u;

  dliscan();
  file_mask(s);
  abort=0;
  num_listed=0;
  titled=1;
  lines_listed=0;
  f=sh_open1(dlfn,O_RDONLY | O_BINARY);
  for (i=1; (i<=numf) && (!abort) && (!hangup) && (tagging!=0); i++) {
    SETREC(f,i);
    sh_read(f,(void *)&u,sizeof(uploadsrec));
    if (compare(s,u.filename)) {
      f=sh_close(f);
      printinfo(&u, &abort);
      f=sh_open1(dlfn,O_RDONLY | O_BINARY);
    } else if (!empty())
      checka(&abort,&next);
  }
  f=sh_close(f);
  endlist(1);
}


void nscandir(int d, int *abort)
{
  int i,od,next=0,f;
  uploadsrec u;

  if ((dir_dates[udir[d].subnum]) && (dir_dates[udir[d].subnum]<nscandate))
    return;

  od=curdir;
  curdir=d;
  dliscan();
  if (this_date>=nscandate) {
    f=sh_open1(dlfn,O_RDONLY | O_BINARY);
    for (i=1; (i<=numf) && (!(*abort)) && (!hangup) && (tagging!=0); i++) {
      checkhangup();
      SETREC(f,i);
      sh_read(f,(void *)&u,sizeof(uploadsrec));
      if (u.daten>=nscandate) {
        f=sh_close(f);
        printinfo(&u, abort);
        f=sh_open1(dlfn,O_RDONLY | O_BINARY);
      } else if (!empty())
        checka(abort,&next);

    }
    f=sh_close(f);
  }
  curdir=od;
}


void nscanall(void)
{
  int abort,i,i1,count,color,ac=0;
  char s[81];

  if ((uconfdir[1].confnum!=-1) && (okconf(&thisuser))) {
    if (!x_only) {
      nl();
      prt(5,get_string(1379));
      ac=yn();
      nl();
    } else
      ac=1;
    if (ac)
      tmp_disable_conf(1);
  }
  abort=0;
  num_listed=0;
  count=0;
  color=3;
  if (!x_only) {
    outstr("\r");
    outstr(get_string(1184));
  }
  for (i=0; (i<num_dirs) && (!abort) && (udir[i].subnum!=-1) &&
       (tagging!=0); i++) {
    count++;
    if (!x_only) {
      npr("%d.",color);
      if (count>=DOTS) {
        outstr("\r");
        outstr(get_string(1184));
        color++;
        count=0;
        if (color==4)
          color++;
        if (color==10)
          color=0;
      }
    }
    i1=udir[i].subnum;
    if (qsc_n[i1/32]&(1L<<(i1%32))) {
      titled=1;
      nscandir(i,&abort);
    }
  }
  endlist(2);
  if (ac)
    tmp_disable_conf(0);
}


void searchall(void)
{
  int i,i1,pts,abort,ocd,next=0,f,count,color,ac=0;
  char s[81];
  uploadsrec u;

  if ((uconfdir[1].confnum!=-1) && (okconf(&thisuser))) {
    if (!x_only) {
      nl();
      prt(5,get_string(1379));
      ac=yn();
      nl();
    } else
      ac=1;
    if (ac)
      tmp_disable_conf(1);
  }

  abort=0;
  ocd=curdir;
  if (x_only) {
    strcpy(s,"*.*");
    align(s);
  } else {
    nl();
    nl();
    pl(get_string(745));
    file_mask(s);
    if (!x_only) {
      nl();
      outstr(get_string(1184));
    }
  }
  num_listed=0;
  lines_listed=0;
  count=0;
  color=3;
  for (i=0; (i<num_dirs) && (!abort) && (!hangup) && (tagging || x_only)
    && (udir[i].subnum!=-1); i++) {
    i1=udir[i].subnum;
    pts=0;
    if (qsc_n[i1/32]&(1L<<(i1%32)))
      pts=1;
    pts=1;
    /* remove pts=1 to search only marked directories */
    if (pts) {
      if (!x_only) {
        count++;
        npr("%d.",color);
        if (count>=DOTS) {
          outstr("\r2Searching ");
          color++;
          count=0;
          if (color==4)
            color++;
          if (color==10)
            color=0;
        }
      }
      curdir=i;
      dliscan();
      titled=1;
      f=sh_open1(dlfn,O_RDONLY | O_BINARY);
      for (i1=1; (i1<=numf) && (!abort) && (!hangup) && (tagging || x_only); i1++) {
        SETREC(f,i1);
        sh_read(f,(void *)&u,sizeof(uploadsrec));
        if (compare(s,u.filename)) {
          f=sh_close(f);
          printinfo(&u, &abort);
          f=sh_open1(dlfn,O_RDONLY | O_BINARY);
        } else if (!empty())
          checka(&abort,&next);
      }
      f=sh_close(f);
    }
  }
  curdir=ocd;
  endlist(1);
  if (ac)
    tmp_disable_conf(0);
}


int recno(char *s)
{
  int i,f;
  uploadsrec u;

  i=1;
  if (numf<1)
    return(-1);
  f=sh_open1(dlfn,O_RDONLY | O_BINARY);
  SETREC(f,i);
  sh_read(f,(void *)&u,sizeof(uploadsrec));
  while ((i<numf) && (compare(s,u.filename)==0)) {
    ++i;
    SETREC(f,i);
    sh_read(f,(void *)&u,sizeof(uploadsrec));
  }
  f=sh_close(f);
  if (compare(s,u.filename))
    return(i);
  else
    return(-1);
}


int nrecno(char *s,int i1)
{
  int i,f;
  uploadsrec u;

  i=i1+1;
  if ((numf<1) || (i1>=numf))
    return(-1);

  f=sh_open1(dlfn,O_RDONLY | O_BINARY);
  SETREC(f,i);
  sh_read(f,(void *)&u,sizeof(uploadsrec));
  while ((i<numf) && (compare(s,u.filename)==0)) {
    ++i;
    SETREC(f,i);
    sh_read(f,(void *)&u,sizeof(uploadsrec));
  }
  f=sh_close(f);
  if (compare(s,u.filename))
    return(i);
  else
    return(-1);
}


int printfileinfo(uploadsrec *u, int dn)
{
  char s[81];
  double d;
  int abort;

  if (modem_speed)
    d=((double) (((u->numbytes)+127)/128)) *
      (1620.0) /
      ((double) (modem_speed));
  else
    d=0.0;
  outstr(get_string(746)); pl(stripfn(u->filename));
  outstr(get_string(747)); pl(u->description);
  outstr(get_string(748)); npr("%dk\r\n", bytes_to_k(u->numbytes));
  outstr(get_string(749)); pl(ctim(d));
  outstr(get_string(750)); pl(u->date);
  outstr(get_string(751)); pl(u->upby);
  outstr(get_string(752)); pln(u->numdloads);
  nl();
  abort=0;
  if (u->mask & mask_extended) {
    pl(get_string(753));
    print_extended(u->filename,&abort,255,0);
  }

  sprintf(s,"%s%s",directories[dn].path,u->filename);
  if (!exist(s)) {
    nl();
    pl(get_string(754));
    nl();
    return(-1);
  }

  if (nsl()>=d)
    return(1);
  else
    return(0);
}


void upload(int dn)
{
  directoryrec d;
  uploadsrec u,u1;
  int i,i1,i2,i3,i4,ok,xfer,f;
  char s[255],s1[81],*ss;
  long l;
  double ti;

  if ((numbatch!=0) && (numbatch-numbatchdl>0)) {
    npr("2Upload files in your batch QUEUE? (1Y/n2) ");
    if (ny()) {
      batchdl(2);
      return;
    }
  }
  dliscan1(dn);
  d=directories[dn];
  if (numf>=d.maxfiles) {
    nl();
    nl();
    pl(get_string(755));
    nl();
    return;
  }
  if ((d.mask & mask_no_uploads) && (!dcs())) {
    nl();
    nl();
    pl(get_string(756));
    nl();
    return;
  }
  nl();
  l=(long)freek1(d.path);
  sprintf(s,"%s - %ldk %s.",get_string(757), l, get_string(758));
  pl(s);
  nl();
  if (l<100) {
    pl(get_string(759));
    nl();
    return;
  }
  prt(2,get_string(44));
  input(s,12);
  if (!okfn(s))
    s[0]=0;
#ifdef OPT_FAST_SEARCH
  else {
    if (!is_uploadable(s)) {
      if (so()) {
        nl();
        prt(5,get_string(1322));
        if (!yn()) {
          s[0]=0;
        }
      } else {
        s[0]=0;
        nl();
        pl(get_string(1323));
      }
    }
  }
#endif
  align(s);
  if (strchr(s,'?')) {
    return;
  }
  if (d.mask & mask_archive) {
    ok=0;
    s1[0]=0;
    for (i=0; i<4; i++) {
      if (syscfg.arcs[i].extension[0] && syscfg.arcs[i].extension[0]!=' ') {
        if (s1[0])
          strcat(s1,", ");
        strcat(s1,syscfg.arcs[i].extension);
        if (strcmp(s+9,syscfg.arcs[i].extension)==0)
          ok=1;
      }
    }
    if (!ok) {
      nl();
      pl(get_string(760));
      pl(get_string(761));
      pl(s1);
      nl();
      return;
    }
  }
  strcpy(u.filename,s);
  u.ownerusr=usernum;
  u.ownersys=0;
  u.numdloads=0;
  u.filetype=0;
  u.mask=0;
  strcpy(u.upby,nam(&thisuser,usernum));
  strcpy(u.date,date());
  nl();
  ok=1;
  xfer=1;
  if (check_batch_queue(u.filename)) {
    ok=0;
    nl();
    pl(get_string(762));
    nl();
  } else {
    sprintf(s1,"%s '%s' %s %s? ",get_string(757), s,get_string(763),d.name);
    if (strcmp(s,get_string(1310)))
      prt(5,s1);
    else
      ok=0;
  }
  if ((ok) && (yn())) {
    sprintf(s1,"%s%s",d.path,s);
    if (exist(s1)) {
      if (dcs()) {
        xfer=0;
        nl();
        nl();
        pl(get_string(764));
        prt(5,get_string(765));
        if (yn()==0)
          ok=0;
      } else {
        nl();
        nl();
        pl(get_string(766));
        nl();
        ok=0;
      }
    } else
      if (!incom) {
        nl();
        pl(get_string(767));
        pl(get_string(768));
        nl();
        ok=0;
      }
    if ((d.mask & mask_PD) && (ok)) {
      nl();
      prt(5,get_string(769));
      if (!yn()) {
        nl();
        pl(get_string(770));
        pl(get_string(771));
        pl(get_string(772));
        pl(get_string(773));
        pl(get_string(774));
        nl();
        sprintf(s,get_stringx(1,41),u.filename);
        add_ass(5,s);
        ok=0;
      } else
        u.mask=mask_PD;
    }
#ifndef OPT_FAST_SEARCH
    if (ok) {
      nl();
      pl(get_string(775));
      nl();
      i2=0;
      for (i=0; (i<num_dirs) && (udir[i].subnum!=-1); i++) {
        strcpy(s,get_string(776));
        strcat(s,directories[udir[i].subnum].name);
        for (i3=i4=strlen(s); i3<i2; i3++) {
          s[i3]=' ';
          s[i3+1]=0;
        }
        i2=i4;
        npr("%s\r",s);

        dliscan1(udir[i].subnum);
        i1=recno(u.filename);
        if (i1>=0) {
          nl();
          outstr(get_string(777));
          pl(directories[udir[i].subnum].name);
          if (dcs()) {
            nl();
            prt(5,get_string(778));
            if (!yn()) {
              ok=0;
              break;
            }
            nl();
          } else {
            ok=0;
            break;
          }
        }
      }
      for (i1=0; i1<i2; i1++)
        s[i1]=' ';
      s[i1]=0;
      npr("%s\r",s);
      if (ok)
        dliscan1(dn);
      nl();
    }
#endif
    if (ok) {
      nl();
      pl(get_string(779));
      outstr(": ");
      inputl(u.description,58);
      nl();
      ss=NULL;
      modify_extended_description(&ss, directories[dn].name,u.filename);
      if (ss) {
        add_extended_description(u.filename,ss);
        u.mask |= mask_extended;
        farfree(ss);
      }
      nl();
      if (xfer) {
        write_inst(INST_LOC_UPLOAD,udir[curdir].subnum,INST_FLAGS_ONLINE);
        ti=timer();
        receive_file(s1,&ok,&u.filetype, u.filename, dn);
        ti=timer()-ti;
        if (ti<0)
          ti += 24.0*3600.0;
        thisuser.extratime += ti;
      }
      if (ok) {
        if (ok==1) {
          f=sh_open1(s1,O_RDONLY | O_BINARY);
          if (f<0) {
            ok=0;
            nl();
            nl();
            pl(get_string(780));
            nl();
            if (u.mask & mask_extended)
              delete_extended_description(u.filename);
          }
          if (ok && syscfg.upload_c[0]) {
            sh_close(f);
            pl(get_string(26));
            if (check_ul_event(dn,&u)) {
              if (u.mask & mask_extended)
                delete_extended_description(u.filename);
              ok=0;
            } else {
              f=sh_open1(s1,O_RDONLY | O_BINARY);
            }
          }
        }
        if (ok) {
          if (ok==1) {
            l=filelength(f);
            u.numbytes=l;
            sh_close(f);
            ++thisuser.uploaded;
#ifdef OPT_FAST_SEARCH
            modify_database(u.filename,1);
#endif
            thisuser.uk += bytes_to_k(l);
            get_file_idz(&u,dn);
#ifdef OPT_PACKSCAN_FREQ
            remotenotify(u.filename,u.description);
#endif
          } else
            u.numbytes=0;
          time(&l);
          u.daten=l;
          f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
          for (i=numf; i>=1; i--) {
            SETREC(f,i);
            sh_read(f,(void *)&u1,sizeof(uploadsrec));
            SETREC(f,i+1);
            sh_write(f,(void *)&u1,sizeof(uploadsrec));
          }
          SETREC(f,1);
          sh_write(f,(void *)&u,sizeof(uploadsrec));
          ++numf;
          SETREC(f,0);
          sh_read(f, &u1, sizeof(uploadsrec));
          u1.numbytes=numf;
          u1.daten=l;
          dir_dates[dn]=l;
          SETREC(f,0);
          sh_write(f,(void *)&u1,sizeof(uploadsrec));
          f=sh_close(f);
          if (ok==1) {
            lock_status();
            ++status.uptoday;
            ++status.filechange[filechange_upload];
            save_status();
            sprintf(s,get_stringx(1,42),u.filename,directories[dn].name);
            sysoplog(s);
            nl();
            nl();
            pl(get_string(781));
            nl();
            outstr(get_string(782));
            npr("%-6.3f\r\n", ratio());
            nl();
            nl();
            if (useron)
              topscreen();
          }
        }
      } else {
        nl();
        nl();
        pl(get_string(783));
        nl();
        if (u.mask & mask_extended)
          delete_extended_description(u.filename);
      }
    }
  }
}


/****************************************************************************/

long date_to_daten(char *datet)
{
  struct time t;
  struct date d;

  if (strlen(datet)!=8)
    return(0);

  memset(&d, 0, sizeof(struct date));
  memset(&t, 0, sizeof(struct time));

  d.da_mon=atoi(datet);
  d.da_day=atoi(datet+3);
  d.da_year=1900+atoi(datet+6);

  return(dostounix(&d, &t));
}


/****************************************************************************/

int try_to_download(char *s, int dn,int title)
{
  int i,ok,sent,abort=0,next=0,i1,f;
  uploadsrec u;
  char s1[81],s2[81];
  userrec ur;

  dliscan1(dn);
  i=recno(s);
  if (i<=0) {
    abort=next=0;
    checka(&abort,&next);
    if (abort)
      return(-1);
    else
      return(0);
  }
  ok=1;
  foundany=1;
  while ((i>0) && (ok) && (!hangup)) {
    tleft(1);
    f=sh_open1(dlfn,O_RDONLY | O_BINARY);
    SETREC(f,i);
    sh_read(f,(void *)&u,sizeof(uploadsrec));
    f=sh_close(f);
    nl();
    if (title) {
      outstr(get_string(784));
      pl(directories[dn].name);
    }
    i1=printfileinfo(&u,dn);
    if (strncmp(u.filename,"WWIV4",5)==0)
      i1=1;
    else {
      if (!ratio_ok()) {
        return(-1);
      }
    }
    if (i1) {
      write_inst(INST_LOC_DOWNLOAD,udir[curdir].subnum,INST_FLAGS_ONLINE);
      sprintf(s1,"%s%s",directories[dn].path,u.filename);
      if (directories[dn].mask & mask_cdrom) {
        sprintf(s2,"%s%s",directories[dn].path,u.filename);
        sprintf(s1,"%s%s",syscfgovr.tempdir,u.filename);
       if (!exist(s1))
          copy_file(s2,s1);
      }
      sent=0;
      abort=0;
      if (i1==-1)
        send_file(s1,&sent,&abort,u.filetype,u.filename,dn, -2L);
      else
        send_file(s1,&sent,&abort,u.filetype,u.filename,dn, u.numbytes);
      if (sent) {
        ++thisuser.downloaded;
        thisuser.dk += (int) (bytes_to_k(u.numbytes));
        ++u.numdloads;
        f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
        SETREC(f,i);
        sh_write(f,(void *)&u,sizeof(uploadsrec));
        f=sh_close(f);
        sprintf(s1,get_stringx(1,43),u.filename);
        sysoplog(s1);
        nl();
        nl();
        outstr(get_string(782)); npr("%-6.3f\r\n", ratio());
        if (syscfg.sysconfig & sysconfig_log_dl) {
          read_user(u.ownerusr, &ur);
          if (!(ur.inact & inact_deleted)) {
            if (date_to_daten(ur.firston) < u.daten) {
              sprintf(s1,"%s %s '%s' %s %s",
                nam(&thisuser,usernum), get_string(785), u.filename, get_string(786),date());
              ssm(u.ownerusr,0,s1);
            }
          }
        }
        if (useron)
          topscreen();
      }
    } else {
      nl();
      nl();
      pl(get_string(787));
      nl();
    }
    if (abort)
      ok=0;
    else
      i=nrecno(s,i);
  }
  if (abort)
    return(-1);
  else
    return(1);
}
/****************************************************************************/


void download(void)
{
  char s[81];
  int dn,count,color;

  if (numbatchdl!=0) {
    nl();
    outstr(get_string(1324));
    if (ny()) {
      batchdl(1);
      return;
    }
  }
  nl();
  pl(get_string(788));
  nl();
  prt(2,get_string(44));
  input(s,12);
  if (s[0]==0)
    return;
  if (strchr(s,'.')==NULL)
    strcat(s,".*");
  align(s);
  if (try_to_download(s,udir[curdir].subnum,0)==0) {
    nl();
    pl(get_string(789));
    nl();
    foundany=dn=0;
    count=0;
    color=3;
    if (!x_only)
      outstr("\r2Searching ");
    while ((dn<num_dirs) && (udir[dn].subnum!=-1)) {
      count++;
      if (!x_only) {
        npr("%d.",color);
        if (count==DOTS) {
          outstr("\r");
          outstr(get_string(1184));
          color++;
          count=0;
          if (color==4)
            color++;
          if (color==10)
            color=0;
        }
      }
      if (try_to_download(s,udir[dn].subnum,1)<0)
        break;
      else
        dn++;
    }
    if (!foundany) {
      pl(get_string(89));
      nl();
    }
  }
}


void setldate(void)
{
  struct date d;
  struct time t;
  char s[81];
  int m,dd,y;

  nl();
  nl();
  unixtodos(nscandate,&d,&t);
  nl();
  outstr(get_string(790));
  npr("%02d/%02d/%02d\r\n",d.da_mon,d.da_day,(d.da_year-1900));
  nl();
  pl(get_string(791));
  pl(get_string(792));
  outstr(":");
  input(s,8);
  m=atoi(s);
  dd=atoi(&(s[3]));
  y=atoi(&(s[6]))+1900;
  if ((strlen(s)==8) && (m>0) && (m<=12) && (dd>0) && (dd<32) && (y>=1980)) {
    t.ti_min=0;
    t.ti_hour=0;
    t.ti_hund=0;
    t.ti_sec=0;
    d.da_year=y;
    d.da_day=dd;
    d.da_mon=m;
    nl();
    outstr(get_string(790));
    npr("%02d/%02d/%02d\r\n",m,dd,(y-1900));
    nl();
    nscandate=dostounix(&d,&t);
  }
}


void finddescription(void)
{
  uploadsrec u;
  int i,i1,i2,abort,ocd,pts,next=0,f,count,color,ac=0;
  char s[81],s1[81];

  nl();
  if ((uconfdir[1].confnum!=-1) && (okconf(&thisuser))) {
    if (!x_only) {
      prt(5,get_string(1379));
      ac=yn();
    } else
      ac=1;
    if (ac)
      tmp_disable_conf(1);
  }
  nl();
  pl(get_string(793));
  nl();
  pl(get_string(794));
  outstr(":");
  input(s1,58);
  if (s1[0]==0) {
    tmp_disable_conf(0);
    return;
  }

  ocd=curdir;
  abort=0;
  num_listed=0;
  count=0;
  color=3;
  if (!x_only) {
    outstr("\r");
    outstr(get_string(1184));
  }
  lines_listed=0;
  for (i=0; (i<num_dirs) && (!abort) && (!hangup) && (tagging!=0)
    && (udir[i].subnum!=-1); i++) {
    i1=udir[i].subnum;
    pts=0;
    titled=1;
    if (qsc_n[i1/32]&(1L<<(i1%32)))
      pts=1;
    pts=1;
    /* remove pts=1 to search only marked directories */
    if ((pts) && (!abort) && (tagging!=0)) {
      if (!x_only) {
        count++;
        npr("%d.",color);
        if (count==DOTS) {
          outstr("\r");
          outstr(get_string(1184));
          color++;
          count=0;
          if (color==4)
            color++;
          if (color==10)
            color=0;
        }
      }
      curdir=i;
      dliscan();
      f=sh_open1(dlfn,O_RDONLY | O_BINARY);
      for (i1=1; (i1<=numf) && (!abort) && (!hangup) && (tagging !=0); i1++) {
        SETREC(f,i1);
        sh_read(f,(void *)&u,sizeof(uploadsrec));
        strcpy(s,u.description);
        for (i2=0; i2<strlen(s); i2++)
          s[i2]=upcase(s[i2]);
        if (strstr(s,s1)!=NULL) {
          f=sh_close(f);
          printinfo(&u, &abort);
          f=sh_open1(dlfn,O_RDONLY | O_BINARY);
        } else if (!empty())
          checka(&abort,&next);
      }
      f=sh_close(f);
    }
  }
  if (ac)
    tmp_disable_conf(0);
  curdir=ocd;
  endlist(1);
}


void arc_l(void)
{
  char s[81];
  int i,abort,next,i1,f;
  uploadsrec u;

  nl();
  prt(2,get_string(795));
  input(s,12);
  if (strchr(s,'.')==NULL)
    strcat(s,".*");
  if (!okfn(s))
    s[0]=0;
  align(s);
  dliscan();
  abort=0;
  next=0;
  i=recno(s);
  do {
    if (i>0) {
      f=sh_open1(dlfn,O_RDONLY | O_BINARY);
      SETREC(f,i);
      sh_read(f,(void *)&u,sizeof(uploadsrec));
      f=sh_close(f);
      i1=list_arc_out(stripfn(u.filename),directories[udir[curdir].subnum].path);
      if (i1)
        abort=1;
      checka(&abort,&next);
      i=nrecno(s,i);
    }
  } while ((i>0) && (!hangup) && (!abort));
}


/****************************************************************************/

void get_file_idz(uploadsrec *u, int dn)
{
  char *b,*ss,cmd[128],s[81];
  int f,i,ok=0;

#ifdef OPT_IDZ_READ_CD
  if (directories[dn].mask & mask_cdrom)
    return;
#endif
  ss=strchr(stripfn(u->filename),'.');
  if (ss==NULL)
    return;
  ++ss;
  for (i=0; i<4; i++)
    if (!ok)
      ok=(stricmp(ss,syscfg.arcs[i].extension)==0);
  if (!ok)
    return;

  sprintf(s,"%sFILE_ID.DIZ",syscfgovr.tempdir);
  unlink(s);
  sprintf(s,"%sDESC.SDI",syscfgovr.tempdir);
  unlink(s);

  cd_to(directories[dn].path);
  get_dir(s,1);
  strcat(s,stripfn(u->filename));
  cd_to(cdir);
  get_arc_cmd(cmd,s,1,"FILE_ID.DIZ DESC.SDI");
  cd_to(syscfgovr.tempdir);
  run_external_ul(cmd);
  cd_to(cdir);
  sprintf(s,"%sFILE_ID.DIZ",syscfgovr.tempdir);
  if (!exist(s))
    sprintf(s,"%sDESC.SDI",syscfgovr.tempdir);
  if (exist(s)) {
    nl();
    ansic(9); npr(get_string(995));
    ansic(2); outstr(stripfn(s));
    ansic(9); npr(get_string(996));
    ss=read_extended_description(u->filename);
    if (ss) {
      farfree(ss);
      delete_extended_description(u->filename);
    }
    if ((b=malloca((long)MAX_LINES*256+1))==NULL)
      return;
    f=sh_open1(s,O_RDONLY | O_BINARY);
    if (filelength(f)<(MAX_LINES*256)) {
      sh_read(f,b,(int) filelength(f));
      b[filelength(f)]=0;
    } else {
      sh_read(f,b,(int)MAX_LINES*256);
      b[(int)MAX_LINES*256]=0;
    }
    sh_close(f);
#ifdef OPT_IDZ_AS_DESCRIPTION
    ss=strtok(b,"\n");
    sprintf(u->description,"   %.56s",ss);
    ss=strtok(NULL,"");
#else
    ss=b;
#endif
    for (i=strlen(ss)-1; i>0; i--) {
      if ((ss[i]==26) || (ss[i]==12))
        ss[i]=32;
    }
    add_extended_description(u->filename,ss);
    u->mask |= mask_extended;
    farfree(b);
    pl(get_string(997));
  }
  sprintf(s,"%sFILE_ID.DIZ",syscfgovr.tempdir);
  unlink(s);
  sprintf(s,"%sDESC.SDI",syscfgovr.tempdir);
  unlink(s);
}


void read_idz(void)
{
  char s[81],s1[161];
  int i,f;
  uploadsrec u;
  unsigned long l;

  tmp_disable_pause(1);
  set_protect(0);
  dliscan();
  file_mask(s);
  sprintf(s1,"9%s2%s #%s...",get_string(998),
     directories[udir[curdir].subnum].name,
     udir[curdir].keys);
  pl(s1);
  f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
  for (i=1; (i<=numf) && (!hangup); i++) {
    SETREC(f,i);
    sh_read(f,(void *)&u,sizeof(uploadsrec));
    if (compare(s,u.filename))
      get_file_idz(&u,udir[curdir].subnum);
    SETREC(f,i);
    sh_write(f,(void *)&u,sizeof(uploadsrec));
  }
  f=sh_close(f);
  topscreen();
  tmp_disable_pause(0);
}


void tag_it(void)
{
  int i,i1,i2,i3,i4,bad,fp;
  char s[161],s1[161],s2[81],s3[81];
  double t;
  long fs;

  if (numbatch>=MAX_BATCH) {
    prt(6,get_string(1325));
    getkey();
    return;
  }
  outstr(get_string(1326));
  npr("%d",tagptr);
  outstr(get_string(1327));
  mpl(30);
  input(s3,30);
  if (s3[0]=='*') {
    s3[0]=0;
    for(i2=0;i2<tagptr && i2<78;i2++) {
      sprintf(s2,"%d ",i2+1);
      strcat(s3,s2);
    }
    nl();
    outstr(get_string(1328));
    pl(s3);
  }
  for(i2=0;i2<strlen(s3);i2++) {
    sprintf(s1,"%s",s3+i2);
    i4=0;
    bad=0;
    for(i3=0;i3<strlen(s1);i3++) {
      if ((s1[i3]==' ') || (s1[i3]==',') || (s1[i3]==';')) {
        s1[i3]=0;
        i4=1;
      } else {
        if (i4==0)
          i2++;
      }
    }
    i=atoi(s1);
    if (i==0)
      break;
    i--;
    if ((s1[0]) && (i>=0) && (i<tagptr)) {
      if (check_batch_queue(filelist[i].u.filename)) {
        ansic(6);
        outstr(filelist[i].u.filename);
        pl(get_string(1329));
        bad=1;
      }
      if (numbatch>=MAX_BATCH) {
        ansic(6);
        outstr(get_string(1330));
        npr("%d",MAX_BATCH);
        pl(get_string(1331));
        bad=1;
      }
      if ((syscfg.req_ratio>0.0001)
        && (ratio()<syscfg.req_ratio)
        && (!thisuser.exempt & exempt_ratio)
        && (bad==0)) {
        ansic(2);
        outstr(get_string(730));
        sprintf(s," %-5.3f.  ",ratio());
        outstr(s);
        outstr(get_string(731));
        sprintf(s," %-5.3f ",syscfg.req_ratio);
        outstr(s);
        outstr(get_string(732));
        nl();
        bad=1;
      }
      if (bad==0) {
        sprintf(s,"%s%s",directories[filelist[i].directory].path,
          stripfn(filelist[i].u.filename));
        if (filelist[i].dir_mask & mask_cdrom) {
          sprintf(s2,"%s%s",
            directories[filelist[i].directory].path,
            stripfn(filelist[i].u.filename));
          sprintf(s,"%s%s",
            syscfgovr.tempdir,stripfn(filelist[i].u.filename));
         if (!exist(s))
           copy_file(s2,s);
        }
        fp=sh_open1(s,O_RDONLY | O_BINARY);
        if (fp<0) {
          ansic(6);
          outstr(get_string(1332));
          outstr(stripfn(filelist[i].u.filename));
          pl(get_string(1333));
          bad=1;
        } else {
          fs=filelength(fp);
          fp=sh_close(fp);
        }
      }
      if (bad==0) {
        t=(12.656) / ((double) (modem_speed)) * ((double)(fs));
        if (nsl()<=(batchtime + t)) {
          ansic(6);
          outstr(get_string(1334));
          outstr(filelist[i].u.filename);
          pl(".");
          bad=1;
        }
      }
      if (bad==0) {
        batchtime += t;
        strcpy(batch[numbatch].filename,filelist[i].u.filename);
        batch[numbatch].dir=filelist[i].directory;
        batch[numbatch].time=t;
        batch[numbatch].sending=1;
        batch[numbatch].len=fs;
        numbatch++;
        ++numbatchdl;
        ansic(1);
        outstr(filelist[i].u.filename);
        pl(get_string(1335));
      }
    } else {
      ansic(6);
      outstr(get_string(1336));
      npr("%d.",i+1);
      nl();
    }
    lines_listed=0;
  }
}


void tag_files(void)
{
  int i, i1, done=0, abort, had, bad, oh, fc, next, ohl;
  char s[161],s1[161],s2[81],s3[81],ch;
  double d;

  fc=thisuser.sysstatus & sysstatus_extra_color;
  if ((lines_listed==0) || (tagging==0))
    return;
  abort=0;
  if ((x_only) || (tagging==2)) {
    tagptr=0;
    return;
  }
  if (thisuser.sysstatus & sysstatus_no_tag) {
    if (thisuser.sysstatus & sysstatus_pause_on_page)
      pausescr();
    ansic(fc ? FRAME : 0);
    if (okansi())
      npr("\r%s\r\n",get_string(1337));
    else
      npr("\r%s\r\n",get_string(1338));
    tagptr=0;
    return;
  }
  lines_listed=0;
  ansic(fc ? FRAME : 0);
  if (okansi())
    npr("\r%s\r\n",get_string(1339));
  else
    npr("\r%s\r\n",get_string(1340));

  oh=helpl;
  helpl=43;
  done=0;
  while ((!done) && (!hangup)) {
    ohl=helpl;
    helpl=43;
    ch=fancy_prompt(get_string(1341),"CDEMNQRTV?");
    helpl=ohl;
    switch (ch) {
      case '?':
        i=tagging;
        tagging=0;
        printmenu(17);
        pausescr();
        tagging=i;
        relist();
      break;
      case 'C':
      case ' ':
      case '\r':
        lines_listed=0;
        tagptr=0;
        titled=2;
        outchr(12);
        done=1;
      break;
      case 'D':
        batchdl(1);
        tagging=0;
        if (!had) {
          nl();
          pausescr();
          outchr(12);
        }
        done=1;
      break;
      case 'E':
        lines_listed=0;
        i1=tagging;
        tagging=0;
        prt(2,get_string(1342));
        npr("2%d)? ",tagptr);
        mpl(2);
        input(s,2);
        i=atoi(s)-1;
        if (modem_speed)
          d=((double) (((filelist[i].u.numbytes)+127)/128)) *
            (1620.0) / ((double) (modem_speed));
        else
          d=0.0;
        if ((s[0]) && (i>=0) && (i<tagptr)) {
          nl();
          npr("%s%s, %s\r\n",
            get_string(1343),
            udir[filelist[i].directory].keys,
            directories[filelist[i].directory].name);
          ansic(1);
          outstr(get_string(746));
          ansic(2);
          pl(filelist[i].u.filename);
          ansic(1);
          outstr(get_string(747));
          ansic(2);
          pl(filelist[i].u.description);
          if (filelist[i].u.mask & mask_extended) {
            sprintf(edlfn,"%s%s.EXT",syscfg.datadir,
              directories[filelist[i].directory].filename);
            npr(get_string(1344));
            print_extended(filelist[i].u.filename,&abort,MAX_LINES,2);
          }
          ansic(1);
          outstr(get_string(748));
          ansic(2);
          npr("%dk\r\n", bytes_to_k(filelist[i].u.numbytes));
          ansic(1);
          outstr(get_string(749));
          ansic(2);
          pl(ctim(d));
          ansic(1);
          outstr(get_string(750));
          ansic(2);
          pl(filelist[i].u.date);
          ansic(1);
          outstr(get_string(751));
          ansic(2);
          pl(filelist[i].u.upby);
          ansic(1);
          outstr(get_string(752));
          ansic(2);
          pln(filelist[i].u.numdloads);
          if (directories[filelist[i].directory].mask & mask_cdrom) {
            nl();
            pl(get_string(1345));
          } else {
            sprintf(s,"%s%s",directories[filelist[i].directory].path,
              filelist[i].u.filename);
            if (!exist(s)) {
              nl();
              pl(get_string(754));
            }
          }
          nl();
          pausescr();
          tagging=i1;
          relist();
        }
      break;
      case 'N':
        tagging=2;
        done=1;
      break;
      case 'M':
        if (dcs()) {
          i=tagging;
          tagging=0;
            move_file_t();
          tagging=i;
          if (num_listed==0) {
            done=1;
            return;
          }
          relist();
        }
      break;
      case 'Q':
        tagging=0;
        titled=0;
        tagptr=0;
        lines_listed=0;
        done=1;
        return;
      case 'R':
        relist();
      break;
      case 'T':
        tag_it();
      break;
      case 'V':
        prt(2,get_string(1342));
        npr("2%d)? ",tagptr);
        mpl(2);
        input(s,2);
        i=atoi(s)-1;
        if ((s[0]) && (i>=0) && (i<tagptr)) {
          sprintf(s1,"%s%s",directories[filelist[i].directory].path,
            stripfn(filelist[i].u.filename));
          if (directories[filelist[i].directory].mask & mask_cdrom) {
            sprintf(s2,"%s%s",directories[filelist[i].directory].path,
              stripfn(filelist[i].u.filename));
            sprintf(s1,"%s%s",syscfgovr.tempdir,
               stripfn(filelist[i].u.filename));
            if (!exist(s1))
              copy_file(s2,s1);
          }
          if (!exist(s1)) {
            prt(6,get_string(1346));
            nl();
            pausescr();
            break;
          }
          get_arc_cmd(s,s1,0,"");
          if (!okfn(stripfn(filelist[i].u.filename)))
            s[0]=0;
          if (s[0]!=0) {
            nl();
            tagging=0;
            do_external(s,1);
            nl();
            pausescr();
            tagging=1;
            topscreen();
            outchr(12);
            relist();
          } else {
            prt(6,get_string(1347));
            nl();
            pausescr();
            break;
          }
        }
      break;
      default:
        outchr(12);
        done=1;
      break;
    }
  }
  helpl=oh;
  tagptr=0;
}


void remlist(char *fn)
{
  int i,i2;
  char s[81],s1[81];

  sprintf(s,"%s",fn);
  align(s);

  for (i=0;i<tagptr;i++) {
    strcpy(s1,filelist[i].u.filename);
    align(s1);
    if (strcmp(s,s1)==0) {
      for (i2=i;i2<tagptr-1;i2++)
        filelist[i2]=filelist[i2+1];
      tagptr--;
      num_listed--;
    }
  }
}


char fancy_prompt(char *prompt,char *accept)
{
  int i,i1;
  char s1[81],s2[81],s3[81];
  char ch;

  tleft(1);
  sprintf(s1,"\r2%s (1%s2)? ",prompt,accept);
  sprintf(s2,"%s (%s)? ",prompt,accept);
  i1=strlen(s2);
  sprintf(s3,"%s%s",accept," \r");
  tleft(1);
  if (okansi()) {
    outstr(s1);
    ch=onek1(s3);
    npr("\x1b[%dD",i1);
    for (i=0; i<i1; i++)
      outchr(' ');
    npr("\x1b[%dD",i1);
  } else {
    outstr(s2);
    ch=onek(s3);
    for (i = 0; i<i1; i++)
      backspace();
  }
  return(ch);
}


void endlist(int mode)
{
  char s[81];
  int fc;

  fc=thisuser.sysstatus & sysstatus_extra_color;
  if (tagging!=0) {
    if (num_listed)  {
      if ((tagging==1) && (!(thisuser.sysstatus&sysstatus_no_tag))) {
        tag_files();
        return;
      } else {
        ansic(fc ? FRAME : 0);
        if ((titled!=2) && (tagging==1)
          && !(thisuser.sysstatus & sysstatus_no_tag)) {
          if (okansi())
            npr("\r%s\r\n",get_string(1348));
          else
            npr("\r%s\r\n",get_string(1349));
        } else {
          if (okansi())
            npr("\r%s\r\n",get_string(1350));
          else
            npr("\r%s\r\n",get_string(1351));
        }
      }
      switch(mode) {
        case 1:
          sprintf(s,"\r%s %ld",get_string(744), num_listed);
        break;
        case 2:
          sprintf(s,"\r%s %ld",get_string(744), num_listed);
        break;
      }
      pl(s);
    } else {
      switch(mode) {
        case 1:
          outstr("\r");
          pl(get_string(1352));
          nl();
          break;
        case 2:
          outstr("\r");
          pl(get_string(1353));
          nl();
          break;
      }
    }
  }
}
