/*****************************************************************************

				WWIV Version 4
                    Copyright (C) 1988-1993 by Wayne Bell

Distribution of the source code for WWIV, in any form, modified or unmodified,
without PRIOR, WRITTEN APPROVAL by the author, is expressly prohibited.
Distribution of compiled versions of WWIV is limited to copies compiled BY
THE AUTHOR.  Distribution of any copies of WWIV not compiled by the author
is expressly prohibited.


*****************************************************************************/



#include "vars.h"

#pragma hdrstop

#include <time.h>
#include <dir.h>



#define SETREC(f,i)  sh_lseek(f,((long) (i))*((long)sizeof(uploadsrec)),SEEK_SET);

/* color for frame */
#define FRAME 7

void move_file(void)
{
  char sx[81],s1[81],s2[81],ch,*ss;
  int i,i1,ok,d1,d2,done,cp,f,temp;
  uploadsrec u,u1;

  ok=0;
  nl();
  nl();
  prt(2,get_string(821));
  input(sx,12);
  if (strchr(sx,'.')==NULL)
    strcat(sx,".*");
  align(sx);
  dliscan();
  i=recno(sx);
  if (i<0) {
    nl();
    pl(get_string(89));
    return;
  }
  done=0;

  tmp_disable_conf(1);

  while ((!hangup) && (i>0) && (!done)) {
    cp=i;
    f=sh_open1(dlfn,O_RDONLY | O_BINARY);
    SETREC(f,i);
    sh_read(f,(void *)&u,sizeof(uploadsrec));
    f=sh_close(f);
    nl();
    printfileinfo(&u,udir[curdir].subnum);
    nl();
    prt(5,get_string(822));
    ch=ynq();
    if (ch=='Q')
      done=1;
    else if (ch=='Y') {
      sprintf(s1,"%s%s",directories[udir[curdir].subnum].path,u.filename);
      do {
        nl();
        nl();
        prt(2,get_string(823));
        ss=mmkey(1);
        if (ss[0]=='?') {
          dirlist();
          dliscan();
        }
      } while ((!hangup) && (ss[0]=='?'));
      d1=-1;
      if (ss[0])
        for (i1=0; (i1<num_dirs) && (udir[i1].subnum!=-1); i1++)
          if (strcmp(udir[i1].keys,ss)==0)
            d1=i1;
      if (d1!=-1) {
        ok=1;
        d1=udir[d1].subnum;
        dliscan1(d1);
        if (recno(u.filename)>0) {
          ok=0;
          nl();
          pl(get_string(824));
        }
        if (numf>=directories[d1].maxfiles) {
          ok=0;
          nl();
          pl(get_string(825));
        }
        if (freek1(directories[d1].path)<((double)(u.numbytes/1024L)+3)) {
          ok=0;
          nl();
          pl(get_string(826));
        }
        dliscan();
      } else
        ok=0;
    } else
      ok=0;
    if (ok && !done) {
      prt(5,get_string(934));
      if (yn()) {
        time((long *)&u.daten);
      }

      --cp;
      f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
      for (i1=i; i1<numf; i1++) {
        SETREC(f,i1+1);
        sh_read(f,(void *)&u1,sizeof(uploadsrec));
        SETREC(f,i1);
        sh_write(f,(void *)&u1,sizeof(uploadsrec));
      }
      --numf;
      SETREC(f,0);
      sh_read(f, &u1, sizeof(uploadsrec));
      u1.numbytes=numf;
      SETREC(f,0);
      sh_write(f,(void *)&u1,sizeof(uploadsrec));
      f=sh_close(f);
      ss=read_extended_description(u.filename);
      if (ss)
        delete_extended_description(u.filename);

      sprintf(s2,"%s%s",directories[d1].path,u.filename);
      dliscan1(d1);
      f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
      for (i=numf; i>=1; i--) {
        SETREC(f,i);
        sh_read(f,(void *)&u1,sizeof(uploadsrec));
        SETREC(f,i+1);
        sh_write(f,(void *)&u1,sizeof(uploadsrec));
      }
      SETREC(f,1);
      sh_write(f,(void *)&u,sizeof(uploadsrec));
      ++numf;
      SETREC(f,0);
      sh_read(f, &u1, sizeof(uploadsrec));
      u1.numbytes=numf;
      if (u.daten>u1.daten) {
        u1.daten = u.daten;
        dir_dates[d1]=u.daten;
      }
      SETREC(f,0);
      sh_write(f,(void *)&u1,sizeof(uploadsrec));
      f=sh_close(f);
      if (ss) {
        add_extended_description(u.filename,ss);
        farfree(ss);
      }

      if ((strcmp(s1,s2)!=0) && (exist(s1))) {
        d2=0;
        if ((s1[1]!=':') && (s2[1]!=':'))
          d2=1;
        if ((s1[1]==':') && (s2[1]==':') && (s1[0]==s2[0]))
          d2=1;
        if (d2) {
          rename(s1,s2);
          unlink(s1);
        } else {
          copy_file(s1,s2);
          unlink(s1);
        }
      }
      nl();
      pl(get_string(827));
    }
    dliscan();
    i=nrecno(sx,cp);
  }

  tmp_disable_conf(0);
}

int comparedl(uploadsrec *x, uploadsrec *y, int type)
{
  switch(type) {
    case 0:
      return(strcmp(x->filename,y->filename));
    case 1:
      if (x->daten < y->daten)
        return(-1);
      else
        if (x->daten > y->daten)
          return(1);
        else
          return(0);
    case 2:
      if (x->daten < y->daten)
        return(1);
      else
        if (x->daten > y->daten)
          return(-1);
        else
          return(0);
  }
  return(0);
}


void quicksort(int l,int r,int type)
{
  register int i,j,f;
  uploadsrec a,a2,x;

  i=l; j=r;
  f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
  SETREC(f,((l+r)/2));
  sh_read(f, (void *)&x,sizeof(uploadsrec));
  do {
    SETREC(f,i);
    sh_read(f, (void *)&a,sizeof(uploadsrec));
    while (comparedl(&a,&x,type)<0) {
      SETREC(f,++i);
      sh_read(f, (void *)&a,sizeof(uploadsrec));
    }
    SETREC(f,j);
    sh_read(f, (void *)&a2,sizeof(uploadsrec));
    while (comparedl(&a2,&x,type)>0) {
      SETREC(f,--j);
      sh_read(f, (void *)&a2,sizeof(uploadsrec));
    }
    if (i<=j) {
      if (i!=j) {
        SETREC(f,i);
        sh_write(f,(void *)&a2,sizeof(uploadsrec));
        SETREC(f,j);
        sh_write(f,(void *)&a,sizeof(uploadsrec));
      }
      i++;
      j--;
    }
  } while (i<j);
  f=sh_close(f);
  if (l<j)
    quicksort(l,j,type);
  if (i<r)
    quicksort(i,r,type);
}


void sortdir(int dn, int type)
{
  dliscan1(dn);
  if (numf>1)
    quicksort(1,numf,type);
}


void sort_all(int type)
{
  int i;

  tmp_disable_conf(1);
  for (i=0; (i<num_dirs) && (udir[i].subnum!=-1) && (!kbhitb()); i++) {
    nl();
    ansic(1);
    outstr(get_string(828));
    pl(directories[udir[i].subnum].name);
    sortdir(i,type);
  }
  tmp_disable_conf(0);
}


void rename_file(void)
{
  char s[81],s1[81],s2[81],*ss,s3[81],ch;
  int i,cp,f;
  uploadsrec u;

  nl();
  nl();
  prt(2,get_string(829));
  input(s,12);
  if (s[0]==0)
    return;
  if (strchr(s,'.')==NULL)
    strcat(s,".*");
  align(s);
  dliscan();
  nl();
  strcpy(s3,s);
  i=recno(s);
  while (i>0) {
    f=sh_open1(dlfn,O_RDONLY | O_BINARY);
    cp=i;
    SETREC(f,i);
    sh_read(f,(void *)&u,sizeof(uploadsrec));
    f=sh_close(f);
    nl();
    printfileinfo(&u,udir[curdir].subnum);
    nl();
    prt(5,get_string(830));
    ch=ynq();
    if (ch=='Q')
      break;
    else if (ch=='N') {
      i=nrecno(s3,cp);
      continue;
    }
    nl();
    prt(2,get_string(72));
    input(s,12);
    if (!okfn(s))
      s[0]=0;
    if (s[0]) {
      align(s);
      if (strcmp(s,get_string(1310))) {
        strcpy(s1,directories[udir[curdir].subnum].path);
        strcpy(s2,s1);
        strcat(s1,s);
        if (exist(s1))
          pl(get_string(831));
        else {
          strcat(s2,u.filename);
          rename(s2,s1);
          if (exist(s1)) {
            ss=read_extended_description(u.filename);
            if (ss) {
              delete_extended_description(u.filename);
              add_extended_description(s,ss);
              farfree(ss);
            }
            strcpy(u.filename,s);
          } else
            pl(get_string(832));
        }
      }
    }
    nl();
    pl(get_string(833));
    prt(2,": ");
    inputl(s,58);
    if (s[0]) {
      strcpy(u.description,s);
    }
    ss=read_extended_description(u.filename);
    nl();
    nl();
    prt(5,get_string(834));
    if (yn()) {
      nl();
      if (ss) {
        prt(5,get_string(835));
        if (yn()) {
          farfree(ss);
          delete_extended_description(u.filename);
          u.mask &= ~mask_extended;
        } else {
          u.mask |= mask_extended;
          modify_extended_description(&ss,
            directories[udir[curdir].subnum].name,u.filename);
          if (ss) {
            delete_extended_description(u.filename);
            add_extended_description(u.filename,ss);
            farfree(ss);
          }
        }
      } else {
        modify_extended_description(&ss,
            directories[udir[curdir].subnum].name,u.filename);
        if (ss) {
          add_extended_description(u.filename,ss);
          farfree(ss);
          u.mask |= mask_extended;
        } else
          u.mask &= ~mask_extended;
      }
    } else
      if (ss) {
        farfree(ss);
        u.mask |= mask_extended;
      } else
        u.mask &= ~mask_extended;
    f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
    SETREC(f,i);
    sh_write(f,(void *)&u,sizeof(uploadsrec));
    f=sh_close(f);
    i=nrecno(s3,cp);
  }
}


int upload_file(char *fn, int dn, char *desc)
{
  directoryrec d;
  uploadsrec u,u1;
  int i,f;
  char s[81],ff[81];
  long l;

  d=directories[dn];
  strcpy(s,fn);
  align(s);
  strcpy(u.filename,s);
  u.ownerusr=usernum;
  u.ownersys=0;
  u.numdloads=0;
  u.filetype=0;
  u.mask=0;
  if ((!(d.mask & mask_cdrom)) && (check_ul_event(dn,&u))) {
    outstr(fn);
    pl(get_string(836));
  } else {
    sprintf(ff,"%s%s",d.path,s);
    f=sh_open1(ff,O_RDONLY | O_BINARY);
    if (f<=0) {
      if (desc && (*desc)) {
        outstr(get_string(837));
        outstr(fn);
        outstr(": ");
        pl(desc);
      } else {
        outstr(fn);
        pl(get_string(838));
      }
      return(1);
    }
    l=filelength(f);
    u.numbytes=l;
    sh_close(f);
    strcpy(u.upby, nam(&thisuser,usernum));
    strcpy(u.date,date());
    if (d.mask & mask_PD)
      d.mask=mask_PD;
    npr("%s: %4ldk :",u.filename,bytes_to_k(u.numbytes));
    if ((desc) && (*desc)) {
      strncpy(u.description,desc,58);
      u.description[58]=0;
      pl(u.description);
    } else
      inputl(u.description,58);
    if (u.description[0]==0)
      return(0);
    get_file_idz(&u,dn);
    ++thisuser.uploaded;
#ifdef OPT_FAST_SEARCH
    if (!(d.mask & mask_cdrom))
      modify_database(u.filename,1);
#endif
    thisuser.uk += bytes_to_k(l);
    time(&l);
    u.daten=l;
#ifdef OPT_PACKSCAN_FREQ
    if (!(d.mask & mask_cdrom))
      remotenotify(u.filename,u.description);
#endif
    f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
    for (i=numf; i>=1; i--) {
      SETREC(f,i);
      sh_read(f,(void *)&u1,sizeof(uploadsrec));
      SETREC(f,i+1);
      sh_write(f,(void *)&u1,sizeof(uploadsrec));
    }
    SETREC(f,1);
    sh_write(f,(void *)&u,sizeof(uploadsrec));
    ++numf;
    SETREC(f,0);
    sh_read(f, &u1, sizeof(uploadsrec));
    u1.numbytes=numf;
    u1.daten=l;
    dir_dates[dn]=l;
    SETREC(f,0);
    sh_write(f,(void *)&u1,sizeof(uploadsrec));
    f=sh_close(f);
    lock_status();
    ++status.uptoday;
    ++status.filechange[filechange_upload];
    save_status();
    sprintf(s,get_stringx(1,42),u.filename,d.name);
    sysoplog(s);
    topscreen();
  }
  return(1);
}


int maybe_upload(char *fn, int dn, char *desc)
{
  char s[81];
  int i,i1=0,ok=1,ocd,f;
  uploadsrec u;

  strcpy(s,fn);
  align(s);
  i=recno(s);

  if (i==-1) {
    if (!upload_file(s,udir[dn].subnum,desc))
      ok=0;
  } else {
    f=sh_open1(dlfn,O_RDONLY | O_BINARY);
    SETREC(f,i);
    sh_read(f,(void *)&u, sizeof(uploadsrec));
    f=sh_close(f);
    ocd=curdir;
    curdir=dn;
    printinfo(&u,&i1);
    curdir=ocd;
    if (i1)
      ok=0;
  }
  return(ok);
}

void upload_files(char *fn, int dn, int type)
/* This assumes the file holds listings of files, one per line, to be
 * uploaded.  The first word (delimited by space/tab) must be the filename.
 * after the filename are optional tab/space separated words (such as file
 * size or date/time).  After the optional words is the description, which
 * is from that position to the end of the line.  the "type" parameter gives
 * the number of optional words between the filename and description.
 * the optional words (size, date/time) are ignored completely.
 */
{
  char s[255],*fn1,*desc,last_fn[81],*ext=NULL;
  FILE *f;
  int ok=1,abort=0,next=0,ok1,i,f1;
  uploadsrec u;

  last_fn[0]=0;
  dliscan1(udir[dn].subnum);

  f=fsh_open(fn,"r");
  if (!f) {
    sprintf(s,"%s%s",directories[udir[dn].subnum].path,fn);
    f=fsh_open(s,"r");
  }
  if (!f) {
    outstr(fn);
    pl(": not found.");
  } else {
    while (ok && fgets(s,250,f)) {
      if (s[0]<32)
        continue;
      else if (s[0]==32) {
        if (last_fn[0]) {
          if (!ext) {
            ext=malloca(4096L);
            *ext=0;
          }
          for (desc=s; (*desc==' ') || (*desc=='\t'); desc++)
            ;
          if (*desc=='|') {
            do {
              desc++;
            } while ((*desc==' ') || (*desc=='\t'));
            fn1=strchr(desc,'\n');
            if (fn1)
              *fn1=0;
            strcat(ext, desc);
            strcat(ext,"\r\n");
          }
        }
      } else {
        ok1=0;
        fn1=strtok(s," \t\n");
        if (fn1) {
          ok1=1;
          for (i=0; ok1 && (i<type); i++)
            if (strtok(NULL," \t\n")==NULL)
              ok1=0;
          if (ok1) {
            desc=strtok(NULL,"\n");
            if (!desc)
              ok1=0;
          }
        }
        if (ok1) {
          if (last_fn[0] && ext && *ext) {
            f1=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
            SETREC(f1,1);
            sh_read(f1,(void *)&u, sizeof(uploadsrec));
            if (strcmp(last_fn,u.filename)==0) {
#ifdef OPT_FAST_SEARCH
              modify_database(u.filename,1);
#endif
              add_extended_description(last_fn, ext);
              u.mask |= mask_extended;
              SETREC(f1,1);
              sh_write(f1, (void *)&u, sizeof(uploadsrec));
            }
            f1=sh_close(f1);
            *ext=0;
          }
          while ((*desc==' ') || (*desc=='\t'))
            ++desc;
          ok=maybe_upload(fn1,dn,desc);
          checka(&abort,&next);
          if (abort)
            ok=0;
          if (ok) {
            strcpy(last_fn, fn1);
            align(last_fn);
            if (ext)
              *ext=0;
          }
        }
      }
    }
    fsh_close(f);
    if (ok && last_fn[0] && ext && *ext) {
      f1=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
      SETREC(f1,1);
      sh_read(f1,(void *)&u, sizeof(uploadsrec));
      if (strcmp(last_fn,u.filename)==0) {
#ifdef OPT_FAST_SEARCH
        modify_database(u.filename,1);
#endif
        add_extended_description(last_fn, ext);
        u.mask |= mask_extended;
        SETREC(f1,1);
        sh_write(f1, (void *)&u, sizeof(uploadsrec));
      }
      f1=sh_close(f1);
    }
  }

  if (ext)
    farfree(ext);
}

int uploadall(int dn)
{
  int i1,f1,maxf,ok,abort=0,next;
  char s[81],s1[81];
  struct ffblk ff;

  dliscan1(udir[dn].subnum);
  nl();
  nl();
  strcpy(s,"*.*");
  strcpy(s1,(directories[udir[dn].subnum].path));
  maxf=directories[udir[dn].subnum].maxfiles;
  strcat(s1,s);
  f1=findfirst(s1,&ff,0);
  ok=1;
  i1=0;
  while ((f1==0) && (!hangup) && (numf<maxf) && (ok) && (!i1) && (!abort)) {
    ok=maybe_upload(ff.ff_name,dn,NULL);
    f1=findnext(&ff);
    checka(&abort,&next);
  }
  if ((!ok) || (abort))
    pl(get_string(14));
  if (numf>=maxf)
    pl(get_string(839));
  return(i1);
}


void relist(void)
{
  char s[85],s1[40],s2[81];
  int i,i1,next,abort=0,fc;

  outchr(12);
  lines_listed=0;
  fc=thisuser.sysstatus & sysstatus_extra_color;
  ansic(fc ? FRAME : 0);
  if (okansi())
    pl(get_string(1354));
  else
    pl(get_string(1355));
  for (i=0;i<tagptr;i++) {
    sprintf(s,"\r%d%2d%d%c",
      check_batch_queue(filelist[i].u.filename) ? 6 : 0,
      i+1, fc ? FRAME : 0, okansi() ? '' : '|' );
    osan(s,&abort,&next);
    if (fc)
      ansic(1);
    strncpy(s,filelist[i].u.filename,8);
    s[8]=0;
    osan(s,&abort,&next);
    strncpy(s,&((filelist[i].u.filename)[8]),4);
    s[4]=0;
    if (fc)
      ansic(1);
    osan(s,&abort,&next);
    ansic(fc ? FRAME : 0);
    osan((okansi() ? "" : ":"),&abort,&next);

    ltoa(bytes_to_k(filelist[i].u.numbytes),s1,10);
    strcat(s1,"k");
/*    if (!(directories[udir[i].subnum].mask & mask_cdrom)) {
      strcpy(s2,directories[udir[i].subnum].path);
      strcat(s2,filelist[i].u.filename);
      if (!exist(s2))
        strcpy(s1,get_string(741));
    }
*/
    for (i1=0; i1<5-strlen(s1); i1++)
      s[i1]=32;
    s[i1]=0;
    strcat(s,s1);
    if (fc)
      ansic(2);
    osan(s,&abort,&next);

    ansic(fc ? FRAME : 0);
    osan((okansi() ? "" : "|"),&abort,&next);
    sprintf(s1,"%d",filelist[i].u.numdloads);

    for (i1=0; i1<4-strlen(s1); i1++)
      s[i1]=32;
    s[i1]=0;
    strcat(s,s1);
    if (fc)
      ansic(2);
    osan(s,&abort,&next);

    ansic(fc ? FRAME : 0);
    osan((okansi() ? "" : "|"),&abort,&next);
    sprintf(s,"%d%s",
      (filelist[i].u.mask & mask_extended) ? 1 : 2,
      filelist[i].u.description);
    plal(s,thisuser.screenchars-28,&abort);
  }
  lines_listed=0;
  ansic(fc ? FRAME : 0);
  if (okansi())
    npr("\r%s\r\n",get_string(1356));
  else
    npr("\r%s\r\n",get_string(1357));
}

/****************************************************************************/

#ifdef OPT_FAST_SEARCH

/****************************************************************************/

void edit_database(void)
/*
 * Allows user to add or remove ALLOW.DAT entries.
 */
{
  unsigned char ch,s[20];
  int done=0;

  do {
    nl();
    pl(get_string(1382));
    pl(get_string(1383));
    pl(get_string(1384));
    nl();
    prt(1,get_string(1385));
    ch=onek("ARQ");
    switch (ch) {
      case 'A':
        nl();
        prt(2,get_string(44));
        mpl(12);
        input(s,12);
        if (s[0])
          modify_database(s,1);
        break;
      case 'R':
        nl();
        prt(2,get_string(44));
        mpl(12);
        input(s,12);
        if (s[0])
          modify_database(s,0);
        break;
      case 'Q':
        done=1;
        break;
    }
  } while ((!hangup) && (!done));
}

/****************************************************************************/

/*
 * Adds or deletes a single entry to/from filename database.
 */
void modify_database(unsigned char *fn, int add)
{
  unsigned char tfn[81],afn[81],cfn[15],fnn[15];
  int af=-1,tf=-1,i,wrote=0,sc;
  unsigned long num_recs, l, nw=0L;

  memset(fnn,0,sizeof(fnn));
  strcpy(fnn,stripfn(fn));

  i=is_uploadable_x(fnn,"ALLOW.DAT");

  /* Adding and already in there? */
  if ((add) && (!i))
    return;

  /* Deleting and not in there? */
  if ((!add) && (i))
    return;

  if (add)
    sprintf(afn,"%sALLOW.TMP",syscfg.datadir);
  else
    sprintf(afn,"%sALLOW.DAT",syscfg.datadir);

  af=sh_open(afn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
  if (af<0)
    return;

  if (filelength(af)==0) {
    if (add) {
      sh_write(af,(void *)&fnn,13);
    }
    af=sh_close(af);
    return;
  }
  sprintf(tfn,"%sALLOW.$$$",syscfg.datadir);
  if (exist(tfn))
    _chmod(tfn,1,0);
  unlink(tfn);
  tf=sh_open(tfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
  if (tf<0) {
    af=sh_close(af);
    return;
  }
  num_recs=(filelength(af)/13);
  for (l=0; l<num_recs; l++) {
    sh_lseek(af,((long) (l*13)),SEEK_SET);
    sh_read(af,(void *)&cfn,13);
    if (!wrote) {
      sc=strcmp(cfn, fnn);
      if ((sc==0) && (!add))
        continue;
      else if ((sc>0) && (add)) {
        sh_write(tf,(void *)&fnn,13);
        nw++;
        wrote=1;
      }
    }
    sh_write(tf,(void *)&cfn,13);
    nw++;
  }
  if ((!wrote) && (add))
    sh_write(tf,(void *)&fnn,13);
  tf=sh_close(tf);
  af=sh_close(af);
  _chmod(afn,1,0);
  unlink(afn);
  if (nw>0)
    rename(tfn,afn);
  else
    unlink(tfn);
}

/****************************************************************************/

/*
 * Checks filename database dbfn to see if file has already been uploaded
 * before.
 */
int is_uploadable_x(unsigned char *fn, unsigned char *dbfn)
{
  unsigned char tfn[15], afn[81], cfn[18];
  int af,found=0,done=0,i;
  unsigned long num_recs, hirec, lorec, currec;
  long ocurrec=-1L;

  strcpy(tfn,stripfn(fn));
  sprintf(afn,"%s%s",syscfg.datadir,dbfn);
  if (!exist(afn))
    return(1);

  af=sh_open(afn,O_RDONLY | O_BINARY, S_IREAD | S_IWRITE);
  if (af<1)
    return(1);

  num_recs=(filelength(af)/13);
  hirec=num_recs; lorec=0;
  while ((!done) && (!found) && (!hangup)) {
    currec=((long)((hirec+lorec)/2));
    if (currec==ocurrec) {
      found=0;
      done=1;
      break;
    }
    ocurrec=currec;
    sh_lseek(af,((long) (currec*13)),SEEK_SET);
    sh_read(af,(void *)&cfn,13);
    i=strcmp(cfn,tfn);

    /* found */
    if (i==0) {
      found=1;
      done=1;
    } else
    /* not found, it's higher if it exists */
    if (i<0) {
      lorec=currec;
    } else
    /* not found, it's lower if it exists */
    if (i>0) {
      hirec=currec;
    }
  }
  af=sh_close(af);
  if (found)
    return(0);
  else
    return(1);
}

/****************************************************************************/

/*
 * Returns 1 if file not found in filename databases (permanent and
 * temporary.
 */
int is_uploadable(unsigned char *fn)
{
  int i=0;

  i=is_uploadable_x(fn,"ALLOW.DAT");
  if (i)
    i=is_uploadable_x(fn,"ALLOW.TMP");
  return(i);
}

/****************************************************************************/

/*
 * Gets new filename from file handle, 1 if got one, 0 if eof.
 */

int get_dbname(int handle, unsigned char *s)
{
  if (eof(handle))
    return(0);
  sh_read(handle,(void *)s,13);
  return(1);
}

/****************************************************************************/

/*
 * If ALLOW.TMP exists, this function merges with ALLOW.DAT. As this can
 * take a while (depending on how many file in databases), this should be
 * called when user not online.
 */
void merge_databases(void)
{
  unsigned char s1[81], s2[81], tfn[81], lfn[15], afn1[15], afn2[15];
  int af1, af2, tf, cmp, ok1, ok2, lcmp;

  /* Store pathnames */
  sprintf(s1,"%sALLOW.DAT",syscfg.datadir);
  sprintf(s2,"%sALLOW.TMP",syscfg.datadir);
  sprintf(tfn,"%sALLOW.$$$",syscfg.datadir);

  /* No ALLOW.TMP then bail */
  if (!exist(s2))
    return;

  /* No ALLOW.DAT makes it easy */
  if (!exist(s1)) {
    rename(s2,s1);
    return;
  }

  holdphone(1);

  /* Open main database file */
  af1=sh_open(s1,O_RDWR | O_BINARY | O_CREAT, S_IREAD);
  if (af1<1)
    return;

  /* Open temp database file */
  af2=sh_open(s2,O_RDWR | O_BINARY, S_IREAD);
  if (af2<1) {
    af1=sh_close(af1);
    return;
  }

  /* No recs in ALLOW.TMP, then zap and bail */
  if (filelength(af2)<13) {
    af1=sh_close(af1);
    af2=sh_close(af2);
    unlink(s2);
    return;
  }

  /* Open temporary merge file */
  tf=sh_open(tfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
  if (tf<1) {
    af1=sh_close(af1);
    af2=sh_close(af2);
    return;
  }

  /* Last filename is nothing to start */
  strcpy(lfn,charstr(1,8));

  ok1=get_dbname(af1,afn1);
  ok2=get_dbname(af2,afn2);

  while (((ok1) || (ok2))) {
    if ((ok1) && (ok2)) {
      /* filenames left in both files */
      cmp=strcmp(afn1,afn2);
      if (cmp==0) {
        /* Same filename */
        lcmp=strcmp(lfn,afn1);
        if (lcmp!=0) {
          strcpy(lfn,afn1);
          sh_write(tf,(void *)&afn1,13);
        }
        ok1=get_dbname(af1,afn1);
        ok2=get_dbname(af2,afn2);
      } else if (cmp<0) {
        /* First one is lower */
        lcmp=strcmp(lfn,afn1);
        if (lcmp!=0) {
          strcpy(lfn,afn1);
          sh_write(tf,(void *)&afn1,13);
        }
        ok1=get_dbname(af1,afn1);
      } else {
        /* Second one is lower */
        lcmp=strcmp(lfn,afn2);
        if (lcmp!=0) {
          strcpy(lfn,afn2);
          sh_write(tf,(void *)&afn2,13);
        }
        ok2=get_dbname(af2,afn2);
      }
    } else if (ok1) {
      /* filenames left only in first file */
      lcmp=strcmp(lfn,afn1);
      if (lcmp!=0) {
        strcpy(lfn,afn1);
        sh_write(tf,(void *)&afn1,13);
      }
      ok1=get_dbname(af1,afn1);
    } else {
      /* filenames left only in second file */
      lcmp=strcmp(lfn,afn2);
      if (lcmp!=0) {
        strcpy(lfn,afn2);
        sh_write(tf,(void *)&afn2,13);
      }
      ok2=get_dbname(af2,afn2);
    }
  }

  /* Release file handles */
  af1=sh_close(af1);
  af2=sh_close(af2);
  tf=sh_close(tf);

  /* Zap original files */
  unlink(s1);
  unlink(s2);

  /* Rename merge file to ALLOW.DAT */
  rename(tfn,s1);
}

/****************************************************************************/

#endif

/****************************************************************************/

void l_config_nscan(void)
{
  int i,abort,i1;
  char s[81], s2[81];

  abort=0;
  nl();
  pl(get_string(802));
  nl();
  for (i=0; (i<num_dirs) && (udir[i].subnum!=-1) && (!abort); i++) {
    i1=udir[i].subnum;
    if (qsc_n[i1/32]&(1L<<(i1%32)))
      strcpy(s,"* ");
    else
      strcpy(s,"  ");
    sprintf(s2,"%s%s. %s",s,udir[i].keys, directories[i1].name);
    pla(s2,&abort);
  }
  nl();
  nl();
}

void config_nscan(void)
{
  char *s,s1[MAX_CONFERENCES+2],s2[120],ch;
  int i,i1,done,done1,oc,os,abort=0;

  done=done1=0;
  oc=curconfdir;
  os=udir[curdir].subnum;

  do {
    if ((okconf(&thisuser)) && (uconfdir[1].confnum!=-1)) {
      abort=0;
      strcpy(s1," ");
      nl();
      pl(get_string(1358));
      nl();
      i=0;
      while ((i<dirconfnum) && (uconfdir[i].confnum!=-1) && (!abort)) {
        sprintf(s2,"%c) %s",dirconfs[uconfdir[i].confnum].designator,
          stripcolors(dirconfs[uconfdir[i].confnum].name));
        pla(s2,&abort);
        s1[i+1]=dirconfs[uconfdir[i].confnum].designator;
        s1[i+2]=0;
        i++;
      }
      nl();
      outstr(get_string(1082));
      outstr(&s1[1]);
      outstr(get_string(1083));
      ch=onek(s1);
    } else
      ch='-';
    switch (ch) {
      case ' ':
        done1=1;
        break;
      default:
        if ((okconf(&thisuser)) && (dirconfnum>1)) {
          i=0;
          while ((ch!=dirconfs[uconfdir[i].confnum].designator) && (i<dirconfnum))
            i++;
          if (i>=dirconfnum)
            break;

          setuconf(CONF_DIRS, i, -1);
        }

        l_config_nscan();
        do {
          nl();
          outstr(get_string(1359));
          s=mmkey(1);
          if (s[0]) {
            for (i=0; i<num_dirs; i++) {
              i1=udir[i].subnum;
              if (strcmp(udir[i].keys,s)==0) {
                qsc_n[i1/32] ^= 1L<<(i1%32);
              }
              if (strcmp(s,"S")==0) {
                qsc_n[i1/32] |= 1L<<(i1%32);
              }
              if (strcmp(s,"C")==0) {
                qsc_n[i1/32] = 0L;
              }
            }
            if (strcmp(s,"Q")==0)
              done=1;
            if (strcmp(s,"?")==0)
              l_config_nscan();
          }
        } while ((!done) && (!hangup));
        break;
    }
    if ((!okconf(&thisuser)) || (uconfdir[1].confnum==-1))
      done1=1;
  } while ((!done1) && (!hangup));

  if (okconf(&thisuser))
    setuconf(CONF_DIRS, oc, os);
}


void xfer_defaults(void)
{
  char s[81],ch;
  int i,done;

  done=0;
  do {
    outchr(12);
    pl(get_string(804));
    pl(get_string(805));
    outstr(get_string(806));
    npr(" (%s).\r\n", thisuser.sysstatus & sysstatus_nscan_file_system?str_yes:str_no);
    outstr(get_string(807));
    npr(" (%d %s%s).\r\n", thisuser.num_extended, get_string(808),
        thisuser.num_extended==1?"":"s");
    outstr(get_string(1360));
    if (thisuser.sysstatus & sysstatus_no_tag)
      outstr(get_string(1361));
    else
      outstr(get_string(1362));
    pl(")");
    pl(get_string(809));
    nl();
    prt(2,get_string(297));
    helpl=32;
    ch=onek("Q12345");
    switch(ch) {
      case 'Q':
        done=1;
        break;
      case '1':
        helpl=24;
        config_nscan();
        break;
      case '2':
        nl();
        nl();
        pl(get_string(810));
        nl();
        helpl=40;
        i=get_protocol(xf_down);
        if (i>=0)
          thisuser.defprot=i;
        break;
      case '3':
        nl();
        nl();
        pl(get_string(811));
        outstr(get_string(812));
        if (thisuser.sysstatus & sysstatus_nscan_file_system)
          thisuser.sysstatus -= sysstatus_nscan_file_system;
        if (yn())
          thisuser.sysstatus += sysstatus_nscan_file_system;
        break;
      case '4':
        nl();
        nl();
        pl(get_string(813));
        pl(get_string(814));
        outstr(get_string(815));
        pln(thisuser.num_extended);
        prt(5,"? ");
        helpl=41;
        input(s,3);
        if (s[0]) {
          i=atoi(s);
          if ((i>=0) && (i<=10))
            thisuser.num_extended=i;
        }
        break;
        case '5':
          if (thisuser.sysstatus & sysstatus_no_tag)
            thisuser.sysstatus -= sysstatus_no_tag;
          else
           thisuser.sysstatus += sysstatus_no_tag;
        break;
    }
  } while ((!done) && (!hangup));
}


void yourinfodl(void)
{
  nl();
#ifdef OPT_EXTRA_COLOR
  ansic(1); outstr(get_string(796));
  ansic(2); npr("%ldk",thisuser.uk);
  ansic(1); outstr(get_string(797));
  ansic(2); npr("%d",thisuser.uploaded);
  pl(get_string(798));
  ansic(1); outstr(get_string(799));
  ansic(2); npr("%ldk",thisuser.dk);
  ansic(1); outstr(get_string(797));
  ansic(2); npr("%d",thisuser.downloaded);
  pl(get_string(798));
  ansic(1); outstr(get_string(800));
  ansic(2); npr("%-6.3f\r\n",ratio());
  ansic(1); outstr(get_string(801));
  ansic(2); pln(thisuser.dsl);
#else
  outstr(get_string(796));
  npr("%ldk",thisuser.uk);
  outstr(get_string(797));
  npr("%d",thisuser.uploaded);
  pl(get_string(798));
  outstr(get_string(799));
  npr("%ldk",thisuser.dk);
  outstr(get_string(797));
  npr("%d",thisuser.downloaded);
  pl(get_string(798));
  outstr(get_string(800)); npr("%-6.3f\r\n",ratio());
  outstr(get_string(801)); pln(thisuser.dsl);
#endif
}
