#include <io.h>
#include <share.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <direct.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"
#include "nodelist.h"

    char d_nodelist[1025] = ".\\NODELIST";
    char d_msg[1025]      = ".\\MSG";
    char d_outbound[1025] = ".\\OUTBOUND";
    char d_menu[1025]     = ".\\MENU";
    char d_help[1025]     = ".\\HELP";
    char d_text[1025]     = ".\\TEXT";
    char d_news[1025]     = ".\\NEWS";
    char d_misc[1025]     = ".\\";
    char d_miscnews[1025] = ".\\MISCNEWS";
    char d_packets[1025]  = ".\\PACKETS";
    char d_xport[1025]    = ".\\XPORT";

    extern long           nidxsize;
    extern NODEIDX huge  *nidx;
    extern MDM           *modems[MAXINSTANCES];
    extern BBS           *bbs;


int _fastcall set_bbs_defaults (USHORT cp) {

    int  handle;
    char *s;

    if((s = getenv("XNODELIST")) != NULL)
      strcpy(d_nodelist,s);
    if((s = getenv("XMSG")) != NULL)
      strcpy(d_msg,s);
    if((s = getenv("XOUTBOUND")) != NULL)
      strcpy(d_outbound,s);
    if((s = getenv("XMENU")) != NULL)
      strcpy(d_menu,s);
    if((s = getenv("XHELP")) != NULL)
      strcpy(d_help,s);
    if((s = getenv("XTEXT")) != NULL)
      strcpy(d_text,s);
    if((s = getenv("XNEWS")) != NULL)
      strcpy(d_news,s);
    if((s = getenv("XMISC")) != NULL)
      strcpy(d_misc,s);
    if((s = getenv("XMISCNEWS")) != NULL)
      strcpy(d_miscnews,s);
    if((s = getenv("XPACKETS")) != NULL)
      strcpy(d_packets,s);
    if((s = getenv("XXPORT")) != NULL)
      strcpy(d_xport,s);

    memset(bbs,0,sizeof(BBS));
    bbs->quotepos = 0L;
    bbs->numcalls = 0L;
    bbs->last_userid = 0L;
    bbs->last_pointid = 0;
    bbs->minage = 12;
    bbs->maxage = 130;
    bbs->credit = 0;
    bbs->expiredays = 0;
    bbs->expiremins = 0;
    bbs->time_per_day = 45;
    bbs->security1 = 5L;
    bbs->security2 = 0L;
    bbs->flags1 = 0L;
    bbs->flags2 = 0L;
    bbs->ukperday = 500L;
    bbs->dkperday = 500L;
    bbs->attribs = B_LOGONQUOTE | B_LOGOFFQUOTE | B_FIRSTLOGMSG |
                   B_LOGOFFMSG | B_FOLLOWBBS | B_HIGHASCII | B_COLOR |
                   B_COLD | B_CLEAR | B_PAUSE | B_SHOW;
    bbs->attribs2 = 0L;

    strcpy(bbs->origin,"An OS/2 XBBS");
    memset(bbs->msgflags,255,64);
    memset(bbs->fileflags,255,64);
    memset(bbs->bbsmsg,255,64);
    memset(bbs->bbsfile,255,64);
    bbs->defaultcost = 50;
    bbs->maxattempts = 3;
    bbs->time_per_call = 30;
    bbs->ulmulti = 0;
    bbs->quoteodds = 50;
    bbs->localbbs[0] = 2;
    bbs->localbbs[1] = 1;
    bbs->mainthread[0] = 2;
    bbs->mainthread[1] = 1;
    strcpy(bbs->inbound[0],"./INBOUND");
    strcpy(bbs->inbound[1],"./INBOUND");
    strcpy(bbs->inbound[2],"./INBOUND");
    strcpy(bbs->okfiles[0],"./OKFILE.LST");
    strcpy(bbs->okfiles[1],"./OKFILE.LST");
    strcpy(bbs->okfiles[2],"./OKFILE.LST");
    bbs->maxpage = 3;
    strcpy(bbs->sysop,"Duhhh");
    strcpy(bbs->bbs_name,"XBBS in your eye");
    bbs->uattribs = U_NOVICE | U_SEENEWS | U_AVAILABLE;
    bbs->maxuserpkt = 65535L;

    s = (char *)malloc(MAX_FILENAME_LEN);
    if(!s)
      return -1;
    if(!*searchpath("XBCONFIG.000",s,MAX_FILENAME_LEN)) {
      strcpy(s,"XBCONFIG.000");
    }
    handle = sopen(s,O_NOINHERIT | O_RDWR | O_CREAT | O_BINARY,SH_DENYWR,S_IWRITE | S_IREAD);
    if(handle == -1) {
      free(s);
      return -2;
    }

    if(!filelength(handle))
      write(handle,bbs,sizeof(BBS));
    else
      read(handle,bbs,sizeof(BBS));

    close(handle);

    mkdir(bbs->inbound[0]);
    mkdir(bbs->inbound[1]);
    mkdir(bbs->inbound[2]);

    {
      struct stat st;

      if(stat(bbs->okfiles[0],&st)) {
        logfmain("Warning:  OKFile \"%s\" doesn't exist.",bbs->okfiles[0]);
      }
      if(stat(bbs->okfiles[2],&st)) {
        logfmain("Warning:  OKFile \"%s\" doesn't exist.",bbs->okfiles[1]);
      }
      if(stat(bbs->okfiles[2],&st)) {
        logfmain("Warning:  OKFile \"%s\" doesn't exist.",bbs->okfiles[2]);
      }
    }

  free(s);

  if(!(bbs->attribs2 & B2_USEVER7)) {
    read_nodelist();
    if(!nidx || !nidxsize)
      logfmain("No nodelist available");
  }

  return 0;
}


int _fastcall set_mailer_defaults (USHORT cp) {

    int  handle;
    char *s,fname[18];

    memset(modems[cp],0,sizeof(MDM));
    strcpy(modems[cp]->dpre,"v~^~AT \\\\N0 DT ");
    strcpy(modems[cp]->dsuf,"|");
    strcpy(modems[cp]->dprevar[0],"v~^~ATDT ");
    strcpy(modems[cp]->dsufvar[0],"|");
    strcpy(modems[cp]->dprevar[1],"v~^~ATDT ");
    strcpy(modems[cp]->dsufvar[1],"|");
    strcpy(modems[cp]->dprevar[2],"v~^~ATDT ");
    strcpy(modems[cp]->dsufvar[2],"|");
    strcpy(modems[cp]->dprevar[3],"v~^~ATDT ");
    strcpy(modems[cp]->dsufvar[3],"|");
    strcpy(modems[cp]->dprevar[4],"v~^~ATDT ");
    strcpy(modems[cp]->dsufvar[4],"|");
    strcpy(modems[cp]->dprevar[5],"v~^~ATDT ");
    strcpy(modems[cp]->dsufvar[5],"|");
    strcpy(modems[cp]->dprevar[6],"v~^~ATDT ");
    strcpy(modems[cp]->dsufvar[6],"|");
    strcpy(modems[cp]->dprevar[7],"v~^~ATDT ");
    strcpy(modems[cp]->dsufvar[7],"|");
    strcpy(modems[cp]->answer,"ATA|");
    strcpy(modems[cp]->banner,"\r\nEnter your name, humanoid.\r\n -> ");
    strcpy(modems[cp]->mailonly,"\rGO AWAY, HUMAN\r");
    strcpy(modems[cp]->init,"v~^~AT Z0|~AT S2=255 S9=28 H0 %C0|~");
    strcpy(modems[cp]->extmail,"cmd.exe /c mail.cmd %s");
    strcpy(modems[cp]->tooslow,"\r\nYou're too slow\r\n");
    modems[cp]->locked = 1;
    modems[cp]->humansok = 1;
    modems[cp]->fts0001 = 0;
    modems[cp]->maxbaud = 19200;
    modems[cp]->minbaud = 1200;
    modems[cp]->minmailbaud = 1200;
    modems[cp]->mincallbaud = 2400;
    modems[cp]->maxcallbaud = 38400;
    modems[cp]->mincost = 0;
    modems[cp]->maxcost = 1;
    modems[cp]->sfreqsok = 1;
    modems[cp]->rfreqsok = 1;
    modems[cp]->dialoutok = 1;
    modems[cp]->answerok = 1;
    modems[cp]->nosealink = 0;
    modems[cp]->noslo = 0;
    modems[cp]->sea1k = 0;
    modems[cp]->nextevent = 0L;
    modems[cp]->maxmailk = 1024L;
    modems[cp]->maxmailtime = 60L * 60L;
    modems[cp]->maxmailmisc = 0L;
    modems[cp]->maxbad = 3;
    modems[cp]->maxtries = 100;
    modems[cp]->whichin = 0;
    modems[cp]->mailer[0] = 2;
    modems[cp]->mailer[1] = 1;
    modems[cp]->comm[0] = 4;
    modems[cp]->comm[1] = 1;
    modems[cp]->bbs[0] = 2;
    modems[cp]->bbs[1] = 1;
    modems[cp]->export[0] = 2;
    modems[cp]->export[1] = 0;
    modems[cp]->outside[0] = 2;
    modems[cp]->outside[1] = 1;
    modems[cp]->transfer[0] = 4;
    modems[cp]->transfer[1] = 2;
    modems[cp]->maxtranserrs = 200;
    modems[cp]->maxresyncs = 15;
    modems[cp]->checkcd = 0;
    modems[cp]->no1k = 1;

    s = (char *)malloc(MAX_FILENAME_LEN);
    if(!s)
      return -1;
    sprintf(fname,"XMCONFIG.%03x",cp);
    if(!*searchpath(fname,s,MAX_FILENAME_LEN))
      strcpy(s,fname);
    handle = sopen(s,O_NOINHERIT | O_RDWR | O_CREAT | O_BINARY,SH_DENYWR,S_IWRITE | S_IREAD);
    if(handle == -1) {
        free(s);
        return -2;
    }

    if(!filelength(handle)) {
        write(handle,modems[cp],sizeof(MDM));
        mkdir(d_outbound);
        mkdir(d_msg);
        mkdir(d_packets);
        mkdir(d_menu);
        mkdir(d_text);
        mkdir(d_help);
        mkdir(d_news);
        mkdir(d_miscnews);
        mkdir(d_nodelist);
        mkdir(d_misc);
        mkdir(d_xport);
    }
    else
      read(handle,modems[cp],sizeof(MDM));

    close(handle);

    free(s);
    return 0;
}
