#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <io.h>
#include <share.h>
#include <ctype.h>
#include "mailer.h"
#include "xmisc.h"
#include "bbs.h"


    extern ADDR   *addresses;
    extern USHORT focusline;
    extern BBS    *bbs;
    extern MDM    *modems[MAXINSTANCES];

    unsigned long FidoUserSEM = 0L;

#define TEXTLEN 133


ADDR * _fastcall find_in_fidouser (int mode,USHORT cp,char *name,ADDR *addr) {

    /* locate a user name in fidouser list, return address or NULL */
    /* name=user name, fn=filename, addr gets filled in.  note this */
    /* will tolerate 'full' addresses (z:N/n.p@d) */

    struct _fuseridx {
        char firstchar;
        long pos;
    } fux;
    int         f,fx,namelen,cntr;
    long        low,high,mid;
    struct stat buf;
    char        midname[TEXTLEN],last_name_first[TEXTLEN];
    char        *c,lastchar = 0;


    if(bbs->attribs2 & B2_USEVER7) return find_in_sysopndx(mode,cp,name,addr);

    DosSemWait(&FidoUserSEM,-1L);
    DosSemSet(&FidoUserSEM);
    memset(addr,0,sizeof(ADDR));
    addr->next = NULL;
    memset(midname, 0, TEXTLEN * sizeof(char));
    strcpy(midname,name);
    lstrip(midname);
    rstrip(midname);

    c = strchr(midname,' ');
    if(!c) strcpy(last_name_first,midname);
    else {
        *c = 0;
        c++;
        lstrip(c);
        strcpy(last_name_first,c);
        strcat(last_name_first,", ");
        strcat(last_name_first,midname);
    }

    strlwr(last_name_first);                /* all lower case */
    namelen = strlen(last_name_first);      /* Calc length now */

    {
        char s[290];

        sprintf(modems[cp]->builddir,"%s/FIDOUSER.LST",d_nodelist);
        if(stat(modems[cp]->builddir,&buf)) {
            DosSemClear(&FidoUserSEM);
            return NULL;
        }

        f = bbs_sopen(cp,modems[cp]->builddir,O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO); /* open it */
        if(f == -1) {
            DosSemClear(&FidoUserSEM);
            return NULL;
        }

        sprintf(modems[cp]->builddir,"%s/FIDOUSER.IDX",d_nodelist);
        fx = bbs_sopen(cp,modems[cp]->builddir,O_NOINHERIT | O_RDWR | O_BINARY,SH_DENYWR);
        if(fx == -1)
          fx = bbs_sopen(cp,modems[cp]->builddir,O_CREAT | O_RDWR | O_BINARY | O_NOINHERIT,SH_DENYWR,S_IWRITE | S_IREAD);
        else {
            read(fx,&mid,sizeof(long));
            read(fx,&high,sizeof(long));
            if(mid == buf.st_size && high == buf.st_mtime)
              goto SkipReIndex;
        }

        if((int)cp != -1)
          sayp(mode,cp,236,NULL,0);
        else
          logfunc(2,focusline,"Indexing FIDOUSER.LST...");
        DosNewSize(fx,0L);
        lseek(fx,(long)sizeof(long) * 2L,SEEK_SET);
        cntr = 0;
        while(!eof(f)) {
            low = tell(f);
            if(!fgetsx(s,TEXTLEN + 1,f)) break;
            if(*s != ' ') {
                if(toupper(*s) != (int)lastchar) {
                    if((int)cp != -1) dputs(mode,cp,".");
                    lastchar = (char)toupper(*s);
                    fux.firstchar = lastchar;
                    fux.pos = low;
                    write(fx,&fux,sizeof(struct _fuseridx));
                }
            }
            cntr++;
            if(!(cntr % 500)) DosSleep(1L);
        }
        lseek(fx,0L,SEEK_SET);
        write(fx,&buf.st_size,sizeof(long));
        write(fx,&buf.st_mtime,sizeof(long));
        if((int)cp != -1) sayp(mode,cp,237,NULL,0);
    }

SkipReIndex:

    lseek(fx,(long)sizeof(long) * 2L,SEEK_SET);
    while(!eof(fx)) {
        read(fx,&fux,sizeof(struct _fuseridx));
        if((int)fux.firstchar == toupper(*last_name_first)) goto FindEm;
    }
    goto Abort;

FindEm:

    lseek(f,fux.pos,SEEK_SET);
    cntr = 0;
    while(!eof(f)) {
        if(!fgetsx(midname,TEXTLEN,f)) break;
        if(tolower(*midname) != (int)*last_name_first) break;
        stripcr(midname);
        strlwr(midname);
        if(!strncmp(last_name_first, midname, namelen)) {

            /* Return the address information */

            bbs_close(cp,f);
            bbs_close(cp,fx);
            c = &c[strlen(c)-1];
            while (isspace(*c)) *c-- = '\0'; c--;
            while (!isspace(*c)) c--;
            DosSemClear(&FidoUserSEM);
            if(parse_addr(&c,addr,addresses)) {
                memset(addr,0,sizeof(ADDR));
                addr->next = NULL;
                return NULL;
            }
            return addr;
        }
        cntr++;
        if(!(cntr % 100)) DosSleep(1L);
    }

Abort:

    bbs_close(cp,f);
    bbs_close(cp,fx);
    DosSemClear(&FidoUserSEM);
    return NULL;
}
