#include <io.h>
#include <share.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include "mailer.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"


    MSGAREA        *msgareas    = NULL;
    MSGAREA        *msgareatail = NULL;

    extern ADDR    *addresses;




int _fastcall load_msgareas (void) {

    int     handle;
    char    ln[513];
    char    *p,*pp;
    MSGAREA *info;
    ADDR    addr;


    handle = sopen("MSG/MSGAREAS.BB2",O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
    if(handle == -1) {
        return 0;
    }

    while(!eof(handle)) {
        if(!fgetsx(ln,512,handle)) break;
        lstrip(ln);
        if(*ln == ';') continue;
        stripcr(ln);
        rstrip(ln);
        if(!*ln || *ln == '\x1a') continue;
        info = (MSGAREA *)malloc(sizeof(MSGAREA));
        if(!info) {

OutOfMemory:

            close(handle);
            logfmain("Not enough memory to load all msgareas");
            DosSleep(1000L);
            return -1;
        }

        memset(info,0,sizeof(MSGAREA));
        p = ln;
        pp = to_delim(p,",");
        *pp = 0;
        if(!*p) {
            info->name = NULL;
            goto BadArea;
        }
        info->name = strdup(ln);
        if(!info->name) {
            free(info);
            goto OutOfMemory;
        }

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp=0;
        info->age = atoi(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->r_security1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->r_security2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->r_flags1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->r_flags2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->w_security1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->w_security2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->w_flags1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->w_flags2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->s_security1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->s_security2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->s_flags1 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->s_flags2 = (unsigned long)atol(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->areaflags = (unsigned int)atoi(p);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        if(parse_addr(&p,&addr,addresses)) {
            goto BadArea;
        }
        info->addr = find_address(&addr,addresses);

        p = ++pp;
        pp = to_delim(p,",");
        if(!*p) goto BadArea;
        *pp = 0;
        info->number = (unsigned int)atoi(p);

        if(!info->number || info->number > 512) {

BadArea:
            logfmain("Invalid msgarea %s",info->name);
            free(info->name);
            free(info);
            continue;
        }

        pp++;       /* allow to be blank from here on */
        if(*pp) {
            p = pp;           
            pp = to_delim(p,",");
            *pp = 0;
            if(!*p) info->descr = NULL;
            else {
                if(strlen(p) > 77) p[77] = 0;
                info->descr = strdup(p);
            }
            pp++;
            if(*pp) {
                p = pp;
                pp = to_delim(p,",");
                *pp = 0;
                if(!*p) info->forceto = NULL;
                else {
                    if(strlen(p) > 35) p[35] = 0;
                    info->forceto = strdup(p);
                }
                pp++;
                if(*pp) {
                    p = pp;
                    pp = to_delim(p,",");
                    *pp = 0;
                    if(!*p) info->password = NULL;
                    else {
                        if(strlen(p) > 35) p[35] = 0;
                        info->password = strdup(p);
                        if(!info->password) {
                            logfmain("Allocation for password, msgarea %s, failed.",info->name);
                            logfmain("Removing area from memory for security.");
                            if(info->descr) free(info->descr);
                            if(info->forceto) free(info->forceto);
                            free(info->name);
                            free(info);
                            continue;
                        }
                    }
                }
            }
        }

        /* note: HeadEdit would read "name-to-use" here and ignore a lot of
                 the stuff XBBS uses. */

        if(!msgareas) {
            msgareas = info;
            msgareatail = info;
            info->prior = NULL;
        }
        else {
            msgareatail->next = info;
            info->prior = msgareatail;
            msgareatail = info;
        }
        info->next = NULL;
    }

    close(handle);
    return 0;
}
