/* Allow user to create a text file */

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "modem.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"


    extern MDM     *modems[MAXINSTANCES];
    extern USER    *user[MAXINSTANCES];
    extern BBS     *bbs;
    extern MSGAREA *msgareas;



int _pascal create_text_file (int mode,USHORT cp,char *dir,char *ext) {

     struct stat st;
     char        *s,*p,title[9];
     static unsigned long FindSEM = 0L;


     if(!dir) return -1;
     if(!ext) ext = ".TXT";

     s = (char *)bbs_malloc(cp,1041);
     if(!s) return -1;

     sprintf(s,"./TEXTFILE.%03x",cp);
     unlink(s);
     line_editor(mode,cp,s,E_NOTO | E_NOFROM | E_NOSUBJ,NULL);
     if(!stat(s,&st) && st.st_size > 0L) {
         p = &s[strlen(s) + 1];
         strset(title,0);
         for(;;) {
             if(user[cp]->offline < time(NULL)) {
                 unlink(s);
                 bbs_free(cp,s);
                 return -1;
             }
             input_string(mode,cp,title,8,3,
                          "\r\nTitle for this file? ",
                          STRT_ALPHANUMERIC,STRF_UCASE,
                          "Text Title",NULL);
             if(!*title) {

                 char input[2];

                 strset(input,0);
                 input_string(mode,cp,input,1,1,
                              "\r\nAbort text file entry? (y/N) ",
                              STRT_YN,STRF_UCASE | STRF_HOT,
                              "Abort Text",NULL);
                 if(*input == 'Y') break;
                 continue;
             }
             if(DosSemRequest(&FindSEM,2000L)) {
                 DosSemClear(&FindSEM);
                 DosSemRequest(&FindSEM,1000L);
             }
             sprintf(p,"%s/%0.8s.%s",dir,title,ext);
dputs(D_LOCAL,cp,"\r\n\04Filename: ");
dputs(D_LOCAL,cp,p);
             if(!stat(p,&st)) {
                 dputs(mode,cp,"\r\nA file by that name already exists; try again.\r\n");
             }
             else break;
             DosSemClear(&FindSEM);
         }
         if(!checkcarrier(cp) && *title && !DosMove(s,p,0L)) {
             dprintf(mode,cp,"\r\nPosted text file \"%s\"\r\n",p);
         }
         else {
             dputs(mode,cp,"\r\nSorry, text post failed.\r\n");
         }
         DosSemClear(&FindSEM);
     }

     unlink(s);
     bbs_free(cp,s);
     return 0;
}
