/*********************************/
/* Modem-7 filename receive      */
/*********************************/

#include <process.h>
#include "mailer.h"
#include "modem.h"
#include "transfer.h"
#include "timers.h"

    extern MDM *modems[MAXINSTANCES];


int _fastcall modem7_recv (USHORT cp,char *filename) {

    int retries = 0;
    int temp;

    purge_in(cp);
    *filename = 0;

    do {
        com_putc(cp,'C');

/* MR0a */

        temp = peek_at_byte(cp,1500L);

        switch(temp) {
            case TIMEOUT:     break;

            case LOSTCARRIER: return LOSTCARRIER;

            case SOH:         if(modems[cp]->nosealink) {
                                get_modem_byte(cp,32L);
                                break;
                              }
            case SYN:         logfunc(0,cp,"Skipping Modem-7 filename");
                              return temp;

            case EOT:         get_modem_byte(cp,32L);
                              return EOT;

            default:          get_modem_byte(cp,32L);
                              break;
        }

        retries++;

    } while(retries < 7);

/* MR0b */

    retries=0;

    do {
        com_putc(cp,NAK);
        temp = get_modem_byte(cp,1100L);

/* MR1 */

        switch(temp) {
            case TIMEOUT:     break;

            case LOSTCARRIER: return LOSTCARRIER;

            case ACK:         temp = MR2(cp,filename);
                              if(temp == 'u')
                                continue;
                              return temp;

            case EOT:         return EOT;
        }

        retries++;

    } while(retries < 20);

    logfunc(0,cp,"Modem-7 receive timed out");
    return TIMEOUT;
}





int _fastcall MR2 (USHORT cp,char *filename) {

    clock_t tmr;
    int temp;
    int retries = 0;
    char csum = 0;
    char *p;
    char x = 0;
    char inext = 0;

    p = filename;
    tmr = timerset(120000L);   // 2 minutes and screw you

    while(!timeup(tmr)) {
        temp = get_modem_byte(cp,1100L);

        switch(temp) {
            case EOT:         return EOT;

/* MR3 */

            case SUB:   csum += SUB;
                        com_putc(cp,csum);
                        temp = get_modem_byte(cp,2500L);
                        if(temp == ACK)
                          return ACK;

            case TIMEOUT:
            case 'u':   return 'u';

            case LOSTCARRIER: return LOSTCARRIER;

            default:          csum += temp;
                        if(x < 11) {          // Gimme a break...
                          if(x == 8) {
                            inext = 1;
                            *p = '.';
                            p++;
                            *p = 0;
                          }
                          else if(temp==' ') {
                            if(!inext) {
                              *p = '.';
                              p++;
                              *p = 0;
                              inext = 1;
                            }
                          }
                          else {
                            *p=(char)temp;
                            p++;
                            *p = 0;
                            x++;
                          }
                        }
                        com_putc(cp,ACK);
                        break;
        }
    }

  logfunc(0,cp,"Modem-7 receive timed out");
  return TIMEOUT;
}
