#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "bbs.h"
#include "xmisc.h"

/*********************************************************************/
/* saved this as a simple example of how to manipulate the user base */
/* note that in practice you'll want to make a backup...             */
/*********************************************************************/


int main (int argc,char *argv[]) {

  int    handle;
  USHORT c = 0;
  USER   u;
  long   pos;
  char   *filename = "./users.bb2";   /* default */
  char   *p,build[1027];
  BBS    bbs;

  if(argc > 1 && (argv[1][0] == '?' || argv[1][1] == '?')) {
    /* print some help */
    printf("\nFixes userids to run sequentially.  Handy for fixing up"
           "\nuser file after, for instance, a reinstall and loss of"
           "\nold XBCONFIG.000 file (containing \"next userid\" entry)."
           "\nAccepts USERS.BB2 pathname as an argument.\n");
    return 0;
  }

  if(argc > 1)  /* allow changing default from command line */
    filename = argv[1];

  /* open userfile */
  handle = sopen(filename,O_RDWR | O_BINARY,SH_DENYRW);
  if(handle == -1) {
    printf("\nCouldn't open user file \"%s\"\n",filename);
    return 1;
  }

  printf("\nProcessing user #");
  while(!eof(handle)) {
    printf("%-5u\b\b\b\b\b",c);

    /* save position */

    pos = tell(handle);

    /* read record */

    if(read(handle,&u,sizeof(USER) - USERSUB) <
       (long)(sizeof(USER) - USERSUB))
      break;

    /* seek back to start of record */

    if(lseek(handle,pos,SEEK_SET) == -1)
      break;

    /* do something to user record */

    u.userid = ++c;     /* updating userids in this example */

//  u.dkperday = 4000L; /* you could change other stuff, too */

    /* rewrite modified record */

    if(write(handle,&u,sizeof(USER) - USERSUB) <
       (long)(sizeof(USER) - USERSUB))
      break;
  }

  close(handle);

  /* now fix next userid in config file */

  while((p = strchr(filename,'/')) != NULL)
    *p = '\\'; /* strip filename to just path */
  p = strrchr(filename,'\\');
  if(!p)
    p = strrchr(filename,':');
  if(p) {
    p++;
    *p = 0;
  }
  else
    *filename = 0;
  sprintf(build,"%sXBCONFIG.000",filename);
  handle = sopen(build,O_RDWR | O_BINARY,SH_DENYWR);
  if(handle != -1) {
    if(read(handle,&bbs,sizeof(bbs)) != -1) {
      bbs.last_userid = c;
      write(handle,&bbs,sizeof(bbs));
    }
    close(handle);
    printf("\nUpdated next userid field in %sXBCONFIG.000\n",filename);
  }
  else
    printf("\nCouldn't open %sXBCONFIG.000.  Note next userid should"
           "\nbe set to %lu.\n",filename,c);

  printf("\nComplete.\n");

  return 0;
}
