#include "mailer.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <direct.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include "bbs.h"
#include "xmisc.h"

    extern int      *_threadid;
    extern MDM      *modems[MAXINSTANCES];
    extern USER     *user[MAXINSTANCES];
    extern BBS      *bbs;
    extern FILEAREA *fileareas;
    extern ARC_TYPE *arcsighead;


void _fastcall view_arc_shell (int mode,USHORT cp) {

  /* prompts user for name of archive to display */

  char filename[65] = "";

  pinput_string(mode,cp,filename,64,1,283,STRT_JUSTFILE,STRF_NEAT,
                "View Arc",NULL);
  if(!*filename) return;
  view_arc(mode,cp,filename);
}


void _fastcall view_arc (int mode,USHORT cp,char *tempstring) {

  /* creates list-command redirection file */

  char        *string,*dostring;
  struct stat st;
  ARC_TYPE    *info;


  if (!tempstring || !*tempstring)
    return;
  string = bbs_malloc(cp,1027);
  if(!string) return;
  dostring = bbs_malloc(cp,1059);
  if(!dostring) {
    bbs_free(cp,string);
    return;
  }

  if(!strchr(tempstring,'\\') && !strchr(tempstring,'/')) {
    if(user[cp]->currfilearea && user[cp]->currfilearea->dpath &&
       *user[cp]->currfilearea->dpath) {
      sprintf (string, "%s\\%s",user[cp]->currfilearea->dpath ,tempstring);
    }
    else *string = 0;
    if(stat(string,&st)) {

      FILEAREA *finfo;

      finfo = next_file_area(fileareas,cp,0,0);
      while(finfo && finfo->password && *finfo->password) {
          finfo = next_file_area(finfo,cp,1,0);
      }
      if(finfo) {
        do {
          if(finfo->dpath && *finfo->dpath) {
            sprintf (string, "%s\\%s",finfo->dpath ,tempstring);
            if(!stat(string,&st)) break;
          }
          do {
            finfo = next_file_area(finfo,cp,1,0);
          } while(finfo && finfo->password && *finfo->password);
        } while(finfo);
      }
    }
  }
  else strcpy(string,tempstring);

  if (!stat(string, &st)) {
    info = find_type(string);
    if(!info) {
      readtext (mode,cp,string);
      bbs_free(cp,dostring);
      bbs_free(cp,string);
      return;
    }
    else {
      forkf(mode,cp,0,"%s /C READARC.CMD %s %s >.\\%08x.ALT",
            getenv("COMSPEC"),info->list,string,*_threadid);
    }
    DosSleep(1L);
    sprintf(dostring,".\\%08x.ALT",*_threadid);
    if(!stat(dostring,&st)) {
      if(info->startlist && info->endlist && info->fnpos >= 0)
        readarc(mode,cp,dostring,string,info);
      else
        readtext(mode,cp,dostring);
      unlink(dostring);
    }
    else
      sayp(mode,cp,281,NULL,0); /* list attempt failed */
    bbs_free(cp,dostring);
    bbs_free(cp,string);
    return;
  }
  else {
    sayp(mode,cp,282,NULL,0); /* archive not found */
  }
  bbs_free(cp,dostring);
  bbs_free(cp,string);
  return;
}


char * _fastcall readarc (int mode,USHORT cp,char *filename,char *arcname,
                          ARC_TYPE *info) {

  /* displays file created by redirection of archiver's list command */

  int    handle;
  char   s[256],*osize,*nsize,*fdate,*fname,*p,*pp,**fnames;
  int    x,gotstart,highest,numfiles,numlines;

  dputs(mode,cp,"\r\n");
  fnames = bbs_malloc(cp,sizeof(char *) * 250);

  handle = bbs_sopen(cp,filename,O_RDONLY | O_BINARY,SH_DENYNO);
  if(handle == -1) {
    bbs_free(cp,fnames);
    return NULL;
  }

  highest = info->osizepos;
  if(info->nsizepos > highest) highest = info->nsizepos;
  if(info->fdpos > highest) highest = info->fdpos;
  if(info->fnpos > highest) highest = info->fnpos;

  gotstart = numfiles = numlines = 0;
  while(!eof(handle) && numfiles < 250) {
    if(!fgetsx(s,255,handle)) break;
    stripcr(s);
    if(!gotstart) {
      if(!strcmp(s,info->startlist)) gotstart++;
      continue;
    }
    if(!strcmp(s,info->endlist)) break;
    lstrip(s);
    rstrip(s);
    if(!*s) continue;
    nsize = fname = NULL;
    osize = fdate = "";
    p = s;
    for(x = 0;x < highest + 1;x++) {
      pp = skip_white(p);
      if(!*pp) break;
      p = to_delim(pp," ");
      if(*p) {
        *p = 0;
        p++;
      }
      if(x == info->nsizepos)
        nsize = pp;
      else if(x == info->osizepos)
        osize = pp;
      else if(x == info->fdpos) {
        fdate = pp;
        if(info->fdflds > 1) {

          int y;

          if(*p) {
            p--;
            *p = ' ';
            for(y = 0;y < info->fdflds - 1;y++) {
              p = skip_white(p);
              p = skip_nonwhite(p);
              x++;
            }
            if(*p) {
              *p = 0;
              p++;
            }
          }
        }
      }
      else if(x == info->fnpos)
        fname = pp;
    }
    if(fname) {
      if(++numlines > user[cp]->length - 2) {
        if(do_more(mode,cp)) break;
        numlines = 0;
      }
      dprintf(mode,cp,"%3u  %-20.20s",numfiles + 1,fname);
      if(fdate)
        dprintf(mode,cp,"  %-15.15s",fdate);
      if(osize)
        dprintf(mode,cp,"  %-13.13s",osize);
      if(nsize)
        dprintf(mode,cp,"  %s",nsize);
      dputs(mode,cp,"\r\n");
      if(fnames)
        fnames[numfiles] = bbs_strdup(cp,fname);
      numfiles++;
    }
  }
  close(handle);
  dputs(mode,cp,"\r\n");

  if(numfiles) {
    for(;;) {

      char member[21];
      int  memnum;

      *member = 0;
      pinput_string(mode,cp,member,20,1,284,STRT_JUSTFILE,STRF_NEAT,
                    "View Arc Member",NULL);
      dputs(mode,cp,"\r\n");
      if(*member) {
        memnum = atoi(member);
        if(memnum > 0 && memnum < numfiles + 1 && fnames && fnames[memnum]) {
          memnum = view_arc_member(mode,cp,arcname,fnames[memnum - 1],info);
        }
        else {
          memnum = view_arc_member(mode,cp,arcname,member,info);
        }
        if(memnum == -1) {
          sayp(mode,cp,285,NULL,0); /* extract attempt failed */
        }
      }
      else break;

      if(fnames) {
        for(x = 0;x < numfiles;x++) {
          if(fnames[x]) {
            if(!(x % 2)) dputs(mode,cp,"\r\n");
            else dputs(mode,cp,"    ");
            dprintf(mode,cp,"%3u  %-22.22s",x + 1,fnames[x]);
          }
        }
      }
    }
  }

/* CleanUp */

  if(fnames) {
    for(x = 0;x < numfiles;x++) {
      if(fnames[numfiles])
        bbs_free(cp,fnames[numfiles]);
    }
    bbs_free(cp,fnames);
  }

  return NULL;
}


int _fastcall view_arc_member (int mode,USHORT cp,char *arcname,char *member,
                               ARC_TYPE *info) {

  char        *s;
  struct stat st;

  if(!info->extract) return -1;

  s = bbs_malloc(cp,290);
  if(!s) return -1;

  sprintf(s,".\\ARCTMP.%03u",cp);
  if(mkdir(s)) {
    bbs_free(cp,s);
    return -1;
  }

  forkf(mode,cp,0,"%s /C EXTRACT.CMD %s %s %s %s",
        getenv("COMSPEC"),s,info->extract,arcname,member);
  DosSleep(1L);

  sprintf(s,".\\ARCTMP.%03u\\%s",cp,member);
  if(!stat(s,&st)) {
    readtext(mode,cp,s);
    sprintf(s,".\\ARCTMP.%03u\\*",cp);
    unlink_all(s);
    sprintf(s,".\\ARCTMP.%03u",cp);
    rmdir(s);
    bbs_free(cp,s);
    return 0;
  }

  sprintf(s,".\\ARCTMP.%03u\\*",cp);
  unlink_all(s);
  sprintf(s,".\\ARCTMP.%03u",cp);
  rmdir(s);
  bbs_free(cp,s);
  return -1;
}
