/*************************************************/
/* This module handles Wazoo requests, received  */
/* translates as req'd to use part of bark rtns  */
/* in recvbark.c                                 */
/* reqs are stored locally in wazoo format and   */
/* translated to bark (if necessary) on send, so */
/* no special wazoo send routines req'd          */
/*************************************************/

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "mailer.h"
#include "bbs.h"
#include "transfer.h"
#include "nodelist.h"
#include "modem.h"
#include "timers.h"
#include "keys.h"
#include "xmisc.h"

    extern int  *_threadid;
    extern MDM  *modems[MAXINSTANCES];
    extern BBS  *bbs;


long _fastcall wazoo_reqs (USHORT cp,ADDR *addr,ADDR *myaddr) {

  char        *s,*p,*pp,sign = 0,*oargs = NULL;
  struct stat  st;
  int          handle;
  long         sent_bytes = 0L;
  time_t       date = 0L,starttime;

  starttime = time(NULL);
  s = (char *)malloc(1027);
  if(!s) return 0L;

  sprintf(s,"%s/%08x.REQ",bbs->inbound[modems[cp]->whichin],*_threadid);
  if(stat(s,&st)) {    /* no request file; outta here */
    free(s);
    return 0L;
  }
  if(!modems[cp]->rfreqsok) {
    logfunc(0,cp,"Refused remote's requests");
    unlink(s);
    free(s);
    return 0L;
  }

  handle = sopen(s,O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
  if(handle == -1) {
    logfunc(0,cp,"Couldn't open Wazoo request file \"%s\"",s); /* oh goddamn */
    unlink(s);
    free(s);
    return 0L;
  }

  while(!eof(handle)) {
    if(!fgetsx(s,1024,handle)) break;
    sign = 0;
    date = 0L;
    stripcr(s);
    lstrip(s);
    if((p = strchr(s,';')) != NULL) *p = 0;
    rstrip(s);
    if(!*s) continue;
    if(*s == '\x1a') break;
    if((p = strchr(s,' ')) != NULL) {
      *p = 0;
      p++;
      if(*p) {
        if(*p == '!') {
          p++;
          if(*p && (pp = strchr(p,' ')) != NULL) {
            *pp = 0;
            pp++;
            sign = (char)(*pp == '-');
            pp++;
            date = atol(pp);
            oargs = strchr(pp,' ');
          }
        }
        else {
          sign = (char)(*p == '-');
          p++;
          date = atol(p);
          pp = p;
          p = "";
          oargs = strchr(pp,' ');
        }
        if(oargs) {
          oargs = skip_white(oargs);
          if(!*oargs) oargs = NULL;
        }
      }
    }
    else p = "";
    if(!*s) continue;
    sent_bytes += send_req_file(cp,s,sign,
                                date,p,1,myaddr,addr,oargs);
    if(modems[cp]->maxmailk) {
      if((sent_bytes / 1024L) > modems[cp]->maxmailk) {
        logfunc(0,cp,"Maximum freq kbytes exceeded");
        break;
      }
    }
    if(modems[cp]->maxmailtime) {
      if((time(NULL) - starttime) > modems[cp]->maxmailtime) {
        logfunc(0,cp,"Maximum freq time exceeded");
        break;
      }
    }
    if(!com_online(cp) && checkcarrier(cp)) break;
  }

  close(handle);
  sprintf(s,"%s/%08x.REQ",bbs->inbound[modems[cp]->whichin],*_threadid);
  if(!unlink(s)) logfunc(0,cp,"Unlinked Wazoo request file \"%s\"",s);
  else logfunc(0,cp,"Couldn't unlink Wazoo request file \"%s\"",s);
  free(s);

  return sent_bytes;
}
