#include <io.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <share.h>
#include "mailer.h"
#include "bbs.h"
#include "keys.h"
#include "xmisc.h"


#define MAXRELATES 50


    extern MDM            *modems[MAXINSTANCES];
    extern USER           *user[MAXINSTANCES];
    extern BBS            *bbs;

    int                   helpkey = TAB;


/* 'Hypertext' help */


int _pascal send_help (int mode,USHORT cp,char *the_topic,char *helpfile) {

    unsigned int count;
    char         ln[134],topic[82],*p,foundhelp;
    char         *related[MAXRELATES + 1];
    int          fh,x,y,numrelated = 0,len;


    if(helpfile == NULL || !*helpfile)
      sprintf(modems[cp]->builddir,"%s/XBBS.HLP",d_help);
    else {
      sprintf(modems[cp]->builddir,"%s/%s",d_help,helpfile);
      if(!strchr(helpfile,'.'))
        strcat(modems[cp]->builddir,".HLP");
    }
    helpfile = modems[cp]->builddir;
    fh = bbs_sopen(cp,helpfile,O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
    if(fh == -1)
      goto ErrorNotFound;

    for(x = 0;x < MAXRELATES;x++)
      related[x] = NULL;

    strncpy(topic,the_topic,80);
    topic[80] = 0;

NextTopic:

    if(bbs && (bbs->attribs & B_LOGALLHELP))
        logfunc(1,cp,"Help read: \"%s\" in helpfile \"%s\"",topic,helpfile);

    dputs(mode,cp,"\r\n");

    foundhelp = 0;
    x = 0;

    while(!foundhelp && !eof(fh)) {

        char busy_string[] = "\\|/-";

        dprintf(mode,cp,"%c\b",busy_string[(x & 3)]);
        x++;

        if(!fgetsx(ln,133,fh)) break;

        if (!strncmp(ln,">>end",5)) {
            goto ErrorNotFound;
        }

        if (*ln == '>' && ln[1] == '>') { /* Topics (">>topic name") */
            ln[132] = 0;
            p = &ln[2];
            stripcr(p);
            rstrip(p);
            if(!stricmp(p,topic)) foundhelp++;
        }
    }

    dputs(mode,cp," \b");

    if(!foundhelp)
        goto ErrorNotFound;

    count = 0;

    while(!eof(fh)) {
        if(!fgetsx(ln,133,fh))
          break;
        ln[132] = 0;

        if(*ln == '.' && ln[1] == '.') {    /* Actions ("..key data") */

            stripcr(ln);
            rstrip(ln);
            lstrip(&ln[2]);

            if(!strnicmp(&ln[2],"related ",8)) {
                p = strchr(&ln[2],' ');
                if(p) {
                    p = skip_white(p);
                    if(*p) {
                        related[numrelated] = bbs_strdup(cp,p);
                        if(related[numrelated]) numrelated++;
                    }
                }
                continue;
            }

            else if(!stricmp(&ln[2],"pause")) {
                hitreturn(mode,cp);
                count = 0;
                continue;
            }

            else if(!strnicmp(&ln[2],"display ",8)) {
                p = strchr(&ln[2],' ');
                if(p) {
                    p = skip_white(p);
                    if(*p) {
                        readtext(mode,cp,p);
                        count = 0;
                    }
                }
                continue;
            }

            else if(!strnicmp(&ln[2],"newtopic ",9)) {
                p = strchr(&ln[2],' ');
                if(p) {
                    p = skip_white(p);
                    if(*p) {
                        strncpy(topic,p,80);
                        goto TopicInterruptus;
                    }
                }
                continue;
            }

            else if(!stricmp(&ln[2],"abort")) {
                dputs(mode,cp,"\r\n");
                goto PrematureBurial;
            }

            else if(!strnicmp(&ln[2],"sleep ",6)) {
                p = strchr(&ln[2],' ');
                if(p) {
                    p = skip_white(p);
                    if(*p) {
                        DosSleep(atol(p));
                    }
                }
                continue;
            }

            else if(!strnicmp(&ln[2],"comment ",8)) {
                continue;
            }

            else if(!strnicmp(&ln[2],"Yesorabort ",11)) {
                p = strchr(&ln[2],' ');
                if(p) {
                    p = skip_white(p);
                    if(*p) {
                        sprintf(topic,"%s (Y/n) ",p);
                        if(*input_string(mode,cp,ln,1,1,topic,
                                         STRT_YN,STRF_UCASE | STRF_HOT,
                                         NULL,NULL) == 'N') {
                            dputs(mode,cp,"\r\n");
                            goto PrematureBurial;
                        }
                        dputs(mode,cp,"\r\n");
                    }
                }
                continue;
            }

            else if(!strnicmp(&ln[2],"Yesorstop ",10)) {
                p = strchr(&ln[2],' ');
                if(p) {
                    p = skip_white(p);
                    if(*p) {
                        sprintf(topic,"%s (Y/n) ",p);
                        if(*input_string(mode,cp,ln,1,1,topic,
                                         STRT_YN,STRF_UCASE | STRF_HOT,
                                         NULL,NULL) == 'N') {
                            dputs(mode,cp,"\r\n");
                            goto EndIt;
                        }
                        dputs(mode,cp,"\r\n");
                    }
                }
                continue;
            }

            continue;   /* unrecognized action skipped */
        }

        if(*ln == '>' && ln[1] == '>')
          break;   /* Next label; stop */

        len = dputs(mode,cp,ln);

        if(!(user[cp]->attribs & U_NOMORE)) {
            if(len > (int)user[cp]->width) count++;
            count++;
            if(count >= user[cp]->length-1) {
                count = 0;
                if(do_more(mode,cp))
                  break;
            }
        }
        else {
            len = toupper(inkey(mode,cp));
            if(len) {
                if(len == 'P' || len == CTRL_S) mpause(mode,cp);
                else if(len == 'S' || len == CTRL_Q) break;
            }
        }
    }

    if(!(user[cp]->attribs & U_NOMORE)) {
       if(count > user[cp]->length - 4) {
            hitreturn(mode,cp);
        }
    }

EndIt:

    if(numrelated) {
        sprintf(ln,"\r\n%d Related topic%s (or CTRL-K):  ",numrelated,&"s"[numrelated == 0]);
        y = select_one(mode,cp,related,numrelated,ln,NULL,"Related Topics",((user[cp]->attribs & U_NOVICE) != 0));

        if(y >= 0) {
            strncpy(topic,related[y],80);

TopicInterruptus:

            topic[80] = 0;
            x = 0;
            for(x = 0;x < numrelated;x++) {
              if(related[x]) {
                bbs_free(cp,related[x]);
                related[x] = NULL;
              }
            }
            numrelated = 0;
            x = 0;
            foundhelp = 0;
            lseek(fh,0L,SEEK_SET);
            goto NextTopic;
        }
        dputs(mode,cp,"\r\n");
    }

PrematureBurial:

    x = 0;
    for(x = 0;x < numrelated;x++)
      if(related[x])
        bbs_free(cp,related[x]);
    bbs_close(cp,fh);
    return 0;

ErrorNotFound:

    if(fh != -1)
      bbs_close(cp,fh);
    dprintf(mode,cp," \b \b\r\n Sorry, nothing found on topic \"%s\".",the_topic);
    dprintf(D_LOCAL,cp," (File: \"%s\")",helpfile);
    dputs(mode,cp,"\r\n I'll inform the sysop you asked, though...\r\n");
    logfunc(1,cp,"User-requested help on \"%s\"--not found in helpfile \"%s\"",the_topic,helpfile);
    return -1;
}
