#define INCL_WIN

#include "sys/types.h"
#include "sys/stat.h"
#include "io.h"
#include "fcntl.h"
#include "share.h"
#include "mailer.h"
#include "xmisc.h"
#include "bbs.h"
#include "nodelist.h"
#include "xbbs.h"

    extern USHORT        focusline;
    extern MDM           *modems[MAXINSTANCES];
    extern BBS           *bbs;


char * translate_to_dlg (char *a) {

  char *p = a;

  while(*p) {
    if(*p == '\r') *p = '|';
    if(*p == '\n') *p = '#';
    if(*p == '\b') *p = '\\';
    p++;
  }
  return a;
}


char * translate_from_dlg (char *a) {

  char *p = a;

  while(*p) {
    if(*p == '|') *p = '\r';
    if(*p == '#') *p = '\n';
    if(*p == '\\') *p = '\b';
    p++;
  }
  return a;
}



MRESULT EXPENTRY IDDlgBoxProc (HWND hwndDlg,USHORT msg,
                               MPARAM mp1,MPARAM mp2) {

    int             rc;
    static MDM     *mdm;
    char            s[162];


    switch(msg) {
        case WM_INITDLG:
            mdm = (MDM *)mp2;
            WinSendDlgItemMsg(hwndDlg, CID_SYSTEM, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(49,0), NULL);
            WinSendDlgItemMsg(hwndDlg, CID_SYSOP, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(19,0), NULL);
            WinSendDlgItemMsg(hwndDlg, CID_BANNER, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(160,0), NULL);
            WinSendDlgItemMsg(hwndDlg, CID_MAILONLY, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(160,0), NULL);
            WinSendDlgItemMsg(hwndDlg, CID_TOOSLOW, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(160,0), NULL);
            WinSendDlgItemMsg(hwndDlg, CID_ANSWER, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(63,0), NULL);
            WinSendDlgItemMsg(hwndDlg, CID_INIT, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(127,0), NULL);
            WinSendDlgItemMsg(hwndDlg, CID_DIALPRE, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(127,0), NULL);
            WinSendDlgItemMsg(hwndDlg, CID_DIALSUF, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(31,0), NULL);
            WinSetWindowText(WinWindowFromID(hwndDlg,CID_SYSTEM),bbs->bbs_name);
            WinSetWindowText(WinWindowFromID(hwndDlg,CID_SYSOP),bbs->sysop);
            strcpy(s,mdm->banner);
            translate_to_dlg(s);
            WinSetWindowText(WinWindowFromID(hwndDlg,CID_BANNER),s);
            strcpy(s,mdm->mailonly);
            translate_to_dlg(s);
            WinSetWindowText(WinWindowFromID(hwndDlg,CID_MAILONLY),s);
            strcpy(s,mdm->tooslow);
            translate_to_dlg(s);
            WinSetWindowText(WinWindowFromID(hwndDlg,CID_TOOSLOW),s);
            WinSetWindowText(WinWindowFromID(hwndDlg,CID_ANSWER),mdm->answer);
            WinSetWindowText(WinWindowFromID(hwndDlg,CID_INIT),mdm->init);
            WinSetWindowText(WinWindowFromID(hwndDlg,CID_DIALPRE),mdm->dpre);
            WinSetWindowText(WinWindowFromID(hwndDlg,CID_DIALSUF),mdm->dsuf);
            break;

        case WM_COMMAND:
            switch(SHORT1FROMMP(mp1)) {
                case CID_OKAY:
                    rc = WinQueryWindowText(WinWindowFromID(hwndDlg, CID_SYSTEM), 50, s);
                    if (rc > 0) {
                      s[49] = 0;
                      lstrip(rstrip(s));
                      strcpy(bbs->bbs_name,s);
                    }
                    rc = WinQueryWindowText(WinWindowFromID(hwndDlg, CID_SYSOP), 20, s);
                    if (rc > 0) {
                      s[19] = 0;
                      lstrip(rstrip(s));
                      strcpy(bbs->sysop,s);
                    }
                    rc = WinQueryWindowText(WinWindowFromID(hwndDlg, CID_BANNER), 161, s);
                    if (rc > 0) {
                      s[160] = 0;
                      lstrip(rstrip(s));
                      translate_from_dlg(s);
                      strcpy(mdm->banner,s);
                    }
                    rc = WinQueryWindowText(WinWindowFromID(hwndDlg, CID_MAILONLY), 161, s);
                    if (rc > 0) {
                      s[160] = 0;
                      lstrip(rstrip(s));
                      translate_from_dlg(s);
                      strcpy(mdm->mailonly,s);
                    }
                    rc = WinQueryWindowText(WinWindowFromID(hwndDlg, CID_TOOSLOW), 161, s);
                    if (rc > 0) {
                      s[160] = 0;
                      lstrip(rstrip(s));
                      translate_from_dlg(s);
                      strcpy(mdm->tooslow,s);
                    }
                    rc = WinQueryWindowText(WinWindowFromID(hwndDlg, CID_ANSWER), 64, s);
                    if (rc > 0) {
                      s[63] = 0;
                      lstrip(rstrip(s));
                      strcpy(mdm->answer,s);
                    }
                    rc = WinQueryWindowText(WinWindowFromID(hwndDlg, CID_INIT), 128, s);
                    if (rc > 0) {
                      s[127] = 0;
                      lstrip(rstrip(s));
                      strcpy(mdm->init,s);
                    }
                    rc = WinQueryWindowText(WinWindowFromID(hwndDlg, CID_DIALPRE), 128, s);
                    if (rc > 0) {
                      s[127] = 0;
                      lstrip(rstrip(s));
                      strcpy(mdm->dpre,s);
                    }
                    rc = WinQueryWindowText(WinWindowFromID(hwndDlg, CID_DIALSUF),32, s);
                    if (rc > 0) {
                      s[31] = 0;
                      lstrip(rstrip(s));
                      strcpy(mdm->dsuf,s);
                    }
                    WinDismissDlg(hwndDlg,0);
                    break;

                case DID_CANCEL:
                case CID_CANCEL:
                    WinDismissDlg(hwndDlg, 0);
                    return MRFROMSHORT(1);

                case CID_HELP:
                    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
                                  "| = carriage return (all but system, sysop)\r# = line feed (banner, mailonly, too slow)\r\\ = backspace (banner, mailonly, too slow)\r"
                                  "  for modem strings:\r~ = 1 sec delay\r` = 1/10 sec delay\r^ = raise DTR\rv = lower DTR\r\\ = \"escape\" character",
                                  "Translated keys:",0,MB_OK | MB_MOVEABLE);
                    return MRFROMSHORT(0);

                default:
                    WinDismissDlg(hwndDlg,0);
                    return MRFROMSHORT(1);
            }

        case WM_CLOSE:
            WinDismissDlg(hwndDlg, 0);
            break;
    }

    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}

