#define INCL_WIN

#include <process.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <direct.h>
#include <io.h>
#include "mailer.h"
#include "modem.h"
#include "bbs.h"
#include "xmisc.h"
#include "xbbs.h"
#include "window.h"

    extern MDM           *modems[MAXINSTANCES];
    extern USER          *user[MAXINSTANCES];
    extern BBS           *bbs;
    extern unsigned long quoteSEM;
    extern int           *_threadid;
    extern HWND          xdhwnd;
    extern USHORT        focusline;
    extern long          fakekeySEM[MAXINSTANCES];
    extern long          userread[MAXINSTANCES];
    extern char          numpages[MAXINSTANCES];
    extern BOOL          fRexxOK;

    unsigned long        exportSEM[MAXINSTANCES];



void crankup_bbs (void *m) {

    USHORT cp = *(USHORT *)m;
    static char *stars = "*********************************************************";
    char        segname[48];
    SEL         utemp;
    int         bbs_thread;

    DosSemClear(&fakekeySEM[cp]);
    fakekeySEM[cp] = 0L;
    zero_keys(cp);
    modems[cp]->VidHandle = -1;
    if(cp == 0) {
      DosSetPrty(2,bbs->localbbs[0],bbs->localbbs[1],*_threadid);
      DosSleep(1000L);
    }
    else {
      if(modems[cp]->curbaud)
        if(checkcarrier(cp))
          return;
      DosSetPrty(2,modems[cp]->bbs[0],modems[cp]->bbs[1],*_threadid);
    }

    sprintf(segname,"\\SHAREMEM\\XBBS\\USER.%u",cp);
    if(!DosAllocShrSeg(sizeof(USER),segname,&utemp))
      user[cp] = (USER *)MAKEP(utemp,0);
    else {
      sayn(D_LOCAL,cp,238,NULL,0);
      return;
    }

    memset(user[cp],0,sizeof(USER));
    user[cp]->lastread = NULL;
    {
      int x;

      for(x = 0;x < 10;x++) {
        user[cp]->from[x] = user[cp]->to[x] = user[cp]->subj[x] =
        user[cp]->msgid[x] = user[cp]->reply[x] = user[cp]->body[x] = NULL;
      }
    }

Again:

    strset(modems[cp]->laststring,0);

    if(cp) {
      logfunc(1,cp,stars);
      sayn(D_LOCAL,cp,239,NULL,0);
      Change_Status("In BBS");
      modems[cp]->checkcd = 1;
    }

    DosSemClear(&modems[cp]->amdonexportingSEM);
    numpages[cp] = 0;
    userread[cp] = 0;

    init_memhandles(cp);
    init_filehandles(cp);
    init_bbsfindhandles(cp);

    modems[cp]->afmsg = pgetarray(cp,125,23);

    {
      char s[11];

      sayn(D_LOCAL,cp,95,s,10);
      modems[cp]->YES = *s;
      modems[cp]->NO = s[1];
      modems[cp]->STOP = s[2];
      modems[cp]->PAUSE = s[3];
      modems[cp]->QUIT = s[4];
    }

    DosSemSet(&modems[cp]->bbsrunningSEM);
    modems[cp]->inchat = 0;
    if(cp) {
      WinPostMsg(xdhwnd,WM_USERONLINE,MPFROM2SHORT(cp,0),MPFROMLONG(0L));
      DosSleep(132L);
    }
    if((bbs_thread = _beginthread(do_bbs,NULL,49152U,(void *)&cp)) != -1) {
      DosSemWait(&modems[cp]->bbsrunningSEM,-1L);
      sayn(D_LOCAL,cp,269,NULL,0);
      DosSleep(128L);
    }
    else {
      DosSemClear(&modems[cp]->bbsrunningSEM);
      sayn(D_LOCAL,cp,240,NULL,0);
    }

    if(cp) {
      if(cp && user[cp]->offline < time(NULL))
        sayn(D_LOCAL,cp,241,NULL,0);
      flushout(cp);
      dropDTR(cp);
      sayn(D_LOCAL,cp,242,NULL,0);
      logfunc(1,cp,stars);
      modems[cp]->curbaud = 0;
    }
    user[cp]->offline = time(NULL) + (4L * 60L);
    DosSemClear(&modems[cp]->pipereadSEM);

    if(fRexxOK) {

      char        s[81];
      struct stat st;

      sprintf(modems[cp]->builddir,"%s/ATEND%u.CMD",d_menu,cp);
      if(!stat(modems[cp]->builddir,&st) && st.st_size > 0L) {
        sprintf(s,"ATEND%u.CMD",cp);
        RexxScriptFile(D_LOCAL,cp,s);
      }
      else {
        sprintf(modems[cp]->builddir,"%s/ATEND.CMD",d_menu);
        if(!stat(modems[cp]->builddir,&st) && st.st_size > 0L)
          RexxScriptFile(D_LOCAL,cp,"ATEND.CMD");
      }
    }

    WinPostMsg(xdhwnd,WM_USEROFFLINE,MPFROM2SHORT(cp,0),MPFROMLONG(0L));
    DosSetPrty(2,modems[cp]->mailer[0],modems[cp]->mailer[1],*_threadid);
    modems[cp]->inchat = 0;
    DosSemClear(&quoteSEM);
    DosSemClear(&modems[cp]->pipereadSEM);

    user[cp]->last_logon = time(NULL);
    user[cp]->numcalls++;
    if(user[cp]->number) {
      modems[cp]->wasbbs = 1;
      Change_Last();
      user[cp]->time_today += (user[cp]->offline - user[cp]->online);
      save_user(user[cp]->number,cp,user[cp]);
      if(user[cp]->lastread)
        save_lastread(cp,user[cp]->lastread,user[cp]->number);
    }

    bbs_freeall(cp);
    bbs_freefindhandles(cp);
    bbs_freefilehandles(cp);

    user[cp]->lastread = NULL;

    save_bbs(0);
    *modems[cp]->name = 0;

    if(bbs_thread != -1) {  /* clean up temp files, directories */

      char s[290];

      sprintf(s,"./FILESEND.%03u",cp);
      unlink(s);
      sprintf(s,"./FILESENT.%03u",cp);
      unlink(s);
      sprintf(s,"./FILEDESC.%03u",cp);
      unlink(s);
      sprintf(s,"./%08x.ALT",bbs_thread);
      unlink(s);
      sprintf(s,"./MSGTMP.%03u",cp);
      unlink(s);
      sprintf(s,"./ARCTMP.%03u/*",cp);
      unlink_all(s);
      sprintf(s,"./ARCTMP.%03u",cp);
      rmdir(s);
    }

    if(!cp) {
      if(focusline == 0) {
        WinPostMsg(xdhwnd,WM_COMMAND,MPFROM2SHORT(IDM_NEXT,0),(MPARAM)0);
        Say_General("");
        DosSleep(1000L);
      }
      goto Again;
    }

    modems[cp]->checkcd = 0;

    DosFreeSeg(utemp);
    user[cp] = NULL;
}



void do_bbs (void *m) {

  USHORT cp = *(USHORT *)m;
  int    mode = (((modems[cp]->curbaud != 0) * D_REMOTE) + D_LOCAL);
  int quotecolor = 15;
  char color[30];

  WinPostMsg(xdhwnd,WM_BBSMESSAGE,MPFROM2SHORT(cp,0),MPFROMP("Login"));
  if(!do_login(mode,cp)) {

    struct stat st;

    WinPostMsg(xdhwnd,WM_BBSMESSAGE,MPFROM2SHORT(cp,0),MPFROMP("In BBS"));
    if(fRexxOK) {
      sprintf(modems[cp]->builddir,"%s/MAIN%u.CMD",d_menu,cp);
      if(!stat(modems[cp]->builddir,&st) && st.st_size > 0L) {
        sprintf(color,"MAIN%u.CMD",cp);
        RexxScriptFile(mode,cp,color);
        goto Logoff;
      }
      else {
        sprintf(modems[cp]->builddir,"%s/MAIN.CMD",d_menu);
        if(!stat(modems[cp]->builddir,&st) && st.st_size > 0L) {
          RexxScriptFile(mode,cp,"MAIN.CMD");
          goto Logoff;
        }
      }
    }

    sprintf(modems[cp]->builddir,"%s/MAIN%u.MNU",d_menu,cp);
    if(!stat(modems[cp]->builddir,&st) && st.st_size > 0L) {
      sprintf(color,"MAIN%u.MNU",cp);
      menu_drvr(mode,cp,color,0,0);
    }
    else {
      sprintf(modems[cp]->builddir,"%s/MAIN.MNU",d_menu);
      if(!stat(modems[cp]->builddir,&st) && st.st_size > 0L)
        menu_drvr(mode,cp,"MAIN.MNU",0,0);
      else
        interface1(mode,cp);
    }

Logoff:

    WinPostMsg(xdhwnd,WM_BBSMESSAGE,MPFROM2SHORT(cp,0),MPFROMP("Logoff"));
    if(bbs->attribs & B_LOGOFFQUOTE) {
      if(user[cp]->attribs & U_COLOR) {
        MAKE_ANSI(quotecolor,color);
        dputs(mode,cp,color);
      }
      say_quote(mode,cp);
      if(!cp)
        hitreturn(mode,cp);
      else
        DosSleep(2000L);
    }
    else
      dputs(mode,cp,"\r\n");
  }

  DosSleep(32L);
  DosSemClear(&modems[cp]->bbsrunningSEM);
}
