#define INCL_DOSERRORS
#define INCL_WIN

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "mailer.h"
#include "bbs.h"
#include "modem.h"
#include "xmisc.h"
#include "xbbs.h"
#include "keys.h"
#include "transfer.h"

    ULONG subFrameFlags = FCF_SIZEBORDER | FCF_SYSMENU | FCF_TITLEBAR |
                          FCF_MINMAX | FCF_ICON;
    ULONG bbsFrameFlags = FCF_SYSMENU | FCF_TITLEBAR | FCF_MINBUTTON |
                          FCF_ICON | FCF_MENU | FCF_BORDER | FCF_ACCELTABLE;
    HWND                 hwndTransfer[MAXINSTANCES],hwndStatus[MAXINSTANCES],
                         hwndLog[MAXINSTANCES],hwndOutbound,
                         hwndBBS[MAXINSTANCES];
    HWND                 xdhwnd = (HWND)0;
    int                  inshutdown = 0;
    char                 deadlines[MAXINSTANCES];
    ADDR                 poll;
    OUTBOUND             *maSelected = NULL;
    ULONG                dlgcolor;
    extern HAB           hab;
    extern OUTBOUND      *outdlgout;
    extern unsigned long ScanningSEM;
    extern OUTBOUND      *outs;
    extern USHORT        numcrank;
    extern USHORT        skipcrank;
    extern USHORT        focusline;
    extern unsigned long localBBSSEM;
    extern unsigned long callnowSEM[MAXINSTANCES];
    extern unsigned long killlogSEM[MAXINSTANCES];
    extern unsigned long initSEM[MAXINSTANCES];
    extern unsigned long mailSEM[MAXINSTANCES];
    extern unsigned long pollnowSEM[MAXINSTANCES];
    extern unsigned long scannowSEM[MAXINSTANCES];
    extern unsigned long InactiveSEM[MAXINSTANCES];
    extern int           *_threadid;
    extern unsigned long EndMeSEM[MAXINSTANCES];
    extern ADDR          *addresses;
    extern MDM           *modems[MAXINSTANCES];
    extern USER          *user[MAXINSTANCES];
    extern BBS           *bbs;
    extern unsigned long killmeyoubastardSEM;
    extern HWND          hwndFrame;

    MRESULT EXPENTRY AboutDlgBoxProc(HWND hwndDlg, USHORT msg,
                                     MPARAM mp1,MPARAM mp2);

    extern MRESULT EXPENTRY EditorsDlgBoxProc (HWND hwndDlg,USHORT msg,
                                               MPARAM mp1,MPARAM mp2);
    extern MRESULT EXPENTRY BBSFrameProc (HWND hwndDlg,USHORT msg,
                                          MPARAM mp1,MPARAM mp2);
    extern MRESULT EXPENTRY PollDlgBoxProc (HWND hwndDlg,USHORT msg,
                                            MPARAM mp1,MPARAM mp2);
    extern MRESULT EXPENTRY GetFilesDlgBoxProc (HWND hwndDlg,USHORT msg,
                                                MPARAM mp1,MPARAM mp2);
    extern MRESULT EXPENTRY OutDlgBoxProc (HWND hwndDlg,USHORT msg,
                                           MPARAM mp1,MPARAM mp2);
    extern MRESULT EXPENTRY IDDlgBoxProc (HWND hwndDlg,USHORT msg,
                                          MPARAM mp1,MPARAM mp2);
    extern MRESULT EXPENTRY DialDlgBoxProc (HWND hwndDlg,USHORT msg,
                                            MPARAM mp1,MPARAM mp2);
    extern MRESULT EXPENTRY PriDlgBoxProc (HWND hwndDlg,USHORT msg,
                                           MPARAM mp1,MPARAM mp2);
    extern MRESULT EXPENTRY MdmDlgBoxProc (HWND hwndDlg,USHORT msg,
                                           MPARAM mp1,MPARAM mp2);
    extern MRESULT EXPENTRY Misc2DlgBoxProc (HWND hwndDlg,USHORT msg,
                                             MPARAM mp1, MPARAM mp2);
    extern MRESULT EXPENTRY Misc3DlgBoxProc (HWND hwndDlg,USHORT msg,
                                             MPARAM mp1, MPARAM mp2);
    extern MRESULT EXPENTRY UserDlgBoxProc (HWND hwndDlg,USHORT msg,
                                            MPARAM mp1, MPARAM mp2);


VOID _fastcall ArrangeIcons (HWND hwndClient) {

  HENUM  henum;
  HWND   hwndChild;
  SWP    swp,swpC;
  USHORT x = 12,y = 18;

  WinQueryWindowPos(hwndClient,&swpC);
  henum = WinBeginEnumWindows(hwndClient);
  while((hwndChild = WinGetNextWindow(henum)) != (HWND)0) {
    WinQueryWindowPos(hwndChild,&swp);
    if(swp.fs & (SWP_MINIMIZE | SWP_HIDE)) {
      WinSetWindowUShort(hwndChild,QWS_XMINIMIZE,x);
      WinSetWindowUShort(hwndChild,QWS_YMINIMIZE,y);
      WinSetWindowPos(hwndChild,HWND_TOP,x,y,0,0,
                      SWP_MOVE | SWP_HIDE | SWP_FOCUSDEACTIVATE);
      WinSetWindowPos(hwndChild,HWND_TOP,x,y,0,0,
                      SWP_MOVE | SWP_SHOW | SWP_FOCUSDEACTIVATE);
      x += WinQuerySysValue(HWND_DESKTOP,SV_CXICON) + 24;
      if(x + WinQuerySysValue(HWND_DESKTOP,SV_CXICON) > swpC.cx) {
        x = 12;
        y += WinQuerySysValue(HWND_DESKTOP,SV_CYICON) + 32;
      }
    }
  }
  WinEndEnumWindows(henum);
}


void _fastcall set_menu_checks (HWND hwndMenu,USHORT fline) {

  if(!DosSemWait(&InactiveSEM[fline],0L))
    WinSendMsg(hwndMenu,MM_SETITEMATTR,
               MPFROM2SHORT(IDM_ACTIVE,1),
               MPFROM2SHORT(MIA_CHECKED,0));
  else
    WinSendMsg(hwndMenu,MM_SETITEMATTR,
               MPFROM2SHORT(IDM_ACTIVE,1),
               MPFROM2SHORT(MIA_CHECKED,MIA_CHECKED));

  WinSendMsg(hwndMenu,MM_SETITEMATTR,MPFROM2SHORT(IDM_BBS,1),
             MPFROM2SHORT(MIA_CHECKED,MIA_CHECKED * (focusline == 0)));

  {
    register USHORT x;

    for(x = 1; x < numcrank + 1;x++) {
      WinSendMsg(hwndMenu,MM_SETITEMATTR,
                 MPFROM2SHORT(LINEIDS + x,1),
                 MPFROM2SHORT(MIA_CHECKED,MIA_CHECKED * (focusline == x)));
      if(!modems[x])
        WinSendMsg(hwndMenu,MM_SETITEMATTR,
                   MPFROM2SHORT(LINEIDS + x,1),
                   MPFROM2SHORT(MIA_DISABLED,MIA_DISABLED));
    }
  }

  if(inshutdown)
    WinSendMsg(hwndMenu,MM_SETITEMATTR,
               MPFROM2SHORT(IDM_SHUTDOWN,1),
               MPFROM2SHORT(MIA_CHECKED,MIA_CHECKED));
  WinSendMsg(hwndMenu,MM_SETITEMATTR,
             MPFROM2SHORT(IDM_NOBBS,1),
             MPFROM2SHORT(MIA_CHECKED,
             ((modems[fline]->humansok == 0) *
             MIA_CHECKED)));
  WinSendMsg(hwndMenu,MM_SETITEMATTR,
             MPFROM2SHORT(IDM_FTS1ONLY,1),
             MPFROM2SHORT(MIA_CHECKED,
             ((modems[fline]->fts0001 != 0) *
             MIA_CHECKED)));
  WinSendMsg(hwndMenu,MM_SETITEMATTR,
             MPFROM2SHORT(IDM_NOSEA,1),
             MPFROM2SHORT(MIA_CHECKED,
             ((modems[fline]->nosealink != 0) *
             MIA_CHECKED)));
  WinSendMsg(hwndMenu,MM_SETITEMATTR,
             MPFROM2SHORT(IDM_NO1K,1),
             MPFROM2SHORT(MIA_CHECKED,
             ((modems[fline]->no1k != 0) *
             MIA_CHECKED)));
  WinSendMsg(hwndMenu,MM_SETITEMATTR,
             MPFROM2SHORT(IDM_NOSLO,1),
             MPFROM2SHORT(MIA_CHECKED,
             ((modems[fline]->noslo != 0) *
             MIA_CHECKED)));
  WinSendMsg(hwndMenu,MM_SETITEMATTR,
             MPFROM2SHORT(IDM_NOIN,1),
             MPFROM2SHORT(MIA_CHECKED,
             ((modems[fline]->answerok == 0) *
             MIA_CHECKED)));
  WinSendMsg(hwndMenu,MM_SETITEMATTR,
             MPFROM2SHORT(IDM_NOOUT,1),
             MPFROM2SHORT(MIA_CHECKED,
             ((modems[fline]->dialoutok == 0) *
             MIA_CHECKED)));
  WinSendMsg(hwndMenu,MM_SETITEMATTR,
             MPFROM2SHORT(IDM_SFREQS,1),
             MPFROM2SHORT(MIA_CHECKED,
             ((modems[fline]->sfreqsok != 0) *
             MIA_CHECKED)));
  WinSendMsg(hwndMenu,MM_SETITEMATTR,
             MPFROM2SHORT(IDM_RFREQ,1),
             MPFROM2SHORT(MIA_CHECKED,
             ((modems[fline]->rfreqsok != 0) *
             MIA_CHECKED)));
}


void _fastcall recall_window (HWND hwnd) {

  SWP swp;

  if(hwnd) {
    WinQueryWindowPos(ParentOf(hwnd),&swp);
    if(swp.fs & SWP_MINIMIZE)
      WinSendMsg(ParentOf(hwnd),WM_SYSCOMMAND,
                 MPFROM2SHORT(SC_RESTORE,0),0L);
    WinShowWindow(ParentOf(hwnd),TRUE);
    WinSetActiveWindow(HWND_DESKTOP,hwnd);
    WinSetFocus(HWND_DESKTOP,hwnd);
  }
}


MRESULT EXPENTRY XBBSBoxProc (HWND hwnd,USHORT msg,MPARAM mp1,
                              MPARAM mp2) {

    register USHORT x;
    static HWND     hwndMenu = (HWND)0;
    static HACCEL   xaccel;

  switch(msg) {
    case WM_CREATE:
      dlgcolor = WinQuerySysColor(HWND_DESKTOP,SYSCLR_DIALOGBACKGROUND,0L);
      xaccel = WinQueryAccelTable(hab,ParentOf(hwnd));
      hwndMenu = WinWindowFromID(ParentOf(hwnd),FID_MENU);
      xdhwnd = hwnd;
      {
        MENUITEM mi;
        char     str[12];
        SHORT    idSubMenu;
        HWND     hwndSubMenu;

        idSubMenu = SHORT1FROMMR(WinSendMsg(hwndMenu,MM_ITEMIDFROMPOSITION,
                                            MPVOID,MPVOID));
        WinSendMsg(hwndMenu,MM_QUERYITEM,MPFROM2SHORT(idSubMenu,0),
                   MPFROMP(&mi));
        hwndSubMenu = mi.hwndSubMenu;
        mi.iPosition = MIT_END;
        mi.afStyle = MIS_TEXT;
        mi.hItem = 0L;
        mi.hwndSubMenu = (HWND)0;
        for(x = 0; x < numcrank + 1;x++) {
          deadlines[x] = 0;
          hwndTransfer[x] = (HWND)0;
          hwndStatus[x] = (HWND)0;
          hwndLog[x] = (HWND)0;
          hwndOutbound = (HWND)0;
          hwndBBS[x] = (HWND)0;
          if(x > 0) {
            mi.afAttribute = (modems[x]) ? (x == focusline) ?
                             MIA_CHECKED : 0 : MIA_DISABLED;
            mi.id = LINEIDS + x;
            sprintf(str,"%s%u",(x < 10) ? "~" : "",x);
            WinSendMsg(hwndSubMenu,MM_INSERTITEM,
                       MPFROMP(&mi),MPFROMP(str));
          }
        }
      }
      memset(&poll,0,sizeof(ADDR));
      set_menu_checks(hwndMenu,focusline);
      WinPostMsg(hwnd,WM_DELAYED,MPVOID,MPVOID);
      break;

    case WM_BBSMESSAGE:
      {
        USHORT cp = SHORT1FROMMP(mp1);

        if(hwndBBS[cp])
          WinSendMsg(hwndBBS[cp],msg,mp1,mp2);
      }
      return 0;

    case WM_USERONLINE:
      {
        USHORT cp = SHORT1FROMMP(mp1);
        char   s[41];
        HWND   focushwnd;

        if(cp)
          sprintf(s,"BBS: %d",cp);
        else
          strcpy(s,"BBS: Local");
        focushwnd = WinQueryActiveWindow(HWND_DESKTOP,0);
        if(!hwndBBS[cp]) {
          if(WinCreateStdWindow(HWND_DESKTOP,0,&bbsFrameFlags,
                                "WC_XBBSBOX",s,CS_SIZEREDRAW,0,
                                BBSBOX,&hwndBBS[cp]))
            WinSetPresParam(hwndBBS[cp],PP_BACKGROUNDCOLOR,
                            (ULONG)sizeof(ULONG),
                            (PVOID)&dlgcolor);
          if(hwndBBS[cp]) {

            PFNWP oldproc;

            if(focusline == cp && (hwnd == focushwnd ||
               WinIsChild(focushwnd,hwnd)))
              focushwnd = hwndBBS[cp];
            oldproc = WinSubclassWindow(ParentOf(hwndBBS[cp]),
                                        (PFNWP)BBSFrameProc);
            WinSendMsg(ParentOf(hwndBBS[cp]),WM_SETCP,MPFROMP(oldproc),MPVOID);
            WinSendMsg(hwndBBS[cp],WM_SETCP,
                       MPFROM2SHORT(cp,0),MPFROMLONG(focushwnd));
            if(cp && focushwnd != hwndBBS[cp] && (bbs->attribs2 & B2_MINIMIZEBBS))
              WinSendMsg(WinQueryWindow(hwndBBS[cp],QW_PARENT,0),WM_SYSCOMMAND,
                         MPFROM2SHORT(SC_MINIMIZE,0),MPVOID);
            WinShowWindow(ParentOf(hwndBBS[cp]),TRUE);
          }
        }
        if(focusline == cp && (hwnd == focushwnd || WinIsChild(focushwnd,hwnd)))
          recall_window(hwndBBS[cp]);
      }
      return 0;

    case WM_USEROFFLINE:
      {
        USHORT cp = SHORT1FROMMP(mp1);

        if(hwndBBS[cp])
          WinDestroyWindow(WinQueryWindow(hwndBBS[cp],QW_PARENT,0));
        hwndBBS[cp] = (HWND)0;
      }
      return 0;

    case WM_DELAYED:
      WinSendMsg(hwnd,WM_COMMAND,MPFROM2SHORT(IDM_STARTOUTBOUNDBOX,0),
                 MPVOID);
      {
        int once = 0,oldfocus = focusline;

        for(x = 1;x < numcrank + 1;x++) {
          if(modems[x]) {
            focusline = x;
            WinSendMsg(hwnd,WM_COMMAND,MPFROM2SHORT(IDM_STARTLOGBOX,0),
                       MPVOID);
            if(once && hwndLog[x])
              WinSendMsg(WinQueryWindow(hwndLog[x],QW_PARENT,0),
                         WM_SYSCOMMAND,
                         MPFROM2SHORT(SC_MINIMIZE,0),MPVOID);
            WinSendMsg(hwnd,WM_COMMAND,MPFROM2SHORT(IDM_STARTSTATUSBOX,0),
                       MPVOID);
            if(once && hwndStatus[x])
              WinSendMsg(WinQueryWindow(hwndStatus[x],QW_PARENT,0),
                         WM_SYSCOMMAND,
                         MPFROM2SHORT(SC_MINIMIZE,0),MPVOID);
            WinSendMsg(hwnd,WM_COMMAND,MPFROM2SHORT(IDM_STARTTRANSFERBOX,0),
                       MPVOID);
            if(once && hwndTransfer[x])
              if(hwndTransfer[x])
                WinSendMsg(WinQueryWindow(hwndTransfer[x],QW_PARENT,0),
                           WM_SYSCOMMAND,
                           MPFROM2SHORT(SC_MINIMIZE,0),MPVOID);
            once++;
          }
        }
        focusline = oldfocus;
      }
      {
        char s[18];

        sprintf(s,"XBBS: %u",focusline);
        WinSetWindowText(ParentOf(hwnd),s);
      }
      WinPostMsg(hwnd,WM_AMSCANNING,0L,0L);
      return 0;

    case WM_PAINT:
      {
        RECTL rclUpdate;
        HPS hps;

        hps = WinBeginPaint(hwnd,0L,(PRECTL)&rclUpdate);
        WinFillRect(hps,(PRECTL)&rclUpdate,SYSCLR_DIALOGBACKGROUND);
        WinEndPaint(hps);
      }
      break;

    case WM_AMSCANNING:
    case WM_DONESCAN:
      if(hwndOutbound)
        /* dispatch message to appropriate subwindow */
        WinSendMsg(hwndOutbound,msg,mp1,mp2);
      else if(msg == WM_AMSCANNING && !outs && focusline)
        DosSemSet(&scannowSEM[focusline]);
      return 0;

    case WM_CLEARUD:
    case WM_TRANSFER:
      if(hwndTransfer[SHORT1FROMMP(mp1)])
        /* dispatch message to appropriate subwindow */
        WinSendMsg(hwndTransfer[SHORT1FROMMP(mp1)],msg,mp1,mp2);
      else if(mp2)
        free(mp2);
      return 0;

    case WM_LASTUSERNAME:
    case WM_LASTMAILER:
    case WM_MISC:
    case WM_BAUD:
    case WM_GENERAL:
    case WM_STATUS:
    case WM_LAST:
      if(hwndStatus[SHORT1FROMMP(mp1)])
        /* dispatch message to appropriate subwindow */
        WinSendMsg(hwndStatus[SHORT1FROMMP(mp1)],msg,mp1,mp2);
      if(msg == WM_LASTUSERNAME && hwndBBS[SHORT1FROMMP(mp1)])
        WinSendMsg(hwndBBS[SHORT1FROMMP(mp1)],msg,mp1,mp2);
      return 0;

    case WM_LOG:
        if((char *)mp2 && *(char *)mp2 && hwndLog[(SHORT1FROMMP(mp1) != -1) ?
           SHORT1FROMMP(mp1) : focusline])
          /* dispatch message to appropriate subwindow */
          WinSendMsg(hwndLog[(SHORT1FROMMP(mp1) != -1) ?
                             (SHORT1FROMMP(mp1)) : focusline],msg,mp1,mp2);
        else if((char *)mp2 && *(char *)mp2) {

          SHORT   logtype,fline = SHORT1FROMMP(mp1);
          char    datestr[12],timestr[12],*str;

          if(fline == -1)
            fline = focusline;
          str = (char *)mp2;
          logtype = SHORT2FROMMP(mp1);
          if(!(logtype & 3) || (logtype & 1)) {
            if(modems[fline] && modems[fline]->lf != -1) {
              _strdate(datestr);
              _strtime(timestr);
              ffprintf(modems[fline]->lf,"%s %s  %s\r\n",
                       datestr,timestr,str);
            }
          }
        }
        return 0;

    case WM_DEADLINE:      /* they're droppin' like flies, maw! */
      deadlines[SHORT1FROMMP(mp1)] = 1;
      if(hwndStatus[SHORT1FROMMP(mp1)])
        WinDestroyWindow(WinQueryWindow(hwndStatus[SHORT1FROMMP(mp1)],
                                        QW_PARENT,0));
      hwndStatus[SHORT1FROMMP(mp1)] = (HWND)0;
      if(hwndTransfer[SHORT1FROMMP(mp1)])
        WinDestroyWindow(WinQueryWindow(hwndTransfer[SHORT1FROMMP(mp1)],
                                        QW_PARENT,0));
      hwndTransfer[SHORT1FROMMP(mp1)] = (HWND)0;
      if(hwndLog[SHORT1FROMMP(mp1)])
        WinDestroyWindow(WinQueryWindow(hwndLog[SHORT1FROMMP(mp1)],
                                        QW_PARENT,0));
      hwndLog[SHORT1FROMMP(mp1)] = (HWND)0;
      for(x = 1;x < numcrank + 1;x++)
        if(deadlines[x] == 0 && modems[x])
          break;
      if(x >= numcrank + 1)
        WinPostMsg(ParentOf(hwnd),WM_QUIT,MPVOID,MPVOID);
      return 0;

    case WM_CLOSE:
      DosBufReset(-1);
      break;

    case WM_COMMAND:
      switch(SHORT1FROMMP(mp1)) {
        case IDM_ARRANGEICONS:
          ArrangeIcons(hwnd);
          break;

        case IDM_NEXTWINDOW:
          {
            HWND hwndFocus;

            hwndFocus = WinQueryActiveWindow(hwnd,0);
            if(hwndFocus) {
              if(hwndFocus == WinQueryWindow(hwndStatus[focusline],QW_PARENT,0))
                WinSetActiveWindow(HWND_DESKTOP,hwndTransfer[focusline]);
              else if(hwndFocus == WinQueryWindow(hwndTransfer[focusline],QW_PARENT,0))
                WinSetActiveWindow(HWND_DESKTOP,hwndLog[focusline]);
              else if(hwndFocus == WinQueryWindow(hwndLog[focusline],QW_PARENT,0))
                WinSetActiveWindow(HWND_DESKTOP,hwndOutbound);
              else
                WinSetActiveWindow(HWND_DESKTOP,hwndStatus[focusline]);
            }
            else
              WinSetActiveWindow(HWND_DESKTOP,hwndStatus[focusline]);
          }
          return 0;

        case IDM_PREVWINDOW:
          {
            HWND hwndFocus;

            hwndFocus = WinQueryActiveWindow(hwnd,0);
            if(hwndFocus) {
              if(hwndFocus == WinQueryWindow(hwndOutbound,QW_PARENT,0))
                WinSetActiveWindow(HWND_DESKTOP,hwndLog[focusline]);
              else if(hwndFocus == WinQueryWindow(hwndLog[focusline],QW_PARENT,0))
                WinSetActiveWindow(HWND_DESKTOP,hwndTransfer[focusline]);
              else if(hwndFocus == WinQueryWindow(hwndTransfer[focusline],QW_PARENT,0))
                WinSetActiveWindow(HWND_DESKTOP,hwndStatus[focusline]);
              else
                WinSetActiveWindow(HWND_DESKTOP,hwndOutbound);
            }
            else
              WinSetActiveWindow(HWND_DESKTOP,hwndOutbound);
          }
          return 0;

        case IDM_TOGGLEFRAME:
          {
            HWND hwndFocus;

            hwndFocus = WinQueryActiveWindow(hwnd,0);
            if(hwndFocus)
              WinPostMsg(hwndFocus,WM_HIDEME,MPVOID,MPVOID);
          }
          return 0;

        case IDM_MAINMENU:
          WinPostMsg(hwndMenu,MM_STARTMENUMODE,MPFROM2SHORT(0,0),
                     MPVOID);
          return 0;

        case IDM_MINALL:
          if(hwndOutbound)
            WinSendMsg(WinQueryWindow(hwndOutbound,QW_PARENT,0),
                       WM_SYSCOMMAND,
                       MPFROM2SHORT(SC_MINIMIZE,0),
                       MPVOID);
          if(hwndLog[focusline])
            WinSendMsg(WinQueryWindow(hwndLog[focusline],QW_PARENT,0),
                       WM_SYSCOMMAND,
                       MPFROM2SHORT(SC_MINIMIZE,0),MPVOID);
          if(hwndStatus[focusline])
            WinSendMsg(WinQueryWindow(hwndStatus[focusline],QW_PARENT,0),
                       WM_SYSCOMMAND,
                       MPFROM2SHORT(SC_MINIMIZE,0),MPVOID);
          if(hwndTransfer[focusline])
            WinSendMsg(WinQueryWindow(hwndTransfer[focusline],QW_PARENT,0),
                       WM_SYSCOMMAND,
                       MPFROM2SHORT(SC_MINIMIZE,0),MPVOID);
          return 0;

        case IDM_TILE:
          if(hwndOutbound)
            WinSendMsg(hwndOutbound,WM_TILE,MPVOID,MPVOID);
          if(hwndLog[focusline])
            WinSendMsg(hwndLog[focusline],WM_TILE,MPVOID,MPVOID);
          if(hwndStatus[focusline])
            WinSendMsg(hwndStatus[focusline],WM_TILE,MPVOID,MPVOID);
          if(hwndTransfer[focusline])
            WinSendMsg(hwndTransfer[focusline],WM_TILE,MPVOID,MPVOID);
          return 0;

        case IDM_STATWIDE:
          if(hwndOutbound)
            WinSendMsg(WinQueryWindow(hwndOutbound,QW_PARENT,0),
                       WM_SYSCOMMAND,
                       MPFROM2SHORT(SC_MINIMIZE,0),
                       MPVOID);
          if(hwndLog[focusline])
            WinSendMsg(hwndLog[focusline],WM_STATWIDE,MPVOID,MPVOID);
          if(hwndStatus[focusline])
            WinSendMsg(hwndStatus[focusline],WM_STATWIDE,MPVOID,MPVOID);
          if(hwndTransfer[focusline])
            WinSendMsg(hwndTransfer[focusline],WM_STATWIDE,MPVOID,MPVOID);
          return 0;

        case IDM_LOGWIDE:
          if(hwndOutbound)
            WinSendMsg(WinQueryWindow(hwndOutbound,QW_PARENT,0),
                       WM_SYSCOMMAND,
                       MPFROM2SHORT(SC_MINIMIZE,0),
                       MPVOID);
          if(hwndLog[focusline])
            WinSendMsg(hwndLog[focusline],WM_LOGWIDE,MPVOID,MPVOID);
          if(hwndStatus[focusline])
            WinSendMsg(hwndStatus[focusline],WM_LOGWIDE,MPVOID,MPVOID);
          if(hwndTransfer[focusline])
            WinSendMsg(hwndTransfer[focusline],WM_LOGWIDE,MPVOID,MPVOID);
          return 0;

        case IDM_CASCADE:
          if(hwndOutbound)
            WinSendMsg(hwndOutbound,WM_CASCADE,MPVOID,MPVOID);
          if(hwndTransfer[focusline])
            WinSendMsg(hwndTransfer[focusline],WM_CASCADE,MPVOID,MPVOID);
          if(hwndLog[focusline])
            WinSendMsg(hwndLog[focusline],WM_CASCADE,MPVOID,MPVOID);
          if(hwndStatus[focusline])
            WinSendMsg(hwndStatus[focusline],WM_CASCADE,MPVOID,MPVOID);
          return 0;

        case IDM_LOOKATBBS:
          if(hwndBBS[focusline])
            recall_window(hwndBBS[focusline]);
          else
            DosBeep(50,100);
          return 0;

        case IDM_STARTLOGBOX:
          if(!hwndLog[focusline]) {
            if(WinCreateStdWindow(hwnd,WS_VISIBLE,&subFrameFlags,
                                  "WC_XLOGBOX",(PSZ)NULL,0,0,
                                  LOGBOX,&hwndLog[focusline])) {
              WinSetPresParam(hwndLog[focusline],PP_BACKGROUNDCOLOR,
                              (ULONG)sizeof(ULONG),
                              (PVOID)&dlgcolor);
            }
            if(hwndLog[focusline])
              WinSendMsg(hwndLog[focusline],WM_SETCP,
                         MPFROMSHORT(focusline),MPVOID);
          }
          if(mp2)
            recall_window(hwndLog[focusline]);
          return 0;

        case IDM_STARTTRANSFERBOX:
          if(!hwndTransfer[focusline]) {
            if(WinCreateStdWindow(hwnd,WS_VISIBLE,&subFrameFlags,
                                  "WC_XTRANSFERBOX",(PSZ)NULL,0,0,
                                  TRANSFERBOX,&hwndTransfer[focusline])) {
              WinSetPresParam(hwndTransfer[focusline],PP_BACKGROUNDCOLOR,
                              (ULONG)sizeof(ULONG),
                              (PVOID)&dlgcolor);

            }
            if(hwndTransfer[focusline])
              WinSendMsg(hwndTransfer[focusline],WM_SETCP,
                         MPFROMSHORT(focusline),MPVOID);
          }
          if(mp2)
            recall_window(hwndTransfer[focusline]);
          return 0;

        case IDM_STARTSTATUSBOX:
          if(!hwndStatus[focusline]) {
            if(WinCreateStdWindow(hwnd,WS_VISIBLE,&subFrameFlags,
                                  "WC_XSTATUSBOX",(PSZ)NULL,0,0,
                                  STATUSBOX,&hwndStatus[focusline])) {
              WinSetPresParam(hwndStatus[focusline],PP_BACKGROUNDCOLOR,
                              (ULONG)sizeof(ULONG),
                              (PVOID)&dlgcolor);
            }
            if(hwndStatus[focusline])
              WinSendMsg(hwndStatus[focusline],WM_SETCP,
                         MPFROMSHORT(focusline),MPVOID);
          }
          if(mp2)
            recall_window(hwndStatus[focusline]);
          return 0;

        case IDM_STARTOUTBOUNDBOX:
          if(!hwndOutbound) {
            if(WinCreateStdWindow(hwnd,WS_VISIBLE,&subFrameFlags,
                                  "WC_XOUTBOUNDBOX","Outbound",0,0,
                                  OUTBOUNDBOX,&hwndOutbound)) {
              WinSetPresParam(hwndOutbound,PP_BACKGROUNDCOLOR,
                              (ULONG)sizeof(ULONG),
                              (PVOID)&dlgcolor);
            }
          }
          if(mp2)
            recall_window(hwndOutbound);
          return 0;

        case IDM_EDITU:
          if(user[focusline])
            sessionf(D_LOCAL,focusline,4,"%s /C BBSRUN.CMD XUSERPM.EXE -L%d",
                     getenv("COMSPEC"),focusline);
          else
            DosBeep(100,100);
          return 0;

        case IDM_MISC2:
          WinDlgBox(HWND_DESKTOP,hwnd,Misc2DlgBoxProc,
                    0,MC2_FRAME,modems[focusline]);
          return 0;

        case IDM_MISC3:
          WinDlgBox(HWND_DESKTOP,hwnd,Misc3DlgBoxProc,
                    0,MC3_FRAME,NULL);
          return 0;

        case IDM_USER:
          WinDlgBox(HWND_DESKTOP,hwnd,UserDlgBoxProc,
                    0,USER_FRAME,NULL);
          return 0;

        case IDM_RESTOREWINDOWS:
          set_saved_position(hwnd,"Sizepos");
          if(hwndLog[focusline])
            set_saved_position(hwndLog[focusline],"LogSizePos");
          if(hwndTransfer[focusline])
            set_saved_position(hwndTransfer[focusline],"TransSizePos");
          if(hwndStatus[focusline])
            set_saved_position(hwndStatus[focusline],"StatSizePos");
          if(hwndOutbound)
            set_saved_position(hwndOutbound,"OutSizePos");
          return 0;

        case IDM_SAVEBBS:
          save_bbs(1);
          for(x = 0;x < numcrank;x++)
            if(modems[x])
              save_mdm(x,modems[x]);
          save_position(hwnd,"Sizepos");
          if(hwndLog[focusline])
            save_position(hwndLog[focusline],"LogSizePos");
          if(hwndTransfer[focusline])
            save_position(hwndTransfer[focusline],"TransSizePos");
          if(hwndStatus[focusline])
            save_position(hwndStatus[focusline],"StatSizePos");
          if(hwndOutbound)
            save_position(hwndOutbound,"OutSizePos");
          logfunc(0,focusline,"Saved status");
          return 0;

        case IDM_HANGUP:
          if(user[SHORT1FROMMP(mp2)])
            put_key(SHORT1FROMMP(mp2),ALT_H);
          return 0;

        case IDM_LOCKOUT:
          if(user[SHORT1FROMMP(mp2)])
            put_key(SHORT1FROMMP(mp2),ALT_L);
          return 0;

        case IDM_CHAT:
          if(user[SHORT1FROMMP(mp2)])
            put_key(SHORT1FROMMP(mp2),ALT_C);
          return 0;

        case IDM_MORON:
          if(user[SHORT1FROMMP(mp2)])
            put_key(SHORT1FROMMP(mp2),ALT_M);
          return 0;

        case IDM_MORETIME:
          if(user[SHORT1FROMMP(mp2)])
            put_key(SHORT1FROMMP(mp2),ALT_PLUS);
          return 0;

        case IDM_LESSTIME:
          if(user[SHORT1FROMMP(mp2)])
            put_key(SHORT1FROMMP(mp2),ALT_MINUS);
          return 0;

        case IDM_LINE:
          WinDlgBox(HWND_DESKTOP,hwnd,MdmDlgBoxProc,
                    0,MDM_FRAME,modems[focusline]);
          return 0;

        case IDM_PRIORITY:
          WinDlgBox(HWND_DESKTOP,hwnd,PriDlgBoxProc,
                    0,PRI_FRAME,modems[focusline]);
          return 0;

        case IDM_DIAL:
          WinDlgBox(HWND_DESKTOP,hwnd,DialDlgBoxProc,
                    0,DID_FRAME,modems[focusline]);
          return 0;

        case IDM_ID:
          WinDlgBox(HWND_DESKTOP,hwnd,IDDlgBoxProc,
                    0,CID_FRAME,modems[focusline]);
          return 0;

        case IDM_HEADEDIT:
          sessionf(D_LOCAL,focusline,4,"%s /C BBSRUN.CMD HEAD2.EXE",
                   getenv("COMSPEC"));
          return 0;

        case IDM_XUSERPM:
          sessionf(D_LOCAL,focusline,4,"%s /C BBSRUN.CMD XUSERPM.EXE",
                   getenv("COMSPEC"));
          return 0;

        case IDM_MSGEDIT:
          sessionf(D_LOCAL,focusline,4,"%s /C BBSRUN.CMD MSGEDIT.EXE",
                   getenv("COMSPEC"));
          return 0;

        case IDM_FILEEDIT:
          sessionf(D_LOCAL,focusline,4,"%s /C BBSRUN.CMD FILEDIT.EXE",
                   getenv("COMSPEC"));
          return 0;

        case IDM_LIBEDIT:
          sessionf(D_LOCAL,focusline,4,"%s /C BBSRUN.CMD LIBEDIT.EXE",
                   getenv("COMSPEC"));
          return 0;

        case IDM_READLOG:
          sessionf(D_LOCAL,focusline,4,"%s /C BBSRUN.CMD LISTLOG.CMD %u",
                   getenv("COMSPEC"),focusline);
          return 0;

        case IDM_PROCLOG:
          sessionf(D_LOCAL,focusline,4,"%s /C BBSRUN.CMD PROCLOG.CMD %u",
                   getenv("COMSPEC"),focusline);
          return 0;

        case IDM_EVENTS:
          sessionf(D_LOCAL,focusline,4,"%s /C BBSRUN.CMD EVNTEDIT.CMD %u",
                   getenv("COMSPEC"),focusline);
          return 0;

        case IDM_GETFILE:
          WinDlgBox(HWND_DESKTOP,hwnd,GetFilesDlgBoxProc,0,GM_FRAME,
                    MPFROM2SHORT(focusline,0));
          return 0;

        case IDM_SENDFILE:
          sessionf(D_LOCAL,focusline,4,"%s /C BBSRUN.CMD XSENDPM.EXE",
                   getenv("COMSPEC"));
          return 0;

        case IDM_KILLLOG:
          if(focusline)
            DosSemSet(&killlogSEM[focusline]);
          return 0;

        case IDM_REINIT:
          if(focusline)
            DosSemSet(&initSEM[focusline]);
          return 0;

        case IDM_DTR:
          if(focusline) {
            doDTR(focusline,0);
            DosSleep(1000L);
            doDTR(focusline,1);
            logfunc(2,focusline,"Toggled DTR",focusline);
          }
          return 0;

        case IDM_CLEAR:
          clear_outs();
          logfunc(0,focusline,"Cleared callout counters all lines");
          WinPostMsg(hwnd, WM_AMSCANNING, 0L, 0L);
          return 0;

        case IDM_IMMCALL:
          if(focusline)
            DosSemSet(&callnowSEM[focusline]);
          return 0;

        case IDM_MAIL:
          if(focusline && *modems[focusline]->extmail)
            sessionf(D_LOCAL,focusline,5,modems[focusline]->extmail,
                     bbs->inbound[modems[focusline]->whichin]);
          return 0;

        case IDM_NEXT:
          DosEnterCritSec();
           focusline++;
          DosExitCritSec();
          while(focusline < numcrank + 1 && focusline > 0 && !modems[focusline]) {
            DosEnterCritSec();
             focusline++;
            DosExitCritSec();
          }
          if(focusline > numcrank || !modems[focusline]) {
            DosEnterCritSec();
             focusline = 1 + skipcrank;
            DosExitCritSec();
          }
          while(focusline < numcrank + 1 && focusline > 0 && !modems[focusline]) {
            DosEnterCritSec();
             focusline++;
            DosExitCritSec();
          }
          if(focusline > numcrank || !modems[focusline]) {
            DosEnterCritSec();
             focusline = 0;
            DosExitCritSec();
          }
          if(focusline) {

            char s[18];

            sprintf(s,"XBBS: %u",focusline);
            WinSetWindowText(ParentOf(hwnd),s);
            set_menu_checks(hwndMenu,focusline);
            if(hwndLog[focusline])
              WinSetWindowPos(WinQueryWindow(hwndLog[focusline],QW_PARENT,0),
                              HWND_TOP,0,0,0,0,SWP_RESTORE | SWP_ZORDER);
            if(hwndStatus[focusline])
              WinSetWindowPos(WinQueryWindow(hwndStatus[focusline],QW_PARENT,0),
                              HWND_TOP,0,0,0,0,SWP_RESTORE | SWP_ZORDER);
            if(hwndTransfer[focusline])
              WinSetWindowPos(WinQueryWindow(hwndTransfer[focusline],QW_PARENT,0),
                              HWND_TOP,0,0,0,0,SWP_RESTORE | SWP_ZORDER);
            if(hwndBBS[focusline])
              WinSetWindowPos(WinQueryWindow(hwndBBS[focusline],QW_PARENT,0),
                              HWND_TOP,0,0,0,0,SWP_RESTORE | SWP_ZORDER);
          }
          else {
            WinSetWindowText(ParentOf(hwnd),"XBBS: Local");
            DosSemClear(&localBBSSEM);
          }
          return 0;

        case IDM_PREV:
          DosEnterCritSec();
           focusline--;
          DosExitCritSec();
          while(focusline > 0 && !modems[focusline]) {
            DosEnterCritSec();
             focusline--;
            DosExitCritSec();
          }
          if(focusline > numcrank || !modems[focusline]) {
            DosEnterCritSec();
             focusline = numcrank;
            DosExitCritSec();
            while(focusline > 0 && !modems[focusline]) {
              DosEnterCritSec();
               focusline--;
              DosExitCritSec();
            }
            if(focusline > numcrank || !modems[focusline]) {
              DosEnterCritSec();
               focusline = 0;
              DosExitCritSec();
            }
          }
          if(focusline) {

            char s[18];

            sprintf(s,"XBBS: %u",focusline);
            WinSetWindowText(ParentOf(hwnd),s);
            set_menu_checks(hwndMenu,focusline);
            if(hwndLog[focusline])
              WinSetWindowPos(WinQueryWindow(hwndLog[focusline],QW_PARENT,0),
                              HWND_TOP,0,0,0,0,SWP_RESTORE | SWP_ZORDER);
            if(hwndStatus[focusline])
              WinSetWindowPos(WinQueryWindow(hwndStatus[focusline],QW_PARENT,0),
                              HWND_TOP,0,0,0,0,SWP_RESTORE | SWP_ZORDER);
            if(hwndTransfer[focusline])
              WinSetWindowPos(WinQueryWindow(hwndTransfer[focusline],QW_PARENT,0),
                              HWND_TOP,0,0,0,0,SWP_RESTORE | SWP_ZORDER);
            if(hwndBBS[focusline])
              WinSetWindowPos(WinQueryWindow(hwndBBS[focusline],QW_PARENT,0),
                              HWND_TOP,0,0,0,0,SWP_RESTORE | SWP_ZORDER);
          }
          else {
            WinSetWindowText(ParentOf(hwnd),"XBBS: Local");
            DosSemClear(&localBBSSEM);
          }
          return 0;

        case IDM_BBS:
          DosEnterCritSec();
           focusline = 0;
          DosExitCritSec();
          WinSetWindowText(ParentOf(hwnd),"XBBS: Local");
          DosSemClear(&localBBSSEM);
          set_menu_checks(hwndMenu,focusline);
          if(hwndBBS[focusline])
            WinSetWindowPos(WinQueryWindow(hwndBBS[focusline],QW_PARENT,0),
                            HWND_TOP,0,0,0,0,SWP_RESTORE | SWP_ZORDER);
          return 0;

        case IDM_POLL:
          WinDlgBox(HWND_DESKTOP,hwnd,PollDlgBoxProc,0,PLL_FRAME,
                    MPFROM2SHORT(focusline,0));
          return 0;

        case IDM_ACTIVE:
            if(!DosSemWait(&InactiveSEM[focusline],0L)) {
              DosSemSet(&InactiveSEM[focusline]);
              WinSendMsg(hwndMenu,MM_SETITEMATTR,
                         MPFROM2SHORT(IDM_ACTIVE,1),
                         MPFROM2SHORT(MIA_CHECKED,MIA_CHECKED));
            }
            else {
              DosSemClear(&InactiveSEM[focusline]);
              WinSendMsg(hwndMenu,MM_SETITEMATTR,
                         MPFROM2SHORT(IDM_ACTIVE,1),
                         MPFROM2SHORT(MIA_CHECKED,0));
            }
            break;

        case IDM_SHUTDOWN:
          for(x = 1;x < numcrank + 1;x++)
            DosSemClear(&EndMeSEM[x]);
          DosSleep(1L);
          for(x = 1;x < numcrank + 1;x++)
            DosSemClear(&InactiveSEM[x]);
          DosSleep(1L);
          inshutdown = 1;
          save_bbs(1);
          WinSendMsg(hwndMenu,MM_SETITEMATTR,
                     MPFROM2SHORT(IDM_SHUTDOWN,1),
                     MPFROM2SHORT(MIA_CHECKED,MIA_CHECKED));
          for(x = 1;x < numcrank + 1;x++)
            DosSemSet(&EndMeSEM[x]);
          break;

        case IDM_NOBBS:
          modems[focusline]->humansok = 1 - modems[focusline]->humansok;
          WinSendMsg(hwndMenu,MM_SETITEMATTR,
                     MPFROM2SHORT(IDM_NOBBS,1),
                     MPFROM2SHORT(MIA_CHECKED,
                     ((modems[focusline]->humansok == 0) *
                     MIA_CHECKED)));
          break;

        case IDM_FTS1ONLY:
          modems[focusline]->fts0001 = 1 - modems[focusline]->fts0001;
          WinSendMsg(hwndMenu,MM_SETITEMATTR,
                     MPFROM2SHORT(IDM_FTS1ONLY,1),
                     MPFROM2SHORT(MIA_CHECKED,
                     ((modems[focusline]->fts0001 != 0) *
                     MIA_CHECKED)));
          break;

        case IDM_NOSEA:
          modems[focusline]->nosealink = 1 - modems[focusline]->nosealink;
          WinSendMsg(hwndMenu,MM_SETITEMATTR,
                     MPFROM2SHORT(IDM_NOSEA,1),
                     MPFROM2SHORT(MIA_CHECKED,
                     ((modems[focusline]->nosealink != 0) *
                     MIA_CHECKED)));
          break;

        case IDM_NO1K:
          modems[focusline]->no1k = 1 - modems[focusline]->no1k;
          WinSendMsg(hwndMenu,MM_SETITEMATTR,
                     MPFROM2SHORT(IDM_NO1K,1),
                     MPFROM2SHORT(MIA_CHECKED,
                     ((modems[focusline]->no1k != 0) *
                     MIA_CHECKED)));
          break;

        case IDM_NOSLO:
          modems[focusline]->noslo = (modems[focusline]->noslo) ? 0 : 1;
          WinSendMsg(hwndMenu,MM_SETITEMATTR,
                     MPFROM2SHORT(IDM_NOSLO,1),
                     MPFROM2SHORT(MIA_CHECKED,
                     ((modems[focusline]->noslo != 0) *
                     MIA_CHECKED)));
          break;

        case IDM_NOIN:
          modems[focusline]->answerok = 1 - modems[focusline]->answerok;
          WinSendMsg(hwndMenu,MM_SETITEMATTR,
                     MPFROM2SHORT(IDM_NOIN,1),
                     MPFROM2SHORT(MIA_CHECKED,
                     ((modems[focusline]->answerok == 0) *
                     MIA_CHECKED)));
          break;

        case IDM_NOOUT:
          modems[focusline]->dialoutok = 1 - modems[focusline]->dialoutok;
          WinSendMsg(hwndMenu,MM_SETITEMATTR,
                     MPFROM2SHORT(IDM_NOOUT,1),
                     MPFROM2SHORT(MIA_CHECKED,
                     ((modems[focusline]->dialoutok == 0) *
                     MIA_CHECKED)));
          break;

        case IDM_SFREQS:
          modems[focusline]->sfreqsok = 1 - modems[focusline]->sfreqsok;
          WinSendMsg(hwndMenu,MM_SETITEMATTR,
                     MPFROM2SHORT(IDM_SFREQS,1),
                     MPFROM2SHORT(MIA_CHECKED,
                     ((modems[focusline]->sfreqsok != 0) *
                     MIA_CHECKED)));
          break;

        case IDM_RFREQ:
          modems[focusline]->rfreqsok = 1 - modems[focusline]->rfreqsok;
          WinSendMsg(hwndMenu,MM_SETITEMATTR,
                     MPFROM2SHORT(IDM_RFREQ,1),
                     MPFROM2SHORT(MIA_CHECKED,
                     ((modems[focusline]->rfreqsok != 0) *
                     MIA_CHECKED)));
          break;

        case IDM_ABOUT:
          WinDlgBox(HWND_DESKTOP,hwnd,AboutDlgBoxProc,
                    0,IDD_ABOUT,NULL);
          break;

        case IDM_HELP:
          break;

        default:
          if(SHORT1FROMMP(mp1) > LINEIDS - 1 &&
             SHORT1FROMMP(mp1) < LINEIDS + numcrank + 1 &&
             modems[SHORT1FROMMP(mp1) - LINEIDS] &&
             SHORT1FROMMP(mp1) - LINEIDS != focusline) {

            char s[18];

            focusline = SHORT1FROMMP(mp1) - LINEIDS;
            if(focusline)
              sprintf(s,"XBBS: %u",focusline);
            else
              strcpy(s,"XBBS: Local");
            WinSetWindowText(ParentOf(hwnd),s);
            set_menu_checks(hwndMenu,focusline);
            if(focusline) {
              if(hwndLog[focusline])
                WinSetWindowPos(WinQueryWindow(hwndLog[focusline],QW_PARENT,0),
                                HWND_TOP,0,0,0,0,SWP_RESTORE | SWP_ZORDER);
              if(hwndStatus[focusline])
                WinSetWindowPos(WinQueryWindow(hwndStatus[focusline],QW_PARENT,0),
                                HWND_TOP,0,0,0,0,SWP_RESTORE | SWP_ZORDER);
              if(hwndTransfer[focusline])
                WinSetWindowPos(WinQueryWindow(hwndTransfer[focusline],QW_PARENT,0),
                                HWND_TOP,0,0,0,0,SWP_RESTORE | SWP_ZORDER);
            }
            if(hwndBBS[focusline])
              recall_window(hwndBBS[focusline]);
          }

      }
      return 0;
  }

  return(WinDefWindowProc(hwnd,msg,mp1,mp2));
}


MRESULT EXPENTRY AboutDlgBoxProc(HWND hwndDlg, USHORT msg, MPARAM mp1,
                                 MPARAM mp2) {

   return (WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}
