#define USE_TIME_MACROS

#include "mailer.h"
#include "bbs.h"
#include "modem.h"
#include "timers.h"
#include "transfer.h"
#include "nodelist.h"
#include "yoohoo.h"
#include "keys.h"
#include "xmisc.h"


#define BROKEN1 0x01b
#define BROKEN2 0x050

    extern ADDR  *addresses;
    extern MDM   *modems[MAXINSTANCES];
    extern BBS   *bbs;
    extern int    hydraok;


/* Yoohoo hello packet stuff implemented per FTS-0006 */




int _fastcall recv_hello (USHORT cp,HELLO *hello,ADDR *addr,ADDR **myaddr) {

    int  temp,retries = 0,crc,hiscrc;
    clock_t t1;

    memset(hello,0,sizeof(HELLO));
    purge_in(cp);

YHR1:

    t1 = timerset(10000L);

/* YHR2 */

    com_putc(cp,ENQ);

YHR3:

    while(retries < 10 && !timeup(t1)) {
        temp = get_modem_byte(cp,5000L);
        switch(temp) {
            case LOSTCARRIER:
                            return LOSTCARRIER;

            case 0x1f:      goto YHR5;

            case YOOHOO:    goto YHR1;

            default:        break;
        }
    }

/* YHR4 */

    retries++;
    if(retries > 9) {
        return TIMEOUT;
    }
    goto YHR1;

YHR5:

    temp = get_modem_block(cp,(char *)hello,sizeof(HELLO),10000L); /* get hello pkt */
    switch(temp) {
        case TIMEOUT:
                            return TIMEOUT;

        case LOSTCARRIER:
                            return LOSTCARRIER;

    }

/* YHR6 */

    crc = figurecrc((char *)hello,sizeof(HELLO),1);
    hiscrc = (get_modem_byte(cp,1000L) << 8) | get_modem_byte(cp,1000L);
    if(hiscrc == crc)
      goto YHR8;

/* YHR7 */

logfunc(2,cp,"Yoohoo CRC error");
    if(retries > 9)
        return TIMEOUT;
    com_putc(cp,'?');
    t1 = timerset(10000L);
    goto YHR3;

YHR8:

    /* dig address out of still-kludged hello packet */

    addr->next = NULL;
    strset(addr->domain,0);
    addr->zone = hello->my_zone;
    addr->net = hello->my_net;
    addr->node = hello->my_node;
    addr->point = hello->my_point;
    if(hello->capabilities & DO_DOMAIN) {

        char *p;

        p = hello->my_name;
        hello->my_name[59] = 0;
        hello->sysop[19] = 0;
        rstrip(hello->sysop);
        while(*p && p < hello->my_name + 58) p++;
        if(!*p && p < hello->my_name + 58) {
            p++;
            strncpy(addr->domain,p,8);
            addr->domain[8] = 0;
            p = strchr(addr->domain,'.');
            if(p) *p = 0;
        }
    }

    rstrip(hello->my_name);

    guess_rest(addr,addresses);
    *myaddr = best_guess(addr,addresses); /* guess who we are */

    if(!(hello->capabilities & Y_DIETIFNA)) {
        purge_in(cp); /* what an asshole */
        return TSYNCH;
    }
    if((hello->capabilities & DO_HYDRA) && hydraok)
      modems[cp]->dohydra = 1;
    else
      modems[cp]->dohydra = 0;

    purge_in(cp);
    com_putc(cp,ACK);
    com_putc(cp,YOOHOO);

    if(hello->capabilities & WZ_FREQ)
      modems[cp]->hefreqs = 1;
    else
      modems[cp]->hefreqs = 0;

    if(hello->product == BROKEN1 || hello->product == BROKEN2) {
        logfunc(0,cp,"Remote's dietIFNA is broken");
        modems[cp]->hesbroken = 1;
    }
    else
      modems[cp]->hesbroken = 0;

    modems[cp]->hisprodcode = (int)hello->product;

    if(hello->product == BROKEN1 && hello->product_maj <= 2 &&
      hello->product_min <= 39) {
        modems[cp]->brokenover = 1;
        logfunc(0,cp,"Disabled overdrive receive for product #%d (%d.%d)",
                hello->product,hello->product_maj,hello->product_min);
    }
    else
      modems[cp]->brokenover = 0;

    modems[cp]->dietIFNA = 1;

    return 0;
}





int _fastcall send_hello (USHORT cp,HELLO *hello,ADDR *addr,
                          char *password) {

    int crc,temp;
    clock_t t1;
    char *p;


    memset(hello,0,sizeof(HELLO));
    hello->signal = 0x6f;
    hello->hello_version = 0x01;
    hello->product = (unsigned int)XBBSPRODCODE;
    hello->product_maj = XBBSVERMAJOR;
    hello->product_min = XBBSVERMINOR;
    strcpy(hello->my_name,bbs->bbs_name);
    p = &hello->my_name[strlen(hello->my_name)+1];
    strcpy(p,addr->domain);
    strcpy(hello->sysop,bbs->sysop);
    hello->my_zone = addr->zone;
    hello->my_net = addr->net;
    hello->my_node = addr->node;
    hello->my_point = addr->point;
    if(password)
      strncpy(hello->my_password,password,8);
    hello->capabilities = Y_DIETIFNA | DO_DOMAIN;
    if(hydraok)
      hello->capabilities |= DO_HYDRA;
    if(modems[cp]->rfreqsok)
      hello->capabilities |= WZ_FREQ;

YHS2:

    com_putc(cp,0x1f);       /* FTS-0006 forgets to mention this... */
    com_write(cp,(char *)hello,sizeof(HELLO));

/* YHS3 */

    purge_in(cp);

/* YHS4 */

    crc = figurecrc((char *)hello,sizeof(HELLO),1);
    com_write(cp,(char *)&crc,2);

    t1 = timerset(30000L);

/* YHS5 */

    while(!timeup(t1)) {
        temp = get_modem_byte(cp,5000L);
        switch(temp) {
            case LOSTCARRIER:   return LOSTCARRIER;

            case ACK:           return 0;

            case '?':           logfunc(2,cp,"Yoohoo/2U2 failed");
                                goto YHS2;

            case ENQ:           break;

            default:            break;
        }
    }

    return TIMEOUT;
}
