#define INCL_WIN

#include <sys/types.h>
#include <sys/stat.h>
#include <share.h>
#include <io.h>
#include <fcntl.h>
#include "mailer.h"
#include "xmisc.h"
#include "bbs.h"
#include "xbbs.h"

    extern ADDR *addresses;
    extern HWND xdhwnd;



MRESULT EXPENTRY SendFilesDlgBoxProc (HWND hwndDlg,USHORT msg,
                                      MPARAM mp1,MPARAM mp2) {

    static USHORT   fline = 65535,once = 0;
    static ADDR     faddr;
    static HPOINTER hwndIcon;


    switch(msg) {
        case WM_INITDLG:
            WinPostMsg(hwndDlg, WM_REFRESH, 0L, 0L);
            if(!once) {
                memset(&faddr,0,sizeof(ADDR));
                once++;
            }
            break;

        case WM_SETCP:
            fline = SHORT1FROMMP(mp1);
            return MRFROMSHORT(0);

        case WM_REFRESH:
            hwndIcon = (HPOINTER)WinQuerySysPointer(HWND_DESKTOP,SPTR_APPICON,0);
            WinDefDlgProc(hwndDlg, WM_SETICON, (MPARAM)hwndIcon, (MPARAM)0);
            WinSendDlgItemMsg(hwndDlg, SM_ADDR, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(80,0), NULL);
            WinSendDlgItemMsg(hwndDlg, SM_FNAME, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(255,0), NULL);
            WinSendDlgItemMsg(hwndDlg, SM_PASS, EM_SETTEXTLIMIT,
                              MPFROM2SHORT(8,0), NULL);
            WinSendDlgItemMsg(hwndDlg,SM_NORMAL,BM_SETCHECK,
                              MPFROM2SHORT(1,0),NULL);


            {
                char s[81];

                if(faddr.zone && *faddr.domain) {
                     sprintf(s,"%s#%u:%u/%u.%u",faddr->domain,faddr.zone,
                             faddr.net,faddr.node,faddr.point);
                }
                else {
                    *s = 0;
                }
                WinSetDlgItemText(hwndDlg,SM_ADDR,s);
            }
            return MRFROMSHORT(0);

        case WM_COMMAND:
            switch(SHORT1FROMMP(mp1)) {
                case SM_OK:
                    {
                        char       *p,s[256],*fname;
                        USHORT      rc,update = 0,ddate = 0,poll = 0;
                        struct stat st;
                        int         handle;

                        rc = WinQueryDlgItemText(hwndDlg, SM_ADDR, 80, s);
                        if (rc > 0) {
                            p = lstrip(rstrip(s));
                            if(parse_addr(&p,&faddr,addresses)) {
                                rc = WinQueryDlgItemText(hwndDlg, SM_ADDR, 80, s);
                                if(rc > 0) {
                                    if(!find_in_fidouser(0,(USHORT)-1,lstrip(rstrip(s)),&faddr)) {
                                        memset(&faddr,0,sizeof(ADDR));
                                        DosBeep(1000,10);
                                        break;
                                    }
                                }
                                else {
                                    memset(&faddr,0,sizeof(ADDR));
                                    DosBeep(1000,10);
                                    break;
                                }
                            }
                            if(faddr.zone && *faddr.domain) {
                                sprintf(s,"%s#%u:%u/%u.%u",faddr.domain,
                                        faddr.zone,faddr.net,faddr.node,
                                        faddr.point);
                                WinSetDlgItemText(hwndDlg,SM_ADDR,s);
                                rc = WinQueryDlgItemText(hwndDlg, SM_FNAME, 255, s);
                                if(rc > 0) {
                                    fname = (char *)malloc(1050);
                                    if(fname) {
                                      sprintf(fname,"%s/C.%u.%u.%u.%u.%s",
                                              d_outbound,
                                              faddr.zone,faddr.net,faddr.node,
                                              faddr.point,faddr.domain);
                                      handle = sopen(fname,O_RDWR | O_BINARY | O_CREAT,
                                                     SH_DENYNO,S_IWRITE | S_IREAD);
                                      free(fname);
                                    }
                                    else
                                      handle = -1;
                                    if(handle != -1) {
                                        ffprintf(handle,"%s\r\n",





                                        close(handle);
                                    }
                                    else DosBeep(500,100);
                                }
                            }
                        }
                        else {
                            DosBeep(250,100);
                        }
                    }
                    return MRFROMSHORT(1);

                case SM_CANCEL:
                    WinPostMsg(xdhwnd, WM_SENDDOWN, 0L, 0L);
                    WinSetDlgItemText(hwndDlg,SM_FNAME,"");
                    WinSetDlgItemText(hwndDlg,SM_PASS,"");
                    WinSetDlgItemText(hwndDlg,SM_ADDR,"");
                    memset(&faddr,0,sizeof(ADDR));
                    WinDismissDlg(hwndDlg, 0);
                    break;

                case SM_QUIT:
                    WinPostMsg(xdhwnd, WM_SENDDOWN, 0L, 0L);
                    WinDismissDlg(hwndDlg, 0);
                    break;
            }

        case WM_CLOSE:
            WinPostMsg(xdhwnd, WM_SENDDOWN, 0L, 0L);
            WinDismissDlg(hwndDlg, 0);
            break;
    }

    return(WinDefDlgProc(hwndDlg, msg, mp1, mp2));
}

