/* User interface #1 */

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "modem.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"
#include "xmsg.h"

    extern MDM     *modems[MAXINSTANCES];
    extern USER    *user[MAXINSTANCES];
    extern BBS     *bbs;
    extern MSGAREA *msgareas;



int _fastcall interface1 (int mode,USHORT cp) {

    #define NUMSELECTS 19

    int    com;
    char **selections;
    word messno;
    char prompt [48] = "",color[13];
    static int promptcolor = 5,normalcolor = 11,quotecolor = 15;
    static unsigned long loadSEM = 0L;


    cls(mode,cp);
    if(user[cp]->attribs & U_COLOR) {
        dputs(mode,cp,"\r\n\r\n\r\n\r\n\r\n");
    }
    sayp(mode,cp,70,NULL,0);

    DosSemRequest(&loadSEM,10000L);
    {
       char *p;

       selections = pgetarray(cp,20,NUMSELECTS);
       if(!selections) {
         logfunc(0,cp,"Unable to load interface 1 menu");
         return 0;
       }

       sayp(mode,cp,69,prompt,47);
       p = prompt;
       if(atoi(p)) promptcolor = atoi(p);
       p = to_delim(p," ");
       p = skip_white(p);
       if(atoi(p)) normalcolor = atoi(p);
       p = to_delim(p," ");
       p = skip_white(p);
       if(atoi(p)) quotecolor = atoi(p);
    }
    DosSemClear(&loadSEM);

    for(;;) {
        com = inkey(mode,cp);
        com = is_one(com,selections,13);
        if(com != -1) {
            com++;
            goto HotInterrupt;
        }

        if((rand() % 100) > bbs->quoteodds) {
            if(user[cp]->attribs & U_COLOR) {
                MAKE_ANSI(quotecolor,color);
                dputs(mode,cp,color);
            }
            dputs(mode,cp,"\r\n");
            say_quote(mode,cp);
        }

        com = inkey(mode,cp);
        com = is_one(com,selections,13);
        if(com != -1) {
            com++;
            goto HotInterrupt;
        }

        if(!clear_toplines(mode,cp,3)) dputs(mode,cp,"\r\n");
        if(user[cp]->attribs & U_COLOR) {
            dputs(mode,cp,"\x1b[s\x1b[2;1H");
        }

        if(user[cp]->currmsgarea || user[cp]->currfilearea) {
            if(user[cp]->currmsgarea) {
               sayp(mode,cp,67,NULL,0);
            }
            if(user[cp]->currfilearea) {
               sayp(mode,cp,68,NULL,0);
            }
        }

        if(user[cp]->attribs & U_COLOR) {
            MAKE_ANSI(promptcolor,color);
            dputs(mode,cp,color);
        }

        sayp(mode,cp,65,NULL,0);

        if(!(user[cp]->attribs & U_COLOR)) {
            sayp(mode,cp,66,prompt,47);
        }

        if(user[cp]->attribs & U_COLOR) {
            dputs(mode,cp,"\x1b[u");
        }

        if(!(user[cp]->attribs & U_COLOR)) {
            com = select_one(mode,cp,selections,NUMSELECTS,prompt,NULL,"Main1",set_iflg(cp));
        }
        else {
            com = top_menu(mode,cp,selections,NUMSELECTS,NULL,"Main1");
        }

        com++;

HotInterrupt:

        if(user[cp]->attribs & U_COLOR) {
            MAKE_ANSI(normalcolor,color);
            dputs(mode,cp,color);
        }

        switch(com) {
            case 0:  break;

            case 13: print_calendar(mode,cp);
                     dputs(mode,cp,"\r\n");
                     if(user[cp]->attribs & U_NOVICE) {
                        hitreturn(mode,cp);
                     }
                     break;

            case 14: library(mode,cp);
                     break;

            case 15: sayp(mode,cp,124,NULL,0);
                     who_is_online(mode,cp);
                     break;

            case 16: if(!(user[cp]->attribs & U_MISCNEWSOK) && user[cp]->number != 1) {
                        sayp(mode,cp,71,NULL,0);
                     }
                     else {
                        create_text_file(mode,cp,d_miscnews,".NWS");
                     }
                     break;

            case 17: {
                        int which = 1;

                        if(user[cp]->pointid) {
                            pselect_one(mode,cp,123,2,146,NULL,"I1_Xport type",set_iflg(cp));
                        }
                        if(which > -1) {
                            if(which == 1) {
                                if(_beginthread(TXT_export,NULL,16384,&cp) == -1) {
                                     sayp(mode,cp,72,NULL,0);
                                     break;
                                }
                            }
                            else {
                                if(_beginthread(FIDO_export,NULL,16384,&cp) == -1) {
                                     sayp(mode,cp,73,NULL,0);
                                     break;
                                }
                            }
                            sayp(mode,cp,74,NULL,0);
                            DosSleep(1500L);
                        }
                        break;
                     }

            case 18: chat_request(mode,cp);
                     dputs(mode,cp,"\r\n");
                     break;

            case NUMSELECTS: {

                         char input[4];

                         strset(input,0);
                         pinput_string(mode,cp,input,1,1,75,
                                      STRT_YN,STRF_UCASE | STRF_HOT,
                                      "I1_Quit",NULL);
                         if(*input == modems[cp]->YES) {

                            if(bbs->attribs & B_LOGOFFMSG) {

                                MSGAREA *info;

                                info = next_msg_area(msgareas,cp,0);
                                while(info) {
                                    if(!stricmp(info->name,"FEEDBACK")) break;
                                    info = info->next;
                                }
                                if(!info) {
                                    find_msg_area(NULL,cp,1);
                                }
                                if(info) {
                                    strset(input,0);
                                    pinput_string(mode,cp,input,1,1,76,
                                                  STRT_YN,STRF_UCASE | STRF_HOT,
                                                  "I1_Logoff Msg",NULL);
                                    if(*input == modems[cp]->YES) {
                                        write_msg(mode,cp,info,NULL,NULL,3);
                                    }
                                }
                            }
                            readansi(mode,cp,"GOODBYE.ASC",NULL,2);
                            sayp(mode,cp,202,NULL,0);
                            sayp(mode,cp,77,NULL,0);
                            flushout(cp);
                            free_selections(cp,selections,NUMSELECTS);
                            return 0;
                         }
                     }
                     break;

            case 12: ask_list_users(mode,cp);
                     break;

            case 1: select_msg_area(mode,cp);
                    DosSleep(500L);
                    dputs(mode,cp,"\r\n");
                    if(user[cp]->currmsgarea) {
                        sayp(mode,cp,78,NULL,0);
                    }
                    else sayp(mode,cp,79,NULL,0);
#ifdef DEBUG
    dump_msgareas(mode,cp);
#endif
                    break;

            case 2: select_file_area(mode,cp);
                    DosSleep(500L);
                    dputs(mode,cp,"\r\n");
                    break;

            case 3:
            case 4: if(user[cp]->currmsgarea) {
                        sayp(mode,cp,80,NULL,0);
                        do_msgread1(mode,cp,(com == 4) * 3,0);
                    }
                    else {
                        sayp(mode,cp,82,NULL,0);
                        DosSleep(2000L);
                    }
                    break;

            case 5: if(user[cp]->currmsgarea) {
                        sayp(mode,cp,83,NULL,0);
                        do_globalmsgread1(mode,cp,0);
                    }
                    break;

            case 6: if(!write_msg(mode,cp,user[cp]->currmsgarea,NULL,NULL,0)) {
                        user[cp]->numposts++;
                    }
                    DosSleep(500L);
                    break;

            case 11: give_status1(mode,cp,user[cp]);
                     if(user[cp]->attribs & U_NOVICE) {
                        hitreturn(mode,cp);
                     }
                     break;

            case 10: edit_yourself(mode,cp);
                     break;

            case 7: if(user[cp]->currfilearea) {

                        long dummy;
                        char *s;

                        s = bbs_malloc(cp,strlen(user[cp]->currfilearea->dpath) + 12);
                        if(s) {

                            struct stat st;

                            sprintf(s,"%s/FILES.BBS",user[cp]->currfilearea->dpath);
                            if(stat(s,&st) || !st.st_size) {
                                if(!(user[cp]->currfilearea->areaflags & F_NOCOMMON)) strcpy(s,"FILES.BBS");
                                else *s = 0;
                            }
                            {
                                char input[48],yorn[2];
                                time_t date = 0L;
                                int err;

                                 strset(input,0);
                                 pinput_string(mode,cp,input,48,2,84,
                                              STRT_ALL,STRF_UCASE,
                                              "I1_FMatchStr",NULL);
                                 strset(yorn,0);
                                 pinput_string(mode,cp,yorn,1,1,85,
                                              STRT_YN,STRF_UCASE | STRF_HOT,
                                              "I1_FNewOnly",NULL);
                                 if(*yorn == modems[cp]->YES) date = user[cp]->last_logon;
                                 sayp(mode,cp,86,NULL,0);
                                 dputs(mode,cp,"\r\n");
                                 if(list_fbbs(mode,cp,input,&dummy,s,
                                    user[cp]->currfilearea->dpath,date,
                                    (((user[cp]->currfilearea->areaflags & F_NODIR) != 0) * 2) |
                                    (((user[cp]->currfilearea->areaflags & F_NOFBBS) != 0) * 4) |
                                    (((user[cp]->currfilearea->areaflags & F_NOCOMMON) != 0) * 8),
                                    &err) > 0L) {
                                      dputs(mode,cp,"\r\n");
                                      hitreturn(mode,cp);
                                 }
                                 else dputs(mode,cp,"\r\n");
                                 bbs_free(cp,s);
                            }
                        }
                    }
                    else {
                        sayp(mode,cp,87,NULL,0);
                        DosSleep(2000L);
                    }
                    break;

            case 8: if(user[cp]->currfilearea && stricmp(user[cp]->currfilearea->dpath,"NUL")) {

                        char input[75];
                        long tk;

                        if(user[cp]->dktoday > user[cp]->dkperday) {
                            sayp(mode,cp,88,NULL,0);
                            DosSleep(2000L);
                            break;
                        }

                        strset(input,0);
                        pinput_string(mode,cp,input,74,1,89,
                                     STRT_MULTFILES,STRF_PRETTY,
                                     "Download1",NULL);
                        dputs(mode,cp,"\r\n");
                        if(!*input) break;
                        tk = download_files(mode,cp,input,NULL,
                                            &user[cp]->dlnum,0) / 1024L;
                        user[cp]->dlk += tk;
                        user[cp]->dktoday += tk;
                        if(modems[cp]->curbaud) {
                            DosSleep(2000L);
                        }
                        if(!tk) sayp(mode,cp,90,NULL,0);
                        DosSleep(1L);
                        break;
                    }
                    else {
                        sayp(mode,cp,87,NULL,0);
                        DosSleep(2000L);
                    }
                    break;

            case 9: if(!user[cp]->currfilearea) {
                        sayp(mode,cp,87,NULL,0);
                        DosSleep(2000L);
                    }
                    else if(file_write_ok(user[cp],user[cp]->currfilearea) || !stricmp(user[cp]->currfilearea->upath,"NUL")) {
                        sayp(mode,cp,91,NULL,0);
                        DosSleep(2000L);
                    }
                    else {

                        char input[75];
                        long tk;

                        strset(input,0);
                        pinput_string(mode,cp,input,74,1,92,
                                     STRT_FILENAME,STRF_PRETTY,
                                     "Upload1",NULL);
                        dputs(mode,cp,"\r\n");
                        if(!*input) break;
                        tk = upload_files(mode,cp,input,
                                          user[cp]->currfilearea->upath,
                                          user[cp]->currfilearea->name,
                                          &user[cp]->ulnum,0);
                        user[cp]->ulk += tk;
                        user[cp]->uktoday += tk;
                        if(!tk) sayp(mode,cp,93,NULL,0);
                    }
                    break;

            default: sayp(mode,cp,94,NULL,0);
                     DosSleep(2000L);
                     break;
        }

        if(user[cp]->offline < time(NULL) || checkcarrier(cp)) {
            free_selections(cp,selections,NUMSELECTS);
            return 1;
        }
    }
}




int _fastcall do_msgread1 (int mode,USHORT cp,unsigned int flags,
                           unsigned int startat) {

    /* flags bitmapped values:
       1:   messages to user
       2:   messages from user
       4:   silence (for private scans)
       8:   don't clear top
    */

    unsigned int messno,ntemp;
    int          temp,lastdir = 1,nonstop = 0;
    char         msgnum[6];
    static int   ampromptcolor = 3,amcmdcolor = 11;


    if(user[cp]->currmsgarea) {

ReEnterMsgNo:

       if(startat) {
         messno = startat;
         goto StartAtInterrupt;
       }
       messno = how_many_msgs(user[cp]->currmsgarea);

       if(!(flags & 8)) {
         if(!clear_toplines(mode,cp,3)) dputs(mode,cp,"\r\n");
         if(user[cp]->attribs & U_COLOR) dputs(mode,cp,"\x1b[s\x1b[2;1H");
       }
       else dputs(mode,cp,"\r\n");

       sayp(mode,cp,34,NULL,0);
       if(!messno)
        return 1;
       if(user[cp]->lastread[user[cp]->currmsgarea->number - 1] < messno) {
         sprintf(msgnum,"%u",user[cp]->lastread[user[cp]->currmsgarea->number - 1] + 1);
       }
       else {
         *msgnum = 0;
         if(messno)
           user[cp]->lastread[user[cp]->currmsgarea->number - 1] = messno;
       }
       pinput_string(mode,cp,msgnum,5,1,35,
                     STRT_NUMERIC,0,
                     "I1_MsgNum",NULL);

       if(!(flags & 8) && user[cp]->attribs & U_COLOR)
         dputs(mode,cp,"\x1b[u");
       else dputs(mode,cp,"\r\n");

       if(atoi(msgnum)) {
          messno = (word)atoi(msgnum);

StartAtInterrupt:

          if(messno > how_many_msgs(user[cp]->currmsgarea)) {
             sayp(mode,cp,36,NULL,0);
             return 0;
          }

          do {

             if(user[cp]->offline < time(NULL) || checkcarrier(cp)) break;

             if((flags & 1) || (flags & 2)) {   /* personal checks */

                 XMSG msg;
                 unsigned int nomess;

                 if(!(flags & 4))
                   sayp(mode,cp,37,NULL,0);
                 nomess = how_many_msgs(user[cp]->currmsgarea);
                 memset(&msg,0,sizeof(XMSG));
                 while(messno < nomess + 1 && messno) {
                     if(!(messno % 25))
                       DosSleep(1L);
                     else
                       DosSleep(0L);
                     temp = get_messu(cp,&msg,user[cp]->currmsgarea->number,messno,user[cp]);
                     if(temp == MSG_NOERR) {
                        if(flags & 1) {
                            if(!stricmp(msg.to,user[cp]->name) || !stricmp(msg.to,user[cp]->handle)) {
                                break;
                            }
                        }
                        if(flags & 2) {
                            if(!stricmp(msg.from,user[cp]->name) || !stricmp(msg.from,user[cp]->handle)) {
                                break;
                            }
                        }
                     }
                     messno += lastdir;
                 }
                 if(messno > nomess || !messno) {
                     if(!(flags & 4)) {
                        sayp(mode,cp,38,NULL,0);
                     }
                     return lastdir;
                 }
             }

             temp = read_msg(mode,cp,user[cp]->currmsgarea,messno,(((nonstop != 0) * 5) + (((flags & 2) != 0) * 2)) + ((lastdir < 0) * 8));
             if(temp > -1 && (temp & 128)) {
                temp &= (~128);
                nonstop = 1;
             }
             else nonstop = 0;

             switch(temp) {
                case -1:    sayp(mode,cp,39,NULL,0);
                            DosSleep(1000L);
                            temp = 1;
                            messno += lastdir;
                            continue;

                case -2:    sayp(mode,cp,40,NULL,0);
                            temp = 0;
                            break;

                case 0:     temp = 1;
                            messno += lastdir;
                            continue;

                case 1:     messno++;
                            lastdir = 1;
                            continue;

                case 2:     messno--;
                            lastdir = -1;
                            continue;

                case 3:     temp = 0;
                            break;

                case 8:     flags &= (~7);
                            goto ReEnterMsgNo;

                case 10:    ntemp = scan_msgs(mode,cp,user[cp]->currmsgarea,messno,10);
                            if(!ntemp)
                              temp = 0;
                            else
                              messno = ntemp;
                            break;

                default:    sayp(mode,cp,94,NULL,0);
                            break;
            }
            dputs(mode,cp,"\r\n");
          } while(temp);
       }
    }
    return lastdir;
}




int _fastcall do_globalmsgread1 (int mode,USHORT cp,unsigned int flags) {

    /* flags bitmapped values:
        1:  Stop at all areas
        8:  Don't clear top
    */

    MSGAREA *temp;
    int     lastdir = 1,t,tempnum;
    word    messno;


    if(user[cp]->currmsgarea) {
        temp = user[cp]->currmsgarea;

        do {

Over:

            messno = how_many_msgs(user[cp]->currmsgarea);
            if(user[cp]->lastread[user[cp]->currmsgarea->number - 1] > messno) {
              if(messno)
                user[cp]->lastread[user[cp]->currmsgarea->number - 1] = messno;
            }
            if((flags & 1) || user[cp]->lastread[user[cp]->currmsgarea->number - 1] < messno) {
                if(user[cp]->offline < time(NULL) || checkcarrier(cp)) {
                    break;
                }

                if(!(flags & 8)) {
                  if(!clear_toplines(mode,cp,3))
                    dputs(mode,cp,"\r\n");
                  if(user[cp]->attribs & U_COLOR)
                    dputs(mode,cp,"\x1b[s\x1b[2;1H");
                }
                else dputs(mode,cp,"\r\n");

                if(lastdir == -1) dputs(mode,cp,"[-]");
                else dputs(mode,cp,"[+]");
                sayp(mode,cp,43,NULL,0);
                if(user[cp]->lastread[user[cp]->currmsgarea->number - 1] < messno) {
                    sayp(mode,cp,44,NULL,0);
                }
                if(!(flags & 8) && user[cp]->attribs & U_COLOR) {
                    dputs(mode,cp,"\x1b[u");
                }
                DosSleep(1L);

                t = pselect_one(mode,cp,41,6,42,NULL,"Global1",set_iflg(cp));
                t++;

                switch(t) {
                    case 2: break;

                    case 3: if(messno)
                              user[cp]->lastread[user[cp]->currmsgarea->number - 1] = messno;
                            break;

                    case 5: if(lastdir == -1) lastdir = 1;
                            else lastdir = -1;
                            goto Over;

                    case 6: goto BreakOut;

                    default: tempnum = do_msgread1(mode,cp,(t == 4) * 3,0);
                             if(tempnum) lastdir = tempnum;
                             if(!lastdir) lastdir = 1;
                             break;
                }

                dputs(mode,cp,"\r\n");
            }
            else {
                if(messno)
                  user[cp]->lastread[user[cp]->currmsgarea->number - 1] = messno;
            }

            do {
                user[cp]->currmsgarea =
                  next_msg_area(user[cp]->currmsgarea,cp,lastdir);
            } while(user[cp]->currmsgarea &&
                    user[cp]->currmsgarea->password &&
                    *user[cp]->currmsgarea->password);

            if(user[cp]->offline < time(NULL) || checkcarrier(cp)) {
                break;
            }

        } while(user[cp]->currmsgarea);

BreakOut:

        dputs(mode,cp,"\r\n");
        user[cp]->currmsgarea = temp;
    }

    return 0;
}




void _fastcall give_status1 (int mode,USHORT cp,USER *user) {

   time_t t;
   static char *bits[] = {"ANSI","Color","High ASCII","No More? Pause",
                          "No Screen Clearing","Cold Input","Show Address",
                          "Show Phone #","Show Real Name","Invulnerable",
                          "Dead","Expert","Twit","See New Files",
                          "See New Msgs","D/L New Msgs","D/L New File List",
                          "See News","Ask to D/L","Novice",
                          "No Rolling Prompts"
                         };
   int numbits = 21,x;


   if(!(user->attribs & U_NOCLEAR)) cls(mode,cp);
   if(user->attribs & U_COLOR) dputs(mode,cp,"\x1b[0;1;37m");
   dputs(mode,cp,"\r\n   -= User Stats =-\r\n");
   dprintf(mode,cp,"\r\n%s (%s)",user->name,user->handle);
   dprintf(mode,cp,"\r\nLogged on:         %0.24s\r\n",asctime(localtime(&user->online)));
   dprintf(mode,cp,"Must log off by:   %0.24s",asctime(localtime(&user->offline)));
   dprintf(mode,cp," (%ld mins left)\r\n",(user->offline - time(NULL)) / 60L);
   t = time(NULL);
   dprintf(mode,cp,"Current time:      %0.24s\r\n",asctime(localtime(&t)));
   if(user->initial_logon)
     dprintf(mode,cp,"Your first logon:  %0.24s\r\n",asctime(localtime(&user->initial_logon)));
   if(user->last_logon)
     dprintf(mode,cp,"Your last logon:   %0.24s\r\n",asctime(localtime(&user->last_logon)));
   if(user->currmsgarea) {
      dprintf(mode,cp,"Current msg area:  %s (%u msg%s)",
              user->currmsgarea->name,
              how_many_msgs(user->currmsgarea),
              &"s"[(how_many_msgs(user->currmsgarea) == 1)]);
      dputs(mode,cp,"\r\n");
   }
   if(user->currfilearea) {
      dprintf(mode,cp,"Current file area: %s\r\n",user->currfilearea->name);
   }
   dprintf(mode,cp,"There have been %lu callers.  You have called %lu time%s, posted",
           bbs->numcalls,user->numcalls,&"s"[(user->numcalls == 1L)]);
   dprintf(mode,cp," %lu message%s,\r\n and have %ld unit%s of credit.\r\n",user->numposts,
           &"s"[(user->numposts == 1)],user->credit,&"s"[(user->credit == 1L)]);
   dprintf(mode,cp,"You are %d years old.\r\n",user->age);
   hitreturn(mode,cp);
   dprintf(mode,cp,"\r\nYour screen size is %d X %d.",
           user->width,user->length);
   dputs  (mode,cp,"\r\n U/D Stats: Up           Down");
   dputs  (mode,cp,"\r\n----------  ----------   ----------");
   dprintf(mode,cp,"\r\n Total #:   %9lu    %9lu",user->ulnum,user->dlnum);
   dprintf(mode,cp,"\r\n Total K:   %9lu    %9lu",user->ulk,user->dlk);
   dprintf(mode,cp,"\r\n K Today:   %9lu    %9lu",user->uktoday,
           user->dktoday);
   dprintf(mode,cp,"\r\n MaxK/day:  %9lu    %9lu",user->ukperday,
           user->dkperday);
   dputs(mode,cp,"\r\nYou have the following attribute bits set:\r\n");
   for(x = 0;x < numbits;x++) {
     if(user->attribs & (1 << x))
       dprintf(mode,cp," %s\r\n",bits[x]);
   }
   hitreturn(mode,cp);
}
