#define INCL_WIN

#include "mailer.h"
#include "xmisc.h"
#include "xbbs.h"

  extern USHORT focusline;
  extern HWND   hwndLog[MAXINSTANCES];
  extern MDM   *modems[MAXINSTANCES];

int _fastcall set_saved_position (HWND hwnd,char *savename) {

  /*
   * called with client hwnd and save name, restores a window
   * to the state last saved with save_position
   */

  HWND   grandparent = GrandparentOf(hwnd);
  SWP    swp,swpgp;
  USHORT fs;
  ULONG  size = sizeof(SWP);

  if(PrfQueryProfileData(HINI_USERPROFILE,"XBBS",
     savename,&swp,&size) == TRUE) {
    if(swp.fs & SWP_MINIMIZE)
      fs = SWP_MINIMIZE;
    else if(swp.fs & SWP_MAXIMIZE)
      fs = SWP_MAXIMIZE;
    else
      fs = SWP_RESTORE | SWP_MOVE | SWP_SIZE;
    WinQueryWindowPos(grandparent,&swpgp);
    if(swp.cy > swpgp.cy)
      swp.cy = swpgp.cy;
    if(swp.y > swpgp.cy)
      swp.y = swpgp.cy - 200;
    if(swp.y + swp.cy > swpgp.cy)
      swp.y = swpgp.cy - swp.cy;
    if(swp.y < 0) {
      swp.cy -= swp.y;
      swp.y = 0;
    }
    if(swp.cx > swpgp.cx)
      swp.cx = swpgp.cx;
    if(swp.x > swpgp.cx)
      swp.x = swpgp.cx - 100;
    if(swp.x + swp.cx > swpgp.cx)
      swp.x = swpgp.cx - swp.cx;
    if(swp.x < 0) {
      swp.cx -= swp.x;
      swp.x = 0;
    }
    WinSetWindowPos(ParentOf(hwnd),HWND_TOP,
                    swp.x,swp.y,swp.cx,swp.cy,fs);
    if(!(fs & SWP_MOVE)) {
      WinSetWindowUShort(ParentOf(hwnd),QWS_XRESTORE,swp.x);
      WinSetWindowUShort(ParentOf(hwnd),QWS_YRESTORE,swp.y);
      WinSetWindowUShort(ParentOf(hwnd),QWS_CXRESTORE,swp.cx);
      WinSetWindowUShort(ParentOf(hwnd),QWS_CYRESTORE,swp.cy);
    }
    return 1;
  }
  else
    return 0;
}


void _fastcall save_position (HWND hwnd,char *savename) {

  SWP    swp;

  WinQueryWindowPos(ParentOf(hwnd),&swp);
  if(swp.fs & (SWP_MINIMIZE | SWP_MAXIMIZE)) {
    swp.x = WinQueryWindowUShort(ParentOf(hwnd),QWS_XRESTORE);
    swp.y = WinQueryWindowUShort(ParentOf(hwnd),QWS_YRESTORE);
    swp.cx = WinQueryWindowUShort(ParentOf(hwnd),QWS_CXRESTORE);
    swp.cy = WinQueryWindowUShort(ParentOf(hwnd),QWS_CYRESTORE);
  }
  PrfWriteProfileData(HINI_USERPROFILE,"XBBS",savename,
                      &swp,(ULONG)sizeof(SWP));
}


MRESULT EXPENTRY ChildFrameProc (HWND hwnd,USHORT msg,MPARAM mp1,MPARAM mp2) {

  PFNWP oldproc;

  if(msg != WM_SETCP)
    oldproc = (PFNWP)WinQueryWindowPtr(ClientOf(hwnd),4);
  else
    oldproc = NULL;

  switch(msg) {
    case WM_SETCP:
      oldproc = (PFNWP)mp1;
      WinSetWindowPtr(ClientOf(hwnd),4,(PVOID)oldproc);
      return 0;

    case WM_SYSCOMMAND:
      if(SHORT1FROMMP(mp1) == SC_MINIMIZE || SHORT1FROMMP(mp1) == SC_RESTORE) {
        if(!(SHORT)WinQueryWindowUShort(ClientOf(hwnd),2))
          WinSendMsg(ClientOf(hwnd),WM_HIDEME,MPVOID,MPVOID);
      }
      break;
  }
  if(oldproc)
    return oldproc(hwnd,msg,mp1,mp2);
  else
    return 0;
}



MRESULT EXPENTRY LogBoxProc (HWND hwnd,USHORT msg,MPARAM mp1,MPARAM mp2) {

  SHORT fline = WinQueryWindowUShort(hwnd,0);
  SHORT frameup;
  HWND  hwndSysmenu,hwndTitlebar,hwndMinmax;

  switch(msg) {
    case WM_CREATE:
      WinSetWindowUShort(hwnd,0,-1);
      WinSetPresParam(hwnd,PP_FONTNAMESIZE,
                      (ULONG)strlen("8.Helv.Bold") + 1L,
                      (PVOID)"8.Helv.Bold");
      WinCreateWindow(hwnd,WC_LISTBOX,(PSZ)NULL,WS_VISIBLE | LS_HORZSCROLL |
                      LS_NOADJUSTPOS,
                      0,0,0,0,hwnd,HWND_TOP,IDM_LOGLISTBOX,NULL,NULL);
      hwndSysmenu = WinWindowFromID(WinQueryWindow(hwnd,QW_PARENT,0),
                                    FID_SYSMENU);
      hwndTitlebar = WinWindowFromID(WinQueryWindow(hwnd,QW_PARENT,0),
                                     FID_TITLEBAR);
      hwndMinmax = WinWindowFromID(WinQueryWindow(hwnd,QW_PARENT,0),
                                   FID_MINMAX);
      WinSetWindowULong(hwnd,8,(ULONG)hwndSysmenu);
      WinSetWindowULong(hwnd,12,(ULONG)hwndTitlebar);
      WinSetWindowULong(hwnd,16,(ULONG)hwndMinmax);
      WinSetWindowUShort(hwnd,2,1);
      WinDefWindowProc(hwnd,msg,mp1,mp2);
      if(!set_saved_position(hwnd,"LogSizePos"))
        WinSendMsg(hwnd,WM_TILE,MPFROMLONG(0L),MPFROMLONG(0L));
      return 0;

    case WM_SETFOCUS:
      if(SHORT1FROMMP(mp1))
        WinPostMsg(hwnd,WM_FOCUSME,MPFROMLONG(0L),MPFROMLONG(0L));
      break;

    case WM_FOCUSME:
      WinSetFocus(hwnd,WinWindowFromID(hwnd,IDM_LOGLISTBOX));
      break;

    case WM_BUTTON2DBLCLK:
      WinPostMsg(hwnd,WM_HIDEME,MPFROMLONG(0L),MPFROMLONG(0L));
      break;

    case WM_HIDEME:
      frameup = WinQueryWindowUShort(hwnd,2);
      frameup = (frameup) ? 0 : 1;
      WinSetWindowUShort(hwnd,2,frameup);
      hwndSysmenu = (HWND)WinQueryWindowULong(hwnd,8);
      hwndTitlebar = (HWND)WinQueryWindowULong(hwnd,12);
      hwndMinmax = (HWND)WinQueryWindowULong(hwnd,16);
      if(!frameup) {
        WinSetParent(hwndSysmenu,HWND_OBJECT,FALSE);
        WinSetParent(hwndTitlebar,HWND_OBJECT,FALSE);
        WinSetParent(hwndMinmax,HWND_OBJECT,FALSE);
      }
      else {
        WinSetParent(hwndSysmenu,WinQueryWindow(hwnd,QW_PARENT,0),TRUE);
        WinSetParent(hwndTitlebar,WinQueryWindow(hwnd,QW_PARENT,0),TRUE);
        WinSetParent(hwndMinmax,WinQueryWindow(hwnd,QW_PARENT,0),TRUE);
      }
      WinSendMsg(WinQueryWindow(hwnd,QW_PARENT,0),WM_UPDATEFRAME,
                 MPFROMSHORT(FCF_TITLEBAR | FCF_SYSMENU | FCF_MINBUTTON),0L) ;
      return 0;

    case WM_TILE:
      {
        SWP swp;

        WinQueryWindowPos(WinQueryWindow(WinQueryWindow(hwnd,QW_PARENT,0),
                          QW_PARENT,0),&swp);
        WinSetWindowPos(WinQueryWindow(hwnd,QW_PARENT,0),HWND_TOP,
                        0,24,swp.cx / 2,(swp.cy / 2) - 12,
                        SWP_RESTORE | SWP_MOVE | SWP_SIZE | SWP_ZORDER);
      }
      return 0;

    case WM_CASCADE:
      {
        SWP swp;

        WinQueryWindowPos(WinQueryWindow(WinQueryWindow(hwnd,QW_PARENT,0),
                          QW_PARENT,0),&swp);
        WinSetWindowPos(WinQueryWindow(hwnd,QW_PARENT,0),HWND_TOP,
                        24,72,swp.cx - 72,swp.cy - 96,
                        SWP_RESTORE | SWP_MOVE | SWP_SIZE | SWP_ZORDER);
      }
      return 0;

    case WM_STATWIDE:
      WinSendMsg(hwnd,WM_TILE,MPFROMLONG(0L),MPFROMLONG(0L));
      return 0;

    case WM_LOGWIDE:
      {
        SWP swp;

        WinQueryWindowPos(GrandparentOf(hwnd),&swp);
        WinSetWindowPos(ParentOf(hwnd),HWND_TOP,
                        0,24,swp.cx,(swp.cy / 2) - 12,
                        SWP_RESTORE | SWP_MOVE | SWP_SIZE | SWP_ZORDER);
      }
      return 0;

    case WM_SETCP:
      {
        char s[81];

        WinSetWindowUShort(hwnd,0,SHORT1FROMMP(mp1));
        sprintf(s,"Recent events: %d",SHORT1FROMMP(mp1));
        WinSetWindowText(WinQueryWindow(hwnd,QW_PARENT,0),s);
        WinSendMsg(hwnd,WM_HIDEME,MPFROMLONG(0L),MPFROMLONG(0L));
        {
          PFNWP oldproc;

          oldproc = WinSubclassWindow(ParentOf(hwnd),(PFNWP)ChildFrameProc);
          WinSendMsg(ParentOf(hwnd),WM_SETCP,MPFROMP(oldproc),MPVOID);
        }
      }
      return 0;

    case WM_SIZE:
      WinSetWindowPos(WinWindowFromID(hwnd,IDM_LOGLISTBOX),HWND_TOP,
                      0,0,SHORT1FROMMP(mp2),SHORT2FROMMP(mp2),
                      SWP_SIZE | SWP_MOVE);
      break;

    case WM_PAINT:
      {
        RECTL rclUpdate;
        HPS hps;

        hps = WinBeginPaint(hwnd,0L,(PRECTL)&rclUpdate);
        WinFillRect(hps,(PRECTL)&rclUpdate,SYSCLR_DIALOGBACKGROUND);
        WinEndPaint(hps);
      }
      break;

    case WM_CONTROL:
      return 0;

    case WM_LOG:
      if(fline != -1 && (char *)mp2 && *(char *)mp2) {

        SHORT   which,logtype,top;
        char    datestr[12],timestr[12],*str;
        RECTL   rcl;

        str = (char *)mp2;
        logtype = SHORT2FROMMP(mp1);
        if(!(logtype & 3) || (logtype & 1)) {
          if(modems[fline] && modems[fline]->lf != -1) {
            _strdate(datestr);
            _strtime(timestr);
            ffprintf(modems[fline]->lf,"%s %s  %s\r\n",
                     datestr,timestr,str);
          }
        }
        if(!(logtype & 3) || (logtype & 2)) {
          which = (SHORT)WinSendDlgItemMsg(hwnd,IDM_LOGLISTBOX,
                                           LM_INSERTITEM,
                                           MPFROM2SHORT(LIT_END,0),
                                           MPFROMP(str));
          if(which > 200) {
            WinSendDlgItemMsg(hwnd,IDM_LOGLISTBOX,LM_DELETEITEM,
                              MPFROM2SHORT(0,0),MPFROMLONG(0L));
            which--;
          }
          else if(!which)
            WinSendDlgItemMsg(hwnd,IDM_LOGLISTBOX,LM_SELECTITEM,
                              MPFROM2SHORT(0,0),MPFROM2SHORT(TRUE,0));
          WinQueryWindowRect(WinWindowFromID(hwnd,IDM_LOGLISTBOX),&rcl);
          rcl.yTop -= WinQuerySysValue(HWND_DESKTOP,SV_CYHSCROLL);
          rcl.yTop /= 12L;
          which = (SHORT)WinSendDlgItemMsg(hwnd,IDM_LOGLISTBOX,
                                           LM_QUERYITEMCOUNT,
                                           MPFROMLONG(0L),MPFROMLONG(0L));
          if(which >= (SHORT)rcl.yTop) {
            top = (SHORT)WinSendDlgItemMsg(hwnd,IDM_LOGLISTBOX,
                                           LM_QUERYTOPINDEX,
                                           MPFROMLONG(0L),MPFROMLONG(0L));
            if(which - (SHORT)rcl.yTop <= top)
              WinSendDlgItemMsg(hwnd,IDM_LOGLISTBOX,LM_SETTOPINDEX,
                                MPFROM2SHORT(top + 1,0),MPFROMLONG(0L));
          }
        }
        if(str && !(logtype & 4))
          free(str);
      }
      return 0;

    case WM_CLOSE:
      WinSendMsg(WinQueryWindow(hwnd,QW_PARENT,0),WM_SYSCOMMAND,
                 MPFROM2SHORT(SC_MINIMIZE,0),MPFROMLONG(0L));
      return 0;
  }

  return WinDefWindowProc(hwnd,msg,mp1,mp2);
}
