/*********************************************/
/* This module is the 'heart' of the mailer. */
/* It handles most of the receive logic and  */
/* "waiting" state.  Ugly as hell.  Works.   */
/* To optimize, you'll need /B2 /C2L         */
/*********************************************/

#define INCL_WIN

#include <ctype.h>
#include <process.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "mailer.h"
#include "modem.h"
#include "transfer.h"
#include "nodelist.h"
#include "timers.h"
#include "xmisc.h"
#include "keys.h"
#include "window.h"
#include "xbbs.h"
#include "bbs.h"

    extern unsigned long callnowSEM[MAXINSTANCES];
    extern unsigned long killlogSEM[MAXINSTANCES];
    extern unsigned long initSEM[MAXINSTANCES];
    extern unsigned long mailSEM[MAXINSTANCES];
    extern unsigned long InactiveSEM[MAXINSTANCES];
    extern int           *_threadid;
    extern unsigned long EndMeSEM[MAXINSTANCES];
    extern HWND          xdhwnd;
    extern ADDR          *addresses;
    extern MDM           *modems[MAXINSTANCES];
    extern BBS           *bbs;
    extern ADDR          poll;
    extern unsigned long scannowSEM[MAXINSTANCES];
    extern unsigned long pollnowSEM[MAXINSTANCES];
    extern int           hydraok;


#define getrandom( min, max ) ((rand() % (int)(((max) + 1) - (min))) + (min))



void mailer (void *x) {

    USHORT         cp = *((USHORT *)x);
    USHORT         temp;
    clock_t        t1,t2;
    char           *s,*got,name[36];
    ADDR           addr,*myaddr;
    int            didsend,errcnt = 0,CTS = 1,RTS = 1,
                   polling,reqsok,DoingYooHoo;
    unsigned int   didmail = 0;
    clock_t        time_for_next_call,time_til_reinit;


    DosSleep(1000L);

    if(cp > MAXINSTANCES || !modems[cp])
      _endthread();

    DosSetPrty(2,modems[cp]->mailer[0],modems[cp]->mailer[1],*_threadid);
    modems[cp]->checkcd = 0;
    set_devctlblk(cp,0,0,1);
    DosDevIOCtl(NULL,NULL,0x48,1,modems[cp]->mh);

    s = (char *)malloc(1027);
    if(!s) {
      logfunc(0,cp,"Can't allocate any memory...");
      close_modem(cp);
      modems[cp]->threadid = -1;
      _endthread();
    }

    time_for_next_call = (clock_t)getrandom(60,180) * 1000L;  // configurable by event
    time_for_next_call += 60000L;
    time_for_next_call = timerset(time_for_next_call);

    memset(&addr,0,sizeof(ADDR));
    addr.next = NULL;

/* OpenLog */

    sprintf(s,"./XBBS%d.LOG",cp);
    modems[cp]->lf = sopen(s,O_NOINHERIT | O_RDWR | O_BINARY,SH_DENYWR);
    if(modems[cp]->lf != -1) {
      lseek(modems[cp]->lf,0L,SEEK_END);
      logfunc(0,cp,"XBBS up");
      goto ReStart;
    }
    modems[cp]->lf = sopen(s,O_NOINHERIT | O_CREAT | O_RDWR | O_BINARY,SH_DENYWR,S_IWRITE | S_IREAD);
    if(modems[cp]->lf == -1) {
      close_modem(cp);
      modems[cp]->threadid = -1;
      _endthread();
    }
    else
      lseek(modems[cp]->lf,0L,SEEK_END);
    DosQFHandState(modems[cp]->lf,&temp);
    DosSetFHandState(modems[cp]->lf,temp | (1 << 7));
    logfunc(1,cp,"XBBS 0.0 logfile");

ReStart:

    DosBufReset(modems[cp]->lf);
    Say_General("");
    if(didmail && *modems[cp]->extmail) {
      sessionf(D_LOCAL,cp,5,modems[cp]->extmail,bbs->inbound[modems[cp]->whichin]);
      didmail = 0;
    }

    modems[cp]->hisprodcode = 0;
    modems[cp]->brokenover = 0;
    modems[cp]->hefreqs = 1;
    modems[cp]->dietIFNA = 0;
    Change_Status("Initializing");
    modems[cp]->checkcd = 0;
    DosSemClear(&initSEM[cp]);
    set_baud(cp,modems[cp]->maxbaud,'N',8,1);
    Change_Baud(modems[cp]->maxbaud);
    Change_Last();

    DoingYooHoo = 0;
    unlock_out(&addr);
    polling = 0;
    time_til_reinit = timerset(600000L);  /* 10 minutes */
    myaddr = addresses;
    set_devctlblk(cp,0,CTS,RTS);
    sprintf(s,"%s/%08x.REQ",bbs->inbound[modems[cp]->whichin],*_threadid); /* get rid of leftover reqs */
    unlink(s);
    didsend = 0;
    modems[cp]->whichin = 0;
    raiseDTR(cp);
    dial_trans(cp,modems[cp]->init);
    purge_in(cp);
    if(modems[cp]->mh != -1) {

      struct _F67Info {
        unsigned char sigs;
      } F67Info;

      DosDevIOCtl(&F67Info,NULL,0x67,1,modems[cp]->mh);
      if(!(F67Info.sigs & 16)) {
        errcnt++;
        if(errcnt > 10) {
/* ScrewIt */
          Change_Status(" Shit, I'm screwed ");
          if(s) free(s);
          s = NULL;
          close_modem(cp);
          if(modems[cp]->id != -1) close(modems[cp]->id);
          if(modems[cp]->tt != -1) close(modems[cp]->tt);
          if(modems[cp]->lf != -1) close(modems[cp]->lf);
          modems[cp]->lf = -1;
          modems[cp]->id = -1;
          modems[cp]->tt = -1;
          DosSetPrty(2,4,31,*_threadid);
          DosSemSetWait(&EndMeSEM[cp],-1L);
          goto LayDownAndDie;
        }
        else if(errcnt > 5) {
          CTS = 0;
          RTS = 0;
          logfunc(0,cp,"Turned off CTS/RTS; some kind of modem problem");
        }
        DosSleep(1L);
        goto ReStart;
      }
    }

    Change_Status("Waiting for call");
    errcnt = 0;
    modems[cp]->dohydra = 0;
    for(;;) {

      if(!waiting_for_something(cp,time_for_next_call,time_til_reinit))
        break;

      if(DosSemWait(&EndMeSEM[cp],0L)) {

LayDownAndDie:

        Change_Status("Dead");
        logfunc(0,cp,"XBBS Down");
        if(s) free(s);
        if(modems[cp]->mh != -1) close_modem(cp);
        if(modems[cp]->id != -1) close(modems[cp]->id);
        if(modems[cp]->tt != -1) close(modems[cp]->tt);
        save_mdm(cp,modems[cp]);
        DosSemClear(&EndMeSEM[cp]);
        WinPostMsg(xdhwnd,WM_DEADLINE,MPFROM2SHORT(cp,0),(MPARAM)0);
        _endthread();
      }

      if(DosSemWait(&pollnowSEM[cp],0L)) {
        DosSemClear(&pollnowSEM[cp]);
        DosEnterCritSec();
         memcpy(&addr,&poll,sizeof(ADDR));
        DosExitCritSec();
        goto PollInterruptus;
      }

      if(DosSemWait(&InactiveSEM[cp],0L)) {
        close_modem(cp);
        close(modems[cp]->id);
        close(modems[cp]->tt);
        modems[cp]->id = modems[cp]->tt = -1;
        do {
          Change_Status("Inactive");
          DosSleep(500L);
          DosSemWait(&InactiveSEM[cp],-1L);
        } while(open_modem(cp));
        if(open_prompt_files(cp,(int)cp,&modems[cp]->id,&modems[cp]->tt)) {
          logfunc(0,cp,"Can't open prompt file(s)!");
          goto LayDownAndDie;
        }
        if(DosSemWait(&EndMeSEM[cp],0L)) {
          goto LayDownAndDie;
        }
        goto ReStart;
      }

      if(DosSemWait(&initSEM[cp],0L)) {
        goto ReStart;
      }

      if(DosSemWait(&mailSEM[cp],0L)) {
        logfunc(1,cp,"Mail processing requested");
        DosSemClear(&mailSEM[cp]);
        didmail++;
        goto ReStart;
      }

      if(DosSemWait(&callnowSEM[cp],0L)) {
        DosSemClear(&callnowSEM[cp]);
        logfunc(1,cp,"Immediate call requested");
        goto ImmediateCall;
      }

      if(DosSemWait(&scannowSEM[cp],0L)) {
        DosSemClear(&scannowSEM[cp]);
        scan_outbound(cp);
        continue;
      }

      if(DosSemWait(&pollnowSEM[cp],0L)) {
        DosSemClear(&pollnowSEM[cp]);
        polling = 1;
        goto PollInterruptus;
      }

      if(DosSemWait(&killlogSEM[cp],0L)) {
        DosSemClear(&killlogSEM[cp]);
        logfunc(2,cp,"Killed log file");
        DosSleep(500L);
        DosNewSize(modems[cp]->lf,0L);
        DosSleep(100L);
        DosBufReset(modems[cp]->lf);
        lseek(modems[cp]->lf,0L,SEEK_SET);
        logfunc(1,cp,"XBBS 0.0 logfile");
        continue;
      }

      if(timeup(time_for_next_call) && modems[cp]->dialoutok) {

ImmediateCall:

        time_for_next_call = (clock_t)getrandom(60,180) * 1000L;  // configurable by event
        time_for_next_call += 60000L;
        time_for_next_call = timerset(time_for_next_call);
        purge_in(cp);
        scan_outbound(cp);

        /* check for someone calling in while we're calling out... */

        {
            unsigned int len;

            len = get_modem_block(cp,s,80,0L);
            if(len > 0 && strstr(s,"RING\r") && modems[cp]->answerok) {
                if(anyone_to_call(cp,&addr,polling)) {
                    DosSemSet(&pollnowSEM[cp]);
                }
                break;
            }
        }

        if(anyone_to_call(cp,&addr,polling)) {
PollInterruptus:
          myaddr = best_guess(&addr,addresses); /* guess who we are */
          logfunc(1,cp,"Calling as %s#%u:%u/%u.%u",myaddr->domain,myaddr->zone,
                  myaddr->net,myaddr->node,myaddr->point);
          temp = (USHORT)dial_out(cp,&addr,&myaddr,polling,&DoingYooHoo);
          if(temp == 1) {
            didsend = 1;
            goto GetTsync;
          }
          else if(temp == 2) {
            didsend = 1;
            goto BatchReceive;
          }
          else if(temp == (USHORT)-2) {
            logfunc(1,cp,"Incoming call?");
            Change_Status("Incoming call?");
            goto TryToConnect;
          }
          goto ReStart;
        }
        else {
          Say_General("No one to call");
        }
      }

      if(timeup(time_til_reinit)) {
        temp = (USHORT)((rand() % 5) + 1);
        switch(temp) {
          case 1:
                    Say_General("Snore");
                    break;
          case 2:
                    Say_General("Grunt");
                    break;
          case 3:
                    Say_General("Shnork");
                    break;
          case 4:
                    Say_General("Cough");
                    break;

          default:
                    Say_General("Braaap");
                    break;
        }
        save_mdm(cp,modems[cp]);
        goto ReStart;
      }

      polling = 0;
    }

    logfunc(1,cp,"Answering RING");
    Change_Status("Answering RING");

TryToConnect:

    modems[cp]->dohydra = 0;
    dial_trans(cp,modems[cp]->answer);

    *s = 0;
    modems[cp]->curbaud = detect_baud(cp,40000L,s);
    if(!modems[cp]->curbaud || checkcarrier(cp)) {
      logfunc(0,cp,"No connect (%s)",s);
      goto ReStart;
    }
    else {
      logfunc(0,cp,"%s",s);
    }

    Change_Baud(modems[cp]->curbaud);
    if(!modems[cp]->locked)
      set_baud(cp,modems[cp]->curbaud,'N',8,1);
    Change_Status("Connect");
    if(modems[cp]->curbaud < modems[cp]->minmailbaud && modems[cp]->curbaud < modems[cp]->minbaud) {
      com_write(cp,modems[cp]->tooslow,strlen(modems[cp]->tooslow));
      flushout(cp);
      logfunc(0,cp,"%u baud caller rejected",modems[cp]->curbaud);
      DosSleep(750L);
      goto ReStart;
    }

    modems[cp]->checkcd = 1;

    DosSleep(5000L);
    purge_in(cp);
    com_write(cp,"\r\nXBBS OS/2 v0.0\r\n",18);
    if(!modems[cp]->humansok || diff_stime(&modems[cp]->beginZMH,&modems[cp]->endZMH) == 1) {
      com_write(cp,modems[cp]->mailonly,strlen(modems[cp]->mailonly));
    }
    else {
      com_write(cp,modems[cp]->banner,strlen(modems[cp]->banner));
    }

/* TryYooHoo */

    if(modems[cp]->fts0001)
      goto GetTsync;

    temp = (USHORT)recv_yoohoo(cp,&addr,&myaddr,name,&reqsok);
    Say_General("");
    switch(temp) {
      case TSYNCH:    if(modems[cp]->curbaud < modems[cp]->minmailbaud) {
                        com_write(cp,modems[cp]->tooslow,strlen(modems[cp]->tooslow));
                        logfunc(0,cp,"FTS-0001 %u baud caller rejected",modems[cp]->curbaud);
                        DosSleep(750L);
                        goto ReStart;
                      }
                      Change_Status("FTS-0001");
                      logfunc(1,cp,"********FTS-0001");
                      goto GotTsync;

      case YOOHOO:    if(modems[cp]->curbaud < modems[cp]->minmailbaud) {
                        com_write(cp,modems[cp]->tooslow,strlen(modems[cp]->tooslow));
                        logfunc(0,cp,"FTS-0006 %u baud caller rejected",modems[cp]->curbaud);
                        DosSleep(750L);
                        goto ReStart;
                      }
                      Change_Status("dietIFNA");
                      logfunc(1,cp,"********dietIFNA");
                      DoingYooHoo = 1;
                      modems[cp]->lastaddress.zone = addr.zone;
                      modems[cp]->lastaddress.net = addr.net;
                      modems[cp]->lastaddress.node = addr.node;
                      modems[cp]->lastaddress.point = addr.point;
                      strcpy(modems[cp]->lastaddress.domain,addr.domain);
                      modems[cp]->wasbbs = 0;
                      Change_Last();
                      goto BatchReceive;

      default:        if(modems[cp]->curbaud < modems[cp]->minbaud) {
                        com_write(cp,modems[cp]->tooslow,strlen(modems[cp]->tooslow));
                        logfunc(0,cp,"Human %u baud caller rejected",modems[cp]->curbaud);
                        DosSleep(750L);
                        goto ReStart;
                      }
                      if(!modems[cp]->humansok || diff_stime(&modems[cp]->beginZMH,&modems[cp]->endZMH) == 1) {
                        logfunc(0,cp,"Dumped human");
                        com_write(cp,modems[cp]->mailonly,
                                  strlen(modems[cp]->mailonly));
                      }
                      else {
                        Change_Status("Human");
                        strcpy(modems[cp]->name,name);
                        crankup_bbs(&cp);
                      }
                      goto ReStart;
    }

GetTsync:

    if(didsend) {
      logfunc(1,cp,"***Turnaround");
      Change_Status("Turnaround");
      if(didmail && *modems[cp]->extmail) {
        sessionf(D_LOCAL,cp,5,modems[cp]->extmail,bbs->inbound[modems[cp]->whichin]);
        didmail = 0;
      }
    }
    else
      Change_Status("Negotiating");
    t1 = timerset(30000L);

    while(!timeup(t1)) {

      char lastret = 0,lastesc = 0;

      DosSleep(32L);
      temp = (USHORT)peek_at_byte(cp,5000L);
      switch(temp) {
        case LOSTCARRIER:
LostItT:
                            logfunc(0,cp,"Lost carrier");
                            goto ReStart;

        case ESC:           if(!didsend) {
                              if(lastesc > 1) {
                                if(!modems[cp]->humansok || diff_stime(&modems[cp]->beginZMH,&modems[cp]->endZMH) == 1) {
                                  logfunc(0,cp,"Dumped human");
                                  com_write(cp,modems[cp]->mailonly,
                                            strlen(modems[cp]->mailonly));
                                  goto ReStart;
                                }
                                else if(modems[cp]->curbaud < modems[cp]->minbaud) {
                                   com_write(cp,modems[cp]->tooslow,strlen(modems[cp]->tooslow));
                                   logfunc(0,cp,"Human %u baud caller rejected",modems[cp]->curbaud);
                                   DosSleep(750L);
                                   goto ReStart;
                                }
                                else {
                                  Change_Status("Human");
                                  crankup_bbs(&cp);
                                }
                              }
                            }
                            lastesc++;
                            get_modem_byte(cp,32L);
                            break;

            case '\r':      if(!didsend) { /* catch late whackers */
                              if(lastret > 1) {
                                if(modems[cp]->curbaud < modems[cp]->minbaud) {
                                  com_write(cp,modems[cp]->tooslow,strlen(modems[cp]->tooslow));
                                  logfunc(0,cp,"Human %u baud caller rejected",modems[cp]->curbaud);
                                  DosSleep(750L);
                                  goto ReStart;
                                }
                                if(modems[cp]->humansok && diff_stime(&modems[cp]->beginZMH,&modems[cp]->endZMH) != 1) {
                                  Change_Status("Human");
                                  crankup_bbs(&cp);
                                }
                                else {
                                  com_write(cp,modems[cp]->mailonly,
                                            strlen(modems[cp]->mailonly));
                                  Change_Status("Human");
                                  logfunc(0,cp,"Dumped human");
                                  goto ReStart;
                                }
                              }
                              com_putc(cp,'\r');
                              if(!modems[cp]->humansok || diff_stime(&modems[cp]->beginZMH,&modems[cp]->endZMH) == 1) {
                                com_write(cp,modems[cp]->mailonly,
                                          strlen(modems[cp]->mailonly));
                              }
                              else {
                                com_write(cp,modems[cp]->banner,
                                          strlen(modems[cp]->banner));
                              }
                            }
                            if(!lastret)
                              purge_in(cp);
                            lastret++;
                            get_modem_byte(cp,32L);
                            break;

        case TSYNCH:        if(modems[cp]->curbaud < modems[cp]->minmailbaud) {
                              com_write(cp,modems[cp]->tooslow,strlen(modems[cp]->tooslow));
                              logfunc(0,cp,"FTS-0001 %u baud caller rejected",modems[cp]->curbaud);
                              DosSleep(750L);
                              goto ReStart;
                            }
                            get_modem_byte(cp,32L);
                            goto GotTsync;

        default:            if(checkcarrier(cp)) goto LostItT;
                            get_modem_byte(cp,32L);
                            if(didsend) {
                              switch(temp) {
                                case SYN:   temp = recv_bark(cp,
                                                             myaddr,
                                                             &addr,1);
                                            if(!temp)
                                              t1 = timerset(30000L);
                                              break;

                                case ENQ:   temp = send_bark(cp,
                                                             &addr);
                                            if(!temp || temp == 1 || temp == 2)
                                              t1 = timerset(30000L);
                                            break;

                                case 'C':
                                case NAK:   com_putc(cp,EOT);
                                            break;

                                default:    com_putc(cp,SUB);
                                            break;
                              }
                            }
                            lastret = lastesc = 0;
                            break;
      }
    }
    logfunc(0,cp,"Receive negotiation timeout");
    goto ReStart;

GotTsync:

    sprintf(s,"%04x%04x.PKT",(int)(time(NULL) & 0xffffL),*_threadid);

    got = recv_file(cp,s,0,bbs->inbound[0]);

    if(got && strnicmp(got,";Aborted",9)) { /* Find out who mail is from */
      didmail++;
      temp = (USHORT)who_is_it(cp,&got,s,&addr,didsend); /* guess who he is */
      lock_out(&addr);      /* lock him so other lines don't call him */
      free(got);
      if(!didsend) {
        modems[cp]->lastaddress.zone=addr.zone;
        modems[cp]->lastaddress.net=addr.net;
        modems[cp]->lastaddress.node=addr.node;
        modems[cp]->lastaddress.point=addr.point;
        strcpy(modems[cp]->lastaddress.domain,addr.domain);
        myaddr = best_guess(&addr,addresses); /* guess who we are */
        logfunc(1,cp,"Responding as %s#%u:%u/%u.%u",myaddr->domain,myaddr->zone,
                myaddr->net,myaddr->node,myaddr->point);
        if(!temp) {             /* password mismatch */
          unlock_out(&addr);
          goto ReStart;
        }
        else if(temp == (USHORT)-1) {   /* unlisted node */
          /* ??? */
        }
        modems[cp]->wasbbs = 0;
        Change_Last();
      }
    }
    else {
      logfunc(0,cp,"Receive error, FTS-0001 session terminated");
      if(didsend)
        inc_calls(&addr,1);
      goto ReStart;
    }

BatchReceive:

    if(modems[cp]->dohydra && hydraok) {

      int         handle;
      FILEFINDBUF f;
      HDIR        hDir = HDIR_CREATE;
      USHORT      nm = 1;
      char        s[513],s2[81];

      logfunc(1,cp,"Hydra kludge running...");
      Change_Status("Hydra Mail");
      sprintf(s,"SENDMAIL.%u",cp);
      unlink(s);
      handle = sopen(s,O_RDWR | O_CREAT | O_BINARY,SH_DENYWR,S_IWRITE | S_IREAD);
      if(handle != -1) {
        make_dirname("*",s,&addr);
        if(!DosFindFirst(s,&hDir,0,&f,sizeof(FILEFINDBUF),&nm,0L)) {
          do {
            if(toupper(*f.achName) == 'A') {
              ffprintf(handle,"%s\\%s ^%04x%04x.MO0\r\n",d_outbound,f.achName,
                       myaddr->net - addr.net,myaddr->node - addr.node);
            }
            else if(toupper(*f.achName) == 'P') {
              ffprintf(handle,"%s\\%s ^%08x.PKT\r\n",d_outbound,f.achName,
                       clock());
            }
            else if(toupper(*f.achName) == 'R') {
              ffprintf(handle,"%s\\%s ^%04x%04x.REQ\r\n",d_outbound,f.achName,
                       myaddr->net - addr.net,myaddr->node - addr.node);
            }
            else {
              sprintf(s,"%s\\%s",d_outbound,f.achName);
              sprintf(s2,"SENDMAIL.%u",cp);
              DosCopy(s,s2,DCPY_APPEND,0L);
            }
            nm = 1;
          } while(!DosFindNext(hDir,&f,sizeof(FILEFINDBUF),
                               &nm));
          DosFindClose(hDir);
        }
        close(handle);
      }
      wait_sessionf(D_LOCAL,cp,0,"HYDRA.EXE -P%u handshake HARD "
                    "log XBBS%u.LOG level 6 speed %u line %u "
                    "mailer receive %s send "
                    "@SENDMAIL.%u",modems[cp]->mh,cp,
                    (modems[cp]->locked) ? modems[cp]->maxbaud :
                    modems[cp]->curbaud,modems[cp]->curbaud,
                    bbs->inbound[modems[cp]->whichin],cp);
      wait_sessionf(D_LOCAL,cp,0,"HYDRA.EXE -P%u handshake HARD "
                    "log XBBS%u.LOG level 6 speed %u line %u"
                    "mailer receive %s send",
                    modems[cp]->mh,cp,
                    (modems[cp]->locked) ? modems[cp]->maxbaud :
                    modems[cp]->curbaud,modems[cp]->curbaud,
                    bbs->inbound[modems[cp]->whichin]);
      goto EndSession;
    }

    Change_Status("Batch receive");
    purge_in(cp);

    for(;;) {

      int bad = 0;

      got = NULL;
      t1 = timerset(30000L);
      t2 = timerset(180000L);

      if(!DoingYooHoo) {

AfterNUL:

        DosSleep(32L);
        temp = (USHORT)modem7_recv(cp,s);

        switch(temp) {
          case LOSTCARRIER:
LostIt:
            logfunc(0,cp,"Lost carrier during batch receive");
            goto ReStart;

          case TIMEOUT:
            logfunc(0,cp,"Timed out on batch receive");
            goto ReStart;

          case SUB:
          case EOT:
            com_putc(cp,ACK);
            DosSleep(250L);
            purge_in(cp);
            logfunc(0,cp,"Received EOT to end batch receive; ACKed");
            goto MailDone;

          case SOH:
          case SYN:
            got = recv_file(cp,s,0,bbs->inbound[modems[cp]->whichin]);
            if(got && strnicmp(got,";Aborted",9)) {
              didmail++;
            }
            break;

          case NUL:
            t1 = timerset(30000L);
            goto AfterNUL;

          default:
            if(checkcarrier(cp)) goto LostIt;
            got = recv_file(cp,s,0,bbs->inbound[modems[cp]->whichin]);
            if(got && strnicmp(got,";Aborted",9)) {
              didmail++;
            }
            break;
        }
      }
      else {

        int retries;

        if(didsend)
          retries = 10;
        else
          retries = 0;

        Say_General("Looking for file...");
        got = NULL;

        while(retries < 20 && !timeup(t1) && !timeup(t2)) {

/* ContLoop */

          *s = 0;
          com_putc(cp,'C');
          DosSleep(32L);
          temp = (USHORT)peek_at_byte(cp,2000L);

/* ReSwitch */

          switch(temp) {
            case TIMEOUT:
              Say_General("Batch receiver timeout");
              retries++;
              break;

            case TSYNCH:
            case ACK:
              Say_General("Batch receiver got TSYNC/ACK");
              get_modem_byte(cp,32L);
              retries++;
              break;

            case 'C':
            case NAK:
              get_modem_byte(cp,32L);
              if(didsend) {
                Say_General("Batch receiver sending EOT to C/NAK");
                com_putc(cp,EOT);
                DosSleep(250L);
              }
              else
                Say_General("Batch receiver got C/NAK");
              break;

            case LOSTCARRIER:
LostItD:
              if(!didsend) {
                logfunc(0,cp,"Batch receiver lost carrier");
                goto ReStart;
              }
              else
                goto EndSession;

            case SOH:
            case SYN:
              Say_General("Batch receiver got SOH/SYN; receiving...");
              got = recv_file(cp,s,255,bbs->inbound[modems[cp]->whichin]);
              if(got && strnicmp(got,";Aborted",9)) {
                didmail++;
              }
              break;

            case SUB:
            case EOT:
              get_modem_byte(cp,32L);
              if(temp == EOT || (temp == SUB && retries < 5)) {
                com_putc(cp,ACK); /* ack EOT */
                logfunc(2,cp,"Received EOT/SUB (%d) to end session; ACKed",temp);
                DosSleep(250L);
                purge_in(cp);
              }
              else
                logfunc(2,cp,"Received EOT/SUB (%d) to end session",temp);
              goto MailDone;

            case NUL:
              Say_General("Received NUL; buying time");
              get_modem_byte(cp,32L);
              t1 = timerset(30000L);
              break;

            default:
              if(checkcarrier(cp))
                goto LostItD;
#ifdef DEBUG
              {
                char tchar = ' ';

                if(isalpha(temp) || isdigit(temp))
                  tchar = (char)temp;
                logfunc(2 + 32767,cp,"Batch receiver ignoring %d \'%c\'",temp,tchar);
              }
#endif
              retries++;
              get_modem_byte(cp,32L);
              break;
          }
        }
      }

      if(got) {
        didmail++;
        free(got);
        got = NULL;
        bad = 0;
        t2 = timerset(180000L);
      }
      else {
        bad++;
        if(bad > 4) {
          if(didsend)
            inc_calls(&addr,1);
          break;
        }
      }

      DosSleep(250L);
      purge_in(cp);
    }

MailDone:

    if(!didsend) {
      if(addr.net) {
        logfunc(1,cp,"***Turnaround");
        Change_Status("Turnaround");
        if(didmail && *modems[cp]->extmail) {
            sessionf(D_LOCAL,cp,5,modems[cp]->extmail,bbs->inbound[modems[cp]->whichin]);
            didmail = 0;
          }
        Say_General("");
        if(!send_mail(cp,&addr,myaddr,"",1,
                      polling,DoingYooHoo)) {
          goto ReStart;
        }
        goto ReStart;
      }
    }

EndSession:

    Change_Status("End session");
    logfunc(1,cp,"********End session");
    dropDTR(cp);
    goto ReStart;
}
