/*******************************************/
/* Miscellaneous structures used by mailer */
/*******************************************/

#ifndef OS2_INCLUDED
 #define  INCL_DOS
 #define  INCL_VIO
 #define  INCL_RXSUBCOM
 #define  INCL_RXSYSEXIT

 #include <os2.h>
#endif

#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#ifndef MPVOID
 #define MPVOID MPFROMLONG(0L)
#endif

#define XBBSPRODCODE    0xcf
#define XBBSVERMAJOR    0
#define XBBSVERMINOR    0

/* warning:  if you make this higher than 40, you'll need to modify
 * the MSC runttime to allow more than 40 files to be fopened (see
 * MSC docs)
 */
#define MAXINSTANCES      17

/* Used by directory listing functions */

#define MAX_FILENAME_SIZE 257
#define MAX_FILENAME_LEN  1025

#define ITSAUSER          32767

    struct _addresses {
        unsigned int      zone;
        unsigned int      net;
        unsigned int      node;
        unsigned int      point;
        char              domain[9];
        struct _addresses *next;
    };

    typedef struct _addresses ADDR;

#define O_CRASH       0x0001
#define O_DIRECT      0x0002
#define O_NORMAL      0x0004
#define O_HOLD        0x0008
#define O_MANUAL      0x0010
#define O_REQUEST     0x0020
#define O_ARCHIVE     0x0040
#define O_PACKET      0x0080

/* the next flag is used to prevent contention between lines; if an address */
/* is locked, other lines don't consider it eligible to be called */

#define O_LOCKED      0x8000

    struct _outbound {
        unsigned int
            zone,
            net,
            node,
            point;
        char domain[9];
        unsigned int types;
        int cost;
        unsigned int calls;
        unsigned int bad;
        unsigned int baud;
        struct _outbound *next;
    };

    typedef struct _outbound OUTBOUND;

/* Packet header structure per FSC-0045 */

    struct _pkthdr {
        unsigned int
            onode,
            dnode,
            opoint,
            dpoint;
        char
            zeros[8];
        unsigned int
            subver,
            version,
            onet,
            dnet;
        char
            product,
            rev_lev,
            password[8];
        unsigned int
            ozone,
            dzone;
        char
            odomain[8],
            ddomain[8];
        long
            specific;
        unsigned int
            first;
    };

    typedef struct _pkthdr PKTHDR;

/* older packet header structure */

    struct _old_pkthdr {
      unsigned int
        orig_node,             /* originating node */
        dest_node,             /* destination node */
        year,                  /* 1989 - nnnnn */
        month,
        day,
        hour,
        minute,
        second,
        rate,                  /* unused */
        ver,                   /* 2 */
        orig_net,              /* originating net */
        dest_net;              /* destination net */
      char
        product,
        rev_lev,               /* revision level */
        password[8];
      unsigned int
        qm_orig_zone,
        qm_dest_zone;
      char
        domain[8];
      unsigned int
        orig_zone,             /* originating zone */
        dest_zone,             /* destination zone */
        orig_point,            /* originating point */
        dest_point;            /* destination point */
      long
        pr_data;
      int
        zero;                  /* ???? */
    };

    typedef struct _old_pkthdr OLDPKTHDR;

#ifndef SIMPLETIME
    typedef struct {
        char hour;
        char min;
        char sec;
    } STIME;
    #define SIMPLETIME
#endif

    /* Note: this is constructed this way (no malloced pointers) so it
       can be saved 'en masse' */

    struct __modemhandles__ {       /* controls per line */

        /* miscellaneous handles */

        HFILE mh;                   /* handle for commport */
        USHORT cp;                  /* commport # (1 for COM1) */
        int threadid;               /* thread for this line */
        HFILE lf;                   /* handle of log file */

        /* miscellaneous strings */

        char init[128];             /* modem init string */
        char dpre[128];             /* dial prefix */
        char dsuf[32];              /* dial suffix */
        char dprevar[8][128];       /* dial prefixes--variant */
        char dsufvar[8][32];        /* dial suffixes--variant */
        char answer[64];            /* answer string */
        char extmail[128];          /* invoked after receiving mail */
        char banner[161];           /* if accepting humans */
        char mailonly[161];         /* if not accepting humans */
        char tooslow[161];          /* if baudrate too low by event */
        char curstatus[81];         /* current status this line */

        /* miscellaneous numbers */

        unsigned int    maxbaud;       /* init baud */
        unsigned int    minbaud;       /* minimum human baud */
        unsigned int    minmailbaud;   /* minimum machine baud */
        unsigned int    mincallbaud;   /* minimum dialout baud */
        unsigned int    maxcallbaud;   /* maximum dialout baud */
        unsigned int    curbaud;       /* actual connect baud */
        unsigned int    mincost;       /* minimum dialout cost */
        unsigned int    maxcost;       /* maximum dialout cost */
        unsigned long   maxmailk;      /* max k for one session */
        unsigned long   maxmailtime;   /* max secs for one session */
        unsigned long   maxmailmisc;   /* dunno yet */
        time_t          nextevent;     /* time til next event */
        unsigned int    maxbad;        /* max bad calls til no more calls */
        unsigned int    maxtries;      /* max times to call */

        /* Miscellaneous flags */

        unsigned int locked:     1;  /* locked baudrate? */
        unsigned int humansok:   1;  /* allow humans? */
        unsigned int rfreqsok:   1;  /* allow freqs? */
        unsigned int sfreqsok:   1;  /* send freqs? */
        unsigned int dialoutok:  1;  /* dial out? */
        unsigned int answerok:   1;  /* answer? */
        unsigned int hefreqs:    1;  /* he takes freqs? */
        unsigned int fts0001:    1;  /* only FTS0001 protocol */
        unsigned int recvunk:    1;  /* receive from unlisted nodes? */
        unsigned int sendunk:    1;  /* send to unlisted nodes? */
        unsigned int wasbbs:     1;  /* last was BBS, not mail */
        unsigned int hesbroken:  1;  /* Binkley's not FTS-0006 compatible... */
        unsigned int whichin:    2;  /* 0-2 valid; which inbound/okfile to use */
        unsigned int brokenover: 1;  /* no overdrive for this turkey... */
        unsigned int noslo:      1;  /* no overdrive */
        unsigned int nosealink:  1;  /* no sealink */
        unsigned int sea1k:      1;  // unused
        unsigned int no1k:       1;  /* 1-K disallowed */
        unsigned int dietIFNA:   1;  /* not FTS-0001 */
        unsigned int inchat:     1;  /* in chat mode */
        unsigned int debugtrans: 1;  /* log debug info during user transfers? */
        unsigned int dohydra:    1;  /* use hydra protocol? */
        unsigned int reserved2:  1;

        /* addresses */

        ADDR *curraddress;          /* current address */
        ADDR lastaddress;           /* last address communicated with */

        /* semaphores */

        unsigned long bbsrunningSEM;     /* set if user is in BBS */
        unsigned long amchattingSEM;
        unsigned long amexportingSEM;    /* set while exporting */
        unsigned long amoutsideSEM;
        unsigned long amdonexportingSEM; /* set when export complete */

        /* bs */

        int hisprodcode;

        /* priorities */

        int mailer[2],
            comm[2],          /* send protos */
            bbs[2],
            export[2],
            outside[2],
            transfer[2];      /* receive protos */

        /* miscellanous timeslots */

        STIME beginZMH;
        STIME endZMH;

        /* handle for prompt files */

        HFILE id;       /* index */
        HFILE tt;       /* text */

        /* international crap */

        char YES;
        char NO;
        char STOP;
        char PAUSE;
        char QUIT;
        char **afmsg;
        char **hdr;
        char name[36];  /* name entered */
        int  maxresyncs;
        int  maxtranserrs;
        char lastusername[39];
        char lastmailer[85];
        char lastlog[82];
        char lastmisc3[60];
        char general[82];
        char Last[82];

        /* modem control junk */

        DCBINFO save_di;
        int     checkcd;

        /* son of misc junk */

        long pipereadSEM;
        char laststring[81];

        /* used to build directory strings */

        char builddir[1052];

        /* video handle to bbs box */

        int VidHandle;

        clock_t lastt2;

        /* expansion area */

        char reserved_junk[1018];   /* for expansion */
    };

    typedef struct __modemhandles__ MDM;

#ifndef INDEXESDEFINED
    typedef struct {
      int to;
      int from;
      int subj;
      long msgidcrc;
      long msgidserialno;
      long replycrc;
      long replyserialno;
    } INDEXES;
  #define INDEXESDEFINED
#endif

extern char d_nodelist[1025];
extern char d_msg[1025];
extern char d_outbound[1025];
extern char d_menu[1025];
extern char d_help[1025];
extern char d_text[1025];
extern char d_news[1025];
extern char d_misc[1025];
extern char d_miscnews[1025];
extern char d_packets[1025];
extern char d_xport[1025];

/* mailer functions */

void logfunc (int which,USHORT cp,char *szFormat, ...);
void mailer (void *x);
int _fastcall set_com_buffers (USHORT cp);
int _fastcall init_all (void);
int _fastcall scan_outbound (USHORT cp);
int _fastcall anyone_to_call (USHORT cp,ADDR *addr,int manual);
void _fastcall unlock_out (ADDR *addr);
void _fastcall lock_out (ADDR *addr);
int _fastcall is_locked_out (ADDR *addr);
void _fastcall inc_calls (ADDR *addr,int badtoo);
void _fastcall clear_outs(void);
char * _fastcall getblock (USHORT cp,char *buf,int blksize,int chktec);
char * _fastcall recv_file (USHORT cp,char *filename,int altentry,
                            char *prepath);
long _fastcall send_file (USHORT cp,char *filename,int altentry,
                         int chktec,int justxmodem,int overdriveok,
                         char *fakename);
int _fastcall send_cancel (USHORT cp,int howmany);
int _fastcall parse_addr (char **p, ADDR *r,ADDR *rr);
int _fastcall guess_rest (ADDR *r, ADDR *m);
ADDR * _fastcall best_guess (ADDR *r,ADDR *m);
int _fastcall dial_out (USHORT cp,ADDR *addr,ADDR **myaddr,
                        int polling,int *DoingYooHoo);
int _fastcall send_mail (USHORT cp,ADDR *addr,ADDR *myaddr,char *password,
                         int didrecv,int polling,int DoingYooHoo);
int _fastcall recv_yoohoo (USHORT cp,ADDR *addr,ADDR **myaddr,char *name,
                           int *reqsok);
int _fastcall send_yoohoo (USHORT cp,ADDR *addr,ADDR **myaddr,char *password);
int _fastcall recv_hello (USHORT cp,struct __Hello__ *hello,ADDR *addr,
                          ADDR **myaddr);
int _fastcall send_hello (USHORT cp,struct __Hello__ *hello,ADDR *addr,
                          char *password);
int _fastcall recv_bark (USHORT cp,ADDR *myaddr,
                         ADDR *addr,int honor);
long _fastcall send_req_file (USHORT cp,char *fname,
                              char sign,long date,char *password,
                              int DoingYooHoo,ADDR *myaddr,
                              ADDR *addr,char *oargs);
struct _filelist * _fastcall find_req_file (USHORT cp,char *fname,
                                            char sign,long date,
                                            char *password,ADDR *addr,
                                            char *oargs,int *error);
int _fastcall check_wildcard (char *mask,char *filename);
int _fastcall send_bark (USHORT cp,ADDR *addr);
int _fastcall rebuild_list (int handle,long pos,char *was,
                            ADDR *addr);
int _fastcall who_is_it (USHORT cp,char **got,char *s,
                         ADDR *addr,int didsend);
PKTHDR * _fastcall fill_in_pkt_hdr (PKTHDR *pkt,ADDR *myaddr,
                                    ADDR *addr,char *password);
int _fastcall make_pkt (PKTHDR *pkt,char *to,char *from,char *subj,
                        char *msgtxt);
int _fastcall make_pkt_from_file (PKTHDR *pkt,char *to,char *from,char *subj,
                                  char *filename);
int _fastcall kill_pkt (void);
long _fastcall wazoo_reqs (USHORT cp,ADDR *addr,ADDR *myaddr);
char * _fastcall make_dirname (char *pre,char *s,ADDR *addr);
void logfmain (char *szFormat, ...);
int _fastcall set_mailer_defaults (USHORT cp);
int _fastcall set_bbs_defaults(USHORT cp);
void _fastcall update_screen (void);
void crankup_bbs (void *m);
int _fastcall is_an_inbound (char *s);
int _fastcall save_mdm(USHORT cp,MDM *m);
char * _fastcall sayn (int mode,USHORT cp,USHORT pnum,char *buf,int len);
int _fastcall waiting_for_something (USHORT cp,clock_t time_for_next_call,
                                     clock_t time_til_reinit);
int _fastcall make_fts1plus_pkt_from_file (PKTHDR *pkt,ADDR *hisaddr,
                                           ADDR *myaddr);
void * _fastcall memdupe (void *buf,int size);
