/*******************************************************/
/* This module performs Bark file requests...receiving */
/*******************************************************/

#include <process.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <ctype.h>
#include "mailer.h"
#include "bbs.h"
#include "modem.h"
#include "transfer.h"
#include "timers.h"
#include "xmisc.h"


#pragma optimize("",off)

    extern char *progname;
    extern MDM  *modems[MAXINSTANCES];
    extern int  *_threadid;
    extern BBS  *bbs;


    struct _filelist {
        char *name;
        struct _filelist *next;
    };


    int _fastcall get_bark_pkt (USHORT cp,char *fname,long *date,
                            char *password);
    void _fastcall free_the_list (struct _filelist *top);


int _fastcall recv_bark (USHORT cp,ADDR *myaddr,
                         ADDR *addr,int honor) {

    char *s,fname[17],password[9];
    int  temp;
    long date;
    char sign=0;
    clock_t t1,t2,t3;

    s = (char *)malloc(1027);
    if(!s || !honor) {
        if(s) free(s);
        send_cancel(cp,1);
        return NAK;
    }

    t3 = timerset(60000L);

SetTimer:

    t2 = timerset(20000L);

Send:

    if(timeup(t3)) {
      logfunc(0,cp,"Request receive timeout");
      free(s);
      return TIMEOUT;
    }
    purge_in(cp);
    com_putc(cp,ENQ);
    t1 = timerset(2000L);

    while(!timeup(t2)) {
        temp = get_modem_byte(cp,3000L);
        switch(temp) {
            case TIMEOUT:   goto Send;

            case LOSTCARRIER: free(s);
                              return LOSTCARRIER;

            case ACK:       if(!modems[cp]->rfreqsok) {
                              logfunc(0,cp,"Refused remote's request");
                              com_putc(cp,CAN);
                              break;
                            }
                            temp = get_bark_pkt(cp,fname,&date,password);
                            switch(temp) {
                                case 0:     send_req_file(cp,
                                                          fname,sign,date,
                                                          password,0,myaddr,
                                                          addr,NULL);
                                            com_putc(cp,EOT);
                                            t3=timerset(60000L);
                                            goto SetTimer;

                                case LOSTCARRIER:
                                case TIMEOUT:   free(s);
                                                return temp;

                                case SUB:       goto SetTimer;

                                default:    com_putc(cp,NAK);
                                            goto Send;
                            }
                            break;

            case ETB:       logfunc(0,cp,"Requests complete");
                            free(s);
                            return 0;

            case ENQ:       com_putc(cp,ETB);
                            goto SetTimer;
        }
        if(timeup(t1)) goto Send;
    }

    free(s);
    return TIMEOUT;
}





int _fastcall get_bark_pkt (USHORT cp,char *fname,long *date,
                            char *password) {

    int     temp,crc,hiscrc,len=0,gotfname=0,gotdate=0,gotpword=0,maxlen=16;
    char    *pp,*p,dstr[33],wholepkt[70];
    clock_t t1;


    p=fname;
    pp=wholepkt;
    t1=timerset(60000L);

    do {
        temp = get_modem_byte(cp,5000L);
        switch(temp) {
            case 0:             return NAK;

            case TIMEOUT:
            case SUB:
            case LOSTCARRIER:   return temp;

            case ETX:           *p=0;
                                goto GotIt;

            case ' ':           if(gotfname && gotdate) return NAK;
                                if(!gotfname) {
                                    gotfname++;
                                    p=dstr;
                                    maxlen=32;
                                    len=0;
                                }
                                else if(!gotdate) {
                                    *date=atol(dstr);
                                    gotdate++;
                                    p=password;
                                    maxlen=8;
                                    len=0;
                                }
                                break;

            default:            if(len >= maxlen) return NAK;
                                *p=(char)temp;
                                p++;
                                *p=0;
                                len++;
                                break;
        }

        *pp = (char)temp;
        pp++;

    } while(!timeup(t1));

    logfunc(0,cp,"Request packet failure");
    return TIMEOUT;   /* bad packet */

GotIt:

    hiscrc = (get_modem_byte(cp,5000L)<<8) | get_modem_byte(cp,5000L);

    /* check packet to see if it's valid */

    crc=figurecrc(wholepkt,strlen(wholepkt),0);
    if(crc!=hiscrc) {
        logfunc(0,cp,"Bad request packet CRC");
        return NAK;       /* bad packet crc */
    }

    return 0;
}




long _fastcall send_req_file (USHORT cp,char *fname,
                              char sign,long date,char *password,
                              int DoingYooHoo,ADDR *myaddr,
                              ADDR *addr,char *oargs) {

    int              temp,ret,retries=0,error;
    char             s[81],*fn;
    clock_t          t1,t2;
    long             totbytes=0;
    struct stat      st;
    struct _filelist *reqfiles=NULL,*nfile;
    PKTHDR           pkt;


    if(!DoingYooHoo) {
      com_putc(cp,ACK);
    }

    logfunc(0,cp,"File request: %s",fname);
    purge_in(cp);
    t2 = timerset(15050L);

    reqfiles = find_req_file(cp,fname,sign,date,password,addr,NULL,&error);
    goto SendEm;

DoAck:

    if(!DoingYooHoo) {
      com_putc(cp,ACK);
    }

SendEm:

    if(DoingYooHoo && !reqfiles) {  /* bad request */
      switch(error) {
        case 1:     fn = "SYSTREQ.TXT";
                    break;

        case 2:     fn = "SYSPREQ.TXT";
                    break;

        case 3:     fn = "BADPREQ.TXT";
                    break;

        default:    fn = "BADFREQ.TXT";
                    break;
      }
      logfunc(0,cp,
              "Failed file request \"%s\" (err#%d, resp \"%s\", pword \"%s\")",
              fname,error,fn,password);
      fill_in_pkt_hdr(&pkt,myaddr,addr,password);
      if(!stat(fn,&st)) {
        make_pkt_from_file(&pkt,"SysOp",progname,fname,fn);
      }
      else {
        switch(error) {
          case 1:     sayn(D_LOCAL,cp,275,s,80);
                      break;

          case 2:     sayn(D_LOCAL,cp,276,s,80);
                      break;

          case 3:     sayn(D_LOCAL,cp,277,s,80);
                      break;

          default:    sayn(D_LOCAL,cp,278,s,80);
                      break;
        }
        make_pkt(&pkt,"SysOp",progname,fname,s);
      }
      sprintf(s,"%08x.PKT",*_threadid);
      sprintf(&s[15],"%08x.PKT",time(NULL));
      send_file(cp,s,0,1,0,1,(char _far *)&s[15]);
      unlink(s);
      return 0L;
    }

    t1 = timerset(3000L);
    do {
      temp = peek_at_byte(cp,3000L);
      switch(temp) {
        case LOSTCARRIER:   if(reqfiles) {
                              free_the_list(reqfiles);
                            }
                            return 0L;

        case TIMEOUT:       goto DoAck;

        case 'C':
        case NAK:           if(reqfiles) goto DoReq;
                            else {
                              logfunc(0,cp,
                                      "Failed file request \"%s\" (err#%d, resp \"%s\", pword \"%s\")",
                                      fname,error,fn,password);
                              return 0L;
                            }
                            break;

        default:            break;

      }
      if(timeup(t1)) {
        goto DoAck;
      }
    } while(!timeup(t2));

    dropDTR(cp);
    if(reqfiles) free_the_list(reqfiles);
    return 0L;

DoReq:

    nfile = reqfiles;
    while(nfile) {
      if(!DoingYooHoo) {
        ret = modem7_send(cp,nfile->name);
        if(ret != 'C' && ret != ACK) break;
        if(send_file(cp,nfile->name,(ret == ACK),1 + ((ret == 'C') * 2),
           0,1,NULL)) {
          if(!stat(nfile->name,&st)) totbytes += st.st_size;
        }
        else break;
      }
      else if(send_file(cp,nfile->name,0,1,0,1,NULL)) {
        if(!stat(nfile->name,&st)) totbytes += st.st_size;
      }
      else break;
      nfile = nfile->next;
    }
    free_the_list(reqfiles);
    return totbytes;
}




struct _filelist * _fastcall find_req_file (USHORT cp,char *fname,
                                            char sign,long date,
                                            char *password,ADDR *addr,
                                            char *oargs,int *error) {

  char                *s1,*s,*p,*pp,magic=0,function=0,*pword=NULL,recurse = 0;
  struct _filelist    *the_list=NULL,*last,*info;
  int                  handle;
  struct _file_buffer *f;
  HDIR                 search_handle;
  USHORT               num_matches;
  clock_t              t1;

  *error = 0;
  if(!oargs)
    oargs = "";
  s = (char *)malloc(1027);
  if(!s)
    return NULL;
  s1 = (char *)malloc(1027);
  if(!s1) {
    free(s);
    *error = 1;
    return NULL;
  }
  f = (struct _file_buffer *)malloc(sizeof(struct _file_buffer));
  if(!f) {
    free(s);
    free(s1);
    *error = 1;
    return NULL;
  }

  p = searchpath(bbs->okfiles[0],s,1026);
  if(!p) {
    free(s);
    free(s1);
    free(f);
    *error = 2;
    return NULL;
  }

  handle = sopen(p,O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
  if(handle == -1) {
    free(s);
    free(s1);
    free(f);
    *error = 1;
    return NULL;
  }

    t1 = timerset(1500L);
    while(!eof(handle)) {
      if(checkcarrier(cp))
        break;
      if(!fgetsx(s,1025 - 256,handle))
        break;
      if(timeup(t1)) {
        com_putc(cp,NUL);
        t1 = timerset(1500L);
      }
      p = strchr(s,';');        /* get rid of comments, empty lines, junk */
      if(p)
        *p = 0;
      stripcr(s);
      rstrip(s);
      p = lstrip(s);
      if(!*p)
        continue;

// logfunc(0,cp,"Line: \"%s\"",p);

      switch((int)*p) {       /* magic, function requests */
        case '@':   magic = 1;
                    function = 0;
                    recurse = 0;
                    p = to_delim(p," ");   /* skip magic name */
                    if(*p) {
                      *p = 0;
                      p++;
                      p = skip_white(p);
                    }
// logfunc(0,cp,"Compare:  \"%s\" \"%s\" \"%s\"",fname,s + 1,p);
                    if(stricmp(fname,s + 1))
// {
// logfunc(0,cp,"Compare failed");
                      *p = 0;
// }
                    break;

        case '#':   function = 1;
                    magic = 0;
                    recurse = 0;
                    p = to_delim(p," ");   /* skip function name */
                    if(*p) {
                      *p = 0;
                      p++;
                      p = skip_white(p);
                    }
                    if(stricmp(fname,s + 1))
                      *p = 0;
                    break;

        case '~':   recurse = 1;
                    magic = 0;
                    function = 0;
                    p++;

        default:    magic = 0;
                    function = 0;
                    recurse = 0;
                    break;
      }

      if(!*p)
        continue;

      pp = p;
      while((pp = strchr(pp,'\\')) != NULL)
        *pp = '/';

      pword = strstr(p," !");
      if(pword) {
        *pword = 0;
        pword += 2;
        if(*pword && (magic || function)) {
          if(!password || stricmp(pword,password)) { /* password mismatch */
            close(handle);
            free(s);
            free(s1);
            free(f);
            *error = 3;
            return NULL;
          }
        }
      }

      if(function) {
        forkf(D_LOCAL,cp,4,"%s /C %s %s %s %s#%u:%u/%u.%u",getenv("COMSPEC"),
              fname,p,oargs,addr->domain,addr->zone,addr->net,addr->node,
              addr->point);
        continue;
      }

      *s1 = 0;
      pp = strrchr(p,'/');      /* isolate path */
      if(!pp)
        pp = strrchr(p,':');
      if(pp) {

        char *tmp = p,*tmp2 = s1;

        pp++;
        while(tmp < pp) {
          *tmp2 = *tmp;
          tmp2++;
          tmp++;
          *tmp2 = 0;
        }
      }                       /* path, if any, now in s1 */

// logfunc(0,cp,"Path: \"%s\"  Find: \"%s\"",s1,p);

      search_handle = HDIR_CREATE;
      num_matches = 1;
      if(!DosFindFirst(p,&search_handle,FILE_NORMAL | FILE_ARCHIVED |
         ((recurse != 0) ? FILE_DIRECTORY : 0),
         (FILEFINDBUF *)f,sizeof(struct _file_buffer),&num_matches,0L)) {

        do {
          if(f->attr & FILE_DIRECTORY) {  /* we must be recursing... */

          }
          if(!f->size)
            goto KeepLooking;  /* skip null-length files */

          /* see if his filename matches our filename... */

          if(!magic && !function) {
            if(!check_wildcard(fname,f->filename))
              goto KeepLooking;
            if(pword && *pword) {
              if(!password || stricmp(pword,password)) { /* password mismatch */
                DosFindClose(search_handle);
                close(handle);
                free(s);
                free(s1);
                free(f);
                logfunc(0,cp,"Password mismatch on file request: \"%s\" \"%s\"",
                        pword,(password) ? password : "<None>");
                return the_list;
              }
            }
          }

          strcpy(s,s1);   /* retrieve path */
          strcat(s,f->filename);  /* add filename */

// logfunc(0,cp,"Fullname: \"%s\"",s);

          if(date) {          /* update stuff */

            long compare;

            compare = secs_since_1970((FDATE *)&f->wd.x,(FTIME *)&f->wt.x);
            if(!sign) {
              if(compare > date)
                goto KeepLooking;
            }
            else if(compare <= date)
              goto KeepLooking;
          }

          info = (struct _filelist *)malloc(sizeof(struct _filelist));
          if(!info) {
            DosFindClose(search_handle);
            close(handle);
            free(s);
            free(s1);
            free(f);
            *error = 1;
            logfunc(0,cp,"Out of memory building file list");
            return the_list;
          }
          info->name = strdup(s);
          if(!info->name) {
            free(info);
            logfunc(0,cp,"Couldn't allocate memory for copy of filename");
            goto KeepLooking;
          }
          if(!the_list)
            the_list = info;
          else
            last->next = info;
          info->next = NULL;
          last = info;

KeepLooking:

          num_matches = 1;
      } while(!DosFindNext(search_handle,(FILEFINDBUF *)f,
              sizeof(struct _file_buffer),&num_matches));
    }
    DosFindClose(search_handle);
  }

  close(handle);
  free(s);
  free(s1);
  free(f);
  *error = 0;

  return the_list;
}




int _fastcall check_wildcard (char *mask,char *filename) {

  /* check a wildcard mask against a filename; return 1 if they match */

  if(!mask || !filename || !*mask || !*filename)
    return 0;

  while(*mask) {
    if(*mask == '?') {
      mask++;
      if(*filename != '.' && *filename)
        filename++;
      continue;
    }
    else if(*mask == '*') {
      while(*mask && *mask != '.') mask++;
      if(*mask == '.') mask++;
      while(*filename && *filename != '.') filename++;
      if(*filename == '.') filename++;
      continue;
    }
    else if(toupper(*mask) != toupper(*filename))
      return 0;
    mask++;
    if(*filename)
      filename++;
  }

  if(*filename)
    return 0;
  return 1;
}




void _fastcall free_the_list (struct _filelist *top) {

  struct _filelist *info,*next;

  info = top;
  while(info) {
    next = info->next;
    if(info->name)
      free(info->name);
    free(info);
    info = next;
  }
}


#pragma optimize("",on)
