/************************************************/
/* This module scans the outbound directory     */
/* and handles related functions                */
/************************************************/

#define INCL_WIN

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include "mailer.h"
#include "nodelist.h"
#include "xmisc.h"
#include "window.h"
#include "xbbs.h"


    extern MDM  *modems[MAXINSTANCES];
    extern HWND xdhwnd;

    unsigned long ScanningSEM;
    OUTBOUND *outs = NULL;


    void _fastcall free_outbound (OUTBOUND *top);
    void _fastcall add_2_types (OUTBOUND *findit,char type);




int _fastcall scan_outbound (USHORT cp) {

    OUTBOUND     *info,*findit,*prev = NULL,*top = NULL;
    HDIR          search_handle;
    USHORT        num_matches;
    int           matched = 0;
    char         *s,*p,type,*domain;
    unsigned int  zone,net,node,point;
    FILEFINDBUF  *f;
    NODEINFO      nif;


    if(DosSemRequest(&ScanningSEM,0L)) {   /* scan already in progress */
      DosSemWait(&ScanningSEM,-1L);      /* block until it finishes */
      return 0;                          /* then return success */
    }

    s = (char *)malloc(1050);
    if(!s) {
      DosSemClear(&ScanningSEM);
      return -1;
    }

    f = (FILEFINDBUF *)malloc(sizeof(FILEFINDBUF));
    if(!f) {
      free(s);
      DosSemClear(&ScanningSEM);
      return -1;
    }

    Say_General("Scanning outbound");

    sprintf(s,"%s/*.*.*.*.*.*",d_outbound); /* Mask to find anything */

    search_handle = HDIR_CREATE;
    num_matches = 1;

    if(!DosFindFirst(s,&search_handle,0,f,
       sizeof(FILEFINDBUF),&num_matches,0L)) {

      do {

        /* pry information out of filename */

        zone = net = node = point = 0;
        domain = NULL;
        strupr(f->achName);
        type = toupper(*f->achName);
        p = to_delim(f->achName,".");
        if(*p) {
            p++;
            zone = atoi(p);
            p = to_delim(p,".");
            if(*p) {
                p++;
                net = atoi(p);
                p = to_delim(p,".");
                if(*p) {
                    p++;
                    node = atoi(p);
                    p = to_delim(p,".");
                    if(*p) {
                        p++;
                        point = atoi(p);
                        p = to_delim(p,".");
                        if(*p) {
                            p++;
                            domain = p;
                            p = to_delim(p,".");
                            if(*p) *p = 0;
                        }
                    }
                }
            }
        }

        /* quick check for valid filename */

        if(!zone || !net || !domain || !*domain) {
            logfunc(0,cp,"Invalid outbound filename \"%s\"",f->achName);
            goto KeepLooking;
        }

        /* if we have some already, see if this address is already listed */

        if(top) {
            findit = top;
            while(findit) {
                if(findit->zone == zone && findit->net == net &&
                   findit->node == node && findit->point == point &&
                   !stricmp(findit->domain,domain)) {
                    add_2_types(findit,type);
                    goto KeepLooking;
                }
                findit = findit->next;
            }
        }

        /* new address; create its entry */

        info = (OUTBOUND *)malloc(sizeof(OUTBOUND));
        if(!info) {
            logfunc(0,cp,"Out of memory scanning outbound");
            DosFindClose(search_handle);
            goto Done;
        }

        memset(&nif,0,sizeof(NODEINFO));    /* for cost & baud lookup */
        memset(info,0,sizeof(OUTBOUND));
        info->next = NULL;
        add_2_types(info,type);
        info->zone = zone;
        nif.net = info->net = net;
        nif.node = info->node = node;
        info->point = point;
        strncpy(info->domain,domain,8);
        info->domain[8] = 0;
        if(get_node_from_list(&nif,info->zone,info->point,info->domain)) {
            info->cost = nif.realcost;
            info->baud = nif.rate * 300;
        }
        else {
            info->cost = 32767;  /* can't call them anyway... */
            info->baud = 0;
        }

      // this needs work...doesn't keep permanent track at all...

        /* add to linked list */

        if(!top) {     /* first entry */
            top = info;
        }
        else {
            prev->next = info;
        }
        prev = info;

        if(outs) {      /* transfer old settings */
            findit = outs;
            while(findit) {
                if(info->zone == findit->zone && info->net == findit->net &&
                   info->node == findit->node && info->point == findit->point &&
                   !stricmp(info->domain,findit->domain)) {
//                        if(findit->types & O_LOCKED) info->types |= O_LOCKED;
                        info->calls = findit->calls;
                        info->bad = findit->bad;
                        break;
                }
                findit = findit->next;
            }
        }

        matched++;

KeepLooking:

            num_matches = 1;

/*
            if(!(matched % 10))
              DosSleep(1L);
*/

      } while(!DosFindNext(search_handle,f,sizeof(FILEFINDBUF),
                           &num_matches));
      DosFindClose(search_handle);
    }

Done:

    free(f);
    free(s);

    if(outs)
      free_outbound(outs);
    outs = top;

    DosSemClear(&ScanningSEM);
    WinPostMsg(xdhwnd,WM_DONESCAN,0L,0L);
    Say_General("");
    return 0;
}




void _fastcall free_outbound (OUTBOUND *top) {

  OUTBOUND *info,*next;


  info = top;
  while(info) {
    next = info->next;
    free(info);
    info = next;
  }
}




void _fastcall add_2_types (OUTBOUND *findit,char type) {

    switch(toupper(type)) {
        case 'C':   findit->types |= O_CRASH;
                    break;
        case 'D':   findit->types |= O_DIRECT;
                    break;
        case 'N':   findit->types |= O_NORMAL;
                    break;
        case 'H':   findit->types |= O_HOLD;
                    break;
        case 'M':   findit->types |= O_MANUAL;
                    break;
        case 'R':   findit->types |= O_REQUEST;
                    break;
        case 'A':   findit->types |= O_ARCHIVE;
                    break;
        case 'T':
        case 'P':   findit->types |= O_PACKET;
                    break;
    }
}




int _fastcall anyone_to_call (USHORT cp,ADDR *addr,int manual) {

    /* find an OUTBOUND address to call and fill in ADDR address */
    /* locks the address found.  Looks from the last address tried */
    /* to end, then from start to end (trying to serialize calls) */

    // need to add checking for event criteria

    OUTBOUND *info,*pre;


    DosSemRequest(&ScanningSEM,-1L);    /* block until it finishes */

    info = outs;
    while(info) {
      if(info->zone == addr->zone && info->net == addr->net &&
         info->node == addr->node && info->point == addr->point &&
         !stricmp(info->domain,addr->domain)) break;
      info = info->next;
    }

    if(info)
      info = info->next;

Again:

    pre = info;
    if(!info)
      info = outs;
    while(info) {
      if(!(info->types & O_LOCKED)) {
        if(info->types & (O_CRASH | O_DIRECT |
                          O_NORMAL | (O_MANUAL * (manual != 0)))) {
          if(info->cost <= (int)modems[cp]->maxcost &&
             info->cost >= (int)modems[cp]->mincost &&
             info->baud >= modems[cp]->mincallbaud &&
             info->baud <= modems[cp]->maxcallbaud &&
             info->bad < modems[cp]->maxbad + 1 &&
             info->calls < modems[cp]->maxtries + 1) {
               addr->zone=info->zone;
               addr->net=info->net;
               addr->node=info->node;
               addr->point=info->point;
               strcpy(addr->domain,info->domain);
               info->types |= O_LOCKED;
               DosSemClear(&ScanningSEM);
               return 1;
          }
        }
      }
      info = info->next;
    }

    if(pre) {
      info = NULL;
      goto Again;
    }

    DosSemClear(&ScanningSEM);
    return 0;
}




void _fastcall unlock_out (ADDR *addr) {

    OUTBOUND *info;


    if(!addr->zone) return;

    DosSemRequest(&ScanningSEM,-1L);       /* block until it finishes */

    info = outs;
    while(info) {
        if(info->zone == addr->zone && info->net == addr->net &&
           info->node == addr->node && info->point == addr->point &&
           !stricmp(info->domain,addr->domain)) {
               info->types &= (~O_LOCKED);
               break;
        }
        info = info->next;
    }

    DosSemClear(&ScanningSEM);
}





void _fastcall lock_out (ADDR *addr) {

    OUTBOUND *info;


    if(!addr->zone) return;

    DosSemRequest(&ScanningSEM,-1L);       /* block until it finishes */

    info = outs;
    while(info) {
        if(info->zone == addr->zone && info->net == addr->net &&
           info->node == addr->node && info->point == addr->point &&
           !stricmp(info->domain,addr->domain)) {
               info->types |= O_LOCKED;
               break;
        }
        info = info->next;
    }

    DosSemClear(&ScanningSEM);
}





int _fastcall is_locked_out (ADDR *addr) {

    OUTBOUND *info;


    if(!addr->zone) return -1;

    DosSemRequest(&ScanningSEM,-1L);   /* block until it finishes */

    info = outs;
    while(info) {
        if(info->zone == addr->zone && info->net == addr->net &&
           info->node == addr->node && info->point == addr->point &&
           !stricmp(info->domain,addr->domain)) {
               if(info->types & O_LOCKED) {
                    DosSemClear(&ScanningSEM);
                    return 1;
               }
               break;
        }
        info = info->next;
    }

    DosSemClear(&ScanningSEM);
    return 0;
}





void _fastcall inc_calls (ADDR *addr,int badtoo) {

    // needs to update #calls/#bad calls in 'permanent' storage

    OUTBOUND *info;


    if(!addr->zone) return;

    DosSemRequest(&ScanningSEM,-1L);   /* block until it finishes */

    info = outs;
    while(info) {
        if(info->zone == addr->zone && info->net == addr->net &&
           info->node == addr->node && info->point == addr->point &&
           !stricmp(info->domain,addr->domain)) {
               info->calls++;
               if(badtoo) info->bad++;
               break;
        }
        info = info->next;
    }

    DosSemClear(&ScanningSEM);
}


void _fastcall clear_outs (void) {

    OUTBOUND *info;


    DosSemRequest(&ScanningSEM,-1L);

    info = outs;
    while(info) {
        info->calls = 0;
        info->bad = 0;
        info = info->next;
    }
    DosSemClear(&ScanningSEM);
}
