#define INCL_WIN
#define INCL_DOSERRORS

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <process.h>
#include "mailer.h"
#include "modem.h"
#include "transfer.h"
#include "bbs.h"
#include "xmisc.h"
#include "xbbs.h"
#include "window.h"

    extern USER *user[MAXINSTANCES];
    extern MDM  *modems[MAXINSTANCES];
    extern int  *_threadid;
    extern HWND  xdhwnd;


void start_pipe_read_thread (void *ph);

#define MAXARGS 33
#define MAXSTRG 1027


int forkf (int mode,USHORT cp,int flags,char *formatstring, ...) {

   /* not a real fork; more like a spoon... */

   char         s[MAXSTRG] = "",object[18],doblip = 0,*p,
                dotrans = 0,dontwait = 0,dontkill = 0,dontmoncar = 0,
                dontmontime = 0,send, *sayarg,*freeme;
   va_list      parguments;
   int          ret = -1;
   char         oldpri[2];
   struct _retvals {
      unsigned int termtype;
      unsigned int exitcode;
   } rt;
   USHORT apptype;


   if(flags & 16)
    doblip = 1;
   if(flags & 32)
    dotrans = 1;
   if(flags & 64)
    dontwait = 1;
   if(flags & 128)
    dontkill = 1;
   if(flags & 256)
    dontmoncar = 1;
   if(flags & 512)
    dontmontime = 1;

   flags &= 7;

   va_start(parguments,formatstring);
   vsprintf(s,formatstring,parguments);
   va_end(parguments);

   if(*s) {

       lstrip(s);
       logfunc(1,cp,"DosExecPgm request: \"%s\" %d",s,flags);
       p = skip_nonwhite(s);
       if(*p) {
          *p = 0;
          p++;
       }
       else
         p = s;
       p[strlen(p) + 1] = 0;

       if(isdos(s))
        return -1;

       DosGetPrty(2,(PUSHORT)oldpri,*_threadid);

       if(cp != (USHORT)-1)
         DosSetPrty(2,modems[cp]->outside[0],modems[cp]->outside[1],*_threadid);

       sayarg = s;
       if((!stricmp(s,"CMD.EXE") || stristr(s,"\\CMD.EXE")) && p && *p)
         sayarg = p;

       if(isdos(s))
        ret = -1;
       else
         ret = DosExecPgm(object,17,flags,s,NULL,&rt,s);

       DosSetPrty(2,oldpri[0],oldpri[1],*_threadid);

       if(ret)
           logfunc(0,cp,"DosExecPgm couldn't start %s",s);
       else if(flags == 0) {
           logfunc(0,cp,"Returned from synchronous DosExecPgm of %s",s);
           if(rt.termtype == 0)
             ret = rt.exitcode;
           else
             ret = -1;
       }
       else if(flags == 5) {
           logfunc(0,cp,"DosExecPgm started frozen process %s",s);
           ret = 0;
       }
       else if(flags == 2) {
            if(dontwait) {
                logfunc(0,cp,"DosExecPgm started %s; not waiting",s);
                return rt.termtype; /* return PID of child so caller can DosCWait */
            }
            logfunc(0,cp,"Waiting for DosExecPgm to return from %s",s);
            for(;;) {

                char nocheck = 0;

                DosSleep(1000L);
                if_key(cp);
                if(!DosCwait(1,1,&rt,&rt.termtype,rt.termtype)) break;
                if(!nocheck && cp != (USHORT)-1) {
                    if((!dontmoncar && checkcarrier(cp)) ||
                      (!dontmontime && (user[cp] && user[cp]->offline < time(NULL)))) {
                        if(!dontmoncar && checkcarrier(cp))
                          logfunc(0,cp,"Lost carrier before DosExecPgm returned");
                        else
                          logfunc(0,cp,"Out of time before DosExecPgm returned");
                        if(!dontkill)
                          DosKillProcess(0,rt.termtype);
                        return 255;
                    }
                }
                if(doblip && cp != (USHORT)-1) {
                    send = NUL;
                    com_putc(cp,send);  /* buy time? */
                }
            }
            ret = rt.exitcode;
       }
       else if(flags == 4) {
            logfunc(0,cp,"DosExecPgm started detached process %s",s);
            ret = 0;
       }
       else {
           logfunc(0,cp,"DosExecPgm started asynchronous process %s",s);
           ret = 0;
       }
   }

   return ret;
}


int sessionf (int mode,USHORT cp,int flags,char *commandtail, ...) {

   char         s[MAXSTRG],s2[MAXSTRG],*p;
   va_list      parguments;
   int          ret = -1;
   STARTDATA    start;
   USHORT       sessID,sessPID,apptype;

   *s = 0;
   va_start(parguments,commandtail);
   vsprintf(s,commandtail,parguments);
   va_end(parguments);
   *s2 = 0;

   if(*s) {
     lstrip(s);
     logfunc(1,cp,"DosStartSession request: \"%s\" %d",s,flags);
     p = skip_nonwhite(s);
     if(*p) {
      *p = 0;
      p++;
      strcpy(s2,p);
     }

     {
      char s3[MAXSTRG];

       p = searchpath(s,s3,MAXSTRG);
       if(p)
        strcpy(s,s3);
     }

     DosQAppType(s,&apptype);

     start.Length = sizeof(STARTDATA);
     start.Related = ((flags & 2) != 0);  /* 2 = related */
     start.FgBg = ((flags & 1) != 0);     /* 1 = background */
     start.TraceOpt = 0;                  /* 0 = no tracing */
     start.PgmTitle = NULL;               /* NULL = use default */
     start.PgmName = s;                   /* s = what to run */
     start.PgmInputs = s2;                /* s2 = args */
     start.TermQ = NULL;                  /* NULL = don't bother */
     start.Environment = NULL;            /* NULL = use default */
     start.InheritOpt = ((flags & 4) == 0); /* 4 = don't inherit from us */
     start.SessionType = (apptype & 3);   /* 0 = use defaults */
     start.IconFile = NULL;               /* NULL = use default */
     start.PgmHandle = 0L;                /* 0 = use default */
     start.PgmControl = 0;                /* 0 = use default */
     ret = DosStartSession(&start,&sessID,&sessPID);
   }
   return ret;
}


int wait_sessionf (int mode,USHORT cp,int flags,char *commandtail, ...) {

   char           s[MAXSTRG],s2[MAXSTRG],qname[64],*p,str[41];
   va_list        parguments;
   int            ret = -1,temp;
   STARTDATA      start;
   USHORT         sessID,sessPID,apptype;
/*
   PIDINFO        mypid;
   HQUEUE         qhandle;
   QUEUERESULT    qresult;
   USHORT         qlen;
   LONG           qSEM;
   SEL            sel;
   VOID FAR       *qdata = NULL;
   LONG           elempri;
*/
   *s = 0;
   va_start(parguments,commandtail);
   vsprintf(s,commandtail,parguments);
   va_end(parguments);

   *s2 = 0;
   if(*s) {
     lstrip(s);
     logfunc(1,cp,"Synchronous DosStartSession request: \"%s\" %d",s,flags);
     p = skip_nonwhite(s);
     if(*p) {
       *p = 0;
       p++;
       strcpy(s2,p);
     }

     sprintf(qname,"\\QUEUES\\XBBS\\TERM%u",cp);
/*     if(!DosCreateQueue(&qhandle,QUE_FIFO,qname)) { */

       {
        char s3[MAXSTRG];

         p = searchpath(s,s3,MAXSTRG);
         if(p)
          strcpy(s,s3);
       }

       DosQAppType(s,&apptype);

       start.Length = sizeof(STARTDATA);
       start.Related = 1;                   /* always related */
       start.FgBg = ((flags & 1) != 0);     /* 1 = background */
       start.TraceOpt = 0;                  /* 0 = no tracing */
       start.PgmTitle = NULL;               /* NULL = use default */
       start.PgmName = s;                   /* s = what to run */
       start.PgmInputs = s2;                /* s2 = args */
       start.TermQ = NULL /* qname */;                 /* term queue name */
       start.Environment = NULL;            /* NULL = use default */
       start.InheritOpt = 1;                /* 1 = inherit from us */
       start.SessionType = (apptype & 3);   /* 0 = use defaults */
       start.IconFile = NULL;               /* NULL = use default */
       start.PgmHandle = 0L;                /* 0 = use default */
       start.PgmControl = 0;                /* 0 = use default */
       ret = DosStartSession(&start,&sessID,&sessPID);
       if(!ret || ret == ERROR_SMG_START_IN_BACKGROUND) { /* success */
         ret = 0;
         hold_comthread(cp);
         sprintf(str,"Session ID %u",sessID);
         if(user[cp])
           Change_Status("User Online -- external session");
         WinPostMsg(xdhwnd,WM_BBSMESSAGE,MPFROM2SHORT(cp,0),MPFROMP(str));
/*
         DosSemSet((HSEM)&qSEM);
         DosGetPID(&mypid);
         qresult.pidProcess = mypid.pid;
*/
temp = 1;
/*
         // need to peek queue first...

         temp = DosReadQueue(qhandle,&qresult,&qlen,(PVOID *)&qdata,
                             0,1,&elempri,(HSEM)&qSEM);
*/
         if(temp) {

           STATUSDATA sd;

           sd.Length = sizeof(STATUSDATA);
           sd.SelectInd = TARGET_UNCHANGED;
           sd.BondInd = BOND_UNCHANGED;
/*           while(DosSemWait((HSEM)&qSEM,1000L)) { */
           for(;;) {
             DosSleep(1000L);
             if(user[cp]) {
               if(user[cp]->offline < time(NULL) + 61L) {
                 logfunc(0,cp,"Stopping session; user out of time");
                 DosStopSession(0,sessID,0L);
                 break;
               }
             }
             if(DosSetSession(sessID,&sd))  /* cheap trick */
              break;
             if(cp) {
               if(checkcarrier(cp))
                 break;
             }
           }
/*
           qresult.pidProcess = mypid.pid;
           DosReadQueue(qhandle,&qresult,&qlen,(PVOID *)&qdata,
                        0,0,&elempri,0L);
*/
         }
/*
         if(qdata) {
           logfunc(1,cp,"Termination queue successfully read");
           sel = SELECTOROF(qdata);
           DosFreeSeg(sel);
         }
*/
         restart_comthread(cp);
       }
       else
         logfunc(0,cp,"Error starting session: %d",ret);
/*       DosCloseQueue(qhandle);
     }
     else
       logfunc(0,cp,"Error opening queue \"%s\"",qname);
*/
   }
   WinPostMsg(xdhwnd,WM_BBSMESSAGE,MPFROM2SHORT(cp,0),MPFROMP(""));
   if(user[cp])
     Change_Status("User Online");
   return ret;
}



int runemf (int mode,USHORT cp,int type,char *formatstring, ...) {

   char         s[MAXSTRG],object[18],*p,param = 0;
   va_list      parguments;
   int          ret = -1;
   struct {
      unsigned int childid;
      unsigned int nothing;
   } rt;
   static long stdSEM = 0L;

   *s = 0;
   va_start(parguments,formatstring);
   vsprintf(s,formatstring,parguments);
   va_end(parguments);

   if(*s) {
       lstrip(s);
       logfunc(0,cp,"Door request: \"%s\" %d",s,type);
       p = skip_nonwhite(s);
       if(*p) {
          *p = 0;
          p++;
       }
       p[strlen(p) + 1] = 0;

       if(isdos(s))
         return -1;

       if(*s) {

         int  phi,pho,phe,phi2,pho2,phe2,nsi,nso,nse,deadid,rkey,
              wrote,temp,bytes = 0;
         char key;
         struct iostuff {
           int    mode;
           USHORT cp;
           int    ph;
         } info,infoe;
         struct {
            unsigned int termtype;
            unsigned int exitcode;
         } rt2;
         char linebuf[257];

         /* serialize access to stdin/stdout */

         DosSemRequest(&stdSEM,30000L);

         Change_Status("User Online -- Door");
         WinPostMsg(xdhwnd,WM_BBSMESSAGE,MPFROM2SHORT(cp,0),MPFROMP("Door"));

         DosQFHandState(fileno(stdout),&temp);
         temp |= (1 << 14);
         DosSetFHandState(fileno(stdout),temp);
         DosQFHandState(fileno(stdin),&temp);
         temp |= (1 << 14);
         DosSetFHandState(fileno(stdin),temp);
         DosQFHandState(fileno(stderr),&temp);
         temp |= (1 << 14);
         DosSetFHandState(fileno(stderr),temp);

         /* duplicate stdout, stdin & stderr */

         nso = -1;
         DosDupHandle(fileno(stdout),&nso);
         nsi = -1;
         DosDupHandle(fileno(stdin),&nsi);
         nse = -1;
         DosDupHandle(fileno(stderr),&nse);

         /* open pipes */

         DosMakePipe(&phi,&phi2,2048);
         DosMakePipe(&pho2,&pho,2048);
         DosMakePipe(&phe,&phe2,2048);

         /* redirect stdout, stdin & stderr to pipes */

         temp = fileno(stdout);
         DosDupHandle(phi2,&temp);
         temp = fileno(stdin);
         DosDupHandle(pho2,&temp);
         temp = fileno(stderr);
         DosDupHandle(phe2,&temp);

         DosQFHandState(fileno(stdout),&temp);
         temp |= (1 << 14);
         DosSetFHandState(fileno(stdout),temp);
         DosQFHandState(fileno(stdin),&temp);
         temp |= (1 << 14);
         DosSetFHandState(fileno(stdin),temp);
         DosQFHandState(fileno(stderr),&temp);
         temp |= (1 << 14);
         DosSetFHandState(fileno(stderr),temp);

         /* run program */

         ret = DosExecPgm(object,17,2,s,NULL,&rt,s);

         /* put stdin/stdout/stderr back */

         temp = fileno(stdout);
         DosDupHandle(nso,&temp);
         temp = fileno(stdin);
         DosDupHandle(nsi,&temp);
         temp = fileno(stderr);
         DosDupHandle(nse,&temp);

         /* close dupes */

         DosClose(nso);
         DosClose(nsi);
         DosClose(nse);

         /* free semaphore */

         DosSemClear(&stdSEM);

         if(!ret) {
           infoe.mode = info.mode = mode;
           infoe.cp = info.cp = cp;
           info.ph = phi;
           infoe.ph = phe;
           DosSemSet(&modems[cp]->pipereadSEM);
           if(_beginthread(start_pipe_read_thread,NULL,8192,(void *)&infoe) != -1 &&
              _beginthread(start_pipe_read_thread,NULL,8192,(void *)&info) != -1) {
             while(DosCwait(0,1,&rt2,&deadid,rt.childid)) {
               if(user[cp]->offline < user[cp]->online)
                 break;    /* out of time */
               if(modems[cp]->curbaud && checkcarrier(cp))
                 break; /* lost carrier */
               rkey = inkey(mode,cp);
               if(!rkey)
                DosSleep(100L);
               else if(rkey != -1 && rkey != -2) {
                 if(rkey & 1024) {
                   if(type && bytes) {
                     if(DosWrite(pho,linebuf,bytes,&wrote))
                       break;
                     bytes = 0;
                   }
                   key = 0;
                   if(DosWrite(pho,&key,1,&wrote))
                     break;
                   key = (char)(rkey & 255);
                   if(DosWrite(pho,&key,1,&wrote))
                     break;
                   continue;
                 }
                 else if(rkey == '\03')
                   DosSendSignal(rt.childid,SIG_CTRLBREAK);
                 else if(type && rkey == '\r')
                  rkey = '\n';
                 if(!type) {
                   key = (char)(rkey & 255);
                   if(DosWrite(pho,&key,1,&wrote))
                     break;
                 }
                 else {
                   if(rkey == '\b') {
                     if(bytes > 0) {
                       bytes--;
                       if(DosWrite(phi2,"\b \b",3,&wrote))
                         break;
                     }
                   }
                   else {
                     key = (char)(rkey & 255);
                     linebuf[bytes++] = key;
                     if(DosWrite(phi2,&key,1,&wrote))
                       break;
                   }
                   if(rkey == '\n' || bytes == 256) {
                     if(DosWrite(pho,linebuf,bytes,&wrote))
                       break;
                     bytes = 0;
                   }
                 }
               }
               else if(rkey == -2)
                 break;
             }
           }
           if(!modems[cp]->curbaud || !checkcarrier(cp))
             DosSleep(100L);
           DosSemClear(&modems[cp]->pipereadSEM);
           DosBufReset(phi);
           if(!modems[cp]->curbaud || !checkcarrier(cp))
             DosSleep(100L);
           DosKillProcess(0,rt.childid);
           DosCwait(0,1,&rt2,&deadid,rt.childid);
           ret = rt2.exitcode;
         }
         /* tell pipe read thread to die ASAP */
         DosSemClear(&modems[cp]->pipereadSEM);
         /* close pipe handles */
         DosClose(pho2);
         DosClose(pho);
         DosClose(phi);
         DosClose(phi2);
         DosClose(phe);
         DosClose(phe2);
         DosSleep(500L);
       }
   }
   Change_Status("User Online");
   WinPostMsg(xdhwnd,WM_BBSMESSAGE,MPFROM2SHORT(cp,0),MPFROMP(""));
   return ret;
}


void start_pipe_read_thread (void *ph) {

  struct iostuff {
    int    mode;
    USHORT cp;
    int    ph;
  }      info;
  char   data[257],param = 0;
  int    len;
  USHORT ret;

  info = *(struct iostuff *)ph;

  for(;;) {
    ret = DosSemWait(&modems[info.cp]->pipereadSEM,0L);
    if(ret && ret != ERROR_BROKEN_PIPE && ret != ERROR_BAD_PIPE) {
      if(DosRead(info.ph,&data,256,&len))
        break;
      data[len] = 0;
      dputs(info.mode,info.cp,data);
    }
    else
      break;
  }
}
