#define TIMEOUT       -1
#define LOSTCARRIER   -2
#define FILEERROR     -3
#define NOSTART       -4
#define BLKCRCERR     -5
#define BLKMISMATCH   -6
#define BLKMINUS1     -7
#define BLKFATAL      -8
#define BLKEOF        -9

#define YOOHOO        0xf1
#define NUL           0x00
#define TSYNCH        0xae
#define ACK           0x06
#define NAK           0x15
#define SOH           0x01
#define STX           0x02
#define SUB           0x1a
#define SYN           0x16
#define EOT           0x04
#define ENQ           0x05
#define CAN           0x18
#define ETX           0x03
#define ETB           0x17


/* Structures for FTS-0001 file transfer blocks */


struct _telink_block {
    char syn;           /* 0x16 */
    char blk;           /* block # */
    char blkcmp;        /* 1's complement of block # */
    long size;          /* file size in bytes */
    int  time;          /* file mod time or 0 'MS-DOS' format */
    int  date;          /* file mod date or 0 'MS-DOS' format */
    char filename[16];  /* No dir or path, blank filled */
    char hdr;           /* Always 0x00  */
    char sender[16];    /* Sending program's name, blank filled */
    char crcmode;       /* 0x01 for CRC 0x00 for checksum */
    char fill[86];      /* Zeroed out */
    char checksum;      /* Of this block, size->checksum? */
};

typedef struct _telink_block TELBLK;


struct zeros {                 /* sealink block 0 data structure */
    long flen;                 /* file length */
    long fstamp;               /* file date/time stamp */
    char fnam[17];             /* original file name */
    char prog[15];             /* sending program name */
    char slo;                  /* overdrive? */
    char resync;
    char macflow;
    char fill[85];             /* reserved for future use */
};

typedef struct zeros ZEROBLK;


struct _sealink_block {          /* full sealink block 0 data structure */
  char soh;
  char blk;
  char blkcmp;
  long flen;                     /* file length */
  long fstamp;                   /* file date/time stamp */
  char fnam[17];                 /* original file name */
  char prog[15];                 /* sending program name */
  char slo;                      /* overdrive? */
  char resync;
  char macflow;
  char fill[85];                 /* reserved for future use */
  int  crc;
};

typedef struct _sealink_block SEABLK;


struct _xmodem_block {
    char soh;           /* 0x01 */
    char blk;           /* block # */
    char blkcmp;        /* 1's complement of block # */
    char data[128];     /* */
    int  crc;           /* Use sizeof-1 for checksum */
};


struct _generic_block {
    char soh;           /* 0x01 or 0x02 */
    char blk;           /* block # */
    char blkcmp;        /* 1's complement of block # */
    char data[1027];    /* data and crc or csum */
};

typedef struct _xmodem_block  XMOBLK;
typedef struct _generic_block GENBLK;

  struct _ftime {       /* Structs & unions for file date/time */
    unsigned int sec: 5;
    unsigned int min: 6;
    unsigned int hour:5;
  };

  struct _fdate {
    unsigned int day: 5;
    unsigned int mon: 4;
    unsigned int year:7;
  };

  union _fd {
    struct _fdate fd;
    unsigned int x;
  };

  union _ft {
    struct _ftime ft;
    unsigned int x;
  };

  struct _file_buffer {   /* For DosFindFirst/DosFindNext */
    union _fd cd;
    union _ft ct;
    union _fd ld;
    union _ft lt;
    union _fd wd;
    union _ft wt;
    long size;
    long falloc;
    unsigned int attr;
    unsigned char namelen;
    char filename[257];
  };

  typedef struct {
    int    type;
    char  *filename;
    char  *err;
    long   errcount;
    long   filesize;
    long   bytessent;
    int    blksize;
    time_t started;
    long   resyncedto;
    char  *misc;
  } TRANSBUF;

#define TB_NAME   0
#define TB_TICK   1
#define TB_ERR    2
#define TB_NCHNG  3
#define TB_FIN    4
#define TB_MISC   5
#define TB_ABORT  6

 /* XModem/Sealink send file routines */

long _fastcall send_file (USHORT cp,char *filename,
                          int altentry,int chktec,
                          int justxmodem,int overdriveok,
                          char *fakename);
int _fastcall chknak (USHORT cp,long *arblk,char *arblk8,
                      long *sendblk,int *window,int *ackst,int *numnak,
                      int *sealink, long *acksrcvd,long *ackblk,int *slo,
                      int *chktec,long *toterr,long lastblk);
long _fastcall get_resync (USHORT cp);
char * _fastcall getblock (USHORT cp, char *buf, int blksize, int chktec);
char * _fastcall recv_file (USHORT cp,char *filename,
                            int altentry,char *prepath);
int _fastcall sendnak (USHORT cp,int *resync,int *sealink,
                       int *chktec,char *blocknum,char *resync_pkt,
                       int slo,long *writeblk);
int _fastcall sendack (USHORT cp,int *slo,int *sealink,
                       char *blocknum,long writeblk);
int _fastcall send_resync (USHORT cp,char *resync_pkt);
int _pascal calcrc (char *ptrr, int count, int likexmodem);
int _fastcall figurecrc (char *ptrr, int count,int likexmodem);
int _fastcall modem7_recv (USHORT cp,char *filename);
int _fastcall MR2 (USHORT cp,char *filename);
int _fastcall modem7_send (USHORT cp,char *filename);
int _fastcall MS1 (USHORT cp,char *filename);
int _fastcall send_cancel (USHORT cp,int howmany);
char sbreak (USHORT cp);
char * run_kermit (int mode,USHORT cp,unsigned long *numbytes,int sflg,
                   char **filelist,long flags);
char * one_kermit (int mode,USHORT cp,unsigned long *numbytes,int sflg,
                   char *filename,long flags);
long _fastcall send_xfile (USHORT cp,char *filename,int flags,int *error);
long _fastcall get_xfile (USHORT cp,char *filename,int flags,int *error);

