/* Upload module handles user uploads to BBS. */

#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "window.h"
#include "transfer.h"
#include "modem.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"

    extern MDM               *modems[MAXINSTANCES];
    extern USER              *user[MAXINSTANCES];


    /* flags bitmapped values:
       1:   Don't do time verification
       2:
       4:   Silence
       8:   Never be silent
       16:  Don't ask for a description
       32:  Use the external protocol indicated by user[cp]->lastprotocol
       64:  Don't return file's size (no-credit file)
       128: Accept as private file
    */




long _fastcall upload_file (int mode,USHORT cp,char *filename,
                            char *ulpath,char *area,unsigned int flags) {

    char        *got,*hold = NULL,*s;
    struct stat st;


    if(!filename || !*filename)
      return -1L;
    if(!ulpath) {
        if(!user[cp]->currfilearea)
          return -1L;
        ulpath = user[cp]->currfilearea->upath;
        if(!ulpath)
          return -1L;
    }

    s = bbs_malloc(cp,strlen(ulpath) + strlen(filename) + 2);
    if(!s) {
        bbs_free(cp,hold);
        return -1L;
    }
    sprintf(s,"%s/%s",ulpath,filename);

    if(!stat(s,&st)) {
        if(!(flags & 4)) {
            dprintf(mode,cp,"\r\n%s exists.\r\n",filename);
            bbs_free(cp,s);
            return -1L;
        }
    }
    bbs_free(cp,s);

    if(flags & 8)
      flags &= (~4);
    if(!(flags & 4))
        dprintf(mode,cp,
                "\r\nReady to receive \"%s\"\r\nEngage Sealink/XModem "
                "SEND mode or send a few CTRL-Xs to abort.\r\n",
                filename);

    DosSleep(500L);
    got = recv_file(cp,filename,0,ulpath);
    if(got && strnicmp(got,";Aborted",9)) { /* Actually got a file */
        hold = bbs_strdup(cp,got);
    }
    else
      hold = NULL;
    if(got) {
        if(!strnicmp(got,";Aborted",9)) {     /* Some sort of error */
            logfunc(0,cp,"Upload of \"%s\" %s",filename,&got[1]);
            free(got);
            return -1L;
        }
        free(got);
    }
    if(!hold)
      return -1L;

    if(!stat(hold,&st)) {
        if(!st.st_size) {
            logfunc(0,cp,"0-length upload \"%s\" deleted",hold);
            unlink(hold);
            if(hold)
              bbs_free(cp,hold);
            return -1L;
        }
        else {
            logfunc(0,cp,"Upload: \"%s\"  %ld bytes  %0.24s",hold,st.st_size,
                    asctime(localtime(&st.st_ctime)));
            if(!(flags & 4) && !(flags & 16))
              accept_upload(mode,cp,filename,ulpath,area,((flags & 128) != 0));
        }
    }

    if(hold)
      bbs_free(cp,hold);

    return 0L;
}




long _fastcall upload_files (int mode,USHORT cp,char *filename,
                             char *ulpath,char *area,unsigned long *numfiles,
                             unsigned int flags) {

    long numbytes = 0L,tl;
    char *wild;


    wild = strchr(filename,'*');
    if(!wild)
      wild = strchr(filename,'?');

    do {
        tl = upload_file(mode,cp,filename,ulpath,area,flags);
        if(tl == -1L) break;
        if(tl && !(flags & 64)) {
            (*numfiles)++;
            numbytes += tl;
        }
    } while(wild && !checkcarrier(cp));
    if(modems[cp]->curbaud)
      dputs(D_REMOTE,cp,"\xb\x18\x18\x18\x18\x18\x18");
    DosSleep(64L);
    purge_in(cp);

    return numbytes;
}



int _fastcall accept_upload (int mode,USHORT cp,char *filename,char *ulpath,
                             char *area,int flags) {

    /* temporarily dummied */

    char *s,*bbsfilename = "FILES.BBS";
    int handle,x;


    s = bbs_malloc(cp,max(133,strlen(ulpath) + strlen(bbsfilename) + 2));
    if(!s)
      return -1;

    purge_in(cp);

    dprintf(mode,cp,"\r\nPlease enter a description for \"%s\"\r\n",filename);
    DosSleep(2000L);

    sprintf(s,"./FILEDESC.%03x",cp);
    unlink(s);
    while(line_editor(mode,cp,s,E_NOTO | E_NOFROM | E_NOSUBJ,NULL)) {

        struct stat st;

        if(!stat(s,&st) && st.st_size > 0L) break;  /* got something */
        dputs(mode,cp,"\r\nYou *must* enter a description.\r\n");
        DosSleep(2000L);
        if(user[cp]->offline < time(NULL) || checkcarrier(cp))
          goto Error;
    }

    sprintf(s,"%s/%s",ulpath,bbsfilename);
    for(x = 0; x < 15;x++) {
        handle = bbs_sopen(cp,s,O_NOINHERIT | O_RDWR | O_BINARY | O_CREAT, SH_DENYWR, S_IWRITE | S_IREAD);
        if(handle != -1) break;
        DosSleep(500L);
    }

    if(handle != -1) {

        time_t t;
        int    handle2;
        char   *p;

        lseek(handle,0L,SEEK_END);
        if(flags)
          ffprintf(handle,"\r\n;%-13s",filename);
        else
          ffprintf(handle,"\r\n%-13s",filename);
        if(area)
          ffprintf(handle," %s ",area);
        t = time(NULL);
        if(flags)
          ffprintf(handle,";%s %0.24s\r\n",
                   user[cp]->name,asctime(localtime(&t)));
        else
          ffprintf(handle," %s %0.24s\r\n",
                   user[cp]->name,asctime(localtime(&t)));
        sprintf(s,"FILEDESC.%03x",cp);
        handle2 = bbs_sopen(cp,s,O_NOINHERIT | O_RDONLY | O_BINARY,SH_DENYNO);
        if(handle2 != -1) {
            while(!eof(handle2)) {
                if(fgetsx(s,79,handle2) == NULL) break;
                s[78] = 0;
                stripcr(s);
                lstrip(s);
                rstrip(s);
                if(!s) continue;
                while((p = strchr(s,';')) != NULL) *p = ',';
                if(flags) ffprintf(handle," ;%s",s);
                ffprintf(handle," %s\r\n",s);
            }
            bbs_close(cp,handle2);
        }
        else {
            logfunc(0,cp,"Couldn't save description");
        }
        bbs_close(cp,handle);
    }
    else {

Error:

        logfunc(0,cp,"Couldn't save description");
    }

    sprintf(s,"FILEDESC.%03",cp);
    unlink(s);
    bbs_free(cp,s);
    return 0;
}
