#include <ctype.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <process.h>
#include "mailer.h"
#include "modem.h"
#include "bbs.h"
#include "bitfuncs.h"
#include "xmisc.h"
#include "xmsg.h"
#include "keys.h"

    extern MDM      *modems[MAXINSTANCES];
    extern USER     *user[MAXINSTANCES];
    extern BBS      *bbs;
    extern MSGAREA  *msgareas;
    extern FILEAREA *fileareas;
    extern int      helpkey;

#define  INCL_RXSUBCOM
#define  INCL_RXSYSEXIT
#define  INCL_RXFUNC

#include <rexxsaa.h>

  BOOL           fRexxOK = FALSE;

  static HMODULE hmodREXX;
  static HMODULE hmodREXXAPI;

  static SHORT   (APIENTRY *pfnREXXSAA)(SHORT,PRXSTRING,
                                        PSZ,PRXSTRING,PSZ,SHORT,
                                        PRXSYSEXIT,PSHORT,PRXSTRING);
  static USHORT  (APIENTRY *pfnRxSubcomRegister)(PSCBLOCK);
  static USHORT  (APIENTRY *pfnRxSubcomQuery)(PSZ,PSZ,PUSHORT,double *);
  static USHORT  (APIENTRY *pfnRxSubcomDrop)(PSZ,PSZ);
  static USHORT  (APIENTRY *pfnRxFunctionRegister)(PSZ,PSZ,PSZ,USHORT);
  static USHORT  (APIENTRY *pfnRxFunctionDeregister)(PSZ);
  static USHORT  (APIENTRY *pfnRxFunctionQuery)(PSZ);

USHORT _fastcall RexxExecCommand (char *cmd,PRXSTRING prxstrgret);

#define XREXXSAA              (*pfnREXXSAA)
#define XRxSubcomRegister     (*pfnRxSubcomRegister)
#define XRxSubcomDrop         (*pfnRxSubcomDrop)
#define XRxSubcomQuery        (*pfnRxSubcomQuery)
#define XRxFunctionRegister   (*pfnRxFunctionRegister)
#define XRxFunctionDeregister (*pfnRxFunctionDeregister)
#define XRxFunctionQuery      (*pfnRxFunctionQuery)


USHORT LoadRexx (void) {

  HMODULE hmod;
  CHAR    achBuf[CCHMAXPATH];
  USHORT  usErr;

  if(hmodREXX)
    return TRUE;
  fRexxOK = FALSE;
  usErr = DosLoadModule(achBuf, CCHMAXPATH, "REXX", &hmod);
  if(usErr) {
    logfmain("ERROR: DosLoadModule REXX: %u",usErr);
    return FALSE;
  }
  hmodREXX = hmod;

  usErr = DosLoadModule(achBuf, CCHMAXPATH, "REXXAPI", &hmod);
  if(usErr) {
    DosFreeModule(hmodREXX);
    logfmain("ERROR: DosLoadModule REXXAPI: %u",usErr);
    hmodREXX = 0;
    return FALSE;
  }
  hmodREXXAPI = hmod;

  usErr = DosGetProcAddr(hmodREXX,"REXXSAA",(PPFN)&pfnREXXSAA);
  if(usErr) {
    logfmain("ERROR: DosGetProcAddr REXXSAA: %u",usErr);
    goto WasError;
  }
  usErr = DosGetProcAddr(hmodREXXAPI,"RXSUBCOMREGISTER",(PPFN)&pfnRxSubcomRegister);
  if(usErr) {
    logfmain("ERROR: DosGetProcAddr RXSUBCOMREGISTER: %u",usErr);
    goto WasError;
  }
  usErr = DosGetProcAddr(hmodREXXAPI,"RXSUBCOMDROP",(PPFN)&pfnRxSubcomDrop);
  if(usErr) {
    logfmain("ERROR: DosGetProcAddr RXSUBCOMDROP: %u",usErr);
    goto WasError;
  }
  usErr = DosGetProcAddr(hmodREXXAPI,"RXSUBCOMQUERY",(PPFN)&pfnRxSubcomQuery);
  if(usErr) {
    logfmain("ERROR: DosGetProcAddr RXSUBCOMQUERY: %u",usErr);
    goto WasError;
  }
  usErr = DosGetProcAddr(hmodREXXAPI,"RXFUNCTIONREGISTER",(PPFN)&pfnRxFunctionRegister);
  if(usErr) {
    logfmain("ERROR: DosGetProcAddr RXFUNCTIONREGISTER: %u",usErr);
    goto WasError;
  }
  usErr = DosGetProcAddr(hmodREXXAPI,"RXFUNCTIONDEREGISTER",(PPFN)&pfnRxFunctionDeregister);
  if(usErr) {
    logfmain("ERROR: DosGetProcAddr RXFUNCTIONDEREGISTER: %u",usErr);
    goto WasError;
  }
  usErr = DosGetProcAddr(hmodREXXAPI,"RXFUNCTIONQUERY",(PPFN)&pfnRxFunctionQuery);
  if(usErr) {
    logfmain("ERROR: DosGetProcAddr RXFUNCTIONQUERY: %u",usErr);
    goto WasError;
  }

WasError:

  if(usErr) {
    DosFreeModule(hmodREXX);
    DosFreeModule(hmodREXXAPI);
    hmodREXX = hmodREXXAPI = 0;
    return FALSE;
  }

  return (fRexxOK = TRUE);
}


SHORT EXPENTRY XBBSREXX (PRXSTRING p,PUSHORT pusRet,PRXSTRING prxstrgret) {

  CHAR    achBuf[1024];
  ULONG   i;

  i = p->strlength;
  memcpy(achBuf, p->strptr, (SHORT)i);
  achBuf[i] = 0;
  *pusRet = RexxExecCommand(achBuf,prxstrgret);
  if(prxstrgret->strptr)
    i = atol(prxstrgret->strptr);
  else
    i = 0;

  return (SHORT)i;
}


USHORT EXPENTRY XBBSPRINT (PSZ name,SHORT argc,PRXSTRING argv,
                           PSZ queue,PRXSTRING retstr) {

  char *retstring;
  SHORT x;
  CHAR  achBuf[1024];
  ULONG i;
  int   mode;
  USHORT cp;

  retstr->strlength = 0L;
  if(argc > 1) {
    i = argv[0].strlength;
    memcpy(achBuf,argv[0].strptr, (SHORT)i);
    achBuf[i] = 0;
    cp = atoi(achBuf);
    if(cp < MAXINSTANCES && modems[cp] && user[cp]) {
      mode = (modems[cp]->curbaud) ? D_BOTH : D_LOCAL;
      for(x = 1;x < argc;x++) {
        i = argv[x].strlength;
        memcpy(achBuf,argv[x].strptr, (SHORT)i);
        achBuf[i] = 0;
        if(*achBuf) {
          retstring = bbs_convert_string(cp,literal(achBuf));
          if(retstring && *retstring)
            dputs(mode,cp,retstring);
          bbs_free(cp,retstring);
        }
      }
    }
  }
  return RXFUNC_OK;
}


USHORT EXPENTRY XBBSCALL (PSZ name,SHORT argc,PRXSTRING argv,
                          PSZ queue,PRXSTRING retstr) {

  char *retstring;
  SHORT x;
  CHAR  achBuf[1024],cmdstr[1025] = "";
  ULONG i;
  int   mode,type,ret = -1,flags;
  USHORT cp;

  if(argc > 3) {
    i = argv[0].strlength;
    memcpy(achBuf,argv[0].strptr, (SHORT)i);
    achBuf[i] = 0;
    cp = atoi(achBuf);
    if(cp < MAXINSTANCES && modems[cp] && user[cp]) {
      mode = (modems[cp]->curbaud) ? D_BOTH : D_LOCAL;
      i = argv[1].strlength;
      memcpy(achBuf,argv[1].strptr, (SHORT)i);
      achBuf[i] = 0;
      type = atoi(achBuf);
      if(type > 0 && type < 4) {
        i = argv[2].strlength;
        memcpy(achBuf,argv[2].strptr, (SHORT)i);
        achBuf[i] = 0;
        flags = atoi(achBuf);
        for(x = 3;x < argc;x++) {
          i = argv[x].strlength;
          memcpy(achBuf,argv[x].strptr, (SHORT)i);
          achBuf[i] = 0;
          if(*achBuf) {
            retstring = bbs_convert_string(cp,literal(achBuf));
            if(retstring && *retstring) {
              strncat(cmdstr," ",1024);
              cmdstr[1024] = 0;
              strncat(cmdstr,retstring,1024);
              cmdstr[1024] = 0;
            }
            bbs_free(cp,retstring);
          }
        }
        if(type == 1)
          ret = wait_sessionf(mode,cp,flags,cmdstr);
        else if(type == 2)
          ret = runemf(mode,cp,0,cmdstr);
        else if(type == 3)
          ret = runemf(mode,cp,1,cmdstr);
      }
    }
  }
  sprintf(retstr->strptr,"%d",ret);
  retstr->strlength = (long)atoi(retstr->strptr);
  return RXFUNC_OK;
}


USHORT EXPENTRY XBBSLOG (PSZ name,SHORT argc,PRXSTRING argv,
                         PSZ queue,PRXSTRING retstr) {

  char *retstring;
  SHORT x;
  CHAR  achBuf[1024],logstr[1025] = "";
  ULONG i;
  int   mode,type,ret = -1;
  USHORT cp;

  if(argc > 2) {
    i = argv[0].strlength;
    memcpy(achBuf,argv[0].strptr, (SHORT)i);
    achBuf[i] = 0;
    cp = atoi(achBuf);
    if(cp < MAXINSTANCES && modems[cp] && user[cp]) {
      mode = (modems[cp]->curbaud) ? D_BOTH : D_LOCAL;
      i = argv[1].strlength;
      memcpy(achBuf,argv[1].strptr, (SHORT)i);
      achBuf[i] = 0;
      type = atoi(achBuf);
      if(type > 0 && type < 3) {
        for(x = 2;x < argc;x++) {
          i = argv[x].strlength;
          memcpy(achBuf,argv[x].strptr, (SHORT)i);
          achBuf[i] = 0;
          if(*achBuf) {
            retstring = bbs_convert_string(cp,literal(achBuf));
            if(retstring && *retstring) {
              strncat(logstr," ",1024);
              logstr[1024] = 0;
              strncat(logstr,retstring,1024);
              logstr[1024] = 0;
            }
            bbs_free(cp,retstring);
          }
        }
        logfunc((type & 3),cp,logstr);
      }
    }
  }
  retstr->strlength = 0;
  return RXFUNC_OK;
}



USHORT EXPENTRY XBBSSEND (PSZ name,SHORT argc,PRXSTRING argv,
                          PSZ queue,PRXSTRING retstr) {

  SHORT         x;
  CHAR          achBuf[1024],path[257];
  ULONG         i;
  int           mode,flags;
  USHORT        cp;
  unsigned long numfiles = 0L;
  long          numbytes = 0L;

  if(argc > 3) {
    i = argv[0].strlength;
    memcpy(achBuf,argv[0].strptr, (SHORT)i);
    achBuf[i] = 0;
    cp = atoi(achBuf);
    if(cp < MAXINSTANCES && modems[cp] && user[cp]) {
      mode = (modems[cp]->curbaud) ? D_BOTH : D_LOCAL;
      i = argv[1].strlength;
			memcpy(achBuf,argv[1].strptr,(SHORT)i);
      achBuf[i] = 0;
      flags = atoi(achBuf);
      i = argv[2].strlength;
			memcpy(achBuf,argv[2].strptr,(SHORT)i);
      achBuf[i] = 0;
      strncpy(path,achBuf,257);
      path[256] = 0;
      for(x = 3;x < argc;x++) {
        i = argv[x].strlength;
        memcpy(achBuf,argv[x].strptr, (SHORT)i);
        achBuf[i] = 0;
        if(*achBuf)
          numbytes += download_files(mode,cp,achBuf,(*path) ? path : NULL,
                                     &numfiles,flags);
      }
    }
  }
  sprintf(retstr->strptr,"%lu %lu",numbytes,numfiles);
  retstr->strlength = (long)strlen(retstr->strptr);
  return RXFUNC_OK;
}



USHORT EXPENTRY XBBSRECV (PSZ name,SHORT argc,PRXSTRING argv,
                          PSZ queue,PRXSTRING retstr) {

  SHORT         x;
  CHAR          achBuf[1024],path[257],area[65];
  ULONG         i;
  int           mode,flags;
  USHORT        cp;
  unsigned long numfiles = 0L;
  long          numbytes = 0L;

  if(argc > 4) {
    i = argv[0].strlength;
    memcpy(achBuf,argv[0].strptr, (SHORT)i);
    achBuf[i] = 0;
    cp = atoi(achBuf);
    if(cp < MAXINSTANCES && modems[cp] && user[cp]) {
      mode = (modems[cp]->curbaud) ? D_BOTH : D_LOCAL;
      i = argv[1].strlength;
      memcpy(achBuf,argv[1].strptr, (SHORT)i);
      achBuf[i] = 0;
      flags = atoi(achBuf);
      i = argv[2].strlength;
      memcpy(achBuf,argv[2].strptr, (SHORT)i);
      achBuf[i] = 0;
      strncpy(path,achBuf,257);
      path[256] = 0;
      i = argv[3].strlength;
      memcpy(achBuf,argv[3].strptr, (SHORT)i);
      achBuf[i] = 0;
      strncpy(area,achBuf,65);
      area[64] = 0;
      for(x = 4;x < argc;x++) {
        i = argv[x].strlength;
        memcpy(achBuf,argv[x].strptr, (SHORT)i);
        achBuf[i] = 0;
        if(*achBuf)
          numbytes += upload_files(mode,cp,achBuf,(*path) ? path : NULL,
                                   (*area) ? area : NULL,&numfiles,flags);
      }
    }
  }
  sprintf(retstr->strptr,"%lu %lu",numbytes,numfiles);
  retstr->strlength = (long)strlen(retstr->strptr);
  return RXFUNC_OK;
}



USHORT EXPENTRY XBBSTIMELEFT (PSZ name,SHORT argc,PRXSTRING argv,
                              PSZ queue,PRXSTRING retstr) {

  CHAR  achBuf[1024];
  ULONG i;
  int   mode;
  USHORT cp;

  retstr->strlength = 0L;
  if(argc) {
    i = argv[0].strlength;
    memcpy(achBuf,argv[0].strptr, (SHORT)i);
    achBuf[i] = 0;
    cp = atoi(achBuf);
    if(cp < MAXINSTANCES && modems[cp] && user[cp]) {
      mode = (modems[cp]->curbaud) ? D_BOTH : D_LOCAL;
      if(argc > 1) {
        i = argv[0].strlength;
        memcpy(achBuf,argv[0].strptr, (SHORT)i);
        achBuf[i] = 0;
        if(atol(achBuf))
          user[cp]->offline = time(NULL) + atol(achBuf);
      }
      sprintf(retstr->strptr,"%ld",user[cp]->offline - time(NULL));
      retstr->strlength = (long)strlen(retstr->strptr);
    }
  }
  return RXFUNC_OK;
}


USHORT EXPENTRY XBBSMENU (PSZ name,SHORT argc,PRXSTRING argv,
													PSZ queue,PRXSTRING retstr) {

  CHAR  achBuf[1024];
  ULONG i;
	int 	mode,flags;
  USHORT cp;

  retstr->strlength = 0L;
	if(argc > 2) {
    i = argv[0].strlength;
    memcpy(achBuf,argv[0].strptr, (SHORT)i);
    achBuf[i] = 0;
    cp = atoi(achBuf);
    if(cp < MAXINSTANCES && modems[cp] && user[cp]) {
      mode = (modems[cp]->curbaud) ? D_BOTH : D_LOCAL;
			i = argv[1].strlength;
			memcpy(achBuf,argv[1].strptr, (SHORT)i);
			achBuf[i] = 0;
			flags = atoi(achBuf);
			i = argv[2].strlength;
			memcpy(achBuf,argv[2].strptr, (SHORT)i);
      achBuf[i] = 0;
			menu_drvr(mode,cp,achBuf,0,flags);
    }
  }
  return RXFUNC_OK;
}


USHORT EXPENTRY XBBSCONVERT (PSZ name,SHORT argc,PRXSTRING argv,
                             PSZ queue,PRXSTRING retstr) {

  char *retstring;
  CHAR  achBuf[1024];
  ULONG i;
  int   mode;
  USHORT cp;

  retstr->strlength = 0L;
  if(argc > 1) {
    i = argv[0].strlength;
    memcpy(achBuf,argv[0].strptr, (SHORT)i);
    achBuf[i] = 0;
    cp = atoi(achBuf);
    if(cp < MAXINSTANCES && modems[cp] && user[cp]) {
      mode = (modems[cp]->curbaud) ? D_BOTH : D_LOCAL;
      i = argv[1].strlength;
      memcpy(achBuf,argv[1].strptr, (SHORT)i);
      achBuf[i] = 0;
      retstring = bbs_convert_string(cp,literal(achBuf));
      if(retstring) {
        strncpy(retstr->strptr,retstring,250);
        bbs_free(cp,retstring);
        retstr->strptr[249] = 0;
        retstr->strlength = (long)strlen(retstr->strptr);
      }
    }
  }
  return RXFUNC_OK;
}


USHORT EXPENTRY XBBSCLS (PSZ name,SHORT argc,PRXSTRING argv,
                         PSZ queue,PRXSTRING retstr) {

  CHAR  achBuf[1024];
  ULONG i;
  int   mode;
  USHORT cp;

  retstr->strlength = 0L;
  if(argc) {
    i = argv[0].strlength;
    memcpy(achBuf,argv[0].strptr, (SHORT)i);
    achBuf[i] = 0;
    cp = atoi(achBuf);
    if(cp < MAXINSTANCES && modems[cp] && user[cp]) {
      mode = (modems[cp]->curbaud) ? D_BOTH : D_LOCAL;
      cls(mode,cp);
    }
  }
  return RXFUNC_OK;
}



USHORT EXPENTRY XBBSWRITE (PSZ name,SHORT argc,PRXSTRING argv,
                           PSZ queue,PRXSTRING retstr) {

  CHAR  achBuf[1024];
  ULONG i;
  int   mode,flags,ret = 9999,type;
  USHORT cp;

  retstr->strlength = 0L;
  if(argc > 3) {
    i = argv[0].strlength;
    memcpy(achBuf,argv[0].strptr, (SHORT)i);
    achBuf[i] = 0;
    cp = atoi(achBuf);
    if(cp < MAXINSTANCES && modems[cp] && user[cp]) {
      mode = (modems[cp]->curbaud) ? D_BOTH : D_LOCAL;
      i = argv[1].strlength;
      memcpy(achBuf,argv[1].strptr, (SHORT)i);
      achBuf[i] = 0;
      type = atoi(achBuf);
      if(type > 0 && type < 3) {
        i = argv[2].strlength;
        memcpy(achBuf,argv[2].strptr, (SHORT)i);
        achBuf[i] = 0;
        flags = atoi(achBuf);
        i = argv[3].strlength;
        memcpy(achBuf,argv[3].strptr, (SHORT)i);
        achBuf[i] = 0;
        switch(type) {
          case 1:
            ret = write_msg(mode,cp,user[cp]->currmsgarea,NULL,NULL,flags);
            break;
          case 2:
            ret = line_editor(mode,cp,achBuf,0,NULL);
            break;
        }
      }
    }
  }
  sprintf(retstr->strptr,"%d",ret);
  retstr->strlength = (long)strlen(retstr->strptr);
  return RXFUNC_OK;
}


USHORT EXPENTRY XBBSREAD (PSZ name,SHORT argc,PRXSTRING argv,
                          PSZ queue,PRXSTRING retstr) {

  CHAR         achBuf[1024],fname[257];
  ULONG        i;
  int          mode,flags,type,ret = 9999;
  unsigned int startat;
  USHORT       cp;
  MSGAREA     *msga;
  FILEAREA    *filea;
  LIBAREA     *liba;

  retstr->strlength = 0L;
  if(argc > 4) {
    i = argv[0].strlength;
    memcpy(achBuf,argv[0].strptr, (SHORT)i);
    achBuf[i] = 0;
    cp = atoi(achBuf);
    if(cp < MAXINSTANCES && modems[cp] && user[cp]) {
      mode = (modems[cp]->curbaud) ? D_BOTH : D_LOCAL;
      i = argv[1].strlength;
      memcpy(achBuf,argv[1].strptr, (SHORT)i);
      achBuf[i] = 0;
      type = atoi(achBuf);
      if(type > 0 && type < 3) {
        i = argv[2].strlength;
        memcpy(achBuf,argv[2].strptr, (SHORT)i);
        achBuf[i] = 0;
        flags = atoi(achBuf);
        i = argv[3].strlength;
        memcpy(achBuf,argv[3].strptr, (SHORT)i);
        achBuf[i] = 0;
        startat = atoi(achBuf);
        strncpy(fname,achBuf,257);
        fname[256] = 0;
        i = argv[4].strlength;
        memcpy(achBuf,argv[4].strptr, (SHORT)i);
        achBuf[i] = 0;
        switch(type) {
          case 1:
            ret = do_msgread1(mode,cp,flags,startat);
            break;
          case 2:
            ret = do_globalmsgread1(mode,cp,flags);
            break;
          case 3:
            ret = how_many_msgs(user[cp]->currmsgarea);
            break;
          case 4:
ReturnName:
            strcpy(retstr->strptr,user[cp]->currmsgarea->name);
            retstr->strlength = (long)strlen(retstr->strptr);
            return RXFUNC_OK;
          case 5:
            ret = user[cp]->currmsgarea->number;
            break;
          case 6:
            msga = find_msg_area(NULL,cp,startat);
            if(msga)
              user[cp]->currmsgarea = msga;
            ret = user[cp]->currmsgarea->number;
            break;
          case 7:
            msga = find_msg_area(achBuf,cp,-1);
            if(msga)
              user[cp]->currmsgarea = msga;
            goto ReturnName;
          case 8:
            msga = next_msg_area(user[cp]->currmsgarea,cp,1);
            if(msga)
              user[cp]->currmsgarea = msga;
            goto ReturnName;
          case 9:
            msga = next_msg_area(user[cp]->currmsgarea,cp,-1);
            if(msga)
              user[cp]->currmsgarea = msga;
            goto ReturnName;
          case 10:
            ret = readansi(mode,cp,fname,(*achBuf) ? achBuf : NULL,flags);
            break;
          case 11:
            ret = readtext(mode,cp,achBuf);
            break;
          case 12:
            ret = readnew(mode,cp,achBuf,flags);
            break;
          case 13:
            ret = readany(mode,cp,achBuf,flags);
            break;
          case 19:
ReturnFileName:
            strcpy(retstr->strptr,user[cp]->currfilearea->name);
            retstr->strlength = (long)strlen(retstr->strptr);
            return RXFUNC_OK;
          case 20:
            ret = user[cp]->currfilearea->number;
            break;
          case 21:
            filea = find_file_area(NULL,cp,startat,0);
            if(filea)
              user[cp]->currfilearea = filea;
            ret = user[cp]->currfilearea->number;
            break;
          case 22:
            filea = find_file_area(achBuf,cp,-1,0);
            if(filea)
              user[cp]->currfilearea = filea;
            goto ReturnFileName;
          case 23:
            filea = next_file_area(user[cp]->currfilearea,cp,1,0);
            if(filea)
              user[cp]->currfilearea = filea;
            goto ReturnFileName;
          case 24:
            filea = next_file_area(user[cp]->currfilearea,cp,-1,0);
            if(filea)
              user[cp]->currfilearea = filea;
            goto ReturnFileName;
          case 25:
            strcpy(retstr->strptr,user[cp]->currfilearea->dpath);
            retstr->strlength = (long)strlen(retstr->strptr);
            return RXFUNC_OK;
          case 26:
            strcpy(retstr->strptr,user[cp]->currfilearea->upath);
            retstr->strlength = (long)strlen(retstr->strptr);
            return RXFUNC_OK;
          case 27:
ReturnLibName:
            strcpy(retstr->strptr,user[cp]->currlibarea->name);
            retstr->strlength = (long)strlen(retstr->strptr);
            return RXFUNC_OK;
          case 28:
            ret = user[cp]->currlibarea->number;
            break;
          case 29:
            liba = find_lib_area(NULL,cp,startat);
            if(liba)
              user[cp]->currlibarea = liba;
            ret = user[cp]->currlibarea->number;
            break;
          case 30:
            liba = find_lib_area(achBuf,cp,-1);
            if(liba)
              user[cp]->currlibarea = liba;
            goto ReturnLibName;
          case 31:
            liba = next_lib_area(user[cp]->currlibarea,cp,1);
            if(liba)
              user[cp]->currlibarea = liba;
            goto ReturnLibName;
          case 32:
            liba = next_lib_area(user[cp]->currlibarea,cp,-1);
            if(liba)
              user[cp]->currlibarea = liba;
            goto ReturnLibName;
          case 33:
            strcpy(retstr->strptr,user[cp]->currlibarea->path);
            retstr->strlength = (long)strlen(retstr->strptr);
            return RXFUNC_OK;
        }
      }
    }
  }
  sprintf(retstr->strptr,"%d",ret);
  retstr->strlength = (long)strlen(retstr->strptr);
  return RXFUNC_OK;
}


USHORT EXPENTRY XBBSINPUT (PSZ name,SHORT argc,PRXSTRING argv,
                           PSZ queue,PRXSTRING retstr) {

  char *retstring;
  CHAR  achBuf[1024],help[41] = "",helpfile[81] = "",prompt[81] = "";
  ULONG i;
  int   mode,minlen = 1,maxlen = 249,type = STRT_ALL,flags = STRF_NOHELP;
  USHORT cp;

  retstr->strlength = 0L;
  *retstr->strptr = 0;
  if(argc) {
    i = argv[0].strlength;
    memcpy(achBuf,argv[0].strptr, (SHORT)i);
    achBuf[i] = 0;
    cp = atoi(achBuf);
    if(cp < MAXINSTANCES && modems[cp] && user[cp]) {
      mode = (modems[cp]->curbaud) ? D_BOTH : D_LOCAL;
      if(argc < 5) {
        input_string(mode,cp,retstr->strptr,249,1,NULL,STRT_ALL,
                     STRF_NOHELP,NULL,NULL);
        retstr->strlength = strlen(retstr->strptr);
      }
      else {
        i = argv[1].strlength;
        memcpy(achBuf,argv[1].strptr, (SHORT)i);
        achBuf[i] = 0;
        minlen = min(1,atoi(achBuf));
        i = argv[2].strlength;
        memcpy(achBuf,argv[2].strptr, (SHORT)i);
        achBuf[i] = 0;
        maxlen = min(1,atoi(achBuf));
        i = argv[3].strlength;
        memcpy(achBuf,argv[3].strptr, (SHORT)i);
        achBuf[i] = 0;
        type = atoi(achBuf);
        i = argv[4].strlength;
        memcpy(achBuf,argv[4].strptr, (SHORT)i);
        achBuf[i] = 0;
        flags = atoi(achBuf);
        if(argc > 5) {
          i = argv[5].strlength;
          memcpy(achBuf,argv[5].strptr, (SHORT)i);
          achBuf[i] = 0;
          retstring = bbs_convert_string(cp,literal(achBuf));
          if(retstring) {
            strncpy(prompt,retstring,81);
            prompt[80] = 0;
            bbs_free(cp,retstring);
          }
          else
            *prompt = 0;
          if(argc > 7) {
            i = argv[6].strlength;
            memcpy(achBuf,argv[6].strptr, (SHORT)i);
            achBuf[i] = 0;
            retstring = bbs_convert_string(cp,literal(achBuf));
            if(retstring) {
              strncpy(help,retstring,41);
              help[40] = 0;
              bbs_free(cp,retstring);
            }
            else
              *help = 0;
            i = argv[7].strlength;
            memcpy(achBuf,argv[7].strptr, (SHORT)i);
            achBuf[i] = 0;
            retstring = bbs_convert_string(cp,literal(achBuf));
            if(retstring) {
              strncpy(helpfile,retstring,81);
              helpfile[80] = 0;
              bbs_free(cp,retstring);
            }
            else
              *helpfile = 0;
          }
          if(argc > 8) {
            i = argv[8].strlength;
            memcpy(achBuf,argv[8].strptr, (SHORT)i);
            achBuf[i] = 0;
            retstring = bbs_convert_string(cp,literal(achBuf));
            if(retstring) {
              strncpy(retstr->strptr,retstring,249);
              retstr->strptr[249] = 0;
              bbs_free(cp,retstring);
            }
          }
        }
        input_string(mode,cp,retstr->strptr,maxlen,minlen,(*prompt) ?
                     prompt : NULL,type,flags,(*help) ? help : NULL,
                     (*helpfile) ? helpfile : NULL);
        retstr->strlength = strlen(retstr->strptr);
      }
    }
  }
  return RXFUNC_OK;
}


void UnloadRexx (void) {

  if(hmodREXX == 0)
    return;
  XRxFunctionDeregister("XBBSPRINT");
  XRxFunctionDeregister("XBBSCONVERT");
  XRxFunctionDeregister("XBBSTIMELEFT");
  XRxFunctionDeregister("XBBSINPUT");
  XRxFunctionDeregister("XBBSCLS");
	XRxFunctionDeregister("XBBSSEND");
	XRxFunctionDeregister("XBBSRECV");
	XRxFunctionDeregister("XBBSCALL");
	XRxFunctionDeregister("XBBSMENU");
  XRxFunctionDeregister("XBBSLOG");
  XRxFunctionDeregister("XBBSREAD");
  XRxFunctionDeregister("XBBSWRITE");
  XRxSubcomDrop("XBBSSUBCOM",NULL);
  DosFreeModule(hmodREXX);
  DosFreeModule(hmodREXXAPI);
  hmodREXX = hmodREXXAPI = 0;
  fRexxOK = FALSE;
}


USHORT RexxScriptFile (int mode,USHORT cp,char *fname) {

  SCBLOCK   sc_block;
  RXSYSEXIT exit_list[] = { {NULL, RXENDLST} };
  RXSTRING  arg;                       /* argument string for REXX   */
  RXSTRING  rexxretval;                /* return value from REXX     */
  SHORT     rc = 0;                    /* return code from REXX      */
  SHORT     rexxrc = 0;                /* return code from function  */
  CHAR     *s;
  USHORT    usErr,isreg;
  double    dummy;

  if(hmodREXX == 0) {
    dprintf(mode,cp,"\r\nSorry, REXX is not loaded.\r\n");
    logfunc(0,cp,"Rexx is not loaded");
    return 0xffff;                    /* If we aren't loaded, leave */
  }

  /* note: assigning during declaration per SAAREXX.INF freaks MSC out */
  memset(&sc_block,0,sizeof(SCBLOCK));
  sc_block.scbname = "XBBSSUBCOM";
  sc_block.scbaddr = (PFN)XBBSREXX;

  /* register subcommand environment, if not already registered */
  usErr = XRxSubcomQuery("XBBSSUBCOM",NULL,&isreg,&dummy);
  if(usErr || !isreg) {
    usErr = XRxSubcomRegister(&sc_block);
    if(usErr)
      logfmain("RxSubcomRegister failed: %u",usErr);
  }

  /* register functions, if not already registered */
  if(XRxFunctionQuery("XBBSPRINT"))
    if(XRxFunctionRegister("XBBSPRINT",NULL,(PSZ)((PFN)XBBSPRINT),
                           RXFUNC_CALLENTRY))
      logfmain("RxFunctionRegister XBBSPRINT failed");
  if(XRxFunctionQuery("XBBSINPUT"))
    if(XRxFunctionRegister("XBBSINPUT",NULL,(PSZ)((PFN)XBBSINPUT),
                           RXFUNC_CALLENTRY))
      logfmain("RxFunctionRegister XBBSINPUT failed");
  if(XRxFunctionQuery("XBBSCONVERT"))
    if(XRxFunctionRegister("XBBSCONVERT",NULL,(PSZ)((PFN)XBBSCONVERT),
                           RXFUNC_CALLENTRY))
      logfmain("RxFunctionRegister XBBSCONVERT failed");
  if(XRxFunctionQuery("XBBSTIMELEFT"))
    if(XRxFunctionRegister("XBBSTIMELEFT",NULL,(PSZ)((PFN)XBBSTIMELEFT),
                           RXFUNC_CALLENTRY))
      logfmain("RxFunctionRegister XBBSTIMELEFT failed");
  if(XRxFunctionQuery("XBBSCLS"))
    if(XRxFunctionRegister("XBBSCLS",NULL,(PSZ)((PFN)XBBSCLS),
                           RXFUNC_CALLENTRY))
      logfmain("RxFunctionRegister XBBSCLS failed");
  if(XRxFunctionQuery("XBBSSEND"))
    if(XRxFunctionRegister("XBBSSEND",NULL,(PSZ)((PFN)XBBSSEND),
                           RXFUNC_CALLENTRY))
      logfmain("RxFunctionRegister XBBSSEND failed");
	if(XRxFunctionQuery("XBBSRECV"))
    if(XRxFunctionRegister("XBBSRECV",NULL,(PSZ)((PFN)XBBSRECV),
                           RXFUNC_CALLENTRY))
			logfmain("RxFunctionRegister XBBSRECV failed");
	if(XRxFunctionQuery("XBBSCALL"))
    if(XRxFunctionRegister("XBBSCALL",NULL,(PSZ)((PFN)XBBSCALL),
                           RXFUNC_CALLENTRY))
			logfmain("RxFunctionRegister XBBSCALL failed");
	if(XRxFunctionQuery("XBBSMENU"))
    if(XRxFunctionRegister("XBBSMENU",NULL,(PSZ)((PFN)XBBSMENU),
                           RXFUNC_CALLENTRY))
			logfmain("RxFunctionRegister XBBSMENU failed");
  if(XRxFunctionQuery("XBBSLOG"))
    if(XRxFunctionRegister("XBBSLOG",NULL,(PSZ)((PFN)XBBSLOG),
                           RXFUNC_CALLENTRY))
      logfmain("RxFunctionRegister XBBSLOG failed");
  if(XRxFunctionQuery("XBBSREAD"))
    if(XRxFunctionRegister("XBBSREAD",NULL,(PSZ)((PFN)XBBSREAD),
                           RXFUNC_CALLENTRY))
      logfmain("RxFunctionRegister XBBSREAD failed");
  if(XRxFunctionQuery("XBBSWRITE"))
    if(XRxFunctionRegister("XBBSWRITE",NULL,(PSZ)((PFN)XBBSWRITE),
                           RXFUNC_CALLENTRY))
      logfmain("RxFunctionRegister XBBSWRITE failed");

  if(!fname)        /* just wanted to register stuff */
    return 0xfffe;

  rexxretval.strlength = 0L;          /* initialize return to empty */
  rexxretval.strptr    = NULL;        /* initialize return to empty */

  s = malloc(250);
  if(!s) {
    logfunc(0,cp,"Out of memory");
    return 0xffff;
  }
  sprintf(s,"%u",cp);                 /* initialize argument */
  MAKERXSTRING(arg,s,strlen(s));

  logfunc(0,cp,"Executing REXX interpreter on \"%s\"",fname);
  dprintf(D_LOCAL,cp,"\r\n\04Executing REXX interpreter on \"%s\"...\r\n",fname);

  {
    char filename[1050];

    if(!strchr(fname,':') && !strchr(fname,'/') && !strchr(fname,'\\'))
      sprintf(filename,"%s/%s",d_menu,fname);
    else
      strcpy(filename,fname);

    rc = XREXXSAA( (SHORT)      1,         /* call the REXX interpreter  */
                   (PRXSTRING)  &arg,
                   (PSZ)        filename,
                   (PRXSTRING)  0,
                   (PSZ)        "XBBSSUBCOM",
                   (SHORT)      RXSUBROUTINE,
                   (PRXSYSEXIT) exit_list,
                   (PSHORT)     &rexxrc,
                   (PRXSTRING)  &rexxretval );

  }
  logfunc(0,cp,"Rexx returned: %d (%d)",rexxrc,rc);
  dprintf(D_LOCAL,cp,"\r\n\04Rexx returned: %d (%d)\r\n",rexxrc,rc);
  if(arg.strptr)
    free(arg.strptr);
  if(rexxretval.strptr)
    DosFreeSeg(SELECTOROF(rexxretval.strptr));
  return rexxrc;
}

  /*
   * This is the actual subcom handler.
   *   cmd        is the actual command to execute
   *   prxstrgret is the result buffer to fill
   * The function should return RXSUBCOM_OK or RXSUBCOM_ERROR
   */

USHORT _fastcall RexxExecCommand (char *cmd, PRXSTRING retval) {

  SHORT       len;
  CHAR        FailName[CCHMAXPATH],comspec[CCHMAXPATH],*p;
  PSZ         parm;
  RESULTCODES rescode;
  USHORT      retcode = RXSUBCOM_OK;

  /*******************************************************************/
  /* All we are going to do here is pass on the command passed to us */
  /* to another copy of CMD.EXE and have it execute the command.     */
  /*******************************************************************/

  strncpy(FailName,cmd,CCHMAXPATH);
  FailName[CCHMAXPATH - 1] = 0;
  lstrip(FailName);
  p = strchr(FailName,' ');
  if(p)
    *p = 0;
  if(!strnicmp(FailName,"CD\\",3) || !strnicmp(FailName,"CD.",3) ||
     !stricmp(FailName,"CD") || !stricmp(FailName,"CHDIR")) {
BombOut:
    *retval->strptr = '-';
    retval->strptr[1] = '1';
    retval->strlength = 2L;
    return (USHORT)-1;
  }
  if(isalpha(*FailName) &&  FailName[1] == ':' && FailName[2] == 0)
    goto BombOut;
  if(isdos(FailName))
    goto BombOut;

  parm = malloc ((USHORT) strlen(cmd) + CCHMAXPATH + 18);
  if(!parm) {
    retval->strlength = 0L;
    return RXSUBCOM_ERROR;
  }
  p = getenv("COMSPEC");
  if(!p)
    p = "CMD.EXE";
  strcpy(comspec,p);
  strcpy(parm,p);
  len = strlen (parm) + 1;
  strcpy (parm + len," /C ");
  len += 4;
  memcpy (parm + len, cmd, (USHORT)strlen(cmd));
  len += (USHORT) strlen(cmd);
  if(!strchr(parm,'>')) {
    strcat(parm," 1> NULL 2> NULL");
    len += 16;
  }
  *(parm + len) = '\0';
  *(parm + len + 1) = '\0';

  DosExecPgm (FailName, sizeof (FailName), EXEC_SYNC, parm, NULL,
              &rescode, comspec);

  if(rescode.codeTerminate != TC_EXIT)
     retcode = RXSUBCOM_ERROR;
  free (parm);

  itoa (rescode.codeResult, retval -> strptr, 10);
  retval->strlength = (ULONG) strlen (retval->strptr);

  return retcode;
}


int _fastcall isdos (char *filename) {

  char    origname[CCHMAXPATH],foundname[CCHMAXPATH],*p,*pp;
  USHORT  apptype;

  strcpy(origname,filename);
  p = stristr(origname,".BAT");
  if(p && *(p + 4) == 0)
    return 1;
  p = searchpath(origname,foundname,CCHMAXPATH);
  if(!*p) {
    pp = &origname[strlen(origname)];
    strcat(origname,".EXE");
    p = searchpath(origname,foundname,CCHMAXPATH);
    if(!*p) {
      *pp = 0;
      strcat(origname,".COM");
      p = searchpath(origname,foundname,CCHMAXPATH);
      if(!*p) {
        *pp = 0;
        strcat(origname,".BAT");
        p = searchpath(origname,foundname,CCHMAXPATH);
        if(!*p)
          p = origname;
      }
    }
  }
  if(!DosQAppType(p,&apptype) && (apptype & DOSFORMAT))
    return 1;

  return 0;
}
