
struct __Hello__ {
    unsigned int     signal;           /* always 'o'     (0x6f)                   */
    unsigned int     hello_version;    /* currently 1    (0x01)                   */
    unsigned int     product;          /* product code                            */
    unsigned int     product_maj;      /* major revision of the product           */
    unsigned int     product_min;      /* minor revision of the product           */
    char             my_name[60];      /* Other end's name                        */
    char             sysop[20];        /* sysop's name                            */
    unsigned int     my_zone;          /* 0== not supported                       */
    unsigned int     my_net;           /* out primary net number                  */
    unsigned int     my_node;          /* our primary node number                 */
    unsigned int     my_point;         /* 0== not supported                       */
    char             my_password[8];   /* This is not necessarily null-terminated */
    char             reserved2[8];     /* reserved by Opus                        */
    unsigned int     capabilities;     /* see below                               */
    char             reserved3[12];    /* for non-Opus systems with "approval"    */
};                                     /*          total size 128 bytes           */

typedef struct __Hello__ HELLO;


/*------------------------------------------------------------------------*/
/* YOOHOO<tm> CAPABILITY VALUES                                           */
/*------------------------------------------------------------------------*/
#define Y_DIETIFNA 0x0001  /* Can do fast "FTS-0001"  0000 0000 0000 0001 */
#define FTB_USER   0x0002  /* Full-Tilt Boogie        0000 0000 0000 0010 */
#define ZED_ZIPPER 0x0004  /* Does ZModem, 1K blocks  0000 0000 0000 0100 */
#define ZED_ZAPPER 0x0008  /* Can do ZModem variant   0000 0000 0000 1000 */
#define DOES_IANUS 0x0010  /* Can do Janus            0000 0000 0001 0000 */
#define Bit_5      0x0020  /* reserved by FTSC        0000 0000 0010 0000 */
#define Bit_6      0x0040  /* reserved by FTSC        0000 0000 0100 0000 */
#define Bit_7      0x0080  /* reserved by FTSC        0000 0000 1000 0000 */
#define Bit_8      0x0100  /* reserved by FTSC        0000 0001 0000 0000 */
#define DO_HYDRA   0x0200  /* reserved by FTSC        0000 0010 0000 0000 */
#define DO_DOMAIN  0x0400  /* domain is behind my_name0000 0100 0000 0000 */
#define SEA_1K     0x0800  /* sealink 1K              0000 1000 0000 0000 */
#define Bit_c      0x1000  /* reserved by FTSC        0001 0000 0000 0000 */
#define Bit_d      0x2000  /* reserved by FTSC        0010 0000 0000 0000 */
#define Bit_e      0x4000  /* reserved by FTSC        0100 0000 0000 0000 */
#define WZ_FREQ    0x8000  /* WZ file req. ok         1000 0000 0000 0000 */
