'
'                ĿĿĿ   ҿĿ  Ŀ   ĿĿ
'                 Ĵ           1.O
'                ٽ        ٽ
'                From  U n d e r W A R E  L a b s. (c)1998
'
' A program for tracking and finding drawing files created by AutoCAD(tm).
'
' Note: This program does NOT in any way associate, alter, read, access, or
' otherwise process any file(s) other than those created by DWGFILER.  All
' data is user identified or maintained.  Because of this, you do not
' necessarily need a CAD program; it could just as easily be used to track
' drawings or files for other systems.
'
' That said... UnderWARE labs (UWLabs), neither endorses, nor discounts the
' programs by AutoDESK (re: AutoCAD).  And any mention hereof is for the
' express purposes and demonstration of the program.
'                                                                    (more)
'
' This program is SHAREWARE - if you find this program useful you are
' encouraged to register it. (Registration is $5.00)
'
' All work contained herein is copyright(c)1998 UWLabs.
' Permission for use, copying, and parsing must be granted in WRITING.
'
' To reach UWLabs for questions, comments, suggestions, or registration...
'
'
'
'       EMail:   uwlabs@aol.com
'         WWW:   http://members.aol.com/uwlabs/index.html
'        USPS:   UnderWARE Labs
'                2500 Goble Rd.
'                Hiddenite, NC 28636
'
'                                                                    (more)
'
' Files required:
'
'       DWGFILER.BAS    - This file.
'       DWGFILER.DAT    - The data file. (All records go here)
'       FILRFORM.TXT    - Data gathering form.
'       FILRHELP.TXT    - DwgFiler's Help file.
'
' Please make sure that all the above files reside in the same directory.
'
' Requirements:
'
'       PC-compatble, QBasic(tm), EGA w/64kRAM+, .53kb per record free.
'       (Max requirement, 16.8 Meg disk free space for 32766 records)
'
'---------------------------------------------------------------------------------
'*EndOFMessage*EndOFMessage*EndOFMessage*EndOFMessage*EndOFMessage*EndOFMessage
' ---------------------------------------------------------------------------
'  Start Program area below...
'
DECLARE SUB PrintOne ()
DECLARE SUB PrintSummary ()
DECLARE SUB PrintDetailed ()
DECLARE SUB Help (i%)
DECLARE SUB PrintForms ()
DECLARE SUB Delay (Amt!)
DECLARE SUB ShowTime ()
DECLARE SUB CreateNew ()
DECLARE SUB EditOne (i%)
DECLARE SUB Chirp ()
DECLARE SUB AboutUWL ()
DECLARE SUB AboutDF ()
DECLARE SUB AddToList (t%)
DECLARE SUB Resources (i%)
DECLARE SUB DisplayRecord (i%)
DECLARE SUB SearchBy (i%)
DECLARE FUNCTION TextDialog$ (y1%, x1%, y2%, x2%, Stored$)
DECLARE SUB RestoreScreen ()
DECLARE SUB OriginalScreen ()
DECLARE SUB LoadMenu ()
DECLARE SUB HiliteMenu (Index%)
DECLARE SUB RegularMenu ()
DECLARE SUB PullMenu (MenuNumber%)
DECLARE FUNCTION SelectFromMenu$ ()
DECLARE SUB MenuHilite (MenuNumber%)
DECLARE SUB SearchKeys (a$)
DECLARE SUB Logo ()
DECLARE SUB Center (y%, Text$)
DECLARE FUNCTION PromptQuit$ ()
DECLARE FUNCTION GetInput$ (Rpos%, Cpos%, Length%, RestoreText$)
DECLARE SUB MakePopUp (y%, x%, Title$, c1%, c2%)
DECLARE SUB InvalidOption ()
DECLARE FUNCTION CheckDate% (BeginDate$, EndDate$, DateToCheck$)
DIM SHARED Header$(x%), PullDown$(x%, x%)
DIM SHARED PullDownWidth%(x%), Index%, Selection%, Entered%
DIM SHARED Footer$(x%, x%), CurrentIndex%, NewRecNum
DIM SHARED DisplayList(i%)
DIM SHARED ErrorContinue%
'---------------------------------------------------------------------------
' *** DATA STATEMENTS ARE FOR THE MENU SYSTEM!!! DO NOT ALTER!!! ***
'---------------------------------------------------------------------------
DATA &Quit,&Search-By, &Edit, &Update,&Print,Sho&w,&Help,0
DATA E&xit Program, |,&Cancel,0
DATA &Index Number,I&ndex Number Range,|,&Filename,&Partial Name,|
DATA Creation &Date, &Creation Date Range,|
DATA &Revision Date, Re&vision Date Range,|
DATA &AutoCAD Release,|,&Key Word,0
DATA &Create a New Record, &Edit Displayed Record,0
DATA &From Disk Drive...,&To Disk Drive...,0
DATA &Current Display, Current Search &Results
DATA |, Complete Listing (&Summary), Complete Listing (&Detailed)
DATA |,&Entry Forms,|, Eject &Page,0
DATA &Program Resource Use,&Data File Information,0
DATA &Index,&Contents,|,About &DWG-Filer...,About &UWL...,0
DATA Choose to end program, Cancel and return to DWG-Filer
DATA Search for one index number, Search for a specified range of index numbers
DATA Search for a specific file name, Search using only a partial file name
DATA Search using a specific creation date, Search using a range of creation dates
DATA Search using a specific revision date, Search using a range of revision dates
DATA Search using only a specific version number
DATA Search through file description using a keyword
DATA Add an item to the index, Edit the item displayed
DATA Update the index using info located on a specified disk
DATA Send info to a specified disk to update another DWG-Filer
DATA Send current screen to the printer, Send all the current search results to the printer
DATA Print a complete listing in summary format, Print a complete listing with all details
DATA Select the number of DWG-Filer record entry forms to print
DATA Passes the PAGE FEED commmand to printer to eject a page
DATA Display how much resources DWG-Filer is using
DATA Display information about DWG-Filer's data file
DATA Choose from the Help index, Choose Help from the contents
DATA DWG-Filer version information, UWL contact information
'---------------------------------------------------------------------------
' Variable TYPE's...
'---------------------------------------------------------------------------
  TYPE DwgRecord
    RecNum AS INTEGER             ' Record# in 0 to 32766    EX: 1000
    FileName AS STRING * 8        ' 8 char. file name        EX: "WELDMENT"
    BuildDate AS STRING * 6       ' "     " creation date    EX: "010198"
    RevDate AS STRING * 6         ' "     " revision date    EX: "010198"
    Path AS STRING * 58           ' 49 char. Path & machine  EX: "C:\ACAD\"
    AcadRev AS INTEGER            ' ACAD revision in number  EX: 11
    Description AS STRING * 256   ' 256 character Description field
    DwgList AS STRING * 200       ' Up to 25 dwgs * 8 chars CONCATENATED
  END TYPE
  DIM SHARED All AS DwgRecord     ' Set it to "TYPE"
  
' ---------------------------------------------------------------------------
'                               MAIN PROGRAM
'---------------------------------------------------------------------------

PALETTE 5, 17                     'Replace some colors
PALETTE 6, 8

ON TIMER(20) GOSUB GetTime
ON ERROR GOTO ErrTrapper

SCREEN 0, , 0, 0                     'Set screen mode, page(0).

COLOR 11, 1                          'Colors first,
CLS                                  'Then clear the screen.
PRINT : PRINT : PRINT                'Space the Logo.
Logo                                 'Print the Logo.

LoadMenu                              'Load Menu Information. (Used once)

RegularMenu                             'Display the default Header.

TIMER ON

DO                                      'Start main loop.
  a$ = UCASE$(INKEY$)                   'Trap a key, and change to uppercase.
  KeyPressed = INP(96)                  'Trap a key by scancode.
  IF KeyPressed = 56 THEN               'If the scancode = 56,(Alt),then...

        Choice$ = SelectFromMenu$
        IF Choice$ = "1-1" THEN
                IF PromptQuit$ = "YES" THEN EXIT DO
        END IF
        IF Choice$ = "3-1" THEN CreateNew
        IF Choice$ = "3-2" THEN EditOne (CurrentIndex%)
        IF Choice$ = "7-5" THEN AboutUWL
        IF Choice$ = "7-4" THEN AboutDF
        IF Choice$ = "5-7" THEN PrintForms
        IF Choice$ = "2-1" THEN SearchBy 1
        IF Choice$ = "2-2" THEN SearchBy 2
        IF Choice$ = "2-4" THEN SearchBy 3
        IF Choice$ = "2-5" THEN SearchBy 4
        IF Choice$ = "2-7" THEN SearchBy 5
        IF Choice$ = "2-8" THEN SearchBy 6
        IF Choice$ = "2-10" THEN SearchBy 7
        IF Choice$ = "2-11" THEN SearchBy 8
        IF Choice$ = "2-13" THEN SearchBy 9
        IF Choice$ = "2-15" THEN SearchBy 10
        IF Choice$ = "6-1" THEN Resources 1
        IF Choice$ = "6-2" THEN Resources 2
        IF Choice$ = "5-1" THEN PrintOne
        IF Choice$ = "5-2" THEN InvalidOption
        IF Choice$ = "5-4" THEN PrintSummary
        IF Choice$ = "5-5" THEN PrintDetailed
        IF Choice$ = "5-9" THEN LPRINT CHR$(12);
        IF Choice$ = "7-1" THEN Help 1
        IF Choice$ = "7-2" THEN Help 2
        IF Choice$ = "4-1" THEN InvalidOption
        IF Choice$ = "4-2" THEN InvalidOption
  END IF
LOOP

RegularMenu              ' Returns to Page(0) and resets the menu.
Delay .3                 ' Delays program execution by 3/10ths of a second.
EndItNow:
COLOR 7, 0               ' Reset to DOS colors.  (Good programming practice).
CLS                      ' Cleanup
SYSTEM                   ' Exit to system if called from a batch file.
END                      ' Really not necessary after SYSTEM.

'---------------------------------------------------------------------------
GetTime:                 'Time display GoSub (called by ON TIMER)
ShowTime                 'Formatting SUB
RETURN
'---------------------------------------------------------------------------
ErrTrapper:
PCOPY 0, 2
SCREEN 0, , 2, 2

        SELECT CASE ERR
        CASE 27
                a$ = "Out of Paper. Make sure the paper is loaded and ready."
                b$ = "Press [Enter] to continue.  Press [ESC] to Cancel."
                MakePopUp 2, 58, "ERROR!", 28, 4
                COLOR 15, 4: Center 12, a$: Center 13, b$
                DO
                  a$ = INKEY$
                  IF a$ = CHR$(27) OR a$ = CHR$(13) THEN EXIT DO
                LOOP
                IF a$ = CHR$(27) THEN
                        ErrorContinue% = 1
                        SCREEN 0, , 1, 1
                        RESUME NEXT
                ELSE
                        ErrorContinue% = 0
                        SCREEN 0, , 1, 1
                        RESUME
                END IF

        CASE 24, 25, 57, 68
                a$ = "Printer not responding. Make sure the printer is ready."
                b$ = "Press [Enter] to continue.  Press [ESC] to Cancel."
                MakePopUp 2, 58, "ERROR!", 28, 4
                COLOR 15, 4: Center 12, a$: Center 13, b$
                DO
                  a$ = INKEY$
                  IF a$ = CHR$(27) OR a$ = CHR$(13) THEN EXIT DO
                LOOP
                IF a$ = CHR$(27) THEN
                        ErrorContinue% = 1
                        SCREEN 0, , 1, 1
                        RESUME NEXT
                ELSE
                        ErrorContinue% = 0
                        SCREEN 0, , 1, 1
                        RESUME
                END IF
        CASE 52, 53, 54, 55, 58, 59, 62, 63, 64, 67, 75, 76
                a$ = "File Error.  Make sure the support files are not corrupt,"
                b$ = "and in the same directory as DwgFiler. - Exiting program."
                MakePopUp 2, 58, "ERROR!", 28, 4
                COLOR 15, 4: Center 12, a$: Center 13, b$
                SLEEP 5
                RESUME EndItNow
        CASE 71
                a$ = "Disk not Ready.  Make sure the disk in the drive."
                b$ = "Press [Enter] to continue.  Press [ESC] to Cancel."
                MakePopUp 2, 58, "ERROR!", 28, 4
                COLOR 15, 4: Center 12, a$: Center 13, b$
                DO
                  a$ = INKEY$
                  IF a$ = CHR$(27) OR a$ = CHR$(13) THEN EXIT DO
                LOOP
                IF a$ = CHR$(27) THEN
                        ErrorContinue% = 1
                        SCREEN 0, , 1, 1
                        RESUME NEXT
                ELSE
                        ErrorContinue% = 0
                        SCREEN 0, , 1, 1
                        RESUME
                END IF
        CASE 61
                a$ = "Disk FULL.  If using removable media, replace and "
                b$ = "press [Enter] to continue.  Press [ESC] to Cancel."
                MakePopUp 2, 58, "ERROR!", 28, 4
                COLOR 15, 4: Center 12, a$: Center 13, b$
                DO
                  a$ = INKEY$
                  IF a$ = CHR$(27) OR a$ = CHR$(13) THEN EXIT DO
                LOOP
                IF a$ = CHR$(27) THEN
                        ErrorContinue% = 1
                        SCREEN 0, , 1, 1
                        RESUME NEXT
                ELSE
                        ErrorContinue% = 0
                        SCREEN 0, , 1, 1
                        RESUME
                END IF
        CASE 72
                a$ = "BAD Disk.   If using removable media, replace and "
                b$ = "press [Enter] to continue.  Press [ESC] to Cancel."
                MakePopUp 2, 58, "ERROR!", 28, 4
                COLOR 15, 4: Center 12, a$: Center 13, b$
                DO
                  a$ = INKEY$
                  IF a$ = CHR$(27) OR a$ = CHR$(13) THEN EXIT DO
                LOOP
                IF a$ = CHR$(27) THEN
                        ErrorContinue% = 1
                        SCREEN 0, , 1, 1
                        RESUME NEXT
                ELSE
                        ErrorContinue% = 0
                        SCREEN 0, , 1, 1
                        RESUME
                END IF
        CASE 70
                a$ = "Access Denied. If using removable media, unlock and"
                b$ = "press [Enter] to continue.   Press [ESC] to Cancel."
                MakePopUp 2, 58, "ERROR!", 28, 4
                COLOR 15, 4: Center 12, a$: Center 13, b$
                DO
                  a$ = INKEY$
                  IF a$ = CHR$(27) OR a$ = CHR$(13) THEN EXIT DO
                LOOP
                IF a$ = CHR$(27) THEN
                        ErrorContinue% = 1
                        SCREEN 0, , 1, 1
                        RESUME NEXT
                ELSE
                        ErrorContinue% = 0
                        SCREEN 0, , 1, 1
                        RESUME
                END IF
        CASE ELSE: GOTO ErrorEnd
        END SELECT


ErrorEnd:
TIMER OFF
MakePopUp 2, 58, "", 28, 4
COLOR 15, 4
a$ = "Non-Recoverble ERROR!   ErrorCode:" + STR$(ERR)
Center 12, a$
COLOR 14
Center 13, "If the problem persists, please contact UWLabs."
COLOR 31
Center 12, "ERROR!"
SLEEP 3
COLOR 7, 0
CLS
SYSTEM
END

'---------------------------------------------------------------------------
'
'  All menus built using UWL's MenuMaker version 1.0, a utility and
'  program structure base for building excellent DOS Menus!  This and
'  other great program utilities are available for UWL at our WEB Site.
'  Check out MenuMaker Pro, Doodler, and the color and screen utilites.
'    - Thanx!
'---------------------------------------------------------------------------

SUB AboutDF
'
' Displays the About Program PopUp
'
RestoreScreen

MakePopUp 8, 48, "About...", 8, 7
COLOR 1, 7
LOCATE 10, 20, 0: PRINT "ĿĿĿ   ҿĿ  Ŀ   ĿĿ "
COLOR 9
LOCATE 11, 20, 0: PRINT " Ĵ           1.O"
COLOR 1
LOCATE 12, 20, 0: PRINT "ٽ        ٽ"

COLOR 8
Center 13, "Release date: BETA ver"
COLOR 0
Center 14, "From UnderWARE Labs(c)"
COLOR 0
Center 16, "[ OK ]"
        
DO WHILE INKEY$ = ""
LOOP
       
COLOR 15, 0
Center 16, "[ OK ]"
Delay .2
OriginalScreen
END SUB

SUB AboutUWL
'
' Displays the about UWL PopUp
'
RestoreScreen
MakePopUp 16, 54, "About UWL", 11, 3
COLOR 0, 3
Center 6, "This program was created using QBasic(tm) 1.1 at..."
COLOR 15, 4
Center 8, " UnderWARE Labs(c)1998  "
COLOR 0, 3
LOCATE 8, 51: PRINT ""
LOCATE 9, 29: PRINT ""
COLOR 0, 3
Center 10, "Please register this program and all shareware."
Center 11, "Send comments, suggestions, and registration to:"
COLOR 15
Center 13, "UnderWARE Labs"
Center 14, "c/o L. Schramm"
Center 15, "2500 Goble Road"
Center 16, "Hiddenite, NC 28636"
COLOR 14
Center 18, "Email: uwlabs@aol.com"
COLOR 0
Center 20, "[ OK ]"
DO WHILE INKEY$ = ""
LOOP
COLOR 15, 0
Center 20, "[ OK ]"
Delay .2
OriginalScreen
END SUB

SUB AddToList (t%)
'
' t% is to flag whether to use the current list or create a new one.
' 1 = NEW       NOT 1 = Use Current
'
PCOPY 1, 2
SCREEN 0, , 2, 2

TIMER OFF
DIM Temp$(25)
FOR i% = 1 TO 25
        IF t% <> 1 THEN Temp$(i%) = MID$(All.DwgList, (i% * 8) - 7, 8)
        IF Temp$(i%) <= "        " THEN Temp$(i%) = "        "
NEXT i%
COLOR 14, 3
LOCATE 25, 21, 0: PRINT STRING$(58, 32);
LOCATE 25, 21, 0: PRINT "Edit associated file list...";

MakePopUp 9, 65, "Associated Files ", 14, 5
c% = 0
b$ = "##) \      \"
COLOR 15, 5
FOR t% = 8 TO 62 STEP 13
   FOR i% = 10 TO 14
      c% = c% + 1
      LOCATE i%, t%, 0: PRINT USING b$; c%; Temp$(c%)
   NEXT i%
NEXT t%

Center 16, "[Enter]=Edit/Accept   [F2]=Go Back/Retain Changes  "
Center 17, "[Esc]=Restore         [F4]=Go Back/Restore Previous"

row% = 10: col% = 12: i% = 1
LOCATE row%, col%, 1
DO
    a$ = INKEY$
    IF a$ = CHR$(0) + CHR$(62) THEN EXIT DO  '[F4]
    IF a$ = CHR$(0) + CHR$(60) THEN          '[F2]
          a$ = ""
          FOR i% = 1 TO 25
             IF Temp$(i%) <> "        " THEN a$ = a$ + Temp$(i%) + STRING$(8 - LEN(Temp$(i%)), " ")
          NEXT i%
        All.DwgList = a$
        EXIT DO
    END IF
    IF a$ = CHR$(9) THEN
        col% = col% + 13
        IF col% > 64 AND row% < 14 THEN col% = 12: row% = row% + 1
        IF col% > 64 AND row% = 14 THEN col% = 64
        LOCATE row%, col%
    END IF
    IF a$ = CHR$(0) + CHR$(80) THEN  'dwn
        row% = row% + 1
        IF row% > 14 THEN row% = 14
        LOCATE row%, col%
    END IF
    IF a$ = CHR$(0) + CHR$(72) THEN  'up
        row% = row% - 1
        IF row% < 10 THEN row% = 10
        LOCATE row%, col%
    END IF
    IF a$ = CHR$(0) + CHR$(75) THEN  'lft
        col% = col% - 13
        IF col% < 10 THEN col% = 12
        LOCATE row%, col%
    END IF
    IF a$ = CHR$(0) + CHR$(77) THEN  'rgt
        col% = col% + 13
        IF col% > 64 THEN col% = 64
        LOCATE row%, col%
    END IF
    IF a$ = CHR$(13) THEN
        i% = ((POS(1) MOD 12) * 5) + (CSRLIN - 9)
        COLOR 15, 0
        Temp$(i%) = GetInput$(row%, col%, 8, Temp$(i%))
        COLOR 15, 5
        LOCATE row%, col%: PRINT STRING$(8, " ")
        LOCATE row%, col%: PRINT Temp$(i%)
        LOCATE row%, col%
    END IF

LOOP

 SCREEN 0, , 1, 1
 TIMER ON

END SUB

SUB Center (y%, Text$)
   '
   ' Centers "Text$" on a 80-wide screen.
   '
   x% = 40 - INT((LEN(Text$) / 2))
   LOCATE y%, x%, 0
   PRINT Text$;
END SUB

FUNCTION CheckDate% (BeginDate$, EndDate$, DateToCheck$)

' Function to compare dates and see if the DateToCheck$ falls
' between the BeginDate$ and EndDate$.  Will also swap the
' beginning date and ending date if they were accidentally entered
' in reverse.

CY% = VAL(RIGHT$(DateToCheck$, 2))
CD% = VAL(MID$(DateToCheck$, 3, 2))
CM% = VAL(LEFT$(DateToCheck$, 2))
CC! = (CY% * 100) + CM% + (CD% / 100)

BY% = VAL(RIGHT$(BeginDate$, 2))
BD% = VAL(MID$(BeginDate$, 3, 2))
BM% = VAL(LEFT$(BeginDate$, 2))
BB! = (BY% * 100) + BM% + (BD% / 100)

EY% = VAL(RIGHT$(EndDate$, 2))
ED% = VAL(MID$(EndDate$, 3, 2))
EM% = VAL(LEFT$(EndDate$, 2))
EE! = (EY% * 100) + EM% + (ED% / 100)


IF EE! < BB! THEN SWAP EE!, BB!

IF CC! >= BB! AND CC! <= EE! THEN CheckDate% = 1 ELSE CheckDate% = 0

END FUNCTION

SUB Chirp
'
'  Used to replace the BEEP statement.(It's faster)
'
SOUND 200, .1
SOUND 2000, .1
SOUND 400, .05
END SUB

SUB CreateNew
'
' PopUp the Create new file
'
TIMER OFF
Added% = 0
RestoreScreen
COLOR 14, 3
LOCATE 25, 21, 0: PRINT STRING$(58, 32);
LOCATE 25, 21, 0: PRINT "Create a new record...";

MakePopUp 14, 66, "Create New ", 11, 3

   i% = 0
   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
        IF ErrorContinue% = 1 THEN
           ErrorContinue% = 0
           GOTO NearCREnd
           END IF
   DO WHILE NOT EOF(1)
        i% = i% + 1
        GET #1, i%, All
   LOOP
   CLOSE #1
   NewRecNum = i%
   b$ = LTRIM$(RTRIM$(STR$(NewRecNum)))
   NewRec$ = STRING$(5 - LEN(b$), "0") + b$

COLOR 15, 3
Center 18, "[Enter]=Edit/Accept   [F1]=Accept Description   [Esc]=Restore "
Center 19, "[F2]=Save   [F3]=Create associated drawings list    [F4]=Exit "
Center 7, "Index#:               FileName:        ACAD ver:      "
Center 8, "Date:    //     Revision:   //     No. Of Files:  "
LOCATE 10, 8, 0: PRINT "Path: "
LOCATE 12, 8, 0
PRINT "Description:"
COLOR 15, 7
LOCATE 7, 20, 0: PRINT NewRec$
LOCATE 7, 42, 0: PRINT "        "
LOCATE 7, 70, 0: PRINT "  "
Created1$ = LEFT$(DATE$, 2): Created2$ = MID$(DATE$, 4, 2): Created3$ = RIGHT$(DATE$, 2)
LOCATE 8, 17, 0: PRINT Created1$: LOCATE 8, 20: PRINT Created2$: LOCATE 8, 23: PRINT Created3$
LOCATE 8, 42, 0: PRINT "  ": LOCATE 8, 45: PRINT "  ": LOCATE 8, 48: PRINT "  "
LOCATE 8, 70, 0: PRINT "  "
LOCATE 10, 14, 0: PRINT STRING$(58, " ")
LOCATE 13, 8, 0: PRINT STRING$(64, " ")
LOCATE 14, 8, 0: PRINT STRING$(64, " ")
LOCATE 15, 8, 0: PRINT STRING$(64, " ")
LOCATE 16, 8, 0: PRINT STRING$(64, " ")

TheTop:

COLOR 15, 7
t% = 1: l% = 7
i% = 1: k% = 42
LOCATE , , 0
LOCATE , , 1
GOSUB SelectField
DO
 a$ = INKEY$
 IF a$ <> "" THEN
    SELECT CASE a$
    CASE CHR$(0) + CHR$(60)          ' F2 (Save)
        PCOPY 1, 2
        SCREEN 0, , 2, 2
        MakePopUp 3, 22, "Save", 9, 5
        COLOR 14, 5
        Center 13, "Updating Records..."
        GOSUB SaveRecord
        Delay 1
        SCREEN 0, , 1, 1
        EXIT DO
    CASE CHR$(0) + CHR$(61)          ' F3 (Asso list)
           IF Added% <> 1 THEN
                AddToList 1
                Added% = 1
                ELSE AddToList 0
           END IF
    CASE CHR$(0) + CHR$(62)          ' F4 (Exit)
         EXIT DO
    CASE CHR$(0) + CHR$(72)
         IF t% = 1 THEN t% = 1
         IF t% = 2 AND i% > 2 THEN i% = 2: t% = 1
         IF t% = 2 AND i% <= 2 THEN t% = t% - 1
         IF t% = 4 OR t% = 3 THEN t% = t% - 1
         GOSUB SelectField         ' Up arrow
    CASE CHR$(0) + CHR$(80)
         IF t% = 2 THEN i% = 1: t% = 0
         IF t% = 1 OR t% = 3 THEN t% = t% + 1
         IF t% = 0 THEN t% = 3
         GOSUB SelectField         ' Down arrow
    CASE CHR$(0) + CHR$(75)
         IF i% < 2 THEN i% = 1 ELSE i% = i% - 1
         GOSUB SelectField         ' Left arrow
    CASE CHR$(0) + CHR$(77)
         IF t% = 1 AND i% < 2 THEN i% = i% + 1
         IF t% = 2 AND i% < 6 THEN i% = i% + 1
         GOSUB SelectField         ' Right arrow
    CASE CHR$(9)
         IF t% = 4 THEN t% = 1: i% = 0
         IF t% = 3 THEN t% = 4: i% = 0
         IF t% = 2 AND i% = 6 THEN t% = 3: i% = 0
         IF t% = 2 AND i% < 6 THEN i% = i% + 1
         IF t% = 1 AND i% = 2 THEN t% = 2: i% = 0
         IF t% = 1 AND i% = 1 THEN i% = 2
         IF i% = 0 THEN i% = 1
         GOSUB SelectField                      ' Tab
    CASE CHR$(13)                               ' Enter
        GOSUB EnterInfo
        GOSUB SelectField
    END SELECT
 END IF
LOOP

GOTO NearCREnd

SelectField:
        
        IF t% = 1 AND i% = 1 THEN l% = 7: k% = 42
        IF t% = 1 AND i% = 2 THEN l% = 7: k% = 70
        IF t% = 2 AND i% = 1 THEN l% = 8: k% = 17
        IF t% = 2 AND i% = 2 THEN l% = 8: k% = 20
        IF t% = 2 AND i% = 3 THEN l% = 8: k% = 23
        IF t% = 2 AND i% = 4 THEN l% = 8: k% = 42
        IF t% = 2 AND i% = 5 THEN l% = 8: k% = 45
        IF t% = 2 AND i% = 6 THEN l% = 8: k% = 48
        IF t% = 3 THEN l% = 10: k% = 14
        IF t% = 4 THEN l% = 13: k% = 8

        LOCATE l%, k%, 1, 0, 31

RETURN

EnterInfo:
COLOR 15, 0
IF t% = 1 THEN
    IF i% = 1 THEN
        FileName$ = GetInput$(7, 42, 8, FileName$)
        COLOR 15, 7: LOCATE 7, 42: PRINT FileName$; STRING$(8 - LEN(FileName$), " ")
                a$ = FileName$
                OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
                        IF ErrorContinue% = 1 THEN
                        ErrorContinue% = 0
                        GOTO NearCREnd
                        END IF
                i% = 0: a$ = UCASE$(a$ + STRING$(8 - LEN(a$), 32))
                DO WHILE NOT EOF(1)
                i% = i% + 1
                GET #1, i%, All
                IF UCASE$(All.FileName) = a$ THEN
                Chirp
                Chirp
                PCOPY 1, 2
                SCREEN 0, , 2, 2
                MakePopUp 4, 40, "Attention!", 7, 6
                COLOR 7, 6
                Center 12, "That record already exists!  Continue?"
                COLOR 7, 6
                LOCATE 14, 28, 0: PRINT "  [ Yes ]   [ Cancel ] "
                COLOR 15
                LOCATE 14, 32, 0: PRINT "Y"
                LOCATE 14, 42, 0: PRINT "C"
                a$ = INPUT$(1)
                SCREEN 0, , 1, 1: CLOSE #1
                IF UCASE$(a$) <> "Y" THEN
                        FileName$ = "        "
                        COLOR 15, 7: LOCATE 7, 42: PRINT FileName$
                        GOTO TheTop
                ELSE
                        t% = 1: l% = 7
                        i% = 2: k% = 70
                        RETURN
                END IF
                END IF
                LOOP
                CLOSE #1
        LOCATE 7, 42
        i% = 2
        RETURN
        END IF
    IF i% = 2 THEN CadVer$ = GetInput$(7, 70, 2, CadVer$): COLOR 15, 7: LOCATE 7, 70: PRINT CadVer$; STRING$(2 - LEN(CadVer$), " "): LOCATE 7, 70: t% = 2: i% = 1: RETURN
END IF
IF t% = 2 THEN
    IF i% = 1 THEN Created1$ = GetInput$(8, 17, 2, Created1$): COLOR 15, 7: LOCATE 8, 17: PRINT Created1$; STRING$(2 - LEN(Created1$), " "): LOCATE 8, 17:  i% = 2: RETURN
    IF i% = 2 THEN Created2$ = GetInput$(8, 20, 2, Created2$): COLOR 15, 7: LOCATE 8, 20: PRINT Created2$; STRING$(2 - LEN(Created2$), " "): LOCATE 8, 20: i% = 3: RETURN
    IF i% = 3 THEN Created3$ = GetInput$(8, 23, 2, Created3$): COLOR 15, 7: LOCATE 8, 23: PRINT Created3$; STRING$(2 - LEN(Created3$), " "): LOCATE 8, 23: i% = 4: RETURN
    IF i% = 4 THEN Rev1$ = GetInput$(8, 42, 2, Rev1$): COLOR 15, 7: LOCATE 8, 42: PRINT Rev1$; STRING$(2 - LEN(Rev1$), " "): LOCATE 7, 42: i% = 5: RETURN
    IF i% = 5 THEN Rev2$ = GetInput$(8, 45, 2, Rev2$): COLOR 15, 7: LOCATE 8, 45: PRINT Rev2$; STRING$(2 - LEN(Rev2$), " "): LOCATE 7, 45: i% = 6: RETURN
    IF i% = 6 THEN Rev3$ = GetInput$(8, 48, 2, Rev3$): COLOR 15, 7: LOCATE 8, 48: PRINT Rev3$; STRING$(2 - LEN(Rev3$), " "): LOCATE 7, 48: t% = 3: i% = 1: RETURN
    
END IF
IF t% = 3 THEN Path$ = GetInput$(10, 14, 58, Path$): COLOR 15, 7: LOCATE 10, 14: PRINT Path$; STRING$(58 - LEN(Path$), " "): LOCATE 10, 14: t% = 4: i% = 1: RETURN
IF t% = 4 THEN
        COLOR 15, 0
        Description$ = TextDialog$(13, 8, 16, 72, Description$)
        COLOR 15, 7
        c% = 12
        FOR i% = 1 TO 256 STEP 64
           c% = c% + 1
           LOCATE c%, 8: PRINT STRING$(64, " ")
           LOCATE c%, 8: PRINT MID$(Description$, i%, 64)
        NEXT i%
END IF
COLOR 15, 7
RETURN

SaveRecord:
                All.RecNum = NewRecNum
                All.FileName = FileName$
                All.BuildDate = Created1$ + Created2$ + Created3$
                All.RevDate = Rev1$ + Rev2$ + Rev3$
                All.Path = Path$
                All.Description = Description$
                All.AcadRev = VAL(CadVer$)
   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
        IF ErrorContinue% = 1 THEN
           ErrorContinue% = 0
           GOTO NearCREnd
           END IF
   PUT #1, NewRecNum, All
   CLOSE #1
   CurrentIndex% = NewRecNum
RETURN

NearCREnd:
LOCATE , , 0

OriginalScreen
DisplayRecord CurrentIndex%
TIMER ON
END SUB

SUB Delay (Amt!)
        '
        ' Delays program the fractional Amt! of seconds
        ' NOTE: This will wait 24 HOURS! if used at exactly 12:00am.
        '
        t! = TIMER + Amt!
        DO WHILE TIMER < t!
        LOOP
END SUB

SUB DisplayRecord (i%)

' Opens the record and displays it.
' All.RecNum is the complete record type...
'
   CLOSE
   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
        IF ErrorContinue% = 1 THEN
           ErrorContinue% = 0
           EXIT SUB
           END IF
   Highest% = LOF(1) / LEN(All)
   CLOSE #1

IF i% = 0 OR i% > Highest% THEN
        COLOR 7, 1
        FOR x% = 3 TO 22
        LOCATE x%, 1: PRINT STRING$(80, " ")
        NEXT x%
        CurrentIndex% = 0
        EXIT SUB
END IF

   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
        IF ErrorContinue% = 1 THEN
           ErrorContinue% = 0
           EXIT SUB
           END IF
   GET #1, i%, All
   CLOSE #1
   FOR i% = 1 TO 200 STEP 8
        a$ = MID$(All.DwgList, i%, 8)
        FOR t% = 1 TO 8
           IF ASC(MID$(a$, t%, 1)) > 32 THEN EXIT FOR
        NEXT t%
        IF t% > 8 THEN EXIT FOR
   NEXT i%
NumAsso$ = LTRIM$(STR$(INT(i% / 8)))
'
COLOR 7, 1
LOCATE 3, 4: PRINT "Index#:    "; LTRIM$(STR$(All.RecNum))
LOCATE 3, 28: PRINT "FileName:     "; All.FileName
LOCATE 3, 56: PRINT "ACAD ver:        "; LTRIM$(STR$(All.AcadRev))

LOCATE 5, 4: PRINT "Created:   "; All.BuildDate
LOCATE 5, 28: PRINT "Last Revised: "; All.RevDate
LOCATE 5, 56: PRINT "Number of Files: "; NumAsso$

LOCATE 7, 4: PRINT "Path:      "; All.Path

LOCATE 9, 4: PRINT "Description:"

LOCATE 11, 8, 0: PRINT LEFT$(All.Description, 64)
LOCATE 12, 8, 0: PRINT MID$(All.Description, 65, 64)
LOCATE 13, 8, 0: PRINT MID$(All.Description, 129, 64)
LOCATE 14, 8, 0: PRINT RIGHT$(All.Description, 64)
LOCATE 16, 4: PRINT "Associated File Names:"
c% = 0: t% = 18
FOR i% = 1 TO 25
   c% = c% + 12
   IF c% > 68 THEN c% = 12: t% = t% + 1
   a$ = MID$(All.DwgList, (i% * 8) - 7, 8)
   IF a$ <= "        " THEN a$ = "........"
   LOCATE t%, c%
   PRINT a$;
NEXT i%

 CurrentIndex% = All.RecNum
'
END SUB

SUB EditOne (OneToEdit%)
'
'  Opens a record for editting.
'
'
TIMER OFF
RestoreScreen
COLOR 14, 3
LOCATE 25, 21, 0: PRINT STRING$(58, 32);
LOCATE 25, 21, 0: PRINT "Editing a record...";
  
   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
        IF ErrorContinue% = 1 THEN
           ErrorContinue% = 0
           GOTO NearEDEnd
           END IF
   Highest% = LOF(1) / LEN(All)
   CLOSE #1


IF OneToEdit% < 1 OR OneToEdit% > Highest% THEN
  MakePopUp 1, 20, "", 14, 3
  COLOR 15, 3
  Center 13, "No Record Selected"
  Chirp
  SLEEP 3
  GOTO NearEDEnd
END IF

MakePopUp 14, 66, "Edit A Record", 11, 3

   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
        IF ErrorContinue% = 1 THEN
           ErrorContinue% = 0
           GOTO NearEDEnd
           END IF
   GET #1, OneToEdit%, All
   CLOSE #1
   NewRecNum = All.RecNum
   b$ = LTRIM$(RTRIM$(STR$(NewRecNum)))
   NewRec$ = STRING$(5 - LEN(b$), "0") + b$

COLOR 15, 3
Center 18, "[Enter]=Edit/Accept   [F1]=Accept Description   [Esc]=Restore "
Center 19, "[F2]=Save    [F3]=Edit associated drawings list     [F4]=Exit "
Center 7, "Index#:               FileName:        ACAD ver:      "
Center 8, "Date:    //     Revision:   //     No. Of Files:  "
LOCATE 10, 8, 0: PRINT "Path: "
LOCATE 12, 8, 0
PRINT "Description:"
COLOR 15, 7
LOCATE 7, 20, 0: PRINT NewRec$
LOCATE 7, 42, 0: PRINT All.FileName
LOCATE 7, 70, 0: PRINT LTRIM$(STR$(All.AcadRev))
Created1$ = LEFT$(All.BuildDate, 2): Created2$ = MID$(All.BuildDate, 3, 2): Created3$ = RIGHT$(All.BuildDate, 2)
LOCATE 8, 17, 0: PRINT Created1$: LOCATE 8, 20: PRINT Created2$: LOCATE 8, 23: PRINT Created3$
Rev1$ = LEFT$(All.RevDate, 2): Rev2$ = MID$(All.RevDate, 3, 2): Rev3$ = RIGHT$(All.RevDate, 2)
LOCATE 8, 42, 0: PRINT Rev1$: LOCATE 8, 45: PRINT Rev2$: LOCATE 8, 48: PRINT Rev3$

LOCATE 10, 14, 0: PRINT STRING$(58, " ")
LOCATE 10, 14, 0: PRINT All.Path
LOCATE 13, 8, 0: PRINT LEFT$(All.Description, 64)
LOCATE 14, 8, 0: PRINT MID$(All.Description, 65, 64)
LOCATE 15, 8, 0: PRINT MID$(All.Description, 129, 64)
LOCATE 16, 8, 0: PRINT RIGHT$(All.Description, 64)

FOR i% = 1 TO 200 STEP 8
        a$ = MID$(All.DwgList, i%, 8)
        FOR t% = 1 TO 8
           IF ASC(MID$(a$, t%, 1)) > 32 THEN EXIT FOR
        NEXT t%
        IF t% > 8 THEN EXIT FOR
NEXT i%
NumAsso$ = LTRIM$(STR$(INT(i% / 8)))
LOCATE 8, 70, 0: PRINT NumAsso$

COLOR 15, 7
t% = 1: l% = 7
i% = 1: k% = 42
LOCATE , , 0
LOCATE , , 1
GOSUB EDSelectField
DO
 a$ = INKEY$
 IF a$ <> "" THEN
    SELECT CASE a$
    CASE CHR$(0) + CHR$(60)          ' F2
        PCOPY 1, 2
        SCREEN 0, , 2, 2
        MakePopUp 3, 22, "Save", 9, 5
        COLOR 14, 5
        Center 13, "Updating Records..."
        GOSUB SaveEdit
        Delay 1
        SCREEN 0, , 1, 1
        EXIT DO
    CASE CHR$(0) + CHR$(61)          ' F3 (Asso list)
           AddToList 0
    CASE CHR$(0) + CHR$(62)          ' F4
        EXIT DO
    CASE CHR$(0) + CHR$(72)
         IF t% = 1 THEN t% = 1
         IF t% = 2 AND i% > 2 THEN i% = 2: t% = 1
         IF t% = 2 AND i% <= 2 THEN t% = t% - 1
         IF t% = 4 OR t% = 3 THEN t% = t% - 1
         GOSUB EDSelectField         ' Up arrow
    CASE CHR$(0) + CHR$(80)
         IF t% = 2 THEN i% = 1: t% = 0
         IF t% = 1 OR t% = 3 THEN t% = t% + 1
         IF t% = 0 THEN t% = 3
         GOSUB EDSelectField         ' Down arrow
    CASE CHR$(0) + CHR$(75)
         IF i% < 2 THEN i% = 1 ELSE i% = i% - 1
         GOSUB EDSelectField         ' Left arrow
    CASE CHR$(0) + CHR$(77)
         IF t% = 1 AND i% < 2 THEN i% = i% + 1
         IF t% = 2 AND i% < 6 THEN i% = i% + 1
         GOSUB EDSelectField         ' Right arrow
    CASE CHR$(9)
         IF t% = 4 THEN t% = 1: i% = 0
         IF t% = 3 THEN t% = 4: i% = 0
         IF t% = 2 AND i% = 6 THEN t% = 3: i% = 0
         IF t% = 2 AND i% < 6 THEN i% = i% + 1
         IF t% = 1 AND i% = 2 THEN t% = 2: i% = 0
         IF t% = 1 AND i% = 1 THEN i% = 2
         IF i% = 0 THEN i% = 1
         GOSUB EDSelectField                    ' Tab
    CASE CHR$(13)                               ' Enter
        GOSUB EDEnterInfo
        GOSUB EDSelectField
    END SELECT
 END IF
LOOP

GOTO NearEDEnd

EDSelectField:
       
        IF t% = 1 AND i% = 1 THEN l% = 7: k% = 42
        IF t% = 1 AND i% = 2 THEN l% = 7: k% = 70
        IF t% = 2 AND i% = 1 THEN l% = 8: k% = 17
        IF t% = 2 AND i% = 2 THEN l% = 8: k% = 20
        IF t% = 2 AND i% = 3 THEN l% = 8: k% = 23
        IF t% = 2 AND i% = 4 THEN l% = 8: k% = 42
        IF t% = 2 AND i% = 5 THEN l% = 8: k% = 45
        IF t% = 2 AND i% = 6 THEN l% = 8: k% = 48
        IF t% = 3 THEN l% = 10: k% = 14
        IF t% = 4 THEN l% = 13: k% = 8

        LOCATE l%, k%, 1, 0, 31

RETURN
SaveEdit:
                All.RecNum = OneToEdit%
                All.BuildDate = Created1$ + Created2$ + Created3$
                All.RevDate = Rev1$ + Rev2$ + Rev3$
   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
        IF ErrorContinue% = 1 THEN
           ErrorContinue% = 0
           GOTO NearEDEnd
           END IF
   PUT #1, OneToEdit%, All
   CLOSE #1
   CurrentIndex% = NewRecNum
RETURN

EDEnterInfo:
COLOR 15, 0
IF t% = 1 THEN
    IF i% = 1 THEN All.FileName = GetInput$(7, 42, 8, RTRIM$(All.FileName)): COLOR 15, 7: LOCATE 7, 42: PRINT All.FileName; STRING$(8 - LEN(All.FileName), " "): LOCATE 7, 42: i% = 2: RETURN
    IF i% = 2 THEN All.AcadRev = VAL(GetInput$(7, 70, 2, LTRIM$(STR$(All.AcadRev)))): COLOR 15, 7: LOCATE 7, 70: PRINT LTRIM$(STR$(All.AcadRev)) + STRING$(2 - LEN(LTRIM$(STR$(All.AcadRev))), " "): LOCATE 7, 70: t% = 2: i% = 1: RETURN
END IF
IF t% = 2 THEN
    IF i% = 1 THEN Created1$ = GetInput$(8, 17, 2, Created1$): COLOR 15, 7: LOCATE 8, 17: PRINT Created1$; STRING$(2 - LEN(Created1$), " "): LOCATE 8, 17:  i% = 2: RETURN
    IF i% = 2 THEN Created2$ = GetInput$(8, 20, 2, Created2$): COLOR 15, 7: LOCATE 8, 20: PRINT Created2$; STRING$(2 - LEN(Created2$), " "): LOCATE 8, 20: i% = 3: RETURN
    IF i% = 3 THEN Created3$ = GetInput$(8, 23, 2, Created3$): COLOR 15, 7: LOCATE 8, 23: PRINT Created3$; STRING$(2 - LEN(Created3$), " "): LOCATE 8, 23: i% = 4: RETURN
    IF i% = 4 THEN Rev1$ = GetInput$(8, 42, 2, Rev1$): COLOR 15, 7: LOCATE 8, 42: PRINT Rev1$; STRING$(2 - LEN(Rev1$), " "): LOCATE 7, 42: i% = 5: RETURN
    IF i% = 5 THEN Rev2$ = GetInput$(8, 45, 2, Rev2$): COLOR 15, 7: LOCATE 8, 45: PRINT Rev2$; STRING$(2 - LEN(Rev2$), " "): LOCATE 7, 45: i% = 6: RETURN
    IF i% = 6 THEN Rev3$ = GetInput$(8, 48, 2, Rev3$): COLOR 15, 7: LOCATE 8, 48: PRINT Rev3$; STRING$(2 - LEN(Rev3$), " "): LOCATE 7, 48: t% = 3: i% = 1: RETURN

END IF
IF t% = 3 THEN All.Path = GetInput$(10, 14, 58, RTRIM$(All.Path)): COLOR 15, 7: LOCATE 10, 14: PRINT All.Path; STRING$(58 - LEN(All.Path), " "): LOCATE 10, 14: t% = 4: i% = 1: RETURN
IF t% = 4 THEN
        COLOR 15, 0
        All.Description = TextDialog$(13, 8, 16, 72, RTRIM$(All.Description))
        COLOR 15, 7
        c% = 12
        FOR i% = 1 TO 256 STEP 64
           c% = c% + 1
           LOCATE c%, 8: PRINT STRING$(64, " ")
           LOCATE c%, 8: PRINT MID$(All.Description, i%, 64)
        NEXT i%
END IF
COLOR 15, 7
RETURN

NearEDEnd:
LOCATE , , 0
OriginalScreen
IF OneToEdit% > 0 OR OneToEdit% < Highest% THEN DisplayRecord OneToEdit%
TIMER ON
END SUB

DEFINT A-Z
FUNCTION GetInput$ (Rpos%, Cpos%, Length%, RestoreText$)
'
' Function to replace the INPUT statement.
'   Locates and determines the length of the required input also.
'
' Syntax:
'               Text$ = GetInput$(Rpos, Cpos%, Length% RestoreText$)
'
' Where:
'  Text$ = is the string returned. ""(nul) if [Esc] is pressed.
'  Rpos% = Row position typing begins.
'  Cpos% = Column position typing begins.
'  Length% = The number of characters to be entered. (Maximum 79 characters).
'  RestoreText$ = The default info for the field. (For restoring field).
'
'
  col% = Cpos%
  row% = Rpos%
LOCATE row, col%: PRINT STRING$(Length%, " ")
LOCATE row, col%, 1, 0, 31
InsertMode = 0
Text$ = RestoreText$
GOSUB SelEnd
     DO
        t$ = INKEY$
        IF t$ = CHR$(13) THEN EXIT DO
         IF t$ = CHR$(27) THEN
              Text$ = RestoreText$
              EXIT DO
         END IF
        IF t$ <> "" THEN GOSUB CheckKeys
     LOOP

GOTO NearTheBottom
'- - - - - - - - - - - - - - -  - - - - - -
CheckKeys:
   SELECT CASE t$
        CASE CHR$(8)
                IF col% >= Cpos% + LEN(Text$) THEN
                  IF LEN(Text$) = 1 THEN
                     Text$ = "": col% = Cpos%
                     GOTO SelEnd
                  END IF
                  IF col% = Cpos% THEN RETURN
                  Text$ = LEFT$(Text$, (LEN(Text$) - 1))
                  col% = col% - 1
                END IF
                IF col% < Cpos% + LEN(Text$) THEN
                  IF col% = Cpos% THEN RETURN
                  LText$ = LEFT$(Text$, (col% - Cpos%) - 1)
                  RText$ = RIGHT$(Text$, (LEN(Text$) + Cpos%) - col%)
                  Text$ = LText$ + RText$
                  col% = col% - 1
                END IF
        CASE CHR$(9)
Chirp: RETURN
        CASE CHR$(0) + CHR$(82)
                IF InsertMode = 1 THEN InsertMode = 0: GOTO SelEnd
                IF InsertMode = 0 THEN InsertMode = 1: GOTO SelEnd
        CASE CHR$(0) + CHR$(71)
                FOR q = 1 TO Length%
                    FirstLtr = INSTR(q, Text$, " ")
                    IF FirstLtr <> q THEN EXIT FOR
                    StartPos = FirstLtr
                NEXT
                col% = StartPos + Cpos%
        CASE CHR$(0) + CHR$(83)
                IF col% >= Cpos% + LEN(Text$) THEN RETURN
                IF col% = Cpos% THEN
                    Text$ = RIGHT$(Text$, LEN(Text$) - 1)
                    GOTO SelEnd
                END IF
                LText$ = LEFT$(Text$, (col% - Cpos%))
                RText$ = RIGHT$(Text$, (LEN(Text$) + Cpos%) - col% - 1)
                Text$ = LText$ + RText$
                IF LEN(Text$) > Length% THEN Text$ = LEFT$(Text$, Length%)
        CASE CHR$(0) + CHR$(79)
                col% = Cpos% + LEN(Text$)
        CASE CHR$(0) + CHR$(75)
                IF col% > Cpos% THEN col% = col% - 1
        CASE CHR$(0) + CHR$(77)
                IF col% < Cpos% + Length% THEN col% = col% + 1
        CASE ELSE
           IF LEN(t$) > 1 THEN Chirp: RETURN
           IF col% >= Cpos% + LEN(Text$) THEN
                col% = col% + 1
                IF col% > Cpos% + Length% THEN col% = col% - 1: RETURN
                Text$ = Text$ + t$
           END IF
           IF col% < Cpos% + LEN(Text$) THEN
                IF InsertMode = 1 THEN
                     LText$ = LEFT$(Text$, (col% - Cpos%))
                     RText$ = RIGHT$(Text$, (LEN(Text$) + Cpos%) - col%)
                     Text$ = LText$ + t$ + RText$
                     IF LEN(Text$) > Length% THEN Text$ = LEFT$(Text$, Length%)
                     col% = col% + 1
                END IF
                IF InsertMode = 0 THEN
                     LText$ = LEFT$(Text$, (col% - Cpos%))
                     RText$ = RIGHT$(Text$, (LEN(Text$) + Cpos%) - col% - 1)
                     Text$ = LText$ + t$ + RText$
                     IF LEN(Text$) > Length% THEN Text$ = LEFT$(Text$, Length%)
                     col% = col% + 1
                END IF
           END IF
   END SELECT
SelEnd:
   x = Length% - LEN(Text$)
        IF x < 0 THEN x = 0
   LOCATE Rpos%, Cpos%, 0: PRINT Text$; STRING$(x, " ")
        IF InsertMode = 0 THEN LOCATE row, col%, 1, 0, 31
        IF InsertMode = 1 THEN LOCATE row, col%, 1, 29, 31
RETURN
'----------------------------------------------------------
NearTheBottom:
GetInput$ = Text$

END FUNCTION

DEFSNG A-Z
SUB Help (i%)

'  Opens the help file and allows the user to browse it.
'

TIMER OFF
RestoreScreen
MakePopUp 18, 70, "Help", 11, 3

COLOR 11, 3
Center 21, "[" + CHR$(27) + CHR$(24) + CHR$(25) + CHR$(26) + "] = Select     [Enter] = Accept     [Esc] = Cancel"

COLOR 15, 3
IF i% = 1 THEN GOTO ContentsHelp
IF i% = 2 THEN GOTO IndexHelp
ContentsHelp:

     DIM Tmp$(24)
     OPEN "FILRHELP.TXT" FOR INPUT AS #1
      FOR x% = 1 TO 24
        INPUT #1, Tmp$(x%)
      NEXT x%
     CLOSE
  
  FOR i% = 0 TO 11
  LOCATE i% + 6, 10: PRINT MID$(Tmp$(i%), 2)
  NEXT i%
  FOR i% = 12 TO 23
  LOCATE i% - 5, 42: PRINT MID$(Tmp$(i%), 2)
  NEXT i%

        PCOPY 1, 2
        SCREEN 0, , 2, 2
        
  i% = 1: d% = 7: e% = 8
  GOSUB DisplayCursor

  DO
  a$ = INKEY$
  IF a$ <> "" THEN
  IF a$ = CHR$(13) THEN GOSUB ChooseIt
  
  IF a$ = CHR$(27) THEN EXIT DO
    IF i% < 22 AND a$ = CHR$(0) + CHR$(80) THEN i% = i% + 1
    IF i% > 1 AND a$ = CHR$(0) + CHR$(72) THEN i% = i% - 1
    IF i% >= 12 AND a$ = CHR$(0) + CHR$(75) THEN i% = i% - 11
    IF i% <= 11 AND a$ = CHR$(0) + CHR$(77) THEN i% = i% + 11
    GOSUB DisplayCursor
    a$ = ""
  END IF
  LOOP


GOTO EndHelpSub
IndexHelp:

     LOCATE 6, 10: PRINT "[ HELP INDEX   ]"
     LOCATE 8, 10: PRINT "[ HELP SYNTAX  ]"
    LOCATE 10, 10: PRINT "[ KEYBOARD USE ]"

     LOCATE 6, 32: PRINT "[ OVERVIEW     ]"
     LOCATE 8, 32: PRINT "[ REQUIREMENTS ]"
    LOCATE 10, 32: PRINT "[ GET STARTED  ]"
   
     LOCATE 6, 54: PRINT "[ COMMANDS     ]"
     LOCATE 8, 54: PRINT "[ REGISTRATION ]"
    LOCATE 10, 54: PRINT "[ CANCEL       ]"
   
    COLOR 5
    Center 14, " This HELP option incomplete at this time. "

SLEEP
GOTO EndHelpSub

DisplayCursor:

        COLOR 15, 3
        LOCATE d%, e%: PRINT STRING$(30, 32)
        LOCATE d%, e% + 1: PRINT MID$(Tmp$(l%), 2)
        IF i% < 12 THEN d% = i% + 6: e% = 9
        IF i% >= 12 THEN d% = i% - 5: e% = 41
        l% = i%
        COLOR 15, 0
        LOCATE d%, e%: PRINT STRING$(30, 32)
        LOCATE d%, e% + 1: PRINT MID$(Tmp$(i%), 2)
RETURN

ChooseIt:
MakePopUp 18, 70, "Help", 11, 3
COLOR 11, 3
Center 21, "[Esc] = Exit Help      Any Other Key To Return"

     OPEN "FILRHELP.TXT" FOR INPUT AS #1
     FOR x% = 1 TO 170
     INPUT #1, a$
     NEXT x%
     DO WHILE NOT EOF(1)
     INPUT #1, a$
      IF a$ = RTRIM$(Tmp$(i%)) THEN
        t% = 4: COLOR 0, 3
        DO
          t% = t% + 1
          LINE INPUT #1, a$
          IF LEFT$(a$, 1) = "." THEN EXIT DO
          IF INSTR(a$, ";;") <> 0 THEN EXIT DO
          IF LEFT$(a$, 1) = "*" THEN
                Center t% + 1, "                                                More..."
                SLEEP 60
                MakePopUp 18, 70, "Help", 11, 3
                COLOR 11, 3: Center 21, "[Esc] = Exit Help      Any Other Key To Return"
                t% = 4: COLOR 0, 3
          END IF
          Center t%, a$
        LOOP
      EXIT DO
      END IF
     LOOP
        IF EOF(1) THEN PCOPY 1, 2: CLOSE : RETURN
     CLOSE
     DO WHILE INKEY$ <> "": LOOP
     a$ = UCASE$(INPUT$(1))
     IF a$ = CHR$(27) THEN GOTO EndHelpSub
     PCOPY 1, 2
RETURN

EndHelpSub:

TIMER ON
OriginalScreen

END SUB

SUB HiliteMenu (Index%)
'
'  Hilites the MenuHeader's KeyLetters only.
'
y% = 4
COLOR 0, 7
LOCATE 1, 1, 0: PRINT STRING$(80, " ")
FOR i% = 1 TO UBOUND(Header$) - 1
        LOCATE 1, y%, 0
        FOR x% = 1 TO LEN(Header$(i%))
           a$ = MID$(Header$(i%), x%, 1)
           IF a$ <> "&" THEN PRINT a$;
           IF a$ = "&" THEN COLOR 15, 7 ELSE COLOR 0, 7
        NEXT x%
        y% = y% + LEN(Header$(i%)) + 1
NEXT i%

LOCATE 1, 80 - LEN(Header$(i%)), 0
        FOR x% = 1 TO LEN(Header$(i%))
           a$ = MID$(Header$(i%), x%, 1)
           IF a$ <> "&" THEN PRINT a$;
           IF a$ = "&" THEN COLOR 15, 7 ELSE COLOR 0, 7
        NEXT x%
END SUB

SUB InvalidOption

   SCREEN 0, , 1, 1
   MakePopUp 4, 46, "", 6, 7

COLOR 0, 7
Center 12, "That option is not available on this version."

        COLOR 15, 7
        Center 14, "[ OK ]"
        SLEEP 4
        COLOR 15, 0
        Center 14, "[ OK ]"
        Delay .25
        SCREEN 0, , 0, 0
        EXIT SUB

END SUB

SUB LoadMenu
'
' Used only once in the program.
' READs all the DATA to build the menu. Alternately determines the widths
' of each pulldown and sets the array sizes.
'
REDIM Tmp$(40)
DO
  i% = i% + 1
  READ Tmp$(i%)
  IF Tmp$(i%) = "0" THEN EXIT DO
LOOP
REDIM Header$(i% - 1)
FOR i% = 1 TO UBOUND(Header$)
        Header$(i%) = Tmp$(i%)
NEXT i%
REDIM Tmp2$(40, 25)
FOR x% = 1 TO UBOUND(Header$)
 i% = 0
  DO
    i% = i% + 1
    READ Tmp2$(i%, x%)
    IF Tmp2$(i%, x%) = "0" THEN EXIT DO
  LOOP
NEXT x%

FOR x% = 1 TO UBOUND(Header$)
  FOR y% = 1 TO 25
    IF Tmp2$(y%, x%) = "0" THEN
        IF Highest% < y% THEN Highest% = y%
        EXIT FOR
    END IF
  NEXT y%
NEXT x%

REDIM PullDown$(Highest% - 1, UBOUND(Header$))
FOR x% = 1 TO UBOUND(Header$)
  FOR y% = 1 TO Highest% - 1
    PullDown$(y%, x%) = Tmp2$(y%, x%)
  NEXT y%
NEXT x%

REDIM Tmp2$(0, 0)
REDIM PullDownWidth%(UBOUND(Header$))
FOR x% = 1 TO UBOUND(Header$)
  FOR y% = 1 TO Highest% - 1
    IF Wide% < LEN(PullDown$(y%, x%)) THEN Wide% = LEN(PullDown$(y%, x%))
  NEXT y%
  PullDownWidth%(x%) = Wide% - 1: Wide% = 0
NEXT x%

REDIM Footer$(UBOUND(Header$), Highest% - 1)
FOR x% = 1 TO UBOUND(Header$)
  FOR y% = 1 TO Highest% - 1
    IF LEN(PullDown$(y%, x%)) > 1 THEN
        READ a$
        Footer$(x%, y%) = a$
    END IF
  NEXT y%
NEXT x%


END SUB

SUB Logo
'
'   Displays program LOGO. And set's up program interface notes.
'
'   Created using the some of following extended characters...
'
'                                    
'
'                                    
'
'                                    
'
COLOR 8, 0: CLS
COLOR 9
Center 11, "From UnderWARE Labs(c)"
s1% = 11: s2% = 3: s3% = 3
FOR i% = 1 TO 25
        d% = s1%: s1% = s2%: s2% = s3%: s3% = d%
        Delay .1
        IF INKEY$ <> "" THEN EXIT FOR
        COLOR s1%
        LOCATE 8, 20: PRINT "ĿĿĿ   ҿĿ  Ŀ   ĿĿ "
        COLOR s2%
        LOCATE 9, 20: PRINT " Ĵ           1.O"
        COLOR s3%
        LOCATE 10, 20: PRINT "ٽ        ٽ"
NEXT i%

COLOR 1, 1
CLS

COLOR 0, 3
LOCATE 25, 1, 0: PRINT ""; STRING$(78, 32); "";
LOCATE 25, 2, 0
PRINT DATE$; "12:32pm";
ShowTime
COLOR 11
LOCATE 25, 21, 0: PRINT "[Alt]=Menu   ["; CHR$(27); CHR$(24); CHR$(25); CHR$(26);
PRINT "]=Select   [Enter]=Accept   [Esc]=Cancel";

END SUB

SUB MakePopUp (y%, x%, Title$, c1%, c2%)
'
'  Creates a PopUP on the screen x% wide, and y% Tall, with the
'  "Title$" text on the upper left Border.  c1% and c2% are the colors.
'  Also automatically creates the "shadowed" effect.
'  If the Title is blank ("") then it fills it in with a border.
'
COLOR c1%, c2%
'
Ypos% = 12 - INT(y% / 2)
Xpos% = 39 - INT(x% / 2)
LOCATE Ypos%, Xpos%, 0
PRINT "";
IF Title$ <> "" THEN COLOR 15
IF Title$ = "" THEN Title$ = "" ELSE Title$ = " " + Title$ + " "

PRINT Title$;

COLOR c1%
PRINT STRING$(x% - LEN(Title$), ""); ""

FOR i% = Ypos% + 1 TO Ypos% + y%
        LOCATE i%, Xpos%, 0
        PRINT ""; STRING$(x%, " "); ""
NEXT i%
LOCATE i%, Xpos%, 0
PRINT ""; STRING$(x%, ""); ""
COLOR 8, 0
FOR i% = Ypos% + 1 TO Ypos% + y% + 1
        a% = SCREEN(i%, Xpos% + x% + 2)
        b% = SCREEN(i%, Xpos% + x% + 3)
        LOCATE i%, Xpos% + x% + 2, 0: PRINT CHR$(a%); CHR$(b%)
NEXT i%
FOR i% = Xpos% + 2 TO Xpos% + 3 + x%
        a% = SCREEN(Ypos% + y% + 2, i%)
        LOCATE Ypos% + y% + 2, i%, 0: PRINT CHR$(a%);
NEXT i%
END SUB

SUB MenuHilite (MenuNumber%)
'
' Creates the MenuHeader with hilighted keyletters, and alternately
' finds the current chosen selection (MenuNumber%), and shows
' it with Text on a BLACK background.
'
'
IF MenuNumber% > 1 AND MenuNumber% <> UBOUND(Header$) THEN
   FOR i% = 1 TO MenuNumber% - 1
     Xpos% = Xpos% + LEN(Header$(i%)) + 1
   NEXT i%
END IF

IF MenuNumber% = UBOUND(Header$) THEN Xpos% = 73 - PullDownWidth%(MenuNumber%)
IF MenuNumber% = 1 THEN Xpos% = 0

Xpos% = Xpos% + 3
IF MenuNumber% < UBOUND(Header$) THEN
COLOR 7, 0
LOCATE 1, Xpos%, 0: PRINT " ";
        FOR x% = 1 TO LEN(Header$(MenuNumber%))
           a$ = MID$(Header$(MenuNumber%), x%, 1)
           IF a$ <> "&" THEN PRINT a$;
           IF a$ = "&" THEN COLOR 15, 0 ELSE COLOR 7, 0
        NEXT x%
        PRINT " "
        END IF
IF MenuNumber% = UBOUND(Header$) THEN
COLOR 7, 0
LOCATE 1, Xpos% + PullDownWidth%(MenuNumber%) - LEN(Header$(MenuNumber%)) + 3, 0: PRINT " ";
        FOR x% = 1 TO LEN(Header$(MenuNumber%))
           a$ = MID$(Header$(MenuNumber%), x%, 1)
           IF a$ <> "&" THEN PRINT a$;
           IF a$ = "&" THEN COLOR 15, 0 ELSE COLOR 7, 0
        NEXT x%
        PRINT " "
        END IF
END SUB

SUB OriginalScreen
'
' Switchs back to the Original screen so that the program writes and
' displays on the the first chosen video page. (Page 0)
' Not to be confused with RestoreScreen.
'
SCREEN 0, , 0, 0
END SUB

SUB PrintDetailed
  
   SCREEN 0, , 1, 1
        MakePopUp 6, 54, "Print", 11, 3
        COLOR 0, 3
        Center 11, "Printing All Records - Detailed Format    "
        COLOR 16
        LOCATE 11, 57: PRINT "..."
   CLOSE
        COLOR 11, 3
        Center 13, STRING$(50, 176)
  
   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
   i% = 0
   LPRINT
        IF ErrorContinue% = 1 THEN
           ErrorContinue% = 0
           GOTO EndOfDetail
           END IF
   LPRINT
   LPRINT "              Complete DwgFiler Index listing - Detailed Format"
   LPRINT " "; STRING$(78, "-")
 
a1$ = " Index: #####             Created:       \      \                ACAD ver: ##"
a2$ = " File Name: \      \      Last Revised:  \      \            No. Of Files: ##"
a3$ = " Path: \                                                      \"
   DO
     i% = i% + 1
     COLOR 15, 3
     Center 15, STR$(INT((i% / (LOF(1) / LEN(All))) * 100)) + "% Complete"
     x% = INT((i% / (LOF(1) / LEN(All))) * 50)
     COLOR 12, 4
     LOCATE 13, 15: PRINT STRING$(x%, 177)
        FOR w% = 1 TO 200 STEP 8
                a$ = MID$(All.DwgList, w%, 8)
                FOR t% = 1 TO 8
                        IF ASC(MID$(a$, t%, 1)) > 32 THEN EXIT FOR
                NEXT t%
                IF t% > 8 THEN EXIT FOR
        NEXT w%
        NumFiles% = INT(w% / 8)

     GET #1, i%, All
     LOCATE 20
     LPRINT
     Date1$ = LEFT$(All.BuildDate, 2) + "-" + MID$(All.BuildDate, 3, 2) + "-" + RIGHT$(All.BuildDate, 2)
     Date2$ = LEFT$(All.RevDate, 2) + "-" + MID$(All.RevDate, 3, 2) + "-" + RIGHT$(All.RevDate, 2)
     LPRINT USING a1$; All.RecNum; Date1$; All.AcadRev
     LPRINT USING a2$; All.FileName; Date2$; NumFiles%
     LPRINT USING a3$; All.Path$
     LPRINT " Description: ";
     LPRINT LEFT$(All.Description, 64)
        b$ = STRING$(64, 32)
        IF MID$(All.Description, 65, 64) <> b$ THEN LPRINT "             "; MID$(All.Description, 65, 64)
        IF MID$(All.Description, 129, 64) <> b$ THEN LPRINT "             "; MID$(All.Description, 129, 64)
        IF RIGHT$(All.Description, 64) <> b$ THEN LPRINT "             "; RIGHT$(All.Description, 64)
     LPRINT " Associated File Names:"
        c% = 0: t% = 18
        FOR w% = 1 TO 25
                c% = c% + 12
                IF c% > 68 THEN c% = 12: t% = t% + 1
                a$ = MID$(All.DwgList, (w% * 8) - 7, 8)
                IF a$ <> "        " THEN LPRINT "      "; a$; " ";
        NEXT w%
     LPRINT
     LPRINT " "; STRING$(78, "-")
   LOOP WHILE i% < LOF(1) / LEN(All)
   CLOSE
   LPRINT CHR$(12)

Delay .5
EndOfDetail:
SCREEN 0, , 0, 0

END SUB

SUB PrintForms
PCOPY 0, 1
SCREEN 0, , 1, 1
MakePopUp 3, 37, "", 11, 5
COLOR 14, 5
Center 12, "Enter number of copies to print:   "
COLOR 15, 0
a$ = GetInput$(12, 56, 2, "")
COLOR 15, 5
LOCATE 12, 56: PRINT "  "
LOCATE 12, 56: PRINT a$
IF VAL(a$) <= 0 THEN GOTO EndOfPF
COLOR 11, 5
LOCATE 14, 31: PRINT "Printing, Page:";

FOR i% = 1 TO VAL(a$)
 CLOSE

 OPEN "filrform.txt" FOR INPUT AS #1
 DO WHILE NOT EOF(1)
        LINE INPUT #1, b$
        LPRINT b$
        IF ErrorContinue% = 1 THEN
           ErrorContinue% = 0
           GOTO EndOfPF
        END IF
 LOOP
 COLOR 15, 5
 LOCATE 14, 46: PRINT i%
 LPRINT
NEXT i%
CLOSE

EndOfPF:
SCREEN 0, , 0, 0

END SUB

SUB PrintOne
  
   i% = CurrentIndex%

   IF i% = 0 THEN
   SCREEN 0, , 1, 1
        MakePopUp 1, 33, "", 11, 3
        COLOR 0, 3
        Center 13, "No Record Selected. "
        Delay 1
        SCREEN 0, , 0, 0
        EXIT SUB
   END IF
  
   SCREEN 0, , 1, 1
        MakePopUp 1, 33, "Print", 11, 3
        COLOR 0, 3
        Center 13, "Printing Current Record. "
   CLOSE
   
   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
   GET #1, i%, All
   CLOSE #1
   FOR i% = 1 TO 200 STEP 8
        a$ = MID$(All.DwgList, i%, 8)
        FOR t% = 1 TO 8
           IF ASC(MID$(a$, t%, 1)) > 32 THEN EXIT FOR
        NEXT t%
        IF t% > 8 THEN EXIT FOR
   NEXT i%
NumAsso$ = LTRIM$(STR$(INT(i% / 8)))

LPRINT " Index#: "; LTRIM$(STR$(All.RecNum)), ,
LPRINT " FileName: "; All.FileName,
LPRINT " ACAD ver: "; LTRIM$(STR$(All.AcadRev))
LPRINT " Created: "; All.BuildDate,
LPRINT " Last Revised: "; All.RevDate,
LPRINT " Number of Files: "; NumAsso$
LPRINT " Path: "; All.Path
LPRINT " Description: ";
LPRINT LEFT$(All.Description, 64)
 b$ = STRING$(64, 32)
 IF MID$(All.Description, 65, 64) <> b$ THEN LPRINT "             "; MID$(All.Description, 65, 64)
 IF MID$(All.Description, 129, 64) <> b$ THEN LPRINT "             "; MID$(All.Description, 129, 64)
 IF RIGHT$(All.Description, 64) <> b$ THEN LPRINT "             "; RIGHT$(All.Description, 64)
LPRINT " Associated File Names:"

c% = 0: t% = 18

FOR i% = 1 TO 25
   c% = c% + 12
   IF c% > 68 THEN c% = 12: t% = t% + 1
   a$ = MID$(All.DwgList, (i% * 8) - 7, 8)
   IF a$ <> "        " THEN LPRINT "      "; a$; " ";
NEXT i%
LPRINT " "; STRING$(78, "-")
LPRINT
Delay 1
SCREEN 0, , 0, 0
END SUB

SUB PrintSummary
  
   SCREEN 0, , 1, 1
        MakePopUp 6, 54, "Print", 11, 3
        COLOR 0, 3
        Center 11, "Printing All Records - Summary Format    "
        COLOR 16
        LOCATE 11, 57: PRINT "..."
   CLOSE
        COLOR 11, 3
        Center 13, STRING$(50, 176)
       

a1$ = "#####   \      \    \      \    \      \    Rev ##    ## More Files"
a2$ = "                    \                                                      \"

   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
   i% = 0: LineNo% = 4: pp% = 1
   LPRINT
   LPRINT
   LPRINT "              Complete DwgFiler Index listing - Summary Format"
   LPRINT " "; STRING$(78, "-")
   DO
     i% = i% + 1
     LineNo% = LineNo% + 2
    
     IF LineNo% > 58 THEN
        LPRINT
        LPRINT STRING$(35, 32); "Page ("; RTRIM$(LTRIM$(STR$(pp%))); ")"
        LPRINT CHR$(12): LineNo% = 6: pp% = pp% + 1
        LPRINT : LPRINT : LPRINT
     END IF
    
     COLOR 15, 3
     Center 15, STR$(INT((i% / (LOF(1) / LEN(All))) * 100)) + "% Complete"
     x% = INT((i% / (LOF(1) / LEN(All))) * 50)
     COLOR 12, 4
     LOCATE 13, 15: PRINT STRING$(x%, 177)
        FOR w% = 1 TO 200 STEP 8
                a$ = MID$(All.DwgList, w%, 8)
                FOR t% = 1 TO 8
                        IF ASC(MID$(a$, t%, 1)) > 32 THEN EXIT FOR
                NEXT t%
                IF t% > 8 THEN EXIT FOR
        NEXT w%
        NumFiles% = INT(w% / 8)

     GET #1, i%, All
     LOCATE 20
     Date1$ = LEFT$(All.BuildDate, 2) + "-" + MID$(All.BuildDate, 3, 2) + "-" + RIGHT$(All.BuildDate, 2)
     Date2$ = LEFT$(All.RevDate, 2) + "-" + MID$(All.RevDate, 3, 2) + "-" + RIGHT$(All.RevDate, 2)
     LPRINT USING a1$; All.RecNum; All.FileName; Date1$; Date2$; All.AcadRev; NumFiles%
     LPRINT USING a2$; All.Path
   LOOP WHILE i% < LOF(1) / LEN(All)
   CLOSE
   FOR y% = 58 TO LineNo% STEP -1
        LPRINT
   NEXT y%
        LPRINT STRING$(35, 32); "Page ("; RTRIM$(LTRIM$(STR$(pp%))); ")"
        LPRINT CHR$(12)

Delay .5
SCREEN 0, , 0, 0

END SUB

FUNCTION PromptQuit$
'
'   Nice Function that creates a PopUp, and Prompts for "Are You Sure?"
'   Returns a "YES" if user selects to quit, or "" if not.
'
'   SYNTAX:
'
'   anystring$= PromptQuit$
'
'   Where the Function will return the information into anystring$.
'
'
RestoreScreen
MakePopUp 4, 31, "Exit", 4, 7
COLOR 0, 7
Center 12, "Do you really wish to quit?"
GOSUB DisplayChoice
DO
  a$ = UCASE$(INKEY$)
  IF a$ = "Y" THEN PromptQuit$ = "YES": GOSUB DisplayOK: RestoreScreen: EXIT FUNCTION
  IF a$ = CHR$(27) THEN PromptQuit$ = "":  GOSUB DisplayCancel: RestoreScreen: EXIT FUNCTION
  IF a$ = "N" THEN PromptQuit$ = "":  GOSUB DisplayCancel: RestoreScreen: EXIT FUNCTION
  IF a$ = "C" THEN PromptQuit$ = "":  GOSUB DisplayCancel: RestoreScreen: EXIT FUNCTION
  IF a$ = CHR$(9) THEN Choice% = Choice% + 1: GOSUB DisplayChoice
  IF a$ = CHR$(13) OR a$ = " " THEN
        IF Choice% = 2 THEN PromptQuit$ = "": GOSUB DisplayCancel: RestoreScreen: EXIT FUNCTION
        IF Choice% = 1 THEN PromptQuit$ = "YES":  GOSUB DisplayOK: RestoreScreen: EXIT FUNCTION
  END IF
LOOP
DisplayChoice:
 COLOR 0, 7
 LOCATE 14, 28, 0: PRINT "   [Yes]    [Cancel] "
 COLOR 15
 LOCATE 14, 32, 0: PRINT "Y"
 LOCATE 14, 41, 0: PRINT "C"
   IF Choice% = 3 THEN Choice% = 1
   IF Choice% = 1 THEN
      COLOR 7, 0
      LOCATE 14, 30, 0: PRINT " [Yes] "
      COLOR 15
      LOCATE 14, 32, 0: PRINT "Y"
   END IF
   IF Choice% = 2 THEN
      COLOR 7, 0
      LOCATE 14, 39, 0: PRINT " [Cancel] "
      COLOR 15
      LOCATE 14, 41, 0: PRINT "C"
   END IF
RETURN
DisplayOK:
COLOR 15, 0
LOCATE 14, 30, 0: PRINT " [Yes] "
Delay .25
RETURN
DisplayCancel:
COLOR 15, 0
LOCATE 14, 39, 0: PRINT " [Cancel] "
Delay .25
RETURN
END FUNCTION

SUB PullMenu (MenuNumber%)
'
' Rather Large Sub routine that Does ALL the PullDown Menu work.
' Selects the MenuNumber% and alternately displays the all the
' information including the current selection.
'
' NOTE: The Index%, and Selection% variables are GLOBAL and are
' required for MenuMakr. Do not use them elsewhere.
'
'
IF MenuNumber% > 1 AND MenuNumber% <> UBOUND(Header$) THEN
   FOR i% = 1 TO MenuNumber% - 1
     Xpos% = Xpos% + LEN(Header$(i%)) + 1
   NEXT i%
END IF

IF MenuNumber% = UBOUND(Header$) THEN Xpos% = 73 - PullDownWidth%(MenuNumber%)
IF MenuNumber% = 1 THEN Xpos% = 0

Xpos% = Xpos% + 3
IF MenuNumber% < UBOUND(Header$) THEN
COLOR 7, 0
LOCATE 1, Xpos%, 0: PRINT " ";
        FOR x% = 1 TO LEN(Header$(MenuNumber%))
           a$ = MID$(Header$(MenuNumber%), x%, 1)
           IF a$ <> "&" THEN PRINT a$;
           IF a$ = "&" THEN COLOR 15, 0 ELSE COLOR 7, 0
        NEXT x%
        PRINT " "
        END IF
IF MenuNumber% = UBOUND(Header$) THEN
COLOR 7, 0
LOCATE 1, Xpos% + PullDownWidth%(MenuNumber%) - LEN(Header$(MenuNumber%)) + 3, 0: PRINT " ";
        FOR x% = 1 TO LEN(Header$(MenuNumber%))
           a$ = MID$(Header$(MenuNumber%), x%, 1)
           IF a$ <> "&" THEN PRINT a$;
           IF a$ = "&" THEN COLOR 15, 0 ELSE COLOR 7, 0
        NEXT x%
        PRINT " "
        END IF
COLOR 0, 7

LOCATE 2, Xpos% - 1, 0: PRINT "" + STRING$(PullDownWidth%(MenuNumber%) + 2, "") + ""
COLOR 0, 7
d% = 7
FOR y% = 1 TO UBOUND(PullDown$)
       
        IF PullDown$(y%, MenuNumber%) = "0" THEN EXIT FOR
        IF PullDown$(y%, MenuNumber%) <> "|" THEN
          Ypos% = Ypos% + 1
          LOCATE y% + 2, Xpos% - 1, 0: PRINT "";
          IF Index% = y% THEN COLOR , 0 ELSE COLOR , 7
          PRINT STRING$(PullDownWidth%(MenuNumber%) + 2, " ");
          COLOR 0, 7: PRINT "": COLOR 7, 0
          IF d% = 7 THEN COLOR 0, 7
          LOCATE y% + 2, Xpos% + 1, 0
            IF Index% = y% THEN COLOR , 0: c% = 7 ELSE COLOR , 7: c% = 0
            FOR x% = 1 TO LEN(PullDown$(y%, MenuNumber%))
              a$ = MID$(PullDown$(y%, MenuNumber%), x%, 1)
              IF Index% = y% AND a$ <> "&" AND c% = 7 AND d% = 7 THEN COLOR 7
              IF a$ <> "&" THEN PRINT a$;
              IF a$ = "&" THEN COLOR 15: d% = 0 ELSE COLOR c%: d% = 7
            NEXT x%
        END IF
        IF PullDown$(y%, MenuNumber%) = "|" THEN
          LOCATE y% + 2, Xpos% - 1, 0: PRINT ""; STRING$(PullDownWidth%(MenuNumber%) + 2, ""); ""
        END IF
         
          COLOR 8, 0
          a% = SCREEN(y% + 2, Xpos% + PullDownWidth%(MenuNumber%) + 3)
          b% = SCREEN(y% + 2, Xpos% + PullDownWidth%(MenuNumber%) + 4)
          LOCATE y% + 2, Xpos% + PullDownWidth%(MenuNumber%) + 3, 0: PRINT CHR$(a%); CHR$(b%)
          COLOR 0, 7
NEXT y%
          COLOR 8, 0
          a% = SCREEN(y% + 2, Xpos% + PullDownWidth%(MenuNumber%) + 3)
          b% = SCREEN(y% + 2, Xpos% + PullDownWidth%(MenuNumber%) + 4)
          LOCATE y% + 2, Xpos% + PullDownWidth%(MenuNumber%) + 3, 0: PRINT CHR$(a%); CHR$(b%)
          COLOR 0, 7
        
LOCATE y% + 2, Xpos% - 1, 0: PRINT "" + STRING$(PullDownWidth%(MenuNumber%) + 2, "") + ""

COLOR 8, 0
FOR x% = Xpos% + 1 TO Xpos% + PullDownWidth%(MenuNumber%) + 4
    a% = SCREEN(y% + 3, x%)
    LOCATE y% + 3, x%, 0: PRINT CHR$(a%)
NEXT x%

COLOR 15, 3
LOCATE 25, 21, 0: PRINT STRING$(58, 32);
LOCATE 25, 21, 0: PRINT Footer$(MenuNumber%, Index%);
END SUB

SUB RegularMenu
'
'   Restores the screen and displays the un-hilighted menu header.
'
PCOPY 0, 1
SCREEN 0, , 0, 0
y% = 4
COLOR 0, 7
LOCATE 1, 1, 0: PRINT STRING$(80, " ")
FOR i% = 1 TO UBOUND(Header$) - 1
        LOCATE 1, y%, 0
        FOR x% = 1 TO LEN(Header$(i%))
           a$ = MID$(Header$(i%), x%, 1)
           IF a$ <> "&" THEN PRINT a$;
        NEXT x%
        y% = y% + LEN(Header$(i%)) + 1
NEXT i%

LOCATE 1, 80 - LEN(Header$(i%)), 0
        FOR x% = 1 TO LEN(Header$(i%))
           a$ = MID$(Header$(i%), x%, 1)
           IF a$ <> "&" THEN PRINT a$;
        NEXT x%

COLOR 5, 1
LOCATE 2, 1, 0: PRINT STRING$(80, 223)

END SUB

SUB Resources (i%)

' Finds out how much space DwgFlr is using on the HDD.
'

SCREEN 0, , 1, 1
IF i% = 1 THEN

MakePopUp 7, 40, "Program Resource Use", 11, 3
COLOR 0, 3
Center 11, "Drawing Filer is using...             "
LOCATE , , 0
SHELL "dir dwgfiler.dat > temp.$$$"
t% = 0

LOCATE 3, 1, 0
OPEN "temp.$$$" FOR INPUT AS #1
        DO WHILE NOT EOF(1)
        LINE INPUT #1, a$
        t% = t% + 1
        IF t% = 3 THEN
        'Volume Serial Number is 3F77-11DE
        d% = INSTR(a$, "Serial")
        END IF
        IF t% = 6 AND d% < 1 THEN
          s% = INSTR(a$, ")")
          a$ = MID$(a$, s% + 1)
          FOR r% = 1 TO LEN(a$)
                s% = ASC(MID$(a$, r%, 1))
                IF s% > 47 AND s% < 58 THEN b$ = b$ + MID$(a$, r%, 1)
          NEXT r%
          LOCATE 13, 21, 0: PRINT LTRIM$(b$); " bytes of disk space."
        END IF
        IF t% = 7 AND d% > 0 THEN
          s% = INSTR(a$, ")")
          a$ = MID$(a$, s% + 1)
          FOR r% = 1 TO LEN(a$)
                s% = ASC(MID$(a$, r%, 1))
                IF s% > 47 AND s% < 58 THEN b$ = b$ + MID$(a$, r%, 1)
          NEXT r%
          LOCATE 13, 21, 0: PRINT LTRIM$(b$); " bytes of disk space."
        END IF
        IF t% = 7 AND d% < 1 THEN
          s% = INSTR(a$, ")")
          a$ = MID$(a$, s% + 1)
          FOR r% = 1 TO LEN(a$)
                s% = ASC(MID$(a$, r%, 1))
                IF s% > 47 AND s% < 58 THEN c$ = c$ + MID$(a$, r%, 1)
          NEXT r%
          LOCATE 14, 21, 0: PRINT "There are "; c$; " bytes available."
        END IF
        IF t% = 8 THEN
          s% = INSTR(a$, ")")
          a$ = MID$(a$, s% + 1)
          FOR r% = 1 TO LEN(a$)
                s% = ASC(MID$(a$, r%, 1))
                IF s% > 47 AND s% < 58 THEN c$ = c$ + MID$(a$, r%, 1)
          NEXT r%
          LOCATE 14, 21, 0: PRINT "There are "; c$; " bytes available."
        END IF
LOOP
CLOSE
        COLOR 15, 3
        Center 16, "[ OK ]"
        a$ = INPUT$(1)
        COLOR 15, 0
        Center 16, "[ OK ]"
        Delay .25
        SCREEN 0, , 0, 0
        EXIT SUB
END IF
               
IF i% = 2 THEN

SCREEN 0, , 1, 1
MakePopUp 4, 44, "Data File Information", 11, 3
  
   i% = 0
   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
   DO WHILE NOT EOF(1)
        i% = i% + 1
        GET #1, i%, All
   LOOP
   CLOSE #1

COLOR 0, 3
Center 12, "Drawing Filer has " + LTRIM$(STR$(i% - 1)) + " separate records."

        COLOR 15, 3
        Center 14, "[ OK ]"
        a$ = INPUT$(1)
        COLOR 15, 0
        Center 14, "[ OK ]"
        Delay .25
        SCREEN 0, , 0, 0
        EXIT SUB

END IF
END SUB

SUB RestoreScreen
'
' COPIES OriginalScreen to a second video page (Page 1), and alternately
' changes TO that page. Information WILL NOT be written to the
' OriginalScreen.  To erase all the information, use RegularScreen.
'
PCOPY 0, 1
SCREEN 0, , 1, 1
END SUB

SUB SearchBy (i%)
'
' Where i% = is the type of search to perform.
'
'       This sub is  B I G .
'
DisplayRecord 0

OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
        IF LOF(1) < 2 THEN ERROR 62
CLOSE
TIMER OFF
PCOPY 0, 1
SCREEN 0, , 1, 1
SELECT CASE i%
        CASE 1
                Title$ = "Find One Index Number"
                D1$ = "  Below, type in index number of the    "
                D2$ = "  drawing file you wish to search for.  "
        CASE 2
                Title$ = "Find a Range of Index Numbers"
                D1$ = "   Below, type in the range of index"
                D2$ = "    numbers you wish to search for."
        CASE 3
                Title$ = "Find One File Name"
                D1$ = "  Below, type in the file name of the"
                D2$ = "  drawing file you wish to search for."
        CASE 4
                Title$ = "Find by Partial File Name"
                D1$ = "Below, type in part of the file name of"
                D2$ = "the drawing file you wish to search for."
        CASE 5
                Title$ = "Find by Creation Date"
                D1$ = " Enter the date you wish to search for."
                D2$ = "      ( Use the format: MMDDYY )"
        CASE 6
                Title$ = "Find a Range of Dates"
                D1$ = " Enter the range of dates to search for."
                D2$ = "      ( Use the format: MMDDYY )"
        CASE 7
                Title$ = "Find by Revision date"
                D1$ = " Enter the date you wish to search for."
                D2$ = "      ( Use the format: MMDDYY )"
        CASE 8
                Title$ = "Find a Range of Revision Dates"
                D1$ = " Enter the range of dates to search for."
                D2$ = "      ( Use the format: MMDDYY )"
        CASE 9
                Title$ = "Find Only by Acad version"
                D1$ = "  Enter the AutoCAD release number you"
                D2$ = "          wish to search for."
        CASE 10
                Title$ = "Find Using a Key Word"
                D1$ = " Type in below a key word to search for"
                D2$ = "       in the index description."
END SELECT

MakePopUp 6, 40, Title$, 5, 7
COLOR 0, 7
LOCATE 11, 20, 0: PRINT D1$
LOCATE 12, 20: PRINT D2$

SELECT CASE i%
        CASE 1
                LOCATE 14, 29, 0: PRINT "Index Number: "
                COLOR 15, 0
                a$ = GetInput$(14, 43, 5, "")
                IF VAL(a$) < 32767 THEN CurrentIndex% = VAL(a$)
                COLOR 15, 7: LOCATE 14, 43: PRINT STRING$(5, " ")
                COLOR 15, 7: LOCATE 14, 43: PRINT a$
                IF a$ = "" THEN
                        a$ = "Invalid Index Number."
                        GOTO NotFound
                END IF
                GOSUB SearchPU
                Delay .25
                COLOR 15, 7
                SCREEN 0, , 0, 0
                DisplayRecord CurrentIndex%
                IF CurrentIndex% = 0 THEN
                        SCREEN 0, , 1, 1
                        a$ = "Invalid Index Number."
                        GOTO NotFound
                END IF
        CASE 2
                LOCATE 14, 24, 0: PRINT "Start No: "
                LOCATE 14, 42: PRINT "End No: "
                COLOR 15, 0
                a1$ = GetInput$(14, 34, 5, "")
                b1$ = GetInput$(14, 50, 5, "")
                COLOR 15, 7: LOCATE 14, 34: PRINT STRING$(5, " ")
                COLOR 15, 7: LOCATE 14, 34: PRINT a1$
                COLOR 15, 7: LOCATE 14, 50: PRINT STRING$(5, " ")
                COLOR 15, 7: LOCATE 14, 50: PRINT b1$
                IF a1$ = "" AND b1$ = "" THEN GOTO EndOfSB
                IF a1$ = "" THEN a1$ = "1"
                IF b1$ = "" THEN b1$ = "32766"
                GOSUB SearchPU
                Delay .25
                COLOR 15, 7
                SCREEN 0, , 0, 0
                CurrentIndex% = VAL(a1$)
NextCI: 
                IF VAL(b1$) > 32766 OR CurrentIndex% = 0 THEN GOTO AfterCI
                DisplayRecord CurrentIndex%
                LOCATE 24, 2, 0: COLOR 31: PRINT "More...";
                IF CurrentIndex% = 0 OR VAL(b1$) = CurrentIndex% THEN GOTO AfterCI
                e$ = INPUT$(1)
                IF e$ = CHR$(27) THEN GOTO AfterCI
                CurrentIndex% = CurrentIndex% + 1
                GOTO NextCI
AfterCI:
               LOCATE 24, 2: COLOR 1, 1: PRINT "       ";
        CASE 3, 4
                LOCATE 14, 30: PRINT "File Name: "
                COLOR 15, 0
                a$ = GetInput$(14, 41, 8, "")
                COLOR 15, 7: LOCATE 14, 41: PRINT STRING$(8, " ")
                COLOR 15, 7: LOCATE 14, 41: PRINT a$
                a$ = UCASE$(a$)
                IF a$ = "" THEN GOTO EndOfSB
                GOSUB SearchPU
                IF i% = 3 THEN GOSUB Search1File: SCREEN 0, , 0, 0: DisplayRecord CurrentIndex%: GOTO EndOfSB
                IF i% = 4 THEN GOSUB Search2File
                'Delay .25
                'COLOR 15, 7
                'SCREEN 0, , 1, 1
        CASE 5, 7
                LOCATE 14, 33: PRINT "Date: "
                COLOR 15, 0
                a$ = GetInput$(14, 39, 6, "")
                COLOR 15, 7: LOCATE 14, 39: PRINT STRING$(6, " ")
                COLOR 15, 7: LOCATE 14, 39, 0: PRINT a$
                IF a$ = "" THEN GOTO EndOfSB
                GOSUB SearchPU
                IF i% = 5 THEN GOSUB SearchOneDate
                IF i% = 7 THEN GOSUB SearchRevDate
                Delay .25
                COLOR 15, 7
                SCREEN 0, , 1, 1
        CASE 6, 8
                LOCATE 14, 21, 0: PRINT "Start Date: "
                LOCATE 14, 43: PRINT "End Date: "
                COLOR 15, 0
                a$ = GetInput$(14, 33, 6, "")
                b$ = GetInput$(14, 53, 6, "")
                COLOR 15, 7: LOCATE 14, 33: PRINT STRING$(6, " ")
                COLOR 15, 7: LOCATE 14, 33: PRINT a$
                COLOR 15, 7: LOCATE 14, 53: PRINT STRING$(6, " ")
                COLOR 15, 7: LOCATE 14, 53: PRINT b$
                IF a$ = "" AND b$ = "" THEN GOTO EndOfSB
                IF a$ = "" OR b$ = "" THEN
                        IF a$ = "" THEN a$ = b$
                        IF b$ = "" THEN b$ = a$
                END IF
                GOSUB SearchPU
                IF i% = 6 THEN tt% = 2 ELSE tt% = 1
                GOSUB Search2Rev
        CASE 9
                LOCATE 14, 32: PRINT "Version No: "
                COLOR 15, 0
                a$ = GetInput$(14, 44, 2, "")
                COLOR 15, 7: LOCATE 14, 44: PRINT " "
                COLOR 15, 7: LOCATE 14, 44: PRINT a$
                IF a$ = "" THEN GOTO EndOfSB
                GOSUB SearchPU
                GOSUB SearchAcadVer
        CASE 10
                LOCATE 14, 22: PRINT "KeyWord: "
                COLOR 15, 0
                a$ = GetInput$(14, 31, 27, "")
                COLOR 15, 7: LOCATE 14, 31: PRINT STRING$(27, " ")
                COLOR 15, 7: LOCATE 14, 31, 0: PRINT a$
                IF a$ = "" THEN GOTO EndOfSB
                GOSUB SearchPU
                GOSUB SearchKeyWord
END SELECT

GOTO EndOfSB

SearchPU:
        PCOPY 1, 2
        SCREEN 0, , 2, 2
        MakePopUp 1, 33, "", 11, 3
        COLOR 0, 3: LOCATE 13, 25: PRINT "One Moment Please,"
        COLOR 16, 3: LOCATE 13, 44, 0: PRINT "Searching..."
RETURN

Search1File:
  
   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
   i% = 0
   DO WHILE NOT EOF(1)
   i% = i% + 1
   a$ = a$ + STRING$(8 - LEN(a$), 32)
   GET #1, i%, All
   IF UCASE$(All.FileName) = a$ THEN
        CurrentIndex% = i%
        RETURN
   END IF
   LOOP
   CLOSE #1
        a$ = "File Name Not Found."
        GOTO NotFound
RETURN:
Search2File:
 
   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
   i% = 0: s% = 1
   DIM Temp%(100)
   DO WHILE NOT EOF(1)
        i% = i% + 1
        GET #1, i%, All
        x% = INSTR(UCASE$(All.FileName), a$)
        IF x% > 0 THEN Temp%(s%) = i%: s% = s% + 1
        IF s% > 100 THEN EXIT DO
   LOOP
   CLOSE #1
         IF s% > 0 THEN
              SCREEN 0, , 0, 0
              FOR i% = 1 TO s% - 1
                 CurrentIndex% = Temp%(i%)
                 DisplayRecord CurrentIndex%
                 LOCATE 24, 2, 0: COLOR 31: PRINT "More...";
                 e$ = INPUT$(1)
                 IF e$ = CHR$(27) THEN EXIT FOR
              NEXT i%
              LOCATE 24, 2, 0: COLOR 1, 1: PRINT "       ";
        ELSE
                a$ = "File Name Not Found."
                GOTO NotFound
        END IF
RETURN
SearchOneDate:
   i% = 0
   SCREEN 0, , 0, 0
   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
   Highest% = LOF(1) / LEN(All)
   CLOSE
   i% = 0: ii% = 0
   DO WHILE i% <= Highest%
     i% = i% + 1
     OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
     GET #1, i%, All
     CLOSE
     IF UCASE$(All.BuildDate) = a$ THEN
        ii% = 1
        CurrentIndex% = i%
        DisplayRecord CurrentIndex%
        LOCATE 24, 2, 0: COLOR 31: PRINT "More...";
        e$ = INPUT$(1)
        IF e$ = CHR$(27) THEN SCREEN 0, , 0, 0: RETURN
        LOCATE 24, 2: COLOR 1, 1: PRINT "       ";
     END IF
   LOOP
        IF ii% = 0 THEN
          a$ = "No Date Match Found."
          SCREEN 0, , 1, 1
          GOTO NotFound
        END IF
RETURN
SearchAcadVer:
   i% = 0
   SCREEN 0, , 0, 0
   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
   Highest% = LOF(1) / LEN(All)
   CLOSE
   i% = 0: ii% = 0
   DO WHILE i% <= Highest%
     i% = i% + 1
     OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
     GET #1, i%, All
     CLOSE
     IF All.AcadRev = VAL(a$) THEN
        ii% = 1
        CurrentIndex% = i%
        DisplayRecord CurrentIndex%
        LOCATE 24, 2: COLOR 31: PRINT "More...";
        e$ = INPUT$(1)
        IF e$ = CHR$(27) THEN SCREEN 0, , 0, 0: RETURN
        LOCATE 24, 2: COLOR 1, 1: PRINT "       ";
     END IF
   LOOP
        IF ii% = 0 THEN
          a$ = "No Version Match Found."
          SCREEN 0, , 1, 1
          GOTO NotFound
        END IF
RETURN
SearchRevDate:
   i% = 0
   SCREEN 0, , 0, 0
   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
   Highest% = LOF(1) / LEN(All)
   CLOSE
   i% = 0: ii% = 0
   DO WHILE i% <= Highest%
     i% = i% + 1
     OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
     GET #1, i%, All
     CLOSE
     IF UCASE$(All.RevDate) = a$ THEN
        ii% = 1
        CurrentIndex% = i%
        DisplayRecord CurrentIndex%
        LOCATE 24, 2: COLOR 31: PRINT "More...";
        e$ = INPUT$(1)
        IF e$ = CHR$(27) THEN SCREEN 0, , 0, 0: RETURN
        LOCATE 24, 2: COLOR 1, 1: PRINT "       ";
     END IF
   LOOP
        IF ii% = 0 THEN
          a$ = "No Date Match Found."
          SCREEN 0, , 1, 1
          GOTO NotFound
        END IF
RETURN
Search2Rev:
  OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
   i% = 0: s% = 1
   DIM Temp%(100)
   DO WHILE NOT EOF(1)
        i% = i% + 1
        GET #1, i%, All
        IF tt% = 1 THEN x% = CheckDate(a$, b$, All.RevDate) ELSE x% = CheckDate(a$, b$, All.BuildDate)
        IF x% <> 0 THEN Temp%(s%) = i%: s% = s% + 1
        IF s% > 100 THEN EXIT DO
   LOOP
   CLOSE #1
         IF s% > 0 THEN
              SCREEN 0, , 0, 0
              FOR i% = 1 TO s% - 1
                 CurrentIndex% = Temp%(i%)
                 DisplayRecord CurrentIndex%
                 LOCATE 24, 2, 0: COLOR 31: PRINT "More...";
                 e$ = INPUT$(1)
                 IF e$ = CHR$(27) THEN EXIT FOR
              NEXT i%
              LOCATE 24, 2: COLOR 1, 1: PRINT "       ";
        ELSE
                a$ = "No Matching Dates Found."
                GOTO NotFound
        END IF

RETURN
SearchKeyWord:
   i% = 0
   SCREEN 0, , 0, 0
   OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
   Highest% = LOF(1) / LEN(All)
   CLOSE
   i% = 0: ii% = 0: a$ = UCASE$(a$)
   DO WHILE i% <= Highest%
     i% = i% + 1
     OPEN "DwgFiler.DAT" FOR RANDOM AS #1 LEN = LEN(All)
     GET #1, i%, All
     CLOSE
     IF INSTR(UCASE$(All.Description), a$) > 0 THEN
        ii% = 1
        CurrentIndex% = i%
        DisplayRecord CurrentIndex%
        LOCATE 24, 2: COLOR 31: PRINT "More...";
        e$ = INPUT$(1)
        IF e$ = CHR$(27) THEN SCREEN 0, , 0, 0: RETURN
        LOCATE 24, 2: COLOR 1, 1: PRINT "       ";
     END IF
   LOOP
        IF ii% = 0 THEN
          a$ = "No Key-Words Found."
          SCREEN 0, , 1, 1
          GOTO NotFound
        END IF
RETURN
NotFound:
        MakePopUp 1, 33, "", 11, 3
        COLOR 0, 3: LOCATE 13, 25: PRINT STRING$(30, " ")
        COLOR 0, 3: Center 13, a$
        Delay .75
        SCREEN 0, , 0, 0
        LOCATE 24, 2, 0: COLOR 1, 1: PRINT "       ";
   CurrentIndex% = 0
EndOfSB:
SCREEN 0, , 0, 0
LOCATE 24, 2, 0: COLOR 1, 1: PRINT "       ";
TIMER ON
END SUB

SUB SearchKeys (a$)
'
' Searchs the currently avavilable menu (Header OR PullDown) for
' the keyletter that user pressed.  If you set up MenuMakr with two
' Keyletters in the same Menu/Header, this sub will return the
' first occurance ONLY, every time.  The program will still function,
' but can be very annoying to the user.  You CAN use the same selection
' keyletters in the header and the pulldown.
'                (Like QBasic does...  [Alt],[R],[R] ).
'
  a$ = UCASE$(a$)
  IF Index% < 1 THEN
        FOR i% = 1 TO UBOUND(Header$)
          x% = INSTR(Header$(i%), "&")
          IF x% > 0 THEN
          IF UCASE$(MID$(Header$(i%), x% + 1, 1)) = a$ THEN
             Selection% = i%
             Index% = 1
             EXIT SUB
           END IF
          END IF
        NEXT i%
  END IF
  IF Index% >= 1 THEN
        FOR i% = 1 TO UBOUND(PullDown$, 1)
          x% = INSTR(PullDown$(i%, Selection%), "&")
          IF x% > 0 THEN
            IF UCASE$(MID$(PullDown$(i%, Selection%), x% + 1, 1)) = a$ THEN
            Index% = i%
            Entered% = 1
            EXIT SUB
            END IF
          END IF
        NEXT i%
  END IF
END SUB

FUNCTION SelectFromMenu$
'
' Here's where all the hard work gets done...
' This function works with all the other subs to create, use and pass
' the necessary information back for use for YOU!
'
' SYNTAX:      anystring$ = SelectFromMenu$
'
' The information placed into anystring$ by this function is a simple
' coordinate string.
'
' If the user moved over two menus from the first, (the third one)
' then moved down, 6 items. the string returned would be "3-6"
' Each time the function is invoked, it returns the information in the
' same format...     "Selection-Item"     where...
' Selection = the number across.   Item = the number down.
'
' All you need to build powerful programs is to parse this information!
'
'
PCOPY 0, 1
SCREEN 0, , 1, 1
y% = 4
Selection% = 1: Index% = 0
COLOR 0, 7
LOCATE 1, 1, 0: PRINT STRING$(80, " ")
FOR i% = 1 TO UBOUND(Header$) - 1
        LOCATE 1, y%, 0
        FOR x% = 1 TO LEN(Header$(i%))
           a$ = MID$(Header$(i%), x%, 1)
           IF a$ <> "&" THEN PRINT a$;
           IF a$ = "&" THEN COLOR 15, 7 ELSE COLOR 0, 7
        NEXT x%
        y% = y% + LEN(Header$(i%)) + 1
NEXT i%

LOCATE 1, 80 - LEN(Header$(i%)), 0
        FOR x% = 1 TO LEN(Header$(i%))
           a$ = MID$(Header$(i%), x%, 1)
           IF a$ <> "&" THEN PRINT a$;
           IF a$ = "&" THEN COLOR 15, 7 ELSE COLOR 0, 7
        NEXT x%
Index% = 0
GOSUB DisplayIt
DO
        a$ = INKEY$
        IF a$ <> "" THEN GOSUB CheckTheKey: GOSUB DisplayIt

LOOP

CheckTheKey:
  SELECT CASE a$
        CASE CHR$(27): RegularMenu: EXIT FUNCTION
        CASE CHR$(13)
                IF Index% <> 0 THEN
                  SelectFromMenu$ = LTRIM$(STR$(Selection%)) + "-" + LTRIM$(STR$(Index%))
                  RegularMenu
                  EXIT FUNCTION
                END IF
                IF Index% = 0 THEN Index% = 1
        CASE CHR$(0) + CHR$(72) 'up
                IF Index% > 1 THEN Index% = Index% - 1
                IF PullDown$(Index%, Selection%) = "|" THEN Index% = Index% - 1
        CASE CHR$(0) + CHR$(77) 'right
                IF Index% > 0 THEN Index% = 1
                Selection% = Selection% + 1
                IF Selection% > UBOUND(Header$) THEN Selection% = 1
                RestoreScreen
        CASE CHR$(0) + CHR$(80) 'down
                Index% = Index% + 1
                IF Index% > UBOUND(PullDown$, 1) THEN Index% = Index% - 1
                IF PullDown$(Index%, Selection%) = "|" THEN Index% = Index% + 1
                IF PullDown$(Index%, Selection%) = "0" THEN Index% = Index% - 1
        CASE CHR$(0) + CHR$(75) 'left
                IF Index% > 0 THEN Index% = 1
                Selection% = Selection% - 1
                IF Selection% < 1 THEN Selection% = UBOUND(Header$)
                RestoreScreen
        CASE ELSE
                Entered% = 0
                SearchKeys a$
                IF Entered% = 1 THEN
                  SelectFromMenu$ = LTRIM$(STR$(Selection%)) + "-" + LTRIM$(STR$(Index%))
                  GOSUB DisplayIt
                  Delay .3
                  RegularMenu
                  EXIT FUNCTION
                END IF
        END SELECT
RETURN

DisplayIt:
        HiliteMenu Selection%
        IF Index% = 0 THEN MenuHilite (Selection%)
        IF Index% > 0 THEN PullMenu (Selection%)
RETURN
END FUNCTION

SUB ShowTime
'
'  Cuts, slices, & dices the TIME$ and alternately displays it.
'
HH% = VAL(LEFT$(TIME$, 2))
Min$ = (MID$(TIME$, 4, 2))
IF HH% >= 12 THEN pp$ = "pm" ELSE pp$ = "am"
IF HH% > 12 THEN HH% = HH% - 12
IF HH% = 0 THEN HH% = 12
Hrs$ = LTRIM$(RTRIM$(STR$(HH%)))
IF LEN(Hrs$) = 1 THEN Hrs$ = " " + Hrs$
Now$ = Hrs$ + ":" + Min$ + pp$
COLOR 0, 3
LOCATE 25, 13, 0
PRINT Now$;

END SUB

FUNCTION TextDialog$ (y1%, x1%, y2%, x2%, Stored$)
'
' Another great "must have" SUB.  It is used to input multiple rows and
' columns of text, with set start and stop parameters, and a default$.
'
'  SYNTAX:
'  ParagraphToGet$ = TextDialog$(UprRow%,LftCol%,LwrRow%,RgtCol%, Stored$)
'
'  WHERE:
'  ParagraphToGet$ is the text input to fill. - upto 32,766 charters.
'  UprRow% is the top row of the dialog window.
'  LftCol% is the left column of the dialog window.
'  LwrRow% is the bottom row of the dialog window.
'  RgtCol% is the right column of the dialog window.
'  Stored$ is the optional text to past TO the function that will  be
'          returned if the user presses "esc".
'
'   ** USER NEEDS TO KNOW THAT TO ACCEPT HE MUST PRESS [F1] **
'
Length% = x2% - x1%
Height% = y2% - y1%

REDIM Txt$(y2%)
row% = y1%: col% = x1%
Cpos% = col%: Rpos% = row%
InsMode% = 0

Khom$ = CHR$(0) + CHR$(71): Kend$ = CHR$(0) + CHR$(79)
Kdel$ = CHR$(0) + CHR$(83): Kup$ = CHR$(0) + CHR$(72)
Kdwn$ = CHR$(0) + CHR$(80): Klft$ = CHR$(0) + CHR$(75)
Krit$ = CHR$(0) + CHR$(77): Kins$ = CHR$(0) + CHR$(82)
Ktab$ = CHR$(9): Kbak$ = CHR$(8): Kent$ = CHR$(13)
KF1$ = CHR$(0) + CHR$(59): KF2$ = CHR$(0) + CHR$(60)
 
   '   KF3$ = CHR$(0) + CHR$(61): KF4$ = CHR$(0) + CHR$(62)
   '   KF5$ = CHR$(0) + CHR$(63): KF6$ = CHR$(0) + CHR$(64)
   '   KF7$ = CHR$(0) + CHR$(65): KF8$ = CHR$(0) + CHR$(66)
   '   KF9$ = CHR$(0) + CHR$(67): KF10$ = CHR$(0) + CHR$(68)
   '  KF11$ = CHR$(0) + CHR$(133): KF12$ = CHR$(0) + CHR$(134)

c% = y1% - 1
FOR i% = y1% TO y2%
        LOCATE i%, x1%, 0: PRINT STRING$(Length%, " ")
NEXT i%
FOR i% = 1 TO LEN(Stored$) STEP Length%
        c% = c% + 1
        Txt$(c%) = RTRIM$(MID$(Stored$, i%, Length%))
        LOCATE c%, x1%: PRINT Txt$(c%)
NEXT i%

LOCATE y1%, x1%, 1, 0, 31

DO
  a$ = INKEY$
  IF a$ = CHR$(27) THEN EXIT DO
  IF a$ <> "" THEN
        GOSUB FindKey
        END IF

LOOP
  TextDialog$ = Stored$: REDIM Txt$(0): EXIT FUNCTION
'--------------------------------------
FindKey:
        SELECT CASE a$
        CASE Kent$
                IF row% < y2% THEN
                  IF col% < x2% THEN
                       IF col% <= LEN(Txt$(row%)) + x1% THEN
                         Bump$ = RIGHT$(Txt$(row%), LEN(Txt$(row%)) - col% + x1%)
                       END IF
                       Txt$(row%) = LEFT$(Txt$(row%), col% - x1%)
                       FOR i% = y2% TO row% + 2 STEP -1
                           Txt$(i%) = Txt$(i% - 1)
                       NEXT i%
                       Txt$(row% + 1) = Bump$
                       FOR i% = y1% TO y2%
                         LOCATE i%, x1%: PRINT STRING$(Length%, " ");
                         LOCATE i%, x1%: PRINT Txt$(i%);
                       NEXT i%
                  END IF
                        row% = row% + 1: col% = x1%
                        Rpos% = row%: Cpos% = col%
                END IF
                IF row% = y2% THEN Chirp
                a$ = ""
        CASE Kup$
                IF row% > y1% THEN row% = row% - 1: Rpos% = Rpos% - 1
                a$ = ""
        CASE Kdwn$
                IF row% < y2% THEN row% = row% + 1: Rpos% = Rpos% + 1
                a$ = ""
        CASE Krit$
                IF col% < x2% THEN col% = col% + 1: Cpos% = Cpos% + 1
                IF col% = x2% AND row% < y2% THEN
                        col% = x1%: row% = row% + 1
                        Cpos% = x1%: Rpos% = row% + 1
                END IF
                a$ = ""
        CASE Klft$
                IF col% > x1% THEN col% = col% - 1: Cpos% = col%
                IF col% = x1% AND row% > y1% THEN
                        col% = x2%: row% = row% - 1
                        Cpos% = col%: Rpos% = row%
                END IF
                a$ = ""
        CASE Khom$
                IF col% > 1 THEN
                  FOR i% = 1 TO LEN(Txt$(row%))
                     IF MID$(Txt$(row%), i%, 1) <> " " THEN EXIT FOR
                  NEXT i%
                  col% = i% + x1% - 1: Cpos% = col%
                END IF
                a$ = ""
        CASE Kend$
                col% = x1% + LEN(Txt$(row%))
                a$ = ""
        CASE Kins$
                IF InsMode% = 0 THEN InsMode% = 1 ELSE InsMode% = 0
                a$ = ""
        CASE Kdel$
                a$ = "": Bump$ = ""
                l$ = "": r$ = ""
                IF col% = x1% AND LEN(Txt$(row%)) >= 1 THEN
                        Txt$(row%) = RIGHT$(Txt$(row%), LEN(Txt$(row%)) - 1)
                END IF
                IF col% = x1% AND LEN(Txt$(row%)) = 0 THEN
                        FOR i% = row% TO y2% - 1
                          Txt$(i%) = Txt$(i% + 1)
                        NEXT i%
                        Txt$(y2%) = ""
                       FOR i% = y1% TO y2%
                         LOCATE i%, x1%: PRINT STRING$(Length%, " ");
                         LOCATE i%, x1%: PRINT Txt$(i%);
                       NEXT i%
                END IF
                IF col% > x1% AND LEN(Txt$(row%)) > 1 THEN
                  IF col% < LEN(Txt$(row%)) + x1% THEN
                    l$ = LEFT$(Txt$(row%), col% - x1%)
                    IF col% < x2% THEN
                      r$ = RIGHT$(Txt$(row%), LEN(Txt$(row%)) - col% + x1% - 1)
                    END IF
                    Txt$(row%) = l$ + r$
                    GOTO SkipHere
                  END IF
                  IF col% >= LEN(Txt$(row%)) + x1% THEN
                    IF row% < y2% THEN
                        Txt$(row%) = Txt$(row%) + LEFT$(Txt$(row% + 1), x2% - col%)
                        Txt$(row% + 1) = MID$(Txt$(row% + 1), x2% - col% + 1)
                        IF row% < y2% - 1 THEN
                          FOR i% = row% + 2 TO y2% - 1
                            Txt$(i%) = Txt$(i% + 1)
                          NEXT i%
                        END IF
                       FOR i% = y1% TO y2%
                         LOCATE i%, x1%: PRINT STRING$(Length%, " ");
                         LOCATE i%, x1%: PRINT Txt$(i%);
                       NEXT i%
                    GOTO SkipHere
                    END IF
                  END IF
                END IF
        CASE Kbak$
                r$ = "": l$ = ""
                IF col% > x1% + LEN(Txt$(row%)) THEN
                        col% = x1% + LEN(Txt$(row%))
                        a$ = "": GOTO SkipHere
                END IF
                IF col% > x1% THEN
                   l$ = LEFT$(Txt$(row%), col% - x1% - 1)
                   IF col% < x2% THEN
                     r$ = RIGHT$(Txt$(row%), LEN(Txt$(row%)) - col% + x1%)
                   END IF
                   Txt$(row%) = l$ + r$
                 col% = col% - 1: Cpos% = col%
                 GOTO SkipHere
                END IF
                IF col% = x1% AND row% > y1% THEN
                        col% = x2%: row% = row% - 1
                        Cpos% = col%: Rpos% = row%
                END IF
                a$ = ""
        CASE Ktab$
                a$ = ""
        CASE KF1$
                a$ = "": GOTO EndOfDialog
        CASE KF2$
                a$ = ""
        CASE ELSE
                IF LEN(a$) > 1 THEN a$ = "": Chirp: RETURN
                IF col% = x2% AND row% < y2% THEN col% = x1%: row% = row% + 1
                IF col% = LEN(Txt$(row%)) + x1% AND col% < x2% THEN
                        Txt$(row%) = Txt$(row%) + a$
                        Cpos% = col%
                        col% = col% + 1
                END IF
                IF col% > LEN(Txt$(row%)) + x1% AND col% < x2% THEN
                IF a$ <> "" THEN Txt$(row%) = Txt$(row%) + STRING$(col% - x1% - LEN(Txt$(row%)), " ") + a$
                        col% = LEN(Txt$(row%)) + x1%
                        Cpos% = col% - 1
                END IF
                IF col% < LEN(Txt$(row%)) + x1% AND col% >= x1% THEN
                       IF InsMode% = 0 THEN
                        l$ = LEFT$(Txt$(row%), col% - x1%)
                        r$ = RIGHT$(Txt$(row%), LEN(Txt$(row%)) - col% + x1% - 1)
                        Txt$(row%) = l$ + a$ + r$
                        col% = col% + 1: Cpos% = col% - 1
                       END IF
                END IF
                IF col% < LEN(Txt$(row%)) + x1% AND col% >= x1% THEN
                       IF InsMode% = 1 THEN
                           l$ = LEFT$(Txt$(row%), col% - x1%)
                           r$ = RIGHT$(Txt$(row%), LEN(Txt$(row%)) - col% + x1%)
                           Txt$(row%) = l$ + a$ + r$
                           col% = col% + 1: Cpos% = col%
                           IF LEN(Txt$(row%)) > Length% THEN
                                Bump$ = RIGHT$(Txt$(row%), 1)
                                Txt$(row%) = LEFT$(Txt$(row%), Length%)
                                FOR i% = row% + 1 TO y2%
                                    Txt$(i%) = Bump$ + Txt$(i%)
                                    IF LEN(Txt$(i%)) > Length% THEN
                                        Bump$ = RIGHT$(Txt$(i%), 1)
                                        Txt$(i%) = LEFT$(Txt$(i%), Length%)
                                    ELSE EXIT FOR
                                    END IF
                                NEXT i%
                                FOR i% = y1% TO y2%
                                        LOCATE i%, x1%: PRINT STRING$(Length%, " ");
                                        LOCATE i%, x1%: PRINT Txt$(i%);
                                NEXT i%
                           END IF
                       END IF
                END IF
        END SELECT
SkipHere:
      
        LOCATE row%, x1%: PRINT STRING$(Length%, " ");
        LOCATE row%, x1%: PRINT Txt$(row%);
        IF InsMode% = 1 THEN LOCATE row%, col%, 1, 30, 31
        IF InsMode% = 0 THEN LOCATE row%, col%, 1, 0, 31

RETURN
'--------------------------------------
EndOfDialog:
l$ = ""
FOR i% = y1% TO y2%
   l$ = l$ + Txt$(i%) + STRING$(Length% - LEN(Txt$(i%)), " ")
NEXT i%
REDIM Txt$(0)
TextDialog$ = l$

END FUNCTION

