'Ŀ
'             Molnar \ Kucalaba Productions' Sound Blaster Jamz             
'                                                                           
'                 "The good programs with the dumb names"                   
'                                                                           
' ALL of the following files should be included from wherever you got this: 
'                                                                           
' 1) JAMZMAIN.BAS         Musical Composer                                  
' 2) INSMAKER.BAS         SB FM Instrument Creator v1.1                     
' 3) MKJMKR.BAS          .MKJ Music File Creator                            
' 4) MKJLDR.BAS          .MKJ Music File Loader/Player                      
' 5) INSSWP.BAS          .MKJ Music File Instrument Swapper                 
' 6) MKJNOTES.BAS        .MKJ Note Generator                                
' 7) MOBYDICK.MKJ         Sample MKJamz Music File                          
' 8) STANDARD.INS         Standard Instrument Type                          
'                                                                           
'          Various instruments (*.INS) are also in this archive.            
'                                                                           
' The MKJamz Kit is just that, a kit.  Therefore any single program should  
' be NOT be distributed alone, and if you see it happening email us and     
'                                tell us.                                   
'

'                        
'                  
'            
'       
' 
'Ŀ
'       Molnar \ Kucalaba Productions' Sound Blaster Music Format v1.1      
'                     Music Composer/Player/Debugger v1.0                   
'                                                                           
'                       Programmed by Luke Molnar.                          
'                                                                           
'This program is an *extensively* commented Sound Blaster FM Music Composer.
' Not only that, but the bottom of this program gives you the complete list 
'of commands.  Everything in this program is commented to give you the best 
'  opportunity to successfully implement 9-Channel FM Sound Blaster music.  
'  If you do compose a cool song, we would love to hear it!  Send the MKJ   
' file to us at blood225@aol.com or upload it to the incoming folder of our 
'                               FTP site.                                   
'                                                                           
'  This program is DonationWare.  Whatis DonationWare?  We're not quite     
' sure.  Read the following, and if it makes sense to you, then you know    
'what are idea of DonationWare :  You can use *any* part of *any* of the    
'programs in the MKJamz Kit for no cost.  However, if you find it worthy    
' of a small, $1-2 donation, than we will gladly accept your money. :-)     
'                                                                           
'  If you do feel inclined to send us money, send it to the following       
' address :                                                                 
'                                                                           
'                   Molnar \ Kucalaba Productions                           
'                   8225 West Calla Road                                    
'                   Canfield, OH  44406                                     
'                                                                           
'   Since you are bored enough to read this, you must have a lot of free    
'   time on your hands.  So why not spend it doing something useful, like   
'   visiting our WWW and FTP sites?  At least you can download TONS of      
'            top notch QBasic source while you are bored.                   
'                                                                           
'   Ŀ   
'           WWW : http://members.aol.com/mkwebsite/index.html             
'                                                                         
'               FTP : ftp://members.aol.com/blood225/                     
'      
'                                                                           
'
' 
'       
'            
'                  
'                        


' Procedure Declarations

DECLARE SUB LoadIns (FileName$)
DECLARE SUB PlayMusic ()
DECLARE SUB Translate (x$, Channel%)
DECLARE SUB SBInit ()
DECLARE SUB CloseChannels ()
DECLARE SUB SetIns (Channel%)
DECLARE SUB WriteReg (Reg%, value%)
DECLARE FUNCTION SpaceLess$ (x$)

CONST BasePort% = &H220 ' Change this for different sound cards

CONST MaxChannel% = 3   ' Defines how many channels you are going to use (0-9)

CONST MaxNotes% = 400   ' The amount of notes and/or commands for each channel

CONST MaxPlay% = -1     ' The number of times you play the song.
                        ' -1 to keep looping through.


' Instrument-type.  For your convenience, use the MKJamz Instrument Creator.
' After all, that's what it's there for.
TYPE InsType
 MMult AS INTEGER     ' Modulator's Multiple
 MLevel AS INTEGER    ' Modulator's Level
 MAttack AS INTEGER   ' Modulator's Attack
 MSustain AS INTEGER  ' Modulator's Sustain
 CMult AS INTEGER     ' Carrier's Multiple
 CLevel AS INTEGER    ' Carrier's Level
 CAttack AS INTEGER   ' Carrier's Attack
 CSustain AS INTEGER  ' Carrier's Sustain
END TYPE


' This buffer holds the current channel information.
TYPE ChannelType
 Defined AS INTEGER   ' Has the user defined the channel and it's notes? (1 if yes)
 Speed AS SINGLE      ' The duration of each note
 SongPtr AS INTEGER   ' A pointer to the current song position
 PStat AS SINGLE      ' Pause counter 2
 Octave AS INTEGER    ' The Octave of each channel
 WaveForm AS INTEGER  ' The Wave Form of each channel
 Flag AS INTEGER      ' Misc control flag
 Flag2 AS INTEGER     ' Number of times to play song
 IsPlaying AS INTEGER ' Is a note playing (1=yes)
 IsDone AS INTEGER    ' Has the note stopped? (1=yes)
END TYPE



DIM SHARED ChannelStat(1 TO MaxChannel%) AS ChannelType ' Allocate a buffer
                                  ' for holding the status of each channel.

DIM SHARED Songbuf(1 TO (MaxChannel% + 1) * MaxNotes%) AS INTEGER' Allocate a
                           ' buffer or holding nearly all the music data.

DIM SHARED CurrentIns AS InsType ' We use this buffer for loading and setting FM
                                 ' instrument types.

CLS                         ' Clear the screen

SBInit                      ' Initialize the Sound Blaster


' {musical composing part below}

' This is a string of music commands that will be played in channel one.
' The commands were made to be nearly identical to PLAY.  Read the bottom
' of the main module of this program for a complete list of commands.

Channel1$ = "t(.2) cdefgabagfed"


CALL Translate(Channel1$, 1)

' Use the Translate routine to change that string into musical commands.
' The second parameter, "1", is the channel number to assign the
' string to.

' {music composing part above}


Channel2$ = "T(.29) o3 cd o2 dc o3 cd o2 dc"
CALL Translate(Channel2$, 2)

Channel3$ = "T(.20) bagab p(.5)"
'CALL Translate(Channel3$, 3)


LoadIns "standard.ins"      ' Load the standard instrument
SetIns 1                    ' Set the first channel as guitar

LoadIns "trumpet.ins"       ' Load the trumpet instrument
SetIns 2                    ' Set the second channel as trumpet

LoadIns "elecbass.ins"      ' Load the electric bass instrument
SetIns 3                    ' Set the third channel as electric bass


PRINT "Now playing Sound Blaster music..."


DO

 PlayMusic  ' This routine updates the music


LOOP UNTIL INKEY$ <> ""    ' Loop until user presses a key.

 
CloseChannels     ' Close all channels and then clear
SBInit            ' everything to leave the SB how we found it.
                  
'Ŀ
'                   How to Make this Program Work for YOU                   
'                                                                           
'                      i.e. Programming Instructions                        
'                                                                           
'                                                                           
'  If you are totally lost on using this, read all of this many times until 
'     you either figure out how to use it or you lose all interest in it.   
'                                                                           
'   First off, you need to decide how many channels you want to use.  The   
' maximum is 9 and the minimum is 1.  If you want no channels to play, then 
' you have a problem.  You can change the amount of channels by editing the 
'                                                                           
' CONST MaxChannel% = 4                                                     
'                                                                           
'  line.  Next, you have to decide how many notes and musical commands you  
'want for your song.  (The number is per-track, not total.)  For default, we
' use 100, which is plenty enough.  However, if you feel inclined to change 
'               it, go right ahead by editing the line :                    
'                                                                           
' CONST MaxNotes% = 100                                                     
'                                                                           
' You can also define how many times you want the song to be played by      
' editing the line :                                                        
'                                                                           
' CONST MaxPlay% = -1          ' (-1 Means loop song forever)               
'                                                                           
'  After that, the next step is to write up the music you want to play.  To 
'simplify this, we made it very similar to the PLAY command.  It follows the
' basic CDEFGAB set, but the musical commands are totally different, so read
'                   the bottom of this to learn them.                       
'                                                                           
'  To use a musical command, insert it into the Note String.  The Note      
'                       String looks like this :                            
'                                                                           
'   Notes$ = "CDEFGAB"                                                      
'                                                                           
' "CDEFGAB" is the Note String                                              
'                                                                           
'  But just having that string isn't going to do you any good.  You need to 
'        define the Note String as the Channel Music.  This has been               
'                greatly simplified by MKJamz.  Just type :                 
'                                                                           
' CALL Translate(Notes$, 1)                                                 
'                                                                           
'   You might wonder what on Earth the "1" is.  "1" represents the Channel  
' Number.  So the above statements would set "CDEFGAB" as the notes to play 
' from Channel 1.  Note that the above does not actually play any music, but
'                         it puts you in position to.                       
'                                                                           
' This is all nice and good, but you still need to tell the sound card what 
' kind of instrument you want to use for each channel.  Do this by typing:  
'                                                                           
' LoadIns "guitar.ins"                                                      
' SetIns 1                                                                  
'                                                                           
' That will load the guitar instrument and set the first channel to play    
' music as the guitar.  Note that these are FM instruments and not digitized
' sound samples, so they won't sound exactly like a real guitar.  For help  
'  on creating your very own Instruments, check out the M \ K Instrument    
' Creator v1.0.  It should help you considerably.  Also, you MUST set the   
' channel before Loading another instrument since all the instrument data   
'              just goes into the same buffer anyways.                      
'                                                                           
' Ok, after you have written the notes, designated the channel to play the  
' notes, and defined what the channel will sound like, you are ready to play
' some music!  To update the music, simply type                             
'                                                                           
' PlayMusic                                                                 
'                                                                           
' But since that routine was written with other things in mind, it will only
'play one set of notes per channel.  So, to play the entire song, over and  
'                             over, type this:                              
'                                                                           
' DO                                                                        
'  PlayMusic                                                                
' LOOP                                                                      
'                                                                           
'                           It's just that easy.                            
'                                                                           
'******************* List of Musical Command Syntax Stuff ******************
'                                                                           
' Tempo : Sets the length of each note.  Syntax :  T(###) where ### is a    
'            small number that is based on a second elapsing.               
' Example :             Note$ = " T(.25) CDEFGAB"                           
'                                                                           
'                                                                           
' Pause : Pauses the current channel for X seconds.  Syntax : P(###)        
' Example :             Note$ = " T(.25) CDEFGAB P(1.2) AGFEDC"             
'                                                                           
'                                                                           
' Octave : Defines the current note octave (0-7)  Syntax : Ox               
'          where x is the octave number.                                    
' Example :             Note$ = " T(.25) O4 CDEFGAB"                        
'                                                                           
'                                                                           
' Wave Form : Changes the current waveform (0-??) Syntax : W(xx)            
'             where xx is an integer.                                       
' Example :             Note$ = " T(.25) W(28) CDEFGAB"                     
'                                                                           
'                                                                           
' End of Song : End the song currently playing.  Syntax  : "X"                                                       
'               You are strongly encouraged to use this command.                                       
'                       Note$ = " T(.25) CDEFGAB X"                                 
'


' ----- List of special Song Buffer control codes ------
'  255  = Pause, the integer following contains the duration of the pause
'         multiplied by 100.
'  254  = Octave, the integer following is the new octave numeral
'  253  = Tempo, the integer following is the duration times 100
'  252  =  Wave form, the integer following is the new waveform

SUB CloseChannels
IF MaxChannel% > 4 THEN FirstLoop% = 3 ELSE FirstLoop% = MaxChannel%
 FOR Channel% = 0 TO FirstLoop%
  WriteReg &HB0 + Channel%, 0
 NEXT
 IF FirstLoop% = MaxChannel% THEN EXIT SUB
 FOR Channel% = Channel% TO MaxChannel%
  WriteReg &HB0 + Channel% + 5, 0
 NEXT
END SUB

SUB LoadIns (FileName$)
OPEN FileName$ FOR BINARY AS #1
 IF LOF(1) < 2 THEN
  BEEP
  CLOSE
  KILL FileName$
  EXIT SUB
 END IF
 GET #1, , CurrentIns
CLOSE #1
END SUB

SUB PlayMusic

FOR Channel% = 1 TO MaxChannel%

  IF ChannelStat(Channel%).Defined = 0 THEN GOTO NoGotosPlease

  RChan% = Channel% - 1

  IF ChannelStat(Channel%).IsDone = 1 THEN
   ChannelStat(Channel%).PStat = TIMER + ChannelStat(Channel%).Speed
   ChannelStat(Channel%).SongPtr = ChannelStat(Channel%).SongPtr + MaxChannel%
   ChannelStat(Channel%).IsDone = 0
   ChannelStat(Channel%).IsPlaying = 0
  END IF

   IF ChannelStat(Channel%).IsPlaying = 0 AND Songbuf(ChannelStat(Channel%).SongPtr + Channel% - 1) <> 0 THEN
    ChannelStat(Channel%).PStat = TIMER + ChannelStat(Channel%).Speed
     SELECT CASE Songbuf(ChannelStat(Channel%).SongPtr + RChan%)
       CASE 68   ' "D"
         WriteReg &HA0 + RChan%, &H81
         WriteReg &HB0 + RChan%, &H21 + 4 * ChannelStat(Channel%).Octave
       CASE 69   ' "E"
         WriteReg &HA0 + RChan%, &HB0
         WriteReg &HB0 + RChan%, &H21 + 4 * ChannelStat(Channel%).Octave
       CASE 70   ' "F"
         WriteReg &HA0 + RChan%, &HCA
         WriteReg &HB0 + RChan%, &H21 + 4 * ChannelStat(Channel%).Octave
       CASE 71    ' "G"
         WriteReg &HA0 + RChan%, &H2
         WriteReg &HB0 + RChan%, &H22 + 4 * ChannelStat(Channel%).Octave
       CASE 65 ' "A"
         WriteReg &HA0 + RChan%, &H41
         WriteReg &HB0 + RChan%, &H22 + 4 * ChannelStat(Channel%).Octave
       CASE 66   ' "B"
         WriteReg &HA0 + RChan%, &H87
         WriteReg &HB0 + RChan%, &H22 + 4 * ChannelStat(Channel%).Octave
       CASE 67  '  "C"
         WriteReg &HA0 + RChan%, &HAE
         WriteReg &HB0 + RChan%, &H22 + 4 * ChannelStat(Channel%).Octave
       CASE 17 ' "C#"
         WriteReg &HA0 + RChan%, &H6B
         WriteReg &HB0 + RChan%, &H21 + 4 * ChannelStat(Channel%).Octave
       CASE 18 ' "D#"
         WriteReg &HA0 + RChan%, &H98
         WriteReg &HB0 + RChan%, &H21 + 4 * ChannelStat(Channel%).Octave
       CASE 20 ' F#"
         WriteReg &HA0 + RChan%, &HE5
         WriteReg &HB0 + RChan%, &H21 + 4 * ChannelStat(Channel%).Octave
       CASE 21 ' "G#"
         WriteReg &HA0 + RChan%, &H20
         WriteReg &HB0 + RChan%, &H22 + 4 * ChannelStat(Channel%).Octave
       CASE 15 ' "A#"
         WriteReg &HA0 + RChan%, &H63
         WriteReg &HB0 + RChan%, &H22 + 4 * ChannelStat(Channel%).Octave
        
       CASE 255
         ChannelStat(Channel%).IsPlaying = 1
         ChannelStat(Channel%).PStat = TIMER + Songbuf(ChannelStat(Channel%).SongPtr + Channel% - 1 + MaxChannel%) / 100
         ChannelStat(Channel%).Flag = -1
       CASE 254
         ChannelStat(Channel%).Octave = Songbuf(ChannelStat(Channel%).SongPtr + Channel% - 1 + MaxChannel%)
         ChannelStat(Channel%).SongPtr = ChannelStat(Channel%).SongPtr + MaxChannel%
       CASE 253
         ChannelStat(Channel%).Speed = Songbuf(ChannelStat(Channel%).SongPtr + Channel% - 1 + MaxChannel%) / 100
         ChannelStat(Channel%).SongPtr = ChannelStat(Channel%).SongPtr + MaxChannel%
       CASE 252
         ChannelStat(Channel%).WaveForm = Songbuf(ChannelStat(Channel%).SongPtr + Channel% - 1 + MaxChannel%) - 300
         ChannelStat(Channel%).SongPtr = ChannelStat(Channel%).SongPtr + MaxChannel%
         IF RChan% > 2 THEN RRChan% = RChan% + 6 ELSE RRChan% = 0
         WriteReg &HE0 + RChan% + RRChan%, ChannelStat(Channel%).WaveForm
       CASE 251
         ChannelStat(1).Flag2 = -1
          FOR MaxChan% = 1 TO MaxChannel%
           ChannelStat(MaxChan%).SongPtr = 1
           ChannelStat(MaxChan%).IsPlaying = 0
           ChannelStat(MaxChan%).IsDone = 0
          NEXT
         CloseChannels
         EXIT SUB
     END SELECT
   END IF

    IF ChannelStat(Channel%).IsPlaying = 1 THEN
     IF TIMER >= ChannelStat(Channel%).PStat THEN
      WriteReg &HB0 + RChan%, 0
      ChannelStat(Channel%).IsDone = 1
       IF ChannelStat(Channel%).Flag = -1 THEN
        ChannelStat(Channel%).SongPtr = ChannelStat(Channel%).SongPtr + MaxChannel%
        ChannelStat(Channel%).Flag = 0
       END IF
     END IF
    END IF
   
   IF ChannelStat(Channel%).SongPtr > MaxChannel% + 1 THEN
     IF Songbuf(ChannelStat(Channel%).SongPtr + RChan%) <> 0 AND Songbuf(ChannelStat(Channel%).SongPtr - MaxChannel% + RChan%) < 250 THEN
       IF ChannelStat(Channel%).IsPlaying = 0 THEN ChannelStat(Channel%).IsPlaying = 1
     END IF
   END IF

NoGotosPlease:
NEXT Channel%


FOR Channel% = 1 TO MaxChannel%

 IF ChannelStat(Channel%).IsPlaying = 0 THEN
  ChannelStat(Channel%).SongPtr = ChannelStat(Channel%).SongPtr + MaxChannel%
  IF ChannelStat(Channel%).SongPtr >= UBOUND(Songbuf) / MaxChannel% THEN
   ChannelStat(Channel%).SongPtr = 1
  END IF
 END IF
NEXT Channel%

END SUB

SUB SBInit
   FOR z% = 1 TO &HF5
     CALL WriteReg(z%, 0)
   NEXT z%
END SUB

SUB SetIns (Channel%)
' Sets the Current Instrument.
CarChan% = Channel% - 1

IF Channel% > 3 THEN CarChan% = CarChan% + 5
IF Channel% > 6 THEN CarChan% = CarChan% + 5


WriteReg &H20 + CarChan%, CurrentIns.CMult  'Plays carrier note at specified octave ch. 1
WriteReg &H23 + CarChan%, CurrentIns.MMult  'Plays modulator note at specified octave ch. 1
WriteReg &H40 + CarChan%, CurrentIns.CLevel   'Set carrier total level to softest ch. 1
WriteReg &H43 + CarChan%, CurrentIns.MLevel   'Set modulator level to loudest ch. 1
WriteReg &H60 + CarChan%, CurrentIns.CAttack  'Set carrier attack and decay ch. 1
WriteReg &H63 + CarChan%, CurrentIns.MAttack  'Set modulator attack and decay ch. 1
WriteReg &H80 + CarChan%, CurrentIns.CSustain 'Set carrier sustain and release ch. 1
WriteReg &H83 + CarChan%, CurrentIns.MSustain 'Set modulator sustain and release ch. 1

END SUB

FUNCTION SpaceLess$ (x$)
' Removes all spaces from a string
FOR c% = 1 TO LEN(x$)
 IF MID$(x$, c%, 1) <> " " THEN k$ = k$ + MID$(x$, c%, 1)
NEXT
SpaceLess$ = UCASE$(k$)
END FUNCTION

SUB Translate (x$, Channel%)

ChannelStat(Channel%).SongPtr = 1   ' These values are all just
ChannelStat(Channel%).Octave = 4    ' back ups if the user never defines
ChannelStat(Channel%).Speed = .25   ' them.
ChannelStat(Channel%).WaveForm = 2
IF Channel% > 3 THEN RChan% = Channel% + 4
WriteReg &HE0 + RChan%, 2

TempBuf! = 0       ' We'll use a temporary single precision value in parsing
TempBuffer% = 0    ' ...as well as a temporary integer.
Temp$ = ""         ' ...as well as a temporary string.

x$ = SpaceLess(x$) ' Remove all spaces from the string

FOR StringLen% = 1 TO LEN(x$)
  CurCommand$ = MID$(x$, StringLen%, 1)
  
    SELECT CASE CurCommand$

      CASE "T":  ' Duration command was issued
                Temp$ = ""
                IF MID$(x$, StringLen% + 1, 1) <> "(" THEN
                  PRINT "Invalid duration command issued :  No control parenthesis! (  )"
                  END
                END IF
                TempBuffer% = 2
                DO UNTIL MID$(x$, StringLen% + TempBuffer%, 1) = ")"
                 Temp$ = Temp$ + MID$(x$, StringLen% + TempBuffer%, 1)
                 TempBuffer% = TempBuffer% + 1
                LOOP
                StringLen% = StringLen% + TempBuffer%
                TempBuf! = VAL(Temp$)
                Songbuf(Channel% + ChannelStat(Channel%).SongPtr - 1) = 253
                Songbuf(Channel% + ChannelStat(Channel%).SongPtr - 1 + MaxChannel%) = TempBuf! * 100
                ChannelStat(Channel%).SongPtr = ChannelStat(Channel%).SongPtr + MaxChannel%
      
       CASE "X": ' Exit song command was issued
                Songbuf(Channel% + ChannelStat(Channel%).SongPtr - 1) = 251
       CASE "W": ' Wave Form command was issued
                Temp$ = ""
                IF MID$(x$, StringLen% + 1, 1) <> "(" THEN
                  PRINT "Invalid wave form command issued :  No control parenthesis! (  )"
                  END
                END IF
                TempBuffer% = 2
                DO UNTIL MID$(x$, StringLen% + TempBuffer%, 1) = ")"
                 Temp$ = Temp$ + MID$(x$, StringLen% + TempBuffer%, 1)
                 TempBuffer% = TempBuffer% + 1
                LOOP
                StringLen% = StringLen% + TempBuffer%
                Songbuf(Channel% + ChannelStat(Channel%).SongPtr - 1) = 252
                Songbuf(Channel% + ChannelStat(Channel%).SongPtr - 1 + MaxChannel%) = VAL(Temp$) + 300
                ChannelStat(Channel%).SongPtr = ChannelStat(Channel%).SongPtr + MaxChannel%

       CASE "P": ' Pause command was issued
                Temp$ = ""
                IF MID$(x$, StringLen% + 1, 1) <> "(" THEN
                  PRINT "Invalid pause command issued :  No control parenthesis! (  )"
                  END
                END IF
                TempBuffer% = 2
                DO UNTIL MID$(x$, StringLen% + TempBuffer%, 1) = ")"
                 Temp$ = Temp$ + MID$(x$, StringLen% + TempBuffer%, 1)
                 TempBuffer% = TempBuffer% + 1
                LOOP
                StringLen% = StringLen% + TempBuffer%
                TempBuf! = VAL(Temp$)
                Songbuf(Channel% + ChannelStat(Channel%).SongPtr - 1) = 255
                Songbuf(Channel% + ChannelStat(Channel%).SongPtr - 1 + MaxChannel%) = TempBuf! * 100
                ChannelStat(Channel%).SongPtr = ChannelStat(Channel%).SongPtr + MaxChannel%
        
         ' An octave command was issued
         CASE "O": Temp$ = MID$(x$, StringLen% + 1, 1)
                   Songbuf(Channel% + ChannelStat(Channel%).SongPtr - 1) = 254
                   Songbuf(Channel% + ChannelStat(Channel%).SongPtr - 1 + MaxChannel%) = VAL(Temp$)
                   StringLen% = StringLen% + 1
                   ChannelStat(Channel%).SongPtr = ChannelStat(Channel%).SongPtr + MaxChannel%

      ' A note command was issued
      CASE "C", "D", "E", "F", "G", "A", "B":
      IF MID$(x$, StringLen% + 1, 1) <> "#" THEN
       Songbuf(Channel% + ChannelStat(Channel%).SongPtr - 1) = ASC(CurCommand$)
      ELSE
       Songbuf(Channel% + ChannelStat(Channel%).SongPtr - 1) = ASC(CurCommand$) - 50
       StringLen% = StringLen% + 1
      END IF

    END SELECT

ChannelStat(Channel%).SongPtr = ChannelStat(Channel%).SongPtr + MaxChannel%
NEXT

ChannelStat(Channel%).Defined = 1

END SUB

DEFINT A-Z
SUB WriteReg (Reg%, value%)

 OUT BasePort% + 8, Reg%
  FOR x% = 0 TO 5
     Buf% = INP(BasePort% + 8)
   NEXT
 OUT BasePort% + 9, value%
   FOR x% = 0 TO 33
     Buf% = INP(BasePort% + 9)
   NEXT

END SUB

