;---------------------------------------------------------------------------
;   Filename: MTimerA.asm
;      Title: MTimer ASM Routines
;     Author: Peter Fedorow
;  Copyright: 2003 Peter Fedorow
;    Started: 2003 May 26 Mon
;Last Change: 2003 May 27 Tue
;    License: GNU LGPL - See LGPL.TXT
;    History: 2003 May 26 Mon  Adapted from compiler listing.
;---------------------------------------------------------------------------

.MODEL MEDIUM, BASIC

.DATA
  
;  True              DW  -1    ;True%
;  False             DW  0     ;False%


.DATA?

.CODE

;---------------------------------------------------------------------------
;SUB PITReadTicks (TicksHi, TicksLo)
PUBLIC PITReadTicks
PITReadTicks PROC Far TicksHi:word, TicksLo:word

  ;PIT 8253 Mode Control register.
  ;Select Counter 0
  ;Latch present counter value
  ;Mode 0: Countdown, interrupt, then wait for new mode/count
  
  ;Disable interrupts.
  CLI

  ;OUT &H43, &H0
  xor     ax,ax
  out     0043h,al
  
  ;PIT ticks.
  ;TicksHi = INP(&H40) 'High byte.
  in      al,0040h
  mov     bx,TicksHi
  mov     [bx],ax
  
  ;TicksLo = INP(&H40) 'Low byte.
  in      al,0040h
  mov     bx,TicksLo
  mov     [bx],ax

  ;Reenable interrupts.
  STI
  
  ;END SUB
  ret

PITReadTicks ENDP

;---------------------------------------------------------------------------


END



