CONST PSET12 = 0, AND12 = 8, OR12 = 16, XOR12 = 24
CONST Normal = 0, HFlip = 1, VFlip = 2, VHFlip = 3
CONST Rotate90 = 4, Rotate180 = 5
'=============================================================================
' SCREEN 12 COMMANDS AND FUNCTIONS
'=============================================================================
DECLARE SUB Set12 CDECL ALIAS "Set_12" (BYVAL X%, BYVAL Y%, BYVAL C%, BYVAL T%)
DECLARE FUNCTION Point12% CDECL ALIAS "Point_12" (BYVAL X%, BYVAL Y%)
DECLARE SUB Line12 CDECL ALIAS "Line_12" (BYVAL X%, BYVAL Y%, BYVAL X2%, BYVAL Y2%, BYVAL C%, BYVAL T%)
DECLARE SUB Circle12 CDECL ALIAS "Circle_12" (BYVAL X%, BYVAL Y%, BYVAL R%, BYVAL C%, BYVAL T%)
DECLARE SUB HLine12 CDECL ALIAS "HLine_12" (BYVAL X%, BYVAL Y%, BYVAL L%, BYVAL C%, BYVAL T%)
DECLARE SUB VLine12 CDECL ALIAS "VLine_12" (BYVAL X%, BYVAL Y%, BYVAL H%, BYVAL C%, BYVAL T%)
DECLARE SUB Frame12 CDECL ALIAS "Frame_12" (BYVAL X%, BYVAL Y%, BYVAL L%, BYVAL W%, BYVAL C%, BYVAL T%)
DECLARE SUB Box12 CDECL ALIAS "Box_12" (BYVAL X%, BYVAL Y%, BYVAL L%, BYVAL W%, BYVAL C%, BYVAL T%)
DECLARE SUB Clear12 CDECL ALIAS "Clear_12" ()
'=============================================================================
DECLARE SUB GetBMP CDECL ALIAS "Get_BMP" (SEG Image AS ANY, SEG Pal AS ANY, FileName$)
DECLARE SUB BMPSize CDECL ALIAS "BMP_Size" (FileName$, Wdth%, Hght%)
DECLARE SUB ReadPalette CDECL ALIAS "Read_Palette" (SEG Pal AS ANY)
DECLARE SUB BMP12 CDECL ALIAS "BMP_12" (BYVAL X%, BYVAL Y%, FileName$, BYVAL T%, BYVAL A%)
'-----------------------------------------------------------------------------
DECLARE SUB SetUp8x16 CDECL ALIAS "Set_Up_8x16" ()
DECLARE SUB SetUp8x8 CDECL ALIAS "Set_Up_8x8" ()
DECLARE SUB SetUpFonts CDECL ALIAS "Set_Up_Fonts" ()
DECLARE SUB SetFontSize CDECL ALIAS "Set_Font_Size" (BYVAL NewSize%)
DECLARE SUB FontLocate CDECL ALIAS "Font_Locate" (BYVAL X%, BYVAL Y%)
DECLARE SUB NewColor CDECL ALIAS "NewColor" (BYVAL NColor%)
DECLARE SUB PrintCharacter CDECL ALIAS "Print_Character" (BYVAL ASCII%, BYVAL T%, BYVAL A%)
DECLARE SUB Text CDECL ALIAS "Text" (TextOff$, BYVAL T%, BYVAL A%)
DECLARE SUB WordWrap CDECL ALIAS "Word_Wrap" (TextOff$, BYVAL T%, BYVAL A%)
DECLARE SUB NewLine CDECL ALIAS "NewLine" ()
DECLARE SUB CarrageReturn CDECL ALIAS "Carrage_Return" ()
DECLARE SUB LineFeed CDECL ALIAS "Line_Feed" ()
'-----------------------------------------------------------------------------
DECLARE SUB ScrollScreenUp CDECL ALIAS "ScrollScreenUp" (BYVAL NoOfTimes%)
DECLARE SUB ScrollScreenDown CDECL ALIAS "ScrollScreenDown" (BYVAL NoOfTimes%)
'-----------------------------------------------------------------------------
DECLARE SUB Save12 CDECL ALIAS "Save_12" (FileName AS STRING)
DECLARE SUB Load12 CDECL ALIAS "Load_12" (FileName AS STRING)
'-----------------------------------------------------------------------------
DECLARE SUB RotatePaletteDown CDECL ALIAS "Rotate_Palette_Down" (BYVAL T%)
DECLARE SUB RotatePaletteUp CDECL ALIAS "Rotate_Palette_Up" (BYVAL T%)
DECLARE SUB SavePalette CDECL ALIAS "Save_Palette" (FileName AS STRING)
DECLARE SUB LoadPalette CDECL ALIAS "Load_Palette" (FileName AS STRING)
DECLARE SUB FadePalette CDECL ALIAS "Fade_Palette" (BYVAL NoOfTimes%)
DECLARE SUB BrightenPalette CDECL ALIAS "Brighten_Palette" (BYVAL NoOfTimes%)
DECLARE SUB ColorEquate CDECL ALIAS "Color_Equate" (BYVAL C1%, BYVAL C2%)
'-----------------------------------------------------------------------------
DECLARE SUB Mouse12 CDECL ALIAS "Mouse_12" ()
DECLARE FUNCTION MColor% CDECL ALIAS "M_Color" ()
DECLARE SUB MouseOn CDECL ALIAS "Mouse_On" ()
DECLARE SUB MouseOff CDECL ALIAS "Mouse_Off" ()
DECLARE SUB Uninstall12 CDECL ALIAS "Uninstall_12" ()
DECLARE SUB NewMouseCursor CDECL ALIAS "New_Mouse_Cursor" (BYVAL NewSeg%, BYVAL NewOff%)
DECLARE SUB RestoreCursor CDECL ALIAS "Restore_Cursor" ()
'-----------------------------------------------------------------------------
DECLARE SUB VirtualScreen CDECL ALIAS "Virtual_Screen" (BYVAL ScreenSize%)
DECLARE SUB PanUp CDECL ALIAS "Pan_Up" (BYVAL NoOfTimes%)
DECLARE SUB PanDown CDECL ALIAS "Pan_Down" (BYVAL NoOfTimes%)
DECLARE SUB PanLeft CDECL ALIAS "Pan_Left" (BYVAL NoOfTimes%)
DECLARE SUB PanRight CDECL ALIAS "Pan_Right" (BYVAL NoOfTimes%)
CONST S640x819 = 40: CONST S656x799 = 41: CONST S672x780 = 42
CONST S688x762 = 43: CONST S704x744 = 44: CONST S720x728 = 45
CONST S736x712 = 46: CONST S752x697 = 47: CONST S768x682 = 48
CONST S784x668 = 49: CONST S800x655 = 50: CONST S816x642 = 51
CONST S832x630 = 52: CONST S848x618 = 53: CONST S864x606 = 54
CONST S880x595 = 55: CONST S896x585 = 56: CONST S912x574 = 57
CONST S928x564 = 58: CONST S944x555 = 59: CONST S960x546 = 60
CONST S976x537 = 61: CONST S992x528 = 62: CONST S1008x520 = 63
CONST S1024x512 = 64: CONST S1040x504 = 65: CONST S1056x496 = 66
CONST S1072x489 = 67: CONST S1088x481 = 68
'-----------------------------------------------------------------------------
DECLARE SUB Get12 CDECL ALIAS "Get_12" (BYVAL X%, BYVAL Y%, BYVAL L%, BYVAL W%, SEG A AS ANY)
DECLARE SUB Put12 CDECL ALIAS "Put_12" (BYVAL X%, BYVAL Y%, BYVAL UC%, SEG Array AS ANY, BYVAL T%, BYVAL A%)
DECLARE SUB SPut12 CDECL ALIAS "SPut_12" (BYVAL X%, BYVAL Y%, BYVAL L%, BYVAL W%, BYVAL UC%, SEG A AS ANY, BYVAL T%)
'-----------------------------------------------------------------------------

