'
' NeoLib - Long FileName Module
'
' Features:
'  6 subs
'  5 functions
' For a total of: 11 routines
'
' Specially designed and coded for AAP's QBCPC
' Official Library of the QuickBASIC Caliber Programming Compo (Summer & Autumn 2003)
'
' Warning! Requires Windows active to use
'

DECLARE FUNCTION neoLFNgetCurrDir$ ()
DECLARE FUNCTION neoLFNgetFullPath$(FileName AS STRING)
DECLARE FUNCTION neoLFNgetShortPath$(FileName AS STRING)
DECLARE FUNCTION neoLFNshortFileName$(LongFileName AS STRING)
DECLARE FUNCTION neoLFNgetFileSystem$(DriveLetter AS STRING)

DECLARE SUB neoLFNmakeDir(DirName AS STRING)
DECLARE SUB neoLFNremoveDir(DirName AS STRING)
DECLARE SUB neoLFNchangeDir(DirName AS STRING)
DECLARE SUB neoLFNrenameDir(DirName AS STRING, NewDirName AS STRING)
DECLARE SUB neoLFNdeleteFile(FileName AS STRING)
DECLARE SUB neoLFNrenameFile(FileName AS STRING, NewFileName AS STRING)

DEFINT A-Z
'$DYNAMIC
'$INCLUDE: 'QB.BI'

'/////////////////////////////////////////////////////////////////////////////
' FUNCTIONS
'/////////////////////////////////////////////////////////////////////////////
FUNCTION neoLFNgetCurrDir$
	'gets the current directory

	'use int 21h, ax=7147
        DIM Regs AS RegTypeX, CurrDir AS STRING * 256
        Regs.ax = &H7147
        Regs.dx = 0
        Regs.ds = VARSEG(CurrDir)
        Regs.si = VARPTR(CurrDir)
        INTERRUPTX &H21, Regs, Regs
        Null = INSTR(CurrDir, CHR$(0))
        IF Null <> 0 THEN neoLFNgetCurrDir$ = LEFT$(CurrDir, Null - 1) ELSE neoLFNgetCurrDir$ = CurrDir
END FUNCTION

FUNCTION neoLFNgetFullPath$ (FileName AS STRING)
	'gets the full path of a file
	'- FileName: file to get the full path of

	'use int 21h, ax=7160, cx=0
        DIM Regs AS RegTypeX, NameBuffer AS STRING * 261
        Regs.ax = &H7160
        Regs.cx = &H0000
        FileNameZ$ = FileName + CHR$(0)
        Regs.ds = VARSEG(FileNameZ$)
        Regs.si = SADD(FileNameZ$)
        Regs.es = VARSEG(NameBuffer)
        Regs.di = VARPTR(NameBuffer)
        INTERRUPTX &H21, Regs, Regs
        Null = INSTR(NameBuffer, CHR$(0))
        IF Null > 0 THEN neoLFNgetFullPath$ = LEFT$(NameBuffer, Null - 1) ELSE neoLFNgetFullPath$ = NameBuffer
END FUNCTION

FUNCTION neoLFNgetShortPath$ (FileName AS STRING)
	'gets the short path of a file
	'- FileName: file to get the short path of

	'use int 21h, ax=7160, cx=1
        DIM Regs AS RegTypeX, NameBuffer AS STRING * 67
        Regs.ax = &H7160
        Regs.cx = 1
       	FileNameZ$ = FileName + CHR$(0)
        Regs.ds = VARSEG(FileNameZ$)
        Regs.si = SADD(FileNameZ$)
        Regs.es = VARSEG(NameBuffer)
        Regs.di = VARPTR(NameBuffer)
        INTERRUPTX &H21, Regs, Regs
        Null = INSTR(NameBuffer, CHR$(0))
        IF Null > 0 THEN neoLFNgetShortPath$ = LEFT$(NameBuffer, Null - 1) ELSE neoLFNgetShortPath$ = NameBuffer
END FUNCTION

FUNCTION neoLFNshortFileName$ (LongFileName AS STRING)
	'gets the short filename of a long file name
	'- LongFileName: filename to get the short file name of

	'use int 21h, ax=71A8
        DIM Regs AS RegTypeX, FBuffer AS STRING * 13
        Regs.ax = &H71A8
        LFNZ$ = LongFileName + CHR$(0)
        Regs.ds = VARSEG(LFNZ$)
        Regs.si = SADD(LFNZ$)
	Regs.es = VARSEG(FBuffer)
	Regs.di = VARPTR(FBuffer)
        Regs.dx = &H0111
        INTERRUPTX &H21, Regs, Regs
        Null = INSTR(FBuffer, CHR$(0))
        IF Null <> 0 THEN neoLFNshortFileName$ = LEFT$(FBuffer, Null - 1) ELSE neoLFNshortFileName$ = FBuffer
END FUNCTION

FUNCTION neoLFNgetFileSystem$ (DriveLetter AS STRING)
	'gets the filesystem of a drive (FAT32, NTFS, FAT, FAT16, CDFS, etc)
	'- DriveLetter: one character, which is the drive to get the filesystem of

	'use int 21h, ax=71A0
	DIM Regs AS RegTypeX, FS AS STRING * 32
        Regs.ax = &H71A0
        RootDirZ$ = DriveLetter + ":\" + CHR$(0)
        Regs.ds = VARSEG(RootDirZ$)
        Regs.dx = SADD(RootDirZ$)
        Regs.es = VARSEG(FS)
        Regs.di = VARPTR(FS)
        Regs.cx = 32
        INTERRUPTX &H21, Regs, Regs
        Null = INSTR(FS, CHR$(0))
        IF Null > 0 THEN neoLFNgetFileSystem$ = LEFT$(FS, Null - 1) ELSE neoLFNgetFileSystem$ = FS
END FUNCTION

'/////////////////////////////////////////////////////////////////////////////
' SUBS
'/////////////////////////////////////////////////////////////////////////////
SUB neoLFNmakeDir (DirName AS STRING)
	'makes a directory
	'- DirName: the name of the directory to make

	'use int 21h, ax=7139
        DIM Regs AS RegTypeX
        Regs.ax = &H7139
        DirNameZ$ = DirName + CHR$(0)
        Regs.ds = VARSEG(DirNameZ$)
        Regs.dx = SADD(DirNameZ$)
        INTERRUPTX &H21, Regs, Regs
END SUB

SUB neoLFNremoveDir (DirName AS STRING)
	'removes a directory
	'- DirName: the name of the directory to remove

	'use int 21h, ax=713A
	DIM Regs AS RegTypeX
	Regs.ax = &H713A
	DirNameZ$ = DirName + CHR$(0)
	Regs.ds = VARSEG(DirNameZ$)
	Regs.dx = SADD(DirNameZ$)
	INTERRUPTX &H21, Regs, Regs
END SUB

SUB neoLFNchangeDir (DirName AS STRING)
	'changes to a directory (CHDIR)
	'- DirName: the directory name to change to

	'use int 21h, ax=713B
	DIM Regs AS RegTypeX
        Regs.ax = &H713B
        DirNameZ$ = DirName + CHR$(0)
        Regs.ds = VARSEG(DirNameZ$)
        Regs.dx = SADD(DirNameZ$)
        INTERRUPTX &H21, Regs, Regs
END SUB

SUB neoLFNrenameDir (DirName AS STRING, NewDirName AS STRING)
	'renames a directory
	'- DirName: directory to change
	'- NewDirName: new name of the directory

	neoLFNrenameFile DirName, NewDirName
END SUB

SUB neoLFNdeleteFile (FileName AS STRING)
	'deletes a file
	'- FileName: filename of the file to delete

	'use int 21h, ax=7141
        DIM Regs AS RegTypeX
        Regs.ax = &H7141
        Regs.si = 0
        FileNameZ$ = FileName + CHR$(0)
        Regs.ds = VARSEG(FileNameZ$)
        Regs.dx = SADD(FileNameZ$)
        INTERRUPTX &H21, Regs, Regs
END SUB

SUB neoLFNrenameFile (FileName AS STRING, NewFileName AS STRING)
	'renames a file
	'- FileName: file to change
	'- NewFileName: new name of the file

	'use int 21h, ax=7156
        DIM Regs AS RegTypeX
        Regs.ax = &H7156
        FileNameZ$ = FileName + CHR$(0)
        Regs.ds = VARSEG(FileNameZ$)
        Regs.dx = SADD(FileNameZ$)
        NewFileNameZ$ = NewFileName + CHR$(0)
        Regs.es = VARSEG(NewFileNameZ$)
        Regs.di = SADD(NewFileNameZ$)
        INTERRUPTX &H21, Regs, Regs
END SUB
