.model medium, basic
.stack 32
.386
.data
   DTAsegment dw ?
   DTAoffset dw ?
.code

public VSFileMatch
public VSFileMatchInit
public VSLoad
public VSLoadPut

;===================The following is the source for Dash=====================
;==========================by 1998-2000 VirtuaSoft===========================

;=======This loads data from a file==========================================
vsload proc
      push bp
      push ds
      mov bp, sp

      mov ds, [bp+18]                 ;get segment of file name string
      mov ax, 3d00h                   ;open for read
      mov dx, [bp+16]                 ;get offset of file name string
      int 21h                         ;do it
      jnc noloaderror                 ;skip if there's no error

      mov ax, 1                       ;error 1 = bad file
      jmp endloadsub
   noloaderror:
      mov ecx, [bp+8]                 ;read nBytes
      cmp ecx, 65535                  ;set max bytes to 65536
      jng lessthan
      mov cx, 65535
   lessthan:
      mov bx, ax                      ;store file handle
      mov ds, [bp+14]                 ;get write segment
      mov ah, 3fh
      mov dx, [bp+12]                 ;get write offset
      int 21h

      mov ah, 3eh                     ;close file
      int 21h
      xor ax, ax                      ;no error = 0

   endloadsub:
      pop ds
      pop bp
      ret 12
vsload endp

;=======This PUTs an image from a BSAVE file=================================
VSLoadPut proc
      push bp
      push ds
      push ebx
      push ebx
      mov bp, sp

      mov ds, [bp+26]                 ;get segment of file name string
      mov ax, 3d00h                   ;open for read
      mov dx, [bp+24]                 ;get offset of file name string
      int 21h                         ;do it
      jnc noloadputerror              ;skip if there's no error

      mov ax, 1                       ;error 1 = bad file
      jmp endloadputsub
   noloadputerror:
      mov bx, ax                      ;store file handle

      mov ax, ss
      mov cx, 7
      mov ds, ax                      ;get write segment
      mov ah, 3fh
      mov dx, bp                      ;get write offset
      int 21h

      cmp byte ptr [bp], 0fdh
      jz isbload

      mov ah, 3eh                     ;close file
      int 21h
      mov ax, 2
   isbload:
      mov cx, 4                       ;get sprite data
      mov ah, 3fh
      int 21h

      shr word ptr [bp], 3
      xor si, si                      ;tempy

      xor dl, dl
      mov ds, [bp+18]                 ;set scrn segment
      mov ax, [bp+20]                 ;y
      mov dh, al
      shl ax, 6
      add dx, ax
      add dx, [bp+16]                 ;scrn offset
      add dx, [bp+22]                 ;x

   nextline:
      mov cx, [bp]
      mov ah, 3fh
      int 21h

      inc si
      add dx, 320
      cmp si, [bp+2]
      js nextline

      mov ah, 3eh                     ;close file
      int 21h
      xor ax, ax                      ;no error = 0

   endloadputsub:
      pop ebx
      pop ebx
      pop ds
      pop bp
      ret 12
VSLoadPut endp

;=======This returns the 1st file match in a directory=======================
VSFileMatchInit proc
      mov di, bp
      mov si, ds
      mov bp, sp

      mov ah, 2fh                     ;Get and store address of DTA.
      int 21h
      mov DTAsegment, es
      mov DTAoffset, bx

      mov ah, 1ah                     ;Update DTA w/ QB one.
      mov ds, [bp+10]
      mov dx, [bp+8]
      int 21h

      mov ah, 4eh
      xor cx, cx
      mov ds, [bp+6]
      mov dx, [bp+4]
      int 21h
      jnc endfilecheckinit

      mov ah, 1ah
      mov ds, DTAsegment
      mov dx, DTAoffset
      int 21h
      xor ax, ax                      ;File match found
      mov bp, di
      mov ds, si
      ret 8
        
   endfilecheckinit:
      mov ax, 1
      mov bp, di
      mov ds, si
      ret 8
VSFileMatchInit endp

;=======This returns more file matches in directory==========================
VSFileMatch proc
      mov di, bp
      mov si, ds
      mov bp, sp

      mov cx, 1
      mov ah, 4fh                     ;Get and store address of DTA.
      int 21h
      jnc endfilecheck

      mov ah, 1ah                     ;No file match found
      mov ds, DTAsegment
      mov dx, DTAoffset
      int 21h
      xor ax, ax 
      mov ds, si
      mov bp, di
      ret

   endfilecheck:
      mov ax, 1
      mov ds, si
      mov bp, di
      ret
VSFileMatch endp

end
